

CREATE TABLE `_sequence` (
  `seq_name` varchar(50) NOT NULL,
  `seq_group` varchar(10) NOT NULL,
  `seq_val` int unsigned NOT NULL,
  PRIMARY KEY (`seq_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO _sequence VALUES("seq_1","164600000","732");



CREATE TABLE `activations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO activations VALUES("1","1","zSs29O0nTa31e38ItVIVzkWar5RY7ImQ","1","2021-01-14 09:30:54","2021-01-14 09:30:54","2021-01-14 09:30:54");
INSERT INTO activations VALUES("2","2","IaEGd0BeelPr92oJtKXnRZhCT2A50MFN","1","2021-01-15 14:01:54","2021-01-15 14:01:54","2021-01-15 14:01:54");
INSERT INTO activations VALUES("6","6","WzIbfyfqccurlx850wRWANnlBE3TnQ7K","1","2021-12-02 06:46:29","2021-12-02 06:46:29","2021-12-02 06:46:29");
INSERT INTO activations VALUES("7","7","97oWrn34woF2PiwvV8j3HUIf2rD1Hz9o","1","2022-06-20 10:34:43","2022-06-20 10:34:43","2022-06-20 10:34:43");
INSERT INTO activations VALUES("8","8","7PQ6poLLsongfH9AqdnCOTXGyVl5HtpB","1","2023-11-17 10:20:37","2023-11-17 10:20:37","2023-11-17 10:20:37");
INSERT INTO activations VALUES("9","9","gpVBlz5IUNrpZtqmgoSoVFH79nPZX0yA","1","2024-05-21 08:21:37","2024-05-21 08:21:37","2024-05-21 08:21:37");
INSERT INTO activations VALUES("10","10","rEHz3nSAGlQrD3zo2Yu92ZLwN8IgnuFD","1","2024-06-26 06:10:39","2024-06-26 06:10:39","2024-06-26 06:10:39");
INSERT INTO activations VALUES("11","11","7AtoaKoWsIxrUf0laRSqMClEfG1FTzIn","1","2024-06-26 07:12:38","2024-06-26 07:12:38","2024-06-26 07:12:38");



CREATE TABLE `asset_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `type` enum('current','fixed','intangible','investment','other') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO asset_types VALUES("1","OFFICE FURNITURE AND FITTINGS","current");
INSERT INTO asset_types VALUES("2","COMPUTER  AND ACCESSORIES","current");
INSERT INTO asset_types VALUES("3","MURANGA INVESTMENT CO-OP SOCIETY","investment");
INSERT INTO asset_types VALUES("4","UNAITAS SHARES ","investment");
INSERT INTO asset_types VALUES("5","MENTOR SACCO ORDINARY SHARES","investment");
INSERT INTO asset_types VALUES("6","MENTOR SACCO(S.ODEPOSITS)","investment");
INSERT INTO asset_types VALUES("7","LOAN ADVANCED TO MEMBERS","current");
INSERT INTO asset_types VALUES("8","PREPAYMENT","current");
INSERT INTO asset_types VALUES("9","DEBTOR ACCOUNT","current");



CREATE TABLE `asset_valuations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `asset_id` int DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(65,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;




CREATE TABLE `assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `asset_type_id` int DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_price` decimal(65,4) DEFAULT NULL,
  `replacement_value` decimal(65,4) DEFAULT NULL,
  `serial_number` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `bought_from` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `notes` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `files` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `branch_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_id_index` (`id`),
  KEY `assets_purchase_date_index` (`purchase_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;




CREATE TABLE `audit_trail` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `user` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `module` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `notes` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `branch_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_trail_id_index` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17518 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO audit_trail VALUES("1","1","Admin Admin","","Logged in to system","2021-01-14 09:31:20","2021-01-14 09:31:20","");
INSERT INTO audit_trail VALUES("2","1","Admin Admin","","Updated Settings","2021-01-14 09:32:22","2021-01-14 09:32:22","1");
INSERT INTO audit_trail VALUES("3","1","Admin Admin","","Updated user with id:1","2021-01-14 09:33:02","2021-01-14 09:33:02","1");
INSERT INTO audit_trail VALUES("4","1","Admin Admin","","Logged in to system","2021-01-14 10:01:25","2021-01-14 10:01:25","");
INSERT INTO audit_trail VALUES("5","1","Admin Admin","","Logged out of system","2021-01-14 10:05:58","2021-01-14 10:05:58","1");
INSERT INTO audit_trail VALUES("6","1","Admin Admin","","Logged in to system","2021-01-14 10:06:39","2021-01-14 10:06:39","1");
INSERT INTO audit_trail VALUES("7","1","Admin Admin","","Logged in to system","2021-01-14 10:47:40","2021-01-14 10:47:40","1");
INSERT INTO audit_trail VALUES("8","1","Admin Admin","","Updated Settings","2021-01-14 11:39:45","2021-01-14 11:39:45","1");
INSERT INTO audit_trail VALUES("9","1","Admin Admin","","Updated Settings","2021-01-14 11:40:29","2021-01-14 11:40:29","1");
INSERT INTO audit_trail VALUES("10","1","Admin Admin","","Updated Settings","2021-01-14 11:40:53","2021-01-14 11:40:53","1");
INSERT INTO audit_trail VALUES("11","1","Admin Admin","","Updated Settings","2021-01-14 11:41:36","2021-01-14 11:41:36","1");
INSERT INTO audit_trail VALUES("12","1","Admin Admin","","Logged out of system","2021-01-14 11:41:44","2021-01-14 11:41:44","1");
INSERT INTO audit_trail VALUES("13","1","Admin Admin","","Logged in to system","2021-01-15 09:07:34","2021-01-15 09:07:34","");
INSERT INTO audit_trail VALUES("14","1","Admin Admin","","Logged in to system","2021-01-15 09:21:13","2021-01-15 09:21:13","");
INSERT INTO audit_trail VALUES("15","1","Admin Admin","","Logged in to system","2021-01-15 09:45:20","2021-01-15 09:45:20","");
INSERT INTO audit_trail VALUES("16","1","Admin Admin","","Logged out of system","2021-01-15 11:16:39","2021-01-15 11:16:39","1");
INSERT INTO audit_trail VALUES("17","1","Admin Admin","","Logged in to system","2021-01-15 11:40:14","2021-01-15 11:40:14","1");
INSERT INTO audit_trail VALUES("18","1","Admin Admin","","Added Journal Manual Entry  with id:2","2021-01-15 11:52:46","2021-01-15 11:52:46","1");
INSERT INTO audit_trail VALUES("19","1","Admin Admin","","Added Journal Manual Entry  with id:4","2021-01-15 11:58:39","2021-01-15 11:58:39","1");
INSERT INTO audit_trail VALUES("20","1","Admin Admin","","Logged in to system","2021-01-15 12:00:51","2021-01-15 12:00:51","1");
INSERT INTO audit_trail VALUES("21","1","Admin Admin","","Logged in to system","2021-01-15 12:33:48","2021-01-15 12:33:48","");
INSERT INTO audit_trail VALUES("22","1","Admin Admin","","Logged out of system","2021-01-15 12:38:11","2021-01-15 12:38:11","1");
INSERT INTO audit_trail VALUES("23","1","Admin Admin","","Logged in to system","2021-01-15 12:38:23","2021-01-15 12:38:23","1");
INSERT INTO audit_trail VALUES("24","1","Admin Admin","","Logged in to system","2021-01-15 12:49:04","2021-01-15 12:49:04","1");
INSERT INTO audit_trail VALUES("25","1","Admin Admin","","Logged in to system","2021-01-15 12:49:22","2021-01-15 12:49:22","");
INSERT INTO audit_trail VALUES("26","1","Admin Admin","","Added loan product with id:1","2021-01-15 13:10:05","2021-01-15 13:10:05","1");
INSERT INTO audit_trail VALUES("27","1","Admin Admin","","Added loan product with id:2","2021-01-15 13:17:26","2021-01-15 13:17:26","1");
INSERT INTO audit_trail VALUES("28","1","Admin Admin","","Added loan product with id:3","2021-01-15 13:23:19","2021-01-15 13:23:19","1");
INSERT INTO audit_trail VALUES("29","1","Admin Admin","","Added loan product with id:4","2021-01-15 13:26:08","2021-01-15 13:26:08","1");
INSERT INTO audit_trail VALUES("30","1","Admin Admin","","Added role with id:2","2021-01-15 13:40:15","2021-01-15 13:40:15","1");
INSERT INTO audit_trail VALUES("31","1","Admin Admin","","Added role with id:3","2021-01-15 13:47:18","2021-01-15 13:47:18","1");
INSERT INTO audit_trail VALUES("32","1","Admin Admin","","Added role with id:4","2021-01-15 14:01:47","2021-01-15 14:01:47","1");
INSERT INTO audit_trail VALUES("33","1","Admin Admin","","Added user with id:2","2021-01-15 14:01:54","2021-01-15 14:01:54","1");
INSERT INTO audit_trail VALUES("34","1","Admin Admin","","Added user with id:3","2021-01-15 14:04:02","2021-01-15 14:04:02","1");
INSERT INTO audit_trail VALUES("35","1","Admin Admin","","Updated user with id:3","2021-01-15 14:05:15","2021-01-15 14:05:15","1");
INSERT INTO audit_trail VALUES("36","1","Admin Admin","","Logged out of system","2021-01-15 14:05:26","2021-01-15 14:05:26","1");
INSERT INTO audit_trail VALUES("37","1","Admin Admin","","Logged in to system","2021-01-16 16:49:14","2021-01-16 16:49:14","");
INSERT INTO audit_trail VALUES("38","1","Admin Admin","","Logged in to system","2021-01-18 02:35:53","2021-01-18 02:35:53","");
INSERT INTO audit_trail VALUES("39","1","Admin Admin","","Added borrower  with id:1","2021-01-18 03:02:19","2021-01-18 03:02:19","1");
INSERT INTO audit_trail VALUES("40","1","Admin Admin","","Updated Settings","2021-01-18 03:57:41","2021-01-18 03:57:41","1");
INSERT INTO audit_trail VALUES("41","1","Admin Admin","","Updated Settings","2021-01-18 03:59:33","2021-01-18 03:59:33","1");
INSERT INTO audit_trail VALUES("42","1","Admin Admin","","Logged in to system","2021-01-18 06:11:44","2021-01-18 06:11:44","");
INSERT INTO audit_trail VALUES("43","1","Admin Admin","","Added Journal Manual Entry  with id:8","2021-01-18 06:56:00","2021-01-18 06:56:00","1");
INSERT INTO audit_trail VALUES("44","1","Admin Admin","","Added Journal Manual Entry  with id:10","2021-01-18 07:08:23","2021-01-18 07:08:23","1");
INSERT INTO audit_trail VALUES("45","1","Admin Admin","","Added Journal Manual Entry  with id:12","2021-01-18 07:09:39","2021-01-18 07:09:39","1");
INSERT INTO audit_trail VALUES("46","1","Admin Admin","","Added Journal Manual Entry  with id:14","2021-01-18 07:10:43","2021-01-18 07:10:43","1");
INSERT INTO audit_trail VALUES("47","1","Admin Admin","","Added Journal Manual Entry  with id:16","2021-01-18 07:18:43","2021-01-18 07:18:43","1");
INSERT INTO audit_trail VALUES("48","1","Admin Admin","","Added Journal Manual Entry  with id:18","2021-01-18 07:22:07","2021-01-18 07:22:07","1");
INSERT INTO audit_trail VALUES("49","1","Admin Admin","","Added Journal Manual Entry  with id:20","2021-01-18 07:27:16","2021-01-18 07:27:16","1");
INSERT INTO audit_trail VALUES("50","1","Admin Admin","","Added Journal Manual Entry  with id:22","2021-01-18 07:40:09","2021-01-18 07:40:09","1");
INSERT INTO audit_trail VALUES("51","1","Admin Admin","","Added Journal Manual Entry  with id:24","2021-01-18 07:48:02","2021-01-18 07:48:02","1");
INSERT INTO audit_trail VALUES("52","1","Admin Admin","","Added Journal Manual Entry  with id:26","2021-01-18 07:51:13","2021-01-18 07:51:13","1");
INSERT INTO audit_trail VALUES("53","1","Admin Admin","","Added Journal Manual Entry  with id:28","2021-01-18 07:54:02","2021-01-18 07:54:02","1");
INSERT INTO audit_trail VALUES("54","1","Admin Admin","","Logged out of system","2021-01-18 07:54:42","2021-01-18 07:54:42","1");
INSERT INTO audit_trail VALUES("55","1","Admin Admin","","Logged in to system","2021-01-18 08:25:56","2021-01-18 08:25:56","1");
INSERT INTO audit_trail VALUES("56","1","Admin Admin","","Logged in to system","2021-01-18 08:29:22","2021-01-18 08:29:22","1");
INSERT INTO audit_trail VALUES("57","1","Admin Admin","","Added Journal Manual Entry  with id:30","2021-01-18 08:29:53","2021-01-18 08:29:53","1");
INSERT INTO audit_trail VALUES("58","1","Admin Admin","","Added Journal Manual Entry  with id:32","2021-01-18 08:32:28","2021-01-18 08:32:28","1");
INSERT INTO audit_trail VALUES("59","1","Admin Admin","","Added Journal Manual Entry  with id:34","2021-01-18 08:35:27","2021-01-18 08:35:27","1");
INSERT INTO audit_trail VALUES("60","1","Admin Admin","","Added Journal Manual Entry  with id:36","2021-01-18 08:40:56","2021-01-18 08:40:56","1");
INSERT INTO audit_trail VALUES("61","1","Admin Admin","","Added Journal Manual Entry  with id:38","2021-01-18 08:42:50","2021-01-18 08:42:50","1");
INSERT INTO audit_trail VALUES("62","1","Admin Admin","","Added Journal Manual Entry  with id:40","2021-01-18 08:45:14","2021-01-18 08:45:14","1");
INSERT INTO audit_trail VALUES("63","1","Admin Admin","","Added Journal Manual Entry  with id:42","2021-01-18 08:46:58","2021-01-18 08:46:58","1");
INSERT INTO audit_trail VALUES("64","1","Admin Admin","","Added Journal Manual Entry  with id:44","2021-01-18 08:48:16","2021-01-18 08:48:16","1");
INSERT INTO audit_trail VALUES("65","1","Admin Admin","","Added Journal Manual Entry  with id:46","2021-01-18 08:51:10","2021-01-18 08:51:10","1");
INSERT INTO audit_trail VALUES("66","1","Admin Admin","","Added Journal Manual Entry  with id:48","2021-01-18 08:53:25","2021-01-18 08:53:25","1");
INSERT INTO audit_trail VALUES("67","1","Admin Admin","","Added Journal Manual Entry  with id:50","2021-01-18 08:54:35","2021-01-18 08:54:35","1");
INSERT INTO audit_trail VALUES("68","1","Admin Admin","","Added Journal Manual Entry  with id:52","2021-01-18 09:03:10","2021-01-18 09:03:10","1");
INSERT INTO audit_trail VALUES("69","1","Admin Admin","","Added Journal Manual Entry  with id:54","2021-01-18 09:08:18","2021-01-18 09:08:18","1");
INSERT INTO audit_trail VALUES("70","1","Admin Admin","","Added Journal Manual Entry  with id:56","2021-01-18 09:15:22","2021-01-18 09:15:22","1");
INSERT INTO audit_trail VALUES("71","1","Admin Admin","","Added Journal Manual Entry  with id:58","2021-01-18 09:21:08","2021-01-18 09:21:08","1");
INSERT INTO audit_trail VALUES("72","1","Admin Admin","","Added Journal Manual Entry  with id:60","2021-01-18 09:22:35","2021-01-18 09:22:35","1");
INSERT INTO audit_trail VALUES("73","1","Admin Admin","","Added Journal Manual Entry  with id:62","2021-01-18 09:23:57","2021-01-18 09:23:57","1");
INSERT INTO audit_trail VALUES("74","1","Admin Admin","","Added user with id:4","2021-01-18 09:54:16","2021-01-18 09:54:16","1");
INSERT INTO audit_trail VALUES("75","1","Admin Admin","","Updated user with id:4","2021-01-18 09:59:23","2021-01-18 09:59:23","1");
INSERT INTO audit_trail VALUES("76","1","Admin Admin","","Added Journal Manual Entry  with id:64","2021-01-18 11:20:43","2021-01-18 11:20:43","1");
INSERT INTO audit_trail VALUES("77","1","Admin Admin","","Logged in to system","2021-01-18 11:21:27","2021-01-18 11:21:27","");
INSERT INTO audit_trail VALUES("78","1","Admin Admin","","Added Journal Manual Entry  with id:66","2021-01-18 11:39:33","2021-01-18 11:39:33","1");
INSERT INTO audit_trail VALUES("79","1","Admin Admin","","Updated borrower  with id:1","2021-01-18 12:04:54","2021-01-18 12:04:54","1");
INSERT INTO audit_trail VALUES("80","1","Admin Admin","","Updated borrower  with id:1","2021-01-18 12:10:09","2021-01-18 12:10:09","1");
INSERT INTO audit_trail VALUES("81","1","Admin Admin","","Sent email to borrower ","2021-01-18 12:13:27","2021-01-18 12:13:27","1");
INSERT INTO audit_trail VALUES("82","1","Admin Admin","","Logged out of system","2021-01-18 12:29:09","2021-01-18 12:29:09","1");
INSERT INTO audit_trail VALUES("83","1","Admin Admin","","Logged in to system","2021-01-19 06:24:25","2021-01-19 06:24:25","1");
INSERT INTO audit_trail VALUES("84","1","Admin Admin","","Logged in to system","2021-01-19 08:58:29","2021-01-19 08:58:29","");
INSERT INTO audit_trail VALUES("85","1","Admin Admin","","Logged in to system","2021-01-19 09:01:36","2021-01-19 09:01:36","");
INSERT INTO audit_trail VALUES("86","1","Admin Admin","","Added Journal Manual Entry  with id:68","2021-01-19 10:13:29","2021-01-19 10:13:29","1");
INSERT INTO audit_trail VALUES("87","1","Admin Admin","","Added Journal Manual Entry  with id:70","2021-01-19 10:14:37","2021-01-19 10:14:37","1");
INSERT INTO audit_trail VALUES("88","1","Admin Admin","","Added Journal Manual Entry  with id:72","2021-01-19 10:15:52","2021-01-19 10:15:52","1");
INSERT INTO audit_trail VALUES("89","1","Admin Admin","","Added Journal Manual Entry  with id:74","2021-01-19 10:16:58","2021-01-19 10:16:58","1");
INSERT INTO audit_trail VALUES("90","1","Admin Admin","","Added Journal Manual Entry  with id:76","2021-01-19 10:18:21","2021-01-19 10:18:21","1");
INSERT INTO audit_trail VALUES("91","1","Admin Admin","","Added Journal Manual Entry  with id:78","2021-01-19 10:19:19","2021-01-19 10:19:19","1");
INSERT INTO audit_trail VALUES("92","1","Admin Admin","","Added Journal Manual Entry  with id:80","2021-01-19 10:25:40","2021-01-19 10:25:40","1");
INSERT INTO audit_trail VALUES("93","1","Admin Admin","","Logged out of system","2021-01-19 10:27:45","2021-01-19 10:27:45","1");
INSERT INTO audit_trail VALUES("94","1","Admin Admin","","Logged in to system","2021-01-19 10:29:05","2021-01-19 10:29:05","1");
INSERT INTO audit_trail VALUES("95","1","Admin Admin","","Logged in to system","2021-01-19 10:29:18","2021-01-19 10:29:18","1");
INSERT INTO audit_trail VALUES("96","1","Admin Admin","","Logged in to system","2021-01-19 10:30:47","2021-01-19 10:30:47","1");
INSERT INTO audit_trail VALUES("97","1","Admin Admin","","Added Journal Manual Entry  with id:82","2021-01-19 10:38:10","2021-01-19 10:38:10","1");
INSERT INTO audit_trail VALUES("98","1","Admin Admin","","Added Journal Manual Entry  with id:84","2021-01-19 10:39:32","2021-01-19 10:39:32","1");
INSERT INTO audit_trail VALUES("99","1","Admin Admin","","Added Journal Manual Entry  with id:86","2021-01-19 10:49:16","2021-01-19 10:49:16","1");
INSERT INTO audit_trail VALUES("100","1","Admin Admin","","Added Journal Manual Entry  with id:88","2021-01-19 10:52:24","2021-01-19 10:52:24","1");
INSERT INTO audit_trail VALUES("101","1","Admin Admin","","Added Journal Manual Entry  with id:90","2021-01-19 11:16:40","2021-01-19 11:16:40","1");
INSERT INTO audit_trail VALUES("102","1","Admin Admin","","Added Journal Manual Entry  with id:92","2021-01-19 11:32:31","2021-01-19 11:32:31","1");
INSERT INTO audit_trail VALUES("103","1","Admin Admin","","Added Journal Manual Entry  with id:94","2021-01-19 11:34:06","2021-01-19 11:34:06","1");
INSERT INTO audit_trail VALUES("104","1","Admin Admin","","Added Journal Manual Entry  with id:96","2021-01-19 11:50:37","2021-01-19 11:50:37","1");
INSERT INTO audit_trail VALUES("105","1","Admin Admin","","Added Journal Manual Entry  with id:98","2021-01-19 11:52:34","2021-01-19 11:52:34","1");
INSERT INTO audit_trail VALUES("106","1","Admin Admin","","Added Journal Manual Entry  with id:100","2021-01-19 11:54:40","2021-01-19 11:54:40","1");
INSERT INTO audit_trail VALUES("107","1","Admin Admin","","Added Journal Manual Entry  with id:102","2021-01-19 11:57:50","2021-01-19 11:57:50","1");
INSERT INTO audit_trail VALUES("108","1","Admin Admin","","Added Journal Manual Entry  with id:104","2021-01-19 12:02:06","2021-01-19 12:02:06","1");
INSERT INTO audit_trail VALUES("109","1","Admin Admin","","Added Journal Manual Entry  with id:106","2021-01-19 12:04:19","2021-01-19 12:04:19","1");
INSERT INTO audit_trail VALUES("110","1","Admin Admin","","Added Journal Manual Entry  with id:112","2021-01-19 12:13:00","2021-01-19 12:13:00","1");
INSERT INTO audit_trail VALUES("111","1","Admin Admin","","Added Journal Manual Entry  with id:114","2021-01-19 12:16:26","2021-01-19 12:16:26","1");
INSERT INTO audit_trail VALUES("112","1","Admin Admin","","Logged out of system","2021-01-19 12:18:48","2021-01-19 12:18:48","1");
INSERT INTO audit_trail VALUES("113","1","Admin Admin","","Logged in to system","2021-01-19 12:18:52","2021-01-19 12:18:52","1");
INSERT INTO audit_trail VALUES("114","1","Admin Admin","","Logged in to system","2021-01-19 12:19:00","2021-01-19 12:19:00","1");
INSERT INTO audit_trail VALUES("115","1","Admin Admin","","Logged in to system","2021-01-19 12:19:49","2021-01-19 12:19:49","1");
INSERT INTO audit_trail VALUES("116","1","Admin Admin","","Added Journal Manual Entry  with id:124","2021-01-19 12:26:27","2021-01-19 12:26:27","1");
INSERT INTO audit_trail VALUES("117","1","Admin Admin","","Added Journal Manual Entry  with id:128","2021-01-19 12:27:49","2021-01-19 12:27:49","1");
INSERT INTO audit_trail VALUES("118","1","Admin Admin","","Added Journal Manual Entry  with id:154","2021-01-19 12:52:18","2021-01-19 12:52:18","1");
INSERT INTO audit_trail VALUES("119","1","Admin Admin","","Logged in to system","2021-01-20 10:36:00","2021-01-20 10:36:00","");
INSERT INTO audit_trail VALUES("120","1","Admin Admin","","Logged in to system","2021-01-21 07:24:13","2021-01-21 07:24:13","");
INSERT INTO audit_trail VALUES("121","1","Admin Admin","","Logged in to system","2021-01-21 07:25:40","2021-01-21 07:25:40","");
INSERT INTO audit_trail VALUES("122","1","Admin Admin","","Logged in to system","2021-01-21 07:32:14","2021-01-21 07:32:14","1");
INSERT INTO audit_trail VALUES("123","1","Admin Admin","","Added Journal Manual Entry  with id:156","2021-01-21 07:42:37","2021-01-21 07:42:37","1");
INSERT INTO audit_trail VALUES("124","1","Admin Admin","","Added Journal Manual Entry  with id:158","2021-01-21 07:44:38","2021-01-21 07:44:38","1");
INSERT INTO audit_trail VALUES("125","1","Admin Admin","","Added Journal Manual Entry  with id:160","2021-01-21 07:48:25","2021-01-21 07:48:25","1");
INSERT INTO audit_trail VALUES("126","1","Admin Admin","","Added Journal Manual Entry  with id:162","2021-01-21 07:49:43","2021-01-21 07:49:43","1");
INSERT INTO audit_trail VALUES("127","1","Admin Admin","","Added Journal Manual Entry  with id:164","2021-01-21 07:51:34","2021-01-21 07:51:34","1");
INSERT INTO audit_trail VALUES("128","1","Admin Admin","","Added Journal Manual Entry  with id:166","2021-01-21 07:52:40","2021-01-21 07:52:40","1");
INSERT INTO audit_trail VALUES("129","1","Admin Admin","","Added Journal Manual Entry  with id:168","2021-01-21 07:54:05","2021-01-21 07:54:05","1");
INSERT INTO audit_trail VALUES("130","1","Admin Admin","","Added Journal Manual Entry  with id:170","2021-01-21 07:54:21","2021-01-21 07:54:21","1");
INSERT INTO audit_trail VALUES("131","1","Admin Admin","","Added Journal Manual Entry  with id:172","2021-01-21 07:55:36","2021-01-21 07:55:36","1");
INSERT INTO audit_trail VALUES("132","1","Admin Admin","","Added Journal Manual Entry  with id:174","2021-01-21 07:57:18","2021-01-21 07:57:18","1");
INSERT INTO audit_trail VALUES("133","1","Admin Admin","","Added Journal Manual Entry  with id:176","2021-01-21 07:59:08","2021-01-21 07:59:08","1");
INSERT INTO audit_trail VALUES("134","1","Admin Admin","","Added Journal Manual Entry  with id:178","2021-01-21 08:00:17","2021-01-21 08:00:17","1");
INSERT INTO audit_trail VALUES("135","1","Admin Admin","","Added Journal Manual Entry  with id:180","2021-01-21 08:02:31","2021-01-21 08:02:31","1");
INSERT INTO audit_trail VALUES("136","1","Admin Admin","","Added Journal Manual Entry  with id:182","2021-01-21 08:02:33","2021-01-21 08:02:33","1");
INSERT INTO audit_trail VALUES("137","1","Admin Admin","","Added Journal Manual Entry  with id:184","2021-01-21 08:03:55","2021-01-21 08:03:55","1");
INSERT INTO audit_trail VALUES("138","1","Admin Admin","","Added Journal Manual Entry  with id:186","2021-01-21 08:05:37","2021-01-21 08:05:37","1");
INSERT INTO audit_trail VALUES("139","1","Admin Admin","","Added Journal Manual Entry  with id:188","2021-01-21 08:05:48","2021-01-21 08:05:48","1");
INSERT INTO audit_trail VALUES("140","1","Admin Admin","","Added Journal Manual Entry  with id:190","2021-01-21 08:07:33","2021-01-21 08:07:33","1");
INSERT INTO audit_trail VALUES("141","1","Admin Admin","","Added Journal Manual Entry  with id:192","2021-01-21 08:08:56","2021-01-21 08:08:56","1");
INSERT INTO audit_trail VALUES("142","1","Admin Admin","","Added Journal Manual Entry  with id:194","2021-01-21 08:10:07","2021-01-21 08:10:07","1");
INSERT INTO audit_trail VALUES("143","1","Admin Admin","","Added Journal Manual Entry  with id:196","2021-01-21 08:11:14","2021-01-21 08:11:14","1");
INSERT INTO audit_trail VALUES("144","1","Admin Admin","","Added Journal Manual Entry  with id:198","2021-01-21 08:11:24","2021-01-21 08:11:24","1");
INSERT INTO audit_trail VALUES("145","1","Admin Admin","","Added Journal Manual Entry  with id:200","2021-01-21 08:12:34","2021-01-21 08:12:34","1");
INSERT INTO audit_trail VALUES("146","1","Admin Admin","","Added Journal Manual Entry  with id:202","2021-01-21 08:12:36","2021-01-21 08:12:36","1");
INSERT INTO audit_trail VALUES("147","1","Admin Admin","","Added Journal Manual Entry  with id:204","2021-01-21 08:14:22","2021-01-21 08:14:22","1");
INSERT INTO audit_trail VALUES("148","1","Admin Admin","","Added Journal Manual Entry  with id:206","2021-01-21 08:14:38","2021-01-21 08:14:38","1");
INSERT INTO audit_trail VALUES("149","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-21 08:15:15","2021-01-21 08:15:15","");
INSERT INTO audit_trail VALUES("150","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-21 08:15:17","2021-01-21 08:15:17","");
INSERT INTO audit_trail VALUES("151","1","Admin Admin","","Added Journal Manual Entry  with id:208","2021-01-21 08:15:48","2021-01-21 08:15:48","1");
INSERT INTO audit_trail VALUES("152","1","Admin Admin","","Added Journal Manual Entry  with id:210","2021-01-21 08:16:03","2021-01-21 08:16:03","1");
INSERT INTO audit_trail VALUES("153","1","Admin Admin","","Added Journal Manual Entry  with id:212","2021-01-21 08:17:11","2021-01-21 08:17:11","1");
INSERT INTO audit_trail VALUES("154","1","Admin Admin","","Added Journal Manual Entry  with id:214","2021-01-21 08:21:11","2021-01-21 08:21:11","1");
INSERT INTO audit_trail VALUES("155","1","Admin Admin","","Added Journal Manual Entry  with id:216","2021-01-21 08:22:18","2021-01-21 08:22:18","1");
INSERT INTO audit_trail VALUES("156","1","Admin Admin","","Added Journal Manual Entry  with id:218","2021-01-21 08:23:37","2021-01-21 08:23:37","1");
INSERT INTO audit_trail VALUES("157","1","Admin Admin","","Added Journal Manual Entry  with id:220","2021-01-21 08:24:33","2021-01-21 08:24:33","1");
INSERT INTO audit_trail VALUES("158","1","Admin Admin","","Added Journal Manual Entry  with id:222","2021-01-21 08:27:17","2021-01-21 08:27:17","1");
INSERT INTO audit_trail VALUES("159","1","Admin Admin","","Added Journal Manual Entry  with id:224","2021-01-21 08:28:56","2021-01-21 08:28:56","1");
INSERT INTO audit_trail VALUES("160","1","Admin Admin","","Added Journal Manual Entry  with id:226","2021-01-21 08:30:32","2021-01-21 08:30:32","1");
INSERT INTO audit_trail VALUES("161","1","Admin Admin","","Added Journal Manual Entry  with id:228","2021-01-21 08:31:48","2021-01-21 08:31:48","1");
INSERT INTO audit_trail VALUES("162","1","Admin Admin","","Added Journal Manual Entry  with id:230","2021-01-21 08:32:57","2021-01-21 08:32:57","1");
INSERT INTO audit_trail VALUES("163","1","Admin Admin","","Added Journal Manual Entry  with id:232","2021-01-21 08:34:25","2021-01-21 08:34:25","1");
INSERT INTO audit_trail VALUES("164","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:613","2021-01-21 08:35:04","2021-01-21 08:35:04","1");
INSERT INTO audit_trail VALUES("165","1","Admin Admin","","Added Journal Manual Entry  with id:234","2021-01-21 08:35:55","2021-01-21 08:35:55","1");
INSERT INTO audit_trail VALUES("166","1","Admin Admin","","Added Journal Manual Entry  with id:236","2021-01-21 08:37:15","2021-01-21 08:37:15","1");
INSERT INTO audit_trail VALUES("167","1","Admin Admin","","Added Journal Manual Entry  with id:238","2021-01-21 08:43:26","2021-01-21 08:43:26","1");
INSERT INTO audit_trail VALUES("168","1","Admin Admin","","Added Journal Manual Entry  with id:240","2021-01-21 08:44:42","2021-01-21 08:44:42","1");
INSERT INTO audit_trail VALUES("169","1","Admin Admin","","Added Journal Manual Entry  with id:242","2021-01-21 08:46:12","2021-01-21 08:46:12","1");
INSERT INTO audit_trail VALUES("170","1","Admin Admin","","Added Journal Manual Entry  with id:244","2021-01-21 08:46:50","2021-01-21 08:46:50","1");
INSERT INTO audit_trail VALUES("171","1","Admin Admin","","Added Journal Manual Entry  with id:246","2021-01-21 08:47:59","2021-01-21 08:47:59","1");
INSERT INTO audit_trail VALUES("172","1","Admin Admin","","Added Journal Manual Entry  with id:250","2021-01-21 08:52:58","2021-01-21 08:52:58","1");
INSERT INTO audit_trail VALUES("173","1","Admin Admin","","Added Journal Manual Entry  with id:252","2021-01-21 08:54:53","2021-01-21 08:54:53","1");
INSERT INTO audit_trail VALUES("174","1","Admin Admin","","Added Journal Manual Entry  with id:254","2021-01-21 08:57:04","2021-01-21 08:57:04","1");
INSERT INTO audit_trail VALUES("175","1","Admin Admin","","Added Journal Manual Entry  with id:256","2021-01-21 08:57:56","2021-01-21 08:57:56","1");
INSERT INTO audit_trail VALUES("176","1","Admin Admin","","Added Journal Manual Entry  with id:258","2021-01-21 08:59:20","2021-01-21 08:59:20","1");
INSERT INTO audit_trail VALUES("177","1","Admin Admin","","Added Journal Manual Entry  with id:260","2021-01-21 08:59:42","2021-01-21 08:59:42","1");
INSERT INTO audit_trail VALUES("178","1","Admin Admin","","Added Journal Manual Entry  with id:262","2021-01-21 09:00:25","2021-01-21 09:00:25","1");
INSERT INTO audit_trail VALUES("179","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-21 09:00:44","2021-01-21 09:00:44","1");
INSERT INTO audit_trail VALUES("180","1","Admin Admin","","Logged in to system","2021-01-21 09:00:58","2021-01-21 09:00:58","1");
INSERT INTO audit_trail VALUES("181","1","Admin Admin","","Added Journal Manual Entry  with id:264","2021-01-21 09:01:26","2021-01-21 09:01:26","1");
INSERT INTO audit_trail VALUES("182","1","Admin Admin","","Added Journal Manual Entry  with id:266","2021-01-21 09:02:02","2021-01-21 09:02:02","1");
INSERT INTO audit_trail VALUES("183","1","Admin Admin","","Updated role with id:2","2021-01-21 09:02:22","2021-01-21 09:02:22","1");
INSERT INTO audit_trail VALUES("184","1","Admin Admin","","Logged out of system","2021-01-21 09:02:49","2021-01-21 09:02:49","1");
INSERT INTO audit_trail VALUES("185","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-21 09:03:10","2021-01-21 09:03:10","1");
INSERT INTO audit_trail VALUES("186","1","Admin Admin","","Logged in to system","2021-01-21 09:03:41","2021-01-21 09:03:41","1");
INSERT INTO audit_trail VALUES("187","1","Admin Admin","","Logged in to system","2021-01-21 09:04:08","2021-01-21 09:04:08","1");
INSERT INTO audit_trail VALUES("188","1","Admin Admin","","Logged out of system","2021-01-21 09:35:44","2021-01-21 09:35:44","1");
INSERT INTO audit_trail VALUES("189","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-21 09:36:30","2021-01-21 09:36:30","1");
INSERT INTO audit_trail VALUES("190","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-01-21 09:37:09","2021-01-21 09:37:09","1");
INSERT INTO audit_trail VALUES("191","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-21 09:37:53","2021-01-21 09:37:53","1");
INSERT INTO audit_trail VALUES("192","1","Admin Admin","","Logged in to system","2021-01-21 09:38:27","2021-01-21 09:38:27","1");
INSERT INTO audit_trail VALUES("193","1","Admin Admin","","Added Journal Manual Entry  with id:268","2021-01-21 09:40:22","2021-01-21 09:40:22","1");
INSERT INTO audit_trail VALUES("194","1","Admin Admin","","Added Journal Manual Entry  with id:270","2021-01-21 09:42:22","2021-01-21 09:42:22","1");
INSERT INTO audit_trail VALUES("195","1","Admin Admin","","Added Journal Manual Entry  with id:272","2021-01-21 09:42:23","2021-01-21 09:42:23","1");
INSERT INTO audit_trail VALUES("196","1","Admin Admin","","Added Journal Manual Entry  with id:274","2021-01-21 09:44:15","2021-01-21 09:44:15","1");
INSERT INTO audit_trail VALUES("197","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:1","2021-01-21 09:44:54","2021-01-21 09:44:54","1");
INSERT INTO audit_trail VALUES("198","1","Admin Admin","","Added Journal Manual Entry  with id:276","2021-01-21 09:45:45","2021-01-21 09:45:45","1");
INSERT INTO audit_trail VALUES("199","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:1","2021-01-21 09:46:04","2021-01-21 09:46:04","1");
INSERT INTO audit_trail VALUES("200","1","Admin Admin","","Added Journal Manual Entry  with id:278","2021-01-21 09:47:13","2021-01-21 09:47:13","1");
INSERT INTO audit_trail VALUES("201","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:1","2021-01-21 09:48:25","2021-01-21 09:48:25","1");
INSERT INTO audit_trail VALUES("202","1","Admin Admin","","Added Journal Manual Entry  with id:282","2021-01-21 09:48:25","2021-01-21 09:48:25","1");
INSERT INTO audit_trail VALUES("203","1","Admin Admin","","Added Journal Manual Entry  with id:284","2021-01-21 09:49:57","2021-01-21 09:49:57","1");
INSERT INTO audit_trail VALUES("204","1","Admin Admin","","Added Journal Manual Entry  with id:286","2021-01-21 09:51:13","2021-01-21 09:51:13","1");
INSERT INTO audit_trail VALUES("205","1","Admin Admin","","Added Journal Manual Entry  with id:288","2021-01-21 09:52:29","2021-01-21 09:52:29","1");
INSERT INTO audit_trail VALUES("206","1","Admin Admin","","Added Journal Manual Entry  with id:290","2021-01-21 09:53:51","2021-01-21 09:53:51","1");
INSERT INTO audit_trail VALUES("207","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-21 09:55:47","2021-01-21 09:55:47","1");
INSERT INTO audit_trail VALUES("208","1","Admin Admin","","Added Journal Manual Entry  with id:292","2021-01-21 09:55:50","2021-01-21 09:55:50","1");
INSERT INTO audit_trail VALUES("209","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-21 09:56:23","2021-01-21 09:56:23","1");
INSERT INTO audit_trail VALUES("210","1","Admin Admin","","Added Journal Manual Entry  with id:294","2021-01-21 09:57:21","2021-01-21 09:57:21","1");
INSERT INTO audit_trail VALUES("211","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:296","2021-01-21 09:58:07","2021-01-21 09:58:07","1");
INSERT INTO audit_trail VALUES("212","1","Admin Admin","","Added Journal Manual Entry  with id:298","2021-01-21 09:59:48","2021-01-21 09:59:48","1");
INSERT INTO audit_trail VALUES("213","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:300","2021-01-21 09:59:57","2021-01-21 09:59:57","1");
INSERT INTO audit_trail VALUES("214","1","Admin Admin","","Added Journal Manual Entry  with id:302","2021-01-21 10:02:02","2021-01-21 10:02:02","1");
INSERT INTO audit_trail VALUES("215","1","Admin Admin","","Added Journal Manual Entry  with id:304","2021-01-21 10:03:52","2021-01-21 10:03:52","1");
INSERT INTO audit_trail VALUES("216","1","Admin Admin","","Added Journal Manual Entry  with id:306","2021-01-21 10:05:20","2021-01-21 10:05:20","1");
INSERT INTO audit_trail VALUES("217","1","Admin Admin","","Added Journal Manual Entry  with id:308","2021-01-21 10:07:02","2021-01-21 10:07:02","1");
INSERT INTO audit_trail VALUES("218","1","Admin Admin","","Added Journal Manual Entry  with id:310","2021-01-21 10:08:57","2021-01-21 10:08:57","1");
INSERT INTO audit_trail VALUES("219","1","Admin Admin","","Added Journal Manual Entry  with id:312","2021-01-21 10:10:37","2021-01-21 10:10:37","1");
INSERT INTO audit_trail VALUES("220","1","Admin Admin","","Added Journal Manual Entry  with id:314","2021-01-21 10:12:50","2021-01-21 10:12:50","1");
INSERT INTO audit_trail VALUES("221","1","Admin Admin","","Added Journal Manual Entry  with id:316","2021-01-21 10:15:34","2021-01-21 10:15:34","1");
INSERT INTO audit_trail VALUES("222","1","Admin Admin","","Added Journal Manual Entry  with id:318","2021-01-21 10:15:35","2021-01-21 10:15:35","1");
INSERT INTO audit_trail VALUES("223","1","Admin Admin","","Added Journal Manual Entry  with id:320","2021-01-21 10:17:39","2021-01-21 10:17:39","1");
INSERT INTO audit_trail VALUES("224","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:322","2021-01-21 10:18:29","2021-01-21 10:18:29","1");
INSERT INTO audit_trail VALUES("225","1","Admin Admin","","Added Journal Manual Entry  with id:324","2021-01-21 10:19:15","2021-01-21 10:19:15","1");
INSERT INTO audit_trail VALUES("226","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:326","2021-01-21 10:19:48","2021-01-21 10:19:48","1");
INSERT INTO audit_trail VALUES("227","1","Admin Admin","","Added Journal Manual Entry  with id:328","2021-01-21 10:20:16","2021-01-21 10:20:16","1");
INSERT INTO audit_trail VALUES("228","1","Admin Admin","","Added Journal Manual Entry  with id:330","2021-01-21 10:21:19","2021-01-21 10:21:19","1");
INSERT INTO audit_trail VALUES("229","1","Admin Admin","","Added Journal Manual Entry  with id:332","2021-01-21 10:21:24","2021-01-21 10:21:24","1");
INSERT INTO audit_trail VALUES("230","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:334","2021-01-21 10:21:40","2021-01-21 10:21:40","1");
INSERT INTO audit_trail VALUES("231","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:336","2021-01-21 10:24:16","2021-01-21 10:24:16","1");
INSERT INTO audit_trail VALUES("232","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:338","2021-01-21 10:25:25","2021-01-21 10:25:25","1");
INSERT INTO audit_trail VALUES("233","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:346","2021-01-21 10:30:03","2021-01-21 10:30:03","1");
INSERT INTO audit_trail VALUES("234","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:350","2021-01-21 10:31:28","2021-01-21 10:31:28","1");
INSERT INTO audit_trail VALUES("235","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:354","2021-01-21 10:33:15","2021-01-21 10:33:15","1");
INSERT INTO audit_trail VALUES("236","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:360","2021-01-21 10:38:30","2021-01-21 10:38:30","1");
INSERT INTO audit_trail VALUES("237","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:364","2021-01-21 10:40:03","2021-01-21 10:40:03","1");
INSERT INTO audit_trail VALUES("238","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:370","2021-01-21 10:42:28","2021-01-21 10:42:28","1");
INSERT INTO audit_trail VALUES("239","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:372","2021-01-21 10:43:31","2021-01-21 10:43:31","1");
INSERT INTO audit_trail VALUES("240","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:376","2021-01-21 10:51:57","2021-01-21 10:51:57","1");
INSERT INTO audit_trail VALUES("241","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:380","2021-01-21 10:52:48","2021-01-21 10:52:48","1");
INSERT INTO audit_trail VALUES("242","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:382","2021-01-21 10:52:49","2021-01-21 10:52:49","1");
INSERT INTO audit_trail VALUES("243","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:384","2021-01-21 10:53:54","2021-01-21 10:53:54","1");
INSERT INTO audit_trail VALUES("244","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:388","2021-01-21 10:54:58","2021-01-21 10:54:58","1");
INSERT INTO audit_trail VALUES("245","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:390","2021-01-21 10:54:59","2021-01-21 10:54:59","1");
INSERT INTO audit_trail VALUES("246","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:392","2021-01-21 10:55:55","2021-01-21 10:55:55","1");
INSERT INTO audit_trail VALUES("247","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-01-21 11:48:41","2021-01-21 11:48:41","1");
INSERT INTO audit_trail VALUES("248","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-21 11:49:02","2021-01-21 11:49:02","1");
INSERT INTO audit_trail VALUES("249","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:614","2021-01-21 11:53:52","2021-01-21 11:53:52","1");
INSERT INTO audit_trail VALUES("250","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:615","2021-01-21 12:01:50","2021-01-21 12:01:50","1");
INSERT INTO audit_trail VALUES("251","1","Admin Admin","","Deleted borrower  with id:613","2021-01-21 12:04:45","2021-01-21 12:04:45","1");
INSERT INTO audit_trail VALUES("252","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-21 12:09:13","2021-01-21 12:09:13","1");
INSERT INTO audit_trail VALUES("253","1","Admin Admin","","Logged in to system","2021-01-22 06:12:56","2021-01-22 06:12:56","");
INSERT INTO audit_trail VALUES("254","1","Admin Admin","","Logged in to system","2021-01-22 06:46:51","2021-01-22 06:46:51","");
INSERT INTO audit_trail VALUES("255","1","Admin Admin","","Logged in to system","2021-01-22 07:03:53","2021-01-22 07:03:53","");
INSERT INTO audit_trail VALUES("256","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-22 07:14:09","2021-01-22 07:14:09","");
INSERT INTO audit_trail VALUES("257","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-22 07:18:23","2021-01-22 07:18:23","1");
INSERT INTO audit_trail VALUES("258","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-22 07:18:25","2021-01-22 07:18:25","1");
INSERT INTO audit_trail VALUES("259","1","Admin Admin","","Logged out of system","2021-01-22 10:20:28","2021-01-22 10:20:28","1");
INSERT INTO audit_trail VALUES("260","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-22 11:59:03","2021-01-22 11:59:03","1");
INSERT INTO audit_trail VALUES("261","1","Admin Admin","","Logged in to system","2021-01-24 06:19:05","2021-01-24 06:19:05","");
INSERT INTO audit_trail VALUES("262","1","Admin Admin","","Logged in to system","2021-01-25 06:24:22","2021-01-25 06:24:22","");
INSERT INTO audit_trail VALUES("263","1","Admin Admin","","Logged in to system","2021-01-25 06:26:21","2021-01-25 06:26:21","");
INSERT INTO audit_trail VALUES("264","1","Admin Admin","","Logged in to system","2021-01-25 07:13:44","2021-01-25 07:13:44","");
INSERT INTO audit_trail VALUES("265","1","Admin Admin","","Logged in to system","2021-01-25 09:45:13","2021-01-25 09:45:13","");
INSERT INTO audit_trail VALUES("266","1","Admin Admin","","Logged in to system","2021-01-25 09:50:42","2021-01-25 09:50:42","1");
INSERT INTO audit_trail VALUES("267","1","Admin Admin","","Added loan with id:2","2021-01-25 10:15:37","2021-01-25 10:15:37","1");
INSERT INTO audit_trail VALUES("268","1","Admin Admin","","Approved loan with id:2","2021-01-25 10:15:58","2021-01-25 10:15:58","1");
INSERT INTO audit_trail VALUES("269","1","Admin Admin","","Disbursed loan with id:2","2021-01-25 10:16:08","2021-01-25 10:16:08","1");
INSERT INTO audit_trail VALUES("270","1","Admin Admin","","Added loan with id:3","2021-01-25 10:18:13","2021-01-25 10:18:13","1");
INSERT INTO audit_trail VALUES("271","1","Admin Admin","","Added loan with id:4","2021-01-25 10:19:47","2021-01-25 10:19:47","1");
INSERT INTO audit_trail VALUES("272","1","Admin Admin","","Added loan with id:5","2021-01-25 10:21:35","2021-01-25 10:21:35","1");
INSERT INTO audit_trail VALUES("273","1","Admin Admin","","Added loan with id:6","2021-01-25 10:26:29","2021-01-25 10:26:29","1");
INSERT INTO audit_trail VALUES("274","1","Admin Admin","","Added loan with id:7","2021-01-25 10:32:16","2021-01-25 10:32:16","1");
INSERT INTO audit_trail VALUES("275","1","Admin Admin","","Added loan with id:8","2021-01-25 10:33:58","2021-01-25 10:33:58","1");
INSERT INTO audit_trail VALUES("276","1","Admin Admin","","Added loan with id:9","2021-01-25 10:35:40","2021-01-25 10:35:40","1");
INSERT INTO audit_trail VALUES("277","1","Admin Admin","","Added loan with id:10","2021-01-25 10:38:03","2021-01-25 10:38:03","1");
INSERT INTO audit_trail VALUES("278","1","Admin Admin","","Added loan with id:11","2021-01-25 10:46:35","2021-01-25 10:46:35","1");
INSERT INTO audit_trail VALUES("279","1","Admin Admin","","Added loan with id:12","2021-01-25 10:49:39","2021-01-25 10:49:39","1");
INSERT INTO audit_trail VALUES("280","1","Admin Admin","","Added loan with id:13","2021-01-25 10:52:40","2021-01-25 10:52:40","1");
INSERT INTO audit_trail VALUES("281","1","Admin Admin","","Added loan with id:14","2021-01-25 10:54:35","2021-01-25 10:54:35","1");
INSERT INTO audit_trail VALUES("282","1","Admin Admin","","Added loan with id:15","2021-01-25 10:56:43","2021-01-25 10:56:43","1");
INSERT INTO audit_trail VALUES("283","1","Admin Admin","","Added loan with id:16","2021-01-25 10:58:50","2021-01-25 10:58:50","1");
INSERT INTO audit_trail VALUES("284","1","Admin Admin","","Added loan with id:17","2021-01-25 11:00:48","2021-01-25 11:00:48","1");
INSERT INTO audit_trail VALUES("285","1","Admin Admin","","Added loan with id:18","2021-01-25 11:03:06","2021-01-25 11:03:06","1");
INSERT INTO audit_trail VALUES("286","1","Admin Admin","","Added loan with id:19","2021-01-25 11:04:36","2021-01-25 11:04:36","1");
INSERT INTO audit_trail VALUES("287","1","Admin Admin","","Added loan with id:20","2021-01-25 11:06:43","2021-01-25 11:06:43","1");
INSERT INTO audit_trail VALUES("288","1","Admin Admin","","Added loan with id:21","2021-01-25 11:08:14","2021-01-25 11:08:14","1");
INSERT INTO audit_trail VALUES("289","1","Admin Admin","","Added loan with id:22","2021-01-25 11:10:02","2021-01-25 11:10:02","1");
INSERT INTO audit_trail VALUES("290","1","Admin Admin","","Added loan with id:23","2021-01-25 11:11:16","2021-01-25 11:11:16","1");
INSERT INTO audit_trail VALUES("291","1","Admin Admin","","Added loan with id:24","2021-01-25 11:12:29","2021-01-25 11:12:29","1");
INSERT INTO audit_trail VALUES("292","1","Admin Admin","","Added loan with id:25","2021-01-25 11:13:48","2021-01-25 11:13:48","1");
INSERT INTO audit_trail VALUES("293","1","Admin Admin","","Added loan with id:26","2021-01-25 11:16:57","2021-01-25 11:16:57","1");
INSERT INTO audit_trail VALUES("294","1","Admin Admin","","Added loan with id:27","2021-01-25 11:19:28","2021-01-25 11:19:28","1");
INSERT INTO audit_trail VALUES("295","1","Admin Admin","","Added loan with id:28","2021-01-25 11:20:42","2021-01-25 11:20:42","1");
INSERT INTO audit_trail VALUES("296","1","Admin Admin","","Added loan with id:29","2021-01-25 11:22:12","2021-01-25 11:22:12","1");
INSERT INTO audit_trail VALUES("297","1","Admin Admin","","Added loan with id:30","2021-01-25 11:23:34","2021-01-25 11:23:34","1");
INSERT INTO audit_trail VALUES("298","1","Admin Admin","","Added loan with id:31","2021-01-25 11:25:56","2021-01-25 11:25:56","1");
INSERT INTO audit_trail VALUES("299","1","Admin Admin","","Added loan with id:32","2021-01-25 11:29:10","2021-01-25 11:29:10","1");
INSERT INTO audit_trail VALUES("300","1","Admin Admin","","Undisbursed loan with id:2","2021-01-25 11:30:48","2021-01-25 11:30:48","1");
INSERT INTO audit_trail VALUES("301","1","Admin Admin","","Unapproved loan with id:2","2021-01-25 11:31:01","2021-01-25 11:31:01","1");
INSERT INTO audit_trail VALUES("302","1","Admin Admin","","Updated loan with id:2","2021-01-25 11:31:28","2021-01-25 11:31:28","1");
INSERT INTO audit_trail VALUES("303","1","Admin Admin","","Approved loan with id:3","2021-01-25 11:32:22","2021-01-25 11:32:22","1");
INSERT INTO audit_trail VALUES("304","1","Admin Admin","","Disbursed loan with id:3","2021-01-25 11:32:31","2021-01-25 11:32:31","1");
INSERT INTO audit_trail VALUES("305","1","Admin Admin","","Logged in to system","2021-01-26 06:19:22","2021-01-26 06:19:22","");
INSERT INTO audit_trail VALUES("306","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-26 06:43:41","2021-01-26 06:43:41","");
INSERT INTO audit_trail VALUES("307","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-26 07:52:01","2021-01-26 07:52:01","");
INSERT INTO audit_trail VALUES("308","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-26 08:00:12","2021-01-26 08:00:12","1");
INSERT INTO audit_trail VALUES("309","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-26 08:00:12","2021-01-26 08:00:12","1");
INSERT INTO audit_trail VALUES("310","1","Admin Admin","","Added expense with id:1","2021-01-26 08:14:38","2021-01-26 08:14:38","1");
INSERT INTO audit_trail VALUES("311","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-26 08:25:45","2021-01-26 08:25:45","");
INSERT INTO audit_trail VALUES("312","1","Admin Admin","","Updated loan product with id:1","2021-01-26 08:33:14","2021-01-26 08:33:14","1");
INSERT INTO audit_trail VALUES("313","1","Admin Admin","","Updated loan product with id:2","2021-01-26 08:33:50","2021-01-26 08:33:50","1");
INSERT INTO audit_trail VALUES("314","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:31","2021-01-26 08:34:11","2021-01-26 08:34:11","1");
INSERT INTO audit_trail VALUES("315","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:31","2021-01-26 08:34:35","2021-01-26 08:34:35","1");
INSERT INTO audit_trail VALUES("316","1","Admin Admin","","Updated loan product with id:3","2021-01-26 08:34:38","2021-01-26 08:34:38","1");
INSERT INTO audit_trail VALUES("317","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:19","2021-01-26 08:36:40","2021-01-26 08:36:40","1");
INSERT INTO audit_trail VALUES("318","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:19","2021-01-26 08:38:04","2021-01-26 08:38:04","1");
INSERT INTO audit_trail VALUES("319","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:32","2021-01-26 08:41:54","2021-01-26 08:41:54","1");
INSERT INTO audit_trail VALUES("320","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:32","2021-01-26 08:43:33","2021-01-26 08:43:33","1");
INSERT INTO audit_trail VALUES("321","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:2","2021-01-26 08:45:36","2021-01-26 08:45:36","1");
INSERT INTO audit_trail VALUES("322","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:2","2021-01-26 08:45:49","2021-01-26 08:45:49","1");
INSERT INTO audit_trail VALUES("323","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:4","2021-01-26 08:50:52","2021-01-26 08:50:52","1");
INSERT INTO audit_trail VALUES("324","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:4","2021-01-26 08:51:27","2021-01-26 08:51:27","1");
INSERT INTO audit_trail VALUES("325","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:5","2021-01-26 08:53:43","2021-01-26 08:53:43","1");
INSERT INTO audit_trail VALUES("326","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:5","2021-01-26 08:53:54","2021-01-26 08:53:54","1");
INSERT INTO audit_trail VALUES("327","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:6","2021-01-26 08:54:45","2021-01-26 08:54:45","1");
INSERT INTO audit_trail VALUES("328","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:6","2021-01-26 08:55:11","2021-01-26 08:55:11","1");
INSERT INTO audit_trail VALUES("329","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:7","2021-01-26 08:56:01","2021-01-26 08:56:01","1");
INSERT INTO audit_trail VALUES("330","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:7","2021-01-26 08:56:19","2021-01-26 08:56:19","1");
INSERT INTO audit_trail VALUES("331","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:8","2021-01-26 08:56:58","2021-01-26 08:56:58","1");
INSERT INTO audit_trail VALUES("332","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:8","2021-01-26 08:57:11","2021-01-26 08:57:11","1");
INSERT INTO audit_trail VALUES("333","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:9","2021-01-26 08:57:54","2021-01-26 08:57:54","1");
INSERT INTO audit_trail VALUES("334","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:9","2021-01-26 08:58:12","2021-01-26 08:58:12","1");
INSERT INTO audit_trail VALUES("335","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:10","2021-01-26 08:58:58","2021-01-26 08:58:58","1");
INSERT INTO audit_trail VALUES("336","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:10","2021-01-26 08:59:15","2021-01-26 08:59:15","1");
INSERT INTO audit_trail VALUES("337","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:11","2021-01-26 09:00:16","2021-01-26 09:00:16","1");
INSERT INTO audit_trail VALUES("338","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:11","2021-01-26 09:00:26","2021-01-26 09:00:26","1");
INSERT INTO audit_trail VALUES("339","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:12","2021-01-26 09:01:07","2021-01-26 09:01:07","1");
INSERT INTO audit_trail VALUES("340","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:12","2021-01-26 09:01:21","2021-01-26 09:01:21","1");
INSERT INTO audit_trail VALUES("341","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:13","2021-01-26 09:08:13","2021-01-26 09:08:13","1");
INSERT INTO audit_trail VALUES("342","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:13","2021-01-26 09:08:24","2021-01-26 09:08:24","1");
INSERT INTO audit_trail VALUES("343","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:14","2021-01-26 09:09:10","2021-01-26 09:09:10","1");
INSERT INTO audit_trail VALUES("344","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:14","2021-01-26 09:09:23","2021-01-26 09:09:23","1");
INSERT INTO audit_trail VALUES("345","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:15","2021-01-26 09:10:07","2021-01-26 09:10:07","1");
INSERT INTO audit_trail VALUES("346","1","Admin Admin","","Added loan with id:33","2021-01-26 09:10:17","2021-01-26 09:10:17","1");
INSERT INTO audit_trail VALUES("347","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:15","2021-01-26 09:10:17","2021-01-26 09:10:17","1");
INSERT INTO audit_trail VALUES("348","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:16","2021-01-26 09:10:56","2021-01-26 09:10:56","1");
INSERT INTO audit_trail VALUES("349","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:16","2021-01-26 09:11:06","2021-01-26 09:11:06","1");
INSERT INTO audit_trail VALUES("350","1","Admin Admin","","Added loan with id:34","2021-01-26 09:11:46","2021-01-26 09:11:46","1");
INSERT INTO audit_trail VALUES("351","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:17","2021-01-26 09:11:51","2021-01-26 09:11:51","1");
INSERT INTO audit_trail VALUES("352","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:17","2021-01-26 09:12:03","2021-01-26 09:12:03","1");
INSERT INTO audit_trail VALUES("353","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:18","2021-01-26 09:13:06","2021-01-26 09:13:06","1");
INSERT INTO audit_trail VALUES("354","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:18","2021-01-26 09:13:25","2021-01-26 09:13:25","1");
INSERT INTO audit_trail VALUES("355","1","Admin Admin","","Added loan with id:35","2021-01-26 09:13:49","2021-01-26 09:13:49","1");
INSERT INTO audit_trail VALUES("356","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:20","2021-01-26 09:14:03","2021-01-26 09:14:03","1");
INSERT INTO audit_trail VALUES("357","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:20","2021-01-26 09:14:15","2021-01-26 09:14:15","1");
INSERT INTO audit_trail VALUES("358","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:21","2021-01-26 09:14:57","2021-01-26 09:14:57","1");
INSERT INTO audit_trail VALUES("359","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:21","2021-01-26 09:15:07","2021-01-26 09:15:07","1");
INSERT INTO audit_trail VALUES("360","1","Admin Admin","","Added loan with id:36","2021-01-26 09:15:21","2021-01-26 09:15:21","1");
INSERT INTO audit_trail VALUES("361","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:22","2021-01-26 09:15:57","2021-01-26 09:15:57","1");
INSERT INTO audit_trail VALUES("362","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:22","2021-01-26 09:16:09","2021-01-26 09:16:09","1");
INSERT INTO audit_trail VALUES("363","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:23","2021-01-26 09:16:53","2021-01-26 09:16:53","1");
INSERT INTO audit_trail VALUES("364","1","Admin Admin","","Added loan with id:37","2021-01-26 09:16:55","2021-01-26 09:16:55","1");
INSERT INTO audit_trail VALUES("365","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:23","2021-01-26 09:17:07","2021-01-26 09:17:07","1");
INSERT INTO audit_trail VALUES("366","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:24","2021-01-26 09:17:54","2021-01-26 09:17:54","1");
INSERT INTO audit_trail VALUES("367","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:24","2021-01-26 09:18:04","2021-01-26 09:18:04","1");
INSERT INTO audit_trail VALUES("368","1","Admin Admin","","Added loan with id:38","2021-01-26 09:18:14","2021-01-26 09:18:14","1");
INSERT INTO audit_trail VALUES("369","1","Admin Admin","","Added loan with id:39","2021-01-26 09:18:14","2021-01-26 09:18:14","1");
INSERT INTO audit_trail VALUES("370","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:25","2021-01-26 09:18:38","2021-01-26 09:18:38","1");
INSERT INTO audit_trail VALUES("371","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:25","2021-01-26 09:18:48","2021-01-26 09:18:48","1");
INSERT INTO audit_trail VALUES("372","1","Admin Admin","","Added loan with id:40","2021-01-26 09:19:22","2021-01-26 09:19:22","1");
INSERT INTO audit_trail VALUES("373","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:26","2021-01-26 09:19:31","2021-01-26 09:19:31","1");
INSERT INTO audit_trail VALUES("374","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:26","2021-01-26 09:19:42","2021-01-26 09:19:42","1");
INSERT INTO audit_trail VALUES("375","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:27","2021-01-26 09:20:25","2021-01-26 09:20:25","1");
INSERT INTO audit_trail VALUES("376","1","Admin Admin","","Added loan with id:41","2021-01-26 09:20:35","2021-01-26 09:20:35","1");
INSERT INTO audit_trail VALUES("377","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:27","2021-01-26 09:20:36","2021-01-26 09:20:36","1");
INSERT INTO audit_trail VALUES("378","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:28","2021-01-26 09:21:21","2021-01-26 09:21:21","1");
INSERT INTO audit_trail VALUES("379","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:28","2021-01-26 09:21:42","2021-01-26 09:21:42","1");
INSERT INTO audit_trail VALUES("380","1","Admin Admin","","Added loan with id:42","2021-01-26 09:21:42","2021-01-26 09:21:42","1");
INSERT INTO audit_trail VALUES("381","1","Admin Admin","","Updated loan with id:42","2021-01-26 09:22:38","2021-01-26 09:22:38","1");
INSERT INTO audit_trail VALUES("382","1","Admin Admin","","Added loan with id:43","2021-01-26 09:24:20","2021-01-26 09:24:20","1");
INSERT INTO audit_trail VALUES("383","1","Admin Admin","","Added loan with id:44","2021-01-26 09:25:40","2021-01-26 09:25:40","1");
INSERT INTO audit_trail VALUES("384","1","Admin Admin","","Added loan with id:45","2021-01-26 09:27:12","2021-01-26 09:27:12","1");
INSERT INTO audit_trail VALUES("385","1","Admin Admin","","Added loan with id:46","2021-01-26 09:28:43","2021-01-26 09:28:43","1");
INSERT INTO audit_trail VALUES("386","1","Admin Admin","","Added loan with id:47","2021-01-26 09:30:36","2021-01-26 09:30:36","1");
INSERT INTO audit_trail VALUES("387","1","Admin Admin","","Added loan with id:48","2021-01-26 09:33:41","2021-01-26 09:33:41","1");
INSERT INTO audit_trail VALUES("388","1","Admin Admin","","Added loan with id:49","2021-01-26 09:37:15","2021-01-26 09:37:15","1");
INSERT INTO audit_trail VALUES("389","1","Admin Admin","","Added loan with id:50","2021-01-26 09:39:24","2021-01-26 09:39:24","1");
INSERT INTO audit_trail VALUES("390","1","Admin Admin","","Added loan with id:51","2021-01-26 09:41:22","2021-01-26 09:41:22","1");
INSERT INTO audit_trail VALUES("391","1","Admin Admin","","Added loan with id:52","2021-01-26 09:43:33","2021-01-26 09:43:33","1");
INSERT INTO audit_trail VALUES("392","1","Admin Admin","","Added loan with id:53","2021-01-26 09:45:45","2021-01-26 09:45:45","1");
INSERT INTO audit_trail VALUES("393","1","Admin Admin","","Added loan with id:54","2021-01-26 09:48:24","2021-01-26 09:48:24","1");
INSERT INTO audit_trail VALUES("394","1","Admin Admin","","Added loan with id:55","2021-01-26 09:52:22","2021-01-26 09:52:22","1");
INSERT INTO audit_trail VALUES("395","1","Admin Admin","","Added loan with id:56","2021-01-26 09:52:22","2021-01-26 09:52:22","1");
INSERT INTO audit_trail VALUES("396","1","Admin Admin","","Added loan with id:57","2021-01-26 09:54:04","2021-01-26 09:54:04","1");
INSERT INTO audit_trail VALUES("397","1","Admin Admin","","Added loan with id:58","2021-01-26 09:55:12","2021-01-26 09:55:12","1");
INSERT INTO audit_trail VALUES("398","1","Admin Admin","","Added loan with id:59","2021-01-26 09:57:35","2021-01-26 09:57:35","1");
INSERT INTO audit_trail VALUES("399","1","Admin Admin","","Added loan with id:60","2021-01-26 10:00:39","2021-01-26 10:00:39","1");
INSERT INTO audit_trail VALUES("400","1","Admin Admin","","Added loan with id:61","2021-01-26 10:01:43","2021-01-26 10:01:43","1");
INSERT INTO audit_trail VALUES("401","1","Admin Admin","","Added loan with id:62","2021-01-26 10:03:29","2021-01-26 10:03:29","1");
INSERT INTO audit_trail VALUES("402","1","Admin Admin","","Added loan with id:63","2021-01-26 10:05:44","2021-01-26 10:05:44","1");
INSERT INTO audit_trail VALUES("403","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:29","2021-01-26 10:06:22","2021-01-26 10:06:22","1");
INSERT INTO audit_trail VALUES("404","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:29","2021-01-26 10:06:35","2021-01-26 10:06:35","1");
INSERT INTO audit_trail VALUES("405","1","Admin Admin","","Added loan with id:64","2021-01-26 10:06:45","2021-01-26 10:06:45","1");
INSERT INTO audit_trail VALUES("406","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:30","2021-01-26 10:07:23","2021-01-26 10:07:23","1");
INSERT INTO audit_trail VALUES("407","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:30","2021-01-26 10:07:36","2021-01-26 10:07:36","1");
INSERT INTO audit_trail VALUES("408","1","Admin Admin","","Added loan with id:65","2021-01-26 10:08:15","2021-01-26 10:08:15","1");
INSERT INTO audit_trail VALUES("409","1","Admin Admin","","Updated loan with id:65","2021-01-26 10:08:53","2021-01-26 10:08:53","1");
INSERT INTO audit_trail VALUES("410","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:65","2021-01-26 10:09:06","2021-01-26 10:09:06","1");
INSERT INTO audit_trail VALUES("411","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:65","2021-01-26 10:09:18","2021-01-26 10:09:18","1");
INSERT INTO audit_trail VALUES("412","1","Admin Admin","","Added loan with id:66","2021-01-26 10:10:21","2021-01-26 10:10:21","1");
INSERT INTO audit_trail VALUES("413","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:33","2021-01-26 10:10:36","2021-01-26 10:10:36","1");
INSERT INTO audit_trail VALUES("414","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:33","2021-01-26 10:11:07","2021-01-26 10:11:07","1");
INSERT INTO audit_trail VALUES("415","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:34","2021-01-26 10:12:03","2021-01-26 10:12:03","1");
INSERT INTO audit_trail VALUES("416","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:34","2021-01-26 10:12:03","2021-01-26 10:12:03","1");
INSERT INTO audit_trail VALUES("417","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:34","2021-01-26 10:12:14","2021-01-26 10:12:14","1");
INSERT INTO audit_trail VALUES("418","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:34","2021-01-26 10:12:16","2021-01-26 10:12:16","1");
INSERT INTO audit_trail VALUES("419","1","Admin Admin","","Added loan with id:67","2021-01-26 10:12:54","2021-01-26 10:12:54","1");
INSERT INTO audit_trail VALUES("420","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:35","2021-01-26 10:13:08","2021-01-26 10:13:08","1");
INSERT INTO audit_trail VALUES("421","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:35","2021-01-26 10:13:22","2021-01-26 10:13:22","1");
INSERT INTO audit_trail VALUES("422","1","Admin Admin","","Added loan with id:68","2021-01-26 10:14:24","2021-01-26 10:14:24","1");
INSERT INTO audit_trail VALUES("423","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:36","2021-01-26 10:14:28","2021-01-26 10:14:28","1");
INSERT INTO audit_trail VALUES("424","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:36","2021-01-26 10:14:38","2021-01-26 10:14:38","1");
INSERT INTO audit_trail VALUES("425","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:37","2021-01-26 10:15:11","2021-01-26 10:15:11","1");
INSERT INTO audit_trail VALUES("426","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:37","2021-01-26 10:15:21","2021-01-26 10:15:21","1");
INSERT INTO audit_trail VALUES("427","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:38","2021-01-26 10:16:10","2021-01-26 10:16:10","1");
INSERT INTO audit_trail VALUES("428","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:38","2021-01-26 10:16:34","2021-01-26 10:16:34","1");
INSERT INTO audit_trail VALUES("429","1","Admin Admin","","Added loan with id:69","2021-01-26 10:16:34","2021-01-26 10:16:34","1");
INSERT INTO audit_trail VALUES("430","1","Admin Admin","","Updated loan with id:69","2021-01-26 10:18:13","2021-01-26 10:18:13","1");
INSERT INTO audit_trail VALUES("431","1","Admin Admin","","Added loan with id:70","2021-01-26 11:05:52","2021-01-26 11:05:52","1");
INSERT INTO audit_trail VALUES("432","1","Admin Admin","","Added loan with id:71","2021-01-26 11:07:00","2021-01-26 11:07:00","1");
INSERT INTO audit_trail VALUES("433","1","Admin Admin","","Added loan with id:72","2021-01-26 11:08:47","2021-01-26 11:08:47","1");
INSERT INTO audit_trail VALUES("434","1","Admin Admin","","Added loan with id:73","2021-01-26 11:10:10","2021-01-26 11:10:10","1");
INSERT INTO audit_trail VALUES("435","1","Admin Admin","","Added loan with id:74","2021-01-26 11:14:15","2021-01-26 11:14:15","1");
INSERT INTO audit_trail VALUES("436","1","Admin Admin","","Added loan with id:75","2021-01-26 11:16:27","2021-01-26 11:16:27","1");
INSERT INTO audit_trail VALUES("437","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:39","2021-01-26 11:17:13","2021-01-26 11:17:13","1");
INSERT INTO audit_trail VALUES("438","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:39","2021-01-26 11:17:26","2021-01-26 11:17:26","1");
INSERT INTO audit_trail VALUES("439","1","Admin Admin","","Added loan with id:76","2021-01-26 11:17:31","2021-01-26 11:17:31","1");
INSERT INTO audit_trail VALUES("440","1","Admin Admin","","Added loan with id:77","2021-01-26 11:19:00","2021-01-26 11:19:00","1");
INSERT INTO audit_trail VALUES("441","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:40","2021-01-26 11:19:13","2021-01-26 11:19:13","1");
INSERT INTO audit_trail VALUES("442","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:40","2021-01-26 11:19:35","2021-01-26 11:19:35","1");
INSERT INTO audit_trail VALUES("443","1","Admin Admin","","Added loan with id:78","2021-01-26 11:20:13","2021-01-26 11:20:13","1");
INSERT INTO audit_trail VALUES("444","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:41","2021-01-26 11:20:18","2021-01-26 11:20:18","1");
INSERT INTO audit_trail VALUES("445","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:41","2021-01-26 11:20:45","2021-01-26 11:20:45","1");
INSERT INTO audit_trail VALUES("446","1","Admin Admin","","Added loan with id:79","2021-01-26 11:21:41","2021-01-26 11:21:41","1");
INSERT INTO audit_trail VALUES("447","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:42","2021-01-26 11:22:10","2021-01-26 11:22:10","1");
INSERT INTO audit_trail VALUES("448","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:42","2021-01-26 11:22:24","2021-01-26 11:22:24","1");
INSERT INTO audit_trail VALUES("449","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:43","2021-01-26 11:22:53","2021-01-26 11:22:53","1");
INSERT INTO audit_trail VALUES("450","1","Admin Admin","","Added loan with id:80","2021-01-26 11:23:02","2021-01-26 11:23:02","1");
INSERT INTO audit_trail VALUES("451","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:43","2021-01-26 11:23:04","2021-01-26 11:23:04","1");
INSERT INTO audit_trail VALUES("452","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:44","2021-01-26 11:25:10","2021-01-26 11:25:10","1");
INSERT INTO audit_trail VALUES("453","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:44","2021-01-26 11:25:21","2021-01-26 11:25:21","1");
INSERT INTO audit_trail VALUES("454","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:45","2021-01-26 11:25:59","2021-01-26 11:25:59","1");
INSERT INTO audit_trail VALUES("455","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:45","2021-01-26 11:26:09","2021-01-26 11:26:09","1");
INSERT INTO audit_trail VALUES("456","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:46","2021-01-26 11:26:49","2021-01-26 11:26:49","1");
INSERT INTO audit_trail VALUES("457","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:46","2021-01-26 11:26:58","2021-01-26 11:26:58","1");
INSERT INTO audit_trail VALUES("458","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:47","2021-01-26 11:28:01","2021-01-26 11:28:01","1");
INSERT INTO audit_trail VALUES("459","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:47","2021-01-26 11:28:18","2021-01-26 11:28:18","1");
INSERT INTO audit_trail VALUES("460","1","Admin Admin","","Added loan with id:81","2021-01-26 11:28:26","2021-01-26 11:28:26","1");
INSERT INTO audit_trail VALUES("461","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:48","2021-01-26 11:29:40","2021-01-26 11:29:40","1");
INSERT INTO audit_trail VALUES("462","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:48","2021-01-26 11:30:02","2021-01-26 11:30:02","1");
INSERT INTO audit_trail VALUES("463","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:49","2021-01-26 11:30:45","2021-01-26 11:30:45","1");
INSERT INTO audit_trail VALUES("464","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:49","2021-01-26 11:31:08","2021-01-26 11:31:08","1");
INSERT INTO audit_trail VALUES("465","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:50","2021-01-26 11:32:00","2021-01-26 11:32:00","1");
INSERT INTO audit_trail VALUES("466","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:50","2021-01-26 11:32:15","2021-01-26 11:32:15","1");
INSERT INTO audit_trail VALUES("467","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:51","2021-01-26 11:32:57","2021-01-26 11:32:57","1");
INSERT INTO audit_trail VALUES("468","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:51","2021-01-26 11:33:13","2021-01-26 11:33:13","1");
INSERT INTO audit_trail VALUES("469","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:52","2021-01-26 11:34:07","2021-01-26 11:34:07","1");
INSERT INTO audit_trail VALUES("470","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:52","2021-01-26 11:34:26","2021-01-26 11:34:26","1");
INSERT INTO audit_trail VALUES("471","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:53","2021-01-26 11:35:42","2021-01-26 11:35:42","1");
INSERT INTO audit_trail VALUES("472","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:53","2021-01-26 11:36:04","2021-01-26 11:36:04","1");
INSERT INTO audit_trail VALUES("473","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:54","2021-01-26 11:36:48","2021-01-26 11:36:48","1");
INSERT INTO audit_trail VALUES("474","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:54","2021-01-26 11:37:02","2021-01-26 11:37:02","1");
INSERT INTO audit_trail VALUES("475","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:55","2021-01-26 11:37:42","2021-01-26 11:37:42","1");
INSERT INTO audit_trail VALUES("476","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:55","2021-01-26 11:38:05","2021-01-26 11:38:05","1");
INSERT INTO audit_trail VALUES("477","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:56","2021-01-26 11:38:57","2021-01-26 11:38:57","1");
INSERT INTO audit_trail VALUES("478","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:56","2021-01-26 11:39:13","2021-01-26 11:39:13","1");
INSERT INTO audit_trail VALUES("479","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:57","2021-01-26 11:40:23","2021-01-26 11:40:23","1");
INSERT INTO audit_trail VALUES("480","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:57","2021-01-26 11:40:41","2021-01-26 11:40:41","1");
INSERT INTO audit_trail VALUES("481","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:58","2021-01-26 11:41:34","2021-01-26 11:41:34","1");
INSERT INTO audit_trail VALUES("482","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:58","2021-01-26 11:41:53","2021-01-26 11:41:53","1");
INSERT INTO audit_trail VALUES("483","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:59","2021-01-26 11:42:45","2021-01-26 11:42:45","1");
INSERT INTO audit_trail VALUES("484","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:59","2021-01-26 11:43:01","2021-01-26 11:43:01","1");
INSERT INTO audit_trail VALUES("485","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:60","2021-01-26 11:44:32","2021-01-26 11:44:32","1");
INSERT INTO audit_trail VALUES("486","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:60","2021-01-26 11:44:49","2021-01-26 11:44:49","1");
INSERT INTO audit_trail VALUES("487","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:61","2021-01-26 11:45:38","2021-01-26 11:45:38","1");
INSERT INTO audit_trail VALUES("488","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:61","2021-01-26 11:45:56","2021-01-26 11:45:56","1");
INSERT INTO audit_trail VALUES("489","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:62","2021-01-26 11:46:25","2021-01-26 11:46:25","1");
INSERT INTO audit_trail VALUES("490","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:62","2021-01-26 11:46:36","2021-01-26 11:46:36","1");
INSERT INTO audit_trail VALUES("491","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:63","2021-01-26 11:47:09","2021-01-26 11:47:09","1");
INSERT INTO audit_trail VALUES("492","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:63","2021-01-26 11:47:19","2021-01-26 11:47:19","1");
INSERT INTO audit_trail VALUES("493","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:64","2021-01-26 11:48:01","2021-01-26 11:48:01","1");
INSERT INTO audit_trail VALUES("494","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:64","2021-01-26 11:48:13","2021-01-26 11:48:13","1");
INSERT INTO audit_trail VALUES("495","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:66","2021-01-26 11:49:02","2021-01-26 11:49:02","1");
INSERT INTO audit_trail VALUES("496","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:66","2021-01-26 11:49:12","2021-01-26 11:49:12","1");
INSERT INTO audit_trail VALUES("497","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:67","2021-01-26 11:49:45","2021-01-26 11:49:45","1");
INSERT INTO audit_trail VALUES("498","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:67","2021-01-26 11:50:02","2021-01-26 11:50:02","1");
INSERT INTO audit_trail VALUES("499","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:68","2021-01-26 11:50:48","2021-01-26 11:50:48","1");
INSERT INTO audit_trail VALUES("500","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:68","2021-01-26 11:50:59","2021-01-26 11:50:59","1");
INSERT INTO audit_trail VALUES("501","1","Admin Admin","","Added loan with id:82","2021-01-26 11:51:09","2021-01-26 11:51:09","1");
INSERT INTO audit_trail VALUES("502","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:69","2021-01-26 11:51:48","2021-01-26 11:51:48","1");
INSERT INTO audit_trail VALUES("503","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:69","2021-01-26 11:52:00","2021-01-26 11:52:00","1");
INSERT INTO audit_trail VALUES("504","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:69","2021-01-26 11:52:00","2021-01-26 11:52:00","1");
INSERT INTO audit_trail VALUES("505","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:70","2021-01-26 11:52:39","2021-01-26 11:52:39","1");
INSERT INTO audit_trail VALUES("506","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:70","2021-01-26 11:52:58","2021-01-26 11:52:58","1");
INSERT INTO audit_trail VALUES("507","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:71","2021-01-26 11:53:28","2021-01-26 11:53:28","1");
INSERT INTO audit_trail VALUES("508","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:71","2021-01-26 11:53:39","2021-01-26 11:53:39","1");
INSERT INTO audit_trail VALUES("509","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:72","2021-01-26 11:54:28","2021-01-26 11:54:28","1");
INSERT INTO audit_trail VALUES("510","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:72","2021-01-26 11:54:38","2021-01-26 11:54:38","1");
INSERT INTO audit_trail VALUES("511","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:73","2021-01-26 11:55:39","2021-01-26 11:55:39","1");
INSERT INTO audit_trail VALUES("512","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:73","2021-01-26 11:56:30","2021-01-26 11:56:30","1");
INSERT INTO audit_trail VALUES("513","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:74","2021-01-26 11:57:08","2021-01-26 11:57:08","1");
INSERT INTO audit_trail VALUES("514","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:74","2021-01-26 11:57:35","2021-01-26 11:57:35","1");
INSERT INTO audit_trail VALUES("515","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:75","2021-01-26 11:58:15","2021-01-26 11:58:15","1");
INSERT INTO audit_trail VALUES("516","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:75","2021-01-26 11:58:47","2021-01-26 11:58:47","1");
INSERT INTO audit_trail VALUES("517","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:76","2021-01-26 11:59:21","2021-01-26 11:59:21","1");
INSERT INTO audit_trail VALUES("518","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:76","2021-01-26 11:59:39","2021-01-26 11:59:39","1");
INSERT INTO audit_trail VALUES("519","1","Admin Admin","","Added Capital  with id:1","2021-01-26 12:00:44","2021-01-26 12:00:44","1");
INSERT INTO audit_trail VALUES("520","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:77","2021-01-26 12:00:56","2021-01-26 12:00:56","1");
INSERT INTO audit_trail VALUES("521","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:77","2021-01-26 12:01:14","2021-01-26 12:01:14","1");
INSERT INTO audit_trail VALUES("522","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:78","2021-01-26 12:03:54","2021-01-26 12:03:54","1");
INSERT INTO audit_trail VALUES("523","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:78","2021-01-26 12:07:26","2021-01-26 12:07:26","1");
INSERT INTO audit_trail VALUES("524","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:79","2021-01-26 12:08:03","2021-01-26 12:08:03","1");
INSERT INTO audit_trail VALUES("525","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:79","2021-01-26 12:08:22","2021-01-26 12:08:22","1");
INSERT INTO audit_trail VALUES("526","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:80","2021-01-26 12:09:17","2021-01-26 12:09:17","1");
INSERT INTO audit_trail VALUES("527","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:80","2021-01-26 12:09:44","2021-01-26 12:09:44","1");
INSERT INTO audit_trail VALUES("528","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:81","2021-01-26 12:10:37","2021-01-26 12:10:37","1");
INSERT INTO audit_trail VALUES("529","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:81","2021-01-26 12:10:50","2021-01-26 12:10:50","1");
INSERT INTO audit_trail VALUES("530","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:82","2021-01-26 12:11:35","2021-01-26 12:11:35","1");
INSERT INTO audit_trail VALUES("531","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:82","2021-01-26 12:12:22","2021-01-26 12:12:22","1");
INSERT INTO audit_trail VALUES("532","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:83","2021-01-27 04:37:44","2021-01-27 04:37:44","1");
INSERT INTO audit_trail VALUES("533","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:84","2021-01-27 04:40:13","2021-01-27 04:40:13","1");
INSERT INTO audit_trail VALUES("534","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:85","2021-01-27 04:42:24","2021-01-27 04:42:24","1");
INSERT INTO audit_trail VALUES("535","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:86","2021-01-27 04:43:52","2021-01-27 04:43:52","1");
INSERT INTO audit_trail VALUES("536","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:87","2021-01-27 04:45:19","2021-01-27 04:45:19","1");
INSERT INTO audit_trail VALUES("537","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:88","2021-01-27 04:48:05","2021-01-27 04:48:05","1");
INSERT INTO audit_trail VALUES("538","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:89","2021-01-27 04:50:45","2021-01-27 04:50:45","1");
INSERT INTO audit_trail VALUES("539","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:90","2021-01-27 04:52:19","2021-01-27 04:52:19","1");
INSERT INTO audit_trail VALUES("540","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:91","2021-01-27 04:53:55","2021-01-27 04:53:55","1");
INSERT INTO audit_trail VALUES("541","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:92","2021-01-27 04:56:36","2021-01-27 04:56:36","1");
INSERT INTO audit_trail VALUES("542","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:93","2021-01-27 04:59:25","2021-01-27 04:59:25","1");
INSERT INTO audit_trail VALUES("543","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:94","2021-01-27 05:22:02","2021-01-27 05:22:02","1");
INSERT INTO audit_trail VALUES("544","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:95","2021-01-27 05:23:54","2021-01-27 05:23:54","1");
INSERT INTO audit_trail VALUES("545","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:96","2021-01-27 05:27:52","2021-01-27 05:27:52","1");
INSERT INTO audit_trail VALUES("546","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:97","2021-01-27 05:29:15","2021-01-27 05:29:15","1");
INSERT INTO audit_trail VALUES("547","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:98","2021-01-27 05:30:44","2021-01-27 05:30:44","1");
INSERT INTO audit_trail VALUES("548","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:99","2021-01-27 05:35:14","2021-01-27 05:35:14","1");
INSERT INTO audit_trail VALUES("549","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:100","2021-01-27 05:37:05","2021-01-27 05:37:05","1");
INSERT INTO audit_trail VALUES("550","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:101","2021-01-27 05:38:37","2021-01-27 05:38:37","1");
INSERT INTO audit_trail VALUES("551","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:102","2021-01-27 05:40:14","2021-01-27 05:40:14","1");
INSERT INTO audit_trail VALUES("552","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:103","2021-01-27 05:43:45","2021-01-27 05:43:45","1");
INSERT INTO audit_trail VALUES("553","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:104","2021-01-27 05:46:14","2021-01-27 05:46:14","1");
INSERT INTO audit_trail VALUES("554","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:105","2021-01-27 05:47:34","2021-01-27 05:47:34","1");
INSERT INTO audit_trail VALUES("555","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:106","2021-01-27 05:48:58","2021-01-27 05:48:58","1");
INSERT INTO audit_trail VALUES("556","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:107","2021-01-27 05:53:32","2021-01-27 05:53:32","1");
INSERT INTO audit_trail VALUES("557","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:108","2021-01-27 05:54:37","2021-01-27 05:54:37","1");
INSERT INTO audit_trail VALUES("558","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:109","2021-01-27 05:56:15","2021-01-27 05:56:15","1");
INSERT INTO audit_trail VALUES("559","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:110","2021-01-27 05:57:50","2021-01-27 05:57:50","1");
INSERT INTO audit_trail VALUES("560","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:111","2021-01-27 06:11:26","2021-01-27 06:11:26","1");
INSERT INTO audit_trail VALUES("561","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:112","2021-01-27 06:14:24","2021-01-27 06:14:24","1");
INSERT INTO audit_trail VALUES("562","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:113","2021-01-27 06:18:03","2021-01-27 06:18:03","1");
INSERT INTO audit_trail VALUES("563","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:114","2021-01-27 06:19:33","2021-01-27 06:19:33","1");
INSERT INTO audit_trail VALUES("564","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:115","2021-01-27 06:21:34","2021-01-27 06:21:34","1");
INSERT INTO audit_trail VALUES("565","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:116","2021-01-27 06:24:01","2021-01-27 06:24:01","1");
INSERT INTO audit_trail VALUES("566","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:117","2021-01-27 06:25:19","2021-01-27 06:25:19","1");
INSERT INTO audit_trail VALUES("567","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:118","2021-01-27 06:26:20","2021-01-27 06:26:20","1");
INSERT INTO audit_trail VALUES("568","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:119","2021-01-27 06:45:11","2021-01-27 06:45:11","1");
INSERT INTO audit_trail VALUES("569","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:120","2021-01-27 06:51:23","2021-01-27 06:51:23","1");
INSERT INTO audit_trail VALUES("570","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:121","2021-01-27 06:52:46","2021-01-27 06:52:46","1");
INSERT INTO audit_trail VALUES("571","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:122","2021-01-27 06:53:54","2021-01-27 06:53:54","1");
INSERT INTO audit_trail VALUES("572","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:123","2021-01-27 06:55:06","2021-01-27 06:55:06","1");
INSERT INTO audit_trail VALUES("573","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:124","2021-01-27 06:56:03","2021-01-27 06:56:03","1");
INSERT INTO audit_trail VALUES("574","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:125","2021-01-27 06:56:58","2021-01-27 06:56:58","1");
INSERT INTO audit_trail VALUES("575","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:126","2021-01-27 06:59:43","2021-01-27 06:59:43","1");
INSERT INTO audit_trail VALUES("576","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:127","2021-01-27 07:00:48","2021-01-27 07:00:48","1");
INSERT INTO audit_trail VALUES("577","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:128","2021-01-27 07:01:46","2021-01-27 07:01:46","1");
INSERT INTO audit_trail VALUES("578","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:129","2021-01-27 07:03:19","2021-01-27 07:03:19","1");
INSERT INTO audit_trail VALUES("579","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:130","2021-01-27 07:04:23","2021-01-27 07:04:23","1");
INSERT INTO audit_trail VALUES("580","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:131","2021-01-27 07:05:39","2021-01-27 07:05:39","1");
INSERT INTO audit_trail VALUES("581","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:132","2021-01-27 07:06:36","2021-01-27 07:06:36","1");
INSERT INTO audit_trail VALUES("582","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:133","2021-01-27 07:08:04","2021-01-27 07:08:04","1");
INSERT INTO audit_trail VALUES("583","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:134","2021-01-27 07:08:05","2021-01-27 07:08:05","1");
INSERT INTO audit_trail VALUES("584","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:135","2021-01-27 07:09:21","2021-01-27 07:09:21","1");
INSERT INTO audit_trail VALUES("585","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:136","2021-01-27 07:10:16","2021-01-27 07:10:16","1");
INSERT INTO audit_trail VALUES("586","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:137","2021-01-27 07:11:17","2021-01-27 07:11:17","1");
INSERT INTO audit_trail VALUES("587","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:138","2021-01-27 07:16:57","2021-01-27 07:16:57","1");
INSERT INTO audit_trail VALUES("588","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:139","2021-01-27 07:18:10","2021-01-27 07:18:10","1");
INSERT INTO audit_trail VALUES("589","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:140","2021-01-27 07:19:20","2021-01-27 07:19:20","1");
INSERT INTO audit_trail VALUES("590","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:141","2021-01-27 07:20:10","2021-01-27 07:20:10","1");
INSERT INTO audit_trail VALUES("591","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:142","2021-01-27 07:22:12","2021-01-27 07:22:12","1");
INSERT INTO audit_trail VALUES("592","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:143","2021-01-27 07:22:55","2021-01-27 07:22:55","1");
INSERT INTO audit_trail VALUES("593","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:144","2021-01-27 07:24:12","2021-01-27 07:24:12","1");
INSERT INTO audit_trail VALUES("594","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:145","2021-01-27 07:25:23","2021-01-27 07:25:23","1");
INSERT INTO audit_trail VALUES("595","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:146","2021-01-27 07:26:13","2021-01-27 07:26:13","1");
INSERT INTO audit_trail VALUES("596","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:84","2021-01-27 07:35:13","2021-01-27 07:35:13","1");
INSERT INTO audit_trail VALUES("597","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:84","2021-01-27 07:36:33","2021-01-27 07:36:33","1");
INSERT INTO audit_trail VALUES("598","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:85","2021-01-27 07:37:39","2021-01-27 07:37:39","1");
INSERT INTO audit_trail VALUES("599","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:85","2021-01-27 07:39:07","2021-01-27 07:39:07","1");
INSERT INTO audit_trail VALUES("600","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:86","2021-01-27 07:40:46","2021-01-27 07:40:46","1");
INSERT INTO audit_trail VALUES("601","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:87","2021-01-27 07:41:51","2021-01-27 07:41:51","1");
INSERT INTO audit_trail VALUES("602","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:88","2021-01-27 07:43:22","2021-01-27 07:43:22","1");
INSERT INTO audit_trail VALUES("603","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:89","2021-01-27 07:44:33","2021-01-27 07:44:33","1");
INSERT INTO audit_trail VALUES("604","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:90","2021-01-27 07:45:53","2021-01-27 07:45:53","1");
INSERT INTO audit_trail VALUES("605","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-27 07:47:58","2021-01-27 07:47:58","");
INSERT INTO audit_trail VALUES("606","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:91","2021-01-27 07:48:06","2021-01-27 07:48:06","1");
INSERT INTO audit_trail VALUES("607","1","Admin Admin","","Updated loan with id:87","2021-01-27 07:49:39","2021-01-27 07:49:39","1");
INSERT INTO audit_trail VALUES("608","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:92","2021-01-27 07:49:50","2021-01-27 07:49:50","1");
INSERT INTO audit_trail VALUES("609","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:93","2021-01-27 07:51:14","2021-01-27 07:51:14","1");
INSERT INTO audit_trail VALUES("610","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:94","2021-01-27 07:52:07","2021-01-27 07:52:07","1");
INSERT INTO audit_trail VALUES("611","1","Admin Admin","","Approved loan with id:83","2021-01-27 07:52:59","2021-01-27 07:52:59","1");
INSERT INTO audit_trail VALUES("612","1","Admin Admin","","Disbursed loan with id:83","2021-01-27 07:53:13","2021-01-27 07:53:13","1");
INSERT INTO audit_trail VALUES("613","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:95","2021-01-27 07:53:16","2021-01-27 07:53:16","1");
INSERT INTO audit_trail VALUES("614","1","Admin Admin","","Approved loan with id:93","2021-01-27 07:53:58","2021-01-27 07:53:58","1");
INSERT INTO audit_trail VALUES("615","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:96","2021-01-27 07:54:03","2021-01-27 07:54:03","1");
INSERT INTO audit_trail VALUES("616","1","Admin Admin","","Disbursed loan with id:93","2021-01-27 07:54:22","2021-01-27 07:54:22","1");
INSERT INTO audit_trail VALUES("617","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:97","2021-01-27 07:54:56","2021-01-27 07:54:56","1");
INSERT INTO audit_trail VALUES("618","1","Admin Admin","","Approved loan with id:96","2021-01-27 07:55:03","2021-01-27 07:55:03","1");
INSERT INTO audit_trail VALUES("619","1","Admin Admin","","Disbursed loan with id:96","2021-01-27 07:55:22","2021-01-27 07:55:22","1");
INSERT INTO audit_trail VALUES("620","1","Admin Admin","","Disbursed loan with id:96","2021-01-27 07:55:23","2021-01-27 07:55:23","1");
INSERT INTO audit_trail VALUES("621","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:98","2021-01-27 07:55:41","2021-01-27 07:55:41","1");
INSERT INTO audit_trail VALUES("622","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:98","2021-01-27 07:56:18","2021-01-27 07:56:18","1");
INSERT INTO audit_trail VALUES("623","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:98","2021-01-27 07:56:52","2021-01-27 07:56:52","1");
INSERT INTO audit_trail VALUES("624","1","Admin Admin","","Approved loan with id:99","2021-01-27 07:56:55","2021-01-27 07:56:55","1");
INSERT INTO audit_trail VALUES("625","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:99","2021-01-27 07:57:29","2021-01-27 07:57:29","1");
INSERT INTO audit_trail VALUES("626","1","Admin Admin","","Approved loan with id:95","2021-01-27 07:57:38","2021-01-27 07:57:38","1");
INSERT INTO audit_trail VALUES("627","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:99","2021-01-27 07:58:05","2021-01-27 07:58:05","1");
INSERT INTO audit_trail VALUES("628","1","Admin Admin","","Disbursed loan with id:95","2021-01-27 07:58:17","2021-01-27 07:58:17","1");
INSERT INTO audit_trail VALUES("629","1","Admin Admin","","Approved loan with id:92","2021-01-27 07:59:08","2021-01-27 07:59:08","1");
INSERT INTO audit_trail VALUES("630","1","Admin Admin","","Disbursed loan with id:92","2021-01-27 07:59:35","2021-01-27 07:59:35","1");
INSERT INTO audit_trail VALUES("631","1","Admin Admin","","Approved loan with id:109","2021-01-27 08:02:02","2021-01-27 08:02:02","1");
INSERT INTO audit_trail VALUES("632","1","Admin Admin","","Disbursed loan with id:109","2021-01-27 08:07:10","2021-01-27 08:07:10","1");
INSERT INTO audit_trail VALUES("633","1","Admin Admin","","Approved loan with id:97","2021-01-27 08:09:13","2021-01-27 08:09:13","1");
INSERT INTO audit_trail VALUES("634","1","Admin Admin","","Disbursed loan with id:97","2021-01-27 08:09:45","2021-01-27 08:09:45","1");
INSERT INTO audit_trail VALUES("635","1","Admin Admin","","Approved loan with id:94","2021-01-27 08:10:35","2021-01-27 08:10:35","1");
INSERT INTO audit_trail VALUES("636","1","Admin Admin","","Disbursed loan with id:94","2021-01-27 08:10:56","2021-01-27 08:10:56","1");
INSERT INTO audit_trail VALUES("637","1","Admin Admin","","Approved loan with id:90","2021-01-27 08:12:06","2021-01-27 08:12:06","1");
INSERT INTO audit_trail VALUES("638","1","Admin Admin","","Disbursed loan with id:90","2021-01-27 08:12:41","2021-01-27 08:12:41","1");
INSERT INTO audit_trail VALUES("639","1","Admin Admin","","Approved loan with id:91","2021-01-27 08:13:49","2021-01-27 08:13:49","1");
INSERT INTO audit_trail VALUES("640","1","Admin Admin","","Disbursed loan with id:91","2021-01-27 08:14:08","2021-01-27 08:14:08","1");
INSERT INTO audit_trail VALUES("641","1","Admin Admin","","Approved loan with id:89","2021-01-27 08:14:59","2021-01-27 08:14:59","1");
INSERT INTO audit_trail VALUES("642","1","Admin Admin","","Disbursed loan with id:89","2021-01-27 08:15:18","2021-01-27 08:15:18","1");
INSERT INTO audit_trail VALUES("643","1","Admin Admin","","Approved loan with id:87","2021-01-27 08:16:29","2021-01-27 08:16:29","1");
INSERT INTO audit_trail VALUES("644","1","Admin Admin","","Disbursed loan with id:87","2021-01-27 08:16:56","2021-01-27 08:16:56","1");
INSERT INTO audit_trail VALUES("645","1","Admin Admin","","Approved loan with id:141","2021-01-27 08:18:03","2021-01-27 08:18:03","1");
INSERT INTO audit_trail VALUES("646","1","Admin Admin","","Disbursed loan with id:141","2021-01-27 08:18:22","2021-01-27 08:18:22","1");
INSERT INTO audit_trail VALUES("647","1","Admin Admin","","Approved loan with id:110","2021-01-27 08:53:05","2021-01-27 08:53:05","1");
INSERT INTO audit_trail VALUES("648","1","Admin Admin","","Disbursed loan with id:110","2021-01-27 08:53:33","2021-01-27 08:53:33","1");
INSERT INTO audit_trail VALUES("649","1","Admin Admin","","Approved loan with id:88","2021-01-27 08:54:35","2021-01-27 08:54:35","1");
INSERT INTO audit_trail VALUES("650","1","Admin Admin","","Disbursed loan with id:88","2021-01-27 08:54:48","2021-01-27 08:54:48","1");
INSERT INTO audit_trail VALUES("651","1","Admin Admin","","Approved loan with id:86","2021-01-27 08:55:45","2021-01-27 08:55:45","1");
INSERT INTO audit_trail VALUES("652","1","Admin Admin","","Disbursed loan with id:86","2021-01-27 08:56:00","2021-01-27 08:56:00","1");
INSERT INTO audit_trail VALUES("653","1","Admin Admin","","Approved loan with id:143","2021-01-27 08:56:43","2021-01-27 08:56:43","1");
INSERT INTO audit_trail VALUES("654","1","Admin Admin","","Disbursed loan with id:143","2021-01-27 08:57:02","2021-01-27 08:57:02","1");
INSERT INTO audit_trail VALUES("655","1","Admin Admin","","Approved loan with id:145","2021-01-27 09:00:07","2021-01-27 09:00:07","1");
INSERT INTO audit_trail VALUES("656","1","Admin Admin","","Disbursed loan with id:145","2021-01-27 09:00:23","2021-01-27 09:00:23","1");
INSERT INTO audit_trail VALUES("657","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:100","2021-01-27 09:00:39","2021-01-27 09:00:39","1");
INSERT INTO audit_trail VALUES("658","1","Admin Admin","","Approved loan with id:144","2021-01-27 09:00:52","2021-01-27 09:00:52","1");
INSERT INTO audit_trail VALUES("659","1","Admin Admin","","Disbursed loan with id:144","2021-01-27 09:01:08","2021-01-27 09:01:08","1");
INSERT INTO audit_trail VALUES("660","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:100","2021-01-27 09:01:23","2021-01-27 09:01:23","1");
INSERT INTO audit_trail VALUES("661","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:100","2021-01-27 09:01:23","2021-01-27 09:01:23","1");
INSERT INTO audit_trail VALUES("662","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:100","2021-01-27 09:01:46","2021-01-27 09:01:46","1");
INSERT INTO audit_trail VALUES("663","1","Admin Admin","","Approved loan with id:133","2021-01-27 09:02:47","2021-01-27 09:02:47","1");
INSERT INTO audit_trail VALUES("664","1","Admin Admin","","Disbursed loan with id:133","2021-01-27 09:03:02","2021-01-27 09:03:02","1");
INSERT INTO audit_trail VALUES("665","1","Admin Admin","","Approved loan with id:107","2021-01-27 09:04:08","2021-01-27 09:04:08","1");
INSERT INTO audit_trail VALUES("666","1","Admin Admin","","Disbursed loan with id:107","2021-01-27 09:05:06","2021-01-27 09:05:06","1");
INSERT INTO audit_trail VALUES("667","1","Admin Admin","","Approved loan with id:101","2021-01-27 09:06:10","2021-01-27 09:06:10","1");
INSERT INTO audit_trail VALUES("668","1","Admin Admin","","Disbursed loan with id:101","2021-01-27 09:06:31","2021-01-27 09:06:31","1");
INSERT INTO audit_trail VALUES("669","1","Admin Admin","","Approved loan with id:102","2021-01-27 09:07:33","2021-01-27 09:07:33","1");
INSERT INTO audit_trail VALUES("670","1","Admin Admin","","Disbursed loan with id:102","2021-01-27 09:08:00","2021-01-27 09:08:00","1");
INSERT INTO audit_trail VALUES("671","1","Admin Admin","","Approved loan with id:103","2021-01-27 09:09:27","2021-01-27 09:09:27","1");
INSERT INTO audit_trail VALUES("672","1","Admin Admin","","Disbursed loan with id:103","2021-01-27 09:09:58","2021-01-27 09:09:58","1");
INSERT INTO audit_trail VALUES("673","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:104","2021-01-27 09:11:26","2021-01-27 09:11:26","1");
INSERT INTO audit_trail VALUES("674","1","Admin Admin","","Approved loan with id:116","2021-01-27 09:11:41","2021-01-27 09:11:41","1");
INSERT INTO audit_trail VALUES("675","1","Admin Admin","","Disbursed loan with id:116","2021-01-27 09:11:57","2021-01-27 09:11:57","1");
INSERT INTO audit_trail VALUES("676","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:104","2021-01-27 09:12:03","2021-01-27 09:12:03","1");
INSERT INTO audit_trail VALUES("677","1","Admin Admin","","Approved loan with id:142","2021-01-27 09:12:41","2021-01-27 09:12:41","1");
INSERT INTO audit_trail VALUES("678","1","Admin Admin","","Disbursed loan with id:142","2021-01-27 09:12:55","2021-01-27 09:12:55","1");
INSERT INTO audit_trail VALUES("679","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:105","2021-01-27 09:13:04","2021-01-27 09:13:04","1");
INSERT INTO audit_trail VALUES("680","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:105","2021-01-27 09:13:37","2021-01-27 09:13:37","1");
INSERT INTO audit_trail VALUES("681","1","Admin Admin","","Disbursed loan with id:105","2021-01-27 09:13:45","2021-01-27 09:13:45","1");
INSERT INTO audit_trail VALUES("682","1","Admin Admin","","Undisbursed loan with id:105","2021-01-27 09:14:07","2021-01-27 09:14:07","1");
INSERT INTO audit_trail VALUES("683","1","Admin Admin","","Disbursed loan with id:105","2021-01-27 09:14:19","2021-01-27 09:14:19","1");
INSERT INTO audit_trail VALUES("684","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:106","2021-01-27 09:14:35","2021-01-27 09:14:35","1");
INSERT INTO audit_trail VALUES("685","1","Admin Admin","","Approved loan with id:108","2021-01-27 09:15:05","2021-01-27 09:15:05","1");
INSERT INTO audit_trail VALUES("686","1","Admin Admin","","Disbursed loan with id:108","2021-01-27 09:15:23","2021-01-27 09:15:23","1");
INSERT INTO audit_trail VALUES("687","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:106","2021-01-27 09:16:18","2021-01-27 09:16:18","1");
INSERT INTO audit_trail VALUES("688","1","Admin Admin","","Approved loan with id:111","2021-01-27 09:16:24","2021-01-27 09:16:24","1");
INSERT INTO audit_trail VALUES("689","1","Admin Admin","","Disbursed loan with id:111","2021-01-27 09:16:42","2021-01-27 09:16:42","1");
INSERT INTO audit_trail VALUES("690","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:112","2021-01-27 09:17:30","2021-01-27 09:17:30","1");
INSERT INTO audit_trail VALUES("691","1","Admin Admin","","Approved loan with id:112","2021-01-27 09:17:34","2021-01-27 09:17:34","1");
INSERT INTO audit_trail VALUES("692","1","Admin Admin","","Disbursed loan with id:112","2021-01-27 09:17:55","2021-01-27 09:17:55","1");
INSERT INTO audit_trail VALUES("693","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:112","2021-01-27 09:17:58","2021-01-27 09:17:58","1");
INSERT INTO audit_trail VALUES("694","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:113","2021-01-27 09:18:37","2021-01-27 09:18:37","1");
INSERT INTO audit_trail VALUES("695","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:113","2021-01-27 09:18:55","2021-01-27 09:18:55","1");
INSERT INTO audit_trail VALUES("696","1","Admin Admin","","Approved loan with id:123","2021-01-27 09:19:33","2021-01-27 09:19:33","1");
INSERT INTO audit_trail VALUES("697","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:114","2021-01-27 09:19:46","2021-01-27 09:19:46","1");
INSERT INTO audit_trail VALUES("698","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:114","2021-01-27 09:20:09","2021-01-27 09:20:09","1");
INSERT INTO audit_trail VALUES("699","1","Admin Admin","","Disbursed loan with id:123","2021-01-27 09:20:09","2021-01-27 09:20:09","1");
INSERT INTO audit_trail VALUES("700","1","Admin Admin","","Undisbursed loan with id:112","2021-01-27 09:20:40","2021-01-27 09:20:40","1");
INSERT INTO audit_trail VALUES("701","1","Admin Admin","","Disbursed loan with id:112","2021-01-27 09:20:51","2021-01-27 09:20:51","1");
INSERT INTO audit_trail VALUES("702","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:115","2021-01-27 09:20:57","2021-01-27 09:20:57","1");
INSERT INTO audit_trail VALUES("703","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:115","2021-01-27 09:21:26","2021-01-27 09:21:26","1");
INSERT INTO audit_trail VALUES("704","1","Admin Admin","","Approved loan with id:127","2021-01-27 09:21:47","2021-01-27 09:21:47","1");
INSERT INTO audit_trail VALUES("705","1","Admin Admin","","Disbursed loan with id:127","2021-01-27 09:22:09","2021-01-27 09:22:09","1");
INSERT INTO audit_trail VALUES("706","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:117","2021-01-27 09:22:28","2021-01-27 09:22:28","1");
INSERT INTO audit_trail VALUES("707","1","Admin Admin","","Approved loan with id:128","2021-01-27 09:22:56","2021-01-27 09:22:56","1");
INSERT INTO audit_trail VALUES("708","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:117","2021-01-27 09:23:02","2021-01-27 09:23:02","1");
INSERT INTO audit_trail VALUES("709","1","Admin Admin","","Disbursed loan with id:128","2021-01-27 09:23:12","2021-01-27 09:23:12","1");
INSERT INTO audit_trail VALUES("710","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:118","2021-01-27 09:23:54","2021-01-27 09:23:54","1");
INSERT INTO audit_trail VALUES("711","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:118","2021-01-27 09:24:14","2021-01-27 09:24:14","1");
INSERT INTO audit_trail VALUES("712","1","Admin Admin","","Approved loan with id:130","2021-01-27 09:24:17","2021-01-27 09:24:17","1");
INSERT INTO audit_trail VALUES("713","1","Admin Admin","","Disbursed loan with id:130","2021-01-27 09:24:39","2021-01-27 09:24:39","1");
INSERT INTO audit_trail VALUES("714","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:119","2021-01-27 09:25:02","2021-01-27 09:25:02","1");
INSERT INTO audit_trail VALUES("715","1","Admin Admin","","Approved loan with id:120","2021-01-27 09:25:41","2021-01-27 09:25:41","1");
INSERT INTO audit_trail VALUES("716","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:119","2021-01-27 09:25:55","2021-01-27 09:25:55","1");
INSERT INTO audit_trail VALUES("717","1","Admin Admin","","Disbursed loan with id:120","2021-01-27 09:26:05","2021-01-27 09:26:05","1");
INSERT INTO audit_trail VALUES("718","1","Admin Admin","","Approved loan with id:135","2021-01-27 09:26:50","2021-01-27 09:26:50","1");
INSERT INTO audit_trail VALUES("719","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:121","2021-01-27 09:26:58","2021-01-27 09:26:58","1");
INSERT INTO audit_trail VALUES("720","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:121","2021-01-27 09:28:35","2021-01-27 09:28:35","1");
INSERT INTO audit_trail VALUES("721","1","Admin Admin","","Disbursed loan with id:135","2021-01-27 09:28:37","2021-01-27 09:28:37","1");
INSERT INTO audit_trail VALUES("722","1","Admin Admin","","Approved loan with id:137","2021-01-27 09:29:27","2021-01-27 09:29:27","1");
INSERT INTO audit_trail VALUES("723","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:122","2021-01-27 09:29:41","2021-01-27 09:29:41","1");
INSERT INTO audit_trail VALUES("724","1","Admin Admin","","Disbursed loan with id:137","2021-01-27 09:29:44","2021-01-27 09:29:44","1");
INSERT INTO audit_trail VALUES("725","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:122","2021-01-27 09:30:11","2021-01-27 09:30:11","1");
INSERT INTO audit_trail VALUES("726","1","Admin Admin","","Approved loan with id:124","2021-01-27 09:30:47","2021-01-27 09:30:47","1");
INSERT INTO audit_trail VALUES("727","1","Admin Admin","","Disbursed loan with id:124","2021-01-27 09:31:05","2021-01-27 09:31:05","1");
INSERT INTO audit_trail VALUES("728","1","Admin Admin","","Approved loan with id:132","2021-01-27 09:31:58","2021-01-27 09:31:58","1");
INSERT INTO audit_trail VALUES("729","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:125","2021-01-27 09:32:13","2021-01-27 09:32:13","1");
INSERT INTO audit_trail VALUES("730","1","Admin Admin","","Disbursed loan with id:132","2021-01-27 09:32:20","2021-01-27 09:32:20","1");
INSERT INTO audit_trail VALUES("731","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:125","2021-01-27 09:32:37","2021-01-27 09:32:37","1");
INSERT INTO audit_trail VALUES("732","1","Admin Admin","","Approved loan with id:126","2021-01-27 09:33:06","2021-01-27 09:33:06","1");
INSERT INTO audit_trail VALUES("733","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:126","2021-01-27 09:33:34","2021-01-27 09:33:34","1");
INSERT INTO audit_trail VALUES("734","1","Admin Admin","","Disbursed loan with id:126","2021-01-27 09:34:13","2021-01-27 09:34:13","1");
INSERT INTO audit_trail VALUES("735","1","Admin Admin","","Approved loan with id:146","2021-01-27 09:35:06","2021-01-27 09:35:06","1");
INSERT INTO audit_trail VALUES("736","1","Admin Admin","","Disbursed loan with id:146","2021-01-27 09:35:45","2021-01-27 09:35:45","1");
INSERT INTO audit_trail VALUES("737","1","Admin Admin","","Approved loan with id:140","2021-01-27 09:36:41","2021-01-27 09:36:41","1");
INSERT INTO audit_trail VALUES("738","1","Admin Admin","","Disbursed loan with id:140","2021-01-27 09:37:02","2021-01-27 09:37:02","1");
INSERT INTO audit_trail VALUES("739","1","Admin Admin","","Approved loan with id:139","2021-01-27 09:37:56","2021-01-27 09:37:56","1");
INSERT INTO audit_trail VALUES("740","1","Admin Admin","","Disbursed loan with id:139","2021-01-27 09:38:20","2021-01-27 09:38:20","1");
INSERT INTO audit_trail VALUES("741","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:129","2021-01-27 09:38:34","2021-01-27 09:38:34","1");
INSERT INTO audit_trail VALUES("742","1","Admin Admin","","Approved loan with id:138","2021-01-27 09:39:13","2021-01-27 09:39:13","1");
INSERT INTO audit_trail VALUES("743","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:129","2021-01-27 09:39:23","2021-01-27 09:39:23","1");
INSERT INTO audit_trail VALUES("744","1","Admin Admin","","Disbursed loan with id:138","2021-01-27 09:39:29","2021-01-27 09:39:29","1");
INSERT INTO audit_trail VALUES("745","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:131","2021-01-27 09:40:14","2021-01-27 09:40:14","1");
INSERT INTO audit_trail VALUES("746","1","Admin Admin","","Approved loan with id:136","2021-01-27 09:40:56","2021-01-27 09:40:56","1");
INSERT INTO audit_trail VALUES("747","1","Admin Admin","","Disbursed loan with id:136","2021-01-27 09:41:13","2021-01-27 09:41:13","1");
INSERT INTO audit_trail VALUES("748","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:131","2021-01-27 09:41:39","2021-01-27 09:41:39","1");
INSERT INTO audit_trail VALUES("749","1","Admin Admin","","Approved loan with id:134","2021-01-27 09:42:10","2021-01-27 09:42:10","1");
INSERT INTO audit_trail VALUES("750","1","Admin Admin","","Disbursed loan with id:134","2021-01-27 09:42:26","2021-01-27 09:42:26","1");
INSERT INTO audit_trail VALUES("751","1","Admin Admin","","Logged out of system","2021-01-27 09:58:22","2021-01-27 09:58:22","1");
INSERT INTO audit_trail VALUES("752","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-27 10:00:03","2021-01-27 10:00:03","1");
INSERT INTO audit_trail VALUES("753","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-27 10:06:06","2021-01-27 10:06:06","1");
INSERT INTO audit_trail VALUES("754","1","Admin Admin","","Logged in to system","2021-01-27 10:06:10","2021-01-27 10:06:10","1");
INSERT INTO audit_trail VALUES("755","1","Admin Admin","","Logged in to system","2021-01-27 10:06:31","2021-01-27 10:06:31","1");
INSERT INTO audit_trail VALUES("756","1","Admin Admin","","Logged out of system","2021-01-27 10:13:17","2021-01-27 10:13:17","1");
INSERT INTO audit_trail VALUES("757","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-27 10:15:00","2021-01-27 10:15:00","1");
INSERT INTO audit_trail VALUES("758","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-27 10:23:20","2021-01-27 10:23:20","1");
INSERT INTO audit_trail VALUES("759","1","Admin Admin","","Logged in to system","2021-01-27 10:23:27","2021-01-27 10:23:27","1");
INSERT INTO audit_trail VALUES("760","1","Admin Admin","","Updated role with id:3","2021-01-27 10:24:57","2021-01-27 10:24:57","1");
INSERT INTO audit_trail VALUES("761","1","Admin Admin","","Logged out of system","2021-01-27 10:28:31","2021-01-27 10:28:31","1");
INSERT INTO audit_trail VALUES("762","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-27 10:29:27","2021-01-27 10:29:27","1");
INSERT INTO audit_trail VALUES("763","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-27 10:36:34","2021-01-27 10:36:34","1");
INSERT INTO audit_trail VALUES("764","1","Admin Admin","","Logged in to system","2021-01-27 10:38:54","2021-01-27 10:38:54","1");
INSERT INTO audit_trail VALUES("765","1","Admin Admin","","Updated role with id:3","2021-01-27 10:40:12","2021-01-27 10:40:12","1");
INSERT INTO audit_trail VALUES("766","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-01-27 10:40:39","2021-01-27 10:40:39","1");
INSERT INTO audit_trail VALUES("767","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-27 10:41:04","2021-01-27 10:41:04","1");
INSERT INTO audit_trail VALUES("768","1","Admin Admin","","Updated role with id:3","2021-01-27 10:46:44","2021-01-27 10:46:44","1");
INSERT INTO audit_trail VALUES("769","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-01-27 10:47:15","2021-01-27 10:47:15","1");
INSERT INTO audit_trail VALUES("770","1","Admin Admin","","Logged in to system","2021-01-27 10:47:20","2021-01-27 10:47:20","1");
INSERT INTO audit_trail VALUES("771","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-27 10:47:32","2021-01-27 10:47:32","1");
INSERT INTO audit_trail VALUES("772","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:2","2021-01-27 10:49:29","2021-01-27 10:49:29","1");
INSERT INTO audit_trail VALUES("773","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-27 10:56:31","2021-01-27 10:56:31","1");
INSERT INTO audit_trail VALUES("774","1","Admin Admin","","Updated role with id:3","2021-01-27 11:15:18","2021-01-27 11:15:18","1");
INSERT INTO audit_trail VALUES("775","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-27 11:19:35","2021-01-27 11:19:35","1");
INSERT INTO audit_trail VALUES("776","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-27 11:31:11","2021-01-27 11:31:11","1");
INSERT INTO audit_trail VALUES("777","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:34","2021-01-27 11:39:00","2021-01-27 11:39:00","1");
INSERT INTO audit_trail VALUES("778","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:34","2021-01-27 11:39:15","2021-01-27 11:39:15","1");
INSERT INTO audit_trail VALUES("779","1","Admin Admin","","Logged out of system","2021-01-27 11:59:33","2021-01-27 11:59:33","1");
INSERT INTO audit_trail VALUES("780","1","Admin Admin","","Logged in to system","2021-01-27 12:00:10","2021-01-27 12:00:10","1");
INSERT INTO audit_trail VALUES("781","1","Admin Admin","","Logged in to system","2021-01-27 12:31:41","2021-01-27 12:31:41","1");
INSERT INTO audit_trail VALUES("782","1","Admin Admin","","Added loan with id:147","2021-01-27 13:08:51","2021-01-27 13:08:51","1");
INSERT INTO audit_trail VALUES("783","1","Admin Admin","","Approved loan with id:147","2021-01-27 13:09:36","2021-01-27 13:09:36","1");
INSERT INTO audit_trail VALUES("784","1","Admin Admin","","Disbursed loan with id:147","2021-01-27 13:09:52","2021-01-27 13:09:52","1");
INSERT INTO audit_trail VALUES("785","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:147","2021-01-27 13:13:33","2021-01-27 13:13:33","1");
INSERT INTO audit_trail VALUES("786","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:147","2021-01-27 13:13:46","2021-01-27 13:13:46","1");
INSERT INTO audit_trail VALUES("787","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:147","2021-01-27 13:15:19","2021-01-27 13:15:19","1");
INSERT INTO audit_trail VALUES("788","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:147","2021-01-27 13:16:40","2021-01-27 13:16:40","1");
INSERT INTO audit_trail VALUES("789","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:3","2021-01-28 05:36:24","2021-01-28 05:36:24","1");
INSERT INTO audit_trail VALUES("790","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:4","2021-01-28 05:44:19","2021-01-28 05:44:19","1");
INSERT INTO audit_trail VALUES("791","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:5","2021-01-28 06:30:58","2021-01-28 06:30:58","1");
INSERT INTO audit_trail VALUES("792","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:5","2021-01-28 06:32:24","2021-01-28 06:32:24","1");
INSERT INTO audit_trail VALUES("793","1","Admin Admin","","Added borrower  with id:616","2021-01-28 07:07:19","2021-01-28 07:07:19","1");
INSERT INTO audit_trail VALUES("794","1","Admin Admin","","Updated borrower  with id:1","2021-01-28 08:56:26","2021-01-28 08:56:26","1");
INSERT INTO audit_trail VALUES("795","1","Admin Admin","","Updated borrower  with id:1","2021-01-28 08:57:19","2021-01-28 08:57:19","1");
INSERT INTO audit_trail VALUES("796","1","Admin Admin","","Updated borrower  with id:140","2021-01-28 09:17:21","2021-01-28 09:17:21","1");
INSERT INTO audit_trail VALUES("797","1","Admin Admin","","Updated borrower  with id:140","2021-01-28 09:20:56","2021-01-28 09:20:56","1");
INSERT INTO audit_trail VALUES("798","1","Admin Admin","","Blacklisted borrower  with id:140","2021-01-28 09:21:26","2021-01-28 09:21:26","1");
INSERT INTO audit_trail VALUES("799","1","Admin Admin","","Updated borrower  with id:527","2021-01-28 09:39:28","2021-01-28 09:39:28","1");
INSERT INTO audit_trail VALUES("800","1","Admin Admin","","Updated borrower  with id:3","2021-01-28 09:40:47","2021-01-28 09:40:47","1");
INSERT INTO audit_trail VALUES("801","1","Admin Admin","","Updated borrower  with id:3","2021-01-28 10:19:47","2021-01-28 10:19:47","1");
INSERT INTO audit_trail VALUES("802","1","Admin Admin","","Added borrower  with id:617","2021-01-28 11:18:30","2021-01-28 11:18:30","1");
INSERT INTO audit_trail VALUES("803","1","Admin Admin","","Added expense with id:2","2021-01-28 11:25:35","2021-01-28 11:25:35","1");
INSERT INTO audit_trail VALUES("804","1","Admin Admin","","Added expense with id:3","2021-01-28 11:28:13","2021-01-28 11:28:13","1");
INSERT INTO audit_trail VALUES("805","1","Admin Admin","","Added expense with id:4","2021-01-28 11:29:13","2021-01-28 11:29:13","1");
INSERT INTO audit_trail VALUES("806","1","Admin Admin","","Added expense with id:5","2021-01-28 11:30:29","2021-01-28 11:30:29","1");
INSERT INTO audit_trail VALUES("807","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-01-28 11:33:03","2021-01-28 11:33:03","1");
INSERT INTO audit_trail VALUES("808","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-28 11:33:35","2021-01-28 11:33:35","1");
INSERT INTO audit_trail VALUES("809","1","Admin Admin","","Added expense with id:6","2021-01-28 11:37:18","2021-01-28 11:37:18","1");
INSERT INTO audit_trail VALUES("810","1","Admin Admin","","Added Capital  with id:6","2021-01-28 11:41:09","2021-01-28 11:41:09","1");
INSERT INTO audit_trail VALUES("811","1","Admin Admin","","Added Capital  with id:7","2021-01-28 11:44:38","2021-01-28 11:44:38","1");
INSERT INTO audit_trail VALUES("812","1","Admin Admin","","Added Capital  with id:8","2021-01-28 11:50:06","2021-01-28 11:50:06","1");
INSERT INTO audit_trail VALUES("813","1","Admin Admin","","Added Capital  with id:9","2021-01-28 11:53:22","2021-01-28 11:53:22","1");
INSERT INTO audit_trail VALUES("814","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-28 11:54:27","2021-01-28 11:54:27","1");
INSERT INTO audit_trail VALUES("815","1","Admin Admin","","Updated expense with id:3","2021-01-28 11:55:23","2021-01-28 11:55:23","1");
INSERT INTO audit_trail VALUES("816","1","Admin Admin","","Added Capital  with id:10","2021-01-28 12:16:32","2021-01-28 12:16:32","1");
INSERT INTO audit_trail VALUES("817","1","Admin Admin","","Updated Capital  with id:10","2021-01-28 12:18:03","2021-01-28 12:18:03","1");
INSERT INTO audit_trail VALUES("818","1","Admin Admin","","Added Capital  with id:11","2021-01-28 12:50:40","2021-01-28 12:50:40","1");
INSERT INTO audit_trail VALUES("819","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-28 13:52:18","2021-01-28 13:52:18","1");
INSERT INTO audit_trail VALUES("820","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-28 13:52:46","2021-01-28 13:52:46","1");
INSERT INTO audit_trail VALUES("821","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-29 04:29:00","2021-01-29 04:29:00","1");
INSERT INTO audit_trail VALUES("822","1","Admin Admin","","Updated user with id:3","2021-01-29 04:31:07","2021-01-29 04:31:07","1");
INSERT INTO audit_trail VALUES("823","1","Admin Admin","","Updated user with id:2","2021-01-29 04:32:01","2021-01-29 04:32:01","1");
INSERT INTO audit_trail VALUES("824","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-29 04:32:27","2021-01-29 04:32:27","");
INSERT INTO audit_trail VALUES("825","3","BERNICE  MUTHONI MUTUGI","","Added borrower  with id:618","2021-01-29 04:53:32","2021-01-29 04:53:32","1");
INSERT INTO audit_trail VALUES("826","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:148","2021-01-29 05:38:49","2021-01-29 05:38:49","1");
INSERT INTO audit_trail VALUES("827","2","CECILIA WANJERI WANGUHU","","Added loan with id:149","2021-01-29 05:41:46","2021-01-29 05:41:46","1");
INSERT INTO audit_trail VALUES("828","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:148","2021-01-29 05:42:24","2021-01-29 05:42:24","1");
INSERT INTO audit_trail VALUES("829","2","CECILIA WANJERI WANGUHU","","Approved loan with id:149","2021-01-29 05:42:49","2021-01-29 05:42:49","1");
INSERT INTO audit_trail VALUES("830","1","Admin Admin","","Logged out of system","2021-01-29 05:45:15","2021-01-29 05:45:15","1");
INSERT INTO audit_trail VALUES("831","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-01-29 05:45:50","2021-01-29 05:45:50","1");
INSERT INTO audit_trail VALUES("832","3","BERNICE  MUTHONI MUTUGI","","Updated role with id:4","2021-01-29 05:47:54","2021-01-29 05:47:54","1");
INSERT INTO audit_trail VALUES("833","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:149","2021-01-29 05:55:26","2021-01-29 05:55:26","1");
INSERT INTO audit_trail VALUES("834","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-01-29 07:04:05","2021-01-29 07:04:05","1");
INSERT INTO audit_trail VALUES("835","1","Admin Admin","","Logged in to system","2021-01-29 07:04:14","2021-01-29 07:04:14","1");
INSERT INTO audit_trail VALUES("836","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-01-29 09:51:40","2021-01-29 09:51:40","1");
INSERT INTO audit_trail VALUES("837","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-01-29 09:52:18","2021-01-29 09:52:18","1");
INSERT INTO audit_trail VALUES("838","1","Admin Admin","","Updated user with id:3","2021-01-29 09:53:42","2021-01-29 09:53:42","1");
INSERT INTO audit_trail VALUES("839","1","Admin Admin","","Updated user with id:2","2021-01-29 09:54:30","2021-01-29 09:54:30","1");
INSERT INTO audit_trail VALUES("840","1","Admin Admin","","Updated user with id:4","2021-01-29 09:55:06","2021-01-29 09:55:06","1");
INSERT INTO audit_trail VALUES("841","1","Admin Admin","","Logged out of system","2021-01-29 09:55:33","2021-01-29 09:55:33","1");
INSERT INTO audit_trail VALUES("842","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-01-29 09:55:57","2021-01-29 09:55:57","1");
INSERT INTO audit_trail VALUES("843","4","PERIS  NYAMBURA MWANGI","","Added loan with id:150","2021-01-29 10:00:16","2021-01-29 10:00:16","1");
INSERT INTO audit_trail VALUES("844","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:150","2021-01-29 10:00:51","2021-01-29 10:00:51","1");
INSERT INTO audit_trail VALUES("845","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:150","2021-01-29 10:01:57","2021-01-29 10:01:57","1");
INSERT INTO audit_trail VALUES("846","4","PERIS  NYAMBURA MWANGI","","Added expense with id:7","2021-01-29 10:47:39","2021-01-29 10:47:39","1");
INSERT INTO audit_trail VALUES("847","4","PERIS  NYAMBURA MWANGI","","Updated expense with id:7","2021-01-29 10:54:37","2021-01-29 10:54:37","1");
INSERT INTO audit_trail VALUES("848","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-01-29 11:06:30","2021-01-29 11:06:30","1");
INSERT INTO audit_trail VALUES("849","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-01-29 11:13:23","2021-01-29 11:13:23","1");
INSERT INTO audit_trail VALUES("850","1","Admin Admin","","Logged in to system","2021-01-30 02:22:08","2021-01-30 02:22:08","");
INSERT INTO audit_trail VALUES("851","1","Admin Admin","","Logged in to system","2021-01-30 02:43:13","2021-01-30 02:43:13","");
INSERT INTO audit_trail VALUES("852","1","Admin Admin","","Updated Settings","2021-01-30 02:47:28","2021-01-30 02:47:28","1");
INSERT INTO audit_trail VALUES("853","1","Admin Admin","","Logged in to system","2021-01-30 04:06:43","2021-01-30 04:06:43","1");
INSERT INTO audit_trail VALUES("854","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-01-30 04:07:44","2021-01-30 04:07:44","1");
INSERT INTO audit_trail VALUES("855","1","Admin Admin","","Added Capital  with id:12","2021-01-30 05:12:09","2021-01-30 05:12:09","1");
INSERT INTO audit_trail VALUES("856","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:13","2021-01-30 05:12:51","2021-01-30 05:12:51","1");
INSERT INTO audit_trail VALUES("857","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:14","2021-01-30 05:12:55","2021-01-30 05:12:55","1");
INSERT INTO audit_trail VALUES("858","1","Admin Admin","","Updated Settings","2021-01-30 06:01:58","2021-01-30 06:01:58","1");
INSERT INTO audit_trail VALUES("859","1","Admin Admin","","Deleted loan with id:148","2021-01-30 06:37:42","2021-01-30 06:37:42","1");
INSERT INTO audit_trail VALUES("860","1","Admin Admin","","Deleted loan with id:149","2021-01-30 06:37:59","2021-01-30 06:37:59","1");
INSERT INTO audit_trail VALUES("861","1","Admin Admin","","Deleted loan with id:150","2021-01-30 06:38:10","2021-01-30 06:38:10","1");
INSERT INTO audit_trail VALUES("862","1","Admin Admin","","Deleted borrower  with id:618","2021-01-30 06:38:58","2021-01-30 06:38:58","1");
INSERT INTO audit_trail VALUES("863","1","Admin Admin","","Added borrower  with id:619","2021-01-30 06:40:00","2021-01-30 06:40:00","1");
INSERT INTO audit_trail VALUES("864","1","Admin Admin","","Logged out of system","2021-01-30 06:54:45","2021-01-30 06:54:45","1");
INSERT INTO audit_trail VALUES("865","1","Admin Admin","","Logged in to system","2021-01-30 06:54:53","2021-01-30 06:54:53","1");
INSERT INTO audit_trail VALUES("866","1","Admin Admin","","Logged in to system","2021-01-30 07:10:48","2021-01-30 07:10:48","1");
INSERT INTO audit_trail VALUES("867","1","Admin Admin","","Logged in to system","2021-01-31 09:33:18","2021-01-31 09:33:18","");
INSERT INTO audit_trail VALUES("868","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-01 06:55:57","2021-02-01 06:55:57","");
INSERT INTO audit_trail VALUES("869","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:15","2021-02-01 08:52:54","2021-02-01 08:52:54","1");
INSERT INTO audit_trail VALUES("870","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-01 09:01:50","2021-02-01 09:01:50","");
INSERT INTO audit_trail VALUES("871","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-01 09:09:50","2021-02-01 09:09:50","1");
INSERT INTO audit_trail VALUES("872","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:8","2021-02-01 12:34:32","2021-02-01 12:34:32","1");
INSERT INTO audit_trail VALUES("873","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:16","2021-02-01 12:57:46","2021-02-01 12:57:46","1");
INSERT INTO audit_trail VALUES("874","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:17","2021-02-02 02:14:08","2021-02-02 02:14:08","1");
INSERT INTO audit_trail VALUES("875","1","Admin Admin","","Logged in to system","2021-02-02 02:20:15","2021-02-02 02:20:15","");
INSERT INTO audit_trail VALUES("876","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-02 08:20:01","2021-02-02 08:20:01","1");
INSERT INTO audit_trail VALUES("877","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-02 08:24:15","2021-02-02 08:24:15","1");
INSERT INTO audit_trail VALUES("878","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-02 09:44:42","2021-02-02 09:44:42","1");
INSERT INTO audit_trail VALUES("879","1","Admin Admin","","Logged in to system","2021-02-02 09:44:43","2021-02-02 09:44:43","");
INSERT INTO audit_trail VALUES("880","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:18","2021-02-02 10:01:28","2021-02-02 10:01:28","1");
INSERT INTO audit_trail VALUES("881","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-02 10:43:43","2021-02-02 10:43:43","1");
INSERT INTO audit_trail VALUES("882","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:19","2021-02-02 10:51:13","2021-02-02 10:51:13","1");
INSERT INTO audit_trail VALUES("883","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:9","2021-02-02 10:56:51","2021-02-02 10:56:51","1");
INSERT INTO audit_trail VALUES("884","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:10","2021-02-02 11:01:48","2021-02-02 11:01:48","1");
INSERT INTO audit_trail VALUES("885","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:11","2021-02-02 11:03:08","2021-02-02 11:03:08","1");
INSERT INTO audit_trail VALUES("886","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:12","2021-02-02 11:31:03","2021-02-02 11:31:03","1");
INSERT INTO audit_trail VALUES("887","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:20","2021-02-02 11:43:05","2021-02-02 11:43:05","1");
INSERT INTO audit_trail VALUES("888","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:21","2021-02-02 11:45:54","2021-02-02 11:45:54","1");
INSERT INTO audit_trail VALUES("889","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:22","2021-02-02 11:55:12","2021-02-02 11:55:12","1");
INSERT INTO audit_trail VALUES("890","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:23","2021-02-02 11:56:52","2021-02-02 11:56:52","1");
INSERT INTO audit_trail VALUES("891","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-02 12:19:41","2021-02-02 12:19:41","1");
INSERT INTO audit_trail VALUES("892","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-02 12:26:58","2021-02-02 12:26:58","");
INSERT INTO audit_trail VALUES("893","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:24","2021-02-02 12:28:53","2021-02-02 12:28:53","1");
INSERT INTO audit_trail VALUES("894","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:25","2021-02-02 12:49:08","2021-02-02 12:49:08","1");
INSERT INTO audit_trail VALUES("895","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:26","2021-02-02 12:50:28","2021-02-02 12:50:28","1");
INSERT INTO audit_trail VALUES("896","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-02 12:51:24","2021-02-02 12:51:24","1");
INSERT INTO audit_trail VALUES("897","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-02 12:51:47","2021-02-02 12:51:47","1");
INSERT INTO audit_trail VALUES("898","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-02 12:54:44","2021-02-02 12:54:44","1");
INSERT INTO audit_trail VALUES("899","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-03 01:15:02","2021-02-03 01:15:02","1");
INSERT INTO audit_trail VALUES("900","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:27","2021-02-03 01:19:19","2021-02-03 01:19:19","1");
INSERT INTO audit_trail VALUES("901","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-03 03:46:51","2021-02-03 03:46:51","1");
INSERT INTO audit_trail VALUES("902","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-03 06:35:57","2021-02-03 06:35:57","");
INSERT INTO audit_trail VALUES("903","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-03 06:49:21","2021-02-03 06:49:21","");
INSERT INTO audit_trail VALUES("904","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:28","2021-02-03 09:14:35","2021-02-03 09:14:35","1");
INSERT INTO audit_trail VALUES("905","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:29","2021-02-03 09:20:30","2021-02-03 09:20:30","1");
INSERT INTO audit_trail VALUES("906","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:30","2021-02-03 09:22:34","2021-02-03 09:22:34","1");
INSERT INTO audit_trail VALUES("907","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:31","2021-02-03 09:24:20","2021-02-03 09:24:20","1");
INSERT INTO audit_trail VALUES("908","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:13","2021-02-03 09:37:54","2021-02-03 09:37:54","1");
INSERT INTO audit_trail VALUES("909","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:14","2021-02-03 09:40:55","2021-02-03 09:40:55","1");
INSERT INTO audit_trail VALUES("910","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-03 10:06:56","2021-02-03 10:06:56","1");
INSERT INTO audit_trail VALUES("911","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:32","2021-02-04 00:23:41","2021-02-04 00:23:41","1");
INSERT INTO audit_trail VALUES("912","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-04 00:49:50","2021-02-04 00:49:50","1");
INSERT INTO audit_trail VALUES("913","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-04 01:06:02","2021-02-04 01:06:02","1");
INSERT INTO audit_trail VALUES("914","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-04 03:11:38","2021-02-04 03:11:38","1");
INSERT INTO audit_trail VALUES("915","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-04 03:24:00","2021-02-04 03:24:00","1");
INSERT INTO audit_trail VALUES("916","1","Admin Admin","","Logged in to system","2021-02-04 03:48:25","2021-02-04 03:48:25","");
INSERT INTO audit_trail VALUES("917","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-04 06:05:18","2021-02-04 06:05:18","1");
INSERT INTO audit_trail VALUES("918","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-04 06:07:24","2021-02-04 06:07:24","1");
INSERT INTO audit_trail VALUES("919","1","Admin Admin","","Logged in to system","2021-02-04 07:02:24","2021-02-04 07:02:24","1");
INSERT INTO audit_trail VALUES("920","1","Admin Admin","","Logged out of system","2021-02-04 07:03:18","2021-02-04 07:03:18","1");
INSERT INTO audit_trail VALUES("921","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-04 07:04:32","2021-02-04 07:04:32","1");
INSERT INTO audit_trail VALUES("922","1","Admin Admin","","Logged in to system","2021-02-04 07:30:28","2021-02-04 07:30:28","1");
INSERT INTO audit_trail VALUES("923","1","Admin Admin","","Logged in to system","2021-02-04 07:30:29","2021-02-04 07:30:29","1");
INSERT INTO audit_trail VALUES("924","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-04 07:37:56","2021-02-04 07:37:56","1");
INSERT INTO audit_trail VALUES("925","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-04 08:05:48","2021-02-04 08:05:48","1");
INSERT INTO audit_trail VALUES("926","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-04 08:39:11","2021-02-04 08:39:11","1");
INSERT INTO audit_trail VALUES("927","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-04 08:41:18","2021-02-04 08:41:18","1");
INSERT INTO audit_trail VALUES("928","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-04 08:47:30","2021-02-04 08:47:30","1");
INSERT INTO audit_trail VALUES("929","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:33","2021-02-04 09:48:03","2021-02-04 09:48:03","1");
INSERT INTO audit_trail VALUES("930","1","Admin Admin","","Logged in to system","2021-02-04 10:11:45","2021-02-04 10:11:45","1");
INSERT INTO audit_trail VALUES("931","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-04 10:41:39","2021-02-04 10:41:39","1");
INSERT INTO audit_trail VALUES("932","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-04 10:44:29","2021-02-04 10:44:29","1");
INSERT INTO audit_trail VALUES("933","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-05 00:44:57","2021-02-05 00:44:57","1");
INSERT INTO audit_trail VALUES("934","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:34","2021-02-05 00:48:09","2021-02-05 00:48:09","1");
INSERT INTO audit_trail VALUES("935","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-05 01:37:12","2021-02-05 01:37:12","1");
INSERT INTO audit_trail VALUES("936","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:15","2021-02-05 04:56:38","2021-02-05 04:56:38","1");
INSERT INTO audit_trail VALUES("937","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:16","2021-02-05 04:58:25","2021-02-05 04:58:25","1");
INSERT INTO audit_trail VALUES("938","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:17","2021-02-05 05:01:59","2021-02-05 05:01:59","1");
INSERT INTO audit_trail VALUES("939","1","Admin Admin","","Logged in to system","2021-02-05 06:04:29","2021-02-05 06:04:29","");
INSERT INTO audit_trail VALUES("940","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-05 06:13:37","2021-02-05 06:13:37","1");
INSERT INTO audit_trail VALUES("941","1","Admin Admin","","Logged in to system","2021-02-05 06:40:30","2021-02-05 06:40:30","");
INSERT INTO audit_trail VALUES("942","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:35","2021-02-05 08:55:39","2021-02-05 08:55:39","1");
INSERT INTO audit_trail VALUES("943","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:2554","2021-02-05 09:02:13","2021-02-05 09:02:13","1");
INSERT INTO audit_trail VALUES("944","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:2559","2021-02-05 09:06:27","2021-02-05 09:06:27","1");
INSERT INTO audit_trail VALUES("945","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:18","2021-02-05 09:09:25","2021-02-05 09:09:25","1");
INSERT INTO audit_trail VALUES("946","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:19","2021-02-05 09:46:39","2021-02-05 09:46:39","1");
INSERT INTO audit_trail VALUES("947","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-05 11:40:06","2021-02-05 11:40:06","1");
INSERT INTO audit_trail VALUES("948","1","Admin Admin","","Logged in to system","2021-02-06 04:05:49","2021-02-06 04:05:49","");
INSERT INTO audit_trail VALUES("949","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-06 04:57:15","2021-02-06 04:57:15","1");
INSERT INTO audit_trail VALUES("950","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:36","2021-02-06 05:04:06","2021-02-06 05:04:06","1");
INSERT INTO audit_trail VALUES("951","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-06 05:13:36","2021-02-06 05:13:36","1");
INSERT INTO audit_trail VALUES("952","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-06 05:43:59","2021-02-06 05:43:59","1");
INSERT INTO audit_trail VALUES("953","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-08 00:37:16","2021-02-08 00:37:16","");
INSERT INTO audit_trail VALUES("954","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:37","2021-02-08 00:39:01","2021-02-08 00:39:01","1");
INSERT INTO audit_trail VALUES("955","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-08 07:06:15","2021-02-08 07:06:15","");
INSERT INTO audit_trail VALUES("956","1","Admin Admin","","Logged in to system","2021-02-08 08:16:18","2021-02-08 08:16:18","");
INSERT INTO audit_trail VALUES("957","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:38","2021-02-08 09:41:22","2021-02-08 09:41:22","1");
INSERT INTO audit_trail VALUES("958","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:39","2021-02-08 09:42:20","2021-02-08 09:42:20","1");
INSERT INTO audit_trail VALUES("959","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:20","2021-02-08 09:43:50","2021-02-08 09:43:50","1");
INSERT INTO audit_trail VALUES("960","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:40","2021-02-08 09:50:31","2021-02-08 09:50:31","1");
INSERT INTO audit_trail VALUES("961","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:41","2021-02-08 09:53:29","2021-02-08 09:53:29","1");
INSERT INTO audit_trail VALUES("962","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:21","2021-02-08 10:05:02","2021-02-08 10:05:02","1");
INSERT INTO audit_trail VALUES("963","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-08 10:33:32","2021-02-08 10:33:32","1");
INSERT INTO audit_trail VALUES("964","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-09 00:20:34","2021-02-09 00:20:34","1");
INSERT INTO audit_trail VALUES("965","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:42","2021-02-09 01:43:51","2021-02-09 01:43:51","1");
INSERT INTO audit_trail VALUES("966","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:43","2021-02-09 01:48:51","2021-02-09 01:48:51","1");
INSERT INTO audit_trail VALUES("967","1","Admin Admin","","Logged in to system","2021-02-09 05:46:57","2021-02-09 05:46:57","");
INSERT INTO audit_trail VALUES("968","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:42","2021-02-09 05:59:02","2021-02-09 05:59:02","1");
INSERT INTO audit_trail VALUES("969","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:43","2021-02-09 06:01:15","2021-02-09 06:01:15","1");
INSERT INTO audit_trail VALUES("970","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:44","2021-02-09 06:03:21","2021-02-09 06:03:21","1");
INSERT INTO audit_trail VALUES("971","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:39","2021-02-09 06:57:44","2021-02-09 06:57:44","1");
INSERT INTO audit_trail VALUES("972","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:38","2021-02-09 06:59:25","2021-02-09 06:59:25","1");
INSERT INTO audit_trail VALUES("973","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:45","2021-02-09 07:02:09","2021-02-09 07:02:09","1");
INSERT INTO audit_trail VALUES("974","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:46","2021-02-09 07:03:53","2021-02-09 07:03:53","1");
INSERT INTO audit_trail VALUES("975","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:45","2021-02-09 07:07:32","2021-02-09 07:07:32","1");
INSERT INTO audit_trail VALUES("976","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:46","2021-02-09 07:08:17","2021-02-09 07:08:17","1");
INSERT INTO audit_trail VALUES("977","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:58","2021-02-09 07:21:37","2021-02-09 07:21:37","1");
INSERT INTO audit_trail VALUES("978","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:58","2021-02-09 07:24:17","2021-02-09 07:24:17","1");
INSERT INTO audit_trail VALUES("979","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:58","2021-02-09 07:24:43","2021-02-09 07:24:43","1");
INSERT INTO audit_trail VALUES("980","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:58","2021-02-09 07:25:24","2021-02-09 07:25:24","1");
INSERT INTO audit_trail VALUES("981","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:58","2021-02-09 07:26:25","2021-02-09 07:26:25","1");
INSERT INTO audit_trail VALUES("982","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:58","2021-02-09 07:27:47","2021-02-09 07:27:47","1");
INSERT INTO audit_trail VALUES("983","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:22","2021-02-09 10:17:34","2021-02-09 10:17:34","1");
INSERT INTO audit_trail VALUES("984","2","CECILIA WANJERI WANGUHU","","Added expense with id:23","2021-02-09 10:22:46","2021-02-09 10:22:46","1");
INSERT INTO audit_trail VALUES("985","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-09 11:07:12","2021-02-09 11:07:12","1");
INSERT INTO audit_trail VALUES("986","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-10 00:17:10","2021-02-10 00:17:10","1");
INSERT INTO audit_trail VALUES("987","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:47","2021-02-10 00:25:28","2021-02-10 00:25:28","1");
INSERT INTO audit_trail VALUES("988","1","Admin Admin","","Logged in to system","2021-02-10 01:41:10","2021-02-10 01:41:10","");
INSERT INTO audit_trail VALUES("989","1","Admin Admin","","Logged in to system","2021-02-10 01:49:26","2021-02-10 01:49:26","");
INSERT INTO audit_trail VALUES("990","1","Admin Admin","","Logged out of system","2021-02-10 01:50:28","2021-02-10 01:50:28","1");
INSERT INTO audit_trail VALUES("991","1","Admin Admin","","Logged in to system","2021-02-10 01:57:03","2021-02-10 01:57:03","1");
INSERT INTO audit_trail VALUES("992","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-10 02:01:17","2021-02-10 02:01:17","1");
INSERT INTO audit_trail VALUES("993","1","Admin Admin","","Logged in to system","2021-02-10 02:01:41","2021-02-10 02:01:41","1");
INSERT INTO audit_trail VALUES("994","1","Admin Admin","","Logged in to system","2021-02-10 02:01:44","2021-02-10 02:01:44","1");
INSERT INTO audit_trail VALUES("995","1","Admin Admin","","Logged in to system","2021-02-10 02:03:59","2021-02-10 02:03:59","");
INSERT INTO audit_trail VALUES("996","1","Admin Admin","","Logged in to system","2021-02-10 02:16:28","2021-02-10 02:16:28","1");
INSERT INTO audit_trail VALUES("997","1","Admin Admin","","Logged in to system","2021-02-10 02:17:13","2021-02-10 02:17:13","");
INSERT INTO audit_trail VALUES("998","1","Admin Admin","","Logged in to system","2021-02-10 02:18:35","2021-02-10 02:18:35","1");
INSERT INTO audit_trail VALUES("999","1","Admin Admin","","Logged in to system","2021-02-10 03:34:37","2021-02-10 03:34:37","");
INSERT INTO audit_trail VALUES("1000","1","Admin Admin","","Logged out of system","2021-02-10 03:34:39","2021-02-10 03:34:39","1");
INSERT INTO audit_trail VALUES("1001","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-10 03:34:56","2021-02-10 03:34:56","1");
INSERT INTO audit_trail VALUES("1002","1","Admin Admin","","Logged in to system","2021-02-10 03:35:55","2021-02-10 03:35:55","1");
INSERT INTO audit_trail VALUES("1003","1","Admin Admin","","Logged out of system","2021-02-10 03:36:59","2021-02-10 03:36:59","1");
INSERT INTO audit_trail VALUES("1004","1","Admin Admin","","Logged in to system","2021-02-10 03:37:42","2021-02-10 03:37:42","1");
INSERT INTO audit_trail VALUES("1005","1","Admin Admin","","Logged in to system","2021-02-10 03:39:11","2021-02-10 03:39:11","1");
INSERT INTO audit_trail VALUES("1006","1","Admin Admin","","Deleted user with id:6","2021-02-10 03:39:16","2021-02-10 03:39:16","1");
INSERT INTO audit_trail VALUES("1007","1","Admin Admin","","Added user with id:7","2021-02-10 03:41:36","2021-02-10 03:41:36","1");
INSERT INTO audit_trail VALUES("1008","1","Admin Admin","","Logged in to system","2021-02-10 03:43:56","2021-02-10 03:43:56","1");
INSERT INTO audit_trail VALUES("1009","1","Admin Admin","","Added user with id:8","2021-02-10 03:44:37","2021-02-10 03:44:37","1");
INSERT INTO audit_trail VALUES("1010","7","board 1","","Logged in to system","2021-02-10 03:45:28","2021-02-10 03:45:28","1");
INSERT INTO audit_trail VALUES("1011","7","board 1","","Logged in to system","2021-02-10 03:46:31","2021-02-10 03:46:31","1");
INSERT INTO audit_trail VALUES("1012","7","board 1","","Logged out of system","2021-02-10 03:46:57","2021-02-10 03:46:57","1");
INSERT INTO audit_trail VALUES("1013","8","board 2","","Logged in to system","2021-02-10 03:47:44","2021-02-10 03:47:44","1");
INSERT INTO audit_trail VALUES("1014","7","board 1","","Logged in to system","2021-02-10 03:48:54","2021-02-10 03:48:54","1");
INSERT INTO audit_trail VALUES("1015","1","Admin Admin","","Logged in to system","2021-02-10 04:02:30","2021-02-10 04:02:30","1");
INSERT INTO audit_trail VALUES("1016","1","Admin Admin","","Logged in to system","2021-02-10 04:02:31","2021-02-10 04:02:31","1");
INSERT INTO audit_trail VALUES("1017","1","Admin Admin","","Added loan with id:151","2021-02-10 04:02:53","2021-02-10 04:02:53","1");
INSERT INTO audit_trail VALUES("1018","1","Admin Admin","","Approved loan with id:151","2021-02-10 04:12:18","2021-02-10 04:12:18","1");
INSERT INTO audit_trail VALUES("1019","1","Admin Admin","","Disbursed loan with id:151","2021-02-10 04:12:51","2021-02-10 04:12:51","1");
INSERT INTO audit_trail VALUES("1020","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-10 04:20:17","2021-02-10 04:20:17","");
INSERT INTO audit_trail VALUES("1021","1","Admin Admin","","Logged out of system","2021-02-10 06:34:52","2021-02-10 06:34:52","1");
INSERT INTO audit_trail VALUES("1022","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-10 06:37:30","2021-02-10 06:37:30","1");
INSERT INTO audit_trail VALUES("1023","1","Admin Admin","","Logged in to system","2021-02-10 06:41:12","2021-02-10 06:41:12","1");
INSERT INTO audit_trail VALUES("1024","1","Admin Admin","","Logged in to system","2021-02-10 08:04:57","2021-02-10 08:04:57","1");
INSERT INTO audit_trail VALUES("1025","1","Admin Admin","","Logged in to system","2021-02-10 08:04:57","2021-02-10 08:04:57","1");
INSERT INTO audit_trail VALUES("1026","1","Admin Admin","","Logged in to system","2021-02-10 08:04:58","2021-02-10 08:04:58","1");
INSERT INTO audit_trail VALUES("1027","1","Admin Admin","","Logged in to system","2021-02-10 08:04:58","2021-02-10 08:04:58","1");
INSERT INTO audit_trail VALUES("1028","1","Admin Admin","","Logged in to system","2021-02-10 08:04:58","2021-02-10 08:04:58","1");
INSERT INTO audit_trail VALUES("1029","1","Admin Admin","","Logged in to system","2021-02-10 08:05:00","2021-02-10 08:05:00","1");
INSERT INTO audit_trail VALUES("1030","1","Admin Admin","","Logged in to system","2021-02-10 08:05:00","2021-02-10 08:05:00","1");
INSERT INTO audit_trail VALUES("1031","1","Admin Admin","","Logged in to system","2021-02-10 08:05:00","2021-02-10 08:05:00","1");
INSERT INTO audit_trail VALUES("1032","1","Admin Admin","","Logged in to system","2021-02-10 08:05:02","2021-02-10 08:05:02","1");
INSERT INTO audit_trail VALUES("1033","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-10 08:06:49","2021-02-10 08:06:49","1");
INSERT INTO audit_trail VALUES("1034","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-10 08:14:41","2021-02-10 08:14:41","1");
INSERT INTO audit_trail VALUES("1035","2","CECILIA WANJERI WANGUHU","","Added expense with id:24","2021-02-10 08:33:15","2021-02-10 08:33:15","1");
INSERT INTO audit_trail VALUES("1036","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-10 09:18:00","2021-02-10 09:18:00","1");
INSERT INTO audit_trail VALUES("1037","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-10 23:57:36","2021-02-10 23:57:36","1");
INSERT INTO audit_trail VALUES("1038","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-10 23:57:38","2021-02-10 23:57:38","1");
INSERT INTO audit_trail VALUES("1039","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:48","2021-02-11 00:49:32","2021-02-11 00:49:32","1");
INSERT INTO audit_trail VALUES("1040","1","Admin Admin","","Logged in to system","2021-02-11 05:27:40","2021-02-11 05:27:40","");
INSERT INTO audit_trail VALUES("1041","1","Admin Admin","","Logged out of system","2021-02-11 06:42:58","2021-02-11 06:42:58","1");
INSERT INTO audit_trail VALUES("1042","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-11 06:43:14","2021-02-11 06:43:14","1");
INSERT INTO audit_trail VALUES("1043","1","Admin Admin","","Logged in to system","2021-02-11 07:52:56","2021-02-11 07:52:56","");
INSERT INTO audit_trail VALUES("1044","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:152","2021-02-11 10:02:19","2021-02-11 10:02:19","1");
INSERT INTO audit_trail VALUES("1045","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:152","2021-02-11 10:03:19","2021-02-11 10:03:19","1");
INSERT INTO audit_trail VALUES("1046","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:152","2021-02-11 10:03:19","2021-02-11 10:03:19","1");
INSERT INTO audit_trail VALUES("1047","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:152","2021-02-11 10:03:27","2021-02-11 10:03:27","1");
INSERT INTO audit_trail VALUES("1048","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:152","2021-02-11 10:03:43","2021-02-11 10:03:43","1");
INSERT INTO audit_trail VALUES("1049","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:152","2021-02-11 10:04:00","2021-02-11 10:04:00","1");
INSERT INTO audit_trail VALUES("1050","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:153","2021-02-11 10:15:07","2021-02-11 10:15:07","1");
INSERT INTO audit_trail VALUES("1051","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:153","2021-02-11 10:15:33","2021-02-11 10:15:33","1");
INSERT INTO audit_trail VALUES("1052","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:153","2021-02-11 10:16:07","2021-02-11 10:16:07","1");
INSERT INTO audit_trail VALUES("1053","1","Admin Admin","","Added repayment for loan with id:153","2021-02-11 10:34:45","2021-02-11 10:34:45","1");
INSERT INTO audit_trail VALUES("1054","1","Admin Admin","","Added repayment for loan with id:153","2021-02-11 10:37:08","2021-02-11 10:37:08","1");
INSERT INTO audit_trail VALUES("1055","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:25","2021-02-11 11:07:05","2021-02-11 11:07:05","1");
INSERT INTO audit_trail VALUES("1056","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:49","2021-02-11 11:10:09","2021-02-11 11:10:09","1");
INSERT INTO audit_trail VALUES("1057","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:50","2021-02-11 11:11:57","2021-02-11 11:11:57","1");
INSERT INTO audit_trail VALUES("1058","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-11 11:51:48","2021-02-11 11:51:48","1");
INSERT INTO audit_trail VALUES("1059","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:51","2021-02-12 00:19:14","2021-02-12 00:19:14","1");
INSERT INTO audit_trail VALUES("1060","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-12 00:25:51","2021-02-12 00:25:51","1");
INSERT INTO audit_trail VALUES("1061","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-12 00:26:17","2021-02-12 00:26:17","1");
INSERT INTO audit_trail VALUES("1062","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-12 05:44:07","2021-02-12 05:44:07","1");
INSERT INTO audit_trail VALUES("1063","1","Admin Admin","","Logged in to system","2021-02-12 05:45:52","2021-02-12 05:45:52","");
INSERT INTO audit_trail VALUES("1064","1","Admin Admin","","Logged out of system","2021-02-12 05:48:54","2021-02-12 05:48:54","1");
INSERT INTO audit_trail VALUES("1065","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-12 05:51:07","2021-02-12 05:51:07","1");
INSERT INTO audit_trail VALUES("1066","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-12 06:13:03","2021-02-12 06:13:03","1");
INSERT INTO audit_trail VALUES("1067","1","Admin Admin","","Logged in to system","2021-02-12 06:18:29","2021-02-12 06:18:29","");
INSERT INTO audit_trail VALUES("1068","1","Admin Admin","","Logged in to system","2021-02-12 06:21:26","2021-02-12 06:21:26","1");
INSERT INTO audit_trail VALUES("1069","1","Admin Admin","","Logged in to system","2021-02-12 06:21:27","2021-02-12 06:21:27","1");
INSERT INTO audit_trail VALUES("1070","1","Admin Admin","","Logged in to system","2021-02-12 06:21:27","2021-02-12 06:21:27","1");
INSERT INTO audit_trail VALUES("1071","1","Admin Admin","","Logged out of system","2021-02-12 06:23:48","2021-02-12 06:23:48","1");
INSERT INTO audit_trail VALUES("1072","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-12 06:24:27","2021-02-12 06:24:27","1");
INSERT INTO audit_trail VALUES("1073","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:3294","2021-02-12 06:37:17","2021-02-12 06:37:17","1");
INSERT INTO audit_trail VALUES("1074","1","Admin Admin","","Logged in to system","2021-02-12 06:52:57","2021-02-12 06:52:57","1");
INSERT INTO audit_trail VALUES("1075","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-12 07:37:21","2021-02-12 07:37:21","1");
INSERT INTO audit_trail VALUES("1076","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-12 08:11:14","2021-02-12 08:11:14","1");
INSERT INTO audit_trail VALUES("1077","1","Admin Admin","","Logged in to system","2021-02-12 08:15:48","2021-02-12 08:15:48","1");
INSERT INTO audit_trail VALUES("1078","1","Admin Admin","","Logged in to system","2021-02-12 08:33:19","2021-02-12 08:33:19","1");
INSERT INTO audit_trail VALUES("1079","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-12 08:51:56","2021-02-12 08:51:56","1");
INSERT INTO audit_trail VALUES("1080","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-12 08:52:09","2021-02-12 08:52:09","1");
INSERT INTO audit_trail VALUES("1081","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-12 08:52:09","2021-02-12 08:52:09","1");
INSERT INTO audit_trail VALUES("1082","1","Admin Admin","","Undisbursed loan with id:5","2021-02-12 08:53:38","2021-02-12 08:53:38","1");
INSERT INTO audit_trail VALUES("1083","1","Admin Admin","","Unapproved loan with id:5","2021-02-12 08:53:55","2021-02-12 08:53:55","1");
INSERT INTO audit_trail VALUES("1084","1","Admin Admin","","Updated loan with id:5","2021-02-12 08:54:21","2021-02-12 08:54:21","1");
INSERT INTO audit_trail VALUES("1085","1","Admin Admin","","Approved loan with id:5","2021-02-12 08:54:48","2021-02-12 08:54:48","1");
INSERT INTO audit_trail VALUES("1086","1","Admin Admin","","Disbursed loan with id:5","2021-02-12 08:55:06","2021-02-12 08:55:06","1");
INSERT INTO audit_trail VALUES("1087","1","Admin Admin","","Added repayment for loan with id:5","2021-02-12 08:56:23","2021-02-12 08:56:23","1");
INSERT INTO audit_trail VALUES("1088","1","Admin Admin","","Added repayment for loan with id:5","2021-02-12 08:56:48","2021-02-12 08:56:48","1");
INSERT INTO audit_trail VALUES("1089","1","Admin Admin","","Undisbursed loan with id:5","2021-02-12 08:59:29","2021-02-12 08:59:29","1");
INSERT INTO audit_trail VALUES("1090","1","Admin Admin","","Unapproved loan with id:5","2021-02-12 08:59:40","2021-02-12 08:59:40","1");
INSERT INTO audit_trail VALUES("1091","1","Admin Admin","","Updated loan product with id:1","2021-02-12 09:00:32","2021-02-12 09:00:32","1");
INSERT INTO audit_trail VALUES("1092","1","Admin Admin","","Approved loan with id:5","2021-02-12 09:01:08","2021-02-12 09:01:08","1");
INSERT INTO audit_trail VALUES("1093","1","Admin Admin","","Disbursed loan with id:5","2021-02-12 09:01:21","2021-02-12 09:01:21","1");
INSERT INTO audit_trail VALUES("1094","1","Admin Admin","","Undisbursed loan with id:5","2021-02-12 09:02:06","2021-02-12 09:02:06","1");
INSERT INTO audit_trail VALUES("1095","1","Admin Admin","","Updated loan with id:5","2021-02-12 09:10:48","2021-02-12 09:10:48","1");
INSERT INTO audit_trail VALUES("1096","1","Admin Admin","","Disbursed loan with id:5","2021-02-12 09:11:18","2021-02-12 09:11:18","1");
INSERT INTO audit_trail VALUES("1097","1","Admin Admin","","Added repayment for loan with id:5","2021-02-12 09:11:58","2021-02-12 09:11:58","1");
INSERT INTO audit_trail VALUES("1098","1","Admin Admin","","Added expense with id:26","2021-02-12 09:16:51","2021-02-12 09:16:51","1");
INSERT INTO audit_trail VALUES("1099","1","Admin Admin","","Added expense with id:27","2021-02-12 09:18:47","2021-02-12 09:18:47","1");
INSERT INTO audit_trail VALUES("1100","1","Admin Admin","","Added Capital  with id:52","2021-02-12 09:29:13","2021-02-12 09:29:13","1");
INSERT INTO audit_trail VALUES("1101","1","Admin Admin","","Added Capital  with id:53","2021-02-12 09:31:07","2021-02-12 09:31:07","1");
INSERT INTO audit_trail VALUES("1102","1","Admin Admin","","Added Capital  with id:54","2021-02-12 09:32:49","2021-02-12 09:32:49","1");
INSERT INTO audit_trail VALUES("1103","1","Admin Admin","","Added expense with id:28","2021-02-12 09:34:40","2021-02-12 09:34:40","1");
INSERT INTO audit_trail VALUES("1104","1","Admin Admin","","Added Capital  with id:55","2021-02-12 09:36:25","2021-02-12 09:36:25","1");
INSERT INTO audit_trail VALUES("1105","1","Admin Admin","","Added Capital  with id:56","2021-02-12 09:58:10","2021-02-12 09:58:10","1");
INSERT INTO audit_trail VALUES("1106","1","Admin Admin","","Undisbursed loan with id:5","2021-02-12 09:58:30","2021-02-12 09:58:30","1");
INSERT INTO audit_trail VALUES("1107","1","Admin Admin","","Unapproved loan with id:5","2021-02-12 09:58:56","2021-02-12 09:58:56","1");
INSERT INTO audit_trail VALUES("1108","1","Admin Admin","","Updated loan with id:5","2021-02-12 10:16:48","2021-02-12 10:16:48","1");
INSERT INTO audit_trail VALUES("1109","1","Admin Admin","","Approved loan with id:5","2021-02-12 10:17:24","2021-02-12 10:17:24","1");
INSERT INTO audit_trail VALUES("1110","1","Admin Admin","","Disbursed loan with id:5","2021-02-12 10:17:36","2021-02-12 10:17:36","1");
INSERT INTO audit_trail VALUES("1111","1","Admin Admin","","Undisbursed loan with id:5","2021-02-12 10:19:32","2021-02-12 10:19:32","1");
INSERT INTO audit_trail VALUES("1112","1","Admin Admin","","Unapproved loan with id:5","2021-02-12 10:19:44","2021-02-12 10:19:44","1");
INSERT INTO audit_trail VALUES("1113","1","Admin Admin","","Updated loan with id:5","2021-02-12 10:22:00","2021-02-12 10:22:00","1");
INSERT INTO audit_trail VALUES("1114","1","Admin Admin","","Approved loan with id:5","2021-02-12 10:23:17","2021-02-12 10:23:17","1");
INSERT INTO audit_trail VALUES("1115","1","Admin Admin","","Disbursed loan with id:5","2021-02-12 10:23:28","2021-02-12 10:23:28","1");
INSERT INTO audit_trail VALUES("1116","1","Admin Admin","","Added expense with id:29","2021-02-12 10:31:56","2021-02-12 10:31:56","1");
INSERT INTO audit_trail VALUES("1117","1","Admin Admin","","Added loan with id:154","2021-02-12 10:42:38","2021-02-12 10:42:38","1");
INSERT INTO audit_trail VALUES("1118","1","Admin Admin","","Approved loan with id:154","2021-02-12 10:43:04","2021-02-12 10:43:04","1");
INSERT INTO audit_trail VALUES("1119","1","Admin Admin","","Disbursed loan with id:154","2021-02-12 10:43:19","2021-02-12 10:43:19","1");
INSERT INTO audit_trail VALUES("1120","1","Admin Admin","","Added repayment for loan with id:58","2021-02-12 10:46:05","2021-02-12 10:46:05","1");
INSERT INTO audit_trail VALUES("1121","1","Admin Admin","","Added loan with id:155","2021-02-12 10:50:19","2021-02-12 10:50:19","1");
INSERT INTO audit_trail VALUES("1122","1","Admin Admin","","Approved loan with id:155","2021-02-12 10:50:47","2021-02-12 10:50:47","1");
INSERT INTO audit_trail VALUES("1123","1","Admin Admin","","Disbursed loan with id:155","2021-02-12 10:50:57","2021-02-12 10:50:57","1");
INSERT INTO audit_trail VALUES("1124","1","Admin Admin","","Disbursed loan with id:155","2021-02-12 10:50:58","2021-02-12 10:50:58","1");
INSERT INTO audit_trail VALUES("1125","1","Admin Admin","","Undisbursed loan with id:155","2021-02-12 10:51:24","2021-02-12 10:51:24","1");
INSERT INTO audit_trail VALUES("1126","1","Admin Admin","","Disbursed loan with id:155","2021-02-12 10:51:36","2021-02-12 10:51:36","1");
INSERT INTO audit_trail VALUES("1127","1","Admin Admin","","Logged out of system","2021-02-12 10:53:11","2021-02-12 10:53:11","1");
INSERT INTO audit_trail VALUES("1128","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-12 10:53:35","2021-02-12 10:53:35","1");
INSERT INTO audit_trail VALUES("1129","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-12 10:53:36","2021-02-12 10:53:36","1");
INSERT INTO audit_trail VALUES("1130","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-12 10:58:13","2021-02-12 10:58:13","1");
INSERT INTO audit_trail VALUES("1131","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-13 01:02:51","2021-02-13 01:02:51","1");
INSERT INTO audit_trail VALUES("1132","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:57","2021-02-13 01:14:20","2021-02-13 01:14:20","1");
INSERT INTO audit_trail VALUES("1133","1","Admin Admin","","Logged in to system","2021-02-13 01:18:48","2021-02-13 01:18:48","1");
INSERT INTO audit_trail VALUES("1134","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:30","2021-02-13 03:14:45","2021-02-13 03:14:45","1");
INSERT INTO audit_trail VALUES("1135","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:58","2021-02-13 03:16:17","2021-02-13 03:16:17","1");
INSERT INTO audit_trail VALUES("1136","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:59","2021-02-13 03:17:35","2021-02-13 03:17:35","1");
INSERT INTO audit_trail VALUES("1137","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:60","2021-02-13 03:19:08","2021-02-13 03:19:08","1");
INSERT INTO audit_trail VALUES("1138","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:31","2021-02-13 05:05:22","2021-02-13 05:05:22","1");
INSERT INTO audit_trail VALUES("1139","1","Admin Admin","","Logged in to system","2021-02-13 05:10:00","2021-02-13 05:10:00","");
INSERT INTO audit_trail VALUES("1140","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:61","2021-02-13 05:17:14","2021-02-13 05:17:14","1");
INSERT INTO audit_trail VALUES("1141","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-13 05:53:43","2021-02-13 05:53:43","1");
INSERT INTO audit_trail VALUES("1142","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-15 01:45:58","2021-02-15 01:45:58","");
INSERT INTO audit_trail VALUES("1143","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:62","2021-02-15 02:16:41","2021-02-15 02:16:41","1");
INSERT INTO audit_trail VALUES("1144","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-15 02:36:33","2021-02-15 02:36:33","");
INSERT INTO audit_trail VALUES("1145","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-15 03:09:32","2021-02-15 03:09:32","1");
INSERT INTO audit_trail VALUES("1146","1","Admin Admin","","Logged in to system","2021-02-15 03:09:38","2021-02-15 03:09:38","1");
INSERT INTO audit_trail VALUES("1147","1","Admin Admin","","Deleted user with id:7","2021-02-15 03:12:07","2021-02-15 03:12:07","1");
INSERT INTO audit_trail VALUES("1148","1","Admin Admin","","Deleted user with id:8","2021-02-15 03:12:27","2021-02-15 03:12:27","1");
INSERT INTO audit_trail VALUES("1149","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-15 03:16:29","2021-02-15 03:16:29","1");
INSERT INTO audit_trail VALUES("1150","1","Admin Admin","","Logged in to system","2021-02-15 06:17:54","2021-02-15 06:17:54","");
INSERT INTO audit_trail VALUES("1151","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-15 08:34:18","2021-02-15 08:34:18","");
INSERT INTO audit_trail VALUES("1152","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:156","2021-02-15 08:38:55","2021-02-15 08:38:55","1");
INSERT INTO audit_trail VALUES("1153","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:156","2021-02-15 08:59:19","2021-02-15 08:59:19","1");
INSERT INTO audit_trail VALUES("1154","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-15 09:23:56","2021-02-15 09:23:56","1");
INSERT INTO audit_trail VALUES("1155","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:156","2021-02-15 09:38:39","2021-02-15 09:38:39","1");
INSERT INTO audit_trail VALUES("1156","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:32","2021-02-15 09:47:49","2021-02-15 09:47:49","1");
INSERT INTO audit_trail VALUES("1157","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:33","2021-02-15 09:50:57","2021-02-15 09:50:57","1");
INSERT INTO audit_trail VALUES("1158","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:34","2021-02-15 09:52:46","2021-02-15 09:52:46","1");
INSERT INTO audit_trail VALUES("1159","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:35","2021-02-15 09:54:21","2021-02-15 09:54:21","1");
INSERT INTO audit_trail VALUES("1160","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:36","2021-02-15 09:55:44","2021-02-15 09:55:44","1");
INSERT INTO audit_trail VALUES("1161","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:37","2021-02-15 09:55:44","2021-02-15 09:55:44","1");
INSERT INTO audit_trail VALUES("1162","1","Admin Admin","","Deleted expense with id:37","2021-02-15 11:11:22","2021-02-15 11:11:22","1");
INSERT INTO audit_trail VALUES("1163","1","Admin Admin","","Logged out of system","2021-02-15 11:12:54","2021-02-15 11:12:54","1");
INSERT INTO audit_trail VALUES("1164","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-15 11:13:17","2021-02-15 11:13:17","1");
INSERT INTO audit_trail VALUES("1165","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-15 11:15:16","2021-02-15 11:15:16","1");
INSERT INTO audit_trail VALUES("1166","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-16 00:53:07","2021-02-16 00:53:07","1");
INSERT INTO audit_trail VALUES("1167","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:63","2021-02-16 01:03:51","2021-02-16 01:03:51","1");
INSERT INTO audit_trail VALUES("1168","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:38","2021-02-16 06:28:20","2021-02-16 06:28:20","1");
INSERT INTO audit_trail VALUES("1169","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:39","2021-02-16 06:30:43","2021-02-16 06:30:43","1");
INSERT INTO audit_trail VALUES("1170","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:64","2021-02-16 06:32:52","2021-02-16 06:32:52","1");
INSERT INTO audit_trail VALUES("1171","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:40","2021-02-16 06:59:41","2021-02-16 06:59:41","1");
INSERT INTO audit_trail VALUES("1172","1","Admin Admin","","Logged in to system","2021-02-16 07:18:34","2021-02-16 07:18:34","");
INSERT INTO audit_trail VALUES("1173","1","Admin Admin","","Logged in to system","2021-02-16 07:20:48","2021-02-16 07:20:48","");
INSERT INTO audit_trail VALUES("1174","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:65","2021-02-16 07:34:27","2021-02-16 07:34:27","1");
INSERT INTO audit_trail VALUES("1175","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:66","2021-02-16 07:35:52","2021-02-16 07:35:52","1");
INSERT INTO audit_trail VALUES("1176","1","Admin Admin","","Logged out of system","2021-02-16 07:44:21","2021-02-16 07:44:21","1");
INSERT INTO audit_trail VALUES("1177","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-16 07:44:42","2021-02-16 07:44:42","1");
INSERT INTO audit_trail VALUES("1178","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-16 07:51:22","2021-02-16 07:51:22","1");
INSERT INTO audit_trail VALUES("1179","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-16 07:51:23","2021-02-16 07:51:23","1");
INSERT INTO audit_trail VALUES("1180","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-16 09:16:38","2021-02-16 09:16:38","1");
INSERT INTO audit_trail VALUES("1181","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-16 09:17:04","2021-02-16 09:17:04","1");
INSERT INTO audit_trail VALUES("1182","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-16 09:17:40","2021-02-16 09:17:40","1");
INSERT INTO audit_trail VALUES("1183","2","CECILIA WANJERI WANGUHU","","Updated expense with id:38","2021-02-16 09:19:09","2021-02-16 09:19:09","1");
INSERT INTO audit_trail VALUES("1184","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:41","2021-02-16 09:19:43","2021-02-16 09:19:43","1");
INSERT INTO audit_trail VALUES("1185","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-16 09:42:41","2021-02-16 09:42:41","1");
INSERT INTO audit_trail VALUES("1186","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:67","2021-02-17 00:46:37","2021-02-17 00:46:37","1");
INSERT INTO audit_trail VALUES("1187","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-17 04:28:51","2021-02-17 04:28:51","1");
INSERT INTO audit_trail VALUES("1188","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-17 06:01:52","2021-02-17 06:01:52","");
INSERT INTO audit_trail VALUES("1189","1","Admin Admin","","Logged in to system","2021-02-17 06:09:02","2021-02-17 06:09:02","");
INSERT INTO audit_trail VALUES("1190","1","Admin Admin","","Logged out of system","2021-02-17 06:15:24","2021-02-17 06:15:24","1");
INSERT INTO audit_trail VALUES("1191","1","Admin Admin","","Logged in to system","2021-02-17 06:15:35","2021-02-17 06:15:35","1");
INSERT INTO audit_trail VALUES("1192","1","Admin Admin","","Logged out of system","2021-02-17 06:16:31","2021-02-17 06:16:31","1");
INSERT INTO audit_trail VALUES("1193","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-17 06:16:57","2021-02-17 06:16:57","1");
INSERT INTO audit_trail VALUES("1194","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:14","2021-02-17 06:25:52","2021-02-17 06:25:52","1");
INSERT INTO audit_trail VALUES("1195","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:14","2021-02-17 06:26:13","2021-02-17 06:26:13","1");
INSERT INTO audit_trail VALUES("1196","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:14","2021-02-17 06:29:34","2021-02-17 06:29:34","1");
INSERT INTO audit_trail VALUES("1197","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:14","2021-02-17 06:30:17","2021-02-17 06:30:17","1");
INSERT INTO audit_trail VALUES("1198","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:14","2021-02-17 06:30:45","2021-02-17 06:30:45","1");
INSERT INTO audit_trail VALUES("1199","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-17 06:33:25","2021-02-17 06:33:25","");
INSERT INTO audit_trail VALUES("1200","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:15","2021-02-17 06:34:35","2021-02-17 06:34:35","1");
INSERT INTO audit_trail VALUES("1201","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:15","2021-02-17 06:34:56","2021-02-17 06:34:56","1");
INSERT INTO audit_trail VALUES("1202","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:15","2021-02-17 06:36:16","2021-02-17 06:36:16","1");
INSERT INTO audit_trail VALUES("1203","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:15","2021-02-17 06:36:59","2021-02-17 06:36:59","1");
INSERT INTO audit_trail VALUES("1204","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:15","2021-02-17 06:37:19","2021-02-17 06:37:19","1");
INSERT INTO audit_trail VALUES("1205","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:35","2021-02-17 07:14:38","2021-02-17 07:14:38","1");
INSERT INTO audit_trail VALUES("1206","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:35","2021-02-17 07:15:03","2021-02-17 07:15:03","1");
INSERT INTO audit_trail VALUES("1207","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:35","2021-02-17 07:16:10","2021-02-17 07:16:10","1");
INSERT INTO audit_trail VALUES("1208","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:35","2021-02-17 07:17:11","2021-02-17 07:17:11","1");
INSERT INTO audit_trail VALUES("1209","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:35","2021-02-17 07:17:22","2021-02-17 07:17:22","1");
INSERT INTO audit_trail VALUES("1210","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-17 07:57:10","2021-02-17 07:57:10","1");
INSERT INTO audit_trail VALUES("1211","1","Admin Admin","","Logged in to system","2021-02-17 07:57:24","2021-02-17 07:57:24","1");
INSERT INTO audit_trail VALUES("1212","1","Admin Admin","","Added repayment for loan with id:35","2021-02-17 08:00:13","2021-02-17 08:00:13","1");
INSERT INTO audit_trail VALUES("1213","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-17 08:02:03","2021-02-17 08:02:03","1");
INSERT INTO audit_trail VALUES("1214","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-17 08:05:10","2021-02-17 08:05:10","1");
INSERT INTO audit_trail VALUES("1215","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-17 08:09:33","2021-02-17 08:09:33","1");
INSERT INTO audit_trail VALUES("1216","1","Admin Admin","","Undisbursed loan with id:28","2021-02-17 08:22:32","2021-02-17 08:22:32","1");
INSERT INTO audit_trail VALUES("1217","1","Admin Admin","","Unapproved loan with id:28","2021-02-17 08:22:57","2021-02-17 08:22:57","1");
INSERT INTO audit_trail VALUES("1218","1","Admin Admin","","Updated loan with id:28","2021-02-17 08:23:55","2021-02-17 08:23:55","1");
INSERT INTO audit_trail VALUES("1219","1","Admin Admin","","Approved loan with id:28","2021-02-17 08:25:00","2021-02-17 08:25:00","1");
INSERT INTO audit_trail VALUES("1220","1","Admin Admin","","Disbursed loan with id:28","2021-02-17 08:25:14","2021-02-17 08:25:14","1");
INSERT INTO audit_trail VALUES("1221","1","Admin Admin","","Added repayment for loan with id:28","2021-02-17 08:26:29","2021-02-17 08:26:29","1");
INSERT INTO audit_trail VALUES("1222","1","Admin Admin","","Undisbursed loan with id:124","2021-02-17 08:39:39","2021-02-17 08:39:39","1");
INSERT INTO audit_trail VALUES("1223","1","Admin Admin","","Unapproved loan with id:124","2021-02-17 08:39:54","2021-02-17 08:39:54","1");
INSERT INTO audit_trail VALUES("1224","1","Admin Admin","","Updated loan with id:124","2021-02-17 08:41:33","2021-02-17 08:41:33","1");
INSERT INTO audit_trail VALUES("1225","1","Admin Admin","","Approved loan with id:124","2021-02-17 08:42:25","2021-02-17 08:42:25","1");
INSERT INTO audit_trail VALUES("1226","1","Admin Admin","","Disbursed loan with id:124","2021-02-17 08:42:41","2021-02-17 08:42:41","1");
INSERT INTO audit_trail VALUES("1227","1","Admin Admin","","Added repayment for loan with id:124","2021-02-17 08:44:18","2021-02-17 08:44:18","1");
INSERT INTO audit_trail VALUES("1228","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:68","2021-02-17 08:52:59","2021-02-17 08:52:59","1");
INSERT INTO audit_trail VALUES("1229","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:69","2021-02-17 08:54:09","2021-02-17 08:54:09","1");
INSERT INTO audit_trail VALUES("1230","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:42","2021-02-17 08:55:46","2021-02-17 08:55:46","1");
INSERT INTO audit_trail VALUES("1231","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:43","2021-02-17 08:56:42","2021-02-17 08:56:42","1");
INSERT INTO audit_trail VALUES("1232","1","Admin Admin","","Undisbursed loan with id:73","2021-02-17 08:57:44","2021-02-17 08:57:44","1");
INSERT INTO audit_trail VALUES("1233","1","Admin Admin","","Unapproved loan with id:73","2021-02-17 08:57:55","2021-02-17 08:57:55","1");
INSERT INTO audit_trail VALUES("1234","1","Admin Admin","","Updated loan with id:73","2021-02-17 08:58:40","2021-02-17 08:58:40","1");
INSERT INTO audit_trail VALUES("1235","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:44","2021-02-17 08:58:46","2021-02-17 08:58:46","1");
INSERT INTO audit_trail VALUES("1236","1","Admin Admin","","Approved loan with id:73","2021-02-17 09:00:25","2021-02-17 09:00:25","1");
INSERT INTO audit_trail VALUES("1237","1","Admin Admin","","Disbursed loan with id:73","2021-02-17 09:07:00","2021-02-17 09:07:00","1");
INSERT INTO audit_trail VALUES("1238","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:45","2021-02-17 09:45:08","2021-02-17 09:45:08","1");
INSERT INTO audit_trail VALUES("1239","1","Admin Admin","","Undisbursed loan with id:154","2021-02-17 09:47:57","2021-02-17 09:47:57","1");
INSERT INTO audit_trail VALUES("1240","1","Admin Admin","","Unapproved loan with id:154","2021-02-17 09:48:10","2021-02-17 09:48:10","1");
INSERT INTO audit_trail VALUES("1241","1","Admin Admin","","Updated loan with id:154","2021-02-17 09:48:36","2021-02-17 09:48:36","1");
INSERT INTO audit_trail VALUES("1242","1","Admin Admin","","Approved loan with id:154","2021-02-17 09:49:03","2021-02-17 09:49:03","1");
INSERT INTO audit_trail VALUES("1243","1","Admin Admin","","Disbursed loan with id:154","2021-02-17 09:49:15","2021-02-17 09:49:15","1");
INSERT INTO audit_trail VALUES("1244","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-17 09:56:29","2021-02-17 09:56:29","1");
INSERT INTO audit_trail VALUES("1245","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-17 09:56:46","2021-02-17 09:56:46","1");
INSERT INTO audit_trail VALUES("1246","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-17 10:33:58","2021-02-17 10:33:58","1");
INSERT INTO audit_trail VALUES("1247","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-18 01:06:01","2021-02-18 01:06:01","1");
INSERT INTO audit_trail VALUES("1248","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-18 01:29:37","2021-02-18 01:29:37","1");
INSERT INTO audit_trail VALUES("1249","1","Admin Admin","","Logged in to system","2021-02-18 01:39:15","2021-02-18 01:39:15","");
INSERT INTO audit_trail VALUES("1250","1","Admin Admin","","Logged in to system","2021-02-18 01:39:16","2021-02-18 01:39:16","");
INSERT INTO audit_trail VALUES("1251","1","Admin Admin","","Logged out of system","2021-02-18 01:39:56","2021-02-18 01:39:56","1");
INSERT INTO audit_trail VALUES("1252","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-18 01:40:13","2021-02-18 01:40:13","1");
INSERT INTO audit_trail VALUES("1253","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-18 02:16:11","2021-02-18 02:16:11","1");
INSERT INTO audit_trail VALUES("1254","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-18 02:21:31","2021-02-18 02:21:31","1");
INSERT INTO audit_trail VALUES("1255","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:70","2021-02-18 02:23:51","2021-02-18 02:23:51","1");
INSERT INTO audit_trail VALUES("1256","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 02:41:39","2021-02-18 02:41:39","1");
INSERT INTO audit_trail VALUES("1257","1","Admin Admin","","Logged in to system","2021-02-18 02:52:14","2021-02-18 02:52:14","1");
INSERT INTO audit_trail VALUES("1258","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 04:21:15","2021-02-18 04:21:15","1");
INSERT INTO audit_trail VALUES("1259","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 07:12:26","2021-02-18 07:12:26","");
INSERT INTO audit_trail VALUES("1260","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-18 07:24:29","2021-02-18 07:24:29","1");
INSERT INTO audit_trail VALUES("1261","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 07:25:05","2021-02-18 07:25:05","1");
INSERT INTO audit_trail VALUES("1262","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 07:25:48","2021-02-18 07:25:48","1");
INSERT INTO audit_trail VALUES("1263","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 07:25:51","2021-02-18 07:25:51","1");
INSERT INTO audit_trail VALUES("1264","1","Admin Admin","","Logged in to system","2021-02-18 07:26:58","2021-02-18 07:26:58","1");
INSERT INTO audit_trail VALUES("1265","1","Admin Admin","","Added repayment for loan with id:154","2021-02-18 07:30:48","2021-02-18 07:30:48","1");
INSERT INTO audit_trail VALUES("1266","1","Admin Admin","","Added repayment for loan with id:154","2021-02-18 07:33:29","2021-02-18 07:33:29","1");
INSERT INTO audit_trail VALUES("1267","1","Admin Admin","","Undisbursed loan with id:44","2021-02-18 07:46:50","2021-02-18 07:46:50","1");
INSERT INTO audit_trail VALUES("1268","1","Admin Admin","","Unapproved loan with id:44","2021-02-18 07:47:06","2021-02-18 07:47:06","1");
INSERT INTO audit_trail VALUES("1269","1","Admin Admin","","Updated loan with id:44","2021-02-18 07:48:39","2021-02-18 07:48:39","1");
INSERT INTO audit_trail VALUES("1270","1","Admin Admin","","Updated loan with id:44","2021-02-18 07:49:55","2021-02-18 07:49:55","1");
INSERT INTO audit_trail VALUES("1271","1","Admin Admin","","Approved loan with id:44","2021-02-18 07:51:34","2021-02-18 07:51:34","1");
INSERT INTO audit_trail VALUES("1272","1","Admin Admin","","Disbursed loan with id:44","2021-02-18 07:51:48","2021-02-18 07:51:48","1");
INSERT INTO audit_trail VALUES("1273","1","Admin Admin","","Undisbursed loan with id:21","2021-02-18 08:05:40","2021-02-18 08:05:40","1");
INSERT INTO audit_trail VALUES("1274","1","Admin Admin","","Unapproved loan with id:21","2021-02-18 08:05:53","2021-02-18 08:05:53","1");
INSERT INTO audit_trail VALUES("1275","1","Admin Admin","","Updated loan with id:21","2021-02-18 08:06:55","2021-02-18 08:06:55","1");
INSERT INTO audit_trail VALUES("1276","1","Admin Admin","","Approved loan with id:21","2021-02-18 08:08:17","2021-02-18 08:08:17","1");
INSERT INTO audit_trail VALUES("1277","1","Admin Admin","","Disbursed loan with id:21","2021-02-18 08:08:31","2021-02-18 08:08:31","1");
INSERT INTO audit_trail VALUES("1278","1","Admin Admin","","Undisbursed loan with id:141","2021-02-18 08:12:03","2021-02-18 08:12:03","1");
INSERT INTO audit_trail VALUES("1279","1","Admin Admin","","Unapproved loan with id:141","2021-02-18 08:12:37","2021-02-18 08:12:37","1");
INSERT INTO audit_trail VALUES("1280","1","Admin Admin","","Updated loan with id:141","2021-02-18 08:13:33","2021-02-18 08:13:33","1");
INSERT INTO audit_trail VALUES("1281","1","Admin Admin","","Approved loan with id:141","2021-02-18 08:15:02","2021-02-18 08:15:02","1");
INSERT INTO audit_trail VALUES("1282","1","Admin Admin","","Disbursed loan with id:141","2021-02-18 08:20:01","2021-02-18 08:20:01","1");
INSERT INTO audit_trail VALUES("1283","1","Admin Admin","","Logged out of system","2021-02-18 08:24:07","2021-02-18 08:24:07","1");
INSERT INTO audit_trail VALUES("1284","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-18 08:54:41","2021-02-18 08:54:41","1");
INSERT INTO audit_trail VALUES("1285","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 09:01:12","2021-02-18 09:01:12","1");
INSERT INTO audit_trail VALUES("1286","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:88","2021-02-18 09:11:32","2021-02-18 09:11:32","1");
INSERT INTO audit_trail VALUES("1287","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:88","2021-02-18 09:12:11","2021-02-18 09:12:11","1");
INSERT INTO audit_trail VALUES("1288","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:88","2021-02-18 09:12:52","2021-02-18 09:12:52","1");
INSERT INTO audit_trail VALUES("1289","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:88","2021-02-18 09:23:23","2021-02-18 09:23:23","1");
INSERT INTO audit_trail VALUES("1290","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:88","2021-02-18 09:25:53","2021-02-18 09:25:53","1");
INSERT INTO audit_trail VALUES("1291","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:6","2021-02-18 09:31:44","2021-02-18 09:31:44","1");
INSERT INTO audit_trail VALUES("1292","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:6","2021-02-18 09:32:03","2021-02-18 09:32:03","1");
INSERT INTO audit_trail VALUES("1293","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:6","2021-02-18 09:32:54","2021-02-18 09:32:54","1");
INSERT INTO audit_trail VALUES("1294","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:6","2021-02-18 09:33:42","2021-02-18 09:33:42","1");
INSERT INTO audit_trail VALUES("1295","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:6","2021-02-18 09:34:14","2021-02-18 09:34:14","1");
INSERT INTO audit_trail VALUES("1296","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-18 09:35:23","2021-02-18 09:35:23","1");
INSERT INTO audit_trail VALUES("1297","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 09:36:32","2021-02-18 09:36:32","1");
INSERT INTO audit_trail VALUES("1298","1","Admin Admin","","Logged in to system","2021-02-18 09:37:30","2021-02-18 09:37:30","1");
INSERT INTO audit_trail VALUES("1299","2","CECILIA WANJERI WANGUHU","","Added expense with id:46","2021-02-18 09:39:22","2021-02-18 09:39:22","1");
INSERT INTO audit_trail VALUES("1300","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 09:39:58","2021-02-18 09:39:58","1");
INSERT INTO audit_trail VALUES("1301","1","Admin Admin","","Added repayment for loan with id:6","2021-02-18 09:40:02","2021-02-18 09:40:02","1");
INSERT INTO audit_trail VALUES("1302","1","Admin Admin","","Added repayment for loan with id:6","2021-02-18 09:40:49","2021-02-18 09:40:49","1");
INSERT INTO audit_trail VALUES("1303","1","Admin Admin","","Deleted loan with id:56","2021-02-18 09:42:06","2021-02-18 09:42:06","1");
INSERT INTO audit_trail VALUES("1304","1","Admin Admin","","Undisbursed loan with id:105","2021-02-18 09:44:43","2021-02-18 09:44:43","1");
INSERT INTO audit_trail VALUES("1305","1","Admin Admin","","Unapproved loan with id:105","2021-02-18 09:45:14","2021-02-18 09:45:14","1");
INSERT INTO audit_trail VALUES("1306","1","Admin Admin","","Updated loan with id:105","2021-02-18 09:45:58","2021-02-18 09:45:58","1");
INSERT INTO audit_trail VALUES("1307","1","Admin Admin","","Updated loan with id:105","2021-02-18 09:45:59","2021-02-18 09:45:59","1");
INSERT INTO audit_trail VALUES("1308","1","Admin Admin","","Approved loan with id:105","2021-02-18 09:47:13","2021-02-18 09:47:13","1");
INSERT INTO audit_trail VALUES("1309","1","Admin Admin","","Disbursed loan with id:105","2021-02-18 09:47:42","2021-02-18 09:47:42","1");
INSERT INTO audit_trail VALUES("1310","1","Admin Admin","","Logged in to system","2021-02-18 09:59:06","2021-02-18 09:59:06","");
INSERT INTO audit_trail VALUES("1311","1","Admin Admin","","Undisbursed loan with id:10","2021-02-18 10:20:07","2021-02-18 10:20:07","1");
INSERT INTO audit_trail VALUES("1312","1","Admin Admin","","Unapproved loan with id:10","2021-02-18 10:20:37","2021-02-18 10:20:37","1");
INSERT INTO audit_trail VALUES("1313","1","Admin Admin","","Updated loan with id:10","2021-02-18 10:21:32","2021-02-18 10:21:32","1");
INSERT INTO audit_trail VALUES("1314","1","Admin Admin","","Approved loan with id:10","2021-02-18 10:22:40","2021-02-18 10:22:40","1");
INSERT INTO audit_trail VALUES("1315","1","Admin Admin","","Disbursed loan with id:10","2021-02-18 10:23:05","2021-02-18 10:23:05","1");
INSERT INTO audit_trail VALUES("1316","1","Admin Admin","","Undisbursed loan with id:28","2021-02-18 10:25:39","2021-02-18 10:25:39","1");
INSERT INTO audit_trail VALUES("1317","1","Admin Admin","","Unapproved loan with id:28","2021-02-18 10:26:06","2021-02-18 10:26:06","1");
INSERT INTO audit_trail VALUES("1318","1","Admin Admin","","Approved loan with id:28","2021-02-18 10:27:13","2021-02-18 10:27:13","1");
INSERT INTO audit_trail VALUES("1319","1","Admin Admin","","Disbursed loan with id:28","2021-02-18 10:27:41","2021-02-18 10:27:41","1");
INSERT INTO audit_trail VALUES("1320","1","Admin Admin","","Added repayment for loan with id:28","2021-02-18 10:30:18","2021-02-18 10:30:18","1");
INSERT INTO audit_trail VALUES("1321","1","Admin Admin","","Undisbursed loan with id:85","2021-02-18 10:32:11","2021-02-18 10:32:11","1");
INSERT INTO audit_trail VALUES("1322","1","Admin Admin","","Unapproved loan with id:85","2021-02-18 10:32:27","2021-02-18 10:32:27","1");
INSERT INTO audit_trail VALUES("1323","1","Admin Admin","","Updated loan with id:85","2021-02-18 10:33:41","2021-02-18 10:33:41","1");
INSERT INTO audit_trail VALUES("1324","1","Admin Admin","","Approved loan with id:85","2021-02-18 10:34:36","2021-02-18 10:34:36","1");
INSERT INTO audit_trail VALUES("1325","1","Admin Admin","","Disbursed loan with id:85","2021-02-18 10:34:48","2021-02-18 10:34:48","1");
INSERT INTO audit_trail VALUES("1326","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-18 10:35:25","2021-02-18 10:35:25","1");
INSERT INTO audit_trail VALUES("1327","1","Admin Admin","","Logged in to system","2021-02-18 10:35:32","2021-02-18 10:35:32","1");
INSERT INTO audit_trail VALUES("1328","1","Admin Admin","","Added repayment for loan with id:85","2021-02-18 10:35:35","2021-02-18 10:35:35","1");
INSERT INTO audit_trail VALUES("1329","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-18 10:35:43","2021-02-18 10:35:43","1");
INSERT INTO audit_trail VALUES("1330","1","Admin Admin","","Updated role with id:1","2021-02-18 10:38:16","2021-02-18 10:38:16","1");
INSERT INTO audit_trail VALUES("1331","1","Admin Admin","","Updated role with id:1","2021-02-18 10:39:01","2021-02-18 10:39:01","1");
INSERT INTO audit_trail VALUES("1332","1","Admin Admin","","Undisbursed loan with id:7","2021-02-18 10:39:45","2021-02-18 10:39:45","1");
INSERT INTO audit_trail VALUES("1333","1","Admin Admin","","Unapproved loan with id:7","2021-02-18 10:40:14","2021-02-18 10:40:14","1");
INSERT INTO audit_trail VALUES("1334","1","Admin Admin","","Logged out of system","2021-02-18 10:40:57","2021-02-18 10:40:57","1");
INSERT INTO audit_trail VALUES("1335","1","Admin Admin","","Logged in to system","2021-02-18 10:42:12","2021-02-18 10:42:12","1");
INSERT INTO audit_trail VALUES("1336","1","Admin Admin","","Logged out of system","2021-02-18 10:42:28","2021-02-18 10:42:28","1");
INSERT INTO audit_trail VALUES("1337","1","Admin Admin","","Logged in to system","2021-02-18 10:42:40","2021-02-18 10:42:40","1");
INSERT INTO audit_trail VALUES("1338","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-18 10:42:46","2021-02-18 10:42:46","1");
INSERT INTO audit_trail VALUES("1339","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-18 10:52:54","2021-02-18 10:52:54","");
INSERT INTO audit_trail VALUES("1340","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:620","2021-02-18 10:53:41","2021-02-18 10:53:41","1");
INSERT INTO audit_trail VALUES("1341","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-18 12:12:44","2021-02-18 12:12:44","1");
INSERT INTO audit_trail VALUES("1342","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:71","2021-02-19 00:13:53","2021-02-19 00:13:53","1");
INSERT INTO audit_trail VALUES("1343","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:72","2021-02-19 00:16:01","2021-02-19 00:16:01","1");
INSERT INTO audit_trail VALUES("1344","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-19 01:10:17","2021-02-19 01:10:17","1");
INSERT INTO audit_trail VALUES("1345","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-19 02:30:17","2021-02-19 02:30:17","1");
INSERT INTO audit_trail VALUES("1346","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:73","2021-02-19 02:31:56","2021-02-19 02:31:56","1");
INSERT INTO audit_trail VALUES("1347","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:74","2021-02-19 06:49:56","2021-02-19 06:49:56","1");
INSERT INTO audit_trail VALUES("1348","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:75","2021-02-19 06:50:53","2021-02-19 06:50:53","1");
INSERT INTO audit_trail VALUES("1349","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:76","2021-02-19 06:52:10","2021-02-19 06:52:10","1");
INSERT INTO audit_trail VALUES("1350","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:77","2021-02-19 06:53:29","2021-02-19 06:53:29","1");
INSERT INTO audit_trail VALUES("1351","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:47","2021-02-19 06:55:02","2021-02-19 06:55:02","1");
INSERT INTO audit_trail VALUES("1352","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:48","2021-02-19 06:56:03","2021-02-19 06:56:03","1");
INSERT INTO audit_trail VALUES("1353","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:49","2021-02-19 06:58:14","2021-02-19 06:58:14","1");
INSERT INTO audit_trail VALUES("1354","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:50","2021-02-19 06:59:15","2021-02-19 06:59:15","1");
INSERT INTO audit_trail VALUES("1355","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:51","2021-02-19 07:01:59","2021-02-19 07:01:59","1");
INSERT INTO audit_trail VALUES("1356","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-19 08:27:50","2021-02-19 08:27:50","");
INSERT INTO audit_trail VALUES("1357","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-19 08:52:03","2021-02-19 08:52:03","1");
INSERT INTO audit_trail VALUES("1358","1","Admin Admin","","Logged in to system","2021-02-19 08:52:27","2021-02-19 08:52:27","1");
INSERT INTO audit_trail VALUES("1359","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-19 08:52:44","2021-02-19 08:52:44","1");
INSERT INTO audit_trail VALUES("1360","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-19 09:23:52","2021-02-19 09:23:52","1");
INSERT INTO audit_trail VALUES("1361","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:52","2021-02-19 09:25:54","2021-02-19 09:25:54","1");
INSERT INTO audit_trail VALUES("1362","1","Admin Admin","","Logged in to system","2021-02-19 09:25:56","2021-02-19 09:25:56","");
INSERT INTO audit_trail VALUES("1363","1","Admin Admin","","Logged out of system","2021-02-19 09:30:13","2021-02-19 09:30:13","1");
INSERT INTO audit_trail VALUES("1364","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-19 09:30:37","2021-02-19 09:30:37","1");
INSERT INTO audit_trail VALUES("1365","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-19 09:33:32","2021-02-19 09:33:32","1");
INSERT INTO audit_trail VALUES("1366","1","Admin Admin","","Logged in to system","2021-02-19 09:34:08","2021-02-19 09:34:08","1");
INSERT INTO audit_trail VALUES("1367","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-20 01:08:43","2021-02-20 01:08:43","1");
INSERT INTO audit_trail VALUES("1368","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:78","2021-02-20 03:29:24","2021-02-20 03:29:24","1");
INSERT INTO audit_trail VALUES("1369","2","CECILIA WANJERI WANGUHU","","Added expense with id:53","2021-02-20 05:16:15","2021-02-20 05:16:15","1");
INSERT INTO audit_trail VALUES("1370","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-20 05:19:12","2021-02-20 05:19:12","1");
INSERT INTO audit_trail VALUES("1371","1","Admin Admin","","Logged out of system","2021-02-20 09:36:57","2021-02-20 09:36:57","1");
INSERT INTO audit_trail VALUES("1372","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-20 09:37:16","2021-02-20 09:37:16","1");
INSERT INTO audit_trail VALUES("1373","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-20 09:39:31","2021-02-20 09:39:31","1");
INSERT INTO audit_trail VALUES("1374","1","Admin Admin","","Logged in to system","2021-02-20 09:44:48","2021-02-20 09:44:48","1");
INSERT INTO audit_trail VALUES("1375","1","Admin Admin","","Logged out of system","2021-02-20 15:53:29","2021-02-20 15:53:29","1");
INSERT INTO audit_trail VALUES("1376","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-20 15:53:43","2021-02-20 15:53:43","1");
INSERT INTO audit_trail VALUES("1377","1","Admin Admin","","Logged in to system","2021-02-21 12:17:59","2021-02-21 12:17:59","");
INSERT INTO audit_trail VALUES("1378","1","Admin Admin","","Logged in to system","2021-02-21 14:48:29","2021-02-21 14:48:29","");
INSERT INTO audit_trail VALUES("1379","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-22 00:58:59","2021-02-22 00:58:59","");
INSERT INTO audit_trail VALUES("1380","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-22 01:54:23","2021-02-22 01:54:23","");
INSERT INTO audit_trail VALUES("1381","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-22 02:38:34","2021-02-22 02:38:34","");
INSERT INTO audit_trail VALUES("1382","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:79","2021-02-22 02:40:59","2021-02-22 02:40:59","1");
INSERT INTO audit_trail VALUES("1383","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:157","2021-02-22 02:50:25","2021-02-22 02:50:25","1");
INSERT INTO audit_trail VALUES("1384","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:157","2021-02-22 02:52:20","2021-02-22 02:52:20","1");
INSERT INTO audit_trail VALUES("1385","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:157","2021-02-22 02:53:47","2021-02-22 02:53:47","1");
INSERT INTO audit_trail VALUES("1386","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:7","2021-02-22 02:56:22","2021-02-22 02:56:22","1");
INSERT INTO audit_trail VALUES("1387","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:7","2021-02-22 02:57:26","2021-02-22 02:57:26","1");
INSERT INTO audit_trail VALUES("1388","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:158","2021-02-22 03:03:20","2021-02-22 03:03:20","1");
INSERT INTO audit_trail VALUES("1389","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:158","2021-02-22 03:05:50","2021-02-22 03:05:50","1");
INSERT INTO audit_trail VALUES("1390","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:158","2021-02-22 03:06:32","2021-02-22 03:06:32","1");
INSERT INTO audit_trail VALUES("1391","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:159","2021-02-22 03:09:43","2021-02-22 03:09:43","1");
INSERT INTO audit_trail VALUES("1392","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:159","2021-02-22 03:10:48","2021-02-22 03:10:48","1");
INSERT INTO audit_trail VALUES("1393","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:159","2021-02-22 03:11:25","2021-02-22 03:11:25","1");
INSERT INTO audit_trail VALUES("1394","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-22 07:15:33","2021-02-22 07:15:33","");
INSERT INTO audit_trail VALUES("1395","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:54","2021-02-22 08:47:55","2021-02-22 08:47:55","1");
INSERT INTO audit_trail VALUES("1396","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:55","2021-02-22 08:49:03","2021-02-22 08:49:03","1");
INSERT INTO audit_trail VALUES("1397","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:56","2021-02-22 08:50:34","2021-02-22 08:50:34","1");
INSERT INTO audit_trail VALUES("1398","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:80","2021-02-22 08:52:04","2021-02-22 08:52:04","1");
INSERT INTO audit_trail VALUES("1399","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:81","2021-02-22 08:53:30","2021-02-22 08:53:30","1");
INSERT INTO audit_trail VALUES("1400","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:82","2021-02-22 08:55:38","2021-02-22 08:55:38","1");
INSERT INTO audit_trail VALUES("1401","1","Admin Admin","","Deleted loan with id:152","2021-02-22 09:26:36","2021-02-22 09:26:36","1");
INSERT INTO audit_trail VALUES("1402","1","Admin Admin","","Deleted loan with id:5","2021-02-22 09:26:54","2021-02-22 09:26:54","1");
INSERT INTO audit_trail VALUES("1403","1","Admin Admin","","Deleted loan with id:154","2021-02-22 09:27:09","2021-02-22 09:27:09","1");
INSERT INTO audit_trail VALUES("1404","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:57","2021-02-22 09:32:38","2021-02-22 09:32:38","1");
INSERT INTO audit_trail VALUES("1405","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-22 10:17:09","2021-02-22 10:17:09","1");
INSERT INTO audit_trail VALUES("1406","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-23 00:23:30","2021-02-23 00:23:30","1");
INSERT INTO audit_trail VALUES("1407","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:83","2021-02-23 02:26:49","2021-02-23 02:26:49","1");
INSERT INTO audit_trail VALUES("1408","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:84","2021-02-23 02:31:44","2021-02-23 02:31:44","1");
INSERT INTO audit_trail VALUES("1409","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-23 03:41:41","2021-02-23 03:41:41","1");
INSERT INTO audit_trail VALUES("1410","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-23 03:44:30","2021-02-23 03:44:30","1");
INSERT INTO audit_trail VALUES("1411","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-23 03:48:54","2021-02-23 03:48:54","1");
INSERT INTO audit_trail VALUES("1412","1","Admin Admin","","Logged in to system","2021-02-23 03:49:41","2021-02-23 03:49:41","1");
INSERT INTO audit_trail VALUES("1413","1","Admin Admin","","Logged out of system","2021-02-23 03:51:58","2021-02-23 03:51:58","1");
INSERT INTO audit_trail VALUES("1414","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-23 03:52:17","2021-02-23 03:52:17","1");
INSERT INTO audit_trail VALUES("1415","1","Admin Admin","","Logged in to system","2021-02-23 05:43:09","2021-02-23 05:43:09","");
INSERT INTO audit_trail VALUES("1416","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-23 08:38:10","2021-02-23 08:38:10","");
INSERT INTO audit_trail VALUES("1417","1","Admin Admin","","Logged in to system","2021-02-23 09:02:29","2021-02-23 09:02:29","1");
INSERT INTO audit_trail VALUES("1418","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-23 10:07:10","2021-02-23 10:07:10","1");
INSERT INTO audit_trail VALUES("1419","1","Admin Admin","","Added loan with id:160","2021-02-23 10:07:14","2021-02-23 10:07:14","1");
INSERT INTO audit_trail VALUES("1420","1","Admin Admin","","Approved loan with id:154","2021-02-23 10:09:07","2021-02-23 10:09:07","1");
INSERT INTO audit_trail VALUES("1421","1","Admin Admin","","Disbursed loan with id:154","2021-02-23 10:09:32","2021-02-23 10:09:32","1");
INSERT INTO audit_trail VALUES("1422","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:58","2021-02-23 10:50:52","2021-02-23 10:50:52","1");
INSERT INTO audit_trail VALUES("1423","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:59","2021-02-23 11:12:03","2021-02-23 11:12:03","1");
INSERT INTO audit_trail VALUES("1424","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:58","2021-02-23 11:14:21","2021-02-23 11:14:21","1");
INSERT INTO audit_trail VALUES("1425","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-23 11:25:14","2021-02-23 11:25:14","1");
INSERT INTO audit_trail VALUES("1426","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-24 00:36:01","2021-02-24 00:36:01","1");
INSERT INTO audit_trail VALUES("1427","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:85","2021-02-24 00:53:29","2021-02-24 00:53:29","1");
INSERT INTO audit_trail VALUES("1428","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:86","2021-02-24 00:55:52","2021-02-24 00:55:52","1");
INSERT INTO audit_trail VALUES("1429","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:87","2021-02-24 00:59:28","2021-02-24 00:59:28","1");
INSERT INTO audit_trail VALUES("1430","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-24 02:00:34","2021-02-24 02:00:34","");
INSERT INTO audit_trail VALUES("1431","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-24 06:15:56","2021-02-24 06:15:56","");
INSERT INTO audit_trail VALUES("1432","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:78","2021-02-24 07:25:45","2021-02-24 07:25:45","1");
INSERT INTO audit_trail VALUES("1433","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:78","2021-02-24 07:26:34","2021-02-24 07:26:34","1");
INSERT INTO audit_trail VALUES("1434","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:78","2021-02-24 07:27:28","2021-02-24 07:27:28","1");
INSERT INTO audit_trail VALUES("1435","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:78","2021-02-24 07:28:16","2021-02-24 07:28:16","1");
INSERT INTO audit_trail VALUES("1436","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:78","2021-02-24 07:28:28","2021-02-24 07:28:28","1");
INSERT INTO audit_trail VALUES("1437","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-02-24 07:30:13","2021-02-24 07:30:13","1");
INSERT INTO audit_trail VALUES("1438","1","Admin Admin","","Logged in to system","2021-02-24 07:30:45","2021-02-24 07:30:45","1");
INSERT INTO audit_trail VALUES("1439","1","Admin Admin","","Added repayment for loan with id:78","2021-02-24 07:32:05","2021-02-24 07:32:05","1");
INSERT INTO audit_trail VALUES("1440","1","Admin Admin","","Undisbursed loan with id:103","2021-02-24 07:33:47","2021-02-24 07:33:47","1");
INSERT INTO audit_trail VALUES("1441","1","Admin Admin","","Disbursed loan with id:103","2021-02-24 07:34:18","2021-02-24 07:34:18","1");
INSERT INTO audit_trail VALUES("1442","1","Admin Admin","","Undisbursed loan with id:24","2021-02-24 07:42:04","2021-02-24 07:42:04","1");
INSERT INTO audit_trail VALUES("1443","1","Admin Admin","","Unapproved loan with id:24","2021-02-24 07:42:20","2021-02-24 07:42:20","1");
INSERT INTO audit_trail VALUES("1444","1","Admin Admin","","Updated loan with id:24","2021-02-24 07:42:53","2021-02-24 07:42:53","1");
INSERT INTO audit_trail VALUES("1445","1","Admin Admin","","Approved loan with id:24","2021-02-24 07:50:58","2021-02-24 07:50:58","1");
INSERT INTO audit_trail VALUES("1446","1","Admin Admin","","Approved loan with id:24","2021-02-24 07:50:58","2021-02-24 07:50:58","1");
INSERT INTO audit_trail VALUES("1447","1","Admin Admin","","Approved loan with id:24","2021-02-24 07:50:58","2021-02-24 07:50:58","1");
INSERT INTO audit_trail VALUES("1448","1","Admin Admin","","Disbursed loan with id:24","2021-02-24 07:51:12","2021-02-24 07:51:12","1");
INSERT INTO audit_trail VALUES("1449","1","Admin Admin","","Added repayment for loan with id:24","2021-02-24 07:53:16","2021-02-24 07:53:16","1");
INSERT INTO audit_trail VALUES("1450","1","Admin Admin","","Undisbursed loan with id:95","2021-02-24 08:05:45","2021-02-24 08:05:45","1");
INSERT INTO audit_trail VALUES("1451","1","Admin Admin","","Unapproved loan with id:95","2021-02-24 08:05:57","2021-02-24 08:05:57","1");
INSERT INTO audit_trail VALUES("1452","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-24 08:06:42","2021-02-24 08:06:42","1");
INSERT INTO audit_trail VALUES("1453","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-24 08:06:43","2021-02-24 08:06:43","1");
INSERT INTO audit_trail VALUES("1454","1","Admin Admin","","Updated loan with id:95","2021-02-24 08:07:24","2021-02-24 08:07:24","1");
INSERT INTO audit_trail VALUES("1455","1","Admin Admin","","Approved loan with id:95","2021-02-24 08:09:12","2021-02-24 08:09:12","1");
INSERT INTO audit_trail VALUES("1456","1","Admin Admin","","Disbursed loan with id:95","2021-02-24 08:09:49","2021-02-24 08:09:49","1");
INSERT INTO audit_trail VALUES("1457","1","Admin Admin","","Added repayment for loan with id:95","2021-02-24 08:10:28","2021-02-24 08:10:28","1");
INSERT INTO audit_trail VALUES("1458","1","Admin Admin","","Added loan with id:161","2021-02-24 08:11:13","2021-02-24 08:11:13","1");
INSERT INTO audit_trail VALUES("1459","1","Admin Admin","","Added repayment for loan with id:95","2021-02-24 08:11:54","2021-02-24 08:11:54","1");
INSERT INTO audit_trail VALUES("1460","1","Admin Admin","","Undisbursed loan with id:41","2021-02-24 08:14:58","2021-02-24 08:14:58","1");
INSERT INTO audit_trail VALUES("1461","1","Admin Admin","","Unapproved loan with id:41","2021-02-24 08:15:44","2021-02-24 08:15:44","1");
INSERT INTO audit_trail VALUES("1462","1","Admin Admin","","Approved loan with id:41","2021-02-24 08:16:01","2021-02-24 08:16:01","1");
INSERT INTO audit_trail VALUES("1463","1","Admin Admin","","Approved loan with id:41","2021-02-24 08:16:02","2021-02-24 08:16:02","1");
INSERT INTO audit_trail VALUES("1464","1","Admin Admin","","Unapproved loan with id:41","2021-02-24 08:16:15","2021-02-24 08:16:15","1");
INSERT INTO audit_trail VALUES("1465","1","Admin Admin","","Updated loan with id:41","2021-02-24 08:17:03","2021-02-24 08:17:03","1");
INSERT INTO audit_trail VALUES("1466","1","Admin Admin","","Approved loan with id:41","2021-02-24 08:17:45","2021-02-24 08:17:45","1");
INSERT INTO audit_trail VALUES("1467","1","Admin Admin","","Logged out of system","2021-02-24 08:25:46","2021-02-24 08:25:46","1");
INSERT INTO audit_trail VALUES("1468","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:88","2021-02-24 09:14:43","2021-02-24 09:14:43","1");
INSERT INTO audit_trail VALUES("1469","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:89","2021-02-24 09:15:51","2021-02-24 09:15:51","1");
INSERT INTO audit_trail VALUES("1470","1","Admin Admin","","Logged in to system","2021-02-24 09:19:23","2021-02-24 09:19:23","1");
INSERT INTO audit_trail VALUES("1471","1","Admin Admin","","Logged in to system","2021-02-24 09:41:34","2021-02-24 09:41:34","1");
INSERT INTO audit_trail VALUES("1472","1","Admin Admin","","Disbursed loan with id:41","2021-02-24 09:42:50","2021-02-24 09:42:50","1");
INSERT INTO audit_trail VALUES("1473","1","Admin Admin","","Undisbursed loan with id:131","2021-02-24 09:50:15","2021-02-24 09:50:15","1");
INSERT INTO audit_trail VALUES("1474","1","Admin Admin","","Unapproved loan with id:131","2021-02-24 09:50:39","2021-02-24 09:50:39","1");
INSERT INTO audit_trail VALUES("1475","1","Admin Admin","","Updated loan with id:131","2021-02-24 09:51:15","2021-02-24 09:51:15","1");
INSERT INTO audit_trail VALUES("1476","1","Admin Admin","","Approved loan with id:131","2021-02-24 09:59:29","2021-02-24 09:59:29","1");
INSERT INTO audit_trail VALUES("1477","1","Admin Admin","","Disbursed loan with id:131","2021-02-24 09:59:41","2021-02-24 09:59:41","1");
INSERT INTO audit_trail VALUES("1478","1","Admin Admin","","Added repayment for loan with id:131","2021-02-24 10:00:20","2021-02-24 10:00:20","1");
INSERT INTO audit_trail VALUES("1479","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-24 10:00:35","2021-02-24 10:00:35","1");
INSERT INTO audit_trail VALUES("1480","1","Admin Admin","","Undisbursed loan with id:125","2021-02-24 10:01:25","2021-02-24 10:01:25","1");
INSERT INTO audit_trail VALUES("1481","1","Admin Admin","","Unapproved loan with id:125","2021-02-24 10:01:41","2021-02-24 10:01:41","1");
INSERT INTO audit_trail VALUES("1482","1","Admin Admin","","Updated loan with id:125","2021-02-24 10:02:05","2021-02-24 10:02:05","1");
INSERT INTO audit_trail VALUES("1483","1","Admin Admin","","Approved loan with id:125","2021-02-24 10:02:53","2021-02-24 10:02:53","1");
INSERT INTO audit_trail VALUES("1484","1","Admin Admin","","Disbursed loan with id:125","2021-02-24 10:03:08","2021-02-24 10:03:08","1");
INSERT INTO audit_trail VALUES("1485","1","Admin Admin","","Logged out of system","2021-02-24 10:03:37","2021-02-24 10:03:37","1");
INSERT INTO audit_trail VALUES("1486","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-25 01:05:04","2021-02-25 01:05:04","1");
INSERT INTO audit_trail VALUES("1487","1","Admin Admin","","Logged in to system","2021-02-25 01:56:59","2021-02-25 01:56:59","1");
INSERT INTO audit_trail VALUES("1488","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-25 03:38:31","2021-02-25 03:38:31","1");
INSERT INTO audit_trail VALUES("1489","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-25 03:38:42","2021-02-25 03:38:42","1");
INSERT INTO audit_trail VALUES("1490","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:90","2021-02-25 06:31:18","2021-02-25 06:31:18","1");
INSERT INTO audit_trail VALUES("1491","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:60","2021-02-25 06:33:13","2021-02-25 06:33:13","1");
INSERT INTO audit_trail VALUES("1492","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:61","2021-02-25 06:34:20","2021-02-25 06:34:20","1");
INSERT INTO audit_trail VALUES("1493","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:62","2021-02-25 06:36:54","2021-02-25 06:36:54","1");
INSERT INTO audit_trail VALUES("1494","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:91","2021-02-25 06:43:09","2021-02-25 06:43:09","1");
INSERT INTO audit_trail VALUES("1495","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:92","2021-02-25 06:44:03","2021-02-25 06:44:03","1");
INSERT INTO audit_trail VALUES("1496","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:63","2021-02-25 09:38:05","2021-02-25 09:38:05","1");
INSERT INTO audit_trail VALUES("1497","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:64","2021-02-25 09:38:05","2021-02-25 09:38:05","1");
INSERT INTO audit_trail VALUES("1498","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:93","2021-02-25 10:14:04","2021-02-25 10:14:04","1");
INSERT INTO audit_trail VALUES("1499","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:94","2021-02-25 10:15:02","2021-02-25 10:15:02","1");
INSERT INTO audit_trail VALUES("1500","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-02-25 10:19:11","2021-02-25 10:19:11","1");
INSERT INTO audit_trail VALUES("1501","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-26 01:13:22","2021-02-26 01:13:22","1");
INSERT INTO audit_trail VALUES("1502","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:95","2021-02-26 03:02:43","2021-02-26 03:02:43","1");
INSERT INTO audit_trail VALUES("1503","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-26 05:11:08","2021-02-26 05:11:08","");
INSERT INTO audit_trail VALUES("1504","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-26 05:11:09","2021-02-26 05:11:09","");
INSERT INTO audit_trail VALUES("1505","1","Admin Admin","","Logged in to system","2021-02-26 05:12:54","2021-02-26 05:12:54","");
INSERT INTO audit_trail VALUES("1506","1","Admin Admin","","Added loan with id:162","2021-02-26 06:44:48","2021-02-26 06:44:48","1");
INSERT INTO audit_trail VALUES("1507","1","Admin Admin","","Approved loan with id:162","2021-02-26 06:45:09","2021-02-26 06:45:09","1");
INSERT INTO audit_trail VALUES("1508","1","Admin Admin","","Disbursed loan with id:7","2021-02-26 06:47:21","2021-02-26 06:47:21","1");
INSERT INTO audit_trail VALUES("1509","1","Admin Admin","","Added repayment for loan with id:7","2021-02-26 06:49:31","2021-02-26 06:49:31","1");
INSERT INTO audit_trail VALUES("1510","1","Admin Admin","","Logged in to system","2021-02-26 07:21:34","2021-02-26 07:21:34","");
INSERT INTO audit_trail VALUES("1511","1","Admin Admin","","Updated repayment for loan with id:154","2021-02-26 07:46:02","2021-02-26 07:46:02","1");
INSERT INTO audit_trail VALUES("1512","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:34","2021-02-26 09:56:58","2021-02-26 09:56:58","1");
INSERT INTO audit_trail VALUES("1513","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:65","2021-02-26 09:59:50","2021-02-26 09:59:50","1");
INSERT INTO audit_trail VALUES("1514","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:66","2021-02-26 10:03:12","2021-02-26 10:03:12","1");
INSERT INTO audit_trail VALUES("1515","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:67","2021-02-26 10:05:05","2021-02-26 10:05:05","1");
INSERT INTO audit_trail VALUES("1516","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:65","2021-02-26 11:07:28","2021-02-26 11:07:28","1");
INSERT INTO audit_trail VALUES("1517","1","Admin Admin","","Updated expense with id:62","2021-02-26 11:09:15","2021-02-26 11:09:15","1");
INSERT INTO audit_trail VALUES("1518","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:62","2021-02-26 11:09:20","2021-02-26 11:09:20","1");
INSERT INTO audit_trail VALUES("1519","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:62","2021-02-26 11:14:00","2021-02-26 11:14:00","1");
INSERT INTO audit_trail VALUES("1520","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:96","2021-02-27 00:47:32","2021-02-27 00:47:32","1");
INSERT INTO audit_trail VALUES("1521","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-02-27 03:31:21","2021-02-27 03:31:21","");
INSERT INTO audit_trail VALUES("1522","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:97","2021-02-27 04:05:37","2021-02-27 04:05:37","1");
INSERT INTO audit_trail VALUES("1523","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:98","2021-02-27 05:49:22","2021-02-27 05:49:22","1");
INSERT INTO audit_trail VALUES("1524","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:99","2021-02-27 05:50:56","2021-02-27 05:50:56","1");
INSERT INTO audit_trail VALUES("1525","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:68","2021-02-27 06:04:30","2021-02-27 06:04:30","1");
INSERT INTO audit_trail VALUES("1526","1","Admin Admin","","Logged in to system","2021-02-27 06:32:52","2021-02-27 06:32:52","");
INSERT INTO audit_trail VALUES("1527","1","Admin Admin","","Logged in to system","2021-02-27 08:39:10","2021-02-27 08:39:10","");
INSERT INTO audit_trail VALUES("1528","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-02-27 17:56:56","2021-02-27 17:56:56","");
INSERT INTO audit_trail VALUES("1529","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-01 01:36:30","2021-03-01 01:36:30","");
INSERT INTO audit_trail VALUES("1530","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-01 05:11:16","2021-03-01 05:11:16","");
INSERT INTO audit_trail VALUES("1531","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-01 05:11:18","2021-03-01 05:11:18","");
INSERT INTO audit_trail VALUES("1532","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:100","2021-03-01 06:42:19","2021-03-01 06:42:19","1");
INSERT INTO audit_trail VALUES("1533","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:13","2021-03-01 06:48:21","2021-03-01 06:48:21","1");
INSERT INTO audit_trail VALUES("1534","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:69","2021-03-01 06:54:57","2021-03-01 06:54:57","1");
INSERT INTO audit_trail VALUES("1535","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:70","2021-03-01 08:35:22","2021-03-01 08:35:22","1");
INSERT INTO audit_trail VALUES("1536","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:71","2021-03-01 08:39:41","2021-03-01 08:39:41","1");
INSERT INTO audit_trail VALUES("1537","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:72","2021-03-01 08:40:48","2021-03-01 08:40:48","1");
INSERT INTO audit_trail VALUES("1538","1","Admin Admin","","Logged in to system","2021-03-01 09:14:14","2021-03-01 09:14:14","");
INSERT INTO audit_trail VALUES("1539","1","Admin Admin","","Logged in to system","2021-03-01 09:16:06","2021-03-01 09:16:06","");
INSERT INTO audit_trail VALUES("1540","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:100","2021-03-01 10:12:24","2021-03-01 10:12:24","1");
INSERT INTO audit_trail VALUES("1541","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:101","2021-03-01 10:38:00","2021-03-01 10:38:00","1");
INSERT INTO audit_trail VALUES("1542","1","Admin Admin","","Added Journal Manual Entry  with id:6172","2021-03-01 10:54:54","2021-03-01 10:54:54","1");
INSERT INTO audit_trail VALUES("1543","1","Admin Admin","","Deleted Capital  with id:101","2021-03-01 10:56:38","2021-03-01 10:56:38","1");
INSERT INTO audit_trail VALUES("1544","1","Admin Admin","","Added Journal Manual Entry  with id:6174","2021-03-01 10:57:46","2021-03-01 10:57:46","1");
INSERT INTO audit_trail VALUES("1545","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:70","2021-03-01 11:20:52","2021-03-01 11:20:52","1");
INSERT INTO audit_trail VALUES("1546","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:73","2021-03-01 11:23:40","2021-03-01 11:23:40","1");
INSERT INTO audit_trail VALUES("1547","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-01 12:03:44","2021-03-01 12:03:44","1");
INSERT INTO audit_trail VALUES("1548","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:102","2021-03-02 00:20:43","2021-03-02 00:20:43","1");
INSERT INTO audit_trail VALUES("1549","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-02 01:55:30","2021-03-02 01:55:30","1");
INSERT INTO audit_trail VALUES("1550","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-02 04:17:11","2021-03-02 04:17:11","1");
INSERT INTO audit_trail VALUES("1551","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-02 04:17:38","2021-03-02 04:17:38","1");
INSERT INTO audit_trail VALUES("1552","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-02 09:25:40","2021-03-02 09:25:40","");
INSERT INTO audit_trail VALUES("1553","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:74","2021-03-02 10:14:07","2021-03-02 10:14:07","1");
INSERT INTO audit_trail VALUES("1554","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:75","2021-03-02 10:15:34","2021-03-02 10:15:34","1");
INSERT INTO audit_trail VALUES("1555","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-03-02 10:32:44","2021-03-02 10:32:44","1");
INSERT INTO audit_trail VALUES("1556","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-02 10:33:08","2021-03-02 10:33:08","1");
INSERT INTO audit_trail VALUES("1557","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-03-02 10:34:00","2021-03-02 10:34:00","1");
INSERT INTO audit_trail VALUES("1558","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-02 10:34:30","2021-03-02 10:34:30","1");
INSERT INTO audit_trail VALUES("1559","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-02 10:34:43","2021-03-02 10:34:43","1");
INSERT INTO audit_trail VALUES("1560","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-02 10:35:45","2021-03-02 10:35:45","1");
INSERT INTO audit_trail VALUES("1561","1","Admin Admin","","Logged in to system","2021-03-02 10:35:58","2021-03-02 10:35:58","1");
INSERT INTO audit_trail VALUES("1562","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:103","2021-03-02 10:36:57","2021-03-02 10:36:57","1");
INSERT INTO audit_trail VALUES("1563","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:104","2021-03-02 10:37:52","2021-03-02 10:37:52","1");
INSERT INTO audit_trail VALUES("1564","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-02 10:37:53","2021-03-02 10:37:53","1");
INSERT INTO audit_trail VALUES("1565","1","Admin Admin","","Logged out of system","2021-03-02 10:39:50","2021-03-02 10:39:50","1");
INSERT INTO audit_trail VALUES("1566","1","Admin Admin","","Logged in to system","2021-03-02 10:40:05","2021-03-02 10:40:05","1");
INSERT INTO audit_trail VALUES("1567","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-02 10:42:58","2021-03-02 10:42:58","1");
INSERT INTO audit_trail VALUES("1568","1","Admin Admin","","Logged out of system","2021-03-02 11:07:29","2021-03-02 11:07:29","1");
INSERT INTO audit_trail VALUES("1569","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:105","2021-03-03 00:47:10","2021-03-03 00:47:10","1");
INSERT INTO audit_trail VALUES("1570","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-03 01:21:12","2021-03-03 01:21:12","1");
INSERT INTO audit_trail VALUES("1571","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-03 01:25:22","2021-03-03 01:25:22","1");
INSERT INTO audit_trail VALUES("1572","1","Admin Admin","","Logged in to system","2021-03-03 05:36:01","2021-03-03 05:36:01","1");
INSERT INTO audit_trail VALUES("1573","1","Admin Admin","","Logged in to system","2021-03-03 05:56:23","2021-03-03 05:56:23","");
INSERT INTO audit_trail VALUES("1574","1","Admin Admin","","Logged out of system","2021-03-03 06:00:42","2021-03-03 06:00:42","1");
INSERT INTO audit_trail VALUES("1575","1","Admin Admin","","Logged in to system","2021-03-03 06:10:03","2021-03-03 06:10:03","1");
INSERT INTO audit_trail VALUES("1576","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-03 07:24:41","2021-03-03 07:24:41","1");
INSERT INTO audit_trail VALUES("1577","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-03 07:24:42","2021-03-03 07:24:42","1");
INSERT INTO audit_trail VALUES("1578","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-03 07:46:14","2021-03-03 07:46:14","");
INSERT INTO audit_trail VALUES("1579","1","Admin Admin","","Logged in to system","2021-03-03 08:04:19","2021-03-03 08:04:19","");
INSERT INTO audit_trail VALUES("1580","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:6408","2021-03-03 09:22:58","2021-03-03 09:22:58","1");
INSERT INTO audit_trail VALUES("1581","1","Admin Admin","","Deleted borrower  with id:619","2021-03-03 10:06:42","2021-03-03 10:06:42","1");
INSERT INTO audit_trail VALUES("1582","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:76","2021-03-03 10:31:28","2021-03-03 10:31:28","1");
INSERT INTO audit_trail VALUES("1583","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:77","2021-03-03 10:34:14","2021-03-03 10:34:14","1");
INSERT INTO audit_trail VALUES("1584","1","Admin Admin","","Logged in to system","2021-03-03 11:00:16","2021-03-03 11:00:16","");
INSERT INTO audit_trail VALUES("1585","1","Admin Admin","","Logged in to system","2021-03-03 11:00:17","2021-03-03 11:00:17","");
INSERT INTO audit_trail VALUES("1586","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-03 11:04:10","2021-03-03 11:04:10","1");
INSERT INTO audit_trail VALUES("1587","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-03 11:04:48","2021-03-03 11:04:48","1");
INSERT INTO audit_trail VALUES("1588","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-03 11:05:30","2021-03-03 11:05:30","1");
INSERT INTO audit_trail VALUES("1589","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:106","2021-03-04 00:30:34","2021-03-04 00:30:34","1");
INSERT INTO audit_trail VALUES("1590","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:107","2021-03-04 00:34:34","2021-03-04 00:34:34","1");
INSERT INTO audit_trail VALUES("1591","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-04 00:37:49","2021-03-04 00:37:49","1");
INSERT INTO audit_trail VALUES("1592","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-04 03:12:55","2021-03-04 03:12:55","");
INSERT INTO audit_trail VALUES("1593","1","Admin Admin","","Updated borrower  with id:526","2021-03-04 07:52:51","2021-03-04 07:52:51","1");
INSERT INTO audit_trail VALUES("1594","1","Admin Admin","","Logged in to system","2021-03-04 07:56:11","2021-03-04 07:56:11","");
INSERT INTO audit_trail VALUES("1595","1","Admin Admin","","Logged in to system","2021-03-04 08:03:16","2021-03-04 08:03:16","1");
INSERT INTO audit_trail VALUES("1596","1","Admin Admin","","Logged in to system","2021-03-04 08:10:04","2021-03-04 08:10:04","1");
INSERT INTO audit_trail VALUES("1597","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:78","2021-03-04 09:34:13","2021-03-04 09:34:13","1");
INSERT INTO audit_trail VALUES("1598","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:78","2021-03-04 09:36:00","2021-03-04 09:36:00","1");
INSERT INTO audit_trail VALUES("1599","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:79","2021-03-04 09:38:16","2021-03-04 09:38:16","1");
INSERT INTO audit_trail VALUES("1600","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:80","2021-03-04 09:39:53","2021-03-04 09:39:53","1");
INSERT INTO audit_trail VALUES("1601","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:81","2021-03-04 09:41:18","2021-03-04 09:41:18","1");
INSERT INTO audit_trail VALUES("1602","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:82","2021-03-04 10:13:42","2021-03-04 10:13:42","1");
INSERT INTO audit_trail VALUES("1603","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-04 10:31:36","2021-03-04 10:31:36","1");
INSERT INTO audit_trail VALUES("1604","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:108","2021-03-05 00:24:10","2021-03-05 00:24:10","1");
INSERT INTO audit_trail VALUES("1605","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-05 00:48:16","2021-03-05 00:48:16","1");
INSERT INTO audit_trail VALUES("1606","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-05 06:44:16","2021-03-05 06:44:16","");
INSERT INTO audit_trail VALUES("1607","1","Admin Admin","","Logged in to system","2021-03-05 08:09:49","2021-03-05 08:09:49","");
INSERT INTO audit_trail VALUES("1608","1","Admin Admin","","Logged in to system","2021-03-05 08:58:00","2021-03-05 08:58:00","");
INSERT INTO audit_trail VALUES("1609","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:109","2021-03-05 09:04:29","2021-03-05 09:04:29","1");
INSERT INTO audit_trail VALUES("1610","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:110","2021-03-05 09:05:34","2021-03-05 09:05:34","1");
INSERT INTO audit_trail VALUES("1611","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:111","2021-03-05 09:09:51","2021-03-05 09:09:51","1");
INSERT INTO audit_trail VALUES("1612","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:111","2021-03-05 09:11:07","2021-03-05 09:11:07","1");
INSERT INTO audit_trail VALUES("1613","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:112","2021-03-05 09:16:05","2021-03-05 09:16:05","1");
INSERT INTO audit_trail VALUES("1614","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:113","2021-03-05 09:19:05","2021-03-05 09:19:05","1");
INSERT INTO audit_trail VALUES("1615","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:83","2021-03-05 09:23:18","2021-03-05 09:23:18","1");
INSERT INTO audit_trail VALUES("1616","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:84","2021-03-05 09:25:25","2021-03-05 09:25:25","1");
INSERT INTO audit_trail VALUES("1617","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:85","2021-03-05 09:27:33","2021-03-05 09:27:33","1");
INSERT INTO audit_trail VALUES("1618","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:86","2021-03-05 09:29:43","2021-03-05 09:29:43","1");
INSERT INTO audit_trail VALUES("1619","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:87","2021-03-05 09:30:55","2021-03-05 09:30:55","1");
INSERT INTO audit_trail VALUES("1620","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:88","2021-03-05 09:32:22","2021-03-05 09:32:22","1");
INSERT INTO audit_trail VALUES("1621","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:89","2021-03-05 10:01:13","2021-03-05 10:01:13","1");
INSERT INTO audit_trail VALUES("1622","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-05 10:05:04","2021-03-05 10:05:04","1");
INSERT INTO audit_trail VALUES("1623","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-05 10:13:55","2021-03-05 10:13:55","1");
INSERT INTO audit_trail VALUES("1624","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-05 10:24:11","2021-03-05 10:24:11","1");
INSERT INTO audit_trail VALUES("1625","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-05 10:52:19","2021-03-05 10:52:19","1");
INSERT INTO audit_trail VALUES("1626","3","BERNICE  MUTHONI MUTUGI","","Added borrower  with id:621","2021-03-06 00:23:35","2021-03-06 00:23:35","1");
INSERT INTO audit_trail VALUES("1627","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:114","2021-03-06 01:02:02","2021-03-06 01:02:02","1");
INSERT INTO audit_trail VALUES("1628","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:90","2021-03-06 01:04:33","2021-03-06 01:04:33","1");
INSERT INTO audit_trail VALUES("1629","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-06 01:44:18","2021-03-06 01:44:18","1");
INSERT INTO audit_trail VALUES("1630","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-06 05:32:01","2021-03-06 05:32:01","1");
INSERT INTO audit_trail VALUES("1631","1","Admin Admin","","Logged in to system","2021-03-06 12:38:49","2021-03-06 12:38:49","");
INSERT INTO audit_trail VALUES("1632","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-08 00:53:04","2021-03-08 00:53:04","");
INSERT INTO audit_trail VALUES("1633","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:115","2021-03-08 00:54:58","2021-03-08 00:54:58","1");
INSERT INTO audit_trail VALUES("1634","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-08 02:26:47","2021-03-08 02:26:47","");
INSERT INTO audit_trail VALUES("1635","1","Admin Admin","","Logged in to system","2021-03-08 05:20:21","2021-03-08 05:20:21","");
INSERT INTO audit_trail VALUES("1636","1","Admin Admin","","Logged out of system","2021-03-08 05:21:09","2021-03-08 05:21:09","1");
INSERT INTO audit_trail VALUES("1637","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-08 05:21:41","2021-03-08 05:21:41","1");
INSERT INTO audit_trail VALUES("1638","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-08 05:26:08","2021-03-08 05:26:08","");
INSERT INTO audit_trail VALUES("1639","1","Admin Admin","","Logged in to system","2021-03-08 06:16:22","2021-03-08 06:16:22","");
INSERT INTO audit_trail VALUES("1640","1","Admin Admin","","Logged out of system","2021-03-08 06:16:56","2021-03-08 06:16:56","1");
INSERT INTO audit_trail VALUES("1641","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-08 06:17:19","2021-03-08 06:17:19","1");
INSERT INTO audit_trail VALUES("1642","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:91","2021-03-08 10:11:37","2021-03-08 10:11:37","1");
INSERT INTO audit_trail VALUES("1643","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:92","2021-03-08 10:13:00","2021-03-08 10:13:00","1");
INSERT INTO audit_trail VALUES("1644","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:93","2021-03-08 10:17:25","2021-03-08 10:17:25","1");
INSERT INTO audit_trail VALUES("1645","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:116","2021-03-09 00:28:39","2021-03-09 00:28:39","1");
INSERT INTO audit_trail VALUES("1646","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:117","2021-03-09 00:31:25","2021-03-09 00:31:25","1");
INSERT INTO audit_trail VALUES("1647","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:118","2021-03-09 00:32:45","2021-03-09 00:32:45","1");
INSERT INTO audit_trail VALUES("1648","3","BERNICE  MUTHONI MUTUGI","","Added borrower  with id:622","2021-03-09 00:37:51","2021-03-09 00:37:51","1");
INSERT INTO audit_trail VALUES("1649","3","BERNICE  MUTHONI MUTUGI","","Added borrower  with id:623","2021-03-09 06:40:14","2021-03-09 06:40:14","1");
INSERT INTO audit_trail VALUES("1650","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:94","2021-03-09 06:42:34","2021-03-09 06:42:34","1");
INSERT INTO audit_trail VALUES("1651","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:95","2021-03-09 06:43:58","2021-03-09 06:43:58","1");
INSERT INTO audit_trail VALUES("1652","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:94","2021-03-09 06:44:42","2021-03-09 06:44:42","1");
INSERT INTO audit_trail VALUES("1653","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:119","2021-03-09 06:48:02","2021-03-09 06:48:02","1");
INSERT INTO audit_trail VALUES("1654","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:120","2021-03-09 06:49:05","2021-03-09 06:49:05","1");
INSERT INTO audit_trail VALUES("1655","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:96","2021-03-09 09:25:56","2021-03-09 09:25:56","1");
INSERT INTO audit_trail VALUES("1656","1","Admin Admin","","Logged in to system","2021-03-09 09:46:48","2021-03-09 09:46:48","");
INSERT INTO audit_trail VALUES("1657","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:121","2021-03-09 09:47:52","2021-03-09 09:47:52","1");
INSERT INTO audit_trail VALUES("1658","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:122","2021-03-09 09:49:17","2021-03-09 09:49:17","1");
INSERT INTO audit_trail VALUES("1659","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-09 10:01:53","2021-03-09 10:01:53","1");
INSERT INTO audit_trail VALUES("1660","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:123","2021-03-09 10:08:36","2021-03-09 10:08:36","1");
INSERT INTO audit_trail VALUES("1661","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-10 01:12:12","2021-03-10 01:12:12","1");
INSERT INTO audit_trail VALUES("1662","1","Admin Admin","","Logged in to system","2021-03-10 01:58:16","2021-03-10 01:58:16","");
INSERT INTO audit_trail VALUES("1663","1","Admin Admin","","Logged out of system","2021-03-10 01:58:35","2021-03-10 01:58:35","1");
INSERT INTO audit_trail VALUES("1664","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-10 01:59:42","2021-03-10 01:59:42","1");
INSERT INTO audit_trail VALUES("1665","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-10 01:59:45","2021-03-10 01:59:45","1");
INSERT INTO audit_trail VALUES("1666","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:124","2021-03-10 03:09:14","2021-03-10 03:09:14","1");
INSERT INTO audit_trail VALUES("1667","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-10 04:07:22","2021-03-10 04:07:22","");
INSERT INTO audit_trail VALUES("1668","1","Admin Admin","","Logged in to system","2021-03-10 04:54:23","2021-03-10 04:54:23","");
INSERT INTO audit_trail VALUES("1669","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:97","2021-03-10 09:00:49","2021-03-10 09:00:49","1");
INSERT INTO audit_trail VALUES("1670","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:125","2021-03-10 09:08:19","2021-03-10 09:08:19","1");
INSERT INTO audit_trail VALUES("1671","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:126","2021-03-10 09:11:13","2021-03-10 09:11:13","1");
INSERT INTO audit_trail VALUES("1672","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:127","2021-03-10 09:12:39","2021-03-10 09:12:39","1");
INSERT INTO audit_trail VALUES("1673","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:128","2021-03-10 09:43:46","2021-03-10 09:43:46","1");
INSERT INTO audit_trail VALUES("1674","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:129","2021-03-10 09:44:58","2021-03-10 09:44:58","1");
INSERT INTO audit_trail VALUES("1675","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-10 09:57:02","2021-03-10 09:57:02","1");
INSERT INTO audit_trail VALUES("1676","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:130","2021-03-11 02:00:52","2021-03-11 02:00:52","1");
INSERT INTO audit_trail VALUES("1677","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-11 02:25:16","2021-03-11 02:25:16","1");
INSERT INTO audit_trail VALUES("1678","1","Admin Admin","","Logged in to system","2021-03-11 02:57:49","2021-03-11 02:57:49","");
INSERT INTO audit_trail VALUES("1679","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-11 06:46:09","2021-03-11 06:46:09","");
INSERT INTO audit_trail VALUES("1680","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-11 06:46:10","2021-03-11 06:46:10","");
INSERT INTO audit_trail VALUES("1681","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-11 06:57:29","2021-03-11 06:57:29","1");
INSERT INTO audit_trail VALUES("1682","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:131","2021-03-11 09:33:35","2021-03-11 09:33:35","1");
INSERT INTO audit_trail VALUES("1683","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:132","2021-03-11 09:34:26","2021-03-11 09:34:26","1");
INSERT INTO audit_trail VALUES("1684","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:98","2021-03-11 09:36:16","2021-03-11 09:36:16","1");
INSERT INTO audit_trail VALUES("1685","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:99","2021-03-11 09:37:22","2021-03-11 09:37:22","1");
INSERT INTO audit_trail VALUES("1686","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:100","2021-03-11 09:44:12","2021-03-11 09:44:12","1");
INSERT INTO audit_trail VALUES("1687","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-11 09:52:16","2021-03-11 09:52:16","1");
INSERT INTO audit_trail VALUES("1688","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:133","2021-03-12 00:36:15","2021-03-12 00:36:15","1");
INSERT INTO audit_trail VALUES("1689","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-12 00:48:45","2021-03-12 00:48:45","1");
INSERT INTO audit_trail VALUES("1690","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-12 01:53:54","2021-03-12 01:53:54","1");
INSERT INTO audit_trail VALUES("1691","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:7933","2021-03-12 05:22:56","2021-03-12 05:22:56","1");
INSERT INTO audit_trail VALUES("1692","1","Admin Admin","","Logged in to system","2021-03-12 05:41:49","2021-03-12 05:41:49","");
INSERT INTO audit_trail VALUES("1693","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:134","2021-03-12 09:19:53","2021-03-12 09:19:53","1");
INSERT INTO audit_trail VALUES("1694","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:135","2021-03-12 09:21:04","2021-03-12 09:21:04","1");
INSERT INTO audit_trail VALUES("1695","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:101","2021-03-12 09:22:43","2021-03-12 09:22:43","1");
INSERT INTO audit_trail VALUES("1696","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:102","2021-03-12 09:22:43","2021-03-12 09:22:43","1");
INSERT INTO audit_trail VALUES("1697","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:103","2021-03-12 09:24:04","2021-03-12 09:24:04","1");
INSERT INTO audit_trail VALUES("1698","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-12 09:44:02","2021-03-12 09:44:02","1");
INSERT INTO audit_trail VALUES("1699","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:136","2021-03-13 00:21:12","2021-03-13 00:21:12","1");
INSERT INTO audit_trail VALUES("1700","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-13 00:35:24","2021-03-13 00:35:24","1");
INSERT INTO audit_trail VALUES("1701","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-13 05:14:02","2021-03-13 05:14:02","1");
INSERT INTO audit_trail VALUES("1702","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-03-13 05:17:33","2021-03-13 05:17:33","1");
INSERT INTO audit_trail VALUES("1703","1","Admin Admin","","Logged in to system","2021-03-13 16:45:50","2021-03-13 16:45:50","");
INSERT INTO audit_trail VALUES("1704","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-15 02:37:30","2021-03-15 02:37:30","");
INSERT INTO audit_trail VALUES("1705","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:137","2021-03-15 02:39:33","2021-03-15 02:39:33","1");
INSERT INTO audit_trail VALUES("1706","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-15 03:31:54","2021-03-15 03:31:54","");
INSERT INTO audit_trail VALUES("1707","1","Admin Admin","","Logged in to system","2021-03-15 07:04:23","2021-03-15 07:04:23","");
INSERT INTO audit_trail VALUES("1708","1","Admin Admin","","Logged out of system","2021-03-15 07:16:13","2021-03-15 07:16:13","1");
INSERT INTO audit_trail VALUES("1709","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-15 07:16:34","2021-03-15 07:16:34","1");
INSERT INTO audit_trail VALUES("1710","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-15 07:54:14","2021-03-15 07:54:14","");
INSERT INTO audit_trail VALUES("1711","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-15 08:49:58","2021-03-15 08:49:58","");
INSERT INTO audit_trail VALUES("1712","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-03-15 08:50:56","2021-03-15 08:50:56","1");
INSERT INTO audit_trail VALUES("1713","1","Admin Admin","","Logged in to system","2021-03-15 08:52:10","2021-03-15 08:52:10","1");
INSERT INTO audit_trail VALUES("1714","1","Admin Admin","","Logged in to system","2021-03-15 08:52:20","2021-03-15 08:52:20","1");
INSERT INTO audit_trail VALUES("1715","1","Admin Admin","","Deleted loan with id:161","2021-03-15 08:53:44","2021-03-15 08:53:44","1");
INSERT INTO audit_trail VALUES("1716","1","Admin Admin","","Updated loan with id:147","2021-03-15 09:46:37","2021-03-15 09:46:37","1");
INSERT INTO audit_trail VALUES("1717","1","Admin Admin","","Deleted loan with id:147","2021-03-15 09:49:53","2021-03-15 09:49:53","1");
INSERT INTO audit_trail VALUES("1718","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-15 09:50:41","2021-03-15 09:50:41","1");
INSERT INTO audit_trail VALUES("1719","1","Admin Admin","","Added loan with id:162","2021-03-15 09:50:55","2021-03-15 09:50:55","1");
INSERT INTO audit_trail VALUES("1720","1","Admin Admin","","Approved loan with id:162","2021-03-15 09:51:45","2021-03-15 09:51:45","1");
INSERT INTO audit_trail VALUES("1721","1","Admin Admin","","Disbursed loan with id:162","2021-03-15 09:52:08","2021-03-15 09:52:08","1");
INSERT INTO audit_trail VALUES("1722","1","Admin Admin","","Updated loan with id:162","2021-03-15 09:56:11","2021-03-15 09:56:11","1");
INSERT INTO audit_trail VALUES("1723","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:104","2021-03-15 09:57:37","2021-03-15 09:57:37","1");
INSERT INTO audit_trail VALUES("1724","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:105","2021-03-15 09:58:57","2021-03-15 09:58:57","1");
INSERT INTO audit_trail VALUES("1725","1","Admin Admin","","Deleted loan with id:162","2021-03-15 09:59:50","2021-03-15 09:59:50","1");
INSERT INTO audit_trail VALUES("1726","1","Admin Admin","","Updated loan product with id:1","2021-03-15 10:02:22","2021-03-15 10:02:22","1");
INSERT INTO audit_trail VALUES("1727","1","Admin Admin","","Added loan with id:163","2021-03-15 10:02:41","2021-03-15 10:02:41","1");
INSERT INTO audit_trail VALUES("1728","1","Admin Admin","","Approved loan with id:163","2021-03-15 10:06:15","2021-03-15 10:06:15","1");
INSERT INTO audit_trail VALUES("1729","1","Admin Admin","","Disbursed loan with id:163","2021-03-15 10:06:32","2021-03-15 10:06:32","1");
INSERT INTO audit_trail VALUES("1730","1","Admin Admin","","Added repayment for loan with id:163","2021-03-15 10:07:42","2021-03-15 10:07:42","1");
INSERT INTO audit_trail VALUES("1731","1","Admin Admin","","Deleted loan with id:2","2021-03-15 10:09:43","2021-03-15 10:09:43","1");
INSERT INTO audit_trail VALUES("1732","1","Admin Admin","","Logged in to system","2021-03-15 10:20:34","2021-03-15 10:20:34","");
INSERT INTO audit_trail VALUES("1733","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-15 10:49:03","2021-03-15 10:49:03","1");
INSERT INTO audit_trail VALUES("1734","1","Admin Admin","","Added repayment for loan with id:163","2021-03-15 10:51:25","2021-03-15 10:51:25","1");
INSERT INTO audit_trail VALUES("1735","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:106","2021-03-15 10:57:11","2021-03-15 10:57:11","1");
INSERT INTO audit_trail VALUES("1736","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-15 11:00:37","2021-03-15 11:00:37","1");
INSERT INTO audit_trail VALUES("1737","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-15 11:12:02","2021-03-15 11:12:02","1");
INSERT INTO audit_trail VALUES("1738","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-16 01:15:19","2021-03-16 01:15:19","1");
INSERT INTO audit_trail VALUES("1739","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:138","2021-03-16 01:24:38","2021-03-16 01:24:38","1");
INSERT INTO audit_trail VALUES("1740","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:139","2021-03-16 07:15:33","2021-03-16 07:15:33","1");
INSERT INTO audit_trail VALUES("1741","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:140","2021-03-16 07:16:27","2021-03-16 07:16:27","1");
INSERT INTO audit_trail VALUES("1742","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:141","2021-03-16 07:17:25","2021-03-16 07:17:25","1");
INSERT INTO audit_trail VALUES("1743","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:107","2021-03-16 10:29:19","2021-03-16 10:29:19","1");
INSERT INTO audit_trail VALUES("1744","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:107","2021-03-16 10:33:38","2021-03-16 10:33:38","1");
INSERT INTO audit_trail VALUES("1745","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-16 11:01:38","2021-03-16 11:01:38","1");
INSERT INTO audit_trail VALUES("1746","1","Admin Admin","","Logged in to system","2021-03-16 15:37:11","2021-03-16 15:37:11","");
INSERT INTO audit_trail VALUES("1747","1","Admin Admin","","Logged in to system","2021-03-17 03:15:35","2021-03-17 03:15:35","");
INSERT INTO audit_trail VALUES("1748","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:142","2021-03-17 03:47:21","2021-03-17 03:47:21","1");
INSERT INTO audit_trail VALUES("1749","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-17 04:00:55","2021-03-17 04:00:55","");
INSERT INTO audit_trail VALUES("1750","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-17 06:15:49","2021-03-17 06:15:49","1");
INSERT INTO audit_trail VALUES("1751","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:108","2021-03-17 10:18:44","2021-03-17 10:18:44","1");
INSERT INTO audit_trail VALUES("1752","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:109","2021-03-17 10:20:33","2021-03-17 10:20:33","1");
INSERT INTO audit_trail VALUES("1753","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:110","2021-03-17 10:23:01","2021-03-17 10:23:01","1");
INSERT INTO audit_trail VALUES("1754","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:143","2021-03-17 10:25:20","2021-03-17 10:25:20","1");
INSERT INTO audit_trail VALUES("1755","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-17 11:04:27","2021-03-17 11:04:27","1");
INSERT INTO audit_trail VALUES("1756","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:144","2021-03-18 01:25:18","2021-03-18 01:25:18","1");
INSERT INTO audit_trail VALUES("1757","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:111","2021-03-18 08:54:12","2021-03-18 08:54:12","1");
INSERT INTO audit_trail VALUES("1758","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:111","2021-03-18 09:03:05","2021-03-18 09:03:05","1");
INSERT INTO audit_trail VALUES("1759","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:112","2021-03-18 09:05:41","2021-03-18 09:05:41","1");
INSERT INTO audit_trail VALUES("1760","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:113","2021-03-18 09:07:15","2021-03-18 09:07:15","1");
INSERT INTO audit_trail VALUES("1761","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:114","2021-03-18 09:08:31","2021-03-18 09:08:31","1");
INSERT INTO audit_trail VALUES("1762","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:115","2021-03-18 09:09:50","2021-03-18 09:09:50","1");
INSERT INTO audit_trail VALUES("1763","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:116","2021-03-18 09:11:30","2021-03-18 09:11:30","1");
INSERT INTO audit_trail VALUES("1764","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-18 09:44:40","2021-03-18 09:44:40","");
INSERT INTO audit_trail VALUES("1765","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:145","2021-03-18 10:12:23","2021-03-18 10:12:23","1");
INSERT INTO audit_trail VALUES("1766","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:146","2021-03-18 10:14:02","2021-03-18 10:14:02","1");
INSERT INTO audit_trail VALUES("1767","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-18 10:31:45","2021-03-18 10:31:45","1");
INSERT INTO audit_trail VALUES("1768","1","Admin Admin","","Logged in to system","2021-03-18 16:43:24","2021-03-18 16:43:24","");
INSERT INTO audit_trail VALUES("1769","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-19 01:06:53","2021-03-19 01:06:53","1");
INSERT INTO audit_trail VALUES("1770","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:147","2021-03-19 01:07:07","2021-03-19 01:07:07","1");
INSERT INTO audit_trail VALUES("1771","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:147","2021-03-19 01:08:40","2021-03-19 01:08:40","1");
INSERT INTO audit_trail VALUES("1772","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:148","2021-03-19 01:11:25","2021-03-19 01:11:25","1");
INSERT INTO audit_trail VALUES("1773","3","BERNICE  MUTHONI MUTUGI","","Added borrower  with id:624","2021-03-19 04:51:00","2021-03-19 04:51:00","1");
INSERT INTO audit_trail VALUES("1774","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:117","2021-03-19 09:27:35","2021-03-19 09:27:35","1");
INSERT INTO audit_trail VALUES("1775","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:118","2021-03-19 09:29:06","2021-03-19 09:29:06","1");
INSERT INTO audit_trail VALUES("1776","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:119","2021-03-19 09:32:05","2021-03-19 09:32:05","1");
INSERT INTO audit_trail VALUES("1777","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:120","2021-03-19 09:33:25","2021-03-19 09:33:25","1");
INSERT INTO audit_trail VALUES("1778","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:149","2021-03-19 11:09:52","2021-03-19 11:09:52","1");
INSERT INTO audit_trail VALUES("1779","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:150","2021-03-19 11:11:06","2021-03-19 11:11:06","1");
INSERT INTO audit_trail VALUES("1780","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:150","2021-03-19 11:12:40","2021-03-19 11:12:40","1");
INSERT INTO audit_trail VALUES("1781","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:151","2021-03-19 11:13:32","2021-03-19 11:13:32","1");
INSERT INTO audit_trail VALUES("1782","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:152","2021-03-19 11:14:59","2021-03-19 11:14:59","1");
INSERT INTO audit_trail VALUES("1783","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:153","2021-03-19 11:15:58","2021-03-19 11:15:58","1");
INSERT INTO audit_trail VALUES("1784","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-19 11:21:42","2021-03-19 11:21:42","1");
INSERT INTO audit_trail VALUES("1785","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:154","2021-03-20 02:18:03","2021-03-20 02:18:03","1");
INSERT INTO audit_trail VALUES("1786","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:155","2021-03-20 02:21:17","2021-03-20 02:21:17","1");
INSERT INTO audit_trail VALUES("1787","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:156","2021-03-20 02:22:48","2021-03-20 02:22:48","1");
INSERT INTO audit_trail VALUES("1788","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:155","2021-03-20 02:27:48","2021-03-20 02:27:48","1");
INSERT INTO audit_trail VALUES("1789","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:155","2021-03-20 02:28:33","2021-03-20 02:28:33","1");
INSERT INTO audit_trail VALUES("1790","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-20 03:06:06","2021-03-20 03:06:06","1");
INSERT INTO audit_trail VALUES("1791","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-20 03:06:06","2021-03-20 03:06:06","1");
INSERT INTO audit_trail VALUES("1792","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-20 03:06:08","2021-03-20 03:06:08","1");
INSERT INTO audit_trail VALUES("1793","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:121","2021-03-20 03:56:25","2021-03-20 03:56:25","1");
INSERT INTO audit_trail VALUES("1794","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:122","2021-03-20 05:23:11","2021-03-20 05:23:11","1");
INSERT INTO audit_trail VALUES("1795","1","Admin Admin","","Logged in to system","2021-03-20 05:37:52","2021-03-20 05:37:52","");
INSERT INTO audit_trail VALUES("1796","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:123","2021-03-20 06:04:01","2021-03-20 06:04:01","1");
INSERT INTO audit_trail VALUES("1797","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-20 06:30:32","2021-03-20 06:30:32","1");
INSERT INTO audit_trail VALUES("1798","1","Admin Admin","","Logged in to system","2021-03-21 15:08:46","2021-03-21 15:08:46","");
INSERT INTO audit_trail VALUES("1799","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-22 01:27:10","2021-03-22 01:27:10","");
INSERT INTO audit_trail VALUES("1800","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-22 01:42:15","2021-03-22 01:42:15","");
INSERT INTO audit_trail VALUES("1801","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:157","2021-03-22 01:45:43","2021-03-22 01:45:43","1");
INSERT INTO audit_trail VALUES("1802","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-22 02:59:37","2021-03-22 02:59:37","");
INSERT INTO audit_trail VALUES("1803","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:124","2021-03-22 03:52:28","2021-03-22 03:52:28","1");
INSERT INTO audit_trail VALUES("1804","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:125","2021-03-22 03:53:47","2021-03-22 03:53:47","1");
INSERT INTO audit_trail VALUES("1805","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:126","2021-03-22 03:55:49","2021-03-22 03:55:49","1");
INSERT INTO audit_trail VALUES("1806","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:158","2021-03-22 03:59:43","2021-03-22 03:59:43","1");
INSERT INTO audit_trail VALUES("1807","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:159","2021-03-22 04:01:08","2021-03-22 04:01:08","1");
INSERT INTO audit_trail VALUES("1808","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:127","2021-03-22 04:06:01","2021-03-22 04:06:01","1");
INSERT INTO audit_trail VALUES("1809","1","Admin Admin","","Logged in to system","2021-03-22 06:46:31","2021-03-22 06:46:31","");
INSERT INTO audit_trail VALUES("1810","1","Admin Admin","","Logged out of system","2021-03-22 06:47:03","2021-03-22 06:47:03","1");
INSERT INTO audit_trail VALUES("1811","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-22 06:47:33","2021-03-22 06:47:33","1");
INSERT INTO audit_trail VALUES("1812","1","Admin Admin","","Logged in to system","2021-03-22 09:53:34","2021-03-22 09:53:34","1");
INSERT INTO audit_trail VALUES("1813","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:128","2021-03-22 11:55:17","2021-03-22 11:55:17","1");
INSERT INTO audit_trail VALUES("1814","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:160","2021-03-22 12:56:54","2021-03-22 12:56:54","1");
INSERT INTO audit_trail VALUES("1815","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-22 13:00:23","2021-03-22 13:00:23","1");
INSERT INTO audit_trail VALUES("1816","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-23 01:12:24","2021-03-23 01:12:24","1");
INSERT INTO audit_trail VALUES("1817","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:161","2021-03-23 02:28:54","2021-03-23 02:28:54","1");
INSERT INTO audit_trail VALUES("1818","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-23 03:03:07","2021-03-23 03:03:07","1");
INSERT INTO audit_trail VALUES("1819","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:162","2021-03-23 10:35:54","2021-03-23 10:35:54","1");
INSERT INTO audit_trail VALUES("1820","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:163","2021-03-23 10:38:22","2021-03-23 10:38:22","1");
INSERT INTO audit_trail VALUES("1821","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:129","2021-03-23 10:51:28","2021-03-23 10:51:28","1");
INSERT INTO audit_trail VALUES("1822","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:130","2021-03-23 10:52:37","2021-03-23 10:52:37","1");
INSERT INTO audit_trail VALUES("1823","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-23 11:29:37","2021-03-23 11:29:37","1");
INSERT INTO audit_trail VALUES("1824","1","Admin Admin","","Logged in to system","2021-03-23 15:40:36","2021-03-23 15:40:36","");
INSERT INTO audit_trail VALUES("1825","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-24 01:14:11","2021-03-24 01:14:11","1");
INSERT INTO audit_trail VALUES("1826","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:164","2021-03-24 01:23:03","2021-03-24 01:23:03","1");
INSERT INTO audit_trail VALUES("1827","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-24 01:35:40","2021-03-24 01:35:40","1");
INSERT INTO audit_trail VALUES("1828","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-24 01:55:46","2021-03-24 01:55:46","1");
INSERT INTO audit_trail VALUES("1829","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-24 05:20:41","2021-03-24 05:20:41","1");
INSERT INTO audit_trail VALUES("1830","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:131","2021-03-24 10:02:10","2021-03-24 10:02:10","1");
INSERT INTO audit_trail VALUES("1831","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:132","2021-03-24 10:03:31","2021-03-24 10:03:31","1");
INSERT INTO audit_trail VALUES("1832","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:133","2021-03-24 10:05:07","2021-03-24 10:05:07","1");
INSERT INTO audit_trail VALUES("1833","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-24 11:03:27","2021-03-24 11:03:27","1");
INSERT INTO audit_trail VALUES("1834","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:165","2021-03-25 02:05:12","2021-03-25 02:05:12","1");
INSERT INTO audit_trail VALUES("1835","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-25 02:57:37","2021-03-25 02:57:37","1");
INSERT INTO audit_trail VALUES("1836","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:166","2021-03-25 08:54:19","2021-03-25 08:54:19","1");
INSERT INTO audit_trail VALUES("1837","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:167","2021-03-25 08:55:51","2021-03-25 08:55:51","1");
INSERT INTO audit_trail VALUES("1838","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:168","2021-03-25 09:01:01","2021-03-25 09:01:01","1");
INSERT INTO audit_trail VALUES("1839","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:169","2021-03-25 09:02:15","2021-03-25 09:02:15","1");
INSERT INTO audit_trail VALUES("1840","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:163","2021-03-25 09:03:11","2021-03-25 09:03:11","1");
INSERT INTO audit_trail VALUES("1841","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:134","2021-03-25 09:28:42","2021-03-25 09:28:42","1");
INSERT INTO audit_trail VALUES("1842","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-25 11:34:58","2021-03-25 11:34:58","1");
INSERT INTO audit_trail VALUES("1843","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:170","2021-03-26 01:15:17","2021-03-26 01:15:17","1");
INSERT INTO audit_trail VALUES("1844","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-26 01:19:25","2021-03-26 01:19:25","1");
INSERT INTO audit_trail VALUES("1845","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:171","2021-03-26 09:15:17","2021-03-26 09:15:17","1");
INSERT INTO audit_trail VALUES("1846","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:172","2021-03-26 09:21:40","2021-03-26 09:21:40","1");
INSERT INTO audit_trail VALUES("1847","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:173","2021-03-26 09:24:58","2021-03-26 09:24:58","1");
INSERT INTO audit_trail VALUES("1848","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:174","2021-03-26 09:26:18","2021-03-26 09:26:18","1");
INSERT INTO audit_trail VALUES("1849","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:170","2021-03-26 09:26:54","2021-03-26 09:26:54","1");
INSERT INTO audit_trail VALUES("1850","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:135","2021-03-26 09:31:39","2021-03-26 09:31:39","1");
INSERT INTO audit_trail VALUES("1851","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:136","2021-03-26 09:33:03","2021-03-26 09:33:03","1");
INSERT INTO audit_trail VALUES("1852","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:175","2021-03-26 10:20:15","2021-03-26 10:20:15","1");
INSERT INTO audit_trail VALUES("1853","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:176","2021-03-26 10:21:13","2021-03-26 10:21:13","1");
INSERT INTO audit_trail VALUES("1854","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-26 10:53:21","2021-03-26 10:53:21","1");
INSERT INTO audit_trail VALUES("1855","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:177","2021-03-27 01:19:43","2021-03-27 01:19:43","1");
INSERT INTO audit_trail VALUES("1856","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-27 01:26:13","2021-03-27 01:26:13","1");
INSERT INTO audit_trail VALUES("1857","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:137","2021-03-27 06:22:55","2021-03-27 06:22:55","1");
INSERT INTO audit_trail VALUES("1858","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:138","2021-03-27 06:24:18","2021-03-27 06:24:18","1");
INSERT INTO audit_trail VALUES("1859","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:139","2021-03-27 06:25:46","2021-03-27 06:25:46","1");
INSERT INTO audit_trail VALUES("1860","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:178","2021-03-27 06:40:47","2021-03-27 06:40:47","1");
INSERT INTO audit_trail VALUES("1861","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:179","2021-03-27 06:41:58","2021-03-27 06:41:58","1");
INSERT INTO audit_trail VALUES("1862","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:178","2021-03-27 06:42:56","2021-03-27 06:42:56","1");
INSERT INTO audit_trail VALUES("1863","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:180","2021-03-27 06:46:24","2021-03-27 06:46:24","1");
INSERT INTO audit_trail VALUES("1864","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:181","2021-03-27 06:48:03","2021-03-27 06:48:03","1");
INSERT INTO audit_trail VALUES("1865","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:182","2021-03-27 06:48:03","2021-03-27 06:48:03","1");
INSERT INTO audit_trail VALUES("1866","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-27 07:08:45","2021-03-27 07:08:45","1");
INSERT INTO audit_trail VALUES("1867","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-29 01:29:02","2021-03-29 01:29:02","");
INSERT INTO audit_trail VALUES("1868","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-29 01:29:04","2021-03-29 01:29:04","");
INSERT INTO audit_trail VALUES("1869","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:183","2021-03-29 01:47:14","2021-03-29 01:47:14","1");
INSERT INTO audit_trail VALUES("1870","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-29 01:51:28","2021-03-29 01:51:28","");
INSERT INTO audit_trail VALUES("1871","1","Admin Admin","","Logged in to system","2021-03-29 03:47:15","2021-03-29 03:47:15","");
INSERT INTO audit_trail VALUES("1872","1","Admin Admin","","Logged out of system","2021-03-29 03:52:25","2021-03-29 03:52:25","1");
INSERT INTO audit_trail VALUES("1873","1","Admin Admin","","Logged in to system","2021-03-29 03:53:19","2021-03-29 03:53:19","");
INSERT INTO audit_trail VALUES("1874","1","Admin Admin","","Logged in to system","2021-03-29 03:53:25","2021-03-29 03:53:25","1");
INSERT INTO audit_trail VALUES("1875","1","Admin Admin","","Added loan with id:164","2021-03-29 04:26:36","2021-03-29 04:26:36","1");
INSERT INTO audit_trail VALUES("1876","1","Admin Admin","","Deleted loan with id:141","2021-03-29 04:27:25","2021-03-29 04:27:25","1");
INSERT INTO audit_trail VALUES("1877","1","Admin Admin","","Approved loan with id:164","2021-03-29 04:27:44","2021-03-29 04:27:44","1");
INSERT INTO audit_trail VALUES("1878","1","Admin Admin","","Disbursed loan with id:164","2021-03-29 04:31:32","2021-03-29 04:31:32","1");
INSERT INTO audit_trail VALUES("1879","1","Admin Admin","","Deleted loan with id:88","2021-03-29 04:43:02","2021-03-29 04:43:02","1");
INSERT INTO audit_trail VALUES("1880","1","Admin Admin","","Added loan with id:165","2021-03-29 04:48:53","2021-03-29 04:48:53","1");
INSERT INTO audit_trail VALUES("1881","1","Admin Admin","","Approved loan with id:165","2021-03-29 04:49:37","2021-03-29 04:49:37","1");
INSERT INTO audit_trail VALUES("1882","1","Admin Admin","","Disbursed loan with id:165","2021-03-29 04:49:46","2021-03-29 04:49:46","1");
INSERT INTO audit_trail VALUES("1883","1","Admin Admin","","Deleted loan with id:132","2021-03-29 04:52:13","2021-03-29 04:52:13","1");
INSERT INTO audit_trail VALUES("1884","1","Admin Admin","","Added loan with id:166","2021-03-29 04:53:24","2021-03-29 04:53:24","1");
INSERT INTO audit_trail VALUES("1885","1","Admin Admin","","Approved loan with id:166","2021-03-29 04:54:43","2021-03-29 04:54:43","1");
INSERT INTO audit_trail VALUES("1886","1","Admin Admin","","Disbursed loan with id:166","2021-03-29 04:54:51","2021-03-29 04:54:51","1");
INSERT INTO audit_trail VALUES("1887","1","Admin Admin","","Added repayment for loan with id:166","2021-03-29 04:56:09","2021-03-29 04:56:09","1");
INSERT INTO audit_trail VALUES("1888","1","Admin Admin","","Updated repayment for loan with id:166","2021-03-29 05:05:05","2021-03-29 05:05:05","1");
INSERT INTO audit_trail VALUES("1889","1","Admin Admin","","Updated loan with id:166","2021-03-29 05:12:42","2021-03-29 05:12:42","1");
INSERT INTO audit_trail VALUES("1890","1","Admin Admin","","Added loan with id:167","2021-03-29 05:14:00","2021-03-29 05:14:00","1");
INSERT INTO audit_trail VALUES("1891","1","Admin Admin","","Approved loan with id:167","2021-03-29 05:14:28","2021-03-29 05:14:28","1");
INSERT INTO audit_trail VALUES("1892","1","Admin Admin","","Disbursed loan with id:167","2021-03-29 05:14:38","2021-03-29 05:14:38","1");
INSERT INTO audit_trail VALUES("1893","1","Admin Admin","","Added loan with id:168","2021-03-29 05:20:43","2021-03-29 05:20:43","1");
INSERT INTO audit_trail VALUES("1894","1","Admin Admin","","Approved loan with id:168","2021-03-29 05:21:04","2021-03-29 05:21:04","1");
INSERT INTO audit_trail VALUES("1895","1","Admin Admin","","Disbursed loan with id:168","2021-03-29 05:21:24","2021-03-29 05:21:24","1");
INSERT INTO audit_trail VALUES("1896","1","Admin Admin","","Deleted loan with id:168","2021-03-29 05:53:31","2021-03-29 05:53:31","1");
INSERT INTO audit_trail VALUES("1897","1","Admin Admin","","Deleted loan with id:167","2021-03-29 05:53:54","2021-03-29 05:53:54","1");
INSERT INTO audit_trail VALUES("1898","1","Admin Admin","","Updated loan with id:166","2021-03-29 05:56:09","2021-03-29 05:56:09","1");
INSERT INTO audit_trail VALUES("1899","1","Admin Admin","","Added loan with id:169","2021-03-29 05:59:23","2021-03-29 05:59:23","1");
INSERT INTO audit_trail VALUES("1900","1","Admin Admin","","Deleted loan with id:6","2021-03-29 05:59:27","2021-03-29 05:59:27","1");
INSERT INTO audit_trail VALUES("1901","1","Admin Admin","","Approved loan with id:169","2021-03-29 05:59:56","2021-03-29 05:59:56","1");
INSERT INTO audit_trail VALUES("1902","1","Admin Admin","","Disbursed loan with id:169","2021-03-29 06:00:04","2021-03-29 06:00:04","1");
INSERT INTO audit_trail VALUES("1903","1","Admin Admin","","Added repayment for loan with id:169","2021-03-29 06:01:48","2021-03-29 06:01:48","1");
INSERT INTO audit_trail VALUES("1904","1","Admin Admin","","Added loan with id:170","2021-03-29 06:07:08","2021-03-29 06:07:08","1");
INSERT INTO audit_trail VALUES("1905","1","Admin Admin","","Approved loan with id:170","2021-03-29 06:07:57","2021-03-29 06:07:57","1");
INSERT INTO audit_trail VALUES("1906","1","Admin Admin","","Disbursed loan with id:170","2021-03-29 06:08:04","2021-03-29 06:08:04","1");
INSERT INTO audit_trail VALUES("1907","1","Admin Admin","","Deleted loan with id:8","2021-03-29 06:13:08","2021-03-29 06:13:08","1");
INSERT INTO audit_trail VALUES("1908","1","Admin Admin","","Added loan with id:171","2021-03-29 06:15:58","2021-03-29 06:15:58","1");
INSERT INTO audit_trail VALUES("1909","1","Admin Admin","","Approved loan with id:171","2021-03-29 06:16:54","2021-03-29 06:16:54","1");
INSERT INTO audit_trail VALUES("1910","1","Admin Admin","","Disbursed loan with id:171","2021-03-29 06:17:01","2021-03-29 06:17:01","1");
INSERT INTO audit_trail VALUES("1911","1","Admin Admin","","Deleted loan with id:28","2021-03-29 06:20:20","2021-03-29 06:20:20","1");
INSERT INTO audit_trail VALUES("1912","1","Admin Admin","","Added loan with id:172","2021-03-29 06:20:47","2021-03-29 06:20:47","1");
INSERT INTO audit_trail VALUES("1913","1","Admin Admin","","Approved loan with id:172","2021-03-29 06:21:30","2021-03-29 06:21:30","1");
INSERT INTO audit_trail VALUES("1914","1","Admin Admin","","Disbursed loan with id:172","2021-03-29 06:21:38","2021-03-29 06:21:38","1");
INSERT INTO audit_trail VALUES("1915","1","Admin Admin","","Added repayment for loan with id:172","2021-03-29 06:23:51","2021-03-29 06:23:51","1");
INSERT INTO audit_trail VALUES("1916","1","Admin Admin","","Added loan with id:173","2021-03-29 06:26:02","2021-03-29 06:26:02","1");
INSERT INTO audit_trail VALUES("1917","1","Admin Admin","","Deleted loan with id:44","2021-03-29 06:26:13","2021-03-29 06:26:13","1");
INSERT INTO audit_trail VALUES("1918","1","Admin Admin","","Approved loan with id:173","2021-03-29 06:26:43","2021-03-29 06:26:43","1");
INSERT INTO audit_trail VALUES("1919","1","Admin Admin","","Disbursed loan with id:173","2021-03-29 06:26:53","2021-03-29 06:26:53","1");
INSERT INTO audit_trail VALUES("1920","1","Admin Admin","","Added repayment for loan with id:173","2021-03-29 06:28:29","2021-03-29 06:28:29","1");
INSERT INTO audit_trail VALUES("1921","1","Admin Admin","","Deleted loan with id:85","2021-03-29 06:29:14","2021-03-29 06:29:14","1");
INSERT INTO audit_trail VALUES("1922","1","Admin Admin","","Added loan with id:174","2021-03-29 06:29:18","2021-03-29 06:29:18","1");
INSERT INTO audit_trail VALUES("1923","1","Admin Admin","","Approved loan with id:174","2021-03-29 06:30:29","2021-03-29 06:30:29","1");
INSERT INTO audit_trail VALUES("1924","1","Admin Admin","","Disbursed loan with id:174","2021-03-29 06:30:44","2021-03-29 06:30:44","1");
INSERT INTO audit_trail VALUES("1925","1","Admin Admin","","Added repayment for loan with id:174","2021-03-29 06:32:05","2021-03-29 06:32:05","1");
INSERT INTO audit_trail VALUES("1926","1","Admin Admin","","Deleted loan with id:7","2021-03-29 06:32:44","2021-03-29 06:32:44","1");
INSERT INTO audit_trail VALUES("1927","1","Admin Admin","","Added loan with id:175","2021-03-29 06:32:45","2021-03-29 06:32:45","1");
INSERT INTO audit_trail VALUES("1928","1","Admin Admin","","Approved loan with id:175","2021-03-29 06:33:24","2021-03-29 06:33:24","1");
INSERT INTO audit_trail VALUES("1929","1","Admin Admin","","Disbursed loan with id:175","2021-03-29 06:34:08","2021-03-29 06:34:08","1");
INSERT INTO audit_trail VALUES("1930","1","Admin Admin","","Added repayment for loan with id:175","2021-03-29 06:34:41","2021-03-29 06:34:41","1");
INSERT INTO audit_trail VALUES("1931","1","Admin Admin","","Deleted loan with id:78","2021-03-29 06:35:10","2021-03-29 06:35:10","1");
INSERT INTO audit_trail VALUES("1932","1","Admin Admin","","Added loan with id:176","2021-03-29 06:35:14","2021-03-29 06:35:14","1");
INSERT INTO audit_trail VALUES("1933","1","Admin Admin","","Approved loan with id:176","2021-03-29 06:35:40","2021-03-29 06:35:40","1");
INSERT INTO audit_trail VALUES("1934","1","Admin Admin","","Disbursed loan with id:176","2021-03-29 06:35:47","2021-03-29 06:35:47","1");
INSERT INTO audit_trail VALUES("1935","1","Admin Admin","","Added repayment for loan with id:176","2021-03-29 06:36:25","2021-03-29 06:36:25","1");
INSERT INTO audit_trail VALUES("1936","1","Admin Admin","","Deleted loan with id:103","2021-03-29 06:37:04","2021-03-29 06:37:04","1");
INSERT INTO audit_trail VALUES("1937","1","Admin Admin","","Added loan with id:177","2021-03-29 06:37:05","2021-03-29 06:37:05","1");
INSERT INTO audit_trail VALUES("1938","1","Admin Admin","","Approved loan with id:177","2021-03-29 06:38:30","2021-03-29 06:38:30","1");
INSERT INTO audit_trail VALUES("1939","1","Admin Admin","","Disbursed loan with id:177","2021-03-29 06:38:47","2021-03-29 06:38:47","1");
INSERT INTO audit_trail VALUES("1940","1","Admin Admin","","Disbursed loan with id:177","2021-03-29 06:38:47","2021-03-29 06:38:47","1");
INSERT INTO audit_trail VALUES("1941","1","Admin Admin","","Added repayment for loan with id:177","2021-03-29 06:42:27","2021-03-29 06:42:27","1");
INSERT INTO audit_trail VALUES("1942","1","Admin Admin","","Deleted loan with id:24","2021-03-29 06:44:11","2021-03-29 06:44:11","1");
INSERT INTO audit_trail VALUES("1943","1","Admin Admin","","Added loan with id:178","2021-03-29 06:45:29","2021-03-29 06:45:29","1");
INSERT INTO audit_trail VALUES("1944","1","Admin Admin","","Approved loan with id:178","2021-03-29 06:45:56","2021-03-29 06:45:56","1");
INSERT INTO audit_trail VALUES("1945","1","Admin Admin","","Disbursed loan with id:178","2021-03-29 06:46:02","2021-03-29 06:46:02","1");
INSERT INTO audit_trail VALUES("1946","1","Admin Admin","","Added repayment for loan with id:178","2021-03-29 06:46:57","2021-03-29 06:46:57","1");
INSERT INTO audit_trail VALUES("1947","1","Admin Admin","","Deleted loan with id:95","2021-03-29 06:47:21","2021-03-29 06:47:21","1");
INSERT INTO audit_trail VALUES("1948","1","Admin Admin","","Added loan with id:179","2021-03-29 06:47:31","2021-03-29 06:47:31","1");
INSERT INTO audit_trail VALUES("1949","1","Admin Admin","","Approved loan with id:179","2021-03-29 06:48:02","2021-03-29 06:48:02","1");
INSERT INTO audit_trail VALUES("1950","1","Admin Admin","","Disbursed loan with id:179","2021-03-29 06:48:11","2021-03-29 06:48:11","1");
INSERT INTO audit_trail VALUES("1951","1","Admin Admin","","Added repayment for loan with id:179","2021-03-29 06:49:16","2021-03-29 06:49:16","1");
INSERT INTO audit_trail VALUES("1952","1","Admin Admin","","Added loan with id:180","2021-03-29 06:49:55","2021-03-29 06:49:55","1");
INSERT INTO audit_trail VALUES("1953","1","Admin Admin","","Deleted loan with id:41","2021-03-29 06:49:56","2021-03-29 06:49:56","1");
INSERT INTO audit_trail VALUES("1954","1","Admin Admin","","Approved loan with id:180","2021-03-29 06:50:57","2021-03-29 06:50:57","1");
INSERT INTO audit_trail VALUES("1955","1","Admin Admin","","Disbursed loan with id:180","2021-03-29 06:51:04","2021-03-29 06:51:04","1");
INSERT INTO audit_trail VALUES("1956","1","Admin Admin","","Added repayment for loan with id:180","2021-03-29 06:51:48","2021-03-29 06:51:48","1");
INSERT INTO audit_trail VALUES("1957","1","Admin Admin","","Added loan with id:181","2021-03-29 06:53:10","2021-03-29 06:53:10","1");
INSERT INTO audit_trail VALUES("1958","1","Admin Admin","","Approved loan with id:181","2021-03-29 06:53:35","2021-03-29 06:53:35","1");
INSERT INTO audit_trail VALUES("1959","1","Admin Admin","","Disbursed loan with id:181","2021-03-29 06:53:44","2021-03-29 06:53:44","1");
INSERT INTO audit_trail VALUES("1960","1","Admin Admin","","Added repayment for loan with id:181","2021-03-29 06:54:26","2021-03-29 06:54:26","1");
INSERT INTO audit_trail VALUES("1961","1","Admin Admin","","Added loan with id:182","2021-03-29 06:55:35","2021-03-29 06:55:35","1");
INSERT INTO audit_trail VALUES("1962","1","Admin Admin","","Deleted loan with id:125","2021-03-29 06:55:37","2021-03-29 06:55:37","1");
INSERT INTO audit_trail VALUES("1963","1","Admin Admin","","Approved loan with id:182","2021-03-29 06:55:55","2021-03-29 06:55:55","1");
INSERT INTO audit_trail VALUES("1964","1","Admin Admin","","Disbursed loan with id:182","2021-03-29 06:56:02","2021-03-29 06:56:02","1");
INSERT INTO audit_trail VALUES("1965","1","Admin Admin","","Added repayment for loan with id:182","2021-03-29 06:57:08","2021-03-29 06:57:08","1");
INSERT INTO audit_trail VALUES("1966","1","Admin Admin","","Added loan with id:183","2021-03-29 06:59:11","2021-03-29 06:59:11","1");
INSERT INTO audit_trail VALUES("1967","1","Admin Admin","","Deleted loan with id:116","2021-03-29 06:59:18","2021-03-29 06:59:18","1");
INSERT INTO audit_trail VALUES("1968","1","Admin Admin","","Approved loan with id:183","2021-03-29 06:59:42","2021-03-29 06:59:42","1");
INSERT INTO audit_trail VALUES("1969","1","Admin Admin","","Disbursed loan with id:183","2021-03-29 06:59:48","2021-03-29 06:59:48","1");
INSERT INTO audit_trail VALUES("1970","1","Admin Admin","","Added repayment for loan with id:183","2021-03-29 07:04:00","2021-03-29 07:04:00","1");
INSERT INTO audit_trail VALUES("1971","1","Admin Admin","","Undisbursed loan with id:84","2021-03-29 07:04:38","2021-03-29 07:04:38","1");
INSERT INTO audit_trail VALUES("1972","1","Admin Admin","","Unapproved loan with id:84","2021-03-29 07:04:46","2021-03-29 07:04:46","1");
INSERT INTO audit_trail VALUES("1973","1","Admin Admin","","Updated loan with id:84","2021-03-29 07:05:41","2021-03-29 07:05:41","1");
INSERT INTO audit_trail VALUES("1974","1","Admin Admin","","Approved loan with id:84","2021-03-29 07:06:20","2021-03-29 07:06:20","1");
INSERT INTO audit_trail VALUES("1975","1","Admin Admin","","Disbursed loan with id:84","2021-03-29 07:06:28","2021-03-29 07:06:28","1");
INSERT INTO audit_trail VALUES("1976","1","Admin Admin","","Logged in to system","2021-03-29 07:07:43","2021-03-29 07:07:43","");
INSERT INTO audit_trail VALUES("1977","1","Admin Admin","","Added repayment for loan with id:84","2021-03-29 07:12:42","2021-03-29 07:12:42","1");
INSERT INTO audit_trail VALUES("1978","1","Admin Admin","","Undisbursed loan with id:45","2021-03-29 07:13:03","2021-03-29 07:13:03","1");
INSERT INTO audit_trail VALUES("1979","1","Admin Admin","","Unapproved loan with id:45","2021-03-29 07:13:16","2021-03-29 07:13:16","1");
INSERT INTO audit_trail VALUES("1980","1","Admin Admin","","Undisbursed loan with id:138","2021-03-29 07:14:51","2021-03-29 07:14:51","1");
INSERT INTO audit_trail VALUES("1981","1","Admin Admin","","Unapproved loan with id:138","2021-03-29 07:15:02","2021-03-29 07:15:02","1");
INSERT INTO audit_trail VALUES("1982","1","Admin Admin","","Undisbursed loan with id:60","2021-03-29 07:15:13","2021-03-29 07:15:13","1");
INSERT INTO audit_trail VALUES("1983","1","Admin Admin","","Unapproved loan with id:60","2021-03-29 07:15:34","2021-03-29 07:15:34","1");
INSERT INTO audit_trail VALUES("1984","1","Admin Admin","","Updated loan with id:60","2021-03-29 07:16:19","2021-03-29 07:16:19","1");
INSERT INTO audit_trail VALUES("1985","1","Admin Admin","","Updated loan with id:138","2021-03-29 07:16:22","2021-03-29 07:16:22","1");
INSERT INTO audit_trail VALUES("1986","1","Admin Admin","","Updated loan with id:45","2021-03-29 07:16:35","2021-03-29 07:16:35","1");
INSERT INTO audit_trail VALUES("1987","1","Admin Admin","","Approved loan with id:138","2021-03-29 07:16:57","2021-03-29 07:16:57","1");
INSERT INTO audit_trail VALUES("1988","1","Admin Admin","","Approved loan with id:60","2021-03-29 07:17:04","2021-03-29 07:17:04","1");
INSERT INTO audit_trail VALUES("1989","1","Admin Admin","","Disbursed loan with id:138","2021-03-29 07:17:10","2021-03-29 07:17:10","1");
INSERT INTO audit_trail VALUES("1990","1","Admin Admin","","Disbursed loan with id:60","2021-03-29 07:17:47","2021-03-29 07:17:47","1");
INSERT INTO audit_trail VALUES("1991","1","Admin Admin","","Added repayment for loan with id:138","2021-03-29 07:17:49","2021-03-29 07:17:49","1");
INSERT INTO audit_trail VALUES("1992","1","Admin Admin","","Added repayment for loan with id:60","2021-03-29 07:18:35","2021-03-29 07:18:35","1");
INSERT INTO audit_trail VALUES("1993","1","Admin Admin","","Approved loan with id:45","2021-03-29 07:19:12","2021-03-29 07:19:12","1");
INSERT INTO audit_trail VALUES("1994","1","Admin Admin","","Disbursed loan with id:45","2021-03-29 07:19:18","2021-03-29 07:19:18","1");
INSERT INTO audit_trail VALUES("1995","1","Admin Admin","","Added repayment for loan with id:45","2021-03-29 07:19:55","2021-03-29 07:19:55","1");
INSERT INTO audit_trail VALUES("1996","1","Admin Admin","","Undisbursed loan with id:49","2021-03-29 07:20:37","2021-03-29 07:20:37","1");
INSERT INTO audit_trail VALUES("1997","1","Admin Admin","","Unapproved loan with id:49","2021-03-29 07:20:43","2021-03-29 07:20:43","1");
INSERT INTO audit_trail VALUES("1998","1","Admin Admin","","Undisbursed loan with id:112","2021-03-29 07:21:45","2021-03-29 07:21:45","1");
INSERT INTO audit_trail VALUES("1999","1","Admin Admin","","Updated loan with id:49","2021-03-29 07:21:47","2021-03-29 07:21:47","1");
INSERT INTO audit_trail VALUES("2000","1","Admin Admin","","Unapproved loan with id:112","2021-03-29 07:21:53","2021-03-29 07:21:53","1");
INSERT INTO audit_trail VALUES("2001","1","Admin Admin","","Approved loan with id:112","2021-03-29 07:21:59","2021-03-29 07:21:59","1");
INSERT INTO audit_trail VALUES("2002","1","Admin Admin","","Disbursed loan with id:112","2021-03-29 07:22:07","2021-03-29 07:22:07","1");
INSERT INTO audit_trail VALUES("2003","1","Admin Admin","","Undisbursed loan with id:112","2021-03-29 07:22:17","2021-03-29 07:22:17","1");
INSERT INTO audit_trail VALUES("2004","1","Admin Admin","","Unapproved loan with id:112","2021-03-29 07:22:23","2021-03-29 07:22:23","1");
INSERT INTO audit_trail VALUES("2005","1","Admin Admin","","Approved loan with id:112","2021-03-29 07:22:45","2021-03-29 07:22:45","1");
INSERT INTO audit_trail VALUES("2006","1","Admin Admin","","Undisbursed loan with id:40","2021-03-29 07:23:03","2021-03-29 07:23:03","1");
INSERT INTO audit_trail VALUES("2007","1","Admin Admin","","Approved loan with id:49","2021-03-29 07:23:05","2021-03-29 07:23:05","1");
INSERT INTO audit_trail VALUES("2008","1","Admin Admin","","Disbursed loan with id:49","2021-03-29 07:23:12","2021-03-29 07:23:12","1");
INSERT INTO audit_trail VALUES("2009","1","Admin Admin","","Unapproved loan with id:40","2021-03-29 07:23:19","2021-03-29 07:23:19","1");
INSERT INTO audit_trail VALUES("2010","1","Admin Admin","","Added repayment for loan with id:49","2021-03-29 07:23:46","2021-03-29 07:23:46","1");
INSERT INTO audit_trail VALUES("2011","1","Admin Admin","","Updated loan with id:40","2021-03-29 07:23:56","2021-03-29 07:23:56","1");
INSERT INTO audit_trail VALUES("2012","1","Admin Admin","","Approved loan with id:40","2021-03-29 07:24:31","2021-03-29 07:24:31","1");
INSERT INTO audit_trail VALUES("2013","1","Admin Admin","","Undisbursed loan with id:13","2021-03-29 07:24:44","2021-03-29 07:24:44","1");
INSERT INTO audit_trail VALUES("2014","1","Admin Admin","","Undisbursed loan with id:122","2021-03-29 07:24:46","2021-03-29 07:24:46","1");
INSERT INTO audit_trail VALUES("2015","1","Admin Admin","","Unapproved loan with id:122","2021-03-29 07:24:55","2021-03-29 07:24:55","1");
INSERT INTO audit_trail VALUES("2016","1","Admin Admin","","Disbursed loan with id:40","2021-03-29 07:25:08","2021-03-29 07:25:08","1");
INSERT INTO audit_trail VALUES("2017","1","Admin Admin","","Updated loan with id:122","2021-03-29 07:25:32","2021-03-29 07:25:32","1");
INSERT INTO audit_trail VALUES("2018","1","Admin Admin","","Added repayment for loan with id:40","2021-03-29 07:26:02","2021-03-29 07:26:02","1");
INSERT INTO audit_trail VALUES("2019","1","Admin Admin","","Approved loan with id:122","2021-03-29 07:26:15","2021-03-29 07:26:15","1");
INSERT INTO audit_trail VALUES("2020","1","Admin Admin","","Disbursed loan with id:122","2021-03-29 07:26:32","2021-03-29 07:26:32","1");
INSERT INTO audit_trail VALUES("2021","1","Admin Admin","","Updated loan with id:13","2021-03-29 07:27:50","2021-03-29 07:27:50","1");
INSERT INTO audit_trail VALUES("2022","1","Admin Admin","","Unapproved loan with id:13","2021-03-29 07:28:26","2021-03-29 07:28:26","1");
INSERT INTO audit_trail VALUES("2023","1","Admin Admin","","Undisbursed loan with id:71","2021-03-29 07:28:26","2021-03-29 07:28:26","1");
INSERT INTO audit_trail VALUES("2024","1","Admin Admin","","Undisbursed loan with id:4","2021-03-29 07:28:38","2021-03-29 07:28:38","1");
INSERT INTO audit_trail VALUES("2025","1","Admin Admin","","Unapproved loan with id:71","2021-03-29 07:28:41","2021-03-29 07:28:41","1");
INSERT INTO audit_trail VALUES("2026","1","Admin Admin","","Updated loan with id:13","2021-03-29 07:28:42","2021-03-29 07:28:42","1");
INSERT INTO audit_trail VALUES("2027","1","Admin Admin","","Unapproved loan with id:4","2021-03-29 07:28:48","2021-03-29 07:28:48","1");
INSERT INTO audit_trail VALUES("2028","1","Admin Admin","","Approved loan with id:13","2021-03-29 07:29:07","2021-03-29 07:29:07","1");
INSERT INTO audit_trail VALUES("2029","1","Admin Admin","","Updated loan with id:4","2021-03-29 07:29:08","2021-03-29 07:29:08","1");
INSERT INTO audit_trail VALUES("2030","1","Admin Admin","","Disbursed loan with id:13","2021-03-29 07:29:16","2021-03-29 07:29:16","1");
INSERT INTO audit_trail VALUES("2031","1","Admin Admin","","Updated loan with id:71","2021-03-29 07:29:26","2021-03-29 07:29:26","1");
INSERT INTO audit_trail VALUES("2032","1","Admin Admin","","Approved loan with id:4","2021-03-29 07:29:44","2021-03-29 07:29:44","1");
INSERT INTO audit_trail VALUES("2033","1","Admin Admin","","Disbursed loan with id:4","2021-03-29 07:29:52","2021-03-29 07:29:52","1");
INSERT INTO audit_trail VALUES("2034","1","Admin Admin","","Added repayment for loan with id:13","2021-03-29 07:30:27","2021-03-29 07:30:27","1");
INSERT INTO audit_trail VALUES("2035","1","Admin Admin","","Added repayment for loan with id:4","2021-03-29 07:30:28","2021-03-29 07:30:28","1");
INSERT INTO audit_trail VALUES("2036","1","Admin Admin","","Approved loan with id:71","2021-03-29 07:31:03","2021-03-29 07:31:03","1");
INSERT INTO audit_trail VALUES("2037","1","Admin Admin","","Disbursed loan with id:71","2021-03-29 07:31:28","2021-03-29 07:31:28","1");
INSERT INTO audit_trail VALUES("2038","1","Admin Admin","","Undisbursed loan with id:97","2021-03-29 07:31:35","2021-03-29 07:31:35","1");
INSERT INTO audit_trail VALUES("2039","1","Admin Admin","","Disbursed loan with id:97","2021-03-29 07:31:42","2021-03-29 07:31:42","1");
INSERT INTO audit_trail VALUES("2040","1","Admin Admin","","Undisbursed loan with id:97","2021-03-29 07:32:13","2021-03-29 07:32:13","1");
INSERT INTO audit_trail VALUES("2041","1","Admin Admin","","Unapproved loan with id:97","2021-03-29 07:32:20","2021-03-29 07:32:20","1");
INSERT INTO audit_trail VALUES("2042","1","Admin Admin","","Updated loan with id:97","2021-03-29 07:32:42","2021-03-29 07:32:42","1");
INSERT INTO audit_trail VALUES("2043","1","Admin Admin","","Undisbursed loan with id:53","2021-03-29 07:33:17","2021-03-29 07:33:17","1");
INSERT INTO audit_trail VALUES("2044","1","Admin Admin","","Unapproved loan with id:53","2021-03-29 07:33:24","2021-03-29 07:33:24","1");
INSERT INTO audit_trail VALUES("2045","1","Admin Admin","","Undisbursed loan with id:123","2021-03-29 07:33:25","2021-03-29 07:33:25","1");
INSERT INTO audit_trail VALUES("2046","1","Admin Admin","","Updated loan with id:97","2021-03-29 07:33:33","2021-03-29 07:33:33","1");
INSERT INTO audit_trail VALUES("2047","1","Admin Admin","","Unapproved loan with id:123","2021-03-29 07:33:36","2021-03-29 07:33:36","1");
INSERT INTO audit_trail VALUES("2048","1","Admin Admin","","Updated loan with id:123","2021-03-29 07:34:00","2021-03-29 07:34:00","1");
INSERT INTO audit_trail VALUES("2049","1","Admin Admin","","Approved loan with id:97","2021-03-29 07:34:11","2021-03-29 07:34:11","1");
INSERT INTO audit_trail VALUES("2050","1","Admin Admin","","Updated loan with id:53","2021-03-29 07:34:16","2021-03-29 07:34:16","1");
INSERT INTO audit_trail VALUES("2051","1","Admin Admin","","Disbursed loan with id:97","2021-03-29 07:34:19","2021-03-29 07:34:19","1");
INSERT INTO audit_trail VALUES("2052","1","Admin Admin","","Approved loan with id:123","2021-03-29 07:34:29","2021-03-29 07:34:29","1");
INSERT INTO audit_trail VALUES("2053","1","Admin Admin","","Disbursed loan with id:123","2021-03-29 07:34:38","2021-03-29 07:34:38","1");
INSERT INTO audit_trail VALUES("2054","1","Admin Admin","","Added repayment for loan with id:97","2021-03-29 07:34:45","2021-03-29 07:34:45","1");
INSERT INTO audit_trail VALUES("2055","1","Admin Admin","","Added repayment for loan with id:123","2021-03-29 07:35:07","2021-03-29 07:35:07","1");
INSERT INTO audit_trail VALUES("2056","1","Admin Admin","","Approved loan with id:53","2021-03-29 07:35:12","2021-03-29 07:35:12","1");
INSERT INTO audit_trail VALUES("2057","1","Admin Admin","","Disbursed loan with id:53","2021-03-29 07:35:23","2021-03-29 07:35:23","1");
INSERT INTO audit_trail VALUES("2058","1","Admin Admin","","Undisbursed loan with id:36","2021-03-29 07:35:53","2021-03-29 07:35:53","1");
INSERT INTO audit_trail VALUES("2059","1","Admin Admin","","Unapproved loan with id:36","2021-03-29 07:36:01","2021-03-29 07:36:01","1");
INSERT INTO audit_trail VALUES("2060","1","Admin Admin","","Added repayment for loan with id:53","2021-03-29 07:36:02","2021-03-29 07:36:02","1");
INSERT INTO audit_trail VALUES("2061","1","Admin Admin","","Updated loan with id:36","2021-03-29 07:36:21","2021-03-29 07:36:21","1");
INSERT INTO audit_trail VALUES("2062","1","Admin Admin","","Undisbursed loan with id:43","2021-03-29 07:36:29","2021-03-29 07:36:29","1");
INSERT INTO audit_trail VALUES("2063","1","Admin Admin","","Unapproved loan with id:43","2021-03-29 07:36:37","2021-03-29 07:36:37","1");
INSERT INTO audit_trail VALUES("2064","1","Admin Admin","","Approved loan with id:36","2021-03-29 07:36:59","2021-03-29 07:36:59","1");
INSERT INTO audit_trail VALUES("2065","1","Admin Admin","","Updated loan with id:43","2021-03-29 07:37:06","2021-03-29 07:37:06","1");
INSERT INTO audit_trail VALUES("2066","1","Admin Admin","","Disbursed loan with id:36","2021-03-29 07:37:06","2021-03-29 07:37:06","1");
INSERT INTO audit_trail VALUES("2067","1","Admin Admin","","Added repayment for loan with id:36","2021-03-29 07:37:38","2021-03-29 07:37:38","1");
INSERT INTO audit_trail VALUES("2068","1","Admin Admin","","Approved loan with id:43","2021-03-29 07:37:56","2021-03-29 07:37:56","1");
INSERT INTO audit_trail VALUES("2069","1","Admin Admin","","Disbursed loan with id:43","2021-03-29 07:38:03","2021-03-29 07:38:03","1");
INSERT INTO audit_trail VALUES("2070","1","Admin Admin","","Added repayment for loan with id:43","2021-03-29 07:38:42","2021-03-29 07:38:42","1");
INSERT INTO audit_trail VALUES("2071","1","Admin Admin","","Undisbursed loan with id:140","2021-03-29 07:39:55","2021-03-29 07:39:55","1");
INSERT INTO audit_trail VALUES("2072","1","Admin Admin","","Unapproved loan with id:140","2021-03-29 07:40:02","2021-03-29 07:40:02","1");
INSERT INTO audit_trail VALUES("2073","1","Admin Admin","","Undisbursed loan with id:9","2021-03-29 07:40:17","2021-03-29 07:40:17","1");
INSERT INTO audit_trail VALUES("2074","1","Admin Admin","","Updated loan with id:140","2021-03-29 07:40:22","2021-03-29 07:40:22","1");
INSERT INTO audit_trail VALUES("2075","1","Admin Admin","","Unapproved loan with id:9","2021-03-29 07:40:31","2021-03-29 07:40:31","1");
INSERT INTO audit_trail VALUES("2076","1","Admin Admin","","Updated loan with id:9","2021-03-29 07:40:47","2021-03-29 07:40:47","1");
INSERT INTO audit_trail VALUES("2077","1","Admin Admin","","Undisbursed loan with id:16","2021-03-29 07:41:04","2021-03-29 07:41:04","1");
INSERT INTO audit_trail VALUES("2078","1","Admin Admin","","Approved loan with id:140","2021-03-29 07:41:16","2021-03-29 07:41:16","1");
INSERT INTO audit_trail VALUES("2079","1","Admin Admin","","Disbursed loan with id:140","2021-03-29 07:41:22","2021-03-29 07:41:22","1");
INSERT INTO audit_trail VALUES("2080","1","Admin Admin","","Approved loan with id:9","2021-03-29 07:41:29","2021-03-29 07:41:29","1");
INSERT INTO audit_trail VALUES("2081","1","Admin Admin","","Disbursed loan with id:9","2021-03-29 07:41:39","2021-03-29 07:41:39","1");
INSERT INTO audit_trail VALUES("2082","1","Admin Admin","","Unapproved loan with id:16","2021-03-29 07:42:04","2021-03-29 07:42:04","1");
INSERT INTO audit_trail VALUES("2083","1","Admin Admin","","Added repayment for loan with id:9","2021-03-29 07:42:11","2021-03-29 07:42:11","1");
INSERT INTO audit_trail VALUES("2084","1","Admin Admin","","Added repayment for loan with id:140","2021-03-29 07:42:23","2021-03-29 07:42:23","1");
INSERT INTO audit_trail VALUES("2085","1","Admin Admin","","Updated loan with id:16","2021-03-29 07:42:45","2021-03-29 07:42:45","1");
INSERT INTO audit_trail VALUES("2086","1","Admin Admin","","Undisbursed loan with id:59","2021-03-29 07:42:48","2021-03-29 07:42:48","1");
INSERT INTO audit_trail VALUES("2087","1","Admin Admin","","Approved loan with id:16","2021-03-29 07:43:26","2021-03-29 07:43:26","1");
INSERT INTO audit_trail VALUES("2088","1","Admin Admin","","Unapproved loan with id:59","2021-03-29 07:43:27","2021-03-29 07:43:27","1");
INSERT INTO audit_trail VALUES("2089","1","Admin Admin","","Disbursed loan with id:16","2021-03-29 07:43:45","2021-03-29 07:43:45","1");
INSERT INTO audit_trail VALUES("2090","1","Admin Admin","","Added repayment for loan with id:9","2021-03-29 07:43:59","2021-03-29 07:43:59","1");
INSERT INTO audit_trail VALUES("2091","1","Admin Admin","","Updated loan with id:59","2021-03-29 07:44:49","2021-03-29 07:44:49","1");
INSERT INTO audit_trail VALUES("2092","1","Admin Admin","","Added repayment for loan with id:16","2021-03-29 07:45:09","2021-03-29 07:45:09","1");
INSERT INTO audit_trail VALUES("2093","1","Admin Admin","","Undisbursed loan with id:146","2021-03-29 07:45:16","2021-03-29 07:45:16","1");
INSERT INTO audit_trail VALUES("2094","1","Admin Admin","","Unapproved loan with id:146","2021-03-29 07:45:24","2021-03-29 07:45:24","1");
INSERT INTO audit_trail VALUES("2095","1","Admin Admin","","Approved loan with id:59","2021-03-29 07:45:32","2021-03-29 07:45:32","1");
INSERT INTO audit_trail VALUES("2096","1","Admin Admin","","Updated loan with id:146","2021-03-29 07:45:41","2021-03-29 07:45:41","1");
INSERT INTO audit_trail VALUES("2097","1","Admin Admin","","Disbursed loan with id:59","2021-03-29 07:45:42","2021-03-29 07:45:42","1");
INSERT INTO audit_trail VALUES("2098","1","Admin Admin","","Approved loan with id:146","2021-03-29 07:46:10","2021-03-29 07:46:10","1");
INSERT INTO audit_trail VALUES("2099","1","Admin Admin","","Disbursed loan with id:146","2021-03-29 07:46:17","2021-03-29 07:46:17","1");
INSERT INTO audit_trail VALUES("2100","1","Admin Admin","","Added repayment for loan with id:59","2021-03-29 07:46:28","2021-03-29 07:46:28","1");
INSERT INTO audit_trail VALUES("2101","1","Admin Admin","","Added repayment for loan with id:146","2021-03-29 07:46:42","2021-03-29 07:46:42","1");
INSERT INTO audit_trail VALUES("2102","1","Admin Admin","","Undisbursed loan with id:46","2021-03-29 07:47:13","2021-03-29 07:47:13","1");
INSERT INTO audit_trail VALUES("2103","1","Admin Admin","","Unapproved loan with id:46","2021-03-29 07:47:24","2021-03-29 07:47:24","1");
INSERT INTO audit_trail VALUES("2104","1","Admin Admin","","Updated loan with id:46","2021-03-29 07:47:50","2021-03-29 07:47:50","1");
INSERT INTO audit_trail VALUES("2105","1","Admin Admin","","Undisbursed loan with id:86","2021-03-29 07:48:14","2021-03-29 07:48:14","1");
INSERT INTO audit_trail VALUES("2106","1","Admin Admin","","Undisbursed loan with id:117","2021-03-29 07:48:16","2021-03-29 07:48:16","1");
INSERT INTO audit_trail VALUES("2107","1","Admin Admin","","Unapproved loan with id:86","2021-03-29 07:48:26","2021-03-29 07:48:26","1");
INSERT INTO audit_trail VALUES("2108","1","Admin Admin","","Unapproved loan with id:117","2021-03-29 07:48:27","2021-03-29 07:48:27","1");
INSERT INTO audit_trail VALUES("2109","1","Admin Admin","","Updated loan with id:86","2021-03-29 07:48:41","2021-03-29 07:48:41","1");
INSERT INTO audit_trail VALUES("2110","1","Admin Admin","","Approved loan with id:46","2021-03-29 07:48:47","2021-03-29 07:48:47","1");
INSERT INTO audit_trail VALUES("2111","1","Admin Admin","","Disbursed loan with id:46","2021-03-29 07:48:57","2021-03-29 07:48:57","1");
INSERT INTO audit_trail VALUES("2112","1","Admin Admin","","Updated loan with id:117","2021-03-29 07:49:06","2021-03-29 07:49:06","1");
INSERT INTO audit_trail VALUES("2113","1","Admin Admin","","Approved loan with id:86","2021-03-29 07:49:06","2021-03-29 07:49:06","1");
INSERT INTO audit_trail VALUES("2114","1","Admin Admin","","Disbursed loan with id:86","2021-03-29 07:49:19","2021-03-29 07:49:19","1");
INSERT INTO audit_trail VALUES("2115","1","Admin Admin","","Added repayment for loan with id:46","2021-03-29 07:49:47","2021-03-29 07:49:47","1");
INSERT INTO audit_trail VALUES("2116","1","Admin Admin","","Approved loan with id:117","2021-03-29 07:49:53","2021-03-29 07:49:53","1");
INSERT INTO audit_trail VALUES("2117","1","Admin Admin","","Added repayment for loan with id:86","2021-03-29 07:49:56","2021-03-29 07:49:56","1");
INSERT INTO audit_trail VALUES("2118","1","Admin Admin","","Disbursed loan with id:117","2021-03-29 07:50:02","2021-03-29 07:50:02","1");
INSERT INTO audit_trail VALUES("2119","1","Admin Admin","","Added repayment for loan with id:117","2021-03-29 07:50:59","2021-03-29 07:50:59","1");
INSERT INTO audit_trail VALUES("2120","1","Admin Admin","","Undisbursed loan with id:12","2021-03-29 07:51:34","2021-03-29 07:51:34","1");
INSERT INTO audit_trail VALUES("2121","1","Admin Admin","","Unapproved loan with id:12","2021-03-29 07:51:39","2021-03-29 07:51:39","1");
INSERT INTO audit_trail VALUES("2122","1","Admin Admin","","Undisbursed loan with id:64","2021-03-29 07:51:48","2021-03-29 07:51:48","1");
INSERT INTO audit_trail VALUES("2123","1","Admin Admin","","Unapproved loan with id:64","2021-03-29 07:51:55","2021-03-29 07:51:55","1");
INSERT INTO audit_trail VALUES("2124","1","Admin Admin","","Updated loan with id:12","2021-03-29 07:51:57","2021-03-29 07:51:57","1");
INSERT INTO audit_trail VALUES("2125","1","Admin Admin","","Approved loan with id:12","2021-03-29 07:52:26","2021-03-29 07:52:26","1");
INSERT INTO audit_trail VALUES("2126","1","Admin Admin","","Disbursed loan with id:12","2021-03-29 07:52:34","2021-03-29 07:52:34","1");
INSERT INTO audit_trail VALUES("2127","1","Admin Admin","","Updated loan with id:64","2021-03-29 07:52:36","2021-03-29 07:52:36","1");
INSERT INTO audit_trail VALUES("2128","1","Admin Admin","","Undisbursed loan with id:100","2021-03-29 07:52:38","2021-03-29 07:52:38","1");
INSERT INTO audit_trail VALUES("2129","1","Admin Admin","","Unapproved loan with id:100","2021-03-29 07:52:51","2021-03-29 07:52:51","1");
INSERT INTO audit_trail VALUES("2130","1","Admin Admin","","Added repayment for loan with id:12","2021-03-29 07:53:05","2021-03-29 07:53:05","1");
INSERT INTO audit_trail VALUES("2131","1","Admin Admin","","Approved loan with id:64","2021-03-29 07:53:12","2021-03-29 07:53:12","1");
INSERT INTO audit_trail VALUES("2132","1","Admin Admin","","Disbursed loan with id:64","2021-03-29 07:53:24","2021-03-29 07:53:24","1");
INSERT INTO audit_trail VALUES("2133","1","Admin Admin","","Updated loan with id:100","2021-03-29 07:53:32","2021-03-29 07:53:32","1");
INSERT INTO audit_trail VALUES("2134","1","Admin Admin","","Added repayment for loan with id:64","2021-03-29 07:54:11","2021-03-29 07:54:11","1");
INSERT INTO audit_trail VALUES("2135","1","Admin Admin","","Approved loan with id:100","2021-03-29 07:54:30","2021-03-29 07:54:30","1");
INSERT INTO audit_trail VALUES("2136","1","Admin Admin","","Disbursed loan with id:100","2021-03-29 07:54:38","2021-03-29 07:54:38","1");
INSERT INTO audit_trail VALUES("2137","1","Admin Admin","","Undisbursed loan with id:23","2021-03-29 07:56:28","2021-03-29 07:56:28","1");
INSERT INTO audit_trail VALUES("2138","1","Admin Admin","","Disbursed loan with id:23","2021-03-29 07:56:34","2021-03-29 07:56:34","1");
INSERT INTO audit_trail VALUES("2139","1","Admin Admin","","Updated loan with id:23","2021-03-29 07:56:56","2021-03-29 07:56:56","1");
INSERT INTO audit_trail VALUES("2140","1","Admin Admin","","Undisbursed loan with id:23","2021-03-29 07:57:51","2021-03-29 07:57:51","1");
INSERT INTO audit_trail VALUES("2141","1","Admin Admin","","Disbursed loan with id:23","2021-03-29 07:57:59","2021-03-29 07:57:59","1");
INSERT INTO audit_trail VALUES("2142","1","Admin Admin","","Undisbursed loan with id:31","2021-03-29 07:58:19","2021-03-29 07:58:19","1");
INSERT INTO audit_trail VALUES("2143","1","Admin Admin","","Unapproved loan with id:31","2021-03-29 07:58:39","2021-03-29 07:58:39","1");
INSERT INTO audit_trail VALUES("2144","1","Admin Admin","","Added repayment for loan with id:23","2021-03-29 07:58:53","2021-03-29 07:58:53","1");
INSERT INTO audit_trail VALUES("2145","1","Admin Admin","","Updated loan with id:31","2021-03-29 07:59:03","2021-03-29 07:59:03","1");
INSERT INTO audit_trail VALUES("2146","1","Admin Admin","","Undisbursed loan with id:115","2021-03-29 07:59:42","2021-03-29 07:59:42","1");
INSERT INTO audit_trail VALUES("2147","1","Admin Admin","","Unapproved loan with id:115","2021-03-29 07:59:51","2021-03-29 07:59:51","1");
INSERT INTO audit_trail VALUES("2148","1","Admin Admin","","Updated loan with id:115","2021-03-29 08:00:15","2021-03-29 08:00:15","1");
INSERT INTO audit_trail VALUES("2149","1","Admin Admin","","Updated loan with id:31","2021-03-29 08:00:19","2021-03-29 08:00:19","1");
INSERT INTO audit_trail VALUES("2150","1","Admin Admin","","Approved loan with id:115","2021-03-29 08:00:48","2021-03-29 08:00:48","1");
INSERT INTO audit_trail VALUES("2151","1","Admin Admin","","Disbursed loan with id:115","2021-03-29 08:00:54","2021-03-29 08:00:54","1");
INSERT INTO audit_trail VALUES("2152","1","Admin Admin","","Added repayment for loan with id:115","2021-03-29 08:01:23","2021-03-29 08:01:23","1");
INSERT INTO audit_trail VALUES("2153","1","Admin Admin","","Added repayment for loan with id:115","2021-03-29 08:02:18","2021-03-29 08:02:18","1");
INSERT INTO audit_trail VALUES("2154","1","Admin Admin","","Deleted loan with id:18","2021-03-29 08:02:22","2021-03-29 08:02:22","1");
INSERT INTO audit_trail VALUES("2155","1","Admin Admin","","Approved loan with id:31","2021-03-29 08:02:23","2021-03-29 08:02:23","1");
INSERT INTO audit_trail VALUES("2156","1","Admin Admin","","Disbursed loan with id:31","2021-03-29 08:02:45","2021-03-29 08:02:45","1");
INSERT INTO audit_trail VALUES("2157","1","Admin Admin","","Added repayment for loan with id:31","2021-03-29 08:03:29","2021-03-29 08:03:29","1");
INSERT INTO audit_trail VALUES("2158","1","Admin Admin","","Undisbursed loan with id:115","2021-03-29 08:04:11","2021-03-29 08:04:11","1");
INSERT INTO audit_trail VALUES("2159","1","Admin Admin","","Disbursed loan with id:115","2021-03-29 08:04:17","2021-03-29 08:04:17","1");
INSERT INTO audit_trail VALUES("2160","1","Admin Admin","","Undisbursed loan with id:115","2021-03-29 08:04:24","2021-03-29 08:04:24","1");
INSERT INTO audit_trail VALUES("2161","1","Admin Admin","","Unapproved loan with id:115","2021-03-29 08:04:36","2021-03-29 08:04:36","1");
INSERT INTO audit_trail VALUES("2162","1","Admin Admin","","Updated loan with id:115","2021-03-29 08:05:01","2021-03-29 08:05:01","1");
INSERT INTO audit_trail VALUES("2163","1","Admin Admin","","Updated loan with id:115","2021-03-29 08:05:28","2021-03-29 08:05:28","1");
INSERT INTO audit_trail VALUES("2164","1","Admin Admin","","Undisbursed loan with id:79","2021-03-29 08:05:38","2021-03-29 08:05:38","1");
INSERT INTO audit_trail VALUES("2165","1","Admin Admin","","Updated loan with id:79","2021-03-29 08:06:13","2021-03-29 08:06:13","1");
INSERT INTO audit_trail VALUES("2166","1","Admin Admin","","Undisbursed loan with id:57","2021-03-29 08:06:19","2021-03-29 08:06:19","1");
INSERT INTO audit_trail VALUES("2167","1","Admin Admin","","Unapproved loan with id:57","2021-03-29 08:06:26","2021-03-29 08:06:26","1");
INSERT INTO audit_trail VALUES("2168","1","Admin Admin","","Updated loan with id:57","2021-03-29 08:06:48","2021-03-29 08:06:48","1");
INSERT INTO audit_trail VALUES("2169","1","Admin Admin","","Approved loan with id:57","2021-03-29 08:07:10","2021-03-29 08:07:10","1");
INSERT INTO audit_trail VALUES("2170","1","Admin Admin","","Disbursed loan with id:57","2021-03-29 08:07:19","2021-03-29 08:07:19","1");
INSERT INTO audit_trail VALUES("2171","1","Admin Admin","","Disbursed loan with id:79","2021-03-29 08:07:34","2021-03-29 08:07:34","1");
INSERT INTO audit_trail VALUES("2172","1","Admin Admin","","Added repayment for loan with id:57","2021-03-29 08:07:53","2021-03-29 08:07:53","1");
INSERT INTO audit_trail VALUES("2173","1","Admin Admin","","Added repayment for loan with id:79","2021-03-29 08:08:30","2021-03-29 08:08:30","1");
INSERT INTO audit_trail VALUES("2174","1","Admin Admin","","Undisbursed loan with id:128","2021-03-29 08:09:01","2021-03-29 08:09:01","1");
INSERT INTO audit_trail VALUES("2175","1","Admin Admin","","Unapproved loan with id:128","2021-03-29 08:09:09","2021-03-29 08:09:09","1");
INSERT INTO audit_trail VALUES("2176","1","Admin Admin","","Updated loan with id:128","2021-03-29 08:09:29","2021-03-29 08:09:29","1");
INSERT INTO audit_trail VALUES("2177","1","Admin Admin","","Approved loan with id:128","2021-03-29 08:10:35","2021-03-29 08:10:35","1");
INSERT INTO audit_trail VALUES("2178","1","Admin Admin","","Disbursed loan with id:128","2021-03-29 08:10:53","2021-03-29 08:10:53","1");
INSERT INTO audit_trail VALUES("2179","1","Admin Admin","","Added repayment for loan with id:128","2021-03-29 08:11:19","2021-03-29 08:11:19","1");
INSERT INTO audit_trail VALUES("2180","1","Admin Admin","","Undisbursed loan with id:129","2021-03-29 08:12:11","2021-03-29 08:12:11","1");
INSERT INTO audit_trail VALUES("2181","1","Admin Admin","","Unapproved loan with id:129","2021-03-29 08:12:17","2021-03-29 08:12:17","1");
INSERT INTO audit_trail VALUES("2182","1","Admin Admin","","Updated loan with id:129","2021-03-29 08:12:45","2021-03-29 08:12:45","1");
INSERT INTO audit_trail VALUES("2183","1","Admin Admin","","Approved loan with id:129","2021-03-29 08:13:20","2021-03-29 08:13:20","1");
INSERT INTO audit_trail VALUES("2184","1","Admin Admin","","Disbursed loan with id:129","2021-03-29 08:14:09","2021-03-29 08:14:09","1");
INSERT INTO audit_trail VALUES("2185","1","Admin Admin","","Added repayment for loan with id:129","2021-03-29 08:14:46","2021-03-29 08:14:46","1");
INSERT INTO audit_trail VALUES("2186","1","Admin Admin","","Undisbursed loan with id:81","2021-03-29 08:15:38","2021-03-29 08:15:38","1");
INSERT INTO audit_trail VALUES("2187","1","Admin Admin","","Unapproved loan with id:81","2021-03-29 08:15:46","2021-03-29 08:15:46","1");
INSERT INTO audit_trail VALUES("2188","1","Admin Admin","","Updated loan with id:81","2021-03-29 08:16:11","2021-03-29 08:16:11","1");
INSERT INTO audit_trail VALUES("2189","1","Admin Admin","","Approved loan with id:81","2021-03-29 08:16:43","2021-03-29 08:16:43","1");
INSERT INTO audit_trail VALUES("2190","1","Admin Admin","","Disbursed loan with id:81","2021-03-29 08:16:51","2021-03-29 08:16:51","1");
INSERT INTO audit_trail VALUES("2191","1","Admin Admin","","Added repayment for loan with id:81","2021-03-29 08:17:34","2021-03-29 08:17:34","1");
INSERT INTO audit_trail VALUES("2192","1","Admin Admin","","Undisbursed loan with id:55","2021-03-29 08:18:17","2021-03-29 08:18:17","1");
INSERT INTO audit_trail VALUES("2193","1","Admin Admin","","Unapproved loan with id:55","2021-03-29 08:18:23","2021-03-29 08:18:23","1");
INSERT INTO audit_trail VALUES("2194","1","Admin Admin","","Updated loan with id:55","2021-03-29 08:18:38","2021-03-29 08:18:38","1");
INSERT INTO audit_trail VALUES("2195","1","Admin Admin","","Approved loan with id:55","2021-03-29 08:19:39","2021-03-29 08:19:39","1");
INSERT INTO audit_trail VALUES("2196","1","Admin Admin","","Disbursed loan with id:55","2021-03-29 08:19:46","2021-03-29 08:19:46","1");
INSERT INTO audit_trail VALUES("2197","1","Admin Admin","","Added loan with id:184","2021-03-29 08:20:08","2021-03-29 08:20:08","1");
INSERT INTO audit_trail VALUES("2198","1","Admin Admin","","Approved loan with id:184","2021-03-29 08:20:30","2021-03-29 08:20:30","1");
INSERT INTO audit_trail VALUES("2199","1","Admin Admin","","Undisbursed loan with id:126","2021-03-29 08:20:46","2021-03-29 08:20:46","1");
INSERT INTO audit_trail VALUES("2200","1","Admin Admin","","Disbursed loan with id:184","2021-03-29 08:20:47","2021-03-29 08:20:47","1");
INSERT INTO audit_trail VALUES("2201","1","Admin Admin","","Unapproved loan with id:126","2021-03-29 08:20:54","2021-03-29 08:20:54","1");
INSERT INTO audit_trail VALUES("2202","1","Admin Admin","","Updated loan with id:126","2021-03-29 08:21:22","2021-03-29 08:21:22","1");
INSERT INTO audit_trail VALUES("2203","1","Admin Admin","","Approved loan with id:126","2021-03-29 08:22:03","2021-03-29 08:22:03","1");
INSERT INTO audit_trail VALUES("2204","1","Admin Admin","","Disbursed loan with id:126","2021-03-29 08:22:09","2021-03-29 08:22:09","1");
INSERT INTO audit_trail VALUES("2205","1","Admin Admin","","Added repayment for loan with id:126","2021-03-29 08:22:41","2021-03-29 08:22:41","1");
INSERT INTO audit_trail VALUES("2206","1","Admin Admin","","Undisbursed loan with id:145","2021-03-29 08:23:14","2021-03-29 08:23:14","1");
INSERT INTO audit_trail VALUES("2207","1","Admin Admin","","Added repayment for loan with id:126","2021-03-29 08:23:17","2021-03-29 08:23:17","1");
INSERT INTO audit_trail VALUES("2208","1","Admin Admin","","Unapproved loan with id:145","2021-03-29 08:23:34","2021-03-29 08:23:34","1");
INSERT INTO audit_trail VALUES("2209","1","Admin Admin","","Updated loan with id:145","2021-03-29 08:23:55","2021-03-29 08:23:55","1");
INSERT INTO audit_trail VALUES("2210","1","Admin Admin","","Approved loan with id:115","2021-03-29 08:24:23","2021-03-29 08:24:23","1");
INSERT INTO audit_trail VALUES("2211","1","Admin Admin","","Added repayment for loan with id:34","2021-03-29 08:24:29","2021-03-29 08:24:29","1");
INSERT INTO audit_trail VALUES("2212","1","Admin Admin","","Disbursed loan with id:115","2021-03-29 08:24:31","2021-03-29 08:24:31","1");
INSERT INTO audit_trail VALUES("2213","1","Admin Admin","","Disbursed loan with id:115","2021-03-29 08:24:33","2021-03-29 08:24:33","1");
INSERT INTO audit_trail VALUES("2214","1","Admin Admin","","Added repayment for loan with id:115","2021-03-29 08:25:22","2021-03-29 08:25:22","1");
INSERT INTO audit_trail VALUES("2215","1","Admin Admin","","Undisbursed loan with id:22","2021-03-29 08:25:47","2021-03-29 08:25:47","1");
INSERT INTO audit_trail VALUES("2216","1","Admin Admin","","Approved loan with id:145","2021-03-29 08:25:50","2021-03-29 08:25:50","1");
INSERT INTO audit_trail VALUES("2217","1","Admin Admin","","Unapproved loan with id:22","2021-03-29 08:25:53","2021-03-29 08:25:53","1");
INSERT INTO audit_trail VALUES("2218","1","Admin Admin","","Disbursed loan with id:145","2021-03-29 08:25:58","2021-03-29 08:25:58","1");
INSERT INTO audit_trail VALUES("2219","1","Admin Admin","","Added repayment for loan with id:145","2021-03-29 08:26:19","2021-03-29 08:26:19","1");
INSERT INTO audit_trail VALUES("2220","1","Admin Admin","","Updated loan with id:22","2021-03-29 08:27:02","2021-03-29 08:27:02","1");
INSERT INTO audit_trail VALUES("2221","1","Admin Admin","","Undisbursed loan with id:72","2021-03-29 08:27:27","2021-03-29 08:27:27","1");
INSERT INTO audit_trail VALUES("2222","1","Admin Admin","","Approved loan with id:22","2021-03-29 08:27:35","2021-03-29 08:27:35","1");
INSERT INTO audit_trail VALUES("2223","1","Admin Admin","","Unapproved loan with id:72","2021-03-29 08:27:37","2021-03-29 08:27:37","1");
INSERT INTO audit_trail VALUES("2224","1","Admin Admin","","Disbursed loan with id:22","2021-03-29 08:27:42","2021-03-29 08:27:42","1");
INSERT INTO audit_trail VALUES("2225","1","Admin Admin","","Updated loan with id:72","2021-03-29 08:28:04","2021-03-29 08:28:04","1");
INSERT INTO audit_trail VALUES("2226","1","Admin Admin","","Added repayment for loan with id:22","2021-03-29 08:28:13","2021-03-29 08:28:13","1");
INSERT INTO audit_trail VALUES("2227","1","Admin Admin","","Approved loan with id:72","2021-03-29 08:29:21","2021-03-29 08:29:21","1");
INSERT INTO audit_trail VALUES("2228","1","Admin Admin","","Undisbursed loan with id:32","2021-03-29 08:29:35","2021-03-29 08:29:35","1");
INSERT INTO audit_trail VALUES("2229","1","Admin Admin","","Disbursed loan with id:72","2021-03-29 08:29:37","2021-03-29 08:29:37","1");
INSERT INTO audit_trail VALUES("2230","1","Admin Admin","","Unapproved loan with id:32","2021-03-29 08:29:44","2021-03-29 08:29:44","1");
INSERT INTO audit_trail VALUES("2231","1","Admin Admin","","Updated loan with id:32","2021-03-29 08:30:04","2021-03-29 08:30:04","1");
INSERT INTO audit_trail VALUES("2232","1","Admin Admin","","Added repayment for loan with id:72","2021-03-29 08:30:07","2021-03-29 08:30:07","1");
INSERT INTO audit_trail VALUES("2233","1","Admin Admin","","Approved loan with id:32","2021-03-29 08:30:46","2021-03-29 08:30:46","1");
INSERT INTO audit_trail VALUES("2234","1","Admin Admin","","Disbursed loan with id:32","2021-03-29 08:30:55","2021-03-29 08:30:55","1");
INSERT INTO audit_trail VALUES("2235","1","Admin Admin","","Added repayment for loan with id:32","2021-03-29 08:31:22","2021-03-29 08:31:22","1");
INSERT INTO audit_trail VALUES("2236","1","Admin Admin","","Undisbursed loan with id:37","2021-03-29 08:31:23","2021-03-29 08:31:23","1");
INSERT INTO audit_trail VALUES("2237","1","Admin Admin","","Unapproved loan with id:37","2021-03-29 08:31:34","2021-03-29 08:31:34","1");
INSERT INTO audit_trail VALUES("2238","1","Admin Admin","","Approved loan with id:37","2021-03-29 08:32:00","2021-03-29 08:32:00","1");
INSERT INTO audit_trail VALUES("2239","1","Admin Admin","","Disbursed loan with id:37","2021-03-29 08:32:07","2021-03-29 08:32:07","1");
INSERT INTO audit_trail VALUES("2240","1","Admin Admin","","Added repayment for loan with id:37","2021-03-29 08:32:52","2021-03-29 08:32:52","1");
INSERT INTO audit_trail VALUES("2241","1","Admin Admin","","Disbursed loan with id:112","2021-03-29 08:33:38","2021-03-29 08:33:38","1");
INSERT INTO audit_trail VALUES("2242","1","Admin Admin","","Undisbursed loan with id:112","2021-03-29 08:34:48","2021-03-29 08:34:48","1");
INSERT INTO audit_trail VALUES("2243","1","Admin Admin","","Unapproved loan with id:112","2021-03-29 08:34:53","2021-03-29 08:34:53","1");
INSERT INTO audit_trail VALUES("2244","1","Admin Admin","","Updated loan with id:112","2021-03-29 08:38:34","2021-03-29 08:38:34","1");
INSERT INTO audit_trail VALUES("2245","1","Admin Admin","","Approved loan with id:112","2021-03-29 08:39:01","2021-03-29 08:39:01","1");
INSERT INTO audit_trail VALUES("2246","1","Admin Admin","","Disbursed loan with id:112","2021-03-29 08:39:08","2021-03-29 08:39:08","1");
INSERT INTO audit_trail VALUES("2247","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:184","2021-03-29 09:48:30","2021-03-29 09:48:30","1");
INSERT INTO audit_trail VALUES("2248","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:185","2021-03-29 09:49:41","2021-03-29 09:49:41","1");
INSERT INTO audit_trail VALUES("2249","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:185","2021-03-29 10:08:42","2021-03-29 10:08:42","1");
INSERT INTO audit_trail VALUES("2250","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:185","2021-03-29 10:19:53","2021-03-29 10:19:53","1");
INSERT INTO audit_trail VALUES("2251","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:185","2021-03-29 10:21:36","2021-03-29 10:21:36","1");
INSERT INTO audit_trail VALUES("2252","1","Admin Admin","","Added borrower  with id:625","2021-03-29 10:34:14","2021-03-29 10:34:14","1");
INSERT INTO audit_trail VALUES("2253","1","Admin Admin","","Deleted borrower  with id:625","2021-03-29 10:35:34","2021-03-29 10:35:34","1");
INSERT INTO audit_trail VALUES("2254","1","Admin Admin","","Added borrower  with id:626","2021-03-29 10:36:40","2021-03-29 10:36:40","1");
INSERT INTO audit_trail VALUES("2255","1","Admin Admin","","Deleted borrower  with id:626","2021-03-29 10:37:04","2021-03-29 10:37:04","1");
INSERT INTO audit_trail VALUES("2256","1","Admin Admin","","Added loan with id:186","2021-03-29 10:43:30","2021-03-29 10:43:30","1");
INSERT INTO audit_trail VALUES("2257","1","Admin Admin","","Approved loan with id:186","2021-03-29 10:44:19","2021-03-29 10:44:19","1");
INSERT INTO audit_trail VALUES("2258","1","Admin Admin","","Disbursed loan with id:186","2021-03-29 10:44:40","2021-03-29 10:44:40","1");
INSERT INTO audit_trail VALUES("2259","1","Admin Admin","","Added Journal Manual Entry  with id:11344","2021-03-29 11:00:44","2021-03-29 11:00:44","1");
INSERT INTO audit_trail VALUES("2260","1","Admin Admin","","Added Capital  with id:186","2021-03-29 12:12:53","2021-03-29 12:12:53","1");
INSERT INTO audit_trail VALUES("2261","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-29 12:21:37","2021-03-29 12:21:37","1");
INSERT INTO audit_trail VALUES("2262","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:187","2021-03-30 01:29:56","2021-03-30 01:29:56","1");
INSERT INTO audit_trail VALUES("2263","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-30 01:36:20","2021-03-30 01:36:20","1");
INSERT INTO audit_trail VALUES("2264","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:187","2021-03-30 03:59:02","2021-03-30 03:59:02","1");
INSERT INTO audit_trail VALUES("2265","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:187","2021-03-30 04:04:04","2021-03-30 04:04:04","1");
INSERT INTO audit_trail VALUES("2266","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:187","2021-03-30 04:05:16","2021-03-30 04:05:16","1");
INSERT INTO audit_trail VALUES("2267","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:188","2021-03-30 05:29:11","2021-03-30 05:29:11","1");
INSERT INTO audit_trail VALUES("2268","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:188","2021-03-30 05:29:58","2021-03-30 05:29:58","1");
INSERT INTO audit_trail VALUES("2269","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:188","2021-03-30 05:32:29","2021-03-30 05:32:29","1");
INSERT INTO audit_trail VALUES("2270","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11479","2021-03-30 07:45:28","2021-03-30 07:45:28","1");
INSERT INTO audit_trail VALUES("2271","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:189","2021-03-30 07:52:38","2021-03-30 07:52:38","1");
INSERT INTO audit_trail VALUES("2272","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:140","2021-03-30 09:16:30","2021-03-30 09:16:30","1");
INSERT INTO audit_trail VALUES("2273","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:141","2021-03-30 10:14:47","2021-03-30 10:14:47","1");
INSERT INTO audit_trail VALUES("2274","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:141","2021-03-30 10:16:30","2021-03-30 10:16:30","1");
INSERT INTO audit_trail VALUES("2275","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:142","2021-03-30 10:18:08","2021-03-30 10:18:08","1");
INSERT INTO audit_trail VALUES("2276","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:143","2021-03-30 10:20:42","2021-03-30 10:20:42","1");
INSERT INTO audit_trail VALUES("2277","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:188","2021-03-30 10:23:34","2021-03-30 10:23:34","1");
INSERT INTO audit_trail VALUES("2278","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:189","2021-03-30 10:25:17","2021-03-30 10:25:17","1");
INSERT INTO audit_trail VALUES("2279","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:190","2021-03-30 10:27:23","2021-03-30 10:27:23","1");
INSERT INTO audit_trail VALUES("2280","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:191","2021-03-30 10:29:39","2021-03-30 10:29:39","1");
INSERT INTO audit_trail VALUES("2281","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:192","2021-03-30 11:28:15","2021-03-30 11:28:15","1");
INSERT INTO audit_trail VALUES("2282","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-30 11:38:21","2021-03-30 11:38:21","1");
INSERT INTO audit_trail VALUES("2283","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-03-31 04:52:33","2021-03-31 04:52:33","");
INSERT INTO audit_trail VALUES("2284","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-03-31 05:33:39","2021-03-31 05:33:39","1");
INSERT INTO audit_trail VALUES("2285","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:193","2021-03-31 05:43:27","2021-03-31 05:43:27","1");
INSERT INTO audit_trail VALUES("2286","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:144","2021-03-31 09:48:13","2021-03-31 09:48:13","1");
INSERT INTO audit_trail VALUES("2287","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:145","2021-03-31 09:49:27","2021-03-31 09:49:27","1");
INSERT INTO audit_trail VALUES("2288","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:146","2021-03-31 10:11:56","2021-03-31 10:11:56","1");
INSERT INTO audit_trail VALUES("2289","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:147","2021-03-31 10:46:53","2021-03-31 10:46:53","1");
INSERT INTO audit_trail VALUES("2290","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:148","2021-03-31 10:48:21","2021-03-31 10:48:21","1");
INSERT INTO audit_trail VALUES("2291","1","Admin Admin","","Logged in to system","2021-03-31 11:02:12","2021-03-31 11:02:12","");
INSERT INTO audit_trail VALUES("2292","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:194","2021-03-31 11:23:20","2021-03-31 11:23:20","1");
INSERT INTO audit_trail VALUES("2293","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-03-31 11:48:54","2021-03-31 11:48:54","1");
INSERT INTO audit_trail VALUES("2294","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-01 01:16:12","2021-04-01 01:16:12","1");
INSERT INTO audit_trail VALUES("2295","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:195","2021-04-01 01:51:03","2021-04-01 01:51:03","1");
INSERT INTO audit_trail VALUES("2296","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-01 10:24:51","2021-04-01 10:24:51","1");
INSERT INTO audit_trail VALUES("2297","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:196","2021-04-01 11:26:30","2021-04-01 11:26:30","1");
INSERT INTO audit_trail VALUES("2298","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:197","2021-04-01 11:28:45","2021-04-01 11:28:45","1");
INSERT INTO audit_trail VALUES("2299","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:198","2021-04-01 11:30:17","2021-04-01 11:30:17","1");
INSERT INTO audit_trail VALUES("2300","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:149","2021-04-01 11:42:30","2021-04-01 11:42:30","1");
INSERT INTO audit_trail VALUES("2301","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-01 12:21:49","2021-04-01 12:21:49","1");
INSERT INTO audit_trail VALUES("2302","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-03 01:07:25","2021-04-03 01:07:25","");
INSERT INTO audit_trail VALUES("2303","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-03 02:20:03","2021-04-03 02:20:03","");
INSERT INTO audit_trail VALUES("2304","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:199","2021-04-03 02:27:10","2021-04-03 02:27:10","1");
INSERT INTO audit_trail VALUES("2305","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11894","2021-04-03 02:57:03","2021-04-03 02:57:03","1");
INSERT INTO audit_trail VALUES("2306","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-03 04:04:23","2021-04-03 04:04:23","");
INSERT INTO audit_trail VALUES("2307","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:190","2021-04-03 04:09:55","2021-04-03 04:09:55","1");
INSERT INTO audit_trail VALUES("2308","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:190","2021-04-03 04:10:44","2021-04-03 04:10:44","1");
INSERT INTO audit_trail VALUES("2309","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:190","2021-04-03 04:11:54","2021-04-03 04:11:54","1");
INSERT INTO audit_trail VALUES("2310","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11919","2021-04-03 04:20:53","2021-04-03 04:20:53","1");
INSERT INTO audit_trail VALUES("2311","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-03 04:24:01","2021-04-03 04:24:01","");
INSERT INTO audit_trail VALUES("2312","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:191","2021-04-03 04:24:01","2021-04-03 04:24:01","1");
INSERT INTO audit_trail VALUES("2313","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:189","2021-04-03 04:25:15","2021-04-03 04:25:15","1");
INSERT INTO audit_trail VALUES("2314","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:189","2021-04-03 04:25:34","2021-04-03 04:25:34","1");
INSERT INTO audit_trail VALUES("2315","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:191","2021-04-03 04:27:39","2021-04-03 04:27:39","1");
INSERT INTO audit_trail VALUES("2316","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:191","2021-04-03 04:27:52","2021-04-03 04:27:52","1");
INSERT INTO audit_trail VALUES("2317","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:191","2021-04-03 04:29:08","2021-04-03 04:29:08","1");
INSERT INTO audit_trail VALUES("2318","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:191","2021-04-03 04:29:21","2021-04-03 04:29:21","1");
INSERT INTO audit_trail VALUES("2319","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11955","2021-04-03 04:40:52","2021-04-03 04:40:52","1");
INSERT INTO audit_trail VALUES("2320","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:192","2021-04-03 04:49:50","2021-04-03 04:49:50","1");
INSERT INTO audit_trail VALUES("2321","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:192","2021-04-03 04:50:24","2021-04-03 04:50:24","1");
INSERT INTO audit_trail VALUES("2322","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:192","2021-04-03 04:50:39","2021-04-03 04:50:39","1");
INSERT INTO audit_trail VALUES("2323","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:11968","2021-04-03 04:51:00","2021-04-03 04:51:00","1");
INSERT INTO audit_trail VALUES("2324","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11981","2021-04-03 05:02:37","2021-04-03 05:02:37","1");
INSERT INTO audit_trail VALUES("2325","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11983","2021-04-03 05:06:08","2021-04-03 05:06:08","1");
INSERT INTO audit_trail VALUES("2326","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11985","2021-04-03 05:07:12","2021-04-03 05:07:12","1");
INSERT INTO audit_trail VALUES("2327","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11987","2021-04-03 05:10:49","2021-04-03 05:10:49","1");
INSERT INTO audit_trail VALUES("2328","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11989","2021-04-03 05:30:30","2021-04-03 05:30:30","1");
INSERT INTO audit_trail VALUES("2329","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11991","2021-04-03 05:36:21","2021-04-03 05:36:21","1");
INSERT INTO audit_trail VALUES("2330","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:11993","2021-04-03 05:39:05","2021-04-03 05:39:05","1");
INSERT INTO audit_trail VALUES("2331","1","Admin Admin","","Logged in to system","2021-04-03 05:39:43","2021-04-03 05:39:43","");
INSERT INTO audit_trail VALUES("2332","1","Admin Admin","","Updated Settings","2021-04-03 05:56:59","2021-04-03 05:56:59","1");
INSERT INTO audit_trail VALUES("2333","1","Admin Admin","","Added Journal Manual Entry  with id:12035","2021-04-03 06:14:44","2021-04-03 06:14:44","1");
INSERT INTO audit_trail VALUES("2334","1","Admin Admin","","Added Journal Manual Entry  with id:12041","2021-04-03 06:21:17","2021-04-03 06:21:17","1");
INSERT INTO audit_trail VALUES("2335","1","Admin Admin","","Added Journal Manual Entry  with id:12045","2021-04-03 06:25:47","2021-04-03 06:25:47","1");
INSERT INTO audit_trail VALUES("2336","1","Admin Admin","","Added Journal Manual Entry  with id:12047","2021-04-03 06:30:46","2021-04-03 06:30:46","1");
INSERT INTO audit_trail VALUES("2337","1","Admin Admin","","Added Journal Manual Entry  with id:12049","2021-04-03 06:35:29","2021-04-03 06:35:29","1");
INSERT INTO audit_trail VALUES("2338","1","Admin Admin","","Added Journal Manual Entry  with id:12051","2021-04-03 06:36:29","2021-04-03 06:36:29","1");
INSERT INTO audit_trail VALUES("2339","1","Admin Admin","","Added Journal Manual Entry  with id:12055","2021-04-03 06:38:38","2021-04-03 06:38:38","1");
INSERT INTO audit_trail VALUES("2340","1","Admin Admin","","Added Journal Manual Entry  with id:12061","2021-04-03 06:40:55","2021-04-03 06:40:55","1");
INSERT INTO audit_trail VALUES("2341","1","Admin Admin","","Added Journal Manual Entry  with id:12065","2021-04-03 06:42:10","2021-04-03 06:42:10","1");
INSERT INTO audit_trail VALUES("2342","1","Admin Admin","","Added Journal Manual Entry  with id:12067","2021-04-03 06:44:23","2021-04-03 06:44:23","1");
INSERT INTO audit_trail VALUES("2343","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:12070","2021-04-03 07:01:15","2021-04-03 07:01:15","1");
INSERT INTO audit_trail VALUES("2344","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:150","2021-04-03 07:06:20","2021-04-03 07:06:20","1");
INSERT INTO audit_trail VALUES("2345","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:200","2021-04-03 07:08:28","2021-04-03 07:08:28","1");
INSERT INTO audit_trail VALUES("2346","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:201","2021-04-03 07:10:33","2021-04-03 07:10:33","1");
INSERT INTO audit_trail VALUES("2347","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:202","2021-04-03 07:11:33","2021-04-03 07:11:33","1");
INSERT INTO audit_trail VALUES("2348","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:203","2021-04-03 07:12:23","2021-04-03 07:12:23","1");
INSERT INTO audit_trail VALUES("2349","1","Admin Admin","","Logged out of system","2021-04-03 07:56:02","2021-04-03 07:56:02","1");
INSERT INTO audit_trail VALUES("2350","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-03 07:57:35","2021-04-03 07:57:35","1");
INSERT INTO audit_trail VALUES("2351","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-06 01:16:20","2021-04-06 01:16:20","");
INSERT INTO audit_trail VALUES("2352","1","Admin Admin","","Logged in to system","2021-04-06 01:20:45","2021-04-06 01:20:45","");
INSERT INTO audit_trail VALUES("2353","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-06 01:30:22","2021-04-06 01:30:22","");
INSERT INTO audit_trail VALUES("2354","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-04-06 02:26:14","2021-04-06 02:26:14","1");
INSERT INTO audit_trail VALUES("2355","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-06 02:55:00","2021-04-06 02:55:00","");
INSERT INTO audit_trail VALUES("2356","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-06 03:34:22","2021-04-06 03:34:22","1");
INSERT INTO audit_trail VALUES("2357","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:204","2021-04-06 03:35:57","2021-04-06 03:35:57","1");
INSERT INTO audit_trail VALUES("2358","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-06 08:31:51","2021-04-06 08:31:51","1");
INSERT INTO audit_trail VALUES("2359","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:205","2021-04-06 09:29:07","2021-04-06 09:29:07","1");
INSERT INTO audit_trail VALUES("2360","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:151","2021-04-06 09:30:43","2021-04-06 09:30:43","1");
INSERT INTO audit_trail VALUES("2361","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:152","2021-04-06 09:31:57","2021-04-06 09:31:57","1");
INSERT INTO audit_trail VALUES("2362","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:12213","2021-04-06 10:12:45","2021-04-06 10:12:45","1");
INSERT INTO audit_trail VALUES("2363","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:206","2021-04-06 10:46:31","2021-04-06 10:46:31","1");
INSERT INTO audit_trail VALUES("2364","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:207","2021-04-06 10:56:25","2021-04-06 10:56:25","1");
INSERT INTO audit_trail VALUES("2365","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-06 11:32:31","2021-04-06 11:32:31","1");
INSERT INTO audit_trail VALUES("2366","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:208","2021-04-07 01:24:56","2021-04-07 01:24:56","1");
INSERT INTO audit_trail VALUES("2367","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-07 03:10:31","2021-04-07 03:10:31","1");
INSERT INTO audit_trail VALUES("2368","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:209","2021-04-07 05:25:45","2021-04-07 05:25:45","1");
INSERT INTO audit_trail VALUES("2369","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:209","2021-04-07 05:26:21","2021-04-07 05:26:21","1");
INSERT INTO audit_trail VALUES("2370","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:210","2021-04-07 08:35:12","2021-04-07 08:35:12","1");
INSERT INTO audit_trail VALUES("2371","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:211","2021-04-07 08:36:20","2021-04-07 08:36:20","1");
INSERT INTO audit_trail VALUES("2372","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:153","2021-04-07 10:10:38","2021-04-07 10:10:38","1");
INSERT INTO audit_trail VALUES("2373","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:212","2021-04-07 10:28:16","2021-04-07 10:28:16","1");
INSERT INTO audit_trail VALUES("2374","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:213","2021-04-07 11:19:04","2021-04-07 11:19:04","1");
INSERT INTO audit_trail VALUES("2375","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-07 11:19:21","2021-04-07 11:19:21","1");
INSERT INTO audit_trail VALUES("2376","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:214","2021-04-08 01:50:41","2021-04-08 01:50:41","1");
INSERT INTO audit_trail VALUES("2377","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-08 04:51:07","2021-04-08 04:51:07","1");
INSERT INTO audit_trail VALUES("2378","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:154","2021-04-08 08:40:46","2021-04-08 08:40:46","1");
INSERT INTO audit_trail VALUES("2379","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:12485","2021-04-08 09:04:07","2021-04-08 09:04:07","1");
INSERT INTO audit_trail VALUES("2380","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:12487","2021-04-08 09:04:08","2021-04-08 09:04:08","1");
INSERT INTO audit_trail VALUES("2381","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:215","2021-04-08 09:14:50","2021-04-08 09:14:50","1");
INSERT INTO audit_trail VALUES("2382","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:216","2021-04-08 09:16:05","2021-04-08 09:16:05","1");
INSERT INTO audit_trail VALUES("2383","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:217","2021-04-08 10:01:46","2021-04-08 10:01:46","1");
INSERT INTO audit_trail VALUES("2384","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:218","2021-04-08 10:02:30","2021-04-08 10:02:30","1");
INSERT INTO audit_trail VALUES("2385","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:155","2021-04-08 10:11:27","2021-04-08 10:11:27","1");
INSERT INTO audit_trail VALUES("2386","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:156","2021-04-08 10:38:54","2021-04-08 10:38:54","1");
INSERT INTO audit_trail VALUES("2387","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:157","2021-04-08 10:40:18","2021-04-08 10:40:18","1");
INSERT INTO audit_trail VALUES("2388","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:158","2021-04-08 10:43:25","2021-04-08 10:43:25","1");
INSERT INTO audit_trail VALUES("2389","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:159","2021-04-08 10:46:16","2021-04-08 10:46:16","1");
INSERT INTO audit_trail VALUES("2390","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:219","2021-04-08 10:47:44","2021-04-08 10:47:44","1");
INSERT INTO audit_trail VALUES("2391","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-08 11:09:17","2021-04-08 11:09:17","1");
INSERT INTO audit_trail VALUES("2392","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-09 01:41:19","2021-04-09 01:41:19","1");
INSERT INTO audit_trail VALUES("2393","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:220","2021-04-09 02:05:47","2021-04-09 02:05:47","1");
INSERT INTO audit_trail VALUES("2394","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-09 03:56:10","2021-04-09 03:56:10","1");
INSERT INTO audit_trail VALUES("2395","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:160","2021-04-09 10:13:00","2021-04-09 10:13:00","1");
INSERT INTO audit_trail VALUES("2396","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:161","2021-04-09 10:14:19","2021-04-09 10:14:19","1");
INSERT INTO audit_trail VALUES("2397","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:221","2021-04-09 10:40:25","2021-04-09 10:40:25","1");
INSERT INTO audit_trail VALUES("2398","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-09 11:12:39","2021-04-09 11:12:39","1");
INSERT INTO audit_trail VALUES("2399","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:222","2021-04-10 01:03:05","2021-04-10 01:03:05","1");
INSERT INTO audit_trail VALUES("2400","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-10 02:53:11","2021-04-10 02:53:11","1");
INSERT INTO audit_trail VALUES("2401","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:223","2021-04-10 06:25:00","2021-04-10 06:25:00","1");
INSERT INTO audit_trail VALUES("2402","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:224","2021-04-10 06:26:21","2021-04-10 06:26:21","1");
INSERT INTO audit_trail VALUES("2403","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:225","2021-04-10 06:29:39","2021-04-10 06:29:39","1");
INSERT INTO audit_trail VALUES("2404","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:226","2021-04-10 06:30:44","2021-04-10 06:30:44","1");
INSERT INTO audit_trail VALUES("2405","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:227","2021-04-10 06:31:57","2021-04-10 06:31:57","1");
INSERT INTO audit_trail VALUES("2406","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:162","2021-04-10 06:35:38","2021-04-10 06:35:38","1");
INSERT INTO audit_trail VALUES("2407","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:163","2021-04-10 06:37:07","2021-04-10 06:37:07","1");
INSERT INTO audit_trail VALUES("2408","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:164","2021-04-10 06:38:28","2021-04-10 06:38:28","1");
INSERT INTO audit_trail VALUES("2409","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-10 07:21:45","2021-04-10 07:21:45","1");
INSERT INTO audit_trail VALUES("2410","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-12 01:50:13","2021-04-12 01:50:13","");
INSERT INTO audit_trail VALUES("2411","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-12 02:02:00","2021-04-12 02:02:00","");
INSERT INTO audit_trail VALUES("2412","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:228","2021-04-12 02:03:18","2021-04-12 02:03:18","1");
INSERT INTO audit_trail VALUES("2413","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-12 03:42:54","2021-04-12 03:42:54","");
INSERT INTO audit_trail VALUES("2414","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:12836","2021-04-12 03:47:28","2021-04-12 03:47:28","1");
INSERT INTO audit_trail VALUES("2415","1","Admin Admin","","Logged in to system","2021-04-12 07:36:10","2021-04-12 07:36:10","");
INSERT INTO audit_trail VALUES("2416","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-12 07:41:30","2021-04-12 07:41:30","");
INSERT INTO audit_trail VALUES("2417","1","Admin Admin","","Added loan with id:193","2021-04-12 07:47:21","2021-04-12 07:47:21","1");
INSERT INTO audit_trail VALUES("2418","1","Admin Admin","","Approved loan with id:193","2021-04-12 07:47:42","2021-04-12 07:47:42","1");
INSERT INTO audit_trail VALUES("2419","1","Admin Admin","","Disbursed loan with id:193","2021-04-12 07:47:55","2021-04-12 07:47:55","1");
INSERT INTO audit_trail VALUES("2420","1","Admin Admin","","Added loan with id:194","2021-04-12 08:00:21","2021-04-12 08:00:21","1");
INSERT INTO audit_trail VALUES("2421","1","Admin Admin","","Approved loan with id:194","2021-04-12 08:01:04","2021-04-12 08:01:04","1");
INSERT INTO audit_trail VALUES("2422","1","Admin Admin","","Disbursed loan with id:194","2021-04-12 08:04:03","2021-04-12 08:04:03","1");
INSERT INTO audit_trail VALUES("2423","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:229","2021-04-12 09:00:53","2021-04-12 09:00:53","1");
INSERT INTO audit_trail VALUES("2424","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:165","2021-04-12 09:02:46","2021-04-12 09:02:46","1");
INSERT INTO audit_trail VALUES("2425","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:166","2021-04-12 09:04:13","2021-04-12 09:04:13","1");
INSERT INTO audit_trail VALUES("2426","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:230","2021-04-12 11:11:47","2021-04-12 11:11:47","1");
INSERT INTO audit_trail VALUES("2427","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:231","2021-04-12 11:40:41","2021-04-12 11:40:41","1");
INSERT INTO audit_trail VALUES("2428","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:232","2021-04-13 01:37:49","2021-04-13 01:37:49","1");
INSERT INTO audit_trail VALUES("2429","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-13 02:44:03","2021-04-13 02:44:03","");
INSERT INTO audit_trail VALUES("2430","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:233","2021-04-13 02:51:44","2021-04-13 02:51:44","1");
INSERT INTO audit_trail VALUES("2431","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:234","2021-04-13 03:07:31","2021-04-13 03:07:31","1");
INSERT INTO audit_trail VALUES("2432","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:13022","2021-04-13 03:30:10","2021-04-13 03:30:10","1");
INSERT INTO audit_trail VALUES("2433","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:13024","2021-04-13 03:49:45","2021-04-13 03:49:45","1");
INSERT INTO audit_trail VALUES("2434","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:13031","2021-04-13 04:26:19","2021-04-13 04:26:19","1");
INSERT INTO audit_trail VALUES("2435","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:13033","2021-04-13 04:29:27","2021-04-13 04:29:27","1");
INSERT INTO audit_trail VALUES("2436","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:13088","2021-04-13 05:04:47","2021-04-13 05:04:47","1");
INSERT INTO audit_trail VALUES("2437","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:13103","2021-04-13 05:27:59","2021-04-13 05:27:59","1");
INSERT INTO audit_trail VALUES("2438","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:167","2021-04-13 07:45:34","2021-04-13 07:45:34","1");
INSERT INTO audit_trail VALUES("2439","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:168","2021-04-13 07:52:26","2021-04-13 07:52:26","1");
INSERT INTO audit_trail VALUES("2440","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:169","2021-04-13 07:59:46","2021-04-13 07:59:46","1");
INSERT INTO audit_trail VALUES("2441","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:169","2021-04-13 08:00:16","2021-04-13 08:00:16","1");
INSERT INTO audit_trail VALUES("2442","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:235","2021-04-13 08:01:50","2021-04-13 08:01:50","1");
INSERT INTO audit_trail VALUES("2443","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:236","2021-04-13 08:02:48","2021-04-13 08:02:48","1");
INSERT INTO audit_trail VALUES("2444","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:237","2021-04-13 09:17:22","2021-04-13 09:17:22","1");
INSERT INTO audit_trail VALUES("2445","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:238","2021-04-13 09:19:23","2021-04-13 09:19:23","1");
INSERT INTO audit_trail VALUES("2446","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:239","2021-04-13 11:22:10","2021-04-13 11:22:10","1");
INSERT INTO audit_trail VALUES("2447","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-13 11:34:23","2021-04-13 11:34:23","1");
INSERT INTO audit_trail VALUES("2448","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:240","2021-04-14 01:35:29","2021-04-14 01:35:29","1");
INSERT INTO audit_trail VALUES("2449","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-14 03:12:25","2021-04-14 03:12:25","1");
INSERT INTO audit_trail VALUES("2450","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-14 03:16:22","2021-04-14 03:16:22","1");
INSERT INTO audit_trail VALUES("2451","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:39","2021-04-14 03:39:24","2021-04-14 03:39:24","1");
INSERT INTO audit_trail VALUES("2452","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:39","2021-04-14 03:40:59","2021-04-14 03:40:59","1");
INSERT INTO audit_trail VALUES("2453","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:170","2021-04-14 09:59:13","2021-04-14 09:59:13","1");
INSERT INTO audit_trail VALUES("2454","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:171","2021-04-14 10:02:01","2021-04-14 10:02:01","1");
INSERT INTO audit_trail VALUES("2455","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:241","2021-04-14 10:04:40","2021-04-14 10:04:40","1");
INSERT INTO audit_trail VALUES("2456","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:242","2021-04-14 10:07:32","2021-04-14 10:07:32","1");
INSERT INTO audit_trail VALUES("2457","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:243","2021-04-14 10:09:23","2021-04-14 10:09:23","1");
INSERT INTO audit_trail VALUES("2458","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:244","2021-04-14 10:14:50","2021-04-14 10:14:50","1");
INSERT INTO audit_trail VALUES("2459","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-14 10:50:13","2021-04-14 10:50:13","1");
INSERT INTO audit_trail VALUES("2460","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-15 01:22:46","2021-04-15 01:22:46","1");
INSERT INTO audit_trail VALUES("2461","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:245","2021-04-15 02:00:33","2021-04-15 02:00:33","1");
INSERT INTO audit_trail VALUES("2462","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:219","2021-04-15 07:10:38","2021-04-15 07:10:38","1");
INSERT INTO audit_trail VALUES("2463","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-15 10:38:31","2021-04-15 10:38:31","1");
INSERT INTO audit_trail VALUES("2464","1","Admin Admin","","Logged in to system","2021-04-16 01:39:38","2021-04-16 01:39:38","");
INSERT INTO audit_trail VALUES("2465","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-16 01:48:49","2021-04-16 01:48:49","1");
INSERT INTO audit_trail VALUES("2466","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:246","2021-04-16 07:39:32","2021-04-16 07:39:32","1");
INSERT INTO audit_trail VALUES("2467","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-16 08:05:27","2021-04-16 08:05:27","1");
INSERT INTO audit_trail VALUES("2468","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-16 09:02:02","2021-04-16 09:02:02","1");
INSERT INTO audit_trail VALUES("2469","1","Admin Admin","","Logged in to system","2021-04-16 09:22:00","2021-04-16 09:22:00","");
INSERT INTO audit_trail VALUES("2470","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:247","2021-04-16 09:22:42","2021-04-16 09:22:42","1");
INSERT INTO audit_trail VALUES("2471","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:248","2021-04-16 09:24:31","2021-04-16 09:24:31","1");
INSERT INTO audit_trail VALUES("2472","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:249","2021-04-16 09:25:57","2021-04-16 09:25:57","1");
INSERT INTO audit_trail VALUES("2473","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:250","2021-04-16 09:27:17","2021-04-16 09:27:17","1");
INSERT INTO audit_trail VALUES("2474","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:172","2021-04-16 09:30:18","2021-04-16 09:30:18","1");
INSERT INTO audit_trail VALUES("2475","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-16 09:37:20","2021-04-16 09:37:20","1");
INSERT INTO audit_trail VALUES("2476","1","Admin Admin","","Added Journal Manual Entry  with id:13740","2021-04-16 09:42:52","2021-04-16 09:42:52","1");
INSERT INTO audit_trail VALUES("2477","1","Admin Admin","","Added Journal Manual Entry  with id:13742","2021-04-16 09:46:20","2021-04-16 09:46:20","1");
INSERT INTO audit_trail VALUES("2478","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-16 09:47:44","2021-04-16 09:47:44","1");
INSERT INTO audit_trail VALUES("2479","1","Admin Admin","","Added Journal Manual Entry  with id:13744","2021-04-16 09:50:47","2021-04-16 09:50:47","1");
INSERT INTO audit_trail VALUES("2480","1","Admin Admin","","Added Journal Manual Entry  with id:13751","2021-04-16 09:57:06","2021-04-16 09:57:06","1");
INSERT INTO audit_trail VALUES("2481","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:251","2021-04-16 10:02:59","2021-04-16 10:02:59","1");
INSERT INTO audit_trail VALUES("2482","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:173","2021-04-16 10:04:38","2021-04-16 10:04:38","1");
INSERT INTO audit_trail VALUES("2483","1","Admin Admin","","Added Journal Manual Entry  with id:13763","2021-04-16 10:17:37","2021-04-16 10:17:37","1");
INSERT INTO audit_trail VALUES("2484","1","Admin Admin","","Added Journal Manual Entry  with id:13765","2021-04-16 10:19:35","2021-04-16 10:19:35","1");
INSERT INTO audit_trail VALUES("2485","1","Admin Admin","","Added Journal Manual Entry  with id:13767","2021-04-16 10:21:36","2021-04-16 10:21:36","1");
INSERT INTO audit_trail VALUES("2486","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:252","2021-04-16 10:23:57","2021-04-16 10:23:57","1");
INSERT INTO audit_trail VALUES("2487","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-16 10:40:49","2021-04-16 10:40:49","1");
INSERT INTO audit_trail VALUES("2488","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-16 10:49:43","2021-04-16 10:49:43","1");
INSERT INTO audit_trail VALUES("2489","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:253","2021-04-17 02:20:46","2021-04-17 02:20:46","1");
INSERT INTO audit_trail VALUES("2490","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:254","2021-04-17 05:53:51","2021-04-17 05:53:51","1");
INSERT INTO audit_trail VALUES("2491","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:255","2021-04-17 05:55:31","2021-04-17 05:55:31","1");
INSERT INTO audit_trail VALUES("2492","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:174","2021-04-17 06:20:53","2021-04-17 06:20:53","1");
INSERT INTO audit_trail VALUES("2493","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:175","2021-04-17 06:22:17","2021-04-17 06:22:17","1");
INSERT INTO audit_trail VALUES("2494","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:256","2021-04-17 06:23:41","2021-04-17 06:23:41","1");
INSERT INTO audit_trail VALUES("2495","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:257","2021-04-17 06:24:31","2021-04-17 06:24:31","1");
INSERT INTO audit_trail VALUES("2496","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:175","2021-04-17 06:48:39","2021-04-17 06:48:39","1");
INSERT INTO audit_trail VALUES("2497","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:176","2021-04-17 06:52:14","2021-04-17 06:52:14","1");
INSERT INTO audit_trail VALUES("2498","3","BERNICE  MUTHONI MUTUGI","","Updated expense with id:175","2021-04-17 06:54:16","2021-04-17 06:54:16","1");
INSERT INTO audit_trail VALUES("2499","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-17 07:04:32","2021-04-17 07:04:32","1");
INSERT INTO audit_trail VALUES("2500","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-19 01:42:01","2021-04-19 01:42:01","");
INSERT INTO audit_trail VALUES("2501","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:258","2021-04-19 01:43:31","2021-04-19 01:43:31","1");
INSERT INTO audit_trail VALUES("2502","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-19 03:10:34","2021-04-19 03:10:34","");
INSERT INTO audit_trail VALUES("2503","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-19 05:31:16","2021-04-19 05:31:16","1");
INSERT INTO audit_trail VALUES("2504","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-19 05:41:59","2021-04-19 05:41:59","1");
INSERT INTO audit_trail VALUES("2505","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:259","2021-04-19 09:59:48","2021-04-19 09:59:48","1");
INSERT INTO audit_trail VALUES("2506","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:260","2021-04-19 10:01:03","2021-04-19 10:01:03","1");
INSERT INTO audit_trail VALUES("2507","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:261","2021-04-19 10:02:05","2021-04-19 10:02:05","1");
INSERT INTO audit_trail VALUES("2508","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:262","2021-04-20 02:25:16","2021-04-20 02:25:16","1");
INSERT INTO audit_trail VALUES("2509","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:194","2021-04-20 07:27:12","2021-04-20 07:27:12","1");
INSERT INTO audit_trail VALUES("2510","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:221","2021-04-20 07:39:47","2021-04-20 07:39:47","1");
INSERT INTO audit_trail VALUES("2511","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:206","2021-04-20 07:41:46","2021-04-20 07:41:46","1");
INSERT INTO audit_trail VALUES("2512","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:177","2021-04-20 08:02:53","2021-04-20 08:02:53","1");
INSERT INTO audit_trail VALUES("2513","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:178","2021-04-20 08:07:17","2021-04-20 08:07:17","1");
INSERT INTO audit_trail VALUES("2514","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:263","2021-04-20 09:59:43","2021-04-20 09:59:43","1");
INSERT INTO audit_trail VALUES("2515","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:264","2021-04-20 10:02:12","2021-04-20 10:02:12","1");
INSERT INTO audit_trail VALUES("2516","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-20 10:45:17","2021-04-20 10:45:17","1");
INSERT INTO audit_trail VALUES("2517","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:265","2021-04-21 01:23:12","2021-04-21 01:23:12","1");
INSERT INTO audit_trail VALUES("2518","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-21 02:25:52","2021-04-21 02:25:52","1");
INSERT INTO audit_trail VALUES("2519","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-21 03:11:29","2021-04-21 03:11:29","1");
INSERT INTO audit_trail VALUES("2520","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-21 03:42:25","2021-04-21 03:42:25","1");
INSERT INTO audit_trail VALUES("2521","1","Admin Admin","","Logged in to system","2021-04-21 03:51:35","2021-04-21 03:51:35","");
INSERT INTO audit_trail VALUES("2522","1","Admin Admin","","Undisbursed loan with id:96","2021-04-21 03:59:48","2021-04-21 03:59:48","1");
INSERT INTO audit_trail VALUES("2523","1","Admin Admin","","Unapproved loan with id:96","2021-04-21 03:59:54","2021-04-21 03:59:54","1");
INSERT INTO audit_trail VALUES("2524","1","Admin Admin","","Updated loan with id:96","2021-04-21 04:00:21","2021-04-21 04:00:21","1");
INSERT INTO audit_trail VALUES("2525","1","Admin Admin","","Approved loan with id:96","2021-04-21 04:00:56","2021-04-21 04:00:56","1");
INSERT INTO audit_trail VALUES("2526","1","Admin Admin","","Disbursed loan with id:96","2021-04-21 04:01:23","2021-04-21 04:01:23","1");
INSERT INTO audit_trail VALUES("2527","1","Admin Admin","","Added repayment for loan with id:96","2021-04-21 04:04:00","2021-04-21 04:04:00","1");
INSERT INTO audit_trail VALUES("2528","1","Admin Admin","","Undisbursed loan with id:140","2021-04-21 04:09:41","2021-04-21 04:09:41","1");
INSERT INTO audit_trail VALUES("2529","1","Admin Admin","","Unapproved loan with id:140","2021-04-21 04:10:00","2021-04-21 04:10:00","1");
INSERT INTO audit_trail VALUES("2530","1","Admin Admin","","Updated loan with id:140","2021-04-21 04:10:51","2021-04-21 04:10:51","1");
INSERT INTO audit_trail VALUES("2531","1","Admin Admin","","Approved loan with id:140","2021-04-21 04:11:24","2021-04-21 04:11:24","1");
INSERT INTO audit_trail VALUES("2532","1","Admin Admin","","Disbursed loan with id:140","2021-04-21 04:11:32","2021-04-21 04:11:32","1");
INSERT INTO audit_trail VALUES("2533","1","Admin Admin","","Added repayment for loan with id:140","2021-04-21 04:12:37","2021-04-21 04:12:37","1");
INSERT INTO audit_trail VALUES("2534","1","Admin Admin","","Undisbursed loan with id:140","2021-04-21 04:13:37","2021-04-21 04:13:37","1");
INSERT INTO audit_trail VALUES("2535","1","Admin Admin","","Unapproved loan with id:140","2021-04-21 04:13:42","2021-04-21 04:13:42","1");
INSERT INTO audit_trail VALUES("2536","1","Admin Admin","","Updated loan with id:140","2021-04-21 04:14:17","2021-04-21 04:14:17","1");
INSERT INTO audit_trail VALUES("2537","1","Admin Admin","","Approved loan with id:140","2021-04-21 04:14:38","2021-04-21 04:14:38","1");
INSERT INTO audit_trail VALUES("2538","1","Admin Admin","","Disbursed loan with id:140","2021-04-21 04:14:50","2021-04-21 04:14:50","1");
INSERT INTO audit_trail VALUES("2539","1","Admin Admin","","Added repayment for loan with id:140","2021-04-21 04:15:27","2021-04-21 04:15:27","1");
INSERT INTO audit_trail VALUES("2540","1","Admin Admin","","Deleted loan with id:39","2021-04-21 04:17:43","2021-04-21 04:17:43","1");
INSERT INTO audit_trail VALUES("2541","1","Admin Admin","","Updated role with id:3","2021-04-21 04:18:24","2021-04-21 04:18:24","1");
INSERT INTO audit_trail VALUES("2542","1","Admin Admin","","Undisbursed loan with id:47","2021-04-21 04:19:33","2021-04-21 04:19:33","1");
INSERT INTO audit_trail VALUES("2543","1","Admin Admin","","Unapproved loan with id:47","2021-04-21 04:19:42","2021-04-21 04:19:42","1");
INSERT INTO audit_trail VALUES("2544","1","Admin Admin","","Updated loan with id:47","2021-04-21 04:20:26","2021-04-21 04:20:26","1");
INSERT INTO audit_trail VALUES("2545","1","Admin Admin","","Approved loan with id:47","2021-04-21 04:20:52","2021-04-21 04:20:52","1");
INSERT INTO audit_trail VALUES("2546","1","Admin Admin","","Disbursed loan with id:47","2021-04-21 04:21:21","2021-04-21 04:21:21","1");
INSERT INTO audit_trail VALUES("2547","1","Admin Admin","","Added repayment for loan with id:47","2021-04-21 04:30:08","2021-04-21 04:30:08","1");
INSERT INTO audit_trail VALUES("2548","3","BERNICE  MUTHONI MUTUGI","","Deleted loan with id:134","2021-04-21 04:35:43","2021-04-21 04:35:43","1");
INSERT INTO audit_trail VALUES("2549","3","BERNICE  MUTHONI MUTUGI","","Deleted loan with id:185","2021-04-21 04:36:38","2021-04-21 04:36:38","1");
INSERT INTO audit_trail VALUES("2550","1","Admin Admin","","Declined borrower  with id:321","2021-04-21 04:36:55","2021-04-21 04:36:55","1");
INSERT INTO audit_trail VALUES("2551","1","Admin Admin","","Approved borrower  with id:321","2021-04-21 04:39:17","2021-04-21 04:39:17","1");
INSERT INTO audit_trail VALUES("2552","1","Admin Admin","","Deleted borrower  with id:321","2021-04-21 04:40:37","2021-04-21 04:40:37","1");
INSERT INTO audit_trail VALUES("2553","1","Admin Admin","","Deleted borrower  with id:220","2021-04-21 04:42:02","2021-04-21 04:42:02","1");
INSERT INTO audit_trail VALUES("2554","1","Admin Admin","","Undisbursed loan with id:115","2021-04-21 04:58:13","2021-04-21 04:58:13","1");
INSERT INTO audit_trail VALUES("2555","1","Admin Admin","","Unapproved loan with id:115","2021-04-21 04:58:20","2021-04-21 04:58:20","1");
INSERT INTO audit_trail VALUES("2556","1","Admin Admin","","Updated loan with id:115","2021-04-21 04:58:42","2021-04-21 04:58:42","1");
INSERT INTO audit_trail VALUES("2557","1","Admin Admin","","Approved loan with id:115","2021-04-21 04:59:26","2021-04-21 04:59:26","1");
INSERT INTO audit_trail VALUES("2558","1","Admin Admin","","Disbursed loan with id:115","2021-04-21 04:59:49","2021-04-21 04:59:49","1");
INSERT INTO audit_trail VALUES("2559","1","Admin Admin","","Added repayment for loan with id:115","2021-04-21 05:00:32","2021-04-21 05:00:32","1");
INSERT INTO audit_trail VALUES("2560","1","Admin Admin","","Updated repayment for loan with id:115","2021-04-21 05:01:01","2021-04-21 05:01:01","1");
INSERT INTO audit_trail VALUES("2561","1","Admin Admin","","Updated repayment for loan with id:115","2021-04-21 05:10:58","2021-04-21 05:10:58","1");
INSERT INTO audit_trail VALUES("2562","1","Admin Admin","","Added repayment for loan with id:115","2021-04-21 05:22:12","2021-04-21 05:22:12","1");
INSERT INTO audit_trail VALUES("2563","1","Admin Admin","","Added loan with id:193","2021-04-21 05:48:02","2021-04-21 05:48:02","1");
INSERT INTO audit_trail VALUES("2564","1","Admin Admin","","Approved loan with id:193","2021-04-21 05:49:02","2021-04-21 05:49:02","1");
INSERT INTO audit_trail VALUES("2565","1","Admin Admin","","Disbursed loan with id:193","2021-04-21 05:49:20","2021-04-21 05:49:20","1");
INSERT INTO audit_trail VALUES("2566","1","Admin Admin","","Undisbursed loan with id:122","2021-04-21 06:15:07","2021-04-21 06:15:07","1");
INSERT INTO audit_trail VALUES("2567","1","Admin Admin","","Unapproved loan with id:122","2021-04-21 06:20:27","2021-04-21 06:20:27","1");
INSERT INTO audit_trail VALUES("2568","1","Admin Admin","","Updated loan with id:122","2021-04-21 06:22:18","2021-04-21 06:22:18","1");
INSERT INTO audit_trail VALUES("2569","1","Admin Admin","","Approved loan with id:122","2021-04-21 06:23:47","2021-04-21 06:23:47","1");
INSERT INTO audit_trail VALUES("2570","1","Admin Admin","","Disbursed loan with id:122","2021-04-21 06:24:29","2021-04-21 06:24:29","1");
INSERT INTO audit_trail VALUES("2571","1","Admin Admin","","Added repayment for loan with id:122","2021-04-21 06:26:57","2021-04-21 06:26:57","1");
INSERT INTO audit_trail VALUES("2572","3","BERNICE  MUTHONI MUTUGI","","Deleted loan with id:75","2021-04-21 06:34:03","2021-04-21 06:34:03","1");
INSERT INTO audit_trail VALUES("2573","3","BERNICE  MUTHONI MUTUGI","","Deleted loan with id:191","2021-04-21 06:34:58","2021-04-21 06:34:58","1");
INSERT INTO audit_trail VALUES("2574","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:14225","2021-04-21 06:45:02","2021-04-21 06:45:02","1");
INSERT INTO audit_trail VALUES("2575","1","Admin Admin","","Deleted payroll with id:6","2021-04-21 07:25:27","2021-04-21 07:25:27","1");
INSERT INTO audit_trail VALUES("2576","1","Admin Admin","","Added Journal Manual Entry  with id:14229","2021-04-21 07:36:34","2021-04-21 07:36:34","1");
INSERT INTO audit_trail VALUES("2577","1","Admin Admin","","Added Journal Manual Entry  with id:14231","2021-04-21 07:38:26","2021-04-21 07:38:26","1");
INSERT INTO audit_trail VALUES("2578","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:14234","2021-04-21 07:52:38","2021-04-21 07:52:38","1");
INSERT INTO audit_trail VALUES("2579","1","Admin Admin","","Logged out of system","2021-04-21 08:28:30","2021-04-21 08:28:30","1");
INSERT INTO audit_trail VALUES("2580","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:179","2021-04-21 08:41:01","2021-04-21 08:41:01","1");
INSERT INTO audit_trail VALUES("2581","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:266","2021-04-21 08:59:51","2021-04-21 08:59:51","1");
INSERT INTO audit_trail VALUES("2582","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-21 09:47:15","2021-04-21 09:47:15","1");
INSERT INTO audit_trail VALUES("2583","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-21 10:36:52","2021-04-21 10:36:52","1");
INSERT INTO audit_trail VALUES("2584","1","Admin Admin","","Logged in to system","2021-04-21 10:40:14","2021-04-21 10:40:14","1");
INSERT INTO audit_trail VALUES("2585","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:627","2021-04-21 10:40:34","2021-04-21 10:40:34","1");
INSERT INTO audit_trail VALUES("2586","1","Admin Admin","","Logged out of system","2021-04-21 10:51:02","2021-04-21 10:51:02","1");
INSERT INTO audit_trail VALUES("2587","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:267","2021-04-21 11:13:56","2021-04-21 11:13:56","1");
INSERT INTO audit_trail VALUES("2588","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-21 11:50:51","2021-04-21 11:50:51","1");
INSERT INTO audit_trail VALUES("2589","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:268","2021-04-22 01:14:06","2021-04-22 01:14:06","1");
INSERT INTO audit_trail VALUES("2590","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-22 02:11:24","2021-04-22 02:11:24","1");
INSERT INTO audit_trail VALUES("2591","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-22 02:11:52","2021-04-22 02:11:52","1");
INSERT INTO audit_trail VALUES("2592","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-22 04:47:32","2021-04-22 04:47:32","1");
INSERT INTO audit_trail VALUES("2593","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:269","2021-04-22 05:09:25","2021-04-22 05:09:25","1");
INSERT INTO audit_trail VALUES("2594","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:270","2021-04-22 05:12:21","2021-04-22 05:12:21","1");
INSERT INTO audit_trail VALUES("2595","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:271","2021-04-22 08:13:28","2021-04-22 08:13:28","1");
INSERT INTO audit_trail VALUES("2596","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:272","2021-04-22 08:14:44","2021-04-22 08:14:44","1");
INSERT INTO audit_trail VALUES("2597","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:180","2021-04-22 08:17:49","2021-04-22 08:17:49","1");
INSERT INTO audit_trail VALUES("2598","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:273","2021-04-22 10:21:45","2021-04-22 10:21:45","1");
INSERT INTO audit_trail VALUES("2599","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-22 10:53:47","2021-04-22 10:53:47","1");
INSERT INTO audit_trail VALUES("2600","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:274","2021-04-23 01:33:32","2021-04-23 01:33:32","1");
INSERT INTO audit_trail VALUES("2601","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-23 02:57:45","2021-04-23 02:57:45","1");
INSERT INTO audit_trail VALUES("2602","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-23 02:58:04","2021-04-23 02:58:04","1");
INSERT INTO audit_trail VALUES("2603","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-23 03:56:39","2021-04-23 03:56:39","1");
INSERT INTO audit_trail VALUES("2604","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-23 08:00:15","2021-04-23 08:00:15","1");
INSERT INTO audit_trail VALUES("2605","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:181","2021-04-23 09:14:45","2021-04-23 09:14:45","1");
INSERT INTO audit_trail VALUES("2606","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:182","2021-04-23 09:16:16","2021-04-23 09:16:16","1");
INSERT INTO audit_trail VALUES("2607","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-23 09:34:59","2021-04-23 09:34:59","");
INSERT INTO audit_trail VALUES("2608","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:196","2021-04-23 09:37:22","2021-04-23 09:37:22","1");
INSERT INTO audit_trail VALUES("2609","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:221","2021-04-23 09:39:28","2021-04-23 09:39:28","1");
INSERT INTO audit_trail VALUES("2610","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:207","2021-04-23 09:40:13","2021-04-23 09:40:13","1");
INSERT INTO audit_trail VALUES("2611","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:207","2021-04-23 09:41:02","2021-04-23 09:41:02","1");
INSERT INTO audit_trail VALUES("2612","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:275","2021-04-23 09:56:01","2021-04-23 09:56:01","1");
INSERT INTO audit_trail VALUES("2613","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:276","2021-04-23 10:12:42","2021-04-23 10:12:42","1");
INSERT INTO audit_trail VALUES("2614","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:277","2021-04-23 10:14:02","2021-04-23 10:14:02","1");
INSERT INTO audit_trail VALUES("2615","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:278","2021-04-23 10:15:05","2021-04-23 10:15:05","1");
INSERT INTO audit_trail VALUES("2616","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:279","2021-04-23 10:16:17","2021-04-23 10:16:17","1");
INSERT INTO audit_trail VALUES("2617","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:183","2021-04-23 10:48:09","2021-04-23 10:48:09","1");
INSERT INTO audit_trail VALUES("2618","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-23 10:59:03","2021-04-23 10:59:03","1");
INSERT INTO audit_trail VALUES("2619","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:280","2021-04-24 01:19:12","2021-04-24 01:19:12","1");
INSERT INTO audit_trail VALUES("2620","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-24 01:36:57","2021-04-24 01:36:57","1");
INSERT INTO audit_trail VALUES("2621","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:206","2021-04-24 02:46:05","2021-04-24 02:46:05","1");
INSERT INTO audit_trail VALUES("2622","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:126","2021-04-24 03:36:41","2021-04-24 03:36:41","1");
INSERT INTO audit_trail VALUES("2623","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:126","2021-04-24 03:36:49","2021-04-24 03:36:49","1");
INSERT INTO audit_trail VALUES("2624","2","CECILIA WANJERI WANGUHU","","Updated loan with id:126","2021-04-24 03:37:44","2021-04-24 03:37:44","1");
INSERT INTO audit_trail VALUES("2625","2","CECILIA WANJERI WANGUHU","","Approved loan with id:126","2021-04-24 03:38:40","2021-04-24 03:38:40","1");
INSERT INTO audit_trail VALUES("2626","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:126","2021-04-24 03:39:05","2021-04-24 03:39:05","1");
INSERT INTO audit_trail VALUES("2627","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:126","2021-04-24 03:42:45","2021-04-24 03:42:45","1");
INSERT INTO audit_trail VALUES("2628","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:126","2021-04-24 03:42:54","2021-04-24 03:42:54","1");
INSERT INTO audit_trail VALUES("2629","2","CECILIA WANJERI WANGUHU","","Updated loan with id:126","2021-04-24 03:46:31","2021-04-24 03:46:31","1");
INSERT INTO audit_trail VALUES("2630","2","CECILIA WANJERI WANGUHU","","Approved loan with id:126","2021-04-24 03:47:00","2021-04-24 03:47:00","1");
INSERT INTO audit_trail VALUES("2631","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:126","2021-04-24 03:47:10","2021-04-24 03:47:10","1");
INSERT INTO audit_trail VALUES("2632","2","CECILIA WANJERI WANGUHU","","Updated loan with id:126","2021-04-24 03:49:17","2021-04-24 03:49:17","1");
INSERT INTO audit_trail VALUES("2633","1","Admin Admin","","Logged in to system","2021-04-24 03:53:25","2021-04-24 03:53:25","");
INSERT INTO audit_trail VALUES("2634","2","CECILIA WANJERI WANGUHU","","Updated loan with id:126","2021-04-24 03:53:40","2021-04-24 03:53:40","1");
INSERT INTO audit_trail VALUES("2635","1","Admin Admin","","Updated role with id:3","2021-04-24 03:54:15","2021-04-24 03:54:15","1");
INSERT INTO audit_trail VALUES("2636","3","BERNICE  MUTHONI MUTUGI","","Added repayment for loan with id:126","2021-04-24 03:57:27","2021-04-24 03:57:27","1");
INSERT INTO audit_trail VALUES("2637","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:184","2021-04-24 04:16:21","2021-04-24 04:16:21","1");
INSERT INTO audit_trail VALUES("2638","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:281","2021-04-24 04:18:05","2021-04-24 04:18:05","1");
INSERT INTO audit_trail VALUES("2639","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:282","2021-04-24 04:20:10","2021-04-24 04:20:10","1");
INSERT INTO audit_trail VALUES("2640","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:283","2021-04-24 05:00:43","2021-04-24 05:00:43","1");
INSERT INTO audit_trail VALUES("2641","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:284","2021-04-24 05:02:44","2021-04-24 05:02:44","1");
INSERT INTO audit_trail VALUES("2642","1","Admin Admin","","Logged in to system","2021-04-24 06:40:21","2021-04-24 06:40:21","");
INSERT INTO audit_trail VALUES("2643","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-24 07:00:46","2021-04-24 07:00:46","1");
INSERT INTO audit_trail VALUES("2644","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-26 02:12:18","2021-04-26 02:12:18","");
INSERT INTO audit_trail VALUES("2645","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-26 03:01:15","2021-04-26 03:01:15","");
INSERT INTO audit_trail VALUES("2646","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:285","2021-04-26 03:03:59","2021-04-26 03:03:59","1");
INSERT INTO audit_trail VALUES("2647","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-26 04:52:28","2021-04-26 04:52:28","1");
INSERT INTO audit_trail VALUES("2648","1","Admin Admin","","Logged in to system","2021-04-26 05:24:19","2021-04-26 05:24:19","");
INSERT INTO audit_trail VALUES("2649","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-26 06:25:12","2021-04-26 06:25:12","1");
INSERT INTO audit_trail VALUES("2650","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-26 06:52:21","2021-04-26 06:52:21","");
INSERT INTO audit_trail VALUES("2651","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-04-26 10:21:33","2021-04-26 10:21:33","1");
INSERT INTO audit_trail VALUES("2652","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-26 10:21:56","2021-04-26 10:21:56","1");
INSERT INTO audit_trail VALUES("2653","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-27 01:25:44","2021-04-27 01:25:44","1");
INSERT INTO audit_trail VALUES("2654","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:286","2021-04-27 01:27:12","2021-04-27 01:27:12","1");
INSERT INTO audit_trail VALUES("2655","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-27 01:30:26","2021-04-27 01:30:26","1");
INSERT INTO audit_trail VALUES("2656","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:287","2021-04-27 07:51:50","2021-04-27 07:51:50","1");
INSERT INTO audit_trail VALUES("2657","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:288","2021-04-27 07:54:04","2021-04-27 07:54:04","1");
INSERT INTO audit_trail VALUES("2658","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:289","2021-04-27 07:57:20","2021-04-27 07:57:20","1");
INSERT INTO audit_trail VALUES("2659","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:290","2021-04-27 07:58:04","2021-04-27 07:58:04","1");
INSERT INTO audit_trail VALUES("2660","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:185","2021-04-27 08:07:55","2021-04-27 08:07:55","1");
INSERT INTO audit_trail VALUES("2661","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:186","2021-04-27 08:09:13","2021-04-27 08:09:13","1");
INSERT INTO audit_trail VALUES("2662","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:187","2021-04-27 08:20:27","2021-04-27 08:20:27","1");
INSERT INTO audit_trail VALUES("2663","1","Admin Admin","","Logged in to system","2021-04-27 08:37:33","2021-04-27 08:37:33","");
INSERT INTO audit_trail VALUES("2664","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:188","2021-04-27 10:10:44","2021-04-27 10:10:44","1");
INSERT INTO audit_trail VALUES("2665","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-27 10:34:26","2021-04-27 10:34:26","1");
INSERT INTO audit_trail VALUES("2666","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-04-27 10:34:46","2021-04-27 10:34:46","1");
INSERT INTO audit_trail VALUES("2667","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-28 01:39:22","2021-04-28 01:39:22","1");
INSERT INTO audit_trail VALUES("2668","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:291","2021-04-28 01:40:35","2021-04-28 01:40:35","1");
INSERT INTO audit_trail VALUES("2669","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-28 01:49:49","2021-04-28 01:49:49","1");
INSERT INTO audit_trail VALUES("2670","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-28 02:51:52","2021-04-28 02:51:52","");
INSERT INTO audit_trail VALUES("2671","3","BERNICE  MUTHONI MUTUGI","","Deleted loan with id:181","2021-04-28 02:52:26","2021-04-28 02:52:26","1");
INSERT INTO audit_trail VALUES("2672","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:292","2021-04-28 07:34:19","2021-04-28 07:34:19","1");
INSERT INTO audit_trail VALUES("2673","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-28 10:29:55","2021-04-28 10:29:55","1");
INSERT INTO audit_trail VALUES("2674","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-04-28 10:30:27","2021-04-28 10:30:27","1");
INSERT INTO audit_trail VALUES("2675","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-29 01:28:37","2021-04-29 01:28:37","1");
INSERT INTO audit_trail VALUES("2676","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-29 01:37:16","2021-04-29 01:37:16","1");
INSERT INTO audit_trail VALUES("2677","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-29 01:45:27","2021-04-29 01:45:27","1");
INSERT INTO audit_trail VALUES("2678","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:293","2021-04-29 01:46:42","2021-04-29 01:46:42","1");
INSERT INTO audit_trail VALUES("2679","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-29 04:18:33","2021-04-29 04:18:33","1");
INSERT INTO audit_trail VALUES("2680","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:294","2021-04-29 05:56:59","2021-04-29 05:56:59","1");
INSERT INTO audit_trail VALUES("2681","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:295","2021-04-29 05:58:03","2021-04-29 05:58:03","1");
INSERT INTO audit_trail VALUES("2682","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-29 10:12:11","2021-04-29 10:12:11","1");
INSERT INTO audit_trail VALUES("2683","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-04-29 10:13:30","2021-04-29 10:13:30","1");
INSERT INTO audit_trail VALUES("2684","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-29 10:51:45","2021-04-29 10:51:45","1");
INSERT INTO audit_trail VALUES("2685","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-29 10:52:58","2021-04-29 10:52:58","1");
INSERT INTO audit_trail VALUES("2686","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 01:41:06","2021-04-30 01:41:06","1");
INSERT INTO audit_trail VALUES("2687","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 02:07:17","2021-04-30 02:07:17","1");
INSERT INTO audit_trail VALUES("2688","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-30 02:27:46","2021-04-30 02:27:46","1");
INSERT INTO audit_trail VALUES("2689","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:296","2021-04-30 02:29:02","2021-04-30 02:29:02","1");
INSERT INTO audit_trail VALUES("2690","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 03:45:19","2021-04-30 03:45:19","1");
INSERT INTO audit_trail VALUES("2691","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-30 04:56:36","2021-04-30 04:56:36","");
INSERT INTO audit_trail VALUES("2692","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-04-30 05:58:45","2021-04-30 05:58:45","1");
INSERT INTO audit_trail VALUES("2693","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 06:38:34","2021-04-30 06:38:34","1");
INSERT INTO audit_trail VALUES("2694","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-30 06:38:44","2021-04-30 06:38:44","1");
INSERT INTO audit_trail VALUES("2695","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:297","2021-04-30 06:41:47","2021-04-30 06:41:47","1");
INSERT INTO audit_trail VALUES("2696","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 06:43:21","2021-04-30 06:43:21","1");
INSERT INTO audit_trail VALUES("2697","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:298","2021-04-30 06:44:54","2021-04-30 06:44:54","1");
INSERT INTO audit_trail VALUES("2698","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:299","2021-04-30 06:46:42","2021-04-30 06:46:42","1");
INSERT INTO audit_trail VALUES("2699","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:300","2021-04-30 06:47:32","2021-04-30 06:47:32","1");
INSERT INTO audit_trail VALUES("2700","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 06:48:34","2021-04-30 06:48:34","1");
INSERT INTO audit_trail VALUES("2701","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-04-30 06:49:07","2021-04-30 06:49:07","1");
INSERT INTO audit_trail VALUES("2702","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 07:10:49","2021-04-30 07:10:49","1");
INSERT INTO audit_trail VALUES("2703","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-04-30 08:20:41","2021-04-30 08:20:41","1");
INSERT INTO audit_trail VALUES("2704","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:189","2021-04-30 09:04:25","2021-04-30 09:04:25","1");
INSERT INTO audit_trail VALUES("2705","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:190","2021-04-30 09:06:10","2021-04-30 09:06:10","1");
INSERT INTO audit_trail VALUES("2706","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:191","2021-04-30 09:11:31","2021-04-30 09:11:31","1");
INSERT INTO audit_trail VALUES("2707","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:192","2021-04-30 09:13:55","2021-04-30 09:13:55","1");
INSERT INTO audit_trail VALUES("2708","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-04-30 10:27:47","2021-04-30 10:27:47","1");
INSERT INTO audit_trail VALUES("2709","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-04-30 10:28:50","2021-04-30 10:28:50","1");
INSERT INTO audit_trail VALUES("2710","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-03 01:23:40","2021-05-03 01:23:40","");
INSERT INTO audit_trail VALUES("2711","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:301","2021-05-03 01:31:09","2021-05-03 01:31:09","1");
INSERT INTO audit_trail VALUES("2712","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-03 01:34:57","2021-05-03 01:34:57","");
INSERT INTO audit_trail VALUES("2713","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-03 01:38:28","2021-05-03 01:38:28","1");
INSERT INTO audit_trail VALUES("2714","1","Admin Admin","","Logged in to system","2021-05-03 07:24:57","2021-05-03 07:24:57","");
INSERT INTO audit_trail VALUES("2715","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:302","2021-05-03 09:55:50","2021-05-03 09:55:50","1");
INSERT INTO audit_trail VALUES("2716","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:303","2021-05-03 09:57:06","2021-05-03 09:57:06","1");
INSERT INTO audit_trail VALUES("2717","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:304","2021-05-03 09:58:29","2021-05-03 09:58:29","1");
INSERT INTO audit_trail VALUES("2718","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:305","2021-05-03 10:00:04","2021-05-03 10:00:04","1");
INSERT INTO audit_trail VALUES("2719","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-03 10:20:53","2021-05-03 10:20:53","1");
INSERT INTO audit_trail VALUES("2720","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-03 10:24:04","2021-05-03 10:24:04","1");
INSERT INTO audit_trail VALUES("2721","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-04 01:26:00","2021-05-04 01:26:00","1");
INSERT INTO audit_trail VALUES("2722","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-04 01:30:12","2021-05-04 01:30:12","1");
INSERT INTO audit_trail VALUES("2723","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-04 01:31:24","2021-05-04 01:31:24","");
INSERT INTO audit_trail VALUES("2724","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:306","2021-05-04 01:33:57","2021-05-04 01:33:57","1");
INSERT INTO audit_trail VALUES("2725","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-04 01:52:42","2021-05-04 01:52:42","1");
INSERT INTO audit_trail VALUES("2726","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-04 02:01:56","2021-05-04 02:01:56","1");
INSERT INTO audit_trail VALUES("2727","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-04 02:11:49","2021-05-04 02:11:49","1");
INSERT INTO audit_trail VALUES("2728","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:307","2021-05-04 05:21:32","2021-05-04 05:21:32","1");
INSERT INTO audit_trail VALUES("2729","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:308","2021-05-04 05:22:39","2021-05-04 05:22:39","1");
INSERT INTO audit_trail VALUES("2730","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:309","2021-05-04 05:23:54","2021-05-04 05:23:54","1");
INSERT INTO audit_trail VALUES("2731","1","Admin Admin","","Logged in to system","2021-05-04 06:56:27","2021-05-04 06:56:27","");
INSERT INTO audit_trail VALUES("2732","3","BERNICE  MUTHONI MUTUGI","","Updated loan with id:179","2021-05-04 08:57:32","2021-05-04 08:57:32","1");
INSERT INTO audit_trail VALUES("2733","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:179","2021-05-04 08:58:15","2021-05-04 08:58:15","1");
INSERT INTO audit_trail VALUES("2734","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:179","2021-05-04 08:59:41","2021-05-04 08:59:41","1");
INSERT INTO audit_trail VALUES("2735","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:179","2021-05-04 09:09:44","2021-05-04 09:09:44","1");
INSERT INTO audit_trail VALUES("2736","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:179","2021-05-04 09:11:00","2021-05-04 09:11:00","1");
INSERT INTO audit_trail VALUES("2737","3","BERNICE  MUTHONI MUTUGI","","Added repayment for loan with id:179","2021-05-04 09:13:04","2021-05-04 09:13:04","1");
INSERT INTO audit_trail VALUES("2738","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15516","2021-05-04 09:40:06","2021-05-04 09:40:06","1");
INSERT INTO audit_trail VALUES("2739","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15520","2021-05-04 09:41:55","2021-05-04 09:41:55","1");
INSERT INTO audit_trail VALUES("2740","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15530","2021-05-04 09:47:54","2021-05-04 09:47:54","1");
INSERT INTO audit_trail VALUES("2741","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:193","2021-05-04 10:00:12","2021-05-04 10:00:12","1");
INSERT INTO audit_trail VALUES("2742","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:194","2021-05-04 10:01:06","2021-05-04 10:01:06","1");
INSERT INTO audit_trail VALUES("2743","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:195","2021-05-04 10:02:56","2021-05-04 10:02:56","1");
INSERT INTO audit_trail VALUES("2744","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-04 10:36:05","2021-05-04 10:36:05","1");
INSERT INTO audit_trail VALUES("2745","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-04 10:37:49","2021-05-04 10:37:49","1");
INSERT INTO audit_trail VALUES("2746","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-05 01:12:33","2021-05-05 01:12:33","1");
INSERT INTO audit_trail VALUES("2747","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 01:33:35","2021-05-05 01:33:35","1");
INSERT INTO audit_trail VALUES("2748","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:310","2021-05-05 03:00:35","2021-05-05 03:00:35","1");
INSERT INTO audit_trail VALUES("2749","3","BERNICE  MUTHONI MUTUGI","","Added expense with id:196","2021-05-05 03:02:11","2021-05-05 03:02:11","1");
INSERT INTO audit_trail VALUES("2750","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 03:32:30","2021-05-05 03:32:30","");
INSERT INTO audit_trail VALUES("2751","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-05 03:38:01","2021-05-05 03:38:01","1");
INSERT INTO audit_trail VALUES("2752","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 03:42:56","2021-05-05 03:42:56","1");
INSERT INTO audit_trail VALUES("2753","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-05 04:37:44","2021-05-05 04:37:44","1");
INSERT INTO audit_trail VALUES("2754","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-05 04:43:09","2021-05-05 04:43:09","1");
INSERT INTO audit_trail VALUES("2755","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:311","2021-05-05 04:51:53","2021-05-05 04:51:53","1");
INSERT INTO audit_trail VALUES("2756","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:312","2021-05-05 04:53:00","2021-05-05 04:53:00","1");
INSERT INTO audit_trail VALUES("2757","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:313","2021-05-05 04:55:37","2021-05-05 04:55:37","1");
INSERT INTO audit_trail VALUES("2758","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15610","2021-05-05 05:14:51","2021-05-05 05:14:51","1");
INSERT INTO audit_trail VALUES("2759","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15619","2021-05-05 05:22:00","2021-05-05 05:22:00","1");
INSERT INTO audit_trail VALUES("2760","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-05 05:29:53","2021-05-05 05:29:53","1");
INSERT INTO audit_trail VALUES("2761","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15628","2021-05-05 05:43:46","2021-05-05 05:43:46","1");
INSERT INTO audit_trail VALUES("2762","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15637","2021-05-05 05:59:03","2021-05-05 05:59:03","1");
INSERT INTO audit_trail VALUES("2763","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 06:27:05","2021-05-05 06:27:05","");
INSERT INTO audit_trail VALUES("2764","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 07:28:35","2021-05-05 07:28:35","1");
INSERT INTO audit_trail VALUES("2765","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:15653","2021-05-05 08:00:40","2021-05-05 08:00:40","1");
INSERT INTO audit_trail VALUES("2766","1","Admin Admin","","Logged in to system","2021-05-05 08:18:53","2021-05-05 08:18:53","");
INSERT INTO audit_trail VALUES("2767","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-05 08:21:15","2021-05-05 08:21:15","1");
INSERT INTO audit_trail VALUES("2768","1","Admin Admin","","Logged in to system","2021-05-05 08:21:41","2021-05-05 08:21:41","1");
INSERT INTO audit_trail VALUES("2769","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 08:22:05","2021-05-05 08:22:05","1");
INSERT INTO audit_trail VALUES("2770","1","Admin Admin","","Updated borrower  with id:612","2021-05-05 08:23:08","2021-05-05 08:23:08","1");
INSERT INTO audit_trail VALUES("2771","1","Admin Admin","","Updated borrower  with id:276","2021-05-05 08:24:21","2021-05-05 08:24:21","1");
INSERT INTO audit_trail VALUES("2772","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:15664","2021-05-05 09:04:00","2021-05-05 09:04:00","1");
INSERT INTO audit_trail VALUES("2773","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:15673","2021-05-05 09:11:41","2021-05-05 09:11:41","1");
INSERT INTO audit_trail VALUES("2774","3","BERNICE  MUTHONI MUTUGI","","Added repayment for loan with id:17","2021-05-05 10:04:03","2021-05-05 10:04:03","1");
INSERT INTO audit_trail VALUES("2775","3","BERNICE  MUTHONI MUTUGI","","Added loan with id:194","2021-05-05 10:05:58","2021-05-05 10:05:58","1");
INSERT INTO audit_trail VALUES("2776","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:194","2021-05-05 10:06:27","2021-05-05 10:06:27","1");
INSERT INTO audit_trail VALUES("2777","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:194","2021-05-05 10:06:41","2021-05-05 10:06:41","1");
INSERT INTO audit_trail VALUES("2778","3","BERNICE  MUTHONI MUTUGI","","Undisbursed loan with id:194","2021-05-05 10:07:55","2021-05-05 10:07:55","1");
INSERT INTO audit_trail VALUES("2779","3","BERNICE  MUTHONI MUTUGI","","Unapproved loan with id:194","2021-05-05 10:08:03","2021-05-05 10:08:03","1");
INSERT INTO audit_trail VALUES("2780","3","BERNICE  MUTHONI MUTUGI","","Approved loan with id:194","2021-05-05 10:08:11","2021-05-05 10:08:11","1");
INSERT INTO audit_trail VALUES("2781","3","BERNICE  MUTHONI MUTUGI","","Disbursed loan with id:194","2021-05-05 10:08:17","2021-05-05 10:08:17","1");
INSERT INTO audit_trail VALUES("2782","3","BERNICE  MUTHONI MUTUGI","","Added repayment for loan with id:145","2021-05-05 10:15:49","2021-05-05 10:15:49","1");
INSERT INTO audit_trail VALUES("2783","3","BERNICE  MUTHONI MUTUGI","","Added Journal Manual Entry  with id:15745","2021-05-05 10:29:22","2021-05-05 10:29:22","1");
INSERT INTO audit_trail VALUES("2784","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-05 10:49:39","2021-05-05 10:49:39","1");
INSERT INTO audit_trail VALUES("2785","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 10:56:31","2021-05-05 10:56:31","1");
INSERT INTO audit_trail VALUES("2786","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-05 11:06:31","2021-05-05 11:06:31","1");
INSERT INTO audit_trail VALUES("2787","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-05 11:16:42","2021-05-05 11:16:42","1");
INSERT INTO audit_trail VALUES("2788","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-06 01:00:27","2021-05-06 01:00:27","1");
INSERT INTO audit_trail VALUES("2789","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-06 01:27:26","2021-05-06 01:27:26","1");
INSERT INTO audit_trail VALUES("2790","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:314","2021-05-06 01:29:12","2021-05-06 01:29:12","1");
INSERT INTO audit_trail VALUES("2791","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-06 01:42:22","2021-05-06 01:42:22","1");
INSERT INTO audit_trail VALUES("2792","1","Admin Admin","","Added expense with id:197","2021-05-06 02:54:48","2021-05-06 02:54:48","1");
INSERT INTO audit_trail VALUES("2793","1","Admin Admin","","Added Capital  with id:315","2021-05-06 07:59:59","2021-05-06 07:59:59","1");
INSERT INTO audit_trail VALUES("2794","1","Admin Admin","","Added Capital  with id:316","2021-05-06 08:01:26","2021-05-06 08:01:26","1");
INSERT INTO audit_trail VALUES("2795","1","Admin Admin","","Added Capital  with id:317","2021-05-06 08:03:55","2021-05-06 08:03:55","1");
INSERT INTO audit_trail VALUES("2796","1","Admin Admin","","Added Capital  with id:318","2021-05-06 08:05:36","2021-05-06 08:05:36","1");
INSERT INTO audit_trail VALUES("2797","1","Admin Admin","","Added Capital  with id:319","2021-05-06 08:16:24","2021-05-06 08:16:24","1");
INSERT INTO audit_trail VALUES("2798","1","Admin Admin","","Added Capital  with id:320","2021-05-06 08:17:58","2021-05-06 08:17:58","1");
INSERT INTO audit_trail VALUES("2799","1","Admin Admin","","Added Capital  with id:321","2021-05-06 08:48:59","2021-05-06 08:48:59","1");
INSERT INTO audit_trail VALUES("2800","1","Admin Admin","","Added expense with id:198","2021-05-06 09:40:47","2021-05-06 09:40:47","1");
INSERT INTO audit_trail VALUES("2801","1","Admin Admin","","Added expense with id:199","2021-05-06 09:48:29","2021-05-06 09:48:29","1");
INSERT INTO audit_trail VALUES("2802","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-06 10:07:15","2021-05-06 10:07:15","1");
INSERT INTO audit_trail VALUES("2803","1","Admin Admin","","Logged out of system","2021-05-06 10:07:38","2021-05-06 10:07:38","1");
INSERT INTO audit_trail VALUES("2804","1","Admin Admin","","Logged in to system","2021-05-07 01:40:22","2021-05-07 01:40:22","1");
INSERT INTO audit_trail VALUES("2805","1","Admin Admin","","Added Capital  with id:322","2021-05-07 01:41:49","2021-05-07 01:41:49","1");
INSERT INTO audit_trail VALUES("2806","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-07 01:57:18","2021-05-07 01:57:18","1");
INSERT INTO audit_trail VALUES("2807","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15839","2021-05-07 03:25:30","2021-05-07 03:25:30","1");
INSERT INTO audit_trail VALUES("2808","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:15848","2021-05-07 03:31:17","2021-05-07 03:31:17","1");
INSERT INTO audit_trail VALUES("2809","1","Admin Admin","","Added Capital  with id:323","2021-05-07 03:55:52","2021-05-07 03:55:52","1");
INSERT INTO audit_trail VALUES("2810","1","Admin Admin","","Added Capital  with id:324","2021-05-07 03:56:49","2021-05-07 03:56:49","1");
INSERT INTO audit_trail VALUES("2811","1","Admin Admin","","Added expense with id:200","2021-05-07 03:58:28","2021-05-07 03:58:28","1");
INSERT INTO audit_trail VALUES("2812","1","Admin Admin","","Added Capital  with id:325","2021-05-07 04:02:10","2021-05-07 04:02:10","1");
INSERT INTO audit_trail VALUES("2813","1","Admin Admin","","Added Capital  with id:326","2021-05-07 04:03:40","2021-05-07 04:03:40","1");
INSERT INTO audit_trail VALUES("2814","1","Admin Admin","","Added Capital  with id:327","2021-05-07 07:17:14","2021-05-07 07:17:14","1");
INSERT INTO audit_trail VALUES("2815","1","Admin Admin","","Added Capital  with id:328","2021-05-07 08:24:54","2021-05-07 08:24:54","1");
INSERT INTO audit_trail VALUES("2816","1","Admin Admin","","Logged out of system","2021-05-07 10:13:51","2021-05-07 10:13:51","1");
INSERT INTO audit_trail VALUES("2817","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-07 10:16:34","2021-05-07 10:16:34","1");
INSERT INTO audit_trail VALUES("2818","1","Admin Admin","","Logged in to system","2021-05-08 01:38:56","2021-05-08 01:38:56","1");
INSERT INTO audit_trail VALUES("2819","1","Admin Admin","","Added Capital  with id:329","2021-05-08 01:40:17","2021-05-08 01:40:17","1");
INSERT INTO audit_trail VALUES("2820","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-08 01:46:48","2021-05-08 01:46:48","");
INSERT INTO audit_trail VALUES("2821","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-08 02:56:10","2021-05-08 02:56:10","1");
INSERT INTO audit_trail VALUES("2822","1","Admin Admin","","Added expense with id:201","2021-05-08 05:34:37","2021-05-08 05:34:37","1");
INSERT INTO audit_trail VALUES("2823","1","Admin Admin","","Added Capital  with id:330","2021-05-08 05:35:29","2021-05-08 05:35:29","1");
INSERT INTO audit_trail VALUES("2824","1","Admin Admin","","Added Capital  with id:331","2021-05-08 05:36:35","2021-05-08 05:36:35","1");
INSERT INTO audit_trail VALUES("2825","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-08 07:26:26","2021-05-08 07:26:26","1");
INSERT INTO audit_trail VALUES("2826","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-08 07:26:59","2021-05-08 07:26:59","1");
INSERT INTO audit_trail VALUES("2827","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-08 07:27:11","2021-05-08 07:27:11","1");
INSERT INTO audit_trail VALUES("2828","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-08 07:27:25","2021-05-08 07:27:25","1");
INSERT INTO audit_trail VALUES("2829","1","Admin Admin","","Logged in to system","2021-05-08 07:46:21","2021-05-08 07:46:21","");
INSERT INTO audit_trail VALUES("2830","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-10 01:20:00","2021-05-10 01:20:00","");
INSERT INTO audit_trail VALUES("2831","3","BERNICE  MUTHONI MUTUGI","","Added Capital  with id:332","2021-05-10 01:21:11","2021-05-10 01:21:11","1");
INSERT INTO audit_trail VALUES("2832","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-10 01:29:43","2021-05-10 01:29:43","");
INSERT INTO audit_trail VALUES("2833","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:332","2021-05-10 02:15:07","2021-05-10 02:15:07","1");
INSERT INTO audit_trail VALUES("2834","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:332","2021-05-10 02:15:09","2021-05-10 02:15:09","1");
INSERT INTO audit_trail VALUES("2835","3","BERNICE  MUTHONI MUTUGI","","Updated Capital  with id:330","2021-05-10 02:17:37","2021-05-10 02:17:37","1");
INSERT INTO audit_trail VALUES("2836","1","Admin Admin","","Logged in to system","2021-05-10 03:05:40","2021-05-10 03:05:40","");
INSERT INTO audit_trail VALUES("2837","1","Admin Admin","","Added expense with id:202","2021-05-10 03:07:33","2021-05-10 03:07:33","1");
INSERT INTO audit_trail VALUES("2838","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-10 03:56:12","2021-05-10 03:56:12","1");
INSERT INTO audit_trail VALUES("2839","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-10 03:56:36","2021-05-10 03:56:36","1");
INSERT INTO audit_trail VALUES("2840","1","Admin Admin","","Added Capital  with id:333","2021-05-10 05:11:21","2021-05-10 05:11:21","1");
INSERT INTO audit_trail VALUES("2841","1","Admin Admin","","Added Capital  with id:334","2021-05-10 05:12:20","2021-05-10 05:12:20","1");
INSERT INTO audit_trail VALUES("2842","1","Admin Admin","","Added expense with id:203","2021-05-10 05:15:11","2021-05-10 05:15:11","1");
INSERT INTO audit_trail VALUES("2843","1","Admin Admin","","Added expense with id:204","2021-05-10 05:15:11","2021-05-10 05:15:11","1");
INSERT INTO audit_trail VALUES("2844","1","Admin Admin","","Deleted expense with id:204","2021-05-10 05:15:33","2021-05-10 05:15:33","1");
INSERT INTO audit_trail VALUES("2845","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-10 05:43:36","2021-05-10 05:43:36","1");
INSERT INTO audit_trail VALUES("2846","1","Admin Admin","","Logged in to system","2021-05-10 06:02:33","2021-05-10 06:02:33","");
INSERT INTO audit_trail VALUES("2847","1","Admin Admin","","Added user with id:5","2021-05-10 06:04:47","2021-05-10 06:04:47","1");
INSERT INTO audit_trail VALUES("2848","1","Admin Admin","","Added borrower  with id:628","2021-05-10 06:27:42","2021-05-10 06:27:42","1");
INSERT INTO audit_trail VALUES("2849","1","Admin Admin","","Logged in to system","2021-05-10 06:27:51","2021-05-10 06:27:51","");
INSERT INTO audit_trail VALUES("2850","1","Admin Admin","","Added loan with id:195","2021-05-10 07:01:47","2021-05-10 07:01:47","1");
INSERT INTO audit_trail VALUES("2851","1","Admin Admin","","Approved loan with id:195","2021-05-10 07:03:44","2021-05-10 07:03:44","1");
INSERT INTO audit_trail VALUES("2852","1","Admin Admin","","Disbursed loan with id:195","2021-05-10 07:06:26","2021-05-10 07:06:26","1");
INSERT INTO audit_trail VALUES("2853","1","Admin Admin","","Logged in to system","2021-05-10 07:11:43","2021-05-10 07:11:43","");
INSERT INTO audit_trail VALUES("2854","1","Admin Admin","","Logged in to system","2021-05-10 07:30:05","2021-05-10 07:30:05","");
INSERT INTO audit_trail VALUES("2855","1","Admin Admin","","Logged in to system","2021-05-10 07:30:15","2021-05-10 07:30:15","1");
INSERT INTO audit_trail VALUES("2856","1","Admin Admin","","Added Journal Manual Entry  with id:16081","2021-05-10 07:46:17","2021-05-10 07:46:17","1");
INSERT INTO audit_trail VALUES("2857","1","Admin Admin","","Logged out of system","2021-05-10 08:29:01","2021-05-10 08:29:01","1");
INSERT INTO audit_trail VALUES("2858","5","HILDA WAIGWE","","Logged in to system","2021-05-10 08:29:27","2021-05-10 08:29:27","1");
INSERT INTO audit_trail VALUES("2859","1","Admin Admin","","Logged in to system","2021-05-10 08:42:05","2021-05-10 08:42:05","1");
INSERT INTO audit_trail VALUES("2860","1","Admin Admin","","Logged in to system","2021-05-10 08:50:50","2021-05-10 08:50:50","");
INSERT INTO audit_trail VALUES("2861","1","Admin Admin","","Added Journal Manual Entry  with id:16090","2021-05-10 08:53:45","2021-05-10 08:53:45","1");
INSERT INTO audit_trail VALUES("2862","1","Admin Admin","","Added expense with id:205","2021-05-10 09:24:25","2021-05-10 09:24:25","1");
INSERT INTO audit_trail VALUES("2863","1","Admin Admin","","Logged out of system","2021-05-10 09:29:39","2021-05-10 09:29:39","1");
INSERT INTO audit_trail VALUES("2864","5","HILDA WAIGWE","","Added expense with id:206","2021-05-10 10:03:00","2021-05-10 10:03:00","1");
INSERT INTO audit_trail VALUES("2865","5","HILDA WAIGWE","","Added expense with id:207","2021-05-10 10:07:10","2021-05-10 10:07:10","1");
INSERT INTO audit_trail VALUES("2866","5","HILDA WAIGWE","","Added Capital  with id:335","2021-05-10 10:11:56","2021-05-10 10:11:56","1");
INSERT INTO audit_trail VALUES("2867","5","HILDA WAIGWE","","Added expense with id:208","2021-05-10 10:15:17","2021-05-10 10:15:17","1");
INSERT INTO audit_trail VALUES("2868","5","HILDA WAIGWE","","Logged out of system","2021-05-10 10:40:56","2021-05-10 10:40:56","1");
INSERT INTO audit_trail VALUES("2869","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-10 10:49:01","2021-05-10 10:49:01","1");
INSERT INTO audit_trail VALUES("2870","1","Admin Admin","","Logged in to system","2021-05-11 01:17:03","2021-05-11 01:17:03","1");
INSERT INTO audit_trail VALUES("2871","1","Admin Admin","","Added Capital  with id:336","2021-05-11 01:18:38","2021-05-11 01:18:38","1");
INSERT INTO audit_trail VALUES("2872","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-11 02:42:26","2021-05-11 02:42:26","1");
INSERT INTO audit_trail VALUES("2873","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-11 02:54:33","2021-05-11 02:54:33","1");
INSERT INTO audit_trail VALUES("2874","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-11 02:54:42","2021-05-11 02:54:42","1");
INSERT INTO audit_trail VALUES("2875","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-11 02:54:42","2021-05-11 02:54:42","1");
INSERT INTO audit_trail VALUES("2876","1","Admin Admin","","Logged in to system","2021-05-11 03:56:34","2021-05-11 03:56:34","1");
INSERT INTO audit_trail VALUES("2877","3","BERNICE  MUTHONI MUTUGI","","Logged in to system","2021-05-11 04:02:01","2021-05-11 04:02:01","");
INSERT INTO audit_trail VALUES("2878","3","BERNICE  MUTHONI MUTUGI","","Logged out of system","2021-05-11 04:11:24","2021-05-11 04:11:24","1");
INSERT INTO audit_trail VALUES("2879","1","Admin Admin","","Logged in to system","2021-05-11 05:39:50","2021-05-11 05:39:50","");
INSERT INTO audit_trail VALUES("2880","1","Admin Admin","","Updated user with id:3","2021-05-11 05:43:10","2021-05-11 05:43:10","1");
INSERT INTO audit_trail VALUES("2881","1","Admin Admin","","Logged in to system","2021-05-11 05:51:52","2021-05-11 05:51:52","");
INSERT INTO audit_trail VALUES("2882","1","Admin Admin","","Logged out of system","2021-05-11 06:03:14","2021-05-11 06:03:14","1");
INSERT INTO audit_trail VALUES("2883","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-11 06:05:46","2021-05-11 06:05:46","");
INSERT INTO audit_trail VALUES("2884","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-05-11 06:06:36","2021-05-11 06:06:36","1");
INSERT INTO audit_trail VALUES("2885","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-11 06:07:15","2021-05-11 06:07:15","1");
INSERT INTO audit_trail VALUES("2886","1","Admin Admin","","Logged in to system","2021-05-11 06:14:21","2021-05-11 06:14:21","");
INSERT INTO audit_trail VALUES("2887","1","Admin Admin","","Updated role with id:3","2021-05-11 06:16:50","2021-05-11 06:16:50","1");
INSERT INTO audit_trail VALUES("2888","1","Admin Admin","","Updated role with id:4","2021-05-11 06:17:34","2021-05-11 06:17:34","1");
INSERT INTO audit_trail VALUES("2889","4","PERIS  NYAMBURA MWANGI","","Added borrower  with id:629","2021-05-11 06:34:12","2021-05-11 06:34:12","1");
INSERT INTO audit_trail VALUES("2890","4","PERIS  NYAMBURA MWANGI","","Added borrower  with id:630","2021-05-11 06:56:54","2021-05-11 06:56:54","1");
INSERT INTO audit_trail VALUES("2891","4","PERIS  NYAMBURA MWANGI","","Added borrower  with id:631","2021-05-11 06:56:57","2021-05-11 06:56:57","1");
INSERT INTO audit_trail VALUES("2892","1","Admin Admin","","Deleted borrower  with id:631","2021-05-11 06:57:51","2021-05-11 06:57:51","1");
INSERT INTO audit_trail VALUES("2893","4","PERIS  NYAMBURA MWANGI","","Added loan with id:196","2021-05-11 07:13:53","2021-05-11 07:13:53","1");
INSERT INTO audit_trail VALUES("2894","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:196","2021-05-11 07:14:50","2021-05-11 07:14:50","1");
INSERT INTO audit_trail VALUES("2895","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:196","2021-05-11 07:16:32","2021-05-11 07:16:32","1");
INSERT INTO audit_trail VALUES("2896","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-11 07:20:26","2021-05-11 07:20:26","");
INSERT INTO audit_trail VALUES("2897","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-11 07:26:26","2021-05-11 07:26:26","");
INSERT INTO audit_trail VALUES("2898","1","Admin Admin","","Logged in to system","2021-05-11 08:52:36","2021-05-11 08:52:36","1");
INSERT INTO audit_trail VALUES("2899","1","Admin Admin","","Added Capital  with id:337","2021-05-11 08:53:50","2021-05-11 08:53:50","1");
INSERT INTO audit_trail VALUES("2900","1","Admin Admin","","Added Capital  with id:338","2021-05-11 08:54:34","2021-05-11 08:54:34","1");
INSERT INTO audit_trail VALUES("2901","1","Admin Admin","","Added expense with id:209","2021-05-11 09:50:04","2021-05-11 09:50:04","1");
INSERT INTO audit_trail VALUES("2902","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16240","2021-05-11 09:53:53","2021-05-11 09:53:53","1");
INSERT INTO audit_trail VALUES("2903","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-05-11 10:13:32","2021-05-11 10:13:32","1");
INSERT INTO audit_trail VALUES("2904","1","Admin Admin","","Added expense with id:210","2021-05-11 10:16:30","2021-05-11 10:16:30","1");
INSERT INTO audit_trail VALUES("2905","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-11 10:21:06","2021-05-11 10:21:06","1");
INSERT INTO audit_trail VALUES("2906","1","Admin Admin","","Logged out of system","2021-05-11 10:21:29","2021-05-11 10:21:29","1");
INSERT INTO audit_trail VALUES("2907","1","Admin Admin","","Logged in to system","2021-05-12 01:25:28","2021-05-12 01:25:28","1");
INSERT INTO audit_trail VALUES("2908","1","Admin Admin","","Added Capital  with id:339","2021-05-12 01:27:06","2021-05-12 01:27:06","1");
INSERT INTO audit_trail VALUES("2909","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-12 02:29:00","2021-05-12 02:29:00","1");
INSERT INTO audit_trail VALUES("2910","1","Admin Admin","","Added Capital  with id:340","2021-05-12 05:00:05","2021-05-12 05:00:05","1");
INSERT INTO audit_trail VALUES("2911","1","Admin Admin","","Added Capital  with id:341","2021-05-12 05:01:08","2021-05-12 05:01:08","1");
INSERT INTO audit_trail VALUES("2912","1","Admin Admin","","Added expense with id:211","2021-05-12 05:23:40","2021-05-12 05:23:40","1");
INSERT INTO audit_trail VALUES("2913","5","HILDA WAIGWE","","Logged in to system","2021-05-12 06:49:02","2021-05-12 06:49:02","");
INSERT INTO audit_trail VALUES("2914","5","HILDA WAIGWE","","Added loan with id:197","2021-05-12 06:50:25","2021-05-12 06:50:25","1");
INSERT INTO audit_trail VALUES("2915","2","CECILIA WANJERI WANGUHU","","Added loan with id:198","2021-05-12 06:51:55","2021-05-12 06:51:55","1");
INSERT INTO audit_trail VALUES("2916","2","CECILIA WANJERI WANGUHU","","Approved loan with id:198","2021-05-12 06:55:35","2021-05-12 06:55:35","1");
INSERT INTO audit_trail VALUES("2917","1","Admin Admin","","Logged out of system","2021-05-12 06:56:37","2021-05-12 06:56:37","1");
INSERT INTO audit_trail VALUES("2918","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:198","2021-05-12 06:56:52","2021-05-12 06:56:52","1");
INSERT INTO audit_trail VALUES("2919","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-12 06:57:22","2021-05-12 06:57:22","1");
INSERT INTO audit_trail VALUES("2920","5","HILDA WAIGWE","","Approved loan with id:197","2021-05-12 06:57:57","2021-05-12 06:57:57","1");
INSERT INTO audit_trail VALUES("2921","5","HILDA WAIGWE","","Disbursed loan with id:197","2021-05-12 06:58:42","2021-05-12 06:58:42","1");
INSERT INTO audit_trail VALUES("2922","4","PERIS  NYAMBURA MWANGI","","Added loan with id:199","2021-05-12 07:02:02","2021-05-12 07:02:02","1");
INSERT INTO audit_trail VALUES("2923","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:199","2021-05-12 07:05:36","2021-05-12 07:05:36","1");
INSERT INTO audit_trail VALUES("2924","2","CECILIA WANJERI WANGUHU","","Deleted loan with id:198","2021-05-12 07:06:15","2021-05-12 07:06:15","1");
INSERT INTO audit_trail VALUES("2925","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:199","2021-05-12 07:07:37","2021-05-12 07:07:37","1");
INSERT INTO audit_trail VALUES("2926","5","HILDA WAIGWE","","Undisbursed loan with id:197","2021-05-12 07:09:23","2021-05-12 07:09:23","1");
INSERT INTO audit_trail VALUES("2927","5","HILDA WAIGWE","","Unapproved loan with id:197","2021-05-12 07:09:33","2021-05-12 07:09:33","1");
INSERT INTO audit_trail VALUES("2928","5","HILDA WAIGWE","","Updated loan with id:197","2021-05-12 07:09:49","2021-05-12 07:09:49","1");
INSERT INTO audit_trail VALUES("2929","2","CECILIA WANJERI WANGUHU","","Added loan with id:200","2021-05-12 07:09:50","2021-05-12 07:09:50","1");
INSERT INTO audit_trail VALUES("2930","5","HILDA WAIGWE","","Approved loan with id:197","2021-05-12 07:10:30","2021-05-12 07:10:30","1");
INSERT INTO audit_trail VALUES("2931","2","CECILIA WANJERI WANGUHU","","Approved loan with id:200","2021-05-12 07:11:33","2021-05-12 07:11:33","1");
INSERT INTO audit_trail VALUES("2932","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:200","2021-05-12 07:11:53","2021-05-12 07:11:53","1");
INSERT INTO audit_trail VALUES("2933","4","PERIS  NYAMBURA MWANGI","","Undisbursed loan with id:199","2021-05-12 07:11:57","2021-05-12 07:11:57","1");
INSERT INTO audit_trail VALUES("2934","4","PERIS  NYAMBURA MWANGI","","Unapproved loan with id:199","2021-05-12 07:12:20","2021-05-12 07:12:20","1");
INSERT INTO audit_trail VALUES("2935","5","HILDA WAIGWE","","Disbursed loan with id:197","2021-05-12 07:13:31","2021-05-12 07:13:31","1");
INSERT INTO audit_trail VALUES("2936","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:199","2021-05-12 07:13:48","2021-05-12 07:13:48","1");
INSERT INTO audit_trail VALUES("2937","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:199","2021-05-12 07:14:22","2021-05-12 07:14:22","1");
INSERT INTO audit_trail VALUES("2938","5","HILDA WAIGWE","","Undisbursed loan with id:197","2021-05-12 07:21:47","2021-05-12 07:21:47","1");
INSERT INTO audit_trail VALUES("2939","5","HILDA WAIGWE","","Unapproved loan with id:197","2021-05-12 07:21:55","2021-05-12 07:21:55","1");
INSERT INTO audit_trail VALUES("2940","5","HILDA WAIGWE","","Approved loan with id:197","2021-05-12 07:22:14","2021-05-12 07:22:14","1");
INSERT INTO audit_trail VALUES("2941","5","HILDA WAIGWE","","Disbursed loan with id:197","2021-05-12 07:22:51","2021-05-12 07:22:51","1");
INSERT INTO audit_trail VALUES("2942","4","PERIS  NYAMBURA MWANGI","","Undisbursed loan with id:199","2021-05-12 07:24:05","2021-05-12 07:24:05","1");
INSERT INTO audit_trail VALUES("2943","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:199","2021-05-12 07:24:30","2021-05-12 07:24:30","1");
INSERT INTO audit_trail VALUES("2944","4","PERIS  NYAMBURA MWANGI","","Undisbursed loan with id:199","2021-05-12 07:24:46","2021-05-12 07:24:46","1");
INSERT INTO audit_trail VALUES("2945","4","PERIS  NYAMBURA MWANGI","","Unapproved loan with id:199","2021-05-12 07:28:03","2021-05-12 07:28:03","1");
INSERT INTO audit_trail VALUES("2946","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:199","2021-05-12 07:28:28","2021-05-12 07:28:28","1");
INSERT INTO audit_trail VALUES("2947","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:199","2021-05-12 07:29:51","2021-05-12 07:29:51","1");
INSERT INTO audit_trail VALUES("2948","5","HILDA WAIGWE","","Undisbursed loan with id:197","2021-05-12 07:30:02","2021-05-12 07:30:02","1");
INSERT INTO audit_trail VALUES("2949","5","HILDA WAIGWE","","Unapproved loan with id:197","2021-05-12 07:30:10","2021-05-12 07:30:10","1");
INSERT INTO audit_trail VALUES("2950","5","HILDA WAIGWE","","Approved loan with id:197","2021-05-12 07:30:19","2021-05-12 07:30:19","1");
INSERT INTO audit_trail VALUES("2951","5","HILDA WAIGWE","","Disbursed loan with id:197","2021-05-12 07:30:31","2021-05-12 07:30:31","1");
INSERT INTO audit_trail VALUES("2952","4","PERIS  NYAMBURA MWANGI","","Undisbursed loan with id:199","2021-05-12 07:30:40","2021-05-12 07:30:40","1");
INSERT INTO audit_trail VALUES("2953","4","PERIS  NYAMBURA MWANGI","","Unapproved loan with id:199","2021-05-12 07:30:58","2021-05-12 07:30:58","1");
INSERT INTO audit_trail VALUES("2954","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:199","2021-05-12 07:31:34","2021-05-12 07:31:34","1");
INSERT INTO audit_trail VALUES("2955","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:199","2021-05-12 07:31:55","2021-05-12 07:31:55","1");
INSERT INTO audit_trail VALUES("2956","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:16290","2021-05-12 07:33:13","2021-05-12 07:33:13","1");
INSERT INTO audit_trail VALUES("2957","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-05-12 07:42:41","2021-05-12 07:42:41","1");
INSERT INTO audit_trail VALUES("2958","1","Admin Admin","","Logged in to system","2021-05-12 07:43:21","2021-05-12 07:43:21","1");
INSERT INTO audit_trail VALUES("2959","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16299","2021-05-12 07:45:52","2021-05-12 07:45:52","1");
INSERT INTO audit_trail VALUES("2960","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16302","2021-05-12 07:48:49","2021-05-12 07:48:49","1");
INSERT INTO audit_trail VALUES("2961","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16307","2021-05-12 07:49:20","2021-05-12 07:49:20","1");
INSERT INTO audit_trail VALUES("2962","1","Admin Admin","","Updated role with id:4","2021-05-12 07:50:34","2021-05-12 07:50:34","1");
INSERT INTO audit_trail VALUES("2963","1","Admin Admin","","Logged out of system","2021-05-12 07:51:20","2021-05-12 07:51:20","1");
INSERT INTO audit_trail VALUES("2964","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16310","2021-05-12 07:53:54","2021-05-12 07:53:54","1");
INSERT INTO audit_trail VALUES("2965","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-12 07:54:33","2021-05-12 07:54:33","1");
INSERT INTO audit_trail VALUES("2966","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16312","2021-05-12 07:56:17","2021-05-12 07:56:17","1");
INSERT INTO audit_trail VALUES("2967","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16314","2021-05-12 08:03:51","2021-05-12 08:03:51","1");
INSERT INTO audit_trail VALUES("2968","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16316","2021-05-12 08:05:15","2021-05-12 08:05:15","1");
INSERT INTO audit_trail VALUES("2969","5","HILDA WAIGWE","","Added repayment for loan with id:197","2021-05-12 08:27:06","2021-05-12 08:27:06","1");
INSERT INTO audit_trail VALUES("2970","5","HILDA WAIGWE","","Added repayment for loan with id:197","2021-05-12 08:29:16","2021-05-12 08:29:16","1");
INSERT INTO audit_trail VALUES("2971","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16328","2021-05-12 08:30:03","2021-05-12 08:30:03","1");
INSERT INTO audit_trail VALUES("2972","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:16338","2021-05-12 08:34:54","2021-05-12 08:34:54","1");
INSERT INTO audit_trail VALUES("2973","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16340","2021-05-12 08:35:28","2021-05-12 08:35:28","1");
INSERT INTO audit_trail VALUES("2974","5","HILDA WAIGWE","","Logged in to system","2021-05-12 08:49:20","2021-05-12 08:49:20","");
INSERT INTO audit_trail VALUES("2975","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16348","2021-05-12 09:01:33","2021-05-12 09:01:33","1");
INSERT INTO audit_trail VALUES("2976","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:16350","2021-05-12 09:01:40","2021-05-12 09:01:40","1");
INSERT INTO audit_trail VALUES("2977","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16352","2021-05-12 09:01:51","2021-05-12 09:01:51","1");
INSERT INTO audit_trail VALUES("2978","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16355","2021-05-12 09:04:55","2021-05-12 09:04:55","1");
INSERT INTO audit_trail VALUES("2979","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16358","2021-05-12 09:06:39","2021-05-12 09:06:39","1");
INSERT INTO audit_trail VALUES("2980","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:16368","2021-05-12 09:12:52","2021-05-12 09:12:52","1");
INSERT INTO audit_trail VALUES("2981","4","PERIS  NYAMBURA MWANGI","","Added loan with id:201","2021-05-12 09:40:47","2021-05-12 09:40:47","1");
INSERT INTO audit_trail VALUES("2982","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:201","2021-05-12 09:41:22","2021-05-12 09:41:22","1");
INSERT INTO audit_trail VALUES("2983","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:201","2021-05-12 09:41:48","2021-05-12 09:41:48","1");
INSERT INTO audit_trail VALUES("2984","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16433","2021-05-12 09:46:19","2021-05-12 09:46:19","1");
INSERT INTO audit_trail VALUES("2985","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16439","2021-05-12 09:55:32","2021-05-12 09:55:32","1");
INSERT INTO audit_trail VALUES("2986","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:342","2021-05-12 09:59:23","2021-05-12 09:59:23","1");
INSERT INTO audit_trail VALUES("2987","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:343","2021-05-12 10:00:43","2021-05-12 10:00:43","1");
INSERT INTO audit_trail VALUES("2988","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16445","2021-05-12 10:01:43","2021-05-12 10:01:43","1");
INSERT INTO audit_trail VALUES("2989","2","CECILIA WANJERI WANGUHU","","Added expense with id:212","2021-05-12 10:23:43","2021-05-12 10:23:43","1");
INSERT INTO audit_trail VALUES("2990","2","CECILIA WANJERI WANGUHU","","Added expense with id:213","2021-05-12 10:27:20","2021-05-12 10:27:20","1");
INSERT INTO audit_trail VALUES("2991","2","CECILIA WANJERI WANGUHU","","Added expense with id:214","2021-05-12 10:53:48","2021-05-12 10:53:48","1");
INSERT INTO audit_trail VALUES("2992","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-12 11:02:38","2021-05-12 11:02:38","1");
INSERT INTO audit_trail VALUES("2993","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:344","2021-05-13 01:46:00","2021-05-13 01:46:00","1");
INSERT INTO audit_trail VALUES("2994","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-13 03:20:38","2021-05-13 03:20:38","1");
INSERT INTO audit_trail VALUES("2995","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-13 03:21:13","2021-05-13 03:21:13","1");
INSERT INTO audit_trail VALUES("2996","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16476","2021-05-13 03:47:02","2021-05-13 03:47:02","1");
INSERT INTO audit_trail VALUES("2997","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16487","2021-05-13 04:15:01","2021-05-13 04:15:01","1");
INSERT INTO audit_trail VALUES("2998","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16490","2021-05-13 04:40:45","2021-05-13 04:40:45","1");
INSERT INTO audit_trail VALUES("2999","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16492","2021-05-13 05:05:21","2021-05-13 05:05:21","1");
INSERT INTO audit_trail VALUES("3000","4","PERIS  NYAMBURA MWANGI","","Added loan with id:202","2021-05-13 05:26:41","2021-05-13 05:26:41","1");
INSERT INTO audit_trail VALUES("3001","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:202","2021-05-13 05:27:15","2021-05-13 05:27:15","1");
INSERT INTO audit_trail VALUES("3002","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:202","2021-05-13 05:29:03","2021-05-13 05:29:03","1");
INSERT INTO audit_trail VALUES("3003","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16504","2021-05-13 05:34:53","2021-05-13 05:34:53","1");
INSERT INTO audit_trail VALUES("3004","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16506","2021-05-13 05:35:57","2021-05-13 05:35:57","1");
INSERT INTO audit_trail VALUES("3005","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16515","2021-05-13 05:46:32","2021-05-13 05:46:32","1");
INSERT INTO audit_trail VALUES("3006","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16524","2021-05-13 05:53:12","2021-05-13 05:53:12","1");
INSERT INTO audit_trail VALUES("3007","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16540","2021-05-13 06:56:20","2021-05-13 06:56:20","1");
INSERT INTO audit_trail VALUES("3008","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16549","2021-05-13 07:03:30","2021-05-13 07:03:30","1");
INSERT INTO audit_trail VALUES("3009","1","Admin Admin","","Logged in to system","2021-05-13 07:48:05","2021-05-13 07:48:05","");
INSERT INTO audit_trail VALUES("3010","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:16573","2021-05-13 08:23:47","2021-05-13 08:23:47","1");
INSERT INTO audit_trail VALUES("3011","1","Admin Admin","","Logged out of system","2021-05-13 08:40:02","2021-05-13 08:40:02","1");
INSERT INTO audit_trail VALUES("3012","2","CECILIA WANJERI WANGUHU","","Added expense with id:215","2021-05-13 09:44:19","2021-05-13 09:44:19","1");
INSERT INTO audit_trail VALUES("3013","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-05-13 09:44:48","2021-05-13 09:44:48","1");
INSERT INTO audit_trail VALUES("3014","2","CECILIA WANJERI WANGUHU","","Added expense with id:216","2021-05-13 09:45:32","2021-05-13 09:45:32","1");
INSERT INTO audit_trail VALUES("3015","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-13 09:58:30","2021-05-13 09:58:30","1");
INSERT INTO audit_trail VALUES("3016","2","CECILIA WANJERI WANGUHU","","Added expense with id:217","2021-05-13 09:58:49","2021-05-13 09:58:49","1");
INSERT INTO audit_trail VALUES("3017","2","CECILIA WANJERI WANGUHU","","Added expense with id:218","2021-05-13 10:00:42","2021-05-13 10:00:42","1");
INSERT INTO audit_trail VALUES("3018","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-13 10:14:52","2021-05-13 10:14:52","1");
INSERT INTO audit_trail VALUES("3019","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-13 10:20:35","2021-05-13 10:20:35","1");
INSERT INTO audit_trail VALUES("3020","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:345","2021-05-13 10:22:08","2021-05-13 10:22:08","1");
INSERT INTO audit_trail VALUES("3021","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-13 10:22:45","2021-05-13 10:22:45","1");
INSERT INTO audit_trail VALUES("3022","5","HILDA WAIGWE","","Logged in to system","2021-05-15 00:56:07","2021-05-15 00:56:07","");
INSERT INTO audit_trail VALUES("3023","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-15 01:04:02","2021-05-15 01:04:02","");
INSERT INTO audit_trail VALUES("3024","5","HILDA WAIGWE","","Added Capital  with id:346","2021-05-15 01:11:30","2021-05-15 01:11:30","1");
INSERT INTO audit_trail VALUES("3025","5","HILDA WAIGWE","","Logged out of system","2021-05-15 01:33:05","2021-05-15 01:33:05","1");
INSERT INTO audit_trail VALUES("3026","5","HILDA WAIGWE","","Logged in to system","2021-05-15 01:33:36","2021-05-15 01:33:36","1");
INSERT INTO audit_trail VALUES("3027","5","HILDA WAIGWE","","Logged out of system","2021-05-15 02:40:08","2021-05-15 02:40:08","1");
INSERT INTO audit_trail VALUES("3028","5","HILDA WAIGWE","","Logged in to system","2021-05-15 02:53:37","2021-05-15 02:53:37","1");
INSERT INTO audit_trail VALUES("3029","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:16662","2021-05-15 04:15:51","2021-05-15 04:15:51","1");
INSERT INTO audit_trail VALUES("3030","5","HILDA WAIGWE","","Logged out of system","2021-05-15 04:45:01","2021-05-15 04:45:01","1");
INSERT INTO audit_trail VALUES("3031","1","Admin Admin","","Logged in to system","2021-05-15 04:45:15","2021-05-15 04:45:15","1");
INSERT INTO audit_trail VALUES("3032","1","Admin Admin","","Deleted loan with id:202","2021-05-15 04:46:26","2021-05-15 04:46:26","1");
INSERT INTO audit_trail VALUES("3033","1","Admin Admin","","Deleted loan with id:197","2021-05-15 04:47:49","2021-05-15 04:47:49","1");
INSERT INTO audit_trail VALUES("3034","1","Admin Admin","","Deleted loan with id:196","2021-05-15 05:01:42","2021-05-15 05:01:42","1");
INSERT INTO audit_trail VALUES("3035","1","Admin Admin","","Deleted loan with id:199","2021-05-15 05:02:09","2021-05-15 05:02:09","1");
INSERT INTO audit_trail VALUES("3036","1","Admin Admin","","Deleted loan with id:200","2021-05-15 05:02:32","2021-05-15 05:02:32","1");
INSERT INTO audit_trail VALUES("3037","1","Admin Admin","","Deleted loan with id:201","2021-05-15 05:02:47","2021-05-15 05:02:47","1");
INSERT INTO audit_trail VALUES("3038","1","Admin Admin","","Logged out of system","2021-05-15 05:11:39","2021-05-15 05:11:39","1");
INSERT INTO audit_trail VALUES("3039","5","HILDA WAIGWE","","Logged in to system","2021-05-15 05:22:09","2021-05-15 05:22:09","1");
INSERT INTO audit_trail VALUES("3040","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-15 06:44:29","2021-05-15 06:44:29","");
INSERT INTO audit_trail VALUES("3041","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-15 06:44:30","2021-05-15 06:44:30","");
INSERT INTO audit_trail VALUES("3042","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-15 06:44:32","2021-05-15 06:44:32","");
INSERT INTO audit_trail VALUES("3043","1","Admin Admin","","Logged in to system","2021-05-15 15:05:00","2021-05-15 15:05:00","");
INSERT INTO audit_trail VALUES("3044","5","HILDA WAIGWE","","Logged in to system","2021-05-17 01:00:18","2021-05-17 01:00:18","");
INSERT INTO audit_trail VALUES("3045","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-17 01:34:13","2021-05-17 01:34:13","");
INSERT INTO audit_trail VALUES("3046","5","HILDA WAIGWE","","Logged in to system","2021-05-17 01:51:48","2021-05-17 01:51:48","");
INSERT INTO audit_trail VALUES("3047","5","HILDA WAIGWE","","Added Capital  with id:347","2021-05-17 02:36:40","2021-05-17 02:36:40","1");
INSERT INTO audit_trail VALUES("3048","5","HILDA WAIGWE","","Logged in to system","2021-05-17 03:00:41","2021-05-17 03:00:41","1");
INSERT INTO audit_trail VALUES("3049","1","Admin Admin","","Logged in to system","2021-05-17 03:27:56","2021-05-17 03:27:56","");
INSERT INTO audit_trail VALUES("3050","5","HILDA WAIGWE","","Added expense with id:219","2021-05-17 03:54:42","2021-05-17 03:54:42","1");
INSERT INTO audit_trail VALUES("3051","5","HILDA WAIGWE","","Added expense with id:220","2021-05-17 03:55:29","2021-05-17 03:55:29","1");
INSERT INTO audit_trail VALUES("3052","5","HILDA WAIGWE","","Added Capital  with id:348","2021-05-17 04:08:24","2021-05-17 04:08:24","1");
INSERT INTO audit_trail VALUES("3053","5","HILDA WAIGWE","","Added Capital  with id:349","2021-05-17 04:10:59","2021-05-17 04:10:59","1");
INSERT INTO audit_trail VALUES("3054","5","HILDA WAIGWE","","Added Capital  with id:350","2021-05-17 04:14:06","2021-05-17 04:14:06","1");
INSERT INTO audit_trail VALUES("3055","5","HILDA WAIGWE","","Added loan with id:203","2021-05-17 04:16:14","2021-05-17 04:16:14","1");
INSERT INTO audit_trail VALUES("3056","5","HILDA WAIGWE","","Approved loan with id:203","2021-05-17 04:16:56","2021-05-17 04:16:56","1");
INSERT INTO audit_trail VALUES("3057","5","HILDA WAIGWE","","Disbursed loan with id:203","2021-05-17 04:18:43","2021-05-17 04:18:43","1");
INSERT INTO audit_trail VALUES("3058","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16742","2021-05-17 04:31:25","2021-05-17 04:31:25","1");
INSERT INTO audit_trail VALUES("3059","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16744","2021-05-17 04:32:36","2021-05-17 04:32:36","1");
INSERT INTO audit_trail VALUES("3060","5","HILDA WAIGWE","","Deleted loan with id:203","2021-05-17 05:04:28","2021-05-17 05:04:28","1");
INSERT INTO audit_trail VALUES("3061","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16775","2021-05-17 05:45:50","2021-05-17 05:45:50","1");
INSERT INTO audit_trail VALUES("3062","5","HILDA WAIGWE","","Added Capital  with id:351","2021-05-17 06:11:27","2021-05-17 06:11:27","1");
INSERT INTO audit_trail VALUES("3063","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16779","2021-05-17 06:19:18","2021-05-17 06:19:18","1");
INSERT INTO audit_trail VALUES("3064","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:16803","2021-05-17 08:27:40","2021-05-17 08:27:40","1");
INSERT INTO audit_trail VALUES("3065","5","HILDA WAIGWE","","Added Capital  with id:352","2021-05-17 08:32:33","2021-05-17 08:32:33","1");
INSERT INTO audit_trail VALUES("3066","5","HILDA WAIGWE","","Added Capital  with id:353","2021-05-17 08:33:31","2021-05-17 08:33:31","1");
INSERT INTO audit_trail VALUES("3067","5","HILDA WAIGWE","","Added expense with id:221","2021-05-17 08:35:14","2021-05-17 08:35:14","1");
INSERT INTO audit_trail VALUES("3068","5","HILDA WAIGWE","","Added expense with id:222","2021-05-17 08:36:55","2021-05-17 08:36:55","1");
INSERT INTO audit_trail VALUES("3069","2","CECILIA WANJERI WANGUHU","","Added loan product with id:5","2021-05-17 11:01:45","2021-05-17 11:01:45","1");
INSERT INTO audit_trail VALUES("3070","2","CECILIA WANJERI WANGUHU","","Added loan with id:204","2021-05-17 11:03:07","2021-05-17 11:03:07","1");
INSERT INTO audit_trail VALUES("3071","5","HILDA WAIGWE","","Approved loan with id:204","2021-05-17 11:04:29","2021-05-17 11:04:29","1");
INSERT INTO audit_trail VALUES("3072","5","HILDA WAIGWE","","Disbursed loan with id:204","2021-05-17 11:05:35","2021-05-17 11:05:35","1");
INSERT INTO audit_trail VALUES("3073","1","Admin Admin","","Logged in to system","2021-05-17 11:18:58","2021-05-17 11:18:58","");
INSERT INTO audit_trail VALUES("3074","5","HILDA WAIGWE","","Updated expense with id:221","2021-05-17 11:21:44","2021-05-17 11:21:44","1");
INSERT INTO audit_trail VALUES("3075","5","HILDA WAIGWE","","Updated expense with id:222","2021-05-17 11:22:15","2021-05-17 11:22:15","1");
INSERT INTO audit_trail VALUES("3076","5","HILDA WAIGWE","","Updated expense with id:220","2021-05-17 11:23:24","2021-05-17 11:23:24","1");
INSERT INTO audit_trail VALUES("3077","5","HILDA WAIGWE","","Updated expense with id:221","2021-05-17 11:24:39","2021-05-17 11:24:39","1");
INSERT INTO audit_trail VALUES("3078","1","Admin Admin","","Updated expense with id:222","2021-05-17 11:25:17","2021-05-17 11:25:17","1");
INSERT INTO audit_trail VALUES("3079","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-17 11:53:00","2021-05-17 11:53:00","1");
INSERT INTO audit_trail VALUES("3080","5","HILDA WAIGWE","","Logged out of system","2021-05-17 11:56:02","2021-05-17 11:56:02","1");
INSERT INTO audit_trail VALUES("3081","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-18 01:16:17","2021-05-18 01:16:17","1");
INSERT INTO audit_trail VALUES("3082","5","HILDA WAIGWE","","Logged in to system","2021-05-18 01:17:08","2021-05-18 01:17:08","1");
INSERT INTO audit_trail VALUES("3083","5","HILDA WAIGWE","","Added Capital  with id:354","2021-05-18 01:31:07","2021-05-18 01:31:07","1");
INSERT INTO audit_trail VALUES("3084","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-18 05:15:35","2021-05-18 05:15:35","1");
INSERT INTO audit_trail VALUES("3085","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-18 05:23:51","2021-05-18 05:23:51","1");
INSERT INTO audit_trail VALUES("3086","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:16965","2021-05-18 05:32:45","2021-05-18 05:32:45","1");
INSERT INTO audit_trail VALUES("3087","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16969","2021-05-18 05:40:24","2021-05-18 05:40:24","1");
INSERT INTO audit_trail VALUES("3088","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16971","2021-05-18 05:43:11","2021-05-18 05:43:11","1");
INSERT INTO audit_trail VALUES("3089","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:16973","2021-05-18 05:44:16","2021-05-18 05:44:16","1");
INSERT INTO audit_trail VALUES("3090","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17018","2021-05-18 09:22:46","2021-05-18 09:22:46","1");
INSERT INTO audit_trail VALUES("3091","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17020","2021-05-18 09:28:00","2021-05-18 09:28:00","1");
INSERT INTO audit_trail VALUES("3092","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17022","2021-05-18 09:31:16","2021-05-18 09:31:16","1");
INSERT INTO audit_trail VALUES("3093","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17024","2021-05-18 09:34:07","2021-05-18 09:34:07","1");
INSERT INTO audit_trail VALUES("3094","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17026","2021-05-18 09:36:12","2021-05-18 09:36:12","1");
INSERT INTO audit_trail VALUES("3095","5","HILDA WAIGWE","","Added expense with id:223","2021-05-18 09:55:33","2021-05-18 09:55:33","1");
INSERT INTO audit_trail VALUES("3096","5","HILDA WAIGWE","","Added Capital  with id:355","2021-05-18 10:16:20","2021-05-18 10:16:20","1");
INSERT INTO audit_trail VALUES("3097","5","HILDA WAIGWE","","Logged out of system","2021-05-18 10:21:33","2021-05-18 10:21:33","1");
INSERT INTO audit_trail VALUES("3098","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-18 10:22:43","2021-05-18 10:22:43","1");
INSERT INTO audit_trail VALUES("3099","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-19 01:46:21","2021-05-19 01:46:21","");
INSERT INTO audit_trail VALUES("3100","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:356","2021-05-19 01:53:30","2021-05-19 01:53:30","1");
INSERT INTO audit_trail VALUES("3101","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-19 04:21:52","2021-05-19 04:21:52","");
INSERT INTO audit_trail VALUES("3102","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-19 04:45:09","2021-05-19 04:45:09","1");
INSERT INTO audit_trail VALUES("3103","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-19 04:50:39","2021-05-19 04:50:39","1");
INSERT INTO audit_trail VALUES("3104","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:357","2021-05-19 08:17:22","2021-05-19 08:17:22","1");
INSERT INTO audit_trail VALUES("3105","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:358","2021-05-19 08:22:04","2021-05-19 08:22:04","1");
INSERT INTO audit_trail VALUES("3106","4","PERIS  NYAMBURA MWANGI","","Added expense with id:224","2021-05-19 08:24:48","2021-05-19 08:24:48","1");
INSERT INTO audit_trail VALUES("3107","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-19 08:55:02","2021-05-19 08:55:02","1");
INSERT INTO audit_trail VALUES("3108","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17082","2021-05-19 09:29:13","2021-05-19 09:29:13","1");
INSERT INTO audit_trail VALUES("3109","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-19 10:00:06","2021-05-19 10:00:06","1");
INSERT INTO audit_trail VALUES("3110","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-19 10:34:18","2021-05-19 10:34:18","1");
INSERT INTO audit_trail VALUES("3111","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:359","2021-05-20 01:43:41","2021-05-20 01:43:41","1");
INSERT INTO audit_trail VALUES("3112","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-20 02:28:23","2021-05-20 02:28:23","");
INSERT INTO audit_trail VALUES("3113","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-20 02:36:12","2021-05-20 02:36:12","1");
INSERT INTO audit_trail VALUES("3114","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-20 02:46:46","2021-05-20 02:46:46","1");
INSERT INTO audit_trail VALUES("3115","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-20 03:37:39","2021-05-20 03:37:39","1");
INSERT INTO audit_trail VALUES("3116","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-20 03:38:27","2021-05-20 03:38:27","1");
INSERT INTO audit_trail VALUES("3117","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17162","2021-05-20 04:06:25","2021-05-20 04:06:25","1");
INSERT INTO audit_trail VALUES("3118","4","PERIS  NYAMBURA MWANGI","","Added expense with id:225","2021-05-20 04:34:35","2021-05-20 04:34:35","1");
INSERT INTO audit_trail VALUES("3119","1","Admin Admin","","Logged in to system","2021-05-20 09:13:18","2021-05-20 09:13:18","");
INSERT INTO audit_trail VALUES("3120","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17243","2021-05-20 09:24:33","2021-05-20 09:24:33","1");
INSERT INTO audit_trail VALUES("3121","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-05-20 09:34:01","2021-05-20 09:34:01","1");
INSERT INTO audit_trail VALUES("3122","5","HILDA WAIGWE","","Logged in to system","2021-05-20 09:44:10","2021-05-20 09:44:10","1");
INSERT INTO audit_trail VALUES("3123","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-20 10:16:51","2021-05-20 10:16:51","1");
INSERT INTO audit_trail VALUES("3124","5","HILDA WAIGWE","","Logged out of system","2021-05-20 10:17:17","2021-05-20 10:17:17","1");
INSERT INTO audit_trail VALUES("3125","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-05-20 10:17:58","2021-05-20 10:17:58","1");
INSERT INTO audit_trail VALUES("3126","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:360","2021-05-21 01:08:40","2021-05-21 01:08:40","1");
INSERT INTO audit_trail VALUES("3127","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-21 01:17:35","2021-05-21 01:17:35","");
INSERT INTO audit_trail VALUES("3128","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-21 01:34:41","2021-05-21 01:34:41","1");
INSERT INTO audit_trail VALUES("3129","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:17261","2021-05-21 04:08:16","2021-05-21 04:08:16","1");
INSERT INTO audit_trail VALUES("3130","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-21 04:08:33","2021-05-21 04:08:33","1");
INSERT INTO audit_trail VALUES("3131","4","PERIS  NYAMBURA MWANGI","","Added expense with id:226","2021-05-21 07:07:19","2021-05-21 07:07:19","1");
INSERT INTO audit_trail VALUES("3132","4","PERIS  NYAMBURA MWANGI","","Added expense with id:227","2021-05-21 07:13:13","2021-05-21 07:13:13","1");
INSERT INTO audit_trail VALUES("3133","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:361","2021-05-21 07:18:39","2021-05-21 07:18:39","1");
INSERT INTO audit_trail VALUES("3134","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:362","2021-05-21 07:20:03","2021-05-21 07:20:03","1");
INSERT INTO audit_trail VALUES("3135","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:363","2021-05-21 07:22:44","2021-05-21 07:22:44","1");
INSERT INTO audit_trail VALUES("3136","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:364","2021-05-21 07:24:01","2021-05-21 07:24:01","1");
INSERT INTO audit_trail VALUES("3137","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:365","2021-05-21 07:25:26","2021-05-21 07:25:26","1");
INSERT INTO audit_trail VALUES("3138","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17306","2021-05-21 08:08:49","2021-05-21 08:08:49","1");
INSERT INTO audit_trail VALUES("3139","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17308","2021-05-21 08:18:00","2021-05-21 08:18:00","1");
INSERT INTO audit_trail VALUES("3140","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17310","2021-05-21 08:34:03","2021-05-21 08:34:03","1");
INSERT INTO audit_trail VALUES("3141","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17312","2021-05-21 08:36:46","2021-05-21 08:36:46","1");
INSERT INTO audit_trail VALUES("3142","1","Admin Admin","","Logged in to system","2021-05-21 08:52:21","2021-05-21 08:52:21","");
INSERT INTO audit_trail VALUES("3143","4","PERIS  NYAMBURA MWANGI","","Added expense with id:228","2021-05-21 09:08:56","2021-05-21 09:08:56","1");
INSERT INTO audit_trail VALUES("3144","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17350","2021-05-21 10:17:36","2021-05-21 10:17:36","1");
INSERT INTO audit_trail VALUES("3145","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17352","2021-05-21 10:32:29","2021-05-21 10:32:29","1");
INSERT INTO audit_trail VALUES("3146","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17354","2021-05-21 10:34:06","2021-05-21 10:34:06","1");
INSERT INTO audit_trail VALUES("3147","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:17356","2021-05-21 10:35:54","2021-05-21 10:35:54","1");
INSERT INTO audit_trail VALUES("3148","4","PERIS  NYAMBURA MWANGI","","Updated expense with id:226","2021-05-21 10:37:44","2021-05-21 10:37:44","1");
INSERT INTO audit_trail VALUES("3149","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-05-21 10:50:00","2021-05-21 10:50:00","1");
INSERT INTO audit_trail VALUES("3150","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-21 10:54:07","2021-05-21 10:54:07","1");
INSERT INTO audit_trail VALUES("3151","5","HILDA WAIGWE","","Logged in to system","2021-05-22 01:04:26","2021-05-22 01:04:26","1");
INSERT INTO audit_trail VALUES("3152","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-22 01:17:36","2021-05-22 01:17:36","1");
INSERT INTO audit_trail VALUES("3153","5","HILDA WAIGWE","","Added Capital  with id:366","2021-05-22 01:18:44","2021-05-22 01:18:44","1");
INSERT INTO audit_trail VALUES("3154","5","HILDA WAIGWE","","Added expense with id:229","2021-05-22 01:20:11","2021-05-22 01:20:11","1");
INSERT INTO audit_trail VALUES("3155","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:17372","2021-05-22 01:28:46","2021-05-22 01:28:46","1");
INSERT INTO audit_trail VALUES("3156","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:17375","2021-05-22 01:31:56","2021-05-22 01:31:56","1");
INSERT INTO audit_trail VALUES("3157","5","HILDA WAIGWE","","Added Capital  with id:367","2021-05-22 02:53:35","2021-05-22 02:53:35","1");
INSERT INTO audit_trail VALUES("3158","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17396","2021-05-22 02:58:37","2021-05-22 02:58:37","1");
INSERT INTO audit_trail VALUES("3159","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17432","2021-05-22 05:19:03","2021-05-22 05:19:03","1");
INSERT INTO audit_trail VALUES("3160","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17438","2021-05-22 05:21:30","2021-05-22 05:21:30","1");
INSERT INTO audit_trail VALUES("3161","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17444","2021-05-22 05:34:27","2021-05-22 05:34:27","1");
INSERT INTO audit_trail VALUES("3162","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17446","2021-05-22 05:40:38","2021-05-22 05:40:38","1");
INSERT INTO audit_trail VALUES("3163","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-22 06:02:36","2021-05-22 06:02:36","1");
INSERT INTO audit_trail VALUES("3164","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-24 01:01:19","2021-05-24 01:01:19","");
INSERT INTO audit_trail VALUES("3165","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-24 01:01:53","2021-05-24 01:01:53","1");
INSERT INTO audit_trail VALUES("3166","5","HILDA WAIGWE","","Logged in to system","2021-05-24 01:09:31","2021-05-24 01:09:31","");
INSERT INTO audit_trail VALUES("3167","5","HILDA WAIGWE","","Added Capital  with id:368","2021-05-24 01:18:44","2021-05-24 01:18:44","1");
INSERT INTO audit_trail VALUES("3168","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-24 01:33:01","2021-05-24 01:33:01","");
INSERT INTO audit_trail VALUES("3169","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-24 01:38:21","2021-05-24 01:38:21","1");
INSERT INTO audit_trail VALUES("3170","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:17463","2021-05-24 02:18:57","2021-05-24 02:18:57","1");
INSERT INTO audit_trail VALUES("3171","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:17492","2021-05-24 06:09:25","2021-05-24 06:09:25","1");
INSERT INTO audit_trail VALUES("3172","5","HILDA WAIGWE","","Added expense with id:230","2021-05-24 08:05:57","2021-05-24 08:05:57","1");
INSERT INTO audit_trail VALUES("3173","5","HILDA WAIGWE","","Added Capital  with id:369","2021-05-24 08:08:41","2021-05-24 08:08:41","1");
INSERT INTO audit_trail VALUES("3174","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17554","2021-05-24 09:43:58","2021-05-24 09:43:58","1");
INSERT INTO audit_trail VALUES("3175","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17559","2021-05-24 09:46:25","2021-05-24 09:46:25","1");
INSERT INTO audit_trail VALUES("3176","5","HILDA WAIGWE","","Added Capital  with id:370","2021-05-24 10:19:38","2021-05-24 10:19:38","1");
INSERT INTO audit_trail VALUES("3177","5","HILDA WAIGWE","","Updated expense with id:230","2021-05-24 10:30:00","2021-05-24 10:30:00","1");
INSERT INTO audit_trail VALUES("3178","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-24 10:33:19","2021-05-24 10:33:19","1");
INSERT INTO audit_trail VALUES("3179","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-24 10:34:11","2021-05-24 10:34:11","1");
INSERT INTO audit_trail VALUES("3180","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-24 10:37:19","2021-05-24 10:37:19","1");
INSERT INTO audit_trail VALUES("3181","1","Admin Admin","","Logged in to system","2021-05-25 01:38:26","2021-05-25 01:38:26","");
INSERT INTO audit_trail VALUES("3182","5","HILDA WAIGWE","","Added Capital  with id:371","2021-05-25 01:40:32","2021-05-25 01:40:32","1");
INSERT INTO audit_trail VALUES("3183","5","HILDA WAIGWE","","Added expense with id:231","2021-05-25 01:49:05","2021-05-25 01:49:05","1");
INSERT INTO audit_trail VALUES("3184","5","HILDA WAIGWE","","Updated expense with id:231","2021-05-25 01:56:23","2021-05-25 01:56:23","1");
INSERT INTO audit_trail VALUES("3185","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-25 02:55:05","2021-05-25 02:55:05","1");
INSERT INTO audit_trail VALUES("3186","1","Admin Admin","","Logged in to system","2021-05-25 03:19:21","2021-05-25 03:19:21","");
INSERT INTO audit_trail VALUES("3187","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-25 04:19:53","2021-05-25 04:19:53","");
INSERT INTO audit_trail VALUES("3188","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-25 05:08:55","2021-05-25 05:08:55","1");
INSERT INTO audit_trail VALUES("3189","5","HILDA WAIGWE","","Deleted borrower  with id:630","2021-05-25 06:40:57","2021-05-25 06:40:57","1");
INSERT INTO audit_trail VALUES("3190","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-25 06:52:12","2021-05-25 06:52:12","1");
INSERT INTO audit_trail VALUES("3191","5","HILDA WAIGWE","","Added Capital  with id:372","2021-05-25 07:12:05","2021-05-25 07:12:05","1");
INSERT INTO audit_trail VALUES("3192","5","HILDA WAIGWE","","Added Capital  with id:373","2021-05-25 07:14:20","2021-05-25 07:14:20","1");
INSERT INTO audit_trail VALUES("3193","5","HILDA WAIGWE","","Added Capital  with id:374","2021-05-25 08:49:15","2021-05-25 08:49:15","1");
INSERT INTO audit_trail VALUES("3194","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-25 10:03:41","2021-05-25 10:03:41","1");
INSERT INTO audit_trail VALUES("3195","5","HILDA WAIGWE","","Added Capital  with id:375","2021-05-26 01:36:55","2021-05-26 01:36:55","1");
INSERT INTO audit_trail VALUES("3196","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-26 01:59:06","2021-05-26 01:59:06","1");
INSERT INTO audit_trail VALUES("3197","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-26 01:59:06","2021-05-26 01:59:06","1");
INSERT INTO audit_trail VALUES("3198","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-26 02:49:34","2021-05-26 02:49:34","");
INSERT INTO audit_trail VALUES("3199","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-26 03:55:18","2021-05-26 03:55:18","1");
INSERT INTO audit_trail VALUES("3200","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:112","2021-05-26 05:47:21","2021-05-26 05:47:21","1");
INSERT INTO audit_trail VALUES("3201","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:112","2021-05-26 05:47:30","2021-05-26 05:47:30","1");
INSERT INTO audit_trail VALUES("3202","5","HILDA WAIGWE","","Added borrower  with id:632","2021-05-26 05:49:27","2021-05-26 05:49:27","1");
INSERT INTO audit_trail VALUES("3203","2","CECILIA WANJERI WANGUHU","","Updated loan with id:112","2021-05-26 05:51:50","2021-05-26 05:51:50","1");
INSERT INTO audit_trail VALUES("3204","2","CECILIA WANJERI WANGUHU","","Approved loan with id:112","2021-05-26 05:53:19","2021-05-26 05:53:19","1");
INSERT INTO audit_trail VALUES("3205","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:112","2021-05-26 05:54:45","2021-05-26 05:54:45","1");
INSERT INTO audit_trail VALUES("3206","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:112","2021-05-26 05:57:47","2021-05-26 05:57:47","1");
INSERT INTO audit_trail VALUES("3207","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:112","2021-05-26 06:03:15","2021-05-26 06:03:15","1");
INSERT INTO audit_trail VALUES("3208","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:112","2021-05-26 06:03:24","2021-05-26 06:03:24","1");
INSERT INTO audit_trail VALUES("3209","2","CECILIA WANJERI WANGUHU","","Updated loan with id:112","2021-05-26 06:04:42","2021-05-26 06:04:42","1");
INSERT INTO audit_trail VALUES("3210","2","CECILIA WANJERI WANGUHU","","Approved loan with id:112","2021-05-26 06:06:52","2021-05-26 06:06:52","1");
INSERT INTO audit_trail VALUES("3211","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:112","2021-05-26 06:08:00","2021-05-26 06:08:00","1");
INSERT INTO audit_trail VALUES("3212","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:112","2021-05-26 06:09:34","2021-05-26 06:09:34","1");
INSERT INTO audit_trail VALUES("3213","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17702","2021-05-26 06:22:08","2021-05-26 06:22:08","1");
INSERT INTO audit_trail VALUES("3214","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:139","2021-05-26 06:44:47","2021-05-26 06:44:47","1");
INSERT INTO audit_trail VALUES("3215","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:139","2021-05-26 06:44:54","2021-05-26 06:44:54","1");
INSERT INTO audit_trail VALUES("3216","2","CECILIA WANJERI WANGUHU","","Updated loan with id:139","2021-05-26 06:46:51","2021-05-26 06:46:51","1");
INSERT INTO audit_trail VALUES("3217","2","CECILIA WANJERI WANGUHU","","Approved loan with id:139","2021-05-26 06:47:37","2021-05-26 06:47:37","1");
INSERT INTO audit_trail VALUES("3218","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:139","2021-05-26 06:48:00","2021-05-26 06:48:00","1");
INSERT INTO audit_trail VALUES("3219","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:139","2021-05-26 06:49:10","2021-05-26 06:49:10","1");
INSERT INTO audit_trail VALUES("3220","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:163","2021-05-26 07:12:40","2021-05-26 07:12:40","1");
INSERT INTO audit_trail VALUES("3221","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:163","2021-05-26 07:12:46","2021-05-26 07:12:46","1");
INSERT INTO audit_trail VALUES("3222","2","CECILIA WANJERI WANGUHU","","Updated loan with id:163","2021-05-26 07:18:21","2021-05-26 07:18:21","1");
INSERT INTO audit_trail VALUES("3223","2","CECILIA WANJERI WANGUHU","","Approved loan with id:163","2021-05-26 07:19:14","2021-05-26 07:19:14","1");
INSERT INTO audit_trail VALUES("3224","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:163","2021-05-26 07:19:43","2021-05-26 07:19:43","1");
INSERT INTO audit_trail VALUES("3225","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:163","2021-05-26 07:20:45","2021-05-26 07:20:45","1");
INSERT INTO audit_trail VALUES("3226","5","HILDA WAIGWE","","Added borrower  with id:633","2021-05-26 08:11:43","2021-05-26 08:11:43","1");
INSERT INTO audit_trail VALUES("3227","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17718","2021-05-26 08:18:48","2021-05-26 08:18:48","1");
INSERT INTO audit_trail VALUES("3228","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17720","2021-05-26 08:23:28","2021-05-26 08:23:28","1");
INSERT INTO audit_trail VALUES("3229","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17726","2021-05-26 08:31:18","2021-05-26 08:31:18","1");
INSERT INTO audit_trail VALUES("3230","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17728","2021-05-26 08:33:16","2021-05-26 08:33:16","1");
INSERT INTO audit_trail VALUES("3231","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:17746","2021-05-26 09:05:28","2021-05-26 09:05:28","1");
INSERT INTO audit_trail VALUES("3232","5","HILDA WAIGWE","","Added expense with id:232","2021-05-26 10:10:36","2021-05-26 10:10:36","1");
INSERT INTO audit_trail VALUES("3233","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-26 10:27:34","2021-05-26 10:27:34","1");
INSERT INTO audit_trail VALUES("3234","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-27 01:06:50","2021-05-27 01:06:50","1");
INSERT INTO audit_trail VALUES("3235","5","HILDA WAIGWE","","Added Capital  with id:376","2021-05-27 01:18:35","2021-05-27 01:18:35","1");
INSERT INTO audit_trail VALUES("3236","5","HILDA WAIGWE","","Added Capital  with id:377","2021-05-27 03:19:09","2021-05-27 03:19:09","1");
INSERT INTO audit_trail VALUES("3237","5","HILDA WAIGWE","","Added Capital  with id:378","2021-05-27 03:20:25","2021-05-27 03:20:25","1");
INSERT INTO audit_trail VALUES("3238","5","HILDA WAIGWE","","Added Capital  with id:379","2021-05-27 03:23:18","2021-05-27 03:23:18","1");
INSERT INTO audit_trail VALUES("3239","5","HILDA WAIGWE","","Added Capital  with id:380","2021-05-27 03:24:33","2021-05-27 03:24:33","1");
INSERT INTO audit_trail VALUES("3240","5","HILDA WAIGWE","","Added expense with id:233","2021-05-27 03:26:41","2021-05-27 03:26:41","1");
INSERT INTO audit_trail VALUES("3241","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17811","2021-05-27 03:43:40","2021-05-27 03:43:40","1");
INSERT INTO audit_trail VALUES("3242","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17814","2021-05-27 04:03:39","2021-05-27 04:03:39","1");
INSERT INTO audit_trail VALUES("3243","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-27 04:05:18","2021-05-27 04:05:18","1");
INSERT INTO audit_trail VALUES("3244","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:9","2021-05-27 04:14:00","2021-05-27 04:14:00","1");
INSERT INTO audit_trail VALUES("3245","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:9","2021-05-27 04:14:20","2021-05-27 04:14:20","1");
INSERT INTO audit_trail VALUES("3246","2","CECILIA WANJERI WANGUHU","","Updated loan with id:9","2021-05-27 04:15:39","2021-05-27 04:15:39","1");
INSERT INTO audit_trail VALUES("3247","2","CECILIA WANJERI WANGUHU","","Approved loan with id:9","2021-05-27 04:17:20","2021-05-27 04:17:20","1");
INSERT INTO audit_trail VALUES("3248","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:9","2021-05-27 04:17:48","2021-05-27 04:17:48","1");
INSERT INTO audit_trail VALUES("3249","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:9","2021-05-27 04:19:53","2021-05-27 04:19:53","1");
INSERT INTO audit_trail VALUES("3250","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:9","2021-05-27 04:21:43","2021-05-27 04:21:43","1");
INSERT INTO audit_trail VALUES("3251","5","HILDA WAIGWE","","Added borrower  with id:634","2021-05-27 04:45:06","2021-05-27 04:45:06","1");
INSERT INTO audit_trail VALUES("3252","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:9","2021-05-27 04:50:26","2021-05-27 04:50:26","1");
INSERT INTO audit_trail VALUES("3253","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:9","2021-05-27 04:50:33","2021-05-27 04:50:33","1");
INSERT INTO audit_trail VALUES("3254","2","CECILIA WANJERI WANGUHU","","Approved loan with id:9","2021-05-27 04:52:17","2021-05-27 04:52:17","1");
INSERT INTO audit_trail VALUES("3255","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:9","2021-05-27 04:52:31","2021-05-27 04:52:31","1");
INSERT INTO audit_trail VALUES("3256","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:9","2021-05-27 04:59:36","2021-05-27 04:59:36","1");
INSERT INTO audit_trail VALUES("3257","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17851","2021-05-27 04:59:56","2021-05-27 04:59:56","1");
INSERT INTO audit_trail VALUES("3258","5","HILDA WAIGWE","","Added borrower  with id:635","2021-05-27 05:07:20","2021-05-27 05:07:20","1");
INSERT INTO audit_trail VALUES("3259","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:17865","2021-05-27 05:38:22","2021-05-27 05:38:22","1");
INSERT INTO audit_trail VALUES("3260","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-27 07:41:08","2021-05-27 07:41:08","1");
INSERT INTO audit_trail VALUES("3261","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-27 07:41:54","2021-05-27 07:41:54","1");
INSERT INTO audit_trail VALUES("3262","5","HILDA WAIGWE","","Added expense with id:234","2021-05-27 10:12:18","2021-05-27 10:12:18","1");
INSERT INTO audit_trail VALUES("3263","5","HILDA WAIGWE","","Added Capital  with id:381","2021-05-27 10:13:56","2021-05-27 10:13:56","1");
INSERT INTO audit_trail VALUES("3264","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-27 10:25:21","2021-05-27 10:25:21","1");
INSERT INTO audit_trail VALUES("3265","5","HILDA WAIGWE","","Added Capital  with id:382","2021-05-28 01:52:41","2021-05-28 01:52:41","1");
INSERT INTO audit_trail VALUES("3266","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-28 02:31:38","2021-05-28 02:31:38","");
INSERT INTO audit_trail VALUES("3267","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-28 02:42:25","2021-05-28 02:42:25","1");
INSERT INTO audit_trail VALUES("3268","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:177","2021-05-28 04:26:17","2021-05-28 04:26:17","1");
INSERT INTO audit_trail VALUES("3269","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:177","2021-05-28 04:26:24","2021-05-28 04:26:24","1");
INSERT INTO audit_trail VALUES("3270","2","CECILIA WANJERI WANGUHU","","Updated loan with id:177","2021-05-28 04:27:23","2021-05-28 04:27:23","1");
INSERT INTO audit_trail VALUES("3271","2","CECILIA WANJERI WANGUHU","","Approved loan with id:177","2021-05-28 04:28:33","2021-05-28 04:28:33","1");
INSERT INTO audit_trail VALUES("3272","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:177","2021-05-28 04:28:57","2021-05-28 04:28:57","1");
INSERT INTO audit_trail VALUES("3273","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:177","2021-05-28 04:31:57","2021-05-28 04:31:57","1");
INSERT INTO audit_trail VALUES("3274","5","HILDA WAIGWE","","Added Capital  with id:383","2021-05-28 05:51:48","2021-05-28 05:51:48","1");
INSERT INTO audit_trail VALUES("3275","5","HILDA WAIGWE","","Updated Capital  with id:378","2021-05-28 05:52:24","2021-05-28 05:52:24","1");
INSERT INTO audit_trail VALUES("3276","5","HILDA WAIGWE","","Added Capital  with id:384","2021-05-28 05:53:07","2021-05-28 05:53:07","1");
INSERT INTO audit_trail VALUES("3277","5","HILDA WAIGWE","","Added Capital  with id:385","2021-05-28 05:54:11","2021-05-28 05:54:11","1");
INSERT INTO audit_trail VALUES("3278","5","HILDA WAIGWE","","Added Capital  with id:386","2021-05-28 05:55:27","2021-05-28 05:55:27","1");
INSERT INTO audit_trail VALUES("3279","5","HILDA WAIGWE","","Updated Capital  with id:385","2021-05-28 05:56:33","2021-05-28 05:56:33","1");
INSERT INTO audit_trail VALUES("3280","5","HILDA WAIGWE","","Added expense with id:235","2021-05-28 05:59:01","2021-05-28 05:59:01","1");
INSERT INTO audit_trail VALUES("3281","1","Admin Admin","","Logged in to system","2021-05-28 06:59:36","2021-05-28 06:59:36","");
INSERT INTO audit_trail VALUES("3282","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18008","2021-05-28 08:15:35","2021-05-28 08:15:35","1");
INSERT INTO audit_trail VALUES("3283","5","HILDA WAIGWE","","Added expense with id:236","2021-05-28 09:24:11","2021-05-28 09:24:11","1");
INSERT INTO audit_trail VALUES("3284","1","Admin Admin","","Updated expense with id:235","2021-05-28 09:50:54","2021-05-28 09:50:54","1");
INSERT INTO audit_trail VALUES("3285","1","Admin Admin","","Updated expense with id:235","2021-05-28 09:51:28","2021-05-28 09:51:28","1");
INSERT INTO audit_trail VALUES("3286","1","Admin Admin","","Updated expense with id:235","2021-05-28 09:54:28","2021-05-28 09:54:28","1");
INSERT INTO audit_trail VALUES("3287","1","Admin Admin","","Updated expense with id:235","2021-05-28 09:55:12","2021-05-28 09:55:12","1");
INSERT INTO audit_trail VALUES("3288","5","HILDA WAIGWE","","Added Capital  with id:387","2021-05-28 09:59:12","2021-05-28 09:59:12","1");
INSERT INTO audit_trail VALUES("3289","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-28 10:01:30","2021-05-28 10:01:30","1");
INSERT INTO audit_trail VALUES("3290","5","HILDA WAIGWE","","Logged out of system","2021-05-28 10:03:18","2021-05-28 10:03:18","1");
INSERT INTO audit_trail VALUES("3291","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-28 10:09:05","2021-05-28 10:09:05","1");
INSERT INTO audit_trail VALUES("3292","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-28 10:09:34","2021-05-28 10:09:34","1");
INSERT INTO audit_trail VALUES("3293","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-28 10:09:42","2021-05-28 10:09:42","1");
INSERT INTO audit_trail VALUES("3294","1","Admin Admin","","Logged in to system","2021-05-28 10:10:37","2021-05-28 10:10:37","1");
INSERT INTO audit_trail VALUES("3295","1","Admin Admin","","Logged out of system","2021-05-28 10:12:25","2021-05-28 10:12:25","1");
INSERT INTO audit_trail VALUES("3296","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-29 00:56:37","2021-05-29 00:56:37","1");
INSERT INTO audit_trail VALUES("3297","5","HILDA WAIGWE","","Logged in to system","2021-05-29 01:10:21","2021-05-29 01:10:21","1");
INSERT INTO audit_trail VALUES("3298","5","HILDA WAIGWE","","Added Capital  with id:388","2021-05-29 01:12:01","2021-05-29 01:12:01","1");
INSERT INTO audit_trail VALUES("3299","5","HILDA WAIGWE","","Added loan with id:205","2021-05-29 04:12:21","2021-05-29 04:12:21","1");
INSERT INTO audit_trail VALUES("3300","5","HILDA WAIGWE","","Approved loan with id:205","2021-05-29 04:14:58","2021-05-29 04:14:58","1");
INSERT INTO audit_trail VALUES("3301","5","HILDA WAIGWE","","Disbursed loan with id:205","2021-05-29 04:15:49","2021-05-29 04:15:49","1");
INSERT INTO audit_trail VALUES("3302","2","CECILIA WANJERI WANGUHU","","Added expense with id:237","2021-05-29 05:43:18","2021-05-29 05:43:18","1");
INSERT INTO audit_trail VALUES("3303","5","HILDA WAIGWE","","Logged out of system","2021-05-29 06:14:12","2021-05-29 06:14:12","1");
INSERT INTO audit_trail VALUES("3304","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-29 06:15:06","2021-05-29 06:15:06","1");
INSERT INTO audit_trail VALUES("3305","5","HILDA WAIGWE","","Logged in to system","2021-05-31 01:24:41","2021-05-31 01:24:41","");
INSERT INTO audit_trail VALUES("3306","5","HILDA WAIGWE","","Added Capital  with id:389","2021-05-31 02:23:15","2021-05-31 02:23:15","1");
INSERT INTO audit_trail VALUES("3307","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-31 02:36:24","2021-05-31 02:36:24","");
INSERT INTO audit_trail VALUES("3308","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-31 02:37:24","2021-05-31 02:37:24","");
INSERT INTO audit_trail VALUES("3309","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18257","2021-05-31 05:29:12","2021-05-31 05:29:12","1");
INSERT INTO audit_trail VALUES("3310","5","HILDA WAIGWE","","Added expense with id:238","2021-05-31 09:10:30","2021-05-31 09:10:30","1");
INSERT INTO audit_trail VALUES("3311","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-05-31 09:19:17","2021-05-31 09:19:17","");
INSERT INTO audit_trail VALUES("3312","5","HILDA WAIGWE","","Added Capital  with id:390","2021-05-31 10:14:23","2021-05-31 10:14:23","1");
INSERT INTO audit_trail VALUES("3313","2","CECILIA WANJERI WANGUHU","","Added expense with id:239","2021-05-31 10:29:13","2021-05-31 10:29:13","1");
INSERT INTO audit_trail VALUES("3314","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-05-31 10:40:57","2021-05-31 10:40:57","1");
INSERT INTO audit_trail VALUES("3315","5","HILDA WAIGWE","","Logged out of system","2021-05-31 10:43:39","2021-05-31 10:43:39","1");
INSERT INTO audit_trail VALUES("3316","5","HILDA WAIGWE","","Logged in to system","2021-06-02 01:25:49","2021-06-02 01:25:49","");
INSERT INTO audit_trail VALUES("3317","5","HILDA WAIGWE","","Added Capital  with id:391","2021-06-02 01:40:14","2021-06-02 01:40:14","1");
INSERT INTO audit_trail VALUES("3318","5","HILDA WAIGWE","","Updated Capital  with id:391","2021-06-02 01:46:04","2021-06-02 01:46:04","1");
INSERT INTO audit_trail VALUES("3319","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-02 02:26:26","2021-06-02 02:26:26","");
INSERT INTO audit_trail VALUES("3320","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-02 02:36:45","2021-06-02 02:36:45","");
INSERT INTO audit_trail VALUES("3321","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18349","2021-06-02 04:13:19","2021-06-02 04:13:19","1");
INSERT INTO audit_trail VALUES("3322","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-02 04:57:52","2021-06-02 04:57:52","1");
INSERT INTO audit_trail VALUES("3323","5","HILDA WAIGWE","","Added expense with id:240","2021-06-02 09:48:44","2021-06-02 09:48:44","1");
INSERT INTO audit_trail VALUES("3324","5","HILDA WAIGWE","","Added expense with id:241","2021-06-02 09:49:43","2021-06-02 09:49:43","1");
INSERT INTO audit_trail VALUES("3325","5","HILDA WAIGWE","","Added expense with id:242","2021-06-02 09:50:56","2021-06-02 09:50:56","1");
INSERT INTO audit_trail VALUES("3326","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18425","2021-06-02 09:52:19","2021-06-02 09:52:19","1");
INSERT INTO audit_trail VALUES("3327","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18427","2021-06-02 09:53:13","2021-06-02 09:53:13","1");
INSERT INTO audit_trail VALUES("3328","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18429","2021-06-02 09:54:05","2021-06-02 09:54:05","1");
INSERT INTO audit_trail VALUES("3329","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18436","2021-06-02 10:24:37","2021-06-02 10:24:37","1");
INSERT INTO audit_trail VALUES("3330","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18438","2021-06-02 10:25:45","2021-06-02 10:25:45","1");
INSERT INTO audit_trail VALUES("3331","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18440","2021-06-02 10:27:26","2021-06-02 10:27:26","1");
INSERT INTO audit_trail VALUES("3332","5","HILDA WAIGWE","","Logged out of system","2021-06-02 11:04:24","2021-06-02 11:04:24","1");
INSERT INTO audit_trail VALUES("3333","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-02 11:10:22","2021-06-02 11:10:22","1");
INSERT INTO audit_trail VALUES("3334","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-03 01:46:13","2021-06-03 01:46:13","1");
INSERT INTO audit_trail VALUES("3335","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-03 01:58:07","2021-06-03 01:58:07","1");
INSERT INTO audit_trail VALUES("3336","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:392","2021-06-03 01:59:43","2021-06-03 01:59:43","1");
INSERT INTO audit_trail VALUES("3337","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-03 03:16:36","2021-06-03 03:16:36","");
INSERT INTO audit_trail VALUES("3338","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-03 10:18:02","2021-06-03 10:18:02","1");
INSERT INTO audit_trail VALUES("3339","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-03 10:19:24","2021-06-03 10:19:24","1");
INSERT INTO audit_trail VALUES("3340","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:18563","2021-06-03 10:22:03","2021-06-03 10:22:03","1");
INSERT INTO audit_trail VALUES("3341","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:18565","2021-06-03 10:23:07","2021-06-03 10:23:07","1");
INSERT INTO audit_trail VALUES("3342","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-03 10:23:26","2021-06-03 10:23:26","1");
INSERT INTO audit_trail VALUES("3343","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-03 10:25:20","2021-06-03 10:25:20","1");
INSERT INTO audit_trail VALUES("3344","5","HILDA WAIGWE","","Logged in to system","2021-06-04 01:09:46","2021-06-04 01:09:46","1");
INSERT INTO audit_trail VALUES("3345","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-04 01:40:57","2021-06-04 01:40:57","1");
INSERT INTO audit_trail VALUES("3346","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-04 01:53:51","2021-06-04 01:53:51","1");
INSERT INTO audit_trail VALUES("3347","5","HILDA WAIGWE","","Added Capital  with id:393","2021-06-04 02:22:10","2021-06-04 02:22:10","1");
INSERT INTO audit_trail VALUES("3348","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18585","2021-06-04 03:23:28","2021-06-04 03:23:28","1");
INSERT INTO audit_trail VALUES("3349","5","HILDA WAIGWE","","Updated loan product with id:1","2021-06-04 07:16:28","2021-06-04 07:16:28","1");
INSERT INTO audit_trail VALUES("3350","5","HILDA WAIGWE","","Logged out of system","2021-06-04 07:30:10","2021-06-04 07:30:10","1");
INSERT INTO audit_trail VALUES("3351","5","HILDA WAIGWE","","Logged in to system","2021-06-04 07:32:53","2021-06-04 07:32:53","1");
INSERT INTO audit_trail VALUES("3352","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18621","2021-06-04 08:05:15","2021-06-04 08:05:15","1");
INSERT INTO audit_trail VALUES("3353","5","HILDA WAIGWE","","Added expense with id:243","2021-06-04 09:32:14","2021-06-04 09:32:14","1");
INSERT INTO audit_trail VALUES("3354","5","HILDA WAIGWE","","Added expense with id:244","2021-06-04 09:33:11","2021-06-04 09:33:11","1");
INSERT INTO audit_trail VALUES("3355","5","HILDA WAIGWE","","Added Capital  with id:394","2021-06-04 09:45:12","2021-06-04 09:45:12","1");
INSERT INTO audit_trail VALUES("3356","5","HILDA WAIGWE","","Added Capital  with id:395","2021-06-04 09:46:28","2021-06-04 09:46:28","1");
INSERT INTO audit_trail VALUES("3357","5","HILDA WAIGWE","","Added Capital  with id:396","2021-06-04 09:47:49","2021-06-04 09:47:49","1");
INSERT INTO audit_trail VALUES("3358","5","HILDA WAIGWE","","Added Capital  with id:397","2021-06-04 09:49:33","2021-06-04 09:49:33","1");
INSERT INTO audit_trail VALUES("3359","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-04 10:24:28","2021-06-04 10:24:28","1");
INSERT INTO audit_trail VALUES("3360","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-05 01:28:56","2021-06-05 01:28:56","");
INSERT INTO audit_trail VALUES("3361","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-05 01:31:57","2021-06-05 01:31:57","1");
INSERT INTO audit_trail VALUES("3362","1","Admin Admin","","Logged in to system","2021-06-05 01:36:08","2021-06-05 01:36:08","");
INSERT INTO audit_trail VALUES("3363","5","HILDA WAIGWE","","Added Capital  with id:398","2021-06-05 01:36:30","2021-06-05 01:36:30","1");
INSERT INTO audit_trail VALUES("3364","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:399","2021-06-05 04:00:33","2021-06-05 04:00:33","1");
INSERT INTO audit_trail VALUES("3365","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:400","2021-06-05 04:01:37","2021-06-05 04:01:37","1");
INSERT INTO audit_trail VALUES("3366","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:401","2021-06-05 04:02:31","2021-06-05 04:02:31","1");
INSERT INTO audit_trail VALUES("3367","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18703","2021-06-05 04:40:15","2021-06-05 04:40:15","1");
INSERT INTO audit_trail VALUES("3368","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18705","2021-06-05 04:42:40","2021-06-05 04:42:40","1");
INSERT INTO audit_trail VALUES("3369","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18707","2021-06-05 04:44:57","2021-06-05 04:44:57","1");
INSERT INTO audit_trail VALUES("3370","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18724","2021-06-05 05:00:15","2021-06-05 05:00:15","1");
INSERT INTO audit_trail VALUES("3371","5","HILDA WAIGWE","","Added Capital  with id:402","2021-06-05 05:09:56","2021-06-05 05:09:56","1");
INSERT INTO audit_trail VALUES("3372","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18738","2021-06-05 05:17:09","2021-06-05 05:17:09","1");
INSERT INTO audit_trail VALUES("3373","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18740","2021-06-05 05:18:40","2021-06-05 05:18:40","1");
INSERT INTO audit_trail VALUES("3374","2","CECILIA WANJERI WANGUHU","","Added expense with id:245","2021-06-05 05:22:27","2021-06-05 05:22:27","1");
INSERT INTO audit_trail VALUES("3375","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18744","2021-06-05 05:27:25","2021-06-05 05:27:25","1");
INSERT INTO audit_trail VALUES("3376","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18753","2021-06-05 05:39:30","2021-06-05 05:39:30","1");
INSERT INTO audit_trail VALUES("3377","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18764","2021-06-05 05:54:30","2021-06-05 05:54:30","1");
INSERT INTO audit_trail VALUES("3378","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18767","2021-06-05 06:16:50","2021-06-05 06:16:50","1");
INSERT INTO audit_trail VALUES("3379","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18769","2021-06-05 06:18:08","2021-06-05 06:18:08","1");
INSERT INTO audit_trail VALUES("3380","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18771","2021-06-05 06:22:03","2021-06-05 06:22:03","1");
INSERT INTO audit_trail VALUES("3381","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-05 06:32:31","2021-06-05 06:32:31","1");
INSERT INTO audit_trail VALUES("3382","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18775","2021-06-05 06:33:02","2021-06-05 06:33:02","1");
INSERT INTO audit_trail VALUES("3383","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-05 06:33:10","2021-06-05 06:33:10","1");
INSERT INTO audit_trail VALUES("3384","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-05 06:34:30","2021-06-05 06:34:30","1");
INSERT INTO audit_trail VALUES("3385","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:18777","2021-06-05 06:35:02","2021-06-05 06:35:02","1");
INSERT INTO audit_trail VALUES("3386","5","HILDA WAIGWE","","Logged out of system","2021-06-05 06:43:25","2021-06-05 06:43:25","1");
INSERT INTO audit_trail VALUES("3387","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-07 01:36:34","2021-06-07 01:36:34","");
INSERT INTO audit_trail VALUES("3388","5","HILDA WAIGWE","","Logged in to system","2021-06-07 01:39:26","2021-06-07 01:39:26","");
INSERT INTO audit_trail VALUES("3389","5","HILDA WAIGWE","","Added Capital  with id:403","2021-06-07 01:45:18","2021-06-07 01:45:18","1");
INSERT INTO audit_trail VALUES("3390","5","HILDA WAIGWE","","Added expense with id:246","2021-06-07 01:48:59","2021-06-07 01:48:59","1");
INSERT INTO audit_trail VALUES("3391","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-07 05:00:57","2021-06-07 05:00:57","");
INSERT INTO audit_trail VALUES("3392","5","HILDA WAIGWE","","Logged out of system","2021-06-07 10:24:23","2021-06-07 10:24:23","1");
INSERT INTO audit_trail VALUES("3393","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-07 10:26:04","2021-06-07 10:26:04","1");
INSERT INTO audit_trail VALUES("3394","5","HILDA WAIGWE","","Logged in to system","2021-06-08 01:31:59","2021-06-08 01:31:59","1");
INSERT INTO audit_trail VALUES("3395","5","HILDA WAIGWE","","Added Capital  with id:404","2021-06-08 01:34:20","2021-06-08 01:34:20","1");
INSERT INTO audit_trail VALUES("3396","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-08 01:48:20","2021-06-08 01:48:20","1");
INSERT INTO audit_trail VALUES("3397","5","HILDA WAIGWE","","Logged out of system","2021-06-08 02:09:24","2021-06-08 02:09:24","1");
INSERT INTO audit_trail VALUES("3398","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-08 03:34:13","2021-06-08 03:34:13","1");
INSERT INTO audit_trail VALUES("3399","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18878","2021-06-08 03:55:05","2021-06-08 03:55:05","1");
INSERT INTO audit_trail VALUES("3400","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18880","2021-06-08 04:16:11","2021-06-08 04:16:11","1");
INSERT INTO audit_trail VALUES("3401","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18882","2021-06-08 04:24:57","2021-06-08 04:24:57","1");
INSERT INTO audit_trail VALUES("3402","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18887","2021-06-08 04:32:05","2021-06-08 04:32:05","1");
INSERT INTO audit_trail VALUES("3403","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18910","2021-06-08 06:52:24","2021-06-08 06:52:24","1");
INSERT INTO audit_trail VALUES("3404","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18912","2021-06-08 06:55:06","2021-06-08 06:55:06","1");
INSERT INTO audit_trail VALUES("3405","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18914","2021-06-08 07:01:12","2021-06-08 07:01:12","1");
INSERT INTO audit_trail VALUES("3406","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:18925","2021-06-08 08:03:35","2021-06-08 08:03:35","1");
INSERT INTO audit_trail VALUES("3407","5","HILDA WAIGWE","","Logged in to system","2021-06-08 08:41:52","2021-06-08 08:41:52","1");
INSERT INTO audit_trail VALUES("3408","5","HILDA WAIGWE","","Added Capital  with id:405","2021-06-08 08:43:04","2021-06-08 08:43:04","1");
INSERT INTO audit_trail VALUES("3409","5","HILDA WAIGWE","","Added Capital  with id:406","2021-06-08 08:47:09","2021-06-08 08:47:09","1");
INSERT INTO audit_trail VALUES("3410","5","HILDA WAIGWE","","Added expense with id:247","2021-06-08 08:49:53","2021-06-08 08:49:53","1");
INSERT INTO audit_trail VALUES("3411","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-08 10:09:49","2021-06-08 10:09:49","1");
INSERT INTO audit_trail VALUES("3412","5","HILDA WAIGWE","","Added Capital  with id:407","2021-06-09 01:57:13","2021-06-09 01:57:13","1");
INSERT INTO audit_trail VALUES("3413","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-09 02:00:26","2021-06-09 02:00:26","1");
INSERT INTO audit_trail VALUES("3414","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-09 02:00:26","2021-06-09 02:00:26","1");
INSERT INTO audit_trail VALUES("3415","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-09 02:30:02","2021-06-09 02:30:02","1");
INSERT INTO audit_trail VALUES("3416","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19009","2021-06-09 02:34:37","2021-06-09 02:34:37","1");
INSERT INTO audit_trail VALUES("3417","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19011","2021-06-09 02:36:44","2021-06-09 02:36:44","1");
INSERT INTO audit_trail VALUES("3418","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19013","2021-06-09 02:37:56","2021-06-09 02:37:56","1");
INSERT INTO audit_trail VALUES("3419","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19015","2021-06-09 02:38:59","2021-06-09 02:38:59","1");
INSERT INTO audit_trail VALUES("3420","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19017","2021-06-09 02:42:12","2021-06-09 02:42:12","1");
INSERT INTO audit_trail VALUES("3421","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-09 05:48:46","2021-06-09 05:48:46","1");
INSERT INTO audit_trail VALUES("3422","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-09 05:49:06","2021-06-09 05:49:06","1");
INSERT INTO audit_trail VALUES("3423","5","HILDA WAIGWE","","Added expense with id:248","2021-06-09 07:26:09","2021-06-09 07:26:09","1");
INSERT INTO audit_trail VALUES("3424","5","HILDA WAIGWE","","Added expense with id:249","2021-06-09 07:36:33","2021-06-09 07:36:33","1");
INSERT INTO audit_trail VALUES("3425","5","HILDA WAIGWE","","Added expense with id:250","2021-06-09 07:52:35","2021-06-09 07:52:35","1");
INSERT INTO audit_trail VALUES("3426","5","HILDA WAIGWE","","Added Capital  with id:408","2021-06-09 09:36:33","2021-06-09 09:36:33","1");
INSERT INTO audit_trail VALUES("3427","5","HILDA WAIGWE","","Added expense with id:251","2021-06-09 09:42:03","2021-06-09 09:42:03","1");
INSERT INTO audit_trail VALUES("3428","5","HILDA WAIGWE","","Added expense with id:252","2021-06-09 09:47:19","2021-06-09 09:47:19","1");
INSERT INTO audit_trail VALUES("3429","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-09 10:18:16","2021-06-09 10:18:16","1");
INSERT INTO audit_trail VALUES("3430","5","HILDA WAIGWE","","Logged out of system","2021-06-09 10:19:21","2021-06-09 10:19:21","1");
INSERT INTO audit_trail VALUES("3431","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-10 01:22:41","2021-06-10 01:22:41","1");
INSERT INTO audit_trail VALUES("3432","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:409","2021-06-10 01:35:46","2021-06-10 01:35:46","1");
INSERT INTO audit_trail VALUES("3433","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-10 03:47:19","2021-06-10 03:47:19","1");
INSERT INTO audit_trail VALUES("3434","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-10 03:59:17","2021-06-10 03:59:17","1");
INSERT INTO audit_trail VALUES("3435","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-10 07:46:03","2021-06-10 07:46:03","1");
INSERT INTO audit_trail VALUES("3436","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:410","2021-06-10 08:01:41","2021-06-10 08:01:41","1");
INSERT INTO audit_trail VALUES("3437","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:411","2021-06-10 08:02:55","2021-06-10 08:02:55","1");
INSERT INTO audit_trail VALUES("3438","4","PERIS  NYAMBURA MWANGI","","Updated Capital  with id:411","2021-06-10 08:03:27","2021-06-10 08:03:27","1");
INSERT INTO audit_trail VALUES("3439","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:412","2021-06-10 08:04:28","2021-06-10 08:04:28","1");
INSERT INTO audit_trail VALUES("3440","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-10 10:09:32","2021-06-10 10:09:32","1");
INSERT INTO audit_trail VALUES("3441","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-10 10:13:05","2021-06-10 10:13:05","1");
INSERT INTO audit_trail VALUES("3442","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-11 03:49:33","2021-06-11 03:49:33","");
INSERT INTO audit_trail VALUES("3443","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-11 03:49:36","2021-06-11 03:49:36","");
INSERT INTO audit_trail VALUES("3444","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-11 03:49:37","2021-06-11 03:49:37","1");
INSERT INTO audit_trail VALUES("3445","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-11 03:49:44","2021-06-11 03:49:44","1");
INSERT INTO audit_trail VALUES("3446","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-11 03:50:03","2021-06-11 03:50:03","1");
INSERT INTO audit_trail VALUES("3447","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:413","2021-06-11 08:01:29","2021-06-11 08:01:29","1");
INSERT INTO audit_trail VALUES("3448","4","PERIS  NYAMBURA MWANGI","","Added expense with id:253","2021-06-11 08:15:39","2021-06-11 08:15:39","1");
INSERT INTO audit_trail VALUES("3449","4","PERIS  NYAMBURA MWANGI","","Added expense with id:254","2021-06-11 08:17:07","2021-06-11 08:17:07","1");
INSERT INTO audit_trail VALUES("3450","4","PERIS  NYAMBURA MWANGI","","Added expense with id:255","2021-06-11 08:18:46","2021-06-11 08:18:46","1");
INSERT INTO audit_trail VALUES("3451","4","PERIS  NYAMBURA MWANGI","","Added expense with id:256","2021-06-11 08:23:04","2021-06-11 08:23:04","1");
INSERT INTO audit_trail VALUES("3452","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-11 10:17:49","2021-06-11 10:17:49","1");
INSERT INTO audit_trail VALUES("3453","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-11 10:21:15","2021-06-11 10:21:15","1");
INSERT INTO audit_trail VALUES("3454","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-12 01:36:12","2021-06-12 01:36:12","1");
INSERT INTO audit_trail VALUES("3455","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:414","2021-06-12 01:40:38","2021-06-12 01:40:38","1");
INSERT INTO audit_trail VALUES("3456","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-12 02:38:19","2021-06-12 02:38:19","1");
INSERT INTO audit_trail VALUES("3457","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-12 02:38:21","2021-06-12 02:38:21","1");
INSERT INTO audit_trail VALUES("3458","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:415","2021-06-12 05:53:57","2021-06-12 05:53:57","1");
INSERT INTO audit_trail VALUES("3459","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-12 06:38:03","2021-06-12 06:38:03","1");
INSERT INTO audit_trail VALUES("3460","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-14 01:26:11","2021-06-14 01:26:11","");
INSERT INTO audit_trail VALUES("3461","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-14 04:03:36","2021-06-14 04:03:36","");
INSERT INTO audit_trail VALUES("3462","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-14 04:06:13","2021-06-14 04:06:13","");
INSERT INTO audit_trail VALUES("3463","2","CECILIA WANJERI WANGUHU","","Added expense with id:257","2021-06-14 04:07:57","2021-06-14 04:07:57","1");
INSERT INTO audit_trail VALUES("3464","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:416","2021-06-14 04:08:42","2021-06-14 04:08:42","1");
INSERT INTO audit_trail VALUES("3465","2","CECILIA WANJERI WANGUHU","","Added expense with id:258","2021-06-14 04:09:21","2021-06-14 04:09:21","1");
INSERT INTO audit_trail VALUES("3466","2","CECILIA WANJERI WANGUHU","","Added expense with id:259","2021-06-14 04:10:16","2021-06-14 04:10:16","1");
INSERT INTO audit_trail VALUES("3467","2","CECILIA WANJERI WANGUHU","","Added expense with id:260","2021-06-14 04:22:20","2021-06-14 04:22:20","1");
INSERT INTO audit_trail VALUES("3468","2","CECILIA WANJERI WANGUHU","","Added loan with id:206","2021-06-14 04:26:38","2021-06-14 04:26:38","1");
INSERT INTO audit_trail VALUES("3469","2","CECILIA WANJERI WANGUHU","","Approved loan with id:206","2021-06-14 04:29:44","2021-06-14 04:29:44","1");
INSERT INTO audit_trail VALUES("3470","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:206","2021-06-14 04:30:43","2021-06-14 04:30:43","1");
INSERT INTO audit_trail VALUES("3471","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19379","2021-06-14 04:35:14","2021-06-14 04:35:14","1");
INSERT INTO audit_trail VALUES("3472","2","CECILIA WANJERI WANGUHU","","Added loan with id:207","2021-06-14 04:42:22","2021-06-14 04:42:22","1");
INSERT INTO audit_trail VALUES("3473","2","CECILIA WANJERI WANGUHU","","Approved loan with id:207","2021-06-14 04:42:58","2021-06-14 04:42:58","1");
INSERT INTO audit_trail VALUES("3474","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:207","2021-06-14 04:48:02","2021-06-14 04:48:02","1");
INSERT INTO audit_trail VALUES("3475","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:207","2021-06-14 04:50:46","2021-06-14 04:50:46","1");
INSERT INTO audit_trail VALUES("3476","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:207","2021-06-14 04:50:54","2021-06-14 04:50:54","1");
INSERT INTO audit_trail VALUES("3477","2","CECILIA WANJERI WANGUHU","","Deleted loan with id:207","2021-06-14 04:51:07","2021-06-14 04:51:07","1");
INSERT INTO audit_trail VALUES("3478","2","CECILIA WANJERI WANGUHU","","Added loan with id:208","2021-06-14 05:05:22","2021-06-14 05:05:22","1");
INSERT INTO audit_trail VALUES("3479","2","CECILIA WANJERI WANGUHU","","Approved loan with id:208","2021-06-14 05:05:47","2021-06-14 05:05:47","1");
INSERT INTO audit_trail VALUES("3480","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:208","2021-06-14 05:07:05","2021-06-14 05:07:05","1");
INSERT INTO audit_trail VALUES("3481","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19402","2021-06-14 05:11:37","2021-06-14 05:11:37","1");
INSERT INTO audit_trail VALUES("3482","2","CECILIA WANJERI WANGUHU","","Added expense with id:261","2021-06-14 07:50:29","2021-06-14 07:50:29","1");
INSERT INTO audit_trail VALUES("3483","2","CECILIA WANJERI WANGUHU","","Added expense with id:262","2021-06-14 10:05:02","2021-06-14 10:05:02","1");
INSERT INTO audit_trail VALUES("3484","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-14 10:16:37","2021-06-14 10:16:37","1");
INSERT INTO audit_trail VALUES("3485","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-15 01:14:29","2021-06-15 01:14:29","1");
INSERT INTO audit_trail VALUES("3486","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:417","2021-06-15 02:01:23","2021-06-15 02:01:23","1");
INSERT INTO audit_trail VALUES("3487","4","PERIS  NYAMBURA MWANGI","","Updated Capital  with id:388","2021-06-15 02:03:25","2021-06-15 02:03:25","1");
INSERT INTO audit_trail VALUES("3488","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-15 02:50:11","2021-06-15 02:50:11","1");
INSERT INTO audit_trail VALUES("3489","4","PERIS  NYAMBURA MWANGI","","Added expense with id:263","2021-06-15 09:57:02","2021-06-15 09:57:02","1");
INSERT INTO audit_trail VALUES("3490","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:418","2021-06-15 09:58:48","2021-06-15 09:58:48","1");
INSERT INTO audit_trail VALUES("3491","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-15 10:07:05","2021-06-15 10:07:05","1");
INSERT INTO audit_trail VALUES("3492","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:419","2021-06-16 01:44:59","2021-06-16 01:44:59","1");
INSERT INTO audit_trail VALUES("3493","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-16 02:37:40","2021-06-16 02:37:40","");
INSERT INTO audit_trail VALUES("3494","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-16 02:41:20","2021-06-16 02:41:20","1");
INSERT INTO audit_trail VALUES("3495","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19560","2021-06-16 03:03:00","2021-06-16 03:03:00","1");
INSERT INTO audit_trail VALUES("3496","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19562","2021-06-16 03:33:52","2021-06-16 03:33:52","1");
INSERT INTO audit_trail VALUES("3497","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19564","2021-06-16 03:42:17","2021-06-16 03:42:17","1");
INSERT INTO audit_trail VALUES("3498","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19582","2021-06-16 04:27:18","2021-06-16 04:27:18","1");
INSERT INTO audit_trail VALUES("3499","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19588","2021-06-16 04:32:50","2021-06-16 04:32:50","1");
INSERT INTO audit_trail VALUES("3500","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19627","2021-06-16 04:58:47","2021-06-16 04:58:47","1");
INSERT INTO audit_trail VALUES("3501","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19630","2021-06-16 05:09:27","2021-06-16 05:09:27","1");
INSERT INTO audit_trail VALUES("3502","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:420","2021-06-16 09:11:58","2021-06-16 09:11:58","1");
INSERT INTO audit_trail VALUES("3503","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:421","2021-06-16 09:14:27","2021-06-16 09:14:27","1");
INSERT INTO audit_trail VALUES("3504","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:422","2021-06-16 09:15:47","2021-06-16 09:15:47","1");
INSERT INTO audit_trail VALUES("3505","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:423","2021-06-16 09:16:56","2021-06-16 09:16:56","1");
INSERT INTO audit_trail VALUES("3506","4","PERIS  NYAMBURA MWANGI","","Added expense with id:264","2021-06-16 09:19:04","2021-06-16 09:19:04","1");
INSERT INTO audit_trail VALUES("3507","4","PERIS  NYAMBURA MWANGI","","Added expense with id:265","2021-06-16 09:30:01","2021-06-16 09:30:01","1");
INSERT INTO audit_trail VALUES("3508","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-16 10:01:06","2021-06-16 10:01:06","1");
INSERT INTO audit_trail VALUES("3509","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-16 10:03:03","2021-06-16 10:03:03","1");
INSERT INTO audit_trail VALUES("3510","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-17 02:15:31","2021-06-17 02:15:31","1");
INSERT INTO audit_trail VALUES("3511","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-17 02:36:08","2021-06-17 02:36:08","1");
INSERT INTO audit_trail VALUES("3512","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-17 02:46:48","2021-06-17 02:46:48","1");
INSERT INTO audit_trail VALUES("3513","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:424","2021-06-17 02:48:18","2021-06-17 02:48:18","1");
INSERT INTO audit_trail VALUES("3514","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19719","2021-06-17 02:56:28","2021-06-17 02:56:28","1");
INSERT INTO audit_trail VALUES("3515","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19721","2021-06-17 03:00:38","2021-06-17 03:00:38","1");
INSERT INTO audit_trail VALUES("3516","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19725","2021-06-17 03:56:40","2021-06-17 03:56:40","1");
INSERT INTO audit_trail VALUES("3517","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:425","2021-06-17 05:15:07","2021-06-17 05:15:07","1");
INSERT INTO audit_trail VALUES("3518","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19740","2021-06-17 05:55:53","2021-06-17 05:55:53","1");
INSERT INTO audit_trail VALUES("3519","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19742","2021-06-17 06:13:05","2021-06-17 06:13:05","1");
INSERT INTO audit_trail VALUES("3520","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19744","2021-06-17 06:15:49","2021-06-17 06:15:49","1");
INSERT INTO audit_trail VALUES("3521","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:426","2021-06-17 08:05:41","2021-06-17 08:05:41","1");
INSERT INTO audit_trail VALUES("3522","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:427","2021-06-17 08:06:39","2021-06-17 08:06:39","1");
INSERT INTO audit_trail VALUES("3523","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:428","2021-06-17 08:07:44","2021-06-17 08:07:44","1");
INSERT INTO audit_trail VALUES("3524","2","CECILIA WANJERI WANGUHU","","Added expense with id:266","2021-06-17 08:09:08","2021-06-17 08:09:08","1");
INSERT INTO audit_trail VALUES("3525","2","CECILIA WANJERI WANGUHU","","Added expense with id:267","2021-06-17 08:09:54","2021-06-17 08:09:54","1");
INSERT INTO audit_trail VALUES("3526","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-17 10:01:48","2021-06-17 10:01:48","1");
INSERT INTO audit_trail VALUES("3527","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-17 10:06:45","2021-06-17 10:06:45","1");
INSERT INTO audit_trail VALUES("3528","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-17 10:07:02","2021-06-17 10:07:02","1");
INSERT INTO audit_trail VALUES("3529","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:429","2021-06-18 01:28:50","2021-06-18 01:28:50","1");
INSERT INTO audit_trail VALUES("3530","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-18 01:55:12","2021-06-18 01:55:12","1");
INSERT INTO audit_trail VALUES("3531","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:19825","2021-06-18 02:43:43","2021-06-18 02:43:43","1");
INSERT INTO audit_trail VALUES("3532","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-18 03:20:49","2021-06-18 03:20:49","1");
INSERT INTO audit_trail VALUES("3533","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:430","2021-06-18 09:05:16","2021-06-18 09:05:16","1");
INSERT INTO audit_trail VALUES("3534","4","PERIS  NYAMBURA MWANGI","","Added expense with id:268","2021-06-18 09:07:07","2021-06-18 09:07:07","1");
INSERT INTO audit_trail VALUES("3535","4","PERIS  NYAMBURA MWANGI","","Added expense with id:269","2021-06-18 10:02:27","2021-06-18 10:02:27","1");
INSERT INTO audit_trail VALUES("3536","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:431","2021-06-18 10:03:27","2021-06-18 10:03:27","1");
INSERT INTO audit_trail VALUES("3537","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-18 10:11:28","2021-06-18 10:11:28","1");
INSERT INTO audit_trail VALUES("3538","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-19 01:06:01","2021-06-19 01:06:01","1");
INSERT INTO audit_trail VALUES("3539","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-19 01:08:22","2021-06-19 01:08:22","1");
INSERT INTO audit_trail VALUES("3540","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:432","2021-06-19 01:23:01","2021-06-19 01:23:01","1");
INSERT INTO audit_trail VALUES("3541","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-19 04:52:45","2021-06-19 04:52:45","1");
INSERT INTO audit_trail VALUES("3542","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:433","2021-06-19 05:44:37","2021-06-19 05:44:37","1");
INSERT INTO audit_trail VALUES("3543","4","PERIS  NYAMBURA MWANGI","","Added loan with id:209","2021-06-19 05:51:25","2021-06-19 05:51:25","1");
INSERT INTO audit_trail VALUES("3544","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:209","2021-06-19 05:55:03","2021-06-19 05:55:03","1");
INSERT INTO audit_trail VALUES("3545","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:209","2021-06-19 05:57:05","2021-06-19 05:57:05","1");
INSERT INTO audit_trail VALUES("3546","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-19 06:10:19","2021-06-19 06:10:19","1");
INSERT INTO audit_trail VALUES("3547","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-19 06:11:49","2021-06-19 06:11:49","1");
INSERT INTO audit_trail VALUES("3548","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-21 02:07:07","2021-06-21 02:07:07","");
INSERT INTO audit_trail VALUES("3549","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:434","2021-06-21 02:08:41","2021-06-21 02:08:41","1");
INSERT INTO audit_trail VALUES("3550","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-21 05:13:06","2021-06-21 05:13:06","");
INSERT INTO audit_trail VALUES("3551","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-21 05:20:31","2021-06-21 05:20:31","1");
INSERT INTO audit_trail VALUES("3552","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:435","2021-06-21 06:01:21","2021-06-21 06:01:21","1");
INSERT INTO audit_trail VALUES("3553","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:436","2021-06-21 06:03:55","2021-06-21 06:03:55","1");
INSERT INTO audit_trail VALUES("3554","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:437","2021-06-21 08:41:50","2021-06-21 08:41:50","1");
INSERT INTO audit_trail VALUES("3555","2","CECILIA WANJERI WANGUHU","","Added expense with id:270","2021-06-21 08:43:04","2021-06-21 08:43:04","1");
INSERT INTO audit_trail VALUES("3556","2","CECILIA WANJERI WANGUHU","","Added expense with id:271","2021-06-21 08:44:03","2021-06-21 08:44:03","1");
INSERT INTO audit_trail VALUES("3557","2","CECILIA WANJERI WANGUHU","","Added expense with id:272","2021-06-21 08:49:55","2021-06-21 08:49:55","1");
INSERT INTO audit_trail VALUES("3558","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-21 10:13:39","2021-06-21 10:13:39","1");
INSERT INTO audit_trail VALUES("3559","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-21 10:18:02","2021-06-21 10:18:02","1");
INSERT INTO audit_trail VALUES("3560","5","HILDA WAIGWE","","Logged in to system","2021-06-22 01:29:11","2021-06-22 01:29:11","1");
INSERT INTO audit_trail VALUES("3561","5","HILDA WAIGWE","","Added Capital  with id:438","2021-06-22 01:31:51","2021-06-22 01:31:51","1");
INSERT INTO audit_trail VALUES("3562","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-22 02:23:00","2021-06-22 02:23:00","1");
INSERT INTO audit_trail VALUES("3563","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-22 02:38:49","2021-06-22 02:38:49","1");
INSERT INTO audit_trail VALUES("3564","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:439","2021-06-22 06:41:49","2021-06-22 06:41:49","1");
INSERT INTO audit_trail VALUES("3565","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:440","2021-06-22 06:42:30","2021-06-22 06:42:30","1");
INSERT INTO audit_trail VALUES("3566","1","Admin Admin","","Logged in to system","2021-06-22 06:59:16","2021-06-22 06:59:16","");
INSERT INTO audit_trail VALUES("3567","1","Admin Admin","","Logged in to system","2021-06-22 06:59:24","2021-06-22 06:59:24","");
INSERT INTO audit_trail VALUES("3568","5","HILDA WAIGWE","","Added Capital  with id:441","2021-06-22 08:39:55","2021-06-22 08:39:55","1");
INSERT INTO audit_trail VALUES("3569","5","HILDA WAIGWE","","Logged out of system","2021-06-22 10:10:18","2021-06-22 10:10:18","1");
INSERT INTO audit_trail VALUES("3570","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-22 10:15:19","2021-06-22 10:15:19","1");
INSERT INTO audit_trail VALUES("3571","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-06-23 01:35:08","2021-06-23 01:35:08","1");
INSERT INTO audit_trail VALUES("3572","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-23 01:44:35","2021-06-23 01:44:35","1");
INSERT INTO audit_trail VALUES("3573","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:442","2021-06-23 02:16:50","2021-06-23 02:16:50","1");
INSERT INTO audit_trail VALUES("3574","4","PERIS  NYAMBURA MWANGI","","Added expense with id:273","2021-06-23 02:22:18","2021-06-23 02:22:18","1");
INSERT INTO audit_trail VALUES("3575","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-23 02:35:15","2021-06-23 02:35:15","");
INSERT INTO audit_trail VALUES("3576","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:443","2021-06-23 07:29:01","2021-06-23 07:29:01","1");
INSERT INTO audit_trail VALUES("3577","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:444","2021-06-23 07:30:03","2021-06-23 07:30:03","1");
INSERT INTO audit_trail VALUES("3578","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:445","2021-06-23 08:43:44","2021-06-23 08:43:44","1");
INSERT INTO audit_trail VALUES("3579","2","CECILIA WANJERI WANGUHU","","Added expense with id:274","2021-06-23 09:34:31","2021-06-23 09:34:31","1");
INSERT INTO audit_trail VALUES("3580","2","CECILIA WANJERI WANGUHU","","Added expense with id:275","2021-06-23 09:35:58","2021-06-23 09:35:58","1");
INSERT INTO audit_trail VALUES("3581","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:446","2021-06-23 10:08:09","2021-06-23 10:08:09","1");
INSERT INTO audit_trail VALUES("3582","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-23 10:17:02","2021-06-23 10:17:02","1");
INSERT INTO audit_trail VALUES("3583","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:447","2021-06-24 01:45:10","2021-06-24 01:45:10","1");
INSERT INTO audit_trail VALUES("3584","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:20265","2021-06-24 01:51:38","2021-06-24 01:51:38","1");
INSERT INTO audit_trail VALUES("3585","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-24 01:54:10","2021-06-24 01:54:10","1");
INSERT INTO audit_trail VALUES("3586","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-24 02:23:54","2021-06-24 02:23:54","1");
INSERT INTO audit_trail VALUES("3587","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:448","2021-06-24 08:10:20","2021-06-24 08:10:20","1");
INSERT INTO audit_trail VALUES("3588","2","CECILIA WANJERI WANGUHU","","Added expense with id:276","2021-06-24 08:12:39","2021-06-24 08:12:39","1");
INSERT INTO audit_trail VALUES("3589","4","PERIS  NYAMBURA MWANGI","","Added expense with id:277","2021-06-24 09:06:03","2021-06-24 09:06:03","1");
INSERT INTO audit_trail VALUES("3590","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-06-24 10:05:32","2021-06-24 10:05:32","1");
INSERT INTO audit_trail VALUES("3591","5","HILDA WAIGWE","","Logged in to system","2021-06-24 10:06:48","2021-06-24 10:06:48","1");
INSERT INTO audit_trail VALUES("3592","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-24 10:11:24","2021-06-24 10:11:24","1");
INSERT INTO audit_trail VALUES("3593","5","HILDA WAIGWE","","Added Capital  with id:449","2021-06-25 02:14:18","2021-06-25 02:14:18","1");
INSERT INTO audit_trail VALUES("3594","5","HILDA WAIGWE","","Added Capital  with id:450","2021-06-25 02:33:14","2021-06-25 02:33:14","1");
INSERT INTO audit_trail VALUES("3595","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-25 02:40:35","2021-06-25 02:40:35","1");
INSERT INTO audit_trail VALUES("3596","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-25 02:40:53","2021-06-25 02:40:53","1");
INSERT INTO audit_trail VALUES("3597","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-25 03:22:42","2021-06-25 03:22:42","");
INSERT INTO audit_trail VALUES("3598","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-25 03:29:25","2021-06-25 03:29:25","1");
INSERT INTO audit_trail VALUES("3599","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:636","2021-06-25 04:30:47","2021-06-25 04:30:47","1");
INSERT INTO audit_trail VALUES("3600","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-25 10:29:24","2021-06-25 10:29:24","1");
INSERT INTO audit_trail VALUES("3601","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-26 01:29:12","2021-06-26 01:29:12","1");
INSERT INTO audit_trail VALUES("3602","5","HILDA WAIGWE","","Added Capital  with id:451","2021-06-26 01:37:03","2021-06-26 01:37:03","1");
INSERT INTO audit_trail VALUES("3603","5","HILDA WAIGWE","","Added loan with id:210","2021-06-26 03:20:47","2021-06-26 03:20:47","1");
INSERT INTO audit_trail VALUES("3604","5","HILDA WAIGWE","","Approved loan with id:210","2021-06-26 03:23:10","2021-06-26 03:23:10","1");
INSERT INTO audit_trail VALUES("3605","5","HILDA WAIGWE","","Disbursed loan with id:210","2021-06-26 03:23:39","2021-06-26 03:23:39","1");
INSERT INTO audit_trail VALUES("3606","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20458","2021-06-26 03:46:24","2021-06-26 03:46:24","1");
INSERT INTO audit_trail VALUES("3607","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20461","2021-06-26 03:53:38","2021-06-26 03:53:38","1");
INSERT INTO audit_trail VALUES("3608","5","HILDA WAIGWE","","Added loan with id:211","2021-06-26 04:08:31","2021-06-26 04:08:31","1");
INSERT INTO audit_trail VALUES("3609","5","HILDA WAIGWE","","Approved loan with id:211","2021-06-26 04:09:21","2021-06-26 04:09:21","1");
INSERT INTO audit_trail VALUES("3610","5","HILDA WAIGWE","","Updated loan with id:211","2021-06-26 04:11:39","2021-06-26 04:11:39","1");
INSERT INTO audit_trail VALUES("3611","5","HILDA WAIGWE","","Disbursed loan with id:211","2021-06-26 04:12:10","2021-06-26 04:12:10","1");
INSERT INTO audit_trail VALUES("3612","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20476","2021-06-26 04:16:48","2021-06-26 04:16:48","1");
INSERT INTO audit_trail VALUES("3613","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-26 04:29:39","2021-06-26 04:29:39","1");
INSERT INTO audit_trail VALUES("3614","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-26 04:29:42","2021-06-26 04:29:42","1");
INSERT INTO audit_trail VALUES("3615","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-26 05:08:00","2021-06-26 05:08:00","1");
INSERT INTO audit_trail VALUES("3616","5","HILDA WAIGWE","","Added Capital  with id:452","2021-06-26 05:29:21","2021-06-26 05:29:21","1");
INSERT INTO audit_trail VALUES("3617","5","HILDA WAIGWE","","Added Capital  with id:453","2021-06-26 05:30:39","2021-06-26 05:30:39","1");
INSERT INTO audit_trail VALUES("3618","5","HILDA WAIGWE","","Added expense with id:278","2021-06-26 05:32:06","2021-06-26 05:32:06","1");
INSERT INTO audit_trail VALUES("3619","5","HILDA WAIGWE","","Added expense with id:279","2021-06-26 05:33:33","2021-06-26 05:33:33","1");
INSERT INTO audit_trail VALUES("3620","5","HILDA WAIGWE","","Added expense with id:280","2021-06-26 06:00:02","2021-06-26 06:00:02","1");
INSERT INTO audit_trail VALUES("3621","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-26 06:13:50","2021-06-26 06:13:50","");
INSERT INTO audit_trail VALUES("3622","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-26 06:15:40","2021-06-26 06:15:40","1");
INSERT INTO audit_trail VALUES("3623","5","HILDA WAIGWE","","Logged in to system","2021-06-28 01:27:00","2021-06-28 01:27:00","");
INSERT INTO audit_trail VALUES("3624","5","HILDA WAIGWE","","Added Capital  with id:454","2021-06-28 01:34:27","2021-06-28 01:34:27","1");
INSERT INTO audit_trail VALUES("3625","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-28 01:47:57","2021-06-28 01:47:57","");
INSERT INTO audit_trail VALUES("3626","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-28 02:23:25","2021-06-28 02:23:25","1");
INSERT INTO audit_trail VALUES("3627","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-28 05:02:29","2021-06-28 05:02:29","1");
INSERT INTO audit_trail VALUES("3628","5","HILDA WAIGWE","","Added expense with id:281","2021-06-28 09:40:08","2021-06-28 09:40:08","1");
INSERT INTO audit_trail VALUES("3629","5","HILDA WAIGWE","","Added Capital  with id:455","2021-06-28 09:42:08","2021-06-28 09:42:08","1");
INSERT INTO audit_trail VALUES("3630","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-28 10:14:40","2021-06-28 10:14:40","1");
INSERT INTO audit_trail VALUES("3631","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-29 01:02:17","2021-06-29 01:02:17","1");
INSERT INTO audit_trail VALUES("3632","5","HILDA WAIGWE","","Added Capital  with id:456","2021-06-29 01:12:20","2021-06-29 01:12:20","1");
INSERT INTO audit_trail VALUES("3633","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-29 01:24:17","2021-06-29 01:24:17","");
INSERT INTO audit_trail VALUES("3634","5","HILDA WAIGWE","","Added expense with id:282","2021-06-29 09:55:13","2021-06-29 09:55:13","1");
INSERT INTO audit_trail VALUES("3635","5","HILDA WAIGWE","","Added expense with id:283","2021-06-29 09:56:04","2021-06-29 09:56:04","1");
INSERT INTO audit_trail VALUES("3636","5","HILDA WAIGWE","","Added Capital  with id:457","2021-06-29 09:58:17","2021-06-29 09:58:17","1");
INSERT INTO audit_trail VALUES("3637","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-29 10:33:17","2021-06-29 10:33:17","1");
INSERT INTO audit_trail VALUES("3638","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-30 01:45:02","2021-06-30 01:45:02","1");
INSERT INTO audit_trail VALUES("3639","5","HILDA WAIGWE","","Added Capital  with id:458","2021-06-30 02:22:34","2021-06-30 02:22:34","1");
INSERT INTO audit_trail VALUES("3640","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-30 02:45:03","2021-06-30 02:45:03","");
INSERT INTO audit_trail VALUES("3641","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-30 03:24:41","2021-06-30 03:24:41","1");
INSERT INTO audit_trail VALUES("3642","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-30 03:54:39","2021-06-30 03:54:39","1");
INSERT INTO audit_trail VALUES("3643","5","HILDA WAIGWE","","Added Capital  with id:459","2021-06-30 05:07:18","2021-06-30 05:07:18","1");
INSERT INTO audit_trail VALUES("3644","5","HILDA WAIGWE","","Added Capital  with id:460","2021-06-30 05:15:07","2021-06-30 05:15:07","1");
INSERT INTO audit_trail VALUES("3645","5","HILDA WAIGWE","","Added Capital  with id:461","2021-06-30 05:17:20","2021-06-30 05:17:20","1");
INSERT INTO audit_trail VALUES("3646","5","HILDA WAIGWE","","Added Capital  with id:462","2021-06-30 05:18:13","2021-06-30 05:18:13","1");
INSERT INTO audit_trail VALUES("3647","5","HILDA WAIGWE","","Updated Capital  with id:461","2021-06-30 05:19:04","2021-06-30 05:19:04","1");
INSERT INTO audit_trail VALUES("3648","5","HILDA WAIGWE","","Added Capital  with id:463","2021-06-30 05:20:00","2021-06-30 05:20:00","1");
INSERT INTO audit_trail VALUES("3649","5","HILDA WAIGWE","","Updated Capital  with id:462","2021-06-30 05:20:40","2021-06-30 05:20:40","1");
INSERT INTO audit_trail VALUES("3650","5","HILDA WAIGWE","","Added Capital  with id:464","2021-06-30 05:21:36","2021-06-30 05:21:36","1");
INSERT INTO audit_trail VALUES("3651","5","HILDA WAIGWE","","Added Capital  with id:465","2021-06-30 05:22:22","2021-06-30 05:22:22","1");
INSERT INTO audit_trail VALUES("3652","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20832","2021-06-30 05:24:48","2021-06-30 05:24:48","1");
INSERT INTO audit_trail VALUES("3653","5","HILDA WAIGWE","","Added expense with id:284","2021-06-30 05:26:53","2021-06-30 05:26:53","1");
INSERT INTO audit_trail VALUES("3654","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20836","2021-06-30 05:31:40","2021-06-30 05:31:40","1");
INSERT INTO audit_trail VALUES("3655","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20838","2021-06-30 05:33:49","2021-06-30 05:33:49","1");
INSERT INTO audit_trail VALUES("3656","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20840","2021-06-30 05:35:07","2021-06-30 05:35:07","1");
INSERT INTO audit_trail VALUES("3657","5","HILDA WAIGWE","","Added Journal Manual Entry  with id:20842","2021-06-30 05:41:10","2021-06-30 05:41:10","1");
INSERT INTO audit_trail VALUES("3658","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-06-30 06:59:37","2021-06-30 06:59:37","1");
INSERT INTO audit_trail VALUES("3659","2","CECILIA WANJERI WANGUHU","","Added expense with id:285","2021-06-30 10:07:01","2021-06-30 10:07:01","1");
INSERT INTO audit_trail VALUES("3660","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-06-30 10:22:01","2021-06-30 10:22:01","1");
INSERT INTO audit_trail VALUES("3661","5","HILDA WAIGWE","","Logged out of system","2021-06-30 10:22:18","2021-06-30 10:22:18","1");
INSERT INTO audit_trail VALUES("3662","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-01 01:38:34","2021-07-01 01:38:34","1");
INSERT INTO audit_trail VALUES("3663","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-01 01:41:04","2021-07-01 01:41:04","");
INSERT INTO audit_trail VALUES("3664","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:466","2021-07-01 02:40:09","2021-07-01 02:40:09","1");
INSERT INTO audit_trail VALUES("3665","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-01 02:59:29","2021-07-01 02:59:29","1");
INSERT INTO audit_trail VALUES("3666","4","PERIS  NYAMBURA MWANGI","","Added expense with id:286","2021-07-01 09:24:08","2021-07-01 09:24:08","1");
INSERT INTO audit_trail VALUES("3667","4","PERIS  NYAMBURA MWANGI","","Added expense with id:287","2021-07-01 09:25:56","2021-07-01 09:25:56","1");
INSERT INTO audit_trail VALUES("3668","4","PERIS  NYAMBURA MWANGI","","Added expense with id:288","2021-07-01 09:27:57","2021-07-01 09:27:57","1");
INSERT INTO audit_trail VALUES("3669","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:467","2021-07-01 09:29:08","2021-07-01 09:29:08","1");
INSERT INTO audit_trail VALUES("3670","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:468","2021-07-01 09:30:34","2021-07-01 09:30:34","1");
INSERT INTO audit_trail VALUES("3671","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-01 10:39:21","2021-07-01 10:39:21","1");
INSERT INTO audit_trail VALUES("3672","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-01 10:44:53","2021-07-01 10:44:53","1");
INSERT INTO audit_trail VALUES("3673","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-02 01:09:09","2021-07-02 01:09:09","1");
INSERT INTO audit_trail VALUES("3674","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-02 02:24:25","2021-07-02 02:24:25","1");
INSERT INTO audit_trail VALUES("3675","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:469","2021-07-02 03:05:11","2021-07-02 03:05:11","1");
INSERT INTO audit_trail VALUES("3676","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:470","2021-07-02 04:34:52","2021-07-02 04:34:52","1");
INSERT INTO audit_trail VALUES("3677","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-02 04:54:12","2021-07-02 04:54:12","");
INSERT INTO audit_trail VALUES("3678","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:57","2021-07-02 05:28:09","2021-07-02 05:28:09","1");
INSERT INTO audit_trail VALUES("3679","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:57","2021-07-02 05:28:52","2021-07-02 05:28:52","1");
INSERT INTO audit_trail VALUES("3680","2","CECILIA WANJERI WANGUHU","","Updated loan with id:57","2021-07-02 05:30:26","2021-07-02 05:30:26","1");
INSERT INTO audit_trail VALUES("3681","2","CECILIA WANJERI WANGUHU","","Approved loan with id:57","2021-07-02 05:31:35","2021-07-02 05:31:35","1");
INSERT INTO audit_trail VALUES("3682","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:57","2021-07-02 05:32:03","2021-07-02 05:32:03","1");
INSERT INTO audit_trail VALUES("3683","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:471","2021-07-02 07:02:41","2021-07-02 07:02:41","1");
INSERT INTO audit_trail VALUES("3684","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:472","2021-07-02 07:10:42","2021-07-02 07:10:42","1");
INSERT INTO audit_trail VALUES("3685","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:472","2021-07-02 07:12:44","2021-07-02 07:12:44","1");
INSERT INTO audit_trail VALUES("3686","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:473","2021-07-02 07:13:58","2021-07-02 07:13:58","1");
INSERT INTO audit_trail VALUES("3687","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:474","2021-07-02 07:17:37","2021-07-02 07:17:37","1");
INSERT INTO audit_trail VALUES("3688","4","PERIS  NYAMBURA MWANGI","","Added expense with id:289","2021-07-02 10:17:47","2021-07-02 10:17:47","1");
INSERT INTO audit_trail VALUES("3689","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-02 10:20:06","2021-07-02 10:20:06","1");
INSERT INTO audit_trail VALUES("3690","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-02 10:20:40","2021-07-02 10:20:40","1");
INSERT INTO audit_trail VALUES("3691","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-03 01:24:05","2021-07-03 01:24:05","1");
INSERT INTO audit_trail VALUES("3692","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-03 01:39:16","2021-07-03 01:39:16","1");
INSERT INTO audit_trail VALUES("3693","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:475","2021-07-03 01:41:15","2021-07-03 01:41:15","1");
INSERT INTO audit_trail VALUES("3694","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:476","2021-07-03 03:56:04","2021-07-03 03:56:04","1");
INSERT INTO audit_trail VALUES("3695","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21312","2021-07-03 05:07:45","2021-07-03 05:07:45","1");
INSERT INTO audit_trail VALUES("3696","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:477","2021-07-03 06:08:06","2021-07-03 06:08:06","1");
INSERT INTO audit_trail VALUES("3697","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-03 06:17:13","2021-07-03 06:17:13","1");
INSERT INTO audit_trail VALUES("3698","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-03 06:20:33","2021-07-03 06:20:33","1");
INSERT INTO audit_trail VALUES("3699","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-03 07:43:45","2021-07-03 07:43:45","1");
INSERT INTO audit_trail VALUES("3700","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-03 10:25:07","2021-07-03 10:25:07","1");
INSERT INTO audit_trail VALUES("3701","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-05 02:32:32","2021-07-05 02:32:32","");
INSERT INTO audit_trail VALUES("3702","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21352","2021-07-05 03:06:52","2021-07-05 03:06:52","1");
INSERT INTO audit_trail VALUES("3703","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21354","2021-07-05 03:17:29","2021-07-05 03:17:29","1");
INSERT INTO audit_trail VALUES("3704","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-05 03:25:40","2021-07-05 03:25:40","");
INSERT INTO audit_trail VALUES("3705","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:478","2021-07-05 03:27:35","2021-07-05 03:27:35","1");
INSERT INTO audit_trail VALUES("3706","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21361","2021-07-05 03:34:05","2021-07-05 03:34:05","1");
INSERT INTO audit_trail VALUES("3707","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21364","2021-07-05 03:38:01","2021-07-05 03:38:01","1");
INSERT INTO audit_trail VALUES("3708","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21367","2021-07-05 03:41:18","2021-07-05 03:41:18","1");
INSERT INTO audit_trail VALUES("3709","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21370","2021-07-05 03:44:06","2021-07-05 03:44:06","1");
INSERT INTO audit_trail VALUES("3710","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21373","2021-07-05 03:46:35","2021-07-05 03:46:35","1");
INSERT INTO audit_trail VALUES("3711","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21376","2021-07-05 03:50:51","2021-07-05 03:50:51","1");
INSERT INTO audit_trail VALUES("3712","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-05 04:09:36","2021-07-05 04:09:36","");
INSERT INTO audit_trail VALUES("3713","2","CECILIA WANJERI WANGUHU","","Added expense with id:290","2021-07-05 04:13:23","2021-07-05 04:13:23","1");
INSERT INTO audit_trail VALUES("3714","2","CECILIA WANJERI WANGUHU","","Added expense with id:291","2021-07-05 04:35:46","2021-07-05 04:35:46","1");
INSERT INTO audit_trail VALUES("3715","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:479","2021-07-05 05:51:18","2021-07-05 05:51:18","1");
INSERT INTO audit_trail VALUES("3716","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:480","2021-07-05 05:52:45","2021-07-05 05:52:45","1");
INSERT INTO audit_trail VALUES("3717","2","CECILIA WANJERI WANGUHU","","Added expense with id:292","2021-07-05 08:54:24","2021-07-05 08:54:24","1");
INSERT INTO audit_trail VALUES("3718","2","CECILIA WANJERI WANGUHU","","Added expense with id:293","2021-07-05 08:55:22","2021-07-05 08:55:22","1");
INSERT INTO audit_trail VALUES("3719","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-05 09:23:31","2021-07-05 09:23:31","");
INSERT INTO audit_trail VALUES("3720","4","PERIS  NYAMBURA MWANGI","","Added loan with id:212","2021-07-05 10:00:07","2021-07-05 10:00:07","1");
INSERT INTO audit_trail VALUES("3721","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:212","2021-07-05 10:00:33","2021-07-05 10:00:33","1");
INSERT INTO audit_trail VALUES("3722","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:212","2021-07-05 10:00:52","2021-07-05 10:00:52","1");
INSERT INTO audit_trail VALUES("3723","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-05 10:08:02","2021-07-05 10:08:02","1");
INSERT INTO audit_trail VALUES("3724","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-05 10:09:50","2021-07-05 10:09:50","1");
INSERT INTO audit_trail VALUES("3725","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-06 01:59:41","2021-07-06 01:59:41","1");
INSERT INTO audit_trail VALUES("3726","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-06 02:01:37","2021-07-06 02:01:37","1");
INSERT INTO audit_trail VALUES("3727","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:481","2021-07-06 02:04:39","2021-07-06 02:04:39","1");
INSERT INTO audit_trail VALUES("3728","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-06 04:18:51","2021-07-06 04:18:51","");
INSERT INTO audit_trail VALUES("3729","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-06 04:56:51","2021-07-06 04:56:51","1");
INSERT INTO audit_trail VALUES("3730","1","Admin Admin","","Logged in to system","2021-07-06 04:58:43","2021-07-06 04:58:43","");
INSERT INTO audit_trail VALUES("3731","1","Admin Admin","","Updated Settings","2021-07-06 05:54:13","2021-07-06 05:54:13","1");
INSERT INTO audit_trail VALUES("3732","1","Admin Admin","","Updated Settings","2021-07-06 05:54:21","2021-07-06 05:54:21","1");
INSERT INTO audit_trail VALUES("3733","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:21525","2021-07-06 06:04:05","2021-07-06 06:04:05","1");
INSERT INTO audit_trail VALUES("3734","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:21527","2021-07-06 06:07:50","2021-07-06 06:07:50","1");
INSERT INTO audit_trail VALUES("3735","1","Admin Admin","","Logged in to system","2021-07-06 06:33:53","2021-07-06 06:33:53","");
INSERT INTO audit_trail VALUES("3736","1","Admin Admin","","Updated Settings","2021-07-06 06:40:25","2021-07-06 06:40:25","1");
INSERT INTO audit_trail VALUES("3737","1","Admin Admin","","Logged out of system","2021-07-06 06:46:54","2021-07-06 06:46:54","1");
INSERT INTO audit_trail VALUES("3738","1","Admin Admin","","Logged in to system","2021-07-06 06:53:36","2021-07-06 06:53:36","1");
INSERT INTO audit_trail VALUES("3739","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:482","2021-07-06 08:25:02","2021-07-06 08:25:02","1");
INSERT INTO audit_trail VALUES("3740","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:483","2021-07-06 08:35:11","2021-07-06 08:35:11","1");
INSERT INTO audit_trail VALUES("3741","2","CECILIA WANJERI WANGUHU","","Added expense with id:294","2021-07-06 09:29:55","2021-07-06 09:29:55","1");
INSERT INTO audit_trail VALUES("3742","2","CECILIA WANJERI WANGUHU","","Added expense with id:295","2021-07-06 09:32:51","2021-07-06 09:32:51","1");
INSERT INTO audit_trail VALUES("3743","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:484","2021-07-06 09:57:13","2021-07-06 09:57:13","1");
INSERT INTO audit_trail VALUES("3744","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-06 10:18:30","2021-07-06 10:18:30","1");
INSERT INTO audit_trail VALUES("3745","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-06 10:18:38","2021-07-06 10:18:38","1");
INSERT INTO audit_trail VALUES("3746","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-07 01:24:17","2021-07-07 01:24:17","1");
INSERT INTO audit_trail VALUES("3747","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-07 01:36:15","2021-07-07 01:36:15","1");
INSERT INTO audit_trail VALUES("3748","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:485","2021-07-07 01:37:49","2021-07-07 01:37:49","1");
INSERT INTO audit_trail VALUES("3749","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-07 02:13:50","2021-07-07 02:13:50","");
INSERT INTO audit_trail VALUES("3750","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-07 04:05:31","2021-07-07 04:05:31","");
INSERT INTO audit_trail VALUES("3751","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-07 05:56:42","2021-07-07 05:56:42","1");
INSERT INTO audit_trail VALUES("3752","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-07 05:57:11","2021-07-07 05:57:11","1");
INSERT INTO audit_trail VALUES("3753","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-07 06:19:30","2021-07-07 06:19:30","1");
INSERT INTO audit_trail VALUES("3754","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:486","2021-07-07 08:07:44","2021-07-07 08:07:44","1");
INSERT INTO audit_trail VALUES("3755","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-07 10:11:04","2021-07-07 10:11:04","1");
INSERT INTO audit_trail VALUES("3756","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-08 01:17:22","2021-07-08 01:17:22","1");
INSERT INTO audit_trail VALUES("3757","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:487","2021-07-08 01:19:02","2021-07-08 01:19:02","1");
INSERT INTO audit_trail VALUES("3758","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:488","2021-07-08 07:45:02","2021-07-08 07:45:02","1");
INSERT INTO audit_trail VALUES("3759","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:489","2021-07-08 07:46:02","2021-07-08 07:46:02","1");
INSERT INTO audit_trail VALUES("3760","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:490","2021-07-08 07:47:46","2021-07-08 07:47:46","1");
INSERT INTO audit_trail VALUES("3761","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-08 08:49:33","2021-07-08 08:49:33","");
INSERT INTO audit_trail VALUES("3762","4","PERIS  NYAMBURA MWANGI","","Added expense with id:296","2021-07-08 10:13:09","2021-07-08 10:13:09","1");
INSERT INTO audit_trail VALUES("3763","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-08 10:14:27","2021-07-08 10:14:27","1");
INSERT INTO audit_trail VALUES("3764","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-08 10:18:45","2021-07-08 10:18:45","1");
INSERT INTO audit_trail VALUES("3765","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-09 01:21:02","2021-07-09 01:21:02","1");
INSERT INTO audit_trail VALUES("3766","2","CECILIA WANJERI WANGUHU","","Added loan with id:213","2021-07-09 01:37:06","2021-07-09 01:37:06","1");
INSERT INTO audit_trail VALUES("3767","2","CECILIA WANJERI WANGUHU","","Approved loan with id:213","2021-07-09 01:37:54","2021-07-09 01:37:54","1");
INSERT INTO audit_trail VALUES("3768","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:213","2021-07-09 01:38:13","2021-07-09 01:38:13","1");
INSERT INTO audit_trail VALUES("3769","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-09 01:42:07","2021-07-09 01:42:07","1");
INSERT INTO audit_trail VALUES("3770","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-09 01:46:55","2021-07-09 01:46:55","1");
INSERT INTO audit_trail VALUES("3771","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:491","2021-07-09 01:48:22","2021-07-09 01:48:22","1");
INSERT INTO audit_trail VALUES("3772","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21813","2021-07-09 01:55:54","2021-07-09 01:55:54","1");
INSERT INTO audit_trail VALUES("3773","4","PERIS  NYAMBURA MWANGI","","Updated loan with id:205","2021-07-09 02:01:38","2021-07-09 02:01:38","1");
INSERT INTO audit_trail VALUES("3774","2","CECILIA WANJERI WANGUHU","","Added loan with id:214","2021-07-09 02:03:18","2021-07-09 02:03:18","1");
INSERT INTO audit_trail VALUES("3775","2","CECILIA WANJERI WANGUHU","","Approved loan with id:214","2021-07-09 02:04:12","2021-07-09 02:04:12","1");
INSERT INTO audit_trail VALUES("3776","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:214","2021-07-09 02:05:28","2021-07-09 02:05:28","1");
INSERT INTO audit_trail VALUES("3777","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21820","2021-07-09 02:10:19","2021-07-09 02:10:19","1");
INSERT INTO audit_trail VALUES("3778","2","CECILIA WANJERI WANGUHU","","Added loan with id:215","2021-07-09 02:13:47","2021-07-09 02:13:47","1");
INSERT INTO audit_trail VALUES("3779","4","PERIS  NYAMBURA MWANGI","","Updated loan with id:205","2021-07-09 02:15:49","2021-07-09 02:15:49","1");
INSERT INTO audit_trail VALUES("3780","2","CECILIA WANJERI WANGUHU","","Approved loan with id:215","2021-07-09 02:17:25","2021-07-09 02:17:25","1");
INSERT INTO audit_trail VALUES("3781","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:215","2021-07-09 02:21:19","2021-07-09 02:21:19","1");
INSERT INTO audit_trail VALUES("3782","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:21827","2021-07-09 02:31:38","2021-07-09 02:31:38","1");
INSERT INTO audit_trail VALUES("3783","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-09 02:52:41","2021-07-09 02:52:41","1");
INSERT INTO audit_trail VALUES("3784","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:492","2021-07-09 06:47:55","2021-07-09 06:47:55","1");
INSERT INTO audit_trail VALUES("3785","2","CECILIA WANJERI WANGUHU","","Added expense with id:297","2021-07-09 09:43:07","2021-07-09 09:43:07","1");
INSERT INTO audit_trail VALUES("3786","2","CECILIA WANJERI WANGUHU","","Added expense with id:298","2021-07-09 09:44:12","2021-07-09 09:44:12","1");
INSERT INTO audit_trail VALUES("3787","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:493","2021-07-09 09:46:01","2021-07-09 09:46:01","1");
INSERT INTO audit_trail VALUES("3788","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-09 10:02:13","2021-07-09 10:02:13","1");
INSERT INTO audit_trail VALUES("3789","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-09 10:03:18","2021-07-09 10:03:18","1");
INSERT INTO audit_trail VALUES("3790","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-10 01:49:00","2021-07-10 01:49:00","");
INSERT INTO audit_trail VALUES("3791","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-10 02:00:44","2021-07-10 02:00:44","1");
INSERT INTO audit_trail VALUES("3792","4","PERIS  NYAMBURA MWANGI","","Added expense with id:299","2021-07-10 02:04:23","2021-07-10 02:04:23","1");
INSERT INTO audit_trail VALUES("3793","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:494","2021-07-10 02:14:38","2021-07-10 02:14:38","1");
INSERT INTO audit_trail VALUES("3794","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-10 02:56:25","2021-07-10 02:56:25","1");
INSERT INTO audit_trail VALUES("3795","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:495","2021-07-10 02:58:25","2021-07-10 02:58:25","1");
INSERT INTO audit_trail VALUES("3796","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:496","2021-07-10 03:36:42","2021-07-10 03:36:42","1");
INSERT INTO audit_trail VALUES("3797","4","PERIS  NYAMBURA MWANGI","","Added expense with id:300","2021-07-10 04:52:39","2021-07-10 04:52:39","1");
INSERT INTO audit_trail VALUES("3798","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-10 06:07:09","2021-07-10 06:07:09","1");
INSERT INTO audit_trail VALUES("3799","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-10 06:07:31","2021-07-10 06:07:31","1");
INSERT INTO audit_trail VALUES("3800","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-10 06:12:37","2021-07-10 06:12:37","1");
INSERT INTO audit_trail VALUES("3801","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-12 02:09:13","2021-07-12 02:09:13","");
INSERT INTO audit_trail VALUES("3802","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-12 02:12:15","2021-07-12 02:12:15","");
INSERT INTO audit_trail VALUES("3803","2","CECILIA WANJERI WANGUHU","","Added loan with id:216","2021-07-12 02:12:25","2021-07-12 02:12:25","1");
INSERT INTO audit_trail VALUES("3804","2","CECILIA WANJERI WANGUHU","","Approved loan with id:216","2021-07-12 02:13:21","2021-07-12 02:13:21","1");
INSERT INTO audit_trail VALUES("3805","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:216","2021-07-12 02:13:34","2021-07-12 02:13:34","1");
INSERT INTO audit_trail VALUES("3806","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:497","2021-07-12 02:14:32","2021-07-12 02:14:32","1");
INSERT INTO audit_trail VALUES("3807","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22055","2021-07-12 02:24:24","2021-07-12 02:24:24","1");
INSERT INTO audit_trail VALUES("3808","2","CECILIA WANJERI WANGUHU","","Added loan with id:217","2021-07-12 02:26:02","2021-07-12 02:26:02","1");
INSERT INTO audit_trail VALUES("3809","2","CECILIA WANJERI WANGUHU","","Approved loan with id:217","2021-07-12 02:26:45","2021-07-12 02:26:45","1");
INSERT INTO audit_trail VALUES("3810","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:217","2021-07-12 02:26:59","2021-07-12 02:26:59","1");
INSERT INTO audit_trail VALUES("3811","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22061","2021-07-12 02:31:41","2021-07-12 02:31:41","1");
INSERT INTO audit_trail VALUES("3812","2","CECILIA WANJERI WANGUHU","","Added loan with id:218","2021-07-12 02:36:22","2021-07-12 02:36:22","1");
INSERT INTO audit_trail VALUES("3813","2","CECILIA WANJERI WANGUHU","","Approved loan with id:218","2021-07-12 02:36:39","2021-07-12 02:36:39","1");
INSERT INTO audit_trail VALUES("3814","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:218","2021-07-12 02:36:57","2021-07-12 02:36:57","1");
INSERT INTO audit_trail VALUES("3815","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22067","2021-07-12 02:47:29","2021-07-12 02:47:29","1");
INSERT INTO audit_trail VALUES("3816","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22069","2021-07-12 02:56:16","2021-07-12 02:56:16","1");
INSERT INTO audit_trail VALUES("3817","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-12 04:39:27","2021-07-12 04:39:27","");
INSERT INTO audit_trail VALUES("3818","2","CECILIA WANJERI WANGUHU","","Added expense with id:301","2021-07-12 08:39:15","2021-07-12 08:39:15","1");
INSERT INTO audit_trail VALUES("3819","2","CECILIA WANJERI WANGUHU","","Added expense with id:302","2021-07-12 08:45:55","2021-07-12 08:45:55","1");
INSERT INTO audit_trail VALUES("3820","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-12 10:02:18","2021-07-12 10:02:18","1");
INSERT INTO audit_trail VALUES("3821","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:498","2021-07-13 01:43:48","2021-07-13 01:43:48","1");
INSERT INTO audit_trail VALUES("3822","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-13 02:02:56","2021-07-13 02:02:56","1");
INSERT INTO audit_trail VALUES("3823","4","PERIS  NYAMBURA MWANGI","","Updated Capital  with id:498","2021-07-13 04:30:36","2021-07-13 04:30:36","1");
INSERT INTO audit_trail VALUES("3824","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22135","2021-07-13 04:40:09","2021-07-13 04:40:09","1");
INSERT INTO audit_trail VALUES("3825","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22139","2021-07-13 04:47:12","2021-07-13 04:47:12","1");
INSERT INTO audit_trail VALUES("3826","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22151","2021-07-13 05:36:36","2021-07-13 05:36:36","1");
INSERT INTO audit_trail VALUES("3827","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22153","2021-07-13 05:38:59","2021-07-13 05:38:59","1");
INSERT INTO audit_trail VALUES("3828","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22155","2021-07-13 05:57:19","2021-07-13 05:57:19","1");
INSERT INTO audit_trail VALUES("3829","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22157","2021-07-13 06:00:45","2021-07-13 06:00:45","1");
INSERT INTO audit_trail VALUES("3830","1","Admin Admin","","Logged in to system","2021-07-13 08:51:46","2021-07-13 08:51:46","");
INSERT INTO audit_trail VALUES("3831","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-13 09:18:51","2021-07-13 09:18:51","");
INSERT INTO audit_trail VALUES("3832","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-13 09:19:24","2021-07-13 09:19:24","");
INSERT INTO audit_trail VALUES("3833","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:499","2021-07-13 09:31:01","2021-07-13 09:31:01","1");
INSERT INTO audit_trail VALUES("3834","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-13 10:02:57","2021-07-13 10:02:57","1");
INSERT INTO audit_trail VALUES("3835","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-13 10:04:31","2021-07-13 10:04:31","1");
INSERT INTO audit_trail VALUES("3836","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-13 10:04:59","2021-07-13 10:04:59","1");
INSERT INTO audit_trail VALUES("3837","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-13 10:05:09","2021-07-13 10:05:09","1");
INSERT INTO audit_trail VALUES("3838","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-13 10:05:18","2021-07-13 10:05:18","1");
INSERT INTO audit_trail VALUES("3839","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-13 10:05:49","2021-07-13 10:05:49","1");
INSERT INTO audit_trail VALUES("3840","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-14 01:17:27","2021-07-14 01:17:27","1");
INSERT INTO audit_trail VALUES("3841","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:500","2021-07-14 01:19:17","2021-07-14 01:19:17","1");
INSERT INTO audit_trail VALUES("3842","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-14 02:22:55","2021-07-14 02:22:55","1");
INSERT INTO audit_trail VALUES("3843","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-14 02:37:10","2021-07-14 02:37:10","1");
INSERT INTO audit_trail VALUES("3844","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22200","2021-07-14 04:36:52","2021-07-14 04:36:52","1");
INSERT INTO audit_trail VALUES("3845","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22202","2021-07-14 04:41:29","2021-07-14 04:41:29","1");
INSERT INTO audit_trail VALUES("3846","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22204","2021-07-14 04:45:53","2021-07-14 04:45:53","1");
INSERT INTO audit_trail VALUES("3847","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22206","2021-07-14 04:47:43","2021-07-14 04:47:43","1");
INSERT INTO audit_trail VALUES("3848","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22208","2021-07-14 04:51:04","2021-07-14 04:51:04","1");
INSERT INTO audit_trail VALUES("3849","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22210","2021-07-14 04:56:40","2021-07-14 04:56:40","1");
INSERT INTO audit_trail VALUES("3850","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22212","2021-07-14 04:58:42","2021-07-14 04:58:42","1");
INSERT INTO audit_trail VALUES("3851","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22214","2021-07-14 04:59:56","2021-07-14 04:59:56","1");
INSERT INTO audit_trail VALUES("3852","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22242","2021-07-14 07:24:09","2021-07-14 07:24:09","1");
INSERT INTO audit_trail VALUES("3853","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22244","2021-07-14 07:27:45","2021-07-14 07:27:45","1");
INSERT INTO audit_trail VALUES("3854","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22246","2021-07-14 07:34:57","2021-07-14 07:34:57","1");
INSERT INTO audit_trail VALUES("3855","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22248","2021-07-14 07:36:44","2021-07-14 07:36:44","1");
INSERT INTO audit_trail VALUES("3856","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22250","2021-07-14 07:45:49","2021-07-14 07:45:49","1");
INSERT INTO audit_trail VALUES("3857","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22252","2021-07-14 07:46:47","2021-07-14 07:46:47","1");
INSERT INTO audit_trail VALUES("3858","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:501","2021-07-14 08:50:21","2021-07-14 08:50:21","1");
INSERT INTO audit_trail VALUES("3859","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-14 10:09:04","2021-07-14 10:09:04","1");
INSERT INTO audit_trail VALUES("3860","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-14 10:13:37","2021-07-14 10:13:37","1");
INSERT INTO audit_trail VALUES("3861","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-15 01:38:58","2021-07-15 01:38:58","1");
INSERT INTO audit_trail VALUES("3862","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:502","2021-07-15 01:42:29","2021-07-15 01:42:29","1");
INSERT INTO audit_trail VALUES("3863","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-15 02:09:42","2021-07-15 02:09:42","1");
INSERT INTO audit_trail VALUES("3864","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-15 02:10:08","2021-07-15 02:10:08","1");
INSERT INTO audit_trail VALUES("3865","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-15 02:32:43","2021-07-15 02:32:43","1");
INSERT INTO audit_trail VALUES("3866","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:503","2021-07-15 06:26:25","2021-07-15 06:26:25","1");
INSERT INTO audit_trail VALUES("3867","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:504","2021-07-15 06:26:56","2021-07-15 06:26:56","1");
INSERT INTO audit_trail VALUES("3868","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-15 07:03:35","2021-07-15 07:03:35","");
INSERT INTO audit_trail VALUES("3869","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-15 08:56:32","2021-07-15 08:56:32","1");
INSERT INTO audit_trail VALUES("3870","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-15 09:28:43","2021-07-15 09:28:43","1");
INSERT INTO audit_trail VALUES("3871","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-15 10:04:28","2021-07-15 10:04:28","1");
INSERT INTO audit_trail VALUES("3872","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-15 10:06:59","2021-07-15 10:06:59","1");
INSERT INTO audit_trail VALUES("3873","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-16 01:42:59","2021-07-16 01:42:59","1");
INSERT INTO audit_trail VALUES("3874","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:505","2021-07-16 02:22:03","2021-07-16 02:22:03","1");
INSERT INTO audit_trail VALUES("3875","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-16 02:59:48","2021-07-16 02:59:48","1");
INSERT INTO audit_trail VALUES("3876","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22462","2021-07-16 03:29:14","2021-07-16 03:29:14","1");
INSERT INTO audit_trail VALUES("3877","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22467","2021-07-16 03:52:21","2021-07-16 03:52:21","1");
INSERT INTO audit_trail VALUES("3878","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:506","2021-07-16 03:52:44","2021-07-16 03:52:44","1");
INSERT INTO audit_trail VALUES("3879","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22471","2021-07-16 03:53:09","2021-07-16 03:53:09","1");
INSERT INTO audit_trail VALUES("3880","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22473","2021-07-16 03:54:26","2021-07-16 03:54:26","1");
INSERT INTO audit_trail VALUES("3881","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22475","2021-07-16 03:56:15","2021-07-16 03:56:15","1");
INSERT INTO audit_trail VALUES("3882","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22477","2021-07-16 04:27:00","2021-07-16 04:27:00","1");
INSERT INTO audit_trail VALUES("3883","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22479","2021-07-16 04:28:34","2021-07-16 04:28:34","1");
INSERT INTO audit_trail VALUES("3884","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22481","2021-07-16 04:29:46","2021-07-16 04:29:46","1");
INSERT INTO audit_trail VALUES("3885","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22483","2021-07-16 04:30:38","2021-07-16 04:30:38","1");
INSERT INTO audit_trail VALUES("3886","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22485","2021-07-16 04:33:49","2021-07-16 04:33:49","1");
INSERT INTO audit_trail VALUES("3887","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-16 04:35:54","2021-07-16 04:35:54","1");
INSERT INTO audit_trail VALUES("3888","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22487","2021-07-16 04:50:15","2021-07-16 04:50:15","1");
INSERT INTO audit_trail VALUES("3889","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22489","2021-07-16 04:51:09","2021-07-16 04:51:09","1");
INSERT INTO audit_trail VALUES("3890","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22491","2021-07-16 04:53:14","2021-07-16 04:53:14","1");
INSERT INTO audit_trail VALUES("3891","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22493","2021-07-16 04:55:35","2021-07-16 04:55:35","1");
INSERT INTO audit_trail VALUES("3892","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22495","2021-07-16 04:56:57","2021-07-16 04:56:57","1");
INSERT INTO audit_trail VALUES("3893","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22497","2021-07-16 05:05:50","2021-07-16 05:05:50","1");
INSERT INTO audit_trail VALUES("3894","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22499","2021-07-16 05:06:52","2021-07-16 05:06:52","1");
INSERT INTO audit_trail VALUES("3895","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22501","2021-07-16 05:07:42","2021-07-16 05:07:42","1");
INSERT INTO audit_trail VALUES("3896","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22503","2021-07-16 05:08:56","2021-07-16 05:08:56","1");
INSERT INTO audit_trail VALUES("3897","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22505","2021-07-16 05:10:05","2021-07-16 05:10:05","1");
INSERT INTO audit_trail VALUES("3898","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22507","2021-07-16 06:28:16","2021-07-16 06:28:16","1");
INSERT INTO audit_trail VALUES("3899","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22509","2021-07-16 06:29:31","2021-07-16 06:29:31","1");
INSERT INTO audit_trail VALUES("3900","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22511","2021-07-16 06:30:18","2021-07-16 06:30:18","1");
INSERT INTO audit_trail VALUES("3901","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22513","2021-07-16 06:31:41","2021-07-16 06:31:41","1");
INSERT INTO audit_trail VALUES("3902","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22515","2021-07-16 06:32:29","2021-07-16 06:32:29","1");
INSERT INTO audit_trail VALUES("3903","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22517","2021-07-16 06:53:05","2021-07-16 06:53:05","1");
INSERT INTO audit_trail VALUES("3904","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:22519","2021-07-16 06:53:47","2021-07-16 06:53:47","1");
INSERT INTO audit_trail VALUES("3905","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:507","2021-07-16 09:50:26","2021-07-16 09:50:26","1");
INSERT INTO audit_trail VALUES("3906","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-16 10:13:03","2021-07-16 10:13:03","1");
INSERT INTO audit_trail VALUES("3907","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-16 10:13:14","2021-07-16 10:13:14","1");
INSERT INTO audit_trail VALUES("3908","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-16 10:13:54","2021-07-16 10:13:54","1");
INSERT INTO audit_trail VALUES("3909","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-17 01:41:26","2021-07-17 01:41:26","");
INSERT INTO audit_trail VALUES("3910","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-17 01:47:38","2021-07-17 01:47:38","1");
INSERT INTO audit_trail VALUES("3911","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:508","2021-07-17 02:01:28","2021-07-17 02:01:28","1");
INSERT INTO audit_trail VALUES("3912","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-17 02:06:39","2021-07-17 02:06:39","1");
INSERT INTO audit_trail VALUES("3913","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:509","2021-07-17 04:06:45","2021-07-17 04:06:45","1");
INSERT INTO audit_trail VALUES("3914","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-17 06:03:49","2021-07-17 06:03:49","1");
INSERT INTO audit_trail VALUES("3915","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-17 06:03:57","2021-07-17 06:03:57","1");
INSERT INTO audit_trail VALUES("3916","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-17 06:05:06","2021-07-17 06:05:06","1");
INSERT INTO audit_trail VALUES("3917","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-17 06:05:13","2021-07-17 06:05:13","1");
INSERT INTO audit_trail VALUES("3918","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-19 01:45:26","2021-07-19 01:45:26","");
INSERT INTO audit_trail VALUES("3919","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-19 01:54:12","2021-07-19 01:54:12","");
INSERT INTO audit_trail VALUES("3920","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:510","2021-07-19 01:56:19","2021-07-19 01:56:19","1");
INSERT INTO audit_trail VALUES("3921","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-19 02:24:44","2021-07-19 02:24:44","");
INSERT INTO audit_trail VALUES("3922","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22711","2021-07-19 05:42:42","2021-07-19 05:42:42","1");
INSERT INTO audit_trail VALUES("3923","4","PERIS  NYAMBURA MWANGI","","Added expense with id:303","2021-07-19 09:44:48","2021-07-19 09:44:48","1");
INSERT INTO audit_trail VALUES("3924","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-19 10:03:18","2021-07-19 10:03:18","1");
INSERT INTO audit_trail VALUES("3925","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-19 10:04:14","2021-07-19 10:04:14","1");
INSERT INTO audit_trail VALUES("3926","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-19 10:04:59","2021-07-19 10:04:59","1");
INSERT INTO audit_trail VALUES("3927","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-19 10:05:13","2021-07-19 10:05:13","1");
INSERT INTO audit_trail VALUES("3928","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-21 04:01:46","2021-07-21 04:01:46","");
INSERT INTO audit_trail VALUES("3929","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-21 04:31:15","2021-07-21 04:31:15","");
INSERT INTO audit_trail VALUES("3930","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:511","2021-07-21 04:46:02","2021-07-21 04:46:02","1");
INSERT INTO audit_trail VALUES("3931","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22807","2021-07-21 08:33:51","2021-07-21 08:33:51","1");
INSERT INTO audit_trail VALUES("3932","4","PERIS  NYAMBURA MWANGI","","Added expense with id:304","2021-07-21 08:41:00","2021-07-21 08:41:00","1");
INSERT INTO audit_trail VALUES("3933","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:512","2021-07-21 09:08:28","2021-07-21 09:08:28","1");
INSERT INTO audit_trail VALUES("3934","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:513","2021-07-21 09:09:07","2021-07-21 09:09:07","1");
INSERT INTO audit_trail VALUES("3935","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:514","2021-07-21 09:10:15","2021-07-21 09:10:15","1");
INSERT INTO audit_trail VALUES("3936","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:515","2021-07-21 09:11:04","2021-07-21 09:11:04","1");
INSERT INTO audit_trail VALUES("3937","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-21 10:09:58","2021-07-21 10:09:58","1");
INSERT INTO audit_trail VALUES("3938","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-21 10:11:57","2021-07-21 10:11:57","1");
INSERT INTO audit_trail VALUES("3939","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-22 01:51:42","2021-07-22 01:51:42","1");
INSERT INTO audit_trail VALUES("3940","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-22 02:15:41","2021-07-22 02:15:41","1");
INSERT INTO audit_trail VALUES("3941","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:516","2021-07-22 02:25:54","2021-07-22 02:25:54","1");
INSERT INTO audit_trail VALUES("3942","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-22 04:22:58","2021-07-22 04:22:58","");
INSERT INTO audit_trail VALUES("3943","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:140","2021-07-22 04:26:12","2021-07-22 04:26:12","1");
INSERT INTO audit_trail VALUES("3944","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:140","2021-07-22 04:26:25","2021-07-22 04:26:25","1");
INSERT INTO audit_trail VALUES("3945","2","CECILIA WANJERI WANGUHU","","Updated loan with id:140","2021-07-22 04:27:02","2021-07-22 04:27:02","1");
INSERT INTO audit_trail VALUES("3946","2","CECILIA WANJERI WANGUHU","","Approved loan with id:140","2021-07-22 04:28:07","2021-07-22 04:28:07","1");
INSERT INTO audit_trail VALUES("3947","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:140","2021-07-22 04:29:45","2021-07-22 04:29:45","1");
INSERT INTO audit_trail VALUES("3948","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:140","2021-07-22 04:31:37","2021-07-22 04:31:37","1");
INSERT INTO audit_trail VALUES("3949","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:517","2021-07-22 05:17:40","2021-07-22 05:17:40","1");
INSERT INTO audit_trail VALUES("3950","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:518","2021-07-22 05:18:25","2021-07-22 05:18:25","1");
INSERT INTO audit_trail VALUES("3951","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22930","2021-07-22 06:47:42","2021-07-22 06:47:42","1");
INSERT INTO audit_trail VALUES("3952","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22933","2021-07-22 06:51:19","2021-07-22 06:51:19","1");
INSERT INTO audit_trail VALUES("3953","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22946","2021-07-22 07:04:08","2021-07-22 07:04:08","1");
INSERT INTO audit_trail VALUES("3954","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:22949","2021-07-22 07:09:02","2021-07-22 07:09:02","1");
INSERT INTO audit_trail VALUES("3955","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:519","2021-07-22 07:21:30","2021-07-22 07:21:30","1");
INSERT INTO audit_trail VALUES("3956","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:520","2021-07-22 07:24:10","2021-07-22 07:24:10","1");
INSERT INTO audit_trail VALUES("3957","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-22 10:07:15","2021-07-22 10:07:15","1");
INSERT INTO audit_trail VALUES("3958","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-22 10:08:02","2021-07-22 10:08:02","1");
INSERT INTO audit_trail VALUES("3959","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-23 01:54:14","2021-07-23 01:54:14","1");
INSERT INTO audit_trail VALUES("3960","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-23 03:02:49","2021-07-23 03:02:49","");
INSERT INTO audit_trail VALUES("3961","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-23 03:33:57","2021-07-23 03:33:57","1");
INSERT INTO audit_trail VALUES("3962","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23034","2021-07-23 03:34:13","2021-07-23 03:34:13","1");
INSERT INTO audit_trail VALUES("3963","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23036","2021-07-23 03:35:48","2021-07-23 03:35:48","1");
INSERT INTO audit_trail VALUES("3964","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23038","2021-07-23 03:37:50","2021-07-23 03:37:50","1");
INSERT INTO audit_trail VALUES("3965","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23040","2021-07-23 03:38:40","2021-07-23 03:38:40","1");
INSERT INTO audit_trail VALUES("3966","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23042","2021-07-23 03:39:22","2021-07-23 03:39:22","1");
INSERT INTO audit_trail VALUES("3967","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23044","2021-07-23 03:40:39","2021-07-23 03:40:39","1");
INSERT INTO audit_trail VALUES("3968","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23046","2021-07-23 03:42:29","2021-07-23 03:42:29","1");
INSERT INTO audit_trail VALUES("3969","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23048","2021-07-23 03:44:48","2021-07-23 03:44:48","1");
INSERT INTO audit_trail VALUES("3970","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23050","2021-07-23 03:47:22","2021-07-23 03:47:22","1");
INSERT INTO audit_trail VALUES("3971","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23052","2021-07-23 03:48:35","2021-07-23 03:48:35","1");
INSERT INTO audit_trail VALUES("3972","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23054","2021-07-23 03:50:03","2021-07-23 03:50:03","1");
INSERT INTO audit_trail VALUES("3973","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23056","2021-07-23 03:51:19","2021-07-23 03:51:19","1");
INSERT INTO audit_trail VALUES("3974","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23058","2021-07-23 04:46:16","2021-07-23 04:46:16","1");
INSERT INTO audit_trail VALUES("3975","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23060","2021-07-23 04:47:48","2021-07-23 04:47:48","1");
INSERT INTO audit_trail VALUES("3976","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23062","2021-07-23 05:16:00","2021-07-23 05:16:00","1");
INSERT INTO audit_trail VALUES("3977","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23064","2021-07-23 05:16:59","2021-07-23 05:16:59","1");
INSERT INTO audit_trail VALUES("3978","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23066","2021-07-23 05:18:26","2021-07-23 05:18:26","1");
INSERT INTO audit_trail VALUES("3979","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23068","2021-07-23 05:20:41","2021-07-23 05:20:41","1");
INSERT INTO audit_trail VALUES("3980","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23070","2021-07-23 05:24:06","2021-07-23 05:24:06","1");
INSERT INTO audit_trail VALUES("3981","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23072","2021-07-23 05:25:45","2021-07-23 05:25:45","1");
INSERT INTO audit_trail VALUES("3982","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23074","2021-07-23 05:26:31","2021-07-23 05:26:31","1");
INSERT INTO audit_trail VALUES("3983","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23076","2021-07-23 05:28:00","2021-07-23 05:28:00","1");
INSERT INTO audit_trail VALUES("3984","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23078","2021-07-23 05:28:55","2021-07-23 05:28:55","1");
INSERT INTO audit_trail VALUES("3985","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23080","2021-07-23 05:29:30","2021-07-23 05:29:30","1");
INSERT INTO audit_trail VALUES("3986","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23082","2021-07-23 05:30:41","2021-07-23 05:30:41","1");
INSERT INTO audit_trail VALUES("3987","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23084","2021-07-23 05:31:54","2021-07-23 05:31:54","1");
INSERT INTO audit_trail VALUES("3988","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23086","2021-07-23 05:34:00","2021-07-23 05:34:00","1");
INSERT INTO audit_trail VALUES("3989","1","Admin Admin","","Logged in to system","2021-07-23 06:20:50","2021-07-23 06:20:50","");
INSERT INTO audit_trail VALUES("3990","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:521","2021-07-23 06:47:04","2021-07-23 06:47:04","1");
INSERT INTO audit_trail VALUES("3991","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-23 08:52:42","2021-07-23 08:52:42","1");
INSERT INTO audit_trail VALUES("3992","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23136","2021-07-23 09:11:51","2021-07-23 09:11:51","1");
INSERT INTO audit_trail VALUES("3993","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23167","2021-07-23 09:57:33","2021-07-23 09:57:33","1");
INSERT INTO audit_trail VALUES("3994","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-23 10:05:11","2021-07-23 10:05:11","1");
INSERT INTO audit_trail VALUES("3995","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-23 10:07:05","2021-07-23 10:07:05","1");
INSERT INTO audit_trail VALUES("3996","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-24 02:24:45","2021-07-24 02:24:45","1");
INSERT INTO audit_trail VALUES("3997","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-24 02:28:34","2021-07-24 02:28:34","1");
INSERT INTO audit_trail VALUES("3998","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:522","2021-07-24 02:30:11","2021-07-24 02:30:11","1");
INSERT INTO audit_trail VALUES("3999","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:523","2021-07-24 04:30:13","2021-07-24 04:30:13","1");
INSERT INTO audit_trail VALUES("4000","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:524","2021-07-24 04:31:09","2021-07-24 04:31:09","1");
INSERT INTO audit_trail VALUES("4001","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:525","2021-07-24 04:32:27","2021-07-24 04:32:27","1");
INSERT INTO audit_trail VALUES("4002","4","PERIS  NYAMBURA MWANGI","","Added expense with id:305","2021-07-24 04:33:48","2021-07-24 04:33:48","1");
INSERT INTO audit_trail VALUES("4003","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:526","2021-07-24 04:34:52","2021-07-24 04:34:52","1");
INSERT INTO audit_trail VALUES("4004","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-24 06:20:10","2021-07-24 06:20:10","1");
INSERT INTO audit_trail VALUES("4005","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-24 06:32:48","2021-07-24 06:32:48","1");
INSERT INTO audit_trail VALUES("4006","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-26 02:31:04","2021-07-26 02:31:04","");
INSERT INTO audit_trail VALUES("4007","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-26 02:31:48","2021-07-26 02:31:48","");
INSERT INTO audit_trail VALUES("4008","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:527","2021-07-26 02:33:13","2021-07-26 02:33:13","1");
INSERT INTO audit_trail VALUES("4009","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:528","2021-07-26 02:44:03","2021-07-26 02:44:03","1");
INSERT INTO audit_trail VALUES("4010","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-26 02:44:35","2021-07-26 02:44:35","1");
INSERT INTO audit_trail VALUES("4011","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23272","2021-07-26 06:35:44","2021-07-26 06:35:44","1");
INSERT INTO audit_trail VALUES("4012","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23282","2021-07-26 06:42:49","2021-07-26 06:42:49","1");
INSERT INTO audit_trail VALUES("4013","4","PERIS  NYAMBURA MWANGI","","Added expense with id:306","2021-07-26 09:43:10","2021-07-26 09:43:10","1");
INSERT INTO audit_trail VALUES("4014","4","PERIS  NYAMBURA MWANGI","","Updated expense with id:306","2021-07-26 09:51:09","2021-07-26 09:51:09","1");
INSERT INTO audit_trail VALUES("4015","4","PERIS  NYAMBURA MWANGI","","Updated expense with id:306","2021-07-26 09:51:43","2021-07-26 09:51:43","1");
INSERT INTO audit_trail VALUES("4016","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-26 10:00:08","2021-07-26 10:00:08","1");
INSERT INTO audit_trail VALUES("4017","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-26 10:01:49","2021-07-26 10:01:49","1");
INSERT INTO audit_trail VALUES("4018","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-27 01:31:01","2021-07-27 01:31:01","1");
INSERT INTO audit_trail VALUES("4019","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:529","2021-07-27 01:33:42","2021-07-27 01:33:42","1");
INSERT INTO audit_trail VALUES("4020","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-27 02:03:03","2021-07-27 02:03:03","1");
INSERT INTO audit_trail VALUES("4021","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-27 02:12:36","2021-07-27 02:12:36","1");
INSERT INTO audit_trail VALUES("4022","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-27 03:40:31","2021-07-27 03:40:31","");
INSERT INTO audit_trail VALUES("4023","2","CECILIA WANJERI WANGUHU","","Added expense with id:307","2021-07-27 09:55:35","2021-07-27 09:55:35","1");
INSERT INTO audit_trail VALUES("4024","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-27 10:05:34","2021-07-27 10:05:34","1");
INSERT INTO audit_trail VALUES("4025","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-27 10:06:37","2021-07-27 10:06:37","1");
INSERT INTO audit_trail VALUES("4026","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-27 10:09:52","2021-07-27 10:09:52","1");
INSERT INTO audit_trail VALUES("4027","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-27 10:10:02","2021-07-27 10:10:02","1");
INSERT INTO audit_trail VALUES("4028","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-28 01:22:00","2021-07-28 01:22:00","1");
INSERT INTO audit_trail VALUES("4029","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:530","2021-07-28 01:30:36","2021-07-28 01:30:36","1");
INSERT INTO audit_trail VALUES("4030","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-28 03:05:29","2021-07-28 03:05:29","1");
INSERT INTO audit_trail VALUES("4031","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:531","2021-07-28 07:05:36","2021-07-28 07:05:36","1");
INSERT INTO audit_trail VALUES("4032","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-28 08:16:06","2021-07-28 08:16:06","1");
INSERT INTO audit_trail VALUES("4033","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:532","2021-07-28 08:58:29","2021-07-28 08:58:29","1");
INSERT INTO audit_trail VALUES("4034","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:533","2021-07-28 09:00:02","2021-07-28 09:00:02","1");
INSERT INTO audit_trail VALUES("4035","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23536","2021-07-28 09:03:39","2021-07-28 09:03:39","1");
INSERT INTO audit_trail VALUES("4036","4","PERIS  NYAMBURA MWANGI","","Added expense with id:308","2021-07-28 09:52:53","2021-07-28 09:52:53","1");
INSERT INTO audit_trail VALUES("4037","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-28 09:59:18","2021-07-28 09:59:18","1");
INSERT INTO audit_trail VALUES("4038","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-28 10:01:45","2021-07-28 10:01:45","1");
INSERT INTO audit_trail VALUES("4039","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-28 10:07:49","2021-07-28 10:07:49","1");
INSERT INTO audit_trail VALUES("4040","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-28 10:08:13","2021-07-28 10:08:13","1");
INSERT INTO audit_trail VALUES("4041","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-29 01:18:04","2021-07-29 01:18:04","1");
INSERT INTO audit_trail VALUES("4042","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-29 01:38:42","2021-07-29 01:38:42","1");
INSERT INTO audit_trail VALUES("4043","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-29 01:44:08","2021-07-29 01:44:08","");
INSERT INTO audit_trail VALUES("4044","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-29 01:52:58","2021-07-29 01:52:58","1");
INSERT INTO audit_trail VALUES("4045","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:534","2021-07-29 01:55:44","2021-07-29 01:55:44","1");
INSERT INTO audit_trail VALUES("4046","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:535","2021-07-29 02:06:11","2021-07-29 02:06:11","1");
INSERT INTO audit_trail VALUES("4047","4","PERIS  NYAMBURA MWANGI","","Added loan with id:219","2021-07-29 04:56:19","2021-07-29 04:56:19","1");
INSERT INTO audit_trail VALUES("4048","4","PERIS  NYAMBURA MWANGI","","Approved loan with id:219","2021-07-29 05:06:30","2021-07-29 05:06:30","1");
INSERT INTO audit_trail VALUES("4049","4","PERIS  NYAMBURA MWANGI","","Disbursed loan with id:219","2021-07-29 05:07:02","2021-07-29 05:07:02","1");
INSERT INTO audit_trail VALUES("4050","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23587","2021-07-29 05:43:07","2021-07-29 05:43:07","1");
INSERT INTO audit_trail VALUES("4051","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23591","2021-07-29 06:01:16","2021-07-29 06:01:16","1");
INSERT INTO audit_trail VALUES("4052","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23609","2021-07-29 06:14:17","2021-07-29 06:14:17","1");
INSERT INTO audit_trail VALUES("4053","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23611","2021-07-29 06:15:53","2021-07-29 06:15:53","1");
INSERT INTO audit_trail VALUES("4054","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23613","2021-07-29 06:17:32","2021-07-29 06:17:32","1");
INSERT INTO audit_trail VALUES("4055","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23618","2021-07-29 06:30:47","2021-07-29 06:30:47","1");
INSERT INTO audit_trail VALUES("4056","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23620","2021-07-29 06:32:20","2021-07-29 06:32:20","1");
INSERT INTO audit_trail VALUES("4057","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23622","2021-07-29 06:37:13","2021-07-29 06:37:13","1");
INSERT INTO audit_trail VALUES("4058","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:536","2021-07-29 08:38:36","2021-07-29 08:38:36","1");
INSERT INTO audit_trail VALUES("4059","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:537","2021-07-29 08:40:51","2021-07-29 08:40:51","1");
INSERT INTO audit_trail VALUES("4060","4","PERIS  NYAMBURA MWANGI","","Added expense with id:309","2021-07-29 09:33:06","2021-07-29 09:33:06","1");
INSERT INTO audit_trail VALUES("4061","4","PERIS  NYAMBURA MWANGI","","Updated Capital  with id:535","2021-07-29 10:15:36","2021-07-29 10:15:36","1");
INSERT INTO audit_trail VALUES("4062","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-29 10:18:16","2021-07-29 10:18:16","1");
INSERT INTO audit_trail VALUES("4063","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-29 10:20:18","2021-07-29 10:20:18","1");
INSERT INTO audit_trail VALUES("4064","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-30 01:32:49","2021-07-30 01:32:49","");
INSERT INTO audit_trail VALUES("4065","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-30 02:13:04","2021-07-30 02:13:04","1");
INSERT INTO audit_trail VALUES("4066","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-30 02:20:59","2021-07-30 02:20:59","1");
INSERT INTO audit_trail VALUES("4067","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:538","2021-07-30 02:22:05","2021-07-30 02:22:05","1");
INSERT INTO audit_trail VALUES("4068","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23730","2021-07-30 03:07:45","2021-07-30 03:07:45","1");
INSERT INTO audit_trail VALUES("4069","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23732","2021-07-30 03:08:58","2021-07-30 03:08:58","1");
INSERT INTO audit_trail VALUES("4070","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23734","2021-07-30 03:10:05","2021-07-30 03:10:05","1");
INSERT INTO audit_trail VALUES("4071","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23736","2021-07-30 03:13:56","2021-07-30 03:13:56","1");
INSERT INTO audit_trail VALUES("4072","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23738","2021-07-30 03:18:22","2021-07-30 03:18:22","1");
INSERT INTO audit_trail VALUES("4073","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23741","2021-07-30 03:36:26","2021-07-30 03:36:26","1");
INSERT INTO audit_trail VALUES("4074","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:23745","2021-07-30 04:29:22","2021-07-30 04:29:22","1");
INSERT INTO audit_trail VALUES("4075","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:539","2021-07-30 07:13:28","2021-07-30 07:13:28","1");
INSERT INTO audit_trail VALUES("4076","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:540","2021-07-30 07:14:15","2021-07-30 07:14:15","1");
INSERT INTO audit_trail VALUES("4077","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:541","2021-07-30 07:15:05","2021-07-30 07:15:05","1");
INSERT INTO audit_trail VALUES("4078","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:542","2021-07-30 07:16:00","2021-07-30 07:16:00","1");
INSERT INTO audit_trail VALUES("4079","4","PERIS  NYAMBURA MWANGI","","Added expense with id:310","2021-07-30 09:40:43","2021-07-30 09:40:43","1");
INSERT INTO audit_trail VALUES("4080","4","PERIS  NYAMBURA MWANGI","","Added expense with id:311","2021-07-30 09:42:04","2021-07-30 09:42:04","1");
INSERT INTO audit_trail VALUES("4081","4","PERIS  NYAMBURA MWANGI","","Added expense with id:312","2021-07-30 09:44:58","2021-07-30 09:44:58","1");
INSERT INTO audit_trail VALUES("4082","4","PERIS  NYAMBURA MWANGI","","Added expense with id:313","2021-07-30 10:00:27","2021-07-30 10:00:27","1");
INSERT INTO audit_trail VALUES("4083","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-30 10:04:26","2021-07-30 10:04:26","1");
INSERT INTO audit_trail VALUES("4084","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-30 10:07:39","2021-07-30 10:07:39","1");
INSERT INTO audit_trail VALUES("4085","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-31 01:29:44","2021-07-31 01:29:44","");
INSERT INTO audit_trail VALUES("4086","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:543","2021-07-31 01:31:56","2021-07-31 01:31:56","1");
INSERT INTO audit_trail VALUES("4087","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-07-31 01:59:27","2021-07-31 01:59:27","1");
INSERT INTO audit_trail VALUES("4088","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-31 02:18:18","2021-07-31 02:18:18","1");
INSERT INTO audit_trail VALUES("4089","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-31 02:23:04","2021-07-31 02:23:04","1");
INSERT INTO audit_trail VALUES("4090","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-31 02:25:50","2021-07-31 02:25:50","1");
INSERT INTO audit_trail VALUES("4091","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:544","2021-07-31 03:10:34","2021-07-31 03:10:34","1");
INSERT INTO audit_trail VALUES("4092","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:545","2021-07-31 03:15:50","2021-07-31 03:15:50","1");
INSERT INTO audit_trail VALUES("4093","2","CECILIA WANJERI WANGUHU","","Added expense with id:314","2021-07-31 05:42:10","2021-07-31 05:42:10","1");
INSERT INTO audit_trail VALUES("4094","4","PERIS  NYAMBURA MWANGI","","Added expense with id:315","2021-07-31 06:16:00","2021-07-31 06:16:00","1");
INSERT INTO audit_trail VALUES("4095","4","PERIS  NYAMBURA MWANGI","","Updated expense with id:315","2021-07-31 06:20:43","2021-07-31 06:20:43","1");
INSERT INTO audit_trail VALUES("4096","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-07-31 06:22:36","2021-07-31 06:22:36","1");
INSERT INTO audit_trail VALUES("4097","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-31 06:23:40","2021-07-31 06:23:40","1");
INSERT INTO audit_trail VALUES("4098","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-07-31 06:24:21","2021-07-31 06:24:21","1");
INSERT INTO audit_trail VALUES("4099","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-07-31 06:25:18","2021-07-31 06:25:18","1");
INSERT INTO audit_trail VALUES("4100","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-02 02:13:41","2021-08-02 02:13:41","");
INSERT INTO audit_trail VALUES("4101","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-02 02:13:43","2021-08-02 02:13:43","");
INSERT INTO audit_trail VALUES("4102","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-02 02:13:43","2021-08-02 02:13:43","");
INSERT INTO audit_trail VALUES("4103","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-02 03:14:48","2021-08-02 03:14:48","");
INSERT INTO audit_trail VALUES("4104","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-02 03:24:10","2021-08-02 03:24:10","");
INSERT INTO audit_trail VALUES("4105","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:546","2021-08-02 03:51:28","2021-08-02 03:51:28","1");
INSERT INTO audit_trail VALUES("4106","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:547","2021-08-02 07:46:24","2021-08-02 07:46:24","1");
INSERT INTO audit_trail VALUES("4107","2","CECILIA WANJERI WANGUHU","","Added expense with id:316","2021-08-02 09:33:03","2021-08-02 09:33:03","1");
INSERT INTO audit_trail VALUES("4108","4","PERIS  NYAMBURA MWANGI","","Added expense with id:317","2021-08-02 10:05:56","2021-08-02 10:05:56","1");
INSERT INTO audit_trail VALUES("4109","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-02 10:18:09","2021-08-02 10:18:09","1");
INSERT INTO audit_trail VALUES("4110","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-02 10:20:20","2021-08-02 10:20:20","1");
INSERT INTO audit_trail VALUES("4111","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-08-02 10:20:38","2021-08-02 10:20:38","1");
INSERT INTO audit_trail VALUES("4112","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-03 02:19:44","2021-08-03 02:19:44","1");
INSERT INTO audit_trail VALUES("4113","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-03 02:21:02","2021-08-03 02:21:02","1");
INSERT INTO audit_trail VALUES("4114","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:548","2021-08-03 02:31:15","2021-08-03 02:31:15","1");
INSERT INTO audit_trail VALUES("4115","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:549","2021-08-03 03:07:21","2021-08-03 03:07:21","1");
INSERT INTO audit_trail VALUES("4116","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:550","2021-08-03 03:08:03","2021-08-03 03:08:03","1");
INSERT INTO audit_trail VALUES("4117","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-03 03:33:20","2021-08-03 03:33:20","1");
INSERT INTO audit_trail VALUES("4118","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24180","2021-08-03 04:34:51","2021-08-03 04:34:51","1");
INSERT INTO audit_trail VALUES("4119","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24182","2021-08-03 04:36:21","2021-08-03 04:36:21","1");
INSERT INTO audit_trail VALUES("4120","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24186","2021-08-03 04:38:54","2021-08-03 04:38:54","1");
INSERT INTO audit_trail VALUES("4121","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24195","2021-08-03 04:40:44","2021-08-03 04:40:44","1");
INSERT INTO audit_trail VALUES("4122","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-03 04:47:10","2021-08-03 04:47:10","1");
INSERT INTO audit_trail VALUES("4123","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24207","2021-08-03 05:51:35","2021-08-03 05:51:35","1");
INSERT INTO audit_trail VALUES("4124","1","Admin Admin","","Logged in to system","2021-08-03 06:03:44","2021-08-03 06:03:44","");
INSERT INTO audit_trail VALUES("4125","1","Admin Admin","","Updated Settings","2021-08-03 06:20:43","2021-08-03 06:20:43","1");
INSERT INTO audit_trail VALUES("4126","1","Admin Admin","","Updated Settings","2021-08-03 06:20:53","2021-08-03 06:20:53","1");
INSERT INTO audit_trail VALUES("4127","1","Admin Admin","","Updated loan with id:14","2021-08-03 06:29:37","2021-08-03 06:29:37","1");
INSERT INTO audit_trail VALUES("4128","1","Admin Admin","","Updated loan with id:14","2021-08-03 06:31:56","2021-08-03 06:31:56","1");
INSERT INTO audit_trail VALUES("4129","1","Admin Admin","","Updated loan with id:14","2021-08-03 06:31:59","2021-08-03 06:31:59","1");
INSERT INTO audit_trail VALUES("4130","1","Admin Admin","","Added loan with id:220","2021-08-03 06:34:02","2021-08-03 06:34:02","1");
INSERT INTO audit_trail VALUES("4131","1","Admin Admin","","Added loan with id:221","2021-08-03 06:34:06","2021-08-03 06:34:06","1");
INSERT INTO audit_trail VALUES("4132","1","Admin Admin","","Deleted loan with id:221","2021-08-03 06:34:25","2021-08-03 06:34:25","1");
INSERT INTO audit_trail VALUES("4133","1","Admin Admin","","Approved loan with id:220","2021-08-03 06:34:48","2021-08-03 06:34:48","1");
INSERT INTO audit_trail VALUES("4134","1","Admin Admin","","Disbursed loan with id:220","2021-08-03 06:35:09","2021-08-03 06:35:09","1");
INSERT INTO audit_trail VALUES("4135","4","PERIS  NYAMBURA MWANGI","","Added expense with id:318","2021-08-03 09:20:50","2021-08-03 09:20:50","1");
INSERT INTO audit_trail VALUES("4136","4","PERIS  NYAMBURA MWANGI","","Added expense with id:319","2021-08-03 09:48:41","2021-08-03 09:48:41","1");
INSERT INTO audit_trail VALUES("4137","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-08-03 10:02:49","2021-08-03 10:02:49","1");
INSERT INTO audit_trail VALUES("4138","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-03 10:04:45","2021-08-03 10:04:45","1");
INSERT INTO audit_trail VALUES("4139","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-04 01:58:33","2021-08-04 01:58:33","1");
INSERT INTO audit_trail VALUES("4140","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:551","2021-08-04 02:09:39","2021-08-04 02:09:39","1");
INSERT INTO audit_trail VALUES("4141","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-04 02:30:57","2021-08-04 02:30:57","");
INSERT INTO audit_trail VALUES("4142","2","CECILIA WANJERI WANGUHU","","Added loan with id:222","2021-08-04 02:49:05","2021-08-04 02:49:05","1");
INSERT INTO audit_trail VALUES("4143","2","CECILIA WANJERI WANGUHU","","Approved loan with id:222","2021-08-04 02:49:41","2021-08-04 02:49:41","1");
INSERT INTO audit_trail VALUES("4144","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:222","2021-08-04 02:50:31","2021-08-04 02:50:31","1");
INSERT INTO audit_trail VALUES("4145","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-04 02:57:21","2021-08-04 02:57:21","1");
INSERT INTO audit_trail VALUES("4146","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:24275","2021-08-04 03:01:15","2021-08-04 03:01:15","1");
INSERT INTO audit_trail VALUES("4147","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24277","2021-08-04 03:09:12","2021-08-04 03:09:12","1");
INSERT INTO audit_trail VALUES("4148","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:24279","2021-08-04 03:11:33","2021-08-04 03:11:33","1");
INSERT INTO audit_trail VALUES("4149","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24281","2021-08-04 04:02:52","2021-08-04 04:02:52","1");
INSERT INTO audit_trail VALUES("4150","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-04 04:44:47","2021-08-04 04:44:47","1");
INSERT INTO audit_trail VALUES("4151","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-04 06:56:41","2021-08-04 06:56:41","");
INSERT INTO audit_trail VALUES("4152","2","CECILIA WANJERI WANGUHU","","Updated loan product with id:1","2021-08-04 06:57:58","2021-08-04 06:57:58","1");
INSERT INTO audit_trail VALUES("4153","1","Admin Admin","","Logged in to system","2021-08-04 08:28:00","2021-08-04 08:28:00","");
INSERT INTO audit_trail VALUES("4154","2","CECILIA WANJERI WANGUHU","","Added expense with id:320","2021-08-04 09:33:57","2021-08-04 09:33:57","1");
INSERT INTO audit_trail VALUES("4155","4","PERIS  NYAMBURA MWANGI","","Added expense with id:321","2021-08-04 09:39:10","2021-08-04 09:39:10","1");
INSERT INTO audit_trail VALUES("4156","4","PERIS  NYAMBURA MWANGI","","Added expense with id:322","2021-08-04 09:47:16","2021-08-04 09:47:16","1");
INSERT INTO audit_trail VALUES("4157","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-08-04 10:06:16","2021-08-04 10:06:16","1");
INSERT INTO audit_trail VALUES("4158","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-04 10:07:06","2021-08-04 10:07:06","1");
INSERT INTO audit_trail VALUES("4159","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-05 01:59:29","2021-08-05 01:59:29","1");
INSERT INTO audit_trail VALUES("4160","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-05 01:59:46","2021-08-05 01:59:46","1");
INSERT INTO audit_trail VALUES("4161","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:552","2021-08-05 02:01:09","2021-08-05 02:01:09","1");
INSERT INTO audit_trail VALUES("4162","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24338","2021-08-05 02:54:18","2021-08-05 02:54:18","1");
INSERT INTO audit_trail VALUES("4163","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24340","2021-08-05 02:55:22","2021-08-05 02:55:22","1");
INSERT INTO audit_trail VALUES("4164","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:553","2021-08-05 04:39:03","2021-08-05 04:39:03","1");
INSERT INTO audit_trail VALUES("4165","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-05 07:14:44","2021-08-05 07:14:44","");
INSERT INTO audit_trail VALUES("4166","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:554","2021-08-05 07:22:18","2021-08-05 07:22:18","1");
INSERT INTO audit_trail VALUES("4167","2","CECILIA WANJERI WANGUHU","","Added expense with id:323","2021-08-05 09:55:36","2021-08-05 09:55:36","1");
INSERT INTO audit_trail VALUES("4168","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-05 09:56:32","2021-08-05 09:56:32","1");
INSERT INTO audit_trail VALUES("4169","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-05 10:02:34","2021-08-05 10:02:34","1");
INSERT INTO audit_trail VALUES("4170","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-08-05 10:06:22","2021-08-05 10:06:22","1");
INSERT INTO audit_trail VALUES("4171","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-06 01:18:54","2021-08-06 01:18:54","1");
INSERT INTO audit_trail VALUES("4172","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-06 01:55:47","2021-08-06 01:55:47","1");
INSERT INTO audit_trail VALUES("4173","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-06 02:09:51","2021-08-06 02:09:51","1");
INSERT INTO audit_trail VALUES("4174","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:555","2021-08-06 02:11:27","2021-08-06 02:11:27","1");
INSERT INTO audit_trail VALUES("4175","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-06 03:49:51","2021-08-06 03:49:51","1");
INSERT INTO audit_trail VALUES("4176","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-06 04:46:56","2021-08-06 04:46:56","1");
INSERT INTO audit_trail VALUES("4177","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:556","2021-08-06 04:48:02","2021-08-06 04:48:02","1");
INSERT INTO audit_trail VALUES("4178","1","Admin Admin","","Logged in to system","2021-08-06 07:38:31","2021-08-06 07:38:31","");
INSERT INTO audit_trail VALUES("4179","4","PERIS  NYAMBURA MWANGI","","Added expense with id:324","2021-08-06 10:01:48","2021-08-06 10:01:48","1");
INSERT INTO audit_trail VALUES("4180","4","PERIS  NYAMBURA MWANGI","","Added expense with id:325","2021-08-06 10:02:35","2021-08-06 10:02:35","1");
INSERT INTO audit_trail VALUES("4181","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-08-06 10:05:46","2021-08-06 10:05:46","1");
INSERT INTO audit_trail VALUES("4182","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-06 10:08:47","2021-08-06 10:08:47","1");
INSERT INTO audit_trail VALUES("4183","1","Admin Admin","","Added repayment for loan with id:154","2021-08-06 17:10:25","2021-08-06 17:10:25","1");
INSERT INTO audit_trail VALUES("4184","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-07 02:23:01","2021-08-07 02:23:01","1");
INSERT INTO audit_trail VALUES("4185","4","PERIS  NYAMBURA MWANGI","","Updated expense with id:235","2021-08-07 02:25:57","2021-08-07 02:25:57","1");
INSERT INTO audit_trail VALUES("4186","4","PERIS  NYAMBURA MWANGI","","Added Capital  with id:557","2021-08-07 02:27:37","2021-08-07 02:27:37","1");
INSERT INTO audit_trail VALUES("4187","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-07 03:26:15","2021-08-07 03:26:15","1");
INSERT INTO audit_trail VALUES("4188","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-07 04:06:50","2021-08-07 04:06:50","");
INSERT INTO audit_trail VALUES("4189","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24524","2021-08-07 04:09:01","2021-08-07 04:09:01","1");
INSERT INTO audit_trail VALUES("4190","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:558","2021-08-07 04:39:05","2021-08-07 04:39:05","1");
INSERT INTO audit_trail VALUES("4191","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:559","2021-08-07 04:39:53","2021-08-07 04:39:53","1");
INSERT INTO audit_trail VALUES("4192","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:560","2021-08-07 04:42:59","2021-08-07 04:42:59","1");
INSERT INTO audit_trail VALUES("4193","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24550","2021-08-07 05:05:09","2021-08-07 05:05:09","1");
INSERT INTO audit_trail VALUES("4194","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24554","2021-08-07 05:06:44","2021-08-07 05:06:44","1");
INSERT INTO audit_trail VALUES("4195","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24557","2021-08-07 05:08:08","2021-08-07 05:08:08","1");
INSERT INTO audit_trail VALUES("4196","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24561","2021-08-07 05:10:11","2021-08-07 05:10:11","1");
INSERT INTO audit_trail VALUES("4197","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24566","2021-08-07 05:15:20","2021-08-07 05:15:20","1");
INSERT INTO audit_trail VALUES("4198","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24580","2021-08-07 05:40:05","2021-08-07 05:40:05","1");
INSERT INTO audit_trail VALUES("4199","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24582","2021-08-07 05:40:46","2021-08-07 05:40:46","1");
INSERT INTO audit_trail VALUES("4200","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24586","2021-08-07 05:45:25","2021-08-07 05:45:25","1");
INSERT INTO audit_trail VALUES("4201","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24590","2021-08-07 05:48:27","2021-08-07 05:48:27","1");
INSERT INTO audit_trail VALUES("4202","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24592","2021-08-07 05:49:55","2021-08-07 05:49:55","1");
INSERT INTO audit_trail VALUES("4203","4","PERIS  NYAMBURA MWANGI","","Added Journal Manual Entry  with id:24594","2021-08-07 05:50:59","2021-08-07 05:50:59","1");
INSERT INTO audit_trail VALUES("4204","4","PERIS  NYAMBURA MWANGI","","Added expense with id:326","2021-08-07 05:57:05","2021-08-07 05:57:05","1");
INSERT INTO audit_trail VALUES("4205","4","PERIS  NYAMBURA MWANGI","","Added expense with id:327","2021-08-07 05:59:05","2021-08-07 05:59:05","1");
INSERT INTO audit_trail VALUES("4206","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-07 06:10:11","2021-08-07 06:10:11","1");
INSERT INTO audit_trail VALUES("4207","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-08-07 06:11:14","2021-08-07 06:11:14","1");
INSERT INTO audit_trail VALUES("4208","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-09 01:36:08","2021-08-09 01:36:08","");
INSERT INTO audit_trail VALUES("4209","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:561","2021-08-09 01:37:37","2021-08-09 01:37:37","1");
INSERT INTO audit_trail VALUES("4210","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-09 01:50:02","2021-08-09 01:50:02","");
INSERT INTO audit_trail VALUES("4211","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:562","2021-08-09 02:57:07","2021-08-09 02:57:07","1");
INSERT INTO audit_trail VALUES("4212","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:563","2021-08-09 03:07:40","2021-08-09 03:07:40","1");
INSERT INTO audit_trail VALUES("4213","1","Admin Admin","","Logged in to system","2021-08-09 03:54:36","2021-08-09 03:54:36","");
INSERT INTO audit_trail VALUES("4214","4","PERIS  NYAMBURA MWANGI","","Logged in to system","2021-08-09 08:27:23","2021-08-09 08:27:23","");
INSERT INTO audit_trail VALUES("4215","2","CECILIA WANJERI WANGUHU","","Added expense with id:328","2021-08-09 09:51:50","2021-08-09 09:51:50","1");
INSERT INTO audit_trail VALUES("4216","4","PERIS  NYAMBURA MWANGI","","Logged out of system","2021-08-09 10:12:32","2021-08-09 10:12:32","1");
INSERT INTO audit_trail VALUES("4217","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-09 10:14:55","2021-08-09 10:14:55","1");
INSERT INTO audit_trail VALUES("4218","1","Admin Admin","","Logged in to system","2021-08-09 13:22:42","2021-08-09 13:22:42","");
INSERT INTO audit_trail VALUES("4219","1","Admin Admin","","Logged in to system","2021-08-10 05:11:53","2021-08-10 05:11:53","");
INSERT INTO audit_trail VALUES("4220","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-10 08:46:37","2021-08-10 08:46:37","");
INSERT INTO audit_trail VALUES("4221","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-10 08:47:17","2021-08-10 08:47:17","1");
INSERT INTO audit_trail VALUES("4222","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:564","2021-08-10 08:48:16","2021-08-10 08:48:16","1");
INSERT INTO audit_trail VALUES("4223","2","CECILIA WANJERI WANGUHU","","Added expense with id:329","2021-08-10 08:54:25","2021-08-10 08:54:25","1");
INSERT INTO audit_trail VALUES("4224","2","CECILIA WANJERI WANGUHU","","Added expense with id:330","2021-08-10 08:56:02","2021-08-10 08:56:02","1");
INSERT INTO audit_trail VALUES("4225","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-10 09:55:33","2021-08-10 09:55:33","1");
INSERT INTO audit_trail VALUES("4226","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:565","2021-08-10 10:02:11","2021-08-10 10:02:11","1");
INSERT INTO audit_trail VALUES("4227","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-10 10:13:54","2021-08-10 10:13:54","1");
INSERT INTO audit_trail VALUES("4228","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-10 10:18:25","2021-08-10 10:18:25","1");
INSERT INTO audit_trail VALUES("4229","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:566","2021-08-10 10:25:03","2021-08-10 10:25:03","1");
INSERT INTO audit_trail VALUES("4230","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-10 10:27:24","2021-08-10 10:27:24","1");
INSERT INTO audit_trail VALUES("4231","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-10 10:30:58","2021-08-10 10:30:58","");
INSERT INTO audit_trail VALUES("4232","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:567","2021-08-11 01:32:42","2021-08-11 01:32:42","1");
INSERT INTO audit_trail VALUES("4233","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:568","2021-08-11 01:34:14","2021-08-11 01:34:14","1");
INSERT INTO audit_trail VALUES("4234","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:569","2021-08-11 01:36:07","2021-08-11 01:36:07","1");
INSERT INTO audit_trail VALUES("4235","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:570","2021-08-11 01:48:36","2021-08-11 01:48:36","1");
INSERT INTO audit_trail VALUES("4236","2","CECILIA WANJERI WANGUHU","","Added loan with id:223","2021-08-11 03:41:01","2021-08-11 03:41:01","1");
INSERT INTO audit_trail VALUES("4237","2","CECILIA WANJERI WANGUHU","","Approved loan with id:223","2021-08-11 03:42:00","2021-08-11 03:42:00","1");
INSERT INTO audit_trail VALUES("4238","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:223","2021-08-11 03:44:02","2021-08-11 03:44:02","1");
INSERT INTO audit_trail VALUES("4239","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:223","2021-08-11 03:44:03","2021-08-11 03:44:03","1");
INSERT INTO audit_trail VALUES("4240","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-11 03:50:16","2021-08-11 03:50:16","1");
INSERT INTO audit_trail VALUES("4241","1","Admin Admin","","Logged in to system","2021-08-11 04:12:04","2021-08-11 04:12:04","");
INSERT INTO audit_trail VALUES("4242","1","Admin Admin","","Added loan product with id:6","2021-08-11 04:42:07","2021-08-11 04:42:07","1");
INSERT INTO audit_trail VALUES("4243","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:571","2021-08-11 04:52:34","2021-08-11 04:52:34","1");
INSERT INTO audit_trail VALUES("4244","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:572","2021-08-11 04:56:20","2021-08-11 04:56:20","1");
INSERT INTO audit_trail VALUES("4245","2","CECILIA WANJERI WANGUHU","","Added loan with id:224","2021-08-11 05:14:06","2021-08-11 05:14:06","1");
INSERT INTO audit_trail VALUES("4246","2","CECILIA WANJERI WANGUHU","","Approved loan with id:224","2021-08-11 05:15:05","2021-08-11 05:15:05","1");
INSERT INTO audit_trail VALUES("4247","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:224","2021-08-11 05:15:27","2021-08-11 05:15:27","1");
INSERT INTO audit_trail VALUES("4248","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25053","2021-08-11 06:29:19","2021-08-11 06:29:19","1");
INSERT INTO audit_trail VALUES("4249","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25055","2021-08-11 06:31:41","2021-08-11 06:31:41","1");
INSERT INTO audit_trail VALUES("4250","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25082","2021-08-11 07:46:12","2021-08-11 07:46:12","1");
INSERT INTO audit_trail VALUES("4251","2","CECILIA WANJERI WANGUHU","","Added expense with id:331","2021-08-11 08:26:29","2021-08-11 08:26:29","1");
INSERT INTO audit_trail VALUES("4252","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-11 10:44:02","2021-08-11 10:44:02","1");
INSERT INTO audit_trail VALUES("4253","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-12 01:30:50","2021-08-12 01:30:50","1");
INSERT INTO audit_trail VALUES("4254","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:573","2021-08-12 01:32:49","2021-08-12 01:32:49","1");
INSERT INTO audit_trail VALUES("4255","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-12 01:35:16","2021-08-12 01:35:16","1");
INSERT INTO audit_trail VALUES("4256","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-12 05:36:00","2021-08-12 05:36:00","1");
INSERT INTO audit_trail VALUES("4257","2","CECILIA WANJERI WANGUHU","","Added expense with id:332","2021-08-12 09:03:48","2021-08-12 09:03:48","1");
INSERT INTO audit_trail VALUES("4258","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-12 10:31:39","2021-08-12 10:31:39","1");
INSERT INTO audit_trail VALUES("4259","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-12 10:45:19","2021-08-12 10:45:19","1");
INSERT INTO audit_trail VALUES("4260","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:573","2021-08-13 02:22:08","2021-08-13 02:22:08","1");
INSERT INTO audit_trail VALUES("4261","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:567","2021-08-13 02:22:29","2021-08-13 02:22:29","1");
INSERT INTO audit_trail VALUES("4262","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:574","2021-08-13 02:29:09","2021-08-13 02:29:09","1");
INSERT INTO audit_trail VALUES("4263","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:575","2021-08-13 02:30:04","2021-08-13 02:30:04","1");
INSERT INTO audit_trail VALUES("4264","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:576","2021-08-13 02:31:19","2021-08-13 02:31:19","1");
INSERT INTO audit_trail VALUES("4265","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:576","2021-08-13 02:31:51","2021-08-13 02:31:51","1");
INSERT INTO audit_trail VALUES("4266","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:567","2021-08-13 02:36:24","2021-08-13 02:36:24","1");
INSERT INTO audit_trail VALUES("4267","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:573","2021-08-13 02:36:53","2021-08-13 02:36:53","1");
INSERT INTO audit_trail VALUES("4268","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:577","2021-08-13 02:38:15","2021-08-13 02:38:15","1");
INSERT INTO audit_trail VALUES("4269","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-13 02:57:04","2021-08-13 02:57:04","1");
INSERT INTO audit_trail VALUES("4270","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:572","2021-08-13 03:00:51","2021-08-13 03:00:51","1");
INSERT INTO audit_trail VALUES("4271","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:578","2021-08-13 03:01:59","2021-08-13 03:01:59","1");
INSERT INTO audit_trail VALUES("4272","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:579","2021-08-13 03:11:23","2021-08-13 03:11:23","1");
INSERT INTO audit_trail VALUES("4273","2","CECILIA WANJERI WANGUHU","","Added expense with id:333","2021-08-13 03:17:45","2021-08-13 03:17:45","1");
INSERT INTO audit_trail VALUES("4274","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-13 03:28:56","2021-08-13 03:28:56","1");
INSERT INTO audit_trail VALUES("4275","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25230","2021-08-13 03:35:34","2021-08-13 03:35:34","1");
INSERT INTO audit_trail VALUES("4276","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25277","2021-08-13 06:39:44","2021-08-13 06:39:44","1");
INSERT INTO audit_trail VALUES("4277","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25279","2021-08-13 06:47:57","2021-08-13 06:47:57","1");
INSERT INTO audit_trail VALUES("4278","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25281","2021-08-13 06:52:20","2021-08-13 06:52:20","1");
INSERT INTO audit_trail VALUES("4279","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-13 10:16:13","2021-08-13 10:16:13","1");
INSERT INTO audit_trail VALUES("4280","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-14 01:43:21","2021-08-14 01:43:21","1");
INSERT INTO audit_trail VALUES("4281","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:580","2021-08-14 01:44:46","2021-08-14 01:44:46","1");
INSERT INTO audit_trail VALUES("4282","2","CECILIA WANJERI WANGUHU","","Added expense with id:334","2021-08-14 01:49:24","2021-08-14 01:49:24","1");
INSERT INTO audit_trail VALUES("4283","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-14 02:52:51","2021-08-14 02:52:51","1");
INSERT INTO audit_trail VALUES("4284","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-14 02:55:54","2021-08-14 02:55:54","1");
INSERT INTO audit_trail VALUES("4285","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:581","2021-08-14 03:09:05","2021-08-14 03:09:05","1");
INSERT INTO audit_trail VALUES("4286","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:582","2021-08-14 03:14:13","2021-08-14 03:14:13","1");
INSERT INTO audit_trail VALUES("4287","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:581","2021-08-14 03:19:20","2021-08-14 03:19:20","1");
INSERT INTO audit_trail VALUES("4288","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-14 07:05:28","2021-08-14 07:05:28","1");
INSERT INTO audit_trail VALUES("4289","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-16 01:45:15","2021-08-16 01:45:15","");
INSERT INTO audit_trail VALUES("4290","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:583","2021-08-16 01:47:36","2021-08-16 01:47:36","1");
INSERT INTO audit_trail VALUES("4291","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-16 02:56:06","2021-08-16 02:56:06","");
INSERT INTO audit_trail VALUES("4292","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-16 03:40:29","2021-08-16 03:40:29","");
INSERT INTO audit_trail VALUES("4293","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-16 03:40:37","2021-08-16 03:40:37","");
INSERT INTO audit_trail VALUES("4294","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:584","2021-08-16 04:09:29","2021-08-16 04:09:29","1");
INSERT INTO audit_trail VALUES("4295","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25416","2021-08-16 05:57:04","2021-08-16 05:57:04","1");
INSERT INTO audit_trail VALUES("4296","1","Admin Admin","","Logged in to system","2021-08-16 08:05:36","2021-08-16 08:05:36","");
INSERT INTO audit_trail VALUES("4297","2","CECILIA WANJERI WANGUHU","","Added expense with id:335","2021-08-16 08:18:30","2021-08-16 08:18:30","1");
INSERT INTO audit_trail VALUES("4298","2","CECILIA WANJERI WANGUHU","","Updated expense with id:31","2021-08-16 10:27:44","2021-08-16 10:27:44","1");
INSERT INTO audit_trail VALUES("4299","2","CECILIA WANJERI WANGUHU","","Added expense with id:336","2021-08-16 10:29:29","2021-08-16 10:29:29","1");
INSERT INTO audit_trail VALUES("4300","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-16 11:36:46","2021-08-16 11:36:46","1");
INSERT INTO audit_trail VALUES("4301","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-17 01:03:07","2021-08-17 01:03:07","1");
INSERT INTO audit_trail VALUES("4302","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-17 01:33:07","2021-08-17 01:33:07","1");
INSERT INTO audit_trail VALUES("4303","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:585","2021-08-17 01:35:09","2021-08-17 01:35:09","1");
INSERT INTO audit_trail VALUES("4304","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:585","2021-08-17 01:35:53","2021-08-17 01:35:53","1");
INSERT INTO audit_trail VALUES("4305","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-17 02:32:00","2021-08-17 02:32:00","1");
INSERT INTO audit_trail VALUES("4306","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:52","2021-08-17 02:35:06","2021-08-17 02:35:06","1");
INSERT INTO audit_trail VALUES("4307","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:52","2021-08-17 02:35:15","2021-08-17 02:35:15","1");
INSERT INTO audit_trail VALUES("4308","2","CECILIA WANJERI WANGUHU","","Updated loan with id:52","2021-08-17 02:36:02","2021-08-17 02:36:02","1");
INSERT INTO audit_trail VALUES("4309","2","CECILIA WANJERI WANGUHU","","Approved loan with id:52","2021-08-17 02:39:54","2021-08-17 02:39:54","1");
INSERT INTO audit_trail VALUES("4310","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:52","2021-08-17 02:40:10","2021-08-17 02:40:10","1");
INSERT INTO audit_trail VALUES("4311","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:52","2021-08-17 02:41:50","2021-08-17 02:41:50","1");
INSERT INTO audit_trail VALUES("4312","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:37","2021-08-17 03:14:45","2021-08-17 03:14:45","1");
INSERT INTO audit_trail VALUES("4313","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:37","2021-08-17 03:14:55","2021-08-17 03:14:55","1");
INSERT INTO audit_trail VALUES("4314","2","CECILIA WANJERI WANGUHU","","Updated loan with id:37","2021-08-17 03:15:38","2021-08-17 03:15:38","1");
INSERT INTO audit_trail VALUES("4315","2","CECILIA WANJERI WANGUHU","","Approved loan with id:37","2021-08-17 03:16:24","2021-08-17 03:16:24","1");
INSERT INTO audit_trail VALUES("4316","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:37","2021-08-17 03:16:37","2021-08-17 03:16:37","1");
INSERT INTO audit_trail VALUES("4317","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:37","2021-08-17 03:17:18","2021-08-17 03:17:18","1");
INSERT INTO audit_trail VALUES("4318","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:586","2021-08-17 05:03:02","2021-08-17 05:03:02","1");
INSERT INTO audit_trail VALUES("4319","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:587","2021-08-17 05:04:01","2021-08-17 05:04:01","1");
INSERT INTO audit_trail VALUES("4320","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:588","2021-08-17 05:04:51","2021-08-17 05:04:51","1");
INSERT INTO audit_trail VALUES("4321","2","CECILIA WANJERI WANGUHU","","Added expense with id:337","2021-08-17 08:32:23","2021-08-17 08:32:23","1");
INSERT INTO audit_trail VALUES("4322","2","CECILIA WANJERI WANGUHU","","Added expense with id:338","2021-08-17 08:35:31","2021-08-17 08:35:31","1");
INSERT INTO audit_trail VALUES("4323","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-17 10:41:32","2021-08-17 10:41:32","1");
INSERT INTO audit_trail VALUES("4324","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-17 10:43:26","2021-08-17 10:43:26","1");
INSERT INTO audit_trail VALUES("4325","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-18 01:27:30","2021-08-18 01:27:30","1");
INSERT INTO audit_trail VALUES("4326","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:589","2021-08-18 01:29:45","2021-08-18 01:29:45","1");
INSERT INTO audit_trail VALUES("4327","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:590","2021-08-18 01:31:08","2021-08-18 01:31:08","1");
INSERT INTO audit_trail VALUES("4328","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:591","2021-08-18 01:35:35","2021-08-18 01:35:35","1");
INSERT INTO audit_trail VALUES("4329","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:592","2021-08-18 01:36:27","2021-08-18 01:36:27","1");
INSERT INTO audit_trail VALUES("4330","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:593","2021-08-18 01:40:10","2021-08-18 01:40:10","1");
INSERT INTO audit_trail VALUES("4331","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:594","2021-08-18 01:41:51","2021-08-18 01:41:51","1");
INSERT INTO audit_trail VALUES("4332","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:595","2021-08-18 01:52:51","2021-08-18 01:52:51","1");
INSERT INTO audit_trail VALUES("4333","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:596","2021-08-18 01:55:42","2021-08-18 01:55:42","1");
INSERT INTO audit_trail VALUES("4334","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:597","2021-08-18 01:58:31","2021-08-18 01:58:31","1");
INSERT INTO audit_trail VALUES("4335","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:598","2021-08-18 02:02:02","2021-08-18 02:02:02","1");
INSERT INTO audit_trail VALUES("4336","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:599","2021-08-18 02:02:50","2021-08-18 02:02:50","1");
INSERT INTO audit_trail VALUES("4337","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:600","2021-08-18 02:07:50","2021-08-18 02:07:50","1");
INSERT INTO audit_trail VALUES("4338","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:600","2021-08-18 02:08:27","2021-08-18 02:08:27","1");
INSERT INTO audit_trail VALUES("4339","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:601","2021-08-18 02:09:27","2021-08-18 02:09:27","1");
INSERT INTO audit_trail VALUES("4340","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:602","2021-08-18 02:10:56","2021-08-18 02:10:56","1");
INSERT INTO audit_trail VALUES("4341","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:594","2021-08-18 02:19:33","2021-08-18 02:19:33","1");
INSERT INTO audit_trail VALUES("4342","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:603","2021-08-18 02:21:12","2021-08-18 02:21:12","1");
INSERT INTO audit_trail VALUES("4343","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:604","2021-08-18 02:21:12","2021-08-18 02:21:12","1");
INSERT INTO audit_trail VALUES("4344","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:605","2021-08-18 02:21:56","2021-08-18 02:21:56","1");
INSERT INTO audit_trail VALUES("4345","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:605","2021-08-18 02:22:30","2021-08-18 02:22:30","1");
INSERT INTO audit_trail VALUES("4346","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:606","2021-08-18 02:27:59","2021-08-18 02:27:59","1");
INSERT INTO audit_trail VALUES("4347","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:607","2021-08-18 02:34:45","2021-08-18 02:34:45","1");
INSERT INTO audit_trail VALUES("4348","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:608","2021-08-18 02:37:03","2021-08-18 02:37:03","1");
INSERT INTO audit_trail VALUES("4349","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:284","2021-08-18 02:41:30","2021-08-18 02:41:30","1");
INSERT INTO audit_trail VALUES("4350","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:266","2021-08-18 02:42:32","2021-08-18 02:42:32","1");
INSERT INTO audit_trail VALUES("4351","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:259","2021-08-18 02:43:17","2021-08-18 02:43:17","1");
INSERT INTO audit_trail VALUES("4352","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:248","2021-08-18 02:47:12","2021-08-18 02:47:12","1");
INSERT INTO audit_trail VALUES("4353","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-18 03:24:16","2021-08-18 03:24:16","1");
INSERT INTO audit_trail VALUES("4354","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-18 03:28:45","2021-08-18 03:28:45","1");
INSERT INTO audit_trail VALUES("4355","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-18 04:43:53","2021-08-18 04:43:53","1");
INSERT INTO audit_trail VALUES("4356","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:25679","2021-08-18 04:47:13","2021-08-18 04:47:13","1");
INSERT INTO audit_trail VALUES("4357","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:609","2021-08-18 05:38:38","2021-08-18 05:38:38","1");
INSERT INTO audit_trail VALUES("4358","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:610","2021-08-18 05:45:27","2021-08-18 05:45:27","1");
INSERT INTO audit_trail VALUES("4359","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-18 05:54:04","2021-08-18 05:54:04","1");
INSERT INTO audit_trail VALUES("4360","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-18 05:58:38","2021-08-18 05:58:38","1");
INSERT INTO audit_trail VALUES("4361","2","CECILIA WANJERI WANGUHU","","Added expense with id:339","2021-08-18 09:51:28","2021-08-18 09:51:28","1");
INSERT INTO audit_trail VALUES("4362","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-18 10:03:47","2021-08-18 10:03:47","1");
INSERT INTO audit_trail VALUES("4363","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-18 10:07:00","2021-08-18 10:07:00","1");
INSERT INTO audit_trail VALUES("4364","1","Admin Admin","","Logged in to system","2021-08-18 16:23:24","2021-08-18 16:23:24","");
INSERT INTO audit_trail VALUES("4365","1","Admin Admin","","Logged in to system","2021-08-18 16:23:27","2021-08-18 16:23:27","1");
INSERT INTO audit_trail VALUES("4366","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-19 01:33:04","2021-08-19 01:33:04","1");
INSERT INTO audit_trail VALUES("4367","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:611","2021-08-19 01:35:06","2021-08-19 01:35:06","1");
INSERT INTO audit_trail VALUES("4368","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-19 01:41:23","2021-08-19 01:41:23","1");
INSERT INTO audit_trail VALUES("4369","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-19 01:41:24","2021-08-19 01:41:24","1");
INSERT INTO audit_trail VALUES("4370","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-19 02:15:55","2021-08-19 02:15:55","1");
INSERT INTO audit_trail VALUES("4371","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:612","2021-08-19 06:59:07","2021-08-19 06:59:07","1");
INSERT INTO audit_trail VALUES("4372","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:613","2021-08-19 07:04:18","2021-08-19 07:04:18","1");
INSERT INTO audit_trail VALUES("4373","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-19 11:02:41","2021-08-19 11:02:41","1");
INSERT INTO audit_trail VALUES("4374","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-20 01:48:19","2021-08-20 01:48:19","1");
INSERT INTO audit_trail VALUES("4375","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:614","2021-08-20 01:49:15","2021-08-20 01:49:15","1");
INSERT INTO audit_trail VALUES("4376","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:71","2021-08-20 03:56:12","2021-08-20 03:56:12","1");
INSERT INTO audit_trail VALUES("4377","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:71","2021-08-20 03:56:24","2021-08-20 03:56:24","1");
INSERT INTO audit_trail VALUES("4378","2","CECILIA WANJERI WANGUHU","","Approved loan with id:71","2021-08-20 03:57:58","2021-08-20 03:57:58","1");
INSERT INTO audit_trail VALUES("4379","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:71","2021-08-20 03:58:37","2021-08-20 03:58:37","1");
INSERT INTO audit_trail VALUES("4380","2","CECILIA WANJERI WANGUHU","","Updated loan with id:71","2021-08-20 03:59:21","2021-08-20 03:59:21","1");
INSERT INTO audit_trail VALUES("4381","2","CECILIA WANJERI WANGUHU","","Approved loan with id:71","2021-08-20 04:00:31","2021-08-20 04:00:31","1");
INSERT INTO audit_trail VALUES("4382","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:71","2021-08-20 04:01:00","2021-08-20 04:01:00","1");
INSERT INTO audit_trail VALUES("4383","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:71","2021-08-20 04:01:00","2021-08-20 04:01:00","1");
INSERT INTO audit_trail VALUES("4384","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-20 04:06:25","2021-08-20 04:06:25","");
INSERT INTO audit_trail VALUES("4385","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:71","2021-08-20 04:07:26","2021-08-20 04:07:26","1");
INSERT INTO audit_trail VALUES("4386","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:71","2021-08-20 04:07:33","2021-08-20 04:07:33","1");
INSERT INTO audit_trail VALUES("4387","2","CECILIA WANJERI WANGUHU","","Updated loan with id:71","2021-08-20 04:08:24","2021-08-20 04:08:24","1");
INSERT INTO audit_trail VALUES("4388","2","CECILIA WANJERI WANGUHU","","Approved loan with id:71","2021-08-20 04:09:34","2021-08-20 04:09:34","1");
INSERT INTO audit_trail VALUES("4389","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:71","2021-08-20 04:09:58","2021-08-20 04:09:58","1");
INSERT INTO audit_trail VALUES("4390","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:71","2021-08-20 04:10:33","2021-08-20 04:10:33","1");
INSERT INTO audit_trail VALUES("4391","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:615","2021-08-20 04:35:56","2021-08-20 04:35:56","1");
INSERT INTO audit_trail VALUES("4392","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:87","2021-08-20 05:15:42","2021-08-20 05:15:42","1");
INSERT INTO audit_trail VALUES("4393","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:87","2021-08-20 05:15:50","2021-08-20 05:15:50","1");
INSERT INTO audit_trail VALUES("4394","2","CECILIA WANJERI WANGUHU","","Updated loan with id:87","2021-08-20 05:17:52","2021-08-20 05:17:52","1");
INSERT INTO audit_trail VALUES("4395","2","CECILIA WANJERI WANGUHU","","Approved loan with id:87","2021-08-20 05:26:54","2021-08-20 05:26:54","1");
INSERT INTO audit_trail VALUES("4396","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:87","2021-08-20 05:27:07","2021-08-20 05:27:07","1");
INSERT INTO audit_trail VALUES("4397","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:87","2021-08-20 05:29:52","2021-08-20 05:29:52","1");
INSERT INTO audit_trail VALUES("4398","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:87","2021-08-20 05:30:26","2021-08-20 05:30:26","1");
INSERT INTO audit_trail VALUES("4399","2","CECILIA WANJERI WANGUHU","","Updated loan with id:87","2021-08-20 05:31:33","2021-08-20 05:31:33","1");
INSERT INTO audit_trail VALUES("4400","2","CECILIA WANJERI WANGUHU","","Approved loan with id:87","2021-08-20 05:32:28","2021-08-20 05:32:28","1");
INSERT INTO audit_trail VALUES("4401","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:87","2021-08-20 05:32:46","2021-08-20 05:32:46","1");
INSERT INTO audit_trail VALUES("4402","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:87","2021-08-20 05:34:03","2021-08-20 05:34:03","1");
INSERT INTO audit_trail VALUES("4403","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:616","2021-08-20 08:19:10","2021-08-20 08:19:10","1");
INSERT INTO audit_trail VALUES("4404","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:617","2021-08-20 08:19:49","2021-08-20 08:19:49","1");
INSERT INTO audit_trail VALUES("4405","2","CECILIA WANJERI WANGUHU","","Added expense with id:340","2021-08-20 08:20:24","2021-08-20 08:20:24","1");
INSERT INTO audit_trail VALUES("4406","2","CECILIA WANJERI WANGUHU","","Added expense with id:341","2021-08-20 09:39:53","2021-08-20 09:39:53","1");
INSERT INTO audit_trail VALUES("4407","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-20 09:54:20","2021-08-20 09:54:20","1");
INSERT INTO audit_trail VALUES("4408","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-20 10:00:52","2021-08-20 10:00:52","1");
INSERT INTO audit_trail VALUES("4409","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-21 01:37:19","2021-08-21 01:37:19","1");
INSERT INTO audit_trail VALUES("4410","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:618","2021-08-21 01:38:33","2021-08-21 01:38:33","1");
INSERT INTO audit_trail VALUES("4411","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-21 01:57:19","2021-08-21 01:57:19","");
INSERT INTO audit_trail VALUES("4412","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:619","2021-08-21 02:37:45","2021-08-21 02:37:45","1");
INSERT INTO audit_trail VALUES("4413","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:620","2021-08-21 02:50:01","2021-08-21 02:50:01","1");
INSERT INTO audit_trail VALUES("4414","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:621","2021-08-21 02:55:50","2021-08-21 02:55:50","1");
INSERT INTO audit_trail VALUES("4415","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:620","2021-08-21 02:56:19","2021-08-21 02:56:19","1");
INSERT INTO audit_trail VALUES("4416","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:348","2021-08-21 02:58:17","2021-08-21 02:58:17","1");
INSERT INTO audit_trail VALUES("4417","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:348","2021-08-21 02:59:46","2021-08-21 02:59:46","1");
INSERT INTO audit_trail VALUES("4418","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:622","2021-08-21 03:02:25","2021-08-21 03:02:25","1");
INSERT INTO audit_trail VALUES("4419","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:367","2021-08-21 03:07:19","2021-08-21 03:07:19","1");
INSERT INTO audit_trail VALUES("4420","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:623","2021-08-21 03:11:06","2021-08-21 03:11:06","1");
INSERT INTO audit_trail VALUES("4421","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:624","2021-08-21 03:12:59","2021-08-21 03:12:59","1");
INSERT INTO audit_trail VALUES("4422","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:625","2021-08-21 03:16:28","2021-08-21 03:16:28","1");
INSERT INTO audit_trail VALUES("4423","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:626","2021-08-21 03:22:53","2021-08-21 03:22:53","1");
INSERT INTO audit_trail VALUES("4424","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-21 06:24:09","2021-08-21 06:24:09","");
INSERT INTO audit_trail VALUES("4425","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-21 08:22:20","2021-08-21 08:22:20","1");
INSERT INTO audit_trail VALUES("4426","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-21 08:24:13","2021-08-21 08:24:13","1");
INSERT INTO audit_trail VALUES("4427","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-23 02:33:35","2021-08-23 02:33:35","");
INSERT INTO audit_trail VALUES("4428","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-23 04:23:10","2021-08-23 04:23:10","1");
INSERT INTO audit_trail VALUES("4429","2","CECILIA WANJERI WANGUHU","","Added expense with id:342","2021-08-23 04:24:53","2021-08-23 04:24:53","1");
INSERT INTO audit_trail VALUES("4430","2","CECILIA WANJERI WANGUHU","","Added expense with id:343","2021-08-23 04:27:54","2021-08-23 04:27:54","1");
INSERT INTO audit_trail VALUES("4431","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:627","2021-08-23 04:29:33","2021-08-23 04:29:33","1");
INSERT INTO audit_trail VALUES("4432","2","CECILIA WANJERI WANGUHU","","Added loan with id:225","2021-08-23 06:02:52","2021-08-23 06:02:52","1");
INSERT INTO audit_trail VALUES("4433","2","CECILIA WANJERI WANGUHU","","Approved loan with id:225","2021-08-23 06:03:23","2021-08-23 06:03:23","1");
INSERT INTO audit_trail VALUES("4434","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:225","2021-08-23 06:49:20","2021-08-23 06:49:20","1");
INSERT INTO audit_trail VALUES("4435","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:26126","2021-08-23 07:11:13","2021-08-23 07:11:13","1");
INSERT INTO audit_trail VALUES("4436","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:628","2021-08-23 07:54:05","2021-08-23 07:54:05","1");
INSERT INTO audit_trail VALUES("4437","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:629","2021-08-23 07:55:19","2021-08-23 07:55:19","1");
INSERT INTO audit_trail VALUES("4438","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-23 10:14:18","2021-08-23 10:14:18","");
INSERT INTO audit_trail VALUES("4439","2","CECILIA WANJERI WANGUHU","","Added expense with id:344","2021-08-23 10:30:40","2021-08-23 10:30:40","1");
INSERT INTO audit_trail VALUES("4440","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-23 10:40:54","2021-08-23 10:40:54","1");
INSERT INTO audit_trail VALUES("4441","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-24 01:24:00","2021-08-24 01:24:00","1");
INSERT INTO audit_trail VALUES("4442","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:630","2021-08-24 01:28:23","2021-08-24 01:28:23","1");
INSERT INTO audit_trail VALUES("4443","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:631","2021-08-24 01:30:10","2021-08-24 01:30:10","1");
INSERT INTO audit_trail VALUES("4444","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-24 01:41:08","2021-08-24 01:41:08","1");
INSERT INTO audit_trail VALUES("4445","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:632","2021-08-24 01:52:31","2021-08-24 01:52:31","1");
INSERT INTO audit_trail VALUES("4446","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-24 02:18:05","2021-08-24 02:18:05","1");
INSERT INTO audit_trail VALUES("4447","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:633","2021-08-24 02:29:33","2021-08-24 02:29:33","1");
INSERT INTO audit_trail VALUES("4448","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-24 03:59:27","2021-08-24 03:59:27","1");
INSERT INTO audit_trail VALUES("4449","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-24 04:50:28","2021-08-24 04:50:28","1");
INSERT INTO audit_trail VALUES("4450","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-24 05:12:29","2021-08-24 05:12:29","");
INSERT INTO audit_trail VALUES("4451","1","Admin Admin","","Logged in to system","2021-08-24 05:33:01","2021-08-24 05:33:01","");
INSERT INTO audit_trail VALUES("4452","1","Admin Admin","","Updated role with id:4","2021-08-24 05:35:07","2021-08-24 05:35:07","1");
INSERT INTO audit_trail VALUES("4453","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-24 05:43:44","2021-08-24 05:43:44","1");
INSERT INTO audit_trail VALUES("4454","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-24 10:53:56","2021-08-24 10:53:56","1");
INSERT INTO audit_trail VALUES("4455","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-25 01:07:05","2021-08-25 01:07:05","1");
INSERT INTO audit_trail VALUES("4456","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:634","2021-08-25 01:08:58","2021-08-25 01:08:58","1");
INSERT INTO audit_trail VALUES("4457","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-25 01:31:44","2021-08-25 01:31:44","1");
INSERT INTO audit_trail VALUES("4458","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-25 01:55:31","2021-08-25 01:55:31","1");
INSERT INTO audit_trail VALUES("4459","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-25 04:45:41","2021-08-25 04:45:41","1");
INSERT INTO audit_trail VALUES("4460","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:170","2021-08-25 05:37:00","2021-08-25 05:37:00","1");
INSERT INTO audit_trail VALUES("4461","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:170","2021-08-25 05:37:16","2021-08-25 05:37:16","1");
INSERT INTO audit_trail VALUES("4462","2","CECILIA WANJERI WANGUHU","","Updated loan with id:170","2021-08-25 05:38:08","2021-08-25 05:38:08","1");
INSERT INTO audit_trail VALUES("4463","2","CECILIA WANJERI WANGUHU","","Approved loan with id:170","2021-08-25 05:39:04","2021-08-25 05:39:04","1");
INSERT INTO audit_trail VALUES("4464","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:170","2021-08-25 05:39:26","2021-08-25 05:39:26","1");
INSERT INTO audit_trail VALUES("4465","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:170","2021-08-25 05:40:02","2021-08-25 05:40:02","1");
INSERT INTO audit_trail VALUES("4466","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:20","2021-08-25 05:58:19","2021-08-25 05:58:19","1");
INSERT INTO audit_trail VALUES("4467","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:20","2021-08-25 05:58:28","2021-08-25 05:58:28","1");
INSERT INTO audit_trail VALUES("4468","2","CECILIA WANJERI WANGUHU","","Updated loan with id:20","2021-08-25 06:01:08","2021-08-25 06:01:08","1");
INSERT INTO audit_trail VALUES("4469","2","CECILIA WANJERI WANGUHU","","Approved loan with id:20","2021-08-25 06:02:37","2021-08-25 06:02:37","1");
INSERT INTO audit_trail VALUES("4470","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:20","2021-08-25 06:02:57","2021-08-25 06:02:57","1");
INSERT INTO audit_trail VALUES("4471","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-25 06:11:37","2021-08-25 06:11:37","1");
INSERT INTO audit_trail VALUES("4472","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-25 07:54:54","2021-08-25 07:54:54","");
INSERT INTO audit_trail VALUES("4473","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:26359","2021-08-25 08:00:31","2021-08-25 08:00:31","1");
INSERT INTO audit_trail VALUES("4474","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:635","2021-08-25 08:48:22","2021-08-25 08:48:22","1");
INSERT INTO audit_trail VALUES("4475","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-25 10:24:04","2021-08-25 10:24:04","1");
INSERT INTO audit_trail VALUES("4476","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-25 10:27:37","2021-08-25 10:27:37","1");
INSERT INTO audit_trail VALUES("4477","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-25 10:33:20","2021-08-25 10:33:20","1");
INSERT INTO audit_trail VALUES("4478","1","Admin Admin","","Logged in to system","2021-08-26 15:08:24","2021-08-26 15:08:24","");
INSERT INTO audit_trail VALUES("4479","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-27 01:56:49","2021-08-27 01:56:49","");
INSERT INTO audit_trail VALUES("4480","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:636","2021-08-27 01:58:25","2021-08-27 01:58:25","1");
INSERT INTO audit_trail VALUES("4481","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:636","2021-08-27 01:58:59","2021-08-27 01:58:59","1");
INSERT INTO audit_trail VALUES("4482","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-27 03:28:49","2021-08-27 03:28:49","");
INSERT INTO audit_trail VALUES("4483","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:637","2021-08-27 04:13:18","2021-08-27 04:13:18","1");
INSERT INTO audit_trail VALUES("4484","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-27 05:43:47","2021-08-27 05:43:47","");
INSERT INTO audit_trail VALUES("4485","2","CECILIA WANJERI WANGUHU","","Added expense with id:345","2021-08-27 08:24:05","2021-08-27 08:24:05","1");
INSERT INTO audit_trail VALUES("4486","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:638","2021-08-27 09:29:16","2021-08-27 09:29:16","1");
INSERT INTO audit_trail VALUES("4487","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-27 10:08:47","2021-08-27 10:08:47","1");
INSERT INTO audit_trail VALUES("4488","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-27 10:10:32","2021-08-27 10:10:32","1");
INSERT INTO audit_trail VALUES("4489","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-27 10:10:48","2021-08-27 10:10:48","1");
INSERT INTO audit_trail VALUES("4490","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-27 10:12:32","2021-08-27 10:12:32","1");
INSERT INTO audit_trail VALUES("4491","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-27 10:17:20","2021-08-27 10:17:20","1");
INSERT INTO audit_trail VALUES("4492","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-28 02:35:04","2021-08-28 02:35:04","1");
INSERT INTO audit_trail VALUES("4493","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:639","2021-08-28 02:36:46","2021-08-28 02:36:46","1");
INSERT INTO audit_trail VALUES("4494","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-28 02:45:49","2021-08-28 02:45:49","1");
INSERT INTO audit_trail VALUES("4495","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:640","2021-08-28 03:22:25","2021-08-28 03:22:25","1");
INSERT INTO audit_trail VALUES("4496","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:641","2021-08-28 03:30:44","2021-08-28 03:30:44","1");
INSERT INTO audit_trail VALUES("4497","2","CECILIA WANJERI WANGUHU","","Added expense with id:346","2021-08-28 06:31:04","2021-08-28 06:31:04","1");
INSERT INTO audit_trail VALUES("4498","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-28 07:23:38","2021-08-28 07:23:38","");
INSERT INTO audit_trail VALUES("4499","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-28 07:25:24","2021-08-28 07:25:24","1");
INSERT INTO audit_trail VALUES("4500","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-30 01:56:59","2021-08-30 01:56:59","");
INSERT INTO audit_trail VALUES("4501","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-30 02:51:12","2021-08-30 02:51:12","");
INSERT INTO audit_trail VALUES("4502","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-30 02:51:16","2021-08-30 02:51:16","1");
INSERT INTO audit_trail VALUES("4503","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:642","2021-08-30 02:55:22","2021-08-30 02:55:22","1");
INSERT INTO audit_trail VALUES("4504","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:643","2021-08-30 04:08:07","2021-08-30 04:08:07","1");
INSERT INTO audit_trail VALUES("4505","2","CECILIA WANJERI WANGUHU","","Added expense with id:347","2021-08-30 04:16:41","2021-08-30 04:16:41","1");
INSERT INTO audit_trail VALUES("4506","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:26679","2021-08-30 05:57:24","2021-08-30 05:57:24","1");
INSERT INTO audit_trail VALUES("4507","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-30 07:56:15","2021-08-30 07:56:15","");
INSERT INTO audit_trail VALUES("4508","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-30 10:50:05","2021-08-30 10:50:05","1");
INSERT INTO audit_trail VALUES("4509","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-30 10:54:09","2021-08-30 10:54:09","1");
INSERT INTO audit_trail VALUES("4510","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-30 10:55:40","2021-08-30 10:55:40","1");
INSERT INTO audit_trail VALUES("4511","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-31 01:28:30","2021-08-31 01:28:30","1");
INSERT INTO audit_trail VALUES("4512","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:644","2021-08-31 01:30:34","2021-08-31 01:30:34","1");
INSERT INTO audit_trail VALUES("4513","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:645","2021-08-31 01:50:31","2021-08-31 01:50:31","1");
INSERT INTO audit_trail VALUES("4514","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-31 02:01:07","2021-08-31 02:01:07","1");
INSERT INTO audit_trail VALUES("4515","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:646","2021-08-31 02:31:48","2021-08-31 02:31:48","1");
INSERT INTO audit_trail VALUES("4516","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:647","2021-08-31 02:32:46","2021-08-31 02:32:46","1");
INSERT INTO audit_trail VALUES("4517","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:648","2021-08-31 02:34:54","2021-08-31 02:34:54","1");
INSERT INTO audit_trail VALUES("4518","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-31 04:44:37","2021-08-31 04:44:37","1");
INSERT INTO audit_trail VALUES("4519","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-31 10:39:06","2021-08-31 10:39:06","1");
INSERT INTO audit_trail VALUES("4520","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-31 10:41:13","2021-08-31 10:41:13","1");
INSERT INTO audit_trail VALUES("4521","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-31 10:41:15","2021-08-31 10:41:15","1");
INSERT INTO audit_trail VALUES("4522","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-31 10:41:16","2021-08-31 10:41:16","1");
INSERT INTO audit_trail VALUES("4523","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-31 10:41:49","2021-08-31 10:41:49","1");
INSERT INTO audit_trail VALUES("4524","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-08-31 10:45:38","2021-08-31 10:45:38","1");
INSERT INTO audit_trail VALUES("4525","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-08-31 10:47:25","2021-08-31 10:47:25","1");
INSERT INTO audit_trail VALUES("4526","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-01 01:55:35","2021-09-01 01:55:35","1");
INSERT INTO audit_trail VALUES("4527","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:649","2021-09-01 01:57:14","2021-09-01 01:57:14","1");
INSERT INTO audit_trail VALUES("4528","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-01 02:00:52","2021-09-01 02:00:52","1");
INSERT INTO audit_trail VALUES("4529","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-01 02:01:13","2021-09-01 02:01:13","1");
INSERT INTO audit_trail VALUES("4530","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:650","2021-09-01 06:59:11","2021-09-01 06:59:11","1");
INSERT INTO audit_trail VALUES("4531","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:651","2021-09-01 08:22:55","2021-09-01 08:22:55","1");
INSERT INTO audit_trail VALUES("4532","1","Admin Admin","","Logged in to system","2021-09-01 08:39:47","2021-09-01 08:39:47","");
INSERT INTO audit_trail VALUES("4533","2","CECILIA WANJERI WANGUHU","","Added expense with id:348","2021-09-01 10:34:38","2021-09-01 10:34:38","1");
INSERT INTO audit_trail VALUES("4534","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-01 10:36:25","2021-09-01 10:36:25","1");
INSERT INTO audit_trail VALUES("4535","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-01 10:38:18","2021-09-01 10:38:18","1");
INSERT INTO audit_trail VALUES("4536","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-01 10:40:25","2021-09-01 10:40:25","1");
INSERT INTO audit_trail VALUES("4537","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-02 01:45:23","2021-09-02 01:45:23","1");
INSERT INTO audit_trail VALUES("4538","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:652","2021-09-02 01:46:53","2021-09-02 01:46:53","1");
INSERT INTO audit_trail VALUES("4539","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:653","2021-09-02 01:47:55","2021-09-02 01:47:55","1");
INSERT INTO audit_trail VALUES("4540","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:654","2021-09-02 02:12:04","2021-09-02 02:12:04","1");
INSERT INTO audit_trail VALUES("4541","1","Admin Admin","","Logged in to system","2021-09-02 04:45:05","2021-09-02 04:45:05","");
INSERT INTO audit_trail VALUES("4542","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-02 05:06:39","2021-09-02 05:06:39","1");
INSERT INTO audit_trail VALUES("4543","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:655","2021-09-02 05:13:22","2021-09-02 05:13:22","1");
INSERT INTO audit_trail VALUES("4544","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:655","2021-09-02 05:13:55","2021-09-02 05:13:55","1");
INSERT INTO audit_trail VALUES("4545","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:656","2021-09-02 05:14:38","2021-09-02 05:14:38","1");
INSERT INTO audit_trail VALUES("4546","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:657","2021-09-02 05:15:22","2021-09-02 05:15:22","1");
INSERT INTO audit_trail VALUES("4547","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:657","2021-09-02 05:15:50","2021-09-02 05:15:50","1");
INSERT INTO audit_trail VALUES("4548","2","CECILIA WANJERI WANGUHU","","Added expense with id:349","2021-09-02 05:17:25","2021-09-02 05:17:25","1");
INSERT INTO audit_trail VALUES("4549","2","CECILIA WANJERI WANGUHU","","Updated expense with id:349","2021-09-02 05:20:46","2021-09-02 05:20:46","1");
INSERT INTO audit_trail VALUES("4550","2","CECILIA WANJERI WANGUHU","","Added expense with id:350","2021-09-02 05:21:46","2021-09-02 05:21:46","1");
INSERT INTO audit_trail VALUES("4551","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:658","2021-09-02 05:24:16","2021-09-02 05:24:16","1");
INSERT INTO audit_trail VALUES("4552","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:658","2021-09-02 05:25:15","2021-09-02 05:25:15","1");
INSERT INTO audit_trail VALUES("4553","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-02 10:27:46","2021-09-02 10:27:46","1");
INSERT INTO audit_trail VALUES("4554","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-02 10:29:59","2021-09-02 10:29:59","");
INSERT INTO audit_trail VALUES("4555","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-03 01:56:00","2021-09-03 01:56:00","1");
INSERT INTO audit_trail VALUES("4556","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:659","2021-09-03 02:09:14","2021-09-03 02:09:14","1");
INSERT INTO audit_trail VALUES("4557","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-03 02:30:49","2021-09-03 02:30:49","1");
INSERT INTO audit_trail VALUES("4558","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27221","2021-09-03 05:00:44","2021-09-03 05:00:44","1");
INSERT INTO audit_trail VALUES("4559","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:660","2021-09-03 06:58:26","2021-09-03 06:58:26","1");
INSERT INTO audit_trail VALUES("4560","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:661","2021-09-03 08:30:42","2021-09-03 08:30:42","1");
INSERT INTO audit_trail VALUES("4561","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-03 11:01:10","2021-09-03 11:01:10","1");
INSERT INTO audit_trail VALUES("4562","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-03 11:14:38","2021-09-03 11:14:38","");
INSERT INTO audit_trail VALUES("4563","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-03 11:17:53","2021-09-03 11:17:53","1");
INSERT INTO audit_trail VALUES("4564","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-04 01:40:33","2021-09-04 01:40:33","1");
INSERT INTO audit_trail VALUES("4565","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:662","2021-09-04 01:42:05","2021-09-04 01:42:05","1");
INSERT INTO audit_trail VALUES("4566","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-04 03:13:14","2021-09-04 03:13:14","1");
INSERT INTO audit_trail VALUES("4567","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27317","2021-09-04 03:15:30","2021-09-04 03:15:30","1");
INSERT INTO audit_trail VALUES("4568","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27319","2021-09-04 03:23:39","2021-09-04 03:23:39","1");
INSERT INTO audit_trail VALUES("4569","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27321","2021-09-04 03:26:14","2021-09-04 03:26:14","1");
INSERT INTO audit_trail VALUES("4570","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27323","2021-09-04 03:45:44","2021-09-04 03:45:44","1");
INSERT INTO audit_trail VALUES("4571","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-04 03:46:17","2021-09-04 03:46:17","1");
INSERT INTO audit_trail VALUES("4572","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27325","2021-09-04 04:00:25","2021-09-04 04:00:25","1");
INSERT INTO audit_trail VALUES("4573","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-04 04:01:04","2021-09-04 04:01:04","1");
INSERT INTO audit_trail VALUES("4574","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27327","2021-09-04 04:25:31","2021-09-04 04:25:31","1");
INSERT INTO audit_trail VALUES("4575","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27329","2021-09-04 04:27:25","2021-09-04 04:27:25","1");
INSERT INTO audit_trail VALUES("4576","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27331","2021-09-04 04:30:18","2021-09-04 04:30:18","1");
INSERT INTO audit_trail VALUES("4577","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27333","2021-09-04 04:32:15","2021-09-04 04:32:15","1");
INSERT INTO audit_trail VALUES("4578","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27335","2021-09-04 04:39:17","2021-09-04 04:39:17","1");
INSERT INTO audit_trail VALUES("4579","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27337","2021-09-04 04:41:44","2021-09-04 04:41:44","1");
INSERT INTO audit_trail VALUES("4580","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-04 05:04:35","2021-09-04 05:04:35","1");
INSERT INTO audit_trail VALUES("4581","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:663","2021-09-04 06:39:35","2021-09-04 06:39:35","1");
INSERT INTO audit_trail VALUES("4582","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:664","2021-09-04 06:40:19","2021-09-04 06:40:19","1");
INSERT INTO audit_trail VALUES("4583","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:665","2021-09-04 06:40:55","2021-09-04 06:40:55","1");
INSERT INTO audit_trail VALUES("4584","2","CECILIA WANJERI WANGUHU","","Added expense with id:351","2021-09-04 06:41:52","2021-09-04 06:41:52","1");
INSERT INTO audit_trail VALUES("4585","2","CECILIA WANJERI WANGUHU","","Added expense with id:352","2021-09-04 06:50:02","2021-09-04 06:50:02","1");
INSERT INTO audit_trail VALUES("4586","2","CECILIA WANJERI WANGUHU","","Added expense with id:353","2021-09-04 06:51:35","2021-09-04 06:51:35","1");
INSERT INTO audit_trail VALUES("4587","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-04 06:51:46","2021-09-04 06:51:46","1");
INSERT INTO audit_trail VALUES("4588","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-04 07:05:49","2021-09-04 07:05:49","1");
INSERT INTO audit_trail VALUES("4589","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-04 07:11:40","2021-09-04 07:11:40","1");
INSERT INTO audit_trail VALUES("4590","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-04 07:14:11","2021-09-04 07:14:11","1");
INSERT INTO audit_trail VALUES("4591","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-06 02:27:51","2021-09-06 02:27:51","");
INSERT INTO audit_trail VALUES("4592","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:666","2021-09-06 02:29:15","2021-09-06 02:29:15","1");
INSERT INTO audit_trail VALUES("4593","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:667","2021-09-06 03:06:22","2021-09-06 03:06:22","1");
INSERT INTO audit_trail VALUES("4594","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:668","2021-09-06 03:06:58","2021-09-06 03:06:58","1");
INSERT INTO audit_trail VALUES("4595","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-06 03:11:22","2021-09-06 03:11:22","1");
INSERT INTO audit_trail VALUES("4596","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27391","2021-09-06 03:15:49","2021-09-06 03:15:49","1");
INSERT INTO audit_trail VALUES("4597","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27397","2021-09-06 03:50:06","2021-09-06 03:50:06","1");
INSERT INTO audit_trail VALUES("4598","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27399","2021-09-06 03:51:26","2021-09-06 03:51:26","1");
INSERT INTO audit_trail VALUES("4599","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27401","2021-09-06 04:51:22","2021-09-06 04:51:22","1");
INSERT INTO audit_trail VALUES("4600","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-06 05:37:10","2021-09-06 05:37:10","");
INSERT INTO audit_trail VALUES("4601","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27406","2021-09-06 06:27:07","2021-09-06 06:27:07","1");
INSERT INTO audit_trail VALUES("4602","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27408","2021-09-06 06:41:48","2021-09-06 06:41:48","1");
INSERT INTO audit_trail VALUES("4603","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27410","2021-09-06 06:43:55","2021-09-06 06:43:55","1");
INSERT INTO audit_trail VALUES("4604","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:50","2021-09-06 08:09:14","2021-09-06 08:09:14","1");
INSERT INTO audit_trail VALUES("4605","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:50","2021-09-06 08:09:29","2021-09-06 08:09:29","1");
INSERT INTO audit_trail VALUES("4606","2","CECILIA WANJERI WANGUHU","","Updated loan with id:50","2021-09-06 08:12:38","2021-09-06 08:12:38","1");
INSERT INTO audit_trail VALUES("4607","2","CECILIA WANJERI WANGUHU","","Approved loan with id:50","2021-09-06 08:13:29","2021-09-06 08:13:29","1");
INSERT INTO audit_trail VALUES("4608","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:50","2021-09-06 08:13:46","2021-09-06 08:13:46","1");
INSERT INTO audit_trail VALUES("4609","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:136","2021-09-06 08:18:43","2021-09-06 08:18:43","1");
INSERT INTO audit_trail VALUES("4610","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:136","2021-09-06 08:19:03","2021-09-06 08:19:03","1");
INSERT INTO audit_trail VALUES("4611","2","CECILIA WANJERI WANGUHU","","Updated loan with id:136","2021-09-06 08:20:24","2021-09-06 08:20:24","1");
INSERT INTO audit_trail VALUES("4612","2","CECILIA WANJERI WANGUHU","","Approved loan with id:136","2021-09-06 08:21:46","2021-09-06 08:21:46","1");
INSERT INTO audit_trail VALUES("4613","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:136","2021-09-06 08:22:04","2021-09-06 08:22:04","1");
INSERT INTO audit_trail VALUES("4614","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27448","2021-09-06 08:47:34","2021-09-06 08:47:34","1");
INSERT INTO audit_trail VALUES("4615","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27453","2021-09-06 09:06:44","2021-09-06 09:06:44","1");
INSERT INTO audit_trail VALUES("4616","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-06 10:49:08","2021-09-06 10:49:08","1");
INSERT INTO audit_trail VALUES("4617","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-06 10:55:47","2021-09-06 10:55:47","");
INSERT INTO audit_trail VALUES("4618","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-07 01:48:05","2021-09-07 01:48:05","1");
INSERT INTO audit_trail VALUES("4619","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-07 01:49:09","2021-09-07 01:49:09","1");
INSERT INTO audit_trail VALUES("4620","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:669","2021-09-07 01:50:24","2021-09-07 01:50:24","1");
INSERT INTO audit_trail VALUES("4621","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:670","2021-09-07 02:06:38","2021-09-07 02:06:38","1");
INSERT INTO audit_trail VALUES("4622","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:671","2021-09-07 02:08:52","2021-09-07 02:08:52","1");
INSERT INTO audit_trail VALUES("4623","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27514","2021-09-07 05:38:08","2021-09-07 05:38:08","1");
INSERT INTO audit_trail VALUES("4624","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27516","2021-09-07 05:41:35","2021-09-07 05:41:35","1");
INSERT INTO audit_trail VALUES("4625","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27518","2021-09-07 05:42:54","2021-09-07 05:42:54","1");
INSERT INTO audit_trail VALUES("4626","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27520","2021-09-07 05:47:00","2021-09-07 05:47:00","1");
INSERT INTO audit_trail VALUES("4627","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27522","2021-09-07 06:15:32","2021-09-07 06:15:32","1");
INSERT INTO audit_trail VALUES("4628","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27524","2021-09-07 06:16:52","2021-09-07 06:16:52","1");
INSERT INTO audit_trail VALUES("4629","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27526","2021-09-07 06:18:43","2021-09-07 06:18:43","1");
INSERT INTO audit_trail VALUES("4630","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27528","2021-09-07 06:19:32","2021-09-07 06:19:32","1");
INSERT INTO audit_trail VALUES("4631","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27530","2021-09-07 06:23:00","2021-09-07 06:23:00","1");
INSERT INTO audit_trail VALUES("4632","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27532","2021-09-07 07:25:02","2021-09-07 07:25:02","1");
INSERT INTO audit_trail VALUES("4633","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27534","2021-09-07 07:26:27","2021-09-07 07:26:27","1");
INSERT INTO audit_trail VALUES("4634","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27536","2021-09-07 07:27:23","2021-09-07 07:27:23","1");
INSERT INTO audit_trail VALUES("4635","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27538","2021-09-07 07:28:21","2021-09-07 07:28:21","1");
INSERT INTO audit_trail VALUES("4636","2","CECILIA WANJERI WANGUHU","","Added expense with id:354","2021-09-07 10:41:16","2021-09-07 10:41:16","1");
INSERT INTO audit_trail VALUES("4637","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-07 10:50:32","2021-09-07 10:50:32","1");
INSERT INTO audit_trail VALUES("4638","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-07 11:00:11","2021-09-07 11:00:11","");
INSERT INTO audit_trail VALUES("4639","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-08 01:22:38","2021-09-08 01:22:38","1");
INSERT INTO audit_trail VALUES("4640","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-08 01:24:23","2021-09-08 01:24:23","1");
INSERT INTO audit_trail VALUES("4641","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:672","2021-09-08 01:27:07","2021-09-08 01:27:07","1");
INSERT INTO audit_trail VALUES("4642","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:673","2021-09-08 01:46:51","2021-09-08 01:46:51","1");
INSERT INTO audit_trail VALUES("4643","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:674","2021-09-08 02:49:38","2021-09-08 02:49:38","1");
INSERT INTO audit_trail VALUES("4644","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:670","2021-09-08 02:50:25","2021-09-08 02:50:25","1");
INSERT INTO audit_trail VALUES("4645","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:675","2021-09-08 02:51:13","2021-09-08 02:51:13","1");
INSERT INTO audit_trail VALUES("4646","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:675","2021-09-08 02:52:00","2021-09-08 02:52:00","1");
INSERT INTO audit_trail VALUES("4647","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:676","2021-09-08 02:52:40","2021-09-08 02:52:40","1");
INSERT INTO audit_trail VALUES("4648","2","CECILIA WANJERI WANGUHU","","Added expense with id:355","2021-09-08 02:54:42","2021-09-08 02:54:42","1");
INSERT INTO audit_trail VALUES("4649","2","CECILIA WANJERI WANGUHU","","Added expense with id:356","2021-09-08 02:56:10","2021-09-08 02:56:10","1");
INSERT INTO audit_trail VALUES("4650","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-08 02:59:23","2021-09-08 02:59:23","1");
INSERT INTO audit_trail VALUES("4651","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27606","2021-09-08 03:42:31","2021-09-08 03:42:31","1");
INSERT INTO audit_trail VALUES("4652","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27608","2021-09-08 03:44:37","2021-09-08 03:44:37","1");
INSERT INTO audit_trail VALUES("4653","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27610","2021-09-08 04:14:28","2021-09-08 04:14:28","1");
INSERT INTO audit_trail VALUES("4654","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27612","2021-09-08 04:19:22","2021-09-08 04:19:22","1");
INSERT INTO audit_trail VALUES("4655","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27614","2021-09-08 04:26:27","2021-09-08 04:26:27","1");
INSERT INTO audit_trail VALUES("4656","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27616","2021-09-08 04:30:43","2021-09-08 04:30:43","1");
INSERT INTO audit_trail VALUES("4657","2","CECILIA WANJERI WANGUHU","","Added expense with id:357","2021-09-08 06:21:04","2021-09-08 06:21:04","1");
INSERT INTO audit_trail VALUES("4658","2","CECILIA WANJERI WANGUHU","","Added expense with id:358","2021-09-08 06:22:03","2021-09-08 06:22:03","1");
INSERT INTO audit_trail VALUES("4659","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27630","2021-09-08 06:43:28","2021-09-08 06:43:28","1");
INSERT INTO audit_trail VALUES("4660","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27632","2021-09-08 06:46:55","2021-09-08 06:46:55","1");
INSERT INTO audit_trail VALUES("4661","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27634","2021-09-08 06:48:23","2021-09-08 06:48:23","1");
INSERT INTO audit_trail VALUES("4662","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27636","2021-09-08 06:49:37","2021-09-08 06:49:37","1");
INSERT INTO audit_trail VALUES("4663","2","CECILIA WANJERI WANGUHU","","Added expense with id:359","2021-09-08 09:17:33","2021-09-08 09:17:33","1");
INSERT INTO audit_trail VALUES("4664","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-08 10:33:19","2021-09-08 10:33:19","1");
INSERT INTO audit_trail VALUES("4665","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-08 10:33:46","2021-09-08 10:33:46","");
INSERT INTO audit_trail VALUES("4666","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-08 10:35:31","2021-09-08 10:35:31","1");
INSERT INTO audit_trail VALUES("4667","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-09 02:53:41","2021-09-09 02:53:41","1");
INSERT INTO audit_trail VALUES("4668","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:677","2021-09-09 02:55:39","2021-09-09 02:55:39","1");
INSERT INTO audit_trail VALUES("4669","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:670","2021-09-09 03:00:36","2021-09-09 03:00:36","1");
INSERT INTO audit_trail VALUES("4670","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-09 03:11:48","2021-09-09 03:11:48","1");
INSERT INTO audit_trail VALUES("4671","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27698","2021-09-09 04:42:19","2021-09-09 04:42:19","1");
INSERT INTO audit_trail VALUES("4672","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:507","2021-09-09 05:41:24","2021-09-09 05:41:24","1");
INSERT INTO audit_trail VALUES("4673","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27702","2021-09-09 05:52:30","2021-09-09 05:52:30","1");
INSERT INTO audit_trail VALUES("4674","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27704","2021-09-09 06:24:56","2021-09-09 06:24:56","1");
INSERT INTO audit_trail VALUES("4675","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27706","2021-09-09 06:28:32","2021-09-09 06:28:32","1");
INSERT INTO audit_trail VALUES("4676","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27711","2021-09-09 06:58:37","2021-09-09 06:58:37","1");
INSERT INTO audit_trail VALUES("4677","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:678","2021-09-09 08:12:16","2021-09-09 08:12:16","1");
INSERT INTO audit_trail VALUES("4678","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:679","2021-09-09 08:19:48","2021-09-09 08:19:48","1");
INSERT INTO audit_trail VALUES("4679","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:680","2021-09-09 08:20:43","2021-09-09 08:20:43","1");
INSERT INTO audit_trail VALUES("4680","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27719","2021-09-09 08:28:25","2021-09-09 08:28:25","1");
INSERT INTO audit_trail VALUES("4681","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27721","2021-09-09 08:30:10","2021-09-09 08:30:10","1");
INSERT INTO audit_trail VALUES("4682","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27723","2021-09-09 08:31:21","2021-09-09 08:31:21","1");
INSERT INTO audit_trail VALUES("4683","2","CECILIA WANJERI WANGUHU","","Added expense with id:360","2021-09-09 09:44:49","2021-09-09 09:44:49","1");
INSERT INTO audit_trail VALUES("4684","2","CECILIA WANJERI WANGUHU","","Added expense with id:361","2021-09-09 09:45:50","2021-09-09 09:45:50","1");
INSERT INTO audit_trail VALUES("4685","2","CECILIA WANJERI WANGUHU","","Added expense with id:362","2021-09-09 09:46:46","2021-09-09 09:46:46","1");
INSERT INTO audit_trail VALUES("4686","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-09 10:15:07","2021-09-09 10:15:07","1");
INSERT INTO audit_trail VALUES("4687","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-09 10:17:10","2021-09-09 10:17:10","");
INSERT INTO audit_trail VALUES("4688","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-10 02:11:07","2021-09-10 02:11:07","1");
INSERT INTO audit_trail VALUES("4689","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:681","2021-09-10 02:12:38","2021-09-10 02:12:38","1");
INSERT INTO audit_trail VALUES("4690","2","CECILIA WANJERI WANGUHU","","Added expense with id:363","2021-09-10 02:14:26","2021-09-10 02:14:26","1");
INSERT INTO audit_trail VALUES("4691","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-10 02:32:47","2021-09-10 02:32:47","1");
INSERT INTO audit_trail VALUES("4692","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:418","2021-09-10 06:12:24","2021-09-10 06:12:24","1");
INSERT INTO audit_trail VALUES("4693","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:682","2021-09-10 08:11:16","2021-09-10 08:11:16","1");
INSERT INTO audit_trail VALUES("4694","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:683","2021-09-10 08:11:53","2021-09-10 08:11:53","1");
INSERT INTO audit_trail VALUES("4695","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-10 10:06:54","2021-09-10 10:06:54","1");
INSERT INTO audit_trail VALUES("4696","2","CECILIA WANJERI WANGUHU","","Added expense with id:364","2021-09-10 10:27:56","2021-09-10 10:27:56","1");
INSERT INTO audit_trail VALUES("4697","2","CECILIA WANJERI WANGUHU","","Updated expense with id:363","2021-09-10 10:29:20","2021-09-10 10:29:20","1");
INSERT INTO audit_trail VALUES("4698","2","CECILIA WANJERI WANGUHU","","Updated expense with id:363","2021-09-10 10:32:17","2021-09-10 10:32:17","1");
INSERT INTO audit_trail VALUES("4699","2","CECILIA WANJERI WANGUHU","","Updated expense with id:363","2021-09-10 10:33:03","2021-09-10 10:33:03","1");
INSERT INTO audit_trail VALUES("4700","2","CECILIA WANJERI WANGUHU","","Updated expense with id:363","2021-09-10 10:40:27","2021-09-10 10:40:27","1");
INSERT INTO audit_trail VALUES("4701","1","Admin Admin","","Logged in to system","2021-09-10 10:42:10","2021-09-10 10:42:10","");
INSERT INTO audit_trail VALUES("4702","1","Admin Admin","","Updated expense with id:363","2021-09-10 10:44:02","2021-09-10 10:44:02","1");
INSERT INTO audit_trail VALUES("4703","1","Admin Admin","","Updated expense with id:363","2021-09-10 10:45:49","2021-09-10 10:45:49","1");
INSERT INTO audit_trail VALUES("4704","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-10 11:00:45","2021-09-10 11:00:45","1");
INSERT INTO audit_trail VALUES("4705","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-10 11:17:51","2021-09-10 11:17:51","");
INSERT INTO audit_trail VALUES("4706","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-10 11:22:01","2021-09-10 11:22:01","1");
INSERT INTO audit_trail VALUES("4707","1","Admin Admin","","Logged in to system","2021-09-13 02:51:00","2021-09-13 02:51:00","");
INSERT INTO audit_trail VALUES("4708","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-13 02:51:09","2021-09-13 02:51:09","");
INSERT INTO audit_trail VALUES("4709","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:684","2021-09-13 02:52:06","2021-09-13 02:52:06","1");
INSERT INTO audit_trail VALUES("4710","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:685","2021-09-13 02:52:53","2021-09-13 02:52:53","1");
INSERT INTO audit_trail VALUES("4711","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:685","2021-09-13 02:53:34","2021-09-13 02:53:34","1");
INSERT INTO audit_trail VALUES("4712","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-13 04:06:01","2021-09-13 04:06:01","");
INSERT INTO audit_trail VALUES("4713","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27879","2021-09-13 05:41:30","2021-09-13 05:41:30","1");
INSERT INTO audit_trail VALUES("4714","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27881","2021-09-13 05:42:49","2021-09-13 05:42:49","1");
INSERT INTO audit_trail VALUES("4715","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27883","2021-09-13 06:00:29","2021-09-13 06:00:29","1");
INSERT INTO audit_trail VALUES("4716","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27885","2021-09-13 06:00:50","2021-09-13 06:00:50","1");
INSERT INTO audit_trail VALUES("4717","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27887","2021-09-13 06:01:09","2021-09-13 06:01:09","1");
INSERT INTO audit_trail VALUES("4718","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27889","2021-09-13 06:02:00","2021-09-13 06:02:00","1");
INSERT INTO audit_trail VALUES("4719","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27891","2021-09-13 07:39:58","2021-09-13 07:39:58","1");
INSERT INTO audit_trail VALUES("4720","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27893","2021-09-13 07:51:44","2021-09-13 07:51:44","1");
INSERT INTO audit_trail VALUES("4721","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27906","2021-09-13 08:38:41","2021-09-13 08:38:41","1");
INSERT INTO audit_trail VALUES("4722","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27908","2021-09-13 08:38:56","2021-09-13 08:38:56","1");
INSERT INTO audit_trail VALUES("4723","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:27910","2021-09-13 08:39:22","2021-09-13 08:39:22","1");
INSERT INTO audit_trail VALUES("4724","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:603","2021-09-13 08:45:33","2021-09-13 08:45:33","1");
INSERT INTO audit_trail VALUES("4725","2","CECILIA WANJERI WANGUHU","","Added expense with id:365","2021-09-13 09:10:47","2021-09-13 09:10:47","1");
INSERT INTO audit_trail VALUES("4726","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-13 10:50:40","2021-09-13 10:50:40","1");
INSERT INTO audit_trail VALUES("4727","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-13 10:52:25","2021-09-13 10:52:25","");
INSERT INTO audit_trail VALUES("4728","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-14 01:12:54","2021-09-14 01:12:54","1");
INSERT INTO audit_trail VALUES("4729","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-14 01:40:06","2021-09-14 01:40:06","1");
INSERT INTO audit_trail VALUES("4730","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:686","2021-09-14 01:41:40","2021-09-14 01:41:40","1");
INSERT INTO audit_trail VALUES("4731","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:687","2021-09-14 03:28:34","2021-09-14 03:28:34","1");
INSERT INTO audit_trail VALUES("4732","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:688","2021-09-14 03:30:09","2021-09-14 03:30:09","1");
INSERT INTO audit_trail VALUES("4733","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28013","2021-09-14 07:31:45","2021-09-14 07:31:45","1");
INSERT INTO audit_trail VALUES("4734","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28015","2021-09-14 07:33:31","2021-09-14 07:33:31","1");
INSERT INTO audit_trail VALUES("4735","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28017","2021-09-14 07:34:39","2021-09-14 07:34:39","1");
INSERT INTO audit_trail VALUES("4736","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28019","2021-09-14 07:35:44","2021-09-14 07:35:44","1");
INSERT INTO audit_trail VALUES("4737","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28021","2021-09-14 07:37:21","2021-09-14 07:37:21","1");
INSERT INTO audit_trail VALUES("4738","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28023","2021-09-14 07:38:29","2021-09-14 07:38:29","1");
INSERT INTO audit_trail VALUES("4739","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28026","2021-09-14 07:42:05","2021-09-14 07:42:05","1");
INSERT INTO audit_trail VALUES("4740","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28035","2021-09-14 07:51:09","2021-09-14 07:51:09","1");
INSERT INTO audit_trail VALUES("4741","2","CECILIA WANJERI WANGUHU","","Added expense with id:366","2021-09-14 10:34:56","2021-09-14 10:34:56","1");
INSERT INTO audit_trail VALUES("4742","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-14 10:44:09","2021-09-14 10:44:09","1");
INSERT INTO audit_trail VALUES("4743","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-14 11:04:35","2021-09-14 11:04:35","");
INSERT INTO audit_trail VALUES("4744","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-15 03:01:00","2021-09-15 03:01:00","1");
INSERT INTO audit_trail VALUES("4745","1","Admin Admin","","Logged in to system","2021-09-15 03:33:20","2021-09-15 03:33:20","");
INSERT INTO audit_trail VALUES("4746","1","Admin Admin","","Logged in to system","2021-09-15 03:53:11","2021-09-15 03:53:11","");
INSERT INTO audit_trail VALUES("4747","1","Admin Admin","","Logged out of system","2021-09-15 03:57:17","2021-09-15 03:57:17","1");
INSERT INTO audit_trail VALUES("4748","1","Admin Admin","","Logged in to system","2021-09-15 03:57:25","2021-09-15 03:57:25","1");
INSERT INTO audit_trail VALUES("4749","1","Admin Admin","","Logged in to system","2021-09-15 03:59:15","2021-09-15 03:59:15","");
INSERT INTO audit_trail VALUES("4750","1","Admin Admin","","Logged in to system","2021-09-15 04:00:46","2021-09-15 04:00:46","");
INSERT INTO audit_trail VALUES("4751","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-15 04:03:14","2021-09-15 04:03:14","");
INSERT INTO audit_trail VALUES("4752","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:689","2021-09-15 04:04:42","2021-09-15 04:04:42","1");
INSERT INTO audit_trail VALUES("4753","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-15 04:09:35","2021-09-15 04:09:35","");
INSERT INTO audit_trail VALUES("4754","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:690","2021-09-15 04:47:39","2021-09-15 04:47:39","1");
INSERT INTO audit_trail VALUES("4755","2","CECILIA WANJERI WANGUHU","","Added expense with id:367","2021-09-15 04:51:15","2021-09-15 04:51:15","1");
INSERT INTO audit_trail VALUES("4756","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:76","2021-09-15 06:21:12","2021-09-15 06:21:12","1");
INSERT INTO audit_trail VALUES("4757","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:76","2021-09-15 06:21:31","2021-09-15 06:21:31","1");
INSERT INTO audit_trail VALUES("4758","2","CECILIA WANJERI WANGUHU","","Updated loan with id:76","2021-09-15 06:24:16","2021-09-15 06:24:16","1");
INSERT INTO audit_trail VALUES("4759","2","CECILIA WANJERI WANGUHU","","Approved loan with id:76","2021-09-15 06:25:33","2021-09-15 06:25:33","1");
INSERT INTO audit_trail VALUES("4760","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:76","2021-09-15 06:26:20","2021-09-15 06:26:20","1");
INSERT INTO audit_trail VALUES("4761","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:76","2021-09-15 06:27:25","2021-09-15 06:27:25","1");
INSERT INTO audit_trail VALUES("4762","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:194","2021-09-15 07:08:14","2021-09-15 07:08:14","1");
INSERT INTO audit_trail VALUES("4763","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:194","2021-09-15 07:08:31","2021-09-15 07:08:31","1");
INSERT INTO audit_trail VALUES("4764","2","CECILIA WANJERI WANGUHU","","Updated loan with id:194","2021-09-15 07:10:29","2021-09-15 07:10:29","1");
INSERT INTO audit_trail VALUES("4765","2","CECILIA WANJERI WANGUHU","","Approved loan with id:194","2021-09-15 07:18:18","2021-09-15 07:18:18","1");
INSERT INTO audit_trail VALUES("4766","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:194","2021-09-15 07:23:38","2021-09-15 07:23:38","1");
INSERT INTO audit_trail VALUES("4767","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:194","2021-09-15 07:31:38","2021-09-15 07:31:38","1");
INSERT INTO audit_trail VALUES("4768","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:194","2021-09-15 07:52:35","2021-09-15 07:52:35","1");
INSERT INTO audit_trail VALUES("4769","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:194","2021-09-15 07:52:48","2021-09-15 07:52:48","1");
INSERT INTO audit_trail VALUES("4770","2","CECILIA WANJERI WANGUHU","","Updated loan with id:194","2021-09-15 07:53:39","2021-09-15 07:53:39","1");
INSERT INTO audit_trail VALUES("4771","2","CECILIA WANJERI WANGUHU","","Approved loan with id:194","2021-09-15 07:56:27","2021-09-15 07:56:27","1");
INSERT INTO audit_trail VALUES("4772","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:194","2021-09-15 07:56:54","2021-09-15 07:56:54","1");
INSERT INTO audit_trail VALUES("4773","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:194","2021-09-15 07:57:44","2021-09-15 07:57:44","1");
INSERT INTO audit_trail VALUES("4774","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-15 08:46:22","2021-09-15 08:46:22","1");
INSERT INTO audit_trail VALUES("4775","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:691","2021-09-15 08:50:25","2021-09-15 08:50:25","1");
INSERT INTO audit_trail VALUES("4776","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-15 10:35:15","2021-09-15 10:35:15","1");
INSERT INTO audit_trail VALUES("4777","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-15 10:38:58","2021-09-15 10:38:58","");
INSERT INTO audit_trail VALUES("4778","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-16 01:56:07","2021-09-16 01:56:07","1");
INSERT INTO audit_trail VALUES("4779","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:692","2021-09-16 01:57:07","2021-09-16 01:57:07","1");
INSERT INTO audit_trail VALUES("4780","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:693","2021-09-16 01:58:47","2021-09-16 01:58:47","1");
INSERT INTO audit_trail VALUES("4781","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:694","2021-09-16 02:01:15","2021-09-16 02:01:15","1");
INSERT INTO audit_trail VALUES("4782","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28191","2021-09-16 02:12:05","2021-09-16 02:12:05","1");
INSERT INTO audit_trail VALUES("4783","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-16 03:51:16","2021-09-16 03:51:16","1");
INSERT INTO audit_trail VALUES("4784","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:94","2021-09-16 05:56:27","2021-09-16 05:56:27","1");
INSERT INTO audit_trail VALUES("4785","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:94","2021-09-16 05:56:38","2021-09-16 05:56:38","1");
INSERT INTO audit_trail VALUES("4786","2","CECILIA WANJERI WANGUHU","","Updated loan with id:94","2021-09-16 05:59:49","2021-09-16 05:59:49","1");
INSERT INTO audit_trail VALUES("4787","2","CECILIA WANJERI WANGUHU","","Approved loan with id:94","2021-09-16 06:00:30","2021-09-16 06:00:30","1");
INSERT INTO audit_trail VALUES("4788","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:94","2021-09-16 06:00:53","2021-09-16 06:00:53","1");
INSERT INTO audit_trail VALUES("4789","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:135","2021-09-16 06:55:50","2021-09-16 06:55:50","1");
INSERT INTO audit_trail VALUES("4790","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:135","2021-09-16 06:56:01","2021-09-16 06:56:01","1");
INSERT INTO audit_trail VALUES("4791","2","CECILIA WANJERI WANGUHU","","Updated loan with id:135","2021-09-16 06:58:29","2021-09-16 06:58:29","1");
INSERT INTO audit_trail VALUES("4792","2","CECILIA WANJERI WANGUHU","","Approved loan with id:135","2021-09-16 06:59:04","2021-09-16 06:59:04","1");
INSERT INTO audit_trail VALUES("4793","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:135","2021-09-16 06:59:16","2021-09-16 06:59:16","1");
INSERT INTO audit_trail VALUES("4794","1","Admin Admin","","Logged in to system","2021-09-16 07:08:02","2021-09-16 07:08:02","");
INSERT INTO audit_trail VALUES("4795","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-16 08:32:16","2021-09-16 08:32:16","1");
INSERT INTO audit_trail VALUES("4796","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-16 10:29:23","2021-09-16 10:29:23","1");
INSERT INTO audit_trail VALUES("4797","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-16 10:30:00","2021-09-16 10:30:00","1");
INSERT INTO audit_trail VALUES("4798","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-16 10:34:52","2021-09-16 10:34:52","1");
INSERT INTO audit_trail VALUES("4799","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-16 10:45:26","2021-09-16 10:45:26","");
INSERT INTO audit_trail VALUES("4800","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-16 10:46:31","2021-09-16 10:46:31","1");
INSERT INTO audit_trail VALUES("4801","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-17 02:09:44","2021-09-17 02:09:44","1");
INSERT INTO audit_trail VALUES("4802","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-17 02:15:23","2021-09-17 02:15:23","1");
INSERT INTO audit_trail VALUES("4803","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:695","2021-09-17 02:18:00","2021-09-17 02:18:00","1");
INSERT INTO audit_trail VALUES("4804","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-17 03:21:14","2021-09-17 03:21:14","1");
INSERT INTO audit_trail VALUES("4805","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:696","2021-09-17 05:08:23","2021-09-17 05:08:23","1");
INSERT INTO audit_trail VALUES("4806","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:697","2021-09-17 05:09:15","2021-09-17 05:09:15","1");
INSERT INTO audit_trail VALUES("4807","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28296","2021-09-17 05:13:35","2021-09-17 05:13:35","1");
INSERT INTO audit_trail VALUES("4808","2","CECILIA WANJERI WANGUHU","","Added expense with id:368","2021-09-17 05:23:29","2021-09-17 05:23:29","1");
INSERT INTO audit_trail VALUES("4809","1","Admin Admin","","Logged in to system","2021-09-17 06:34:06","2021-09-17 06:34:06","");
INSERT INTO audit_trail VALUES("4810","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:698","2021-09-17 07:35:39","2021-09-17 07:35:39","1");
INSERT INTO audit_trail VALUES("4811","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-17 10:12:23","2021-09-17 10:12:23","1");
INSERT INTO audit_trail VALUES("4812","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:699","2021-09-17 10:17:37","2021-09-17 10:17:37","1");
INSERT INTO audit_trail VALUES("4813","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:699","2021-09-17 10:21:47","2021-09-17 10:21:47","1");
INSERT INTO audit_trail VALUES("4814","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:699","2021-09-17 10:23:19","2021-09-17 10:23:19","1");
INSERT INTO audit_trail VALUES("4815","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-17 10:31:52","2021-09-17 10:31:52","1");
INSERT INTO audit_trail VALUES("4816","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-17 10:34:22","2021-09-17 10:34:22","");
INSERT INTO audit_trail VALUES("4817","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-18 02:12:05","2021-09-18 02:12:05","1");
INSERT INTO audit_trail VALUES("4818","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-18 02:56:44","2021-09-18 02:56:44","1");
INSERT INTO audit_trail VALUES("4819","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:700","2021-09-18 02:58:37","2021-09-18 02:58:37","1");
INSERT INTO audit_trail VALUES("4820","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:701","2021-09-18 03:29:22","2021-09-18 03:29:22","1");
INSERT INTO audit_trail VALUES("4821","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:702","2021-09-18 04:22:04","2021-09-18 04:22:04","1");
INSERT INTO audit_trail VALUES("4822","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:703","2021-09-18 04:23:10","2021-09-18 04:23:10","1");
INSERT INTO audit_trail VALUES("4823","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-18 04:32:22","2021-09-18 04:32:22","1");
INSERT INTO audit_trail VALUES("4824","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-18 05:54:14","2021-09-18 05:54:14","1");
INSERT INTO audit_trail VALUES("4825","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-18 06:16:09","2021-09-18 06:16:09","1");
INSERT INTO audit_trail VALUES("4826","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-18 06:19:12","2021-09-18 06:19:12","1");
INSERT INTO audit_trail VALUES("4827","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-18 06:20:59","2021-09-18 06:20:59","1");
INSERT INTO audit_trail VALUES("4828","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-20 01:42:20","2021-09-20 01:42:20","");
INSERT INTO audit_trail VALUES("4829","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:704","2021-09-20 01:43:44","2021-09-20 01:43:44","1");
INSERT INTO audit_trail VALUES("4830","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:705","2021-09-20 02:01:46","2021-09-20 02:01:46","1");
INSERT INTO audit_trail VALUES("4831","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-20 02:06:41","2021-09-20 02:06:41","");
INSERT INTO audit_trail VALUES("4832","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:706","2021-09-20 03:25:22","2021-09-20 03:25:22","1");
INSERT INTO audit_trail VALUES("4833","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-20 05:36:24","2021-09-20 05:36:24","1");
INSERT INTO audit_trail VALUES("4834","2","CECILIA WANJERI WANGUHU","","Added expense with id:369","2021-09-20 10:29:52","2021-09-20 10:29:52","1");
INSERT INTO audit_trail VALUES("4835","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-20 10:30:10","2021-09-20 10:30:10","1");
INSERT INTO audit_trail VALUES("4836","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-20 10:41:47","2021-09-20 10:41:47","1");
INSERT INTO audit_trail VALUES("4837","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-20 10:50:02","2021-09-20 10:50:02","1");
INSERT INTO audit_trail VALUES("4838","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-20 10:58:05","2021-09-20 10:58:05","");
INSERT INTO audit_trail VALUES("4839","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-20 10:59:11","2021-09-20 10:59:11","1");
INSERT INTO audit_trail VALUES("4840","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-21 04:28:49","2021-09-21 04:28:49","1");
INSERT INTO audit_trail VALUES("4841","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:707","2021-09-21 04:53:40","2021-09-21 04:53:40","1");
INSERT INTO audit_trail VALUES("4842","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-21 05:53:01","2021-09-21 05:53:01","1");
INSERT INTO audit_trail VALUES("4843","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:708","2021-09-21 05:56:16","2021-09-21 05:56:16","1");
INSERT INTO audit_trail VALUES("4844","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:709","2021-09-21 05:57:23","2021-09-21 05:57:23","1");
INSERT INTO audit_trail VALUES("4845","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:710","2021-09-21 05:59:04","2021-09-21 05:59:04","1");
INSERT INTO audit_trail VALUES("4846","2","CECILIA WANJERI WANGUHU","","Added expense with id:370","2021-09-21 06:00:51","2021-09-21 06:00:51","1");
INSERT INTO audit_trail VALUES("4847","2","CECILIA WANJERI WANGUHU","","Updated expense with id:369","2021-09-21 06:02:05","2021-09-21 06:02:05","1");
INSERT INTO audit_trail VALUES("4848","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-21 06:18:37","2021-09-21 06:18:37","1");
INSERT INTO audit_trail VALUES("4849","2","CECILIA WANJERI WANGUHU","","Added loan with id:226","2021-09-21 06:23:43","2021-09-21 06:23:43","1");
INSERT INTO audit_trail VALUES("4850","2","CECILIA WANJERI WANGUHU","","Approved loan with id:226","2021-09-21 06:24:19","2021-09-21 06:24:19","1");
INSERT INTO audit_trail VALUES("4851","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:226","2021-09-21 06:24:43","2021-09-21 06:24:43","1");
INSERT INTO audit_trail VALUES("4852","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28599","2021-09-21 06:33:44","2021-09-21 06:33:44","1");
INSERT INTO audit_trail VALUES("4853","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28601","2021-09-21 06:39:43","2021-09-21 06:39:43","1");
INSERT INTO audit_trail VALUES("4854","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28605","2021-09-21 07:16:47","2021-09-21 07:16:47","1");
INSERT INTO audit_trail VALUES("4855","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28630","2021-09-21 08:34:37","2021-09-21 08:34:37","1");
INSERT INTO audit_trail VALUES("4856","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28633","2021-09-21 08:40:42","2021-09-21 08:40:42","1");
INSERT INTO audit_trail VALUES("4857","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28636","2021-09-21 08:46:46","2021-09-21 08:46:46","1");
INSERT INTO audit_trail VALUES("4858","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28639","2021-09-21 08:50:12","2021-09-21 08:50:12","1");
INSERT INTO audit_trail VALUES("4859","2","CECILIA WANJERI WANGUHU","","Added expense with id:371","2021-09-21 10:33:49","2021-09-21 10:33:49","1");
INSERT INTO audit_trail VALUES("4860","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-21 10:53:13","2021-09-21 10:53:13","1");
INSERT INTO audit_trail VALUES("4861","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-21 10:58:17","2021-09-21 10:58:17","");
INSERT INTO audit_trail VALUES("4862","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-22 03:05:57","2021-09-22 03:05:57","1");
INSERT INTO audit_trail VALUES("4863","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-22 03:12:23","2021-09-22 03:12:23","1");
INSERT INTO audit_trail VALUES("4864","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-22 04:53:09","2021-09-22 04:53:09","");
INSERT INTO audit_trail VALUES("4865","1","Admin Admin","","Logged in to system","2021-09-22 04:56:25","2021-09-22 04:56:25","");
INSERT INTO audit_trail VALUES("4866","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:711","2021-09-22 04:59:38","2021-09-22 04:59:38","1");
INSERT INTO audit_trail VALUES("4867","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:712","2021-09-22 05:00:37","2021-09-22 05:00:37","1");
INSERT INTO audit_trail VALUES("4868","2","CECILIA WANJERI WANGUHU","","Added expense with id:372","2021-09-22 07:20:12","2021-09-22 07:20:12","1");
INSERT INTO audit_trail VALUES("4869","2","CECILIA WANJERI WANGUHU","","Added expense with id:373","2021-09-22 07:20:50","2021-09-22 07:20:50","1");
INSERT INTO audit_trail VALUES("4870","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28715","2021-09-22 07:59:22","2021-09-22 07:59:22","1");
INSERT INTO audit_trail VALUES("4871","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-22 10:53:14","2021-09-22 10:53:14","");
INSERT INTO audit_trail VALUES("4872","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-22 10:59:56","2021-09-22 10:59:56","1");
INSERT INTO audit_trail VALUES("4873","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-22 11:06:42","2021-09-22 11:06:42","");
INSERT INTO audit_trail VALUES("4874","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-23 02:02:03","2021-09-23 02:02:03","1");
INSERT INTO audit_trail VALUES("4875","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:713","2021-09-23 02:10:51","2021-09-23 02:10:51","1");
INSERT INTO audit_trail VALUES("4876","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-23 04:54:20","2021-09-23 04:54:20","1");
INSERT INTO audit_trail VALUES("4877","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:714","2021-09-23 05:52:08","2021-09-23 05:52:08","1");
INSERT INTO audit_trail VALUES("4878","2","CECILIA WANJERI WANGUHU","","Added expense with id:374","2021-09-23 07:22:07","2021-09-23 07:22:07","1");
INSERT INTO audit_trail VALUES("4879","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:715","2021-09-23 07:22:59","2021-09-23 07:22:59","1");
INSERT INTO audit_trail VALUES("4880","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-23 10:34:34","2021-09-23 10:34:34","1");
INSERT INTO audit_trail VALUES("4881","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-24 01:41:58","2021-09-24 01:41:58","1");
INSERT INTO audit_trail VALUES("4882","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:716","2021-09-24 01:43:25","2021-09-24 01:43:25","1");
INSERT INTO audit_trail VALUES("4883","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-24 01:50:04","2021-09-24 01:50:04","1");
INSERT INTO audit_trail VALUES("4884","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:717","2021-09-24 03:01:58","2021-09-24 03:01:58","1");
INSERT INTO audit_trail VALUES("4885","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28823","2021-09-24 04:41:05","2021-09-24 04:41:05","1");
INSERT INTO audit_trail VALUES("4886","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28825","2021-09-24 04:54:27","2021-09-24 04:54:27","1");
INSERT INTO audit_trail VALUES("4887","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28827","2021-09-24 04:55:51","2021-09-24 04:55:51","1");
INSERT INTO audit_trail VALUES("4888","2","CECILIA WANJERI WANGUHU","","Added expense with id:375","2021-09-24 05:23:11","2021-09-24 05:23:11","1");
INSERT INTO audit_trail VALUES("4889","2","CECILIA WANJERI WANGUHU","","Added expense with id:376","2021-09-24 05:47:08","2021-09-24 05:47:08","1");
INSERT INTO audit_trail VALUES("4890","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-24 09:52:05","2021-09-24 09:52:05","1");
INSERT INTO audit_trail VALUES("4891","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-24 10:02:32","2021-09-24 10:02:32","1");
INSERT INTO audit_trail VALUES("4892","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-24 10:02:51","2021-09-24 10:02:51","1");
INSERT INTO audit_trail VALUES("4893","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-24 10:03:00","2021-09-24 10:03:00","1");
INSERT INTO audit_trail VALUES("4894","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-24 10:05:29","2021-09-24 10:05:29","");
INSERT INTO audit_trail VALUES("4895","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-24 10:23:52","2021-09-24 10:23:52","1");
INSERT INTO audit_trail VALUES("4896","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-25 02:12:26","2021-09-25 02:12:26","1");
INSERT INTO audit_trail VALUES("4897","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:718","2021-09-25 02:14:00","2021-09-25 02:14:00","1");
INSERT INTO audit_trail VALUES("4898","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-25 02:14:21","2021-09-25 02:14:21","1");
INSERT INTO audit_trail VALUES("4899","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:719","2021-09-25 04:37:36","2021-09-25 04:37:36","1");
INSERT INTO audit_trail VALUES("4900","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28888","2021-09-25 05:04:18","2021-09-25 05:04:18","1");
INSERT INTO audit_trail VALUES("4901","1","Admin Admin","","Logged in to system","2021-09-25 05:48:00","2021-09-25 05:48:00","");
INSERT INTO audit_trail VALUES("4902","2","CECILIA WANJERI WANGUHU","","Added expense with id:377","2021-09-25 06:05:35","2021-09-25 06:05:35","1");
INSERT INTO audit_trail VALUES("4903","1","Admin Admin","","Added repayment for loan with id:186","2021-09-25 07:45:58","2021-09-25 07:45:58","1");
INSERT INTO audit_trail VALUES("4904","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-25 09:42:43","2021-09-25 09:42:43","1");
INSERT INTO audit_trail VALUES("4905","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-27 01:42:47","2021-09-27 01:42:47","");
INSERT INTO audit_trail VALUES("4906","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:720","2021-09-27 01:46:24","2021-09-27 01:46:24","1");
INSERT INTO audit_trail VALUES("4907","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-27 03:27:04","2021-09-27 03:27:04","");
INSERT INTO audit_trail VALUES("4908","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:721","2021-09-27 03:56:29","2021-09-27 03:56:29","1");
INSERT INTO audit_trail VALUES("4909","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:722","2021-09-27 03:57:09","2021-09-27 03:57:09","1");
INSERT INTO audit_trail VALUES("4910","2","CECILIA WANJERI WANGUHU","","Added expense with id:378","2021-09-27 03:58:58","2021-09-27 03:58:58","1");
INSERT INTO audit_trail VALUES("4911","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:723","2021-09-27 04:04:15","2021-09-27 04:04:15","1");
INSERT INTO audit_trail VALUES("4912","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:724","2021-09-27 04:09:36","2021-09-27 04:09:36","1");
INSERT INTO audit_trail VALUES("4913","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:637","2021-09-27 05:05:59","2021-09-27 05:05:59","1");
INSERT INTO audit_trail VALUES("4914","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:638","2021-09-27 05:12:41","2021-09-27 05:12:41","1");
INSERT INTO audit_trail VALUES("4915","2","CECILIA WANJERI WANGUHU","","Declined borrower  with id:637","2021-09-27 05:13:34","2021-09-27 05:13:34","1");
INSERT INTO audit_trail VALUES("4916","1","Admin Admin","","Logged in to system","2021-09-27 05:15:42","2021-09-27 05:15:42","");
INSERT INTO audit_trail VALUES("4917","1","Admin Admin","","Deleted borrower  with id:637","2021-09-27 05:18:48","2021-09-27 05:18:48","1");
INSERT INTO audit_trail VALUES("4918","1","Admin Admin","","Updated borrower  with id:173","2021-09-27 05:20:29","2021-09-27 05:20:29","1");
INSERT INTO audit_trail VALUES("4919","1","Admin Admin","","Updated borrower  with id:173","2021-09-27 05:22:41","2021-09-27 05:22:41","1");
INSERT INTO audit_trail VALUES("4920","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:28965","2021-09-27 07:08:57","2021-09-27 07:08:57","1");
INSERT INTO audit_trail VALUES("4921","2","CECILIA WANJERI WANGUHU","","Added expense with id:379","2021-09-27 08:25:17","2021-09-27 08:25:17","1");
INSERT INTO audit_trail VALUES("4922","2","CECILIA WANJERI WANGUHU","","Updated expense with id:379","2021-09-27 08:25:39","2021-09-27 08:25:39","1");
INSERT INTO audit_trail VALUES("4923","2","CECILIA WANJERI WANGUHU","","Added expense with id:380","2021-09-27 08:29:20","2021-09-27 08:29:20","1");
INSERT INTO audit_trail VALUES("4924","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-27 10:21:45","2021-09-27 10:21:45","");
INSERT INTO audit_trail VALUES("4925","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-28 01:30:50","2021-09-28 01:30:50","1");
INSERT INTO audit_trail VALUES("4926","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:725","2021-09-28 01:32:54","2021-09-28 01:32:54","1");
INSERT INTO audit_trail VALUES("4927","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:726","2021-09-28 01:54:24","2021-09-28 01:54:24","1");
INSERT INTO audit_trail VALUES("4928","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:727","2021-09-28 01:57:22","2021-09-28 01:57:22","1");
INSERT INTO audit_trail VALUES("4929","2","CECILIA WANJERI WANGUHU","","Added loan with id:227","2021-09-28 02:06:41","2021-09-28 02:06:41","1");
INSERT INTO audit_trail VALUES("4930","2","CECILIA WANJERI WANGUHU","","Approved loan with id:227","2021-09-28 02:07:41","2021-09-28 02:07:41","1");
INSERT INTO audit_trail VALUES("4931","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:227","2021-09-28 02:09:21","2021-09-28 02:09:21","1");
INSERT INTO audit_trail VALUES("4932","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29040","2021-09-28 02:41:22","2021-09-28 02:41:22","1");
INSERT INTO audit_trail VALUES("4933","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29042","2021-09-28 02:44:31","2021-09-28 02:44:31","1");
INSERT INTO audit_trail VALUES("4934","2","CECILIA WANJERI WANGUHU","","Added loan with id:228","2021-09-28 03:07:14","2021-09-28 03:07:14","1");
INSERT INTO audit_trail VALUES("4935","2","CECILIA WANJERI WANGUHU","","Approved loan with id:228","2021-09-28 03:07:43","2021-09-28 03:07:43","1");
INSERT INTO audit_trail VALUES("4936","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:228","2021-09-28 03:08:02","2021-09-28 03:08:02","1");
INSERT INTO audit_trail VALUES("4937","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29051","2021-09-28 03:16:34","2021-09-28 03:16:34","1");
INSERT INTO audit_trail VALUES("4938","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29053","2021-09-28 03:20:12","2021-09-28 03:20:12","1");
INSERT INTO audit_trail VALUES("4939","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29057","2021-09-28 03:25:12","2021-09-28 03:25:12","1");
INSERT INTO audit_trail VALUES("4940","2","CECILIA WANJERI WANGUHU","","Added expense with id:381","2021-09-28 06:16:07","2021-09-28 06:16:07","1");
INSERT INTO audit_trail VALUES("4941","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29102","2021-09-28 07:26:23","2021-09-28 07:26:23","1");
INSERT INTO audit_trail VALUES("4942","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-28 10:29:05","2021-09-28 10:29:05","1");
INSERT INTO audit_trail VALUES("4943","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-29 01:42:14","2021-09-29 01:42:14","1");
INSERT INTO audit_trail VALUES("4944","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-29 01:42:17","2021-09-29 01:42:17","1");
INSERT INTO audit_trail VALUES("4945","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-29 01:44:39","2021-09-29 01:44:39","1");
INSERT INTO audit_trail VALUES("4946","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:728","2021-09-29 01:46:27","2021-09-29 01:46:27","1");
INSERT INTO audit_trail VALUES("4947","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:729","2021-09-29 02:16:29","2021-09-29 02:16:29","1");
INSERT INTO audit_trail VALUES("4948","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:730","2021-09-29 02:17:24","2021-09-29 02:17:24","1");
INSERT INTO audit_trail VALUES("4949","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:728","2021-09-29 02:36:28","2021-09-29 02:36:28","1");
INSERT INTO audit_trail VALUES("4950","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29213","2021-09-29 03:29:04","2021-09-29 03:29:04","1");
INSERT INTO audit_trail VALUES("4951","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29215","2021-09-29 03:32:24","2021-09-29 03:32:24","1");
INSERT INTO audit_trail VALUES("4952","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29217","2021-09-29 03:35:03","2021-09-29 03:35:03","1");
INSERT INTO audit_trail VALUES("4953","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29219","2021-09-29 03:40:30","2021-09-29 03:40:30","1");
INSERT INTO audit_trail VALUES("4954","2","CECILIA WANJERI WANGUHU","","Added expense with id:382","2021-09-29 10:07:32","2021-09-29 10:07:32","1");
INSERT INTO audit_trail VALUES("4955","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-29 10:14:56","2021-09-29 10:14:56","");
INSERT INTO audit_trail VALUES("4956","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-29 10:15:51","2021-09-29 10:15:51","1");
INSERT INTO audit_trail VALUES("4957","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-30 01:10:15","2021-09-30 01:10:15","1");
INSERT INTO audit_trail VALUES("4958","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-30 01:18:50","2021-09-30 01:18:50","1");
INSERT INTO audit_trail VALUES("4959","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-30 01:24:49","2021-09-30 01:24:49","1");
INSERT INTO audit_trail VALUES("4960","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:731","2021-09-30 01:26:09","2021-09-30 01:26:09","1");
INSERT INTO audit_trail VALUES("4961","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:732","2021-09-30 02:30:50","2021-09-30 02:30:50","1");
INSERT INTO audit_trail VALUES("4962","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:732","2021-09-30 02:34:11","2021-09-30 02:34:11","1");
INSERT INTO audit_trail VALUES("4963","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:733","2021-09-30 03:44:38","2021-09-30 03:44:38","1");
INSERT INTO audit_trail VALUES("4964","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:732","2021-09-30 03:45:23","2021-09-30 03:45:23","1");
INSERT INTO audit_trail VALUES("4965","2","CECILIA WANJERI WANGUHU","","Added expense with id:383","2021-09-30 08:36:54","2021-09-30 08:36:54","1");
INSERT INTO audit_trail VALUES("4966","2","CECILIA WANJERI WANGUHU","","Added expense with id:384","2021-09-30 09:56:23","2021-09-30 09:56:23","1");
INSERT INTO audit_trail VALUES("4967","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-30 10:10:22","2021-09-30 10:10:22","1");
INSERT INTO audit_trail VALUES("4968","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-09-30 10:11:02","2021-09-30 10:11:02","");
INSERT INTO audit_trail VALUES("4969","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-09-30 10:27:15","2021-09-30 10:27:15","1");
INSERT INTO audit_trail VALUES("4970","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-01 01:31:36","2021-10-01 01:31:36","1");
INSERT INTO audit_trail VALUES("4971","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:734","2021-10-01 01:35:21","2021-10-01 01:35:21","1");
INSERT INTO audit_trail VALUES("4972","2","CECILIA WANJERI WANGUHU","","Updated expense with id:383","2021-10-01 01:43:52","2021-10-01 01:43:52","1");
INSERT INTO audit_trail VALUES("4973","2","CECILIA WANJERI WANGUHU","","Updated expense with id:383","2021-10-01 01:45:51","2021-10-01 01:45:51","1");
INSERT INTO audit_trail VALUES("4974","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:29508","2021-10-01 02:05:42","2021-10-01 02:05:42","1");
INSERT INTO audit_trail VALUES("4975","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-01 02:08:31","2021-10-01 02:08:31","1");
INSERT INTO audit_trail VALUES("4976","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:735","2021-10-01 03:17:39","2021-10-01 03:17:39","1");
INSERT INTO audit_trail VALUES("4977","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:736","2021-10-01 03:48:46","2021-10-01 03:48:46","1");
INSERT INTO audit_trail VALUES("4978","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:737","2021-10-01 03:49:37","2021-10-01 03:49:37","1");
INSERT INTO audit_trail VALUES("4979","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:738","2021-10-01 03:50:52","2021-10-01 03:50:52","1");
INSERT INTO audit_trail VALUES("4980","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:739","2021-10-01 03:57:42","2021-10-01 03:57:42","1");
INSERT INTO audit_trail VALUES("4981","2","CECILIA WANJERI WANGUHU","","Added expense with id:385","2021-10-01 05:31:54","2021-10-01 05:31:54","1");
INSERT INTO audit_trail VALUES("4982","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-01 08:11:22","2021-10-01 08:11:22","");
INSERT INTO audit_trail VALUES("4983","2","CECILIA WANJERI WANGUHU","","Added repayment for loan with id:12","2021-10-01 08:15:33","2021-10-01 08:15:33","1");
INSERT INTO audit_trail VALUES("4984","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-01 10:02:55","2021-10-01 10:02:55","1");
INSERT INTO audit_trail VALUES("4985","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-01 10:11:01","2021-10-01 10:11:01","");
INSERT INTO audit_trail VALUES("4986","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-01 10:14:41","2021-10-01 10:14:41","1");
INSERT INTO audit_trail VALUES("4987","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-01 10:14:49","2021-10-01 10:14:49","1");
INSERT INTO audit_trail VALUES("4988","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-02 01:14:10","2021-10-02 01:14:10","1");
INSERT INTO audit_trail VALUES("4989","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:740","2021-10-02 01:15:13","2021-10-02 01:15:13","1");
INSERT INTO audit_trail VALUES("4990","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:741","2021-10-02 02:22:33","2021-10-02 02:22:33","1");
INSERT INTO audit_trail VALUES("4991","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:742","2021-10-02 02:24:02","2021-10-02 02:24:02","1");
INSERT INTO audit_trail VALUES("4992","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-02 05:25:47","2021-10-02 05:25:47","1");
INSERT INTO audit_trail VALUES("4993","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-02 05:25:48","2021-10-02 05:25:48","1");
INSERT INTO audit_trail VALUES("4994","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-02 06:16:43","2021-10-02 06:16:43","1");
INSERT INTO audit_trail VALUES("4995","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-02 06:17:45","2021-10-02 06:17:45","1");
INSERT INTO audit_trail VALUES("4996","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-02 06:18:05","2021-10-02 06:18:05","1");
INSERT INTO audit_trail VALUES("4997","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-02 06:20:31","2021-10-02 06:20:31","");
INSERT INTO audit_trail VALUES("4998","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-02 06:21:45","2021-10-02 06:21:45","1");
INSERT INTO audit_trail VALUES("4999","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-02 06:28:31","2021-10-02 06:28:31","1");
INSERT INTO audit_trail VALUES("5000","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-02 06:31:02","2021-10-02 06:31:02","1");
INSERT INTO audit_trail VALUES("5001","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-04 01:39:51","2021-10-04 01:39:51","");
INSERT INTO audit_trail VALUES("5002","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:743","2021-10-04 01:42:28","2021-10-04 01:42:28","1");
INSERT INTO audit_trail VALUES("5003","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-04 01:43:36","2021-10-04 01:43:36","1");
INSERT INTO audit_trail VALUES("5004","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-04 01:49:39","2021-10-04 01:49:39","");
INSERT INTO audit_trail VALUES("5005","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:744","2021-10-04 03:03:30","2021-10-04 03:03:30","1");
INSERT INTO audit_trail VALUES("5006","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:745","2021-10-04 03:11:29","2021-10-04 03:11:29","1");
INSERT INTO audit_trail VALUES("5007","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:744","2021-10-04 05:37:21","2021-10-04 05:37:21","1");
INSERT INTO audit_trail VALUES("5008","2","CECILIA WANJERI WANGUHU","","Added expense with id:386","2021-10-04 09:30:20","2021-10-04 09:30:20","1");
INSERT INTO audit_trail VALUES("5009","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:746","2021-10-04 10:09:13","2021-10-04 10:09:13","1");
INSERT INTO audit_trail VALUES("5010","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-04 10:11:52","2021-10-04 10:11:52","");
INSERT INTO audit_trail VALUES("5011","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-04 10:20:26","2021-10-04 10:20:26","1");
INSERT INTO audit_trail VALUES("5012","1","Admin Admin","","Logged in to system","2021-10-07 02:37:51","2021-10-07 02:37:51","");
INSERT INTO audit_trail VALUES("5013","1","Admin Admin","","Logged in to system","2021-10-07 02:40:22","2021-10-07 02:40:22","1");
INSERT INTO audit_trail VALUES("5014","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-07 02:51:43","2021-10-07 02:51:43","");
INSERT INTO audit_trail VALUES("5015","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-07 02:56:00","2021-10-07 02:56:00","");
INSERT INTO audit_trail VALUES("5016","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:747","2021-10-07 02:57:19","2021-10-07 02:57:19","1");
INSERT INTO audit_trail VALUES("5017","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-07 03:16:58","2021-10-07 03:16:58","1");
INSERT INTO audit_trail VALUES("5018","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:748","2021-10-07 03:17:28","2021-10-07 03:17:28","1");
INSERT INTO audit_trail VALUES("5019","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:749","2021-10-07 05:00:28","2021-10-07 05:00:28","1");
INSERT INTO audit_trail VALUES("5020","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-07 05:10:51","2021-10-07 05:10:51","");
INSERT INTO audit_trail VALUES("5021","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:750","2021-10-07 05:16:20","2021-10-07 05:16:20","1");
INSERT INTO audit_trail VALUES("5022","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:751","2021-10-07 05:20:29","2021-10-07 05:20:29","1");
INSERT INTO audit_trail VALUES("5023","2","CECILIA WANJERI WANGUHU","","Added expense with id:387","2021-10-07 05:28:15","2021-10-07 05:28:15","1");
INSERT INTO audit_trail VALUES("5024","2","CECILIA WANJERI WANGUHU","","Added expense with id:388","2021-10-07 05:32:09","2021-10-07 05:32:09","1");
INSERT INTO audit_trail VALUES("5025","2","CECILIA WANJERI WANGUHU","","Added expense with id:389","2021-10-07 05:33:21","2021-10-07 05:33:21","1");
INSERT INTO audit_trail VALUES("5026","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:752","2021-10-07 05:41:15","2021-10-07 05:41:15","1");
INSERT INTO audit_trail VALUES("5027","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:753","2021-10-07 05:56:01","2021-10-07 05:56:01","1");
INSERT INTO audit_trail VALUES("5028","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:754","2021-10-07 05:56:58","2021-10-07 05:56:58","1");
INSERT INTO audit_trail VALUES("5029","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:639","2021-10-07 06:08:53","2021-10-07 06:08:53","1");
INSERT INTO audit_trail VALUES("5030","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:755","2021-10-07 06:12:05","2021-10-07 06:12:05","1");
INSERT INTO audit_trail VALUES("5031","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30024","2021-10-07 08:20:46","2021-10-07 08:20:46","1");
INSERT INTO audit_trail VALUES("5032","2","CECILIA WANJERI WANGUHU","","Added expense with id:390","2021-10-07 09:51:22","2021-10-07 09:51:22","1");
INSERT INTO audit_trail VALUES("5033","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-07 10:08:05","2021-10-07 10:08:05","1");
INSERT INTO audit_trail VALUES("5034","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-08 01:25:22","2021-10-08 01:25:22","1");
INSERT INTO audit_trail VALUES("5035","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-08 01:51:10","2021-10-08 01:51:10","1");
INSERT INTO audit_trail VALUES("5036","1","Admin Admin","","Logged in to system","2021-10-08 02:32:38","2021-10-08 02:32:38","");
INSERT INTO audit_trail VALUES("5037","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-08 02:51:07","2021-10-08 02:51:07","");
INSERT INTO audit_trail VALUES("5038","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:756","2021-10-08 02:58:16","2021-10-08 02:58:16","1");
INSERT INTO audit_trail VALUES("5039","2","CECILIA WANJERI WANGUHU","","Added expense with id:391","2021-10-08 07:16:06","2021-10-08 07:16:06","1");
INSERT INTO audit_trail VALUES("5040","2","CECILIA WANJERI WANGUHU","","Updated expense with id:391","2021-10-08 07:29:23","2021-10-08 07:29:23","1");
INSERT INTO audit_trail VALUES("5041","2","CECILIA WANJERI WANGUHU","","Added expense with id:392","2021-10-08 08:25:39","2021-10-08 08:25:39","1");
INSERT INTO audit_trail VALUES("5042","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:757","2021-10-08 08:33:26","2021-10-08 08:33:26","1");
INSERT INTO audit_trail VALUES("5043","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:755","2021-10-08 08:37:06","2021-10-08 08:37:06","1");
INSERT INTO audit_trail VALUES("5044","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:758","2021-10-08 08:42:48","2021-10-08 08:42:48","1");
INSERT INTO audit_trail VALUES("5045","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-08 10:16:31","2021-10-08 10:16:31","1");
INSERT INTO audit_trail VALUES("5046","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-08 10:16:46","2021-10-08 10:16:46","1");
INSERT INTO audit_trail VALUES("5047","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-08 10:17:24","2021-10-08 10:17:24","1");
INSERT INTO audit_trail VALUES("5048","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-08 10:25:51","2021-10-08 10:25:51","1");
INSERT INTO audit_trail VALUES("5049","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-09 01:50:22","2021-10-09 01:50:22","1");
INSERT INTO audit_trail VALUES("5050","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-09 02:24:16","2021-10-09 02:24:16","1");
INSERT INTO audit_trail VALUES("5051","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:759","2021-10-09 02:25:34","2021-10-09 02:25:34","1");
INSERT INTO audit_trail VALUES("5052","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:661","2021-10-09 02:57:33","2021-10-09 02:57:33","1");
INSERT INTO audit_trail VALUES("5053","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:760","2021-10-09 03:00:03","2021-10-09 03:00:03","1");
INSERT INTO audit_trail VALUES("5054","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30132","2021-10-09 03:04:54","2021-10-09 03:04:54","1");
INSERT INTO audit_trail VALUES("5055","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30134","2021-10-09 03:09:41","2021-10-09 03:09:41","1");
INSERT INTO audit_trail VALUES("5056","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30136","2021-10-09 03:11:37","2021-10-09 03:11:37","1");
INSERT INTO audit_trail VALUES("5057","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30138","2021-10-09 03:12:24","2021-10-09 03:12:24","1");
INSERT INTO audit_trail VALUES("5058","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30140","2021-10-09 03:13:38","2021-10-09 03:13:38","1");
INSERT INTO audit_trail VALUES("5059","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-09 03:14:35","2021-10-09 03:14:35","1");
INSERT INTO audit_trail VALUES("5060","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30142","2021-10-09 03:26:24","2021-10-09 03:26:24","1");
INSERT INTO audit_trail VALUES("5061","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30144","2021-10-09 03:27:15","2021-10-09 03:27:15","1");
INSERT INTO audit_trail VALUES("5062","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30146","2021-10-09 03:27:58","2021-10-09 03:27:58","1");
INSERT INTO audit_trail VALUES("5063","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30148","2021-10-09 03:28:36","2021-10-09 03:28:36","1");
INSERT INTO audit_trail VALUES("5064","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30152","2021-10-09 03:30:22","2021-10-09 03:30:22","1");
INSERT INTO audit_trail VALUES("5065","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30154","2021-10-09 03:31:02","2021-10-09 03:31:02","1");
INSERT INTO audit_trail VALUES("5066","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30156","2021-10-09 03:31:44","2021-10-09 03:31:44","1");
INSERT INTO audit_trail VALUES("5067","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30158","2021-10-09 03:32:39","2021-10-09 03:32:39","1");
INSERT INTO audit_trail VALUES("5068","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30160","2021-10-09 03:33:16","2021-10-09 03:33:16","1");
INSERT INTO audit_trail VALUES("5069","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30162","2021-10-09 03:34:18","2021-10-09 03:34:18","1");
INSERT INTO audit_trail VALUES("5070","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30164","2021-10-09 03:35:12","2021-10-09 03:35:12","1");
INSERT INTO audit_trail VALUES("5071","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30166","2021-10-09 03:36:03","2021-10-09 03:36:03","1");
INSERT INTO audit_trail VALUES("5072","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30169","2021-10-09 03:39:00","2021-10-09 03:39:00","1");
INSERT INTO audit_trail VALUES("5073","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30181","2021-10-09 03:45:14","2021-10-09 03:45:14","1");
INSERT INTO audit_trail VALUES("5074","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-09 04:02:34","2021-10-09 04:02:34","1");
INSERT INTO audit_trail VALUES("5075","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-09 04:02:54","2021-10-09 04:02:54","1");
INSERT INTO audit_trail VALUES("5076","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-09 04:05:09","2021-10-09 04:05:09","1");
INSERT INTO audit_trail VALUES("5077","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30207","2021-10-09 04:17:25","2021-10-09 04:17:25","1");
INSERT INTO audit_trail VALUES("5078","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30209","2021-10-09 04:19:55","2021-10-09 04:19:55","1");
INSERT INTO audit_trail VALUES("5079","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30211","2021-10-09 04:25:04","2021-10-09 04:25:04","1");
INSERT INTO audit_trail VALUES("5080","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-09 06:05:39","2021-10-09 06:05:39","1");
INSERT INTO audit_trail VALUES("5081","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-09 06:10:25","2021-10-09 06:10:25","1");
INSERT INTO audit_trail VALUES("5082","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-09 06:25:14","2021-10-09 06:25:14","1");
INSERT INTO audit_trail VALUES("5083","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-12 02:40:42","2021-10-12 02:40:42","");
INSERT INTO audit_trail VALUES("5084","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:761","2021-10-12 02:41:33","2021-10-12 02:41:33","1");
INSERT INTO audit_trail VALUES("5085","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:761","2021-10-12 02:42:14","2021-10-12 02:42:14","1");
INSERT INTO audit_trail VALUES("5086","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-12 02:48:23","2021-10-12 02:48:23","");
INSERT INTO audit_trail VALUES("5087","2","CECILIA WANJERI WANGUHU","","Added loan with id:229","2021-10-12 04:46:51","2021-10-12 04:46:51","1");
INSERT INTO audit_trail VALUES("5088","2","CECILIA WANJERI WANGUHU","","Approved loan with id:229","2021-10-12 04:50:51","2021-10-12 04:50:51","1");
INSERT INTO audit_trail VALUES("5089","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:229","2021-10-12 04:51:37","2021-10-12 04:51:37","1");
INSERT INTO audit_trail VALUES("5090","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30273","2021-10-12 05:01:01","2021-10-12 05:01:01","1");
INSERT INTO audit_trail VALUES("5091","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30277","2021-10-12 05:10:22","2021-10-12 05:10:22","1");
INSERT INTO audit_trail VALUES("5092","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30280","2021-10-12 05:14:41","2021-10-12 05:14:41","1");
INSERT INTO audit_trail VALUES("5093","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:762","2021-10-12 05:17:08","2021-10-12 05:17:08","1");
INSERT INTO audit_trail VALUES("5094","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:762","2021-10-12 05:23:31","2021-10-12 05:23:31","1");
INSERT INTO audit_trail VALUES("5095","2","CECILIA WANJERI WANGUHU","","Added expense with id:393","2021-10-12 05:23:42","2021-10-12 05:23:42","1");
INSERT INTO audit_trail VALUES("5096","2","CECILIA WANJERI WANGUHU","","Added expense with id:394","2021-10-12 05:24:40","2021-10-12 05:24:40","1");
INSERT INTO audit_trail VALUES("5097","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-12 09:49:34","2021-10-12 09:49:34","1");
INSERT INTO audit_trail VALUES("5098","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-12 09:51:06","2021-10-12 09:51:06","");
INSERT INTO audit_trail VALUES("5099","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-12 09:53:18","2021-10-12 09:53:18","1");
INSERT INTO audit_trail VALUES("5100","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-12 10:39:27","2021-10-12 10:39:27","1");
INSERT INTO audit_trail VALUES("5101","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-13 01:10:46","2021-10-13 01:10:46","1");
INSERT INTO audit_trail VALUES("5102","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:763","2021-10-13 01:21:11","2021-10-13 01:21:11","1");
INSERT INTO audit_trail VALUES("5103","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:764","2021-10-13 01:41:27","2021-10-13 01:41:27","1");
INSERT INTO audit_trail VALUES("5104","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-13 01:46:16","2021-10-13 01:46:16","1");
INSERT INTO audit_trail VALUES("5105","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-13 01:46:20","2021-10-13 01:46:20","1");
INSERT INTO audit_trail VALUES("5106","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30361","2021-10-13 01:56:37","2021-10-13 01:56:37","1");
INSERT INTO audit_trail VALUES("5107","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:765","2021-10-13 05:05:58","2021-10-13 05:05:58","1");
INSERT INTO audit_trail VALUES("5108","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:766","2021-10-13 09:51:52","2021-10-13 09:51:52","1");
INSERT INTO audit_trail VALUES("5109","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-13 10:09:23","2021-10-13 10:09:23","1");
INSERT INTO audit_trail VALUES("5110","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-13 10:12:35","2021-10-13 10:12:35","1");
INSERT INTO audit_trail VALUES("5111","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-13 10:12:47","2021-10-13 10:12:47","1");
INSERT INTO audit_trail VALUES("5112","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-14 01:30:27","2021-10-14 01:30:27","1");
INSERT INTO audit_trail VALUES("5113","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-14 01:30:53","2021-10-14 01:30:53","1");
INSERT INTO audit_trail VALUES("5114","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:767","2021-10-14 01:32:22","2021-10-14 01:32:22","1");
INSERT INTO audit_trail VALUES("5115","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:768","2021-10-14 01:50:02","2021-10-14 01:50:02","1");
INSERT INTO audit_trail VALUES("5116","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:769","2021-10-14 01:50:39","2021-10-14 01:50:39","1");
INSERT INTO audit_trail VALUES("5117","1","Admin Admin","","Logged in to system","2021-10-14 07:32:17","2021-10-14 07:32:17","");
INSERT INTO audit_trail VALUES("5118","2","CECILIA WANJERI WANGUHU","","Added expense with id:395","2021-10-14 10:01:20","2021-10-14 10:01:20","1");
INSERT INTO audit_trail VALUES("5119","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-14 10:10:08","2021-10-14 10:10:08","1");
INSERT INTO audit_trail VALUES("5120","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-14 10:11:06","2021-10-14 10:11:06","1");
INSERT INTO audit_trail VALUES("5121","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-14 10:11:23","2021-10-14 10:11:23","1");
INSERT INTO audit_trail VALUES("5122","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-14 10:28:44","2021-10-14 10:28:44","");
INSERT INTO audit_trail VALUES("5123","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-14 10:29:48","2021-10-14 10:29:48","1");
INSERT INTO audit_trail VALUES("5124","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-15 01:15:32","2021-10-15 01:15:32","1");
INSERT INTO audit_trail VALUES("5125","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:770","2021-10-15 01:16:53","2021-10-15 01:16:53","1");
INSERT INTO audit_trail VALUES("5126","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-15 02:29:36","2021-10-15 02:29:36","1");
INSERT INTO audit_trail VALUES("5127","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:771","2021-10-15 03:21:47","2021-10-15 03:21:47","1");
INSERT INTO audit_trail VALUES("5128","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:772","2021-10-15 03:22:31","2021-10-15 03:22:31","1");
INSERT INTO audit_trail VALUES("5129","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:773","2021-10-15 03:28:29","2021-10-15 03:28:29","1");
INSERT INTO audit_trail VALUES("5130","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30522","2021-10-15 03:34:45","2021-10-15 03:34:45","1");
INSERT INTO audit_trail VALUES("5131","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:770","2021-10-15 03:38:43","2021-10-15 03:38:43","1");
INSERT INTO audit_trail VALUES("5132","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30526","2021-10-15 04:07:06","2021-10-15 04:07:06","1");
INSERT INTO audit_trail VALUES("5133","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30528","2021-10-15 04:12:03","2021-10-15 04:12:03","1");
INSERT INTO audit_trail VALUES("5134","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30530","2021-10-15 04:13:09","2021-10-15 04:13:09","1");
INSERT INTO audit_trail VALUES("5135","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30532","2021-10-15 04:18:32","2021-10-15 04:18:32","1");
INSERT INTO audit_trail VALUES("5136","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30537","2021-10-15 04:22:47","2021-10-15 04:22:47","1");
INSERT INTO audit_trail VALUES("5137","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30539","2021-10-15 04:25:15","2021-10-15 04:25:15","1");
INSERT INTO audit_trail VALUES("5138","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30541","2021-10-15 04:34:46","2021-10-15 04:34:46","1");
INSERT INTO audit_trail VALUES("5139","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30543","2021-10-15 04:40:33","2021-10-15 04:40:33","1");
INSERT INTO audit_trail VALUES("5140","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30545","2021-10-15 04:42:17","2021-10-15 04:42:17","1");
INSERT INTO audit_trail VALUES("5141","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-15 10:17:53","2021-10-15 10:17:53","1");
INSERT INTO audit_trail VALUES("5142","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-15 10:28:44","2021-10-15 10:28:44","1");
INSERT INTO audit_trail VALUES("5143","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-15 10:29:51","2021-10-15 10:29:51","1");
INSERT INTO audit_trail VALUES("5144","1","Admin Admin","","Logged in to system","2021-10-15 10:42:53","2021-10-15 10:42:53","");
INSERT INTO audit_trail VALUES("5145","1","Admin Admin","","Added loan with id:230","2021-10-15 11:00:13","2021-10-15 11:00:13","1");
INSERT INTO audit_trail VALUES("5146","1","Admin Admin","","Approved loan with id:230","2021-10-15 11:00:40","2021-10-15 11:00:40","1");
INSERT INTO audit_trail VALUES("5147","1","Admin Admin","","Disbursed loan with id:230","2021-10-15 11:03:18","2021-10-15 11:03:18","1");
INSERT INTO audit_trail VALUES("5148","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-16 01:19:25","2021-10-16 01:19:25","1");
INSERT INTO audit_trail VALUES("5149","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-16 01:19:27","2021-10-16 01:19:27","1");
INSERT INTO audit_trail VALUES("5150","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-16 01:25:03","2021-10-16 01:25:03","1");
INSERT INTO audit_trail VALUES("5151","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:774","2021-10-16 01:25:59","2021-10-16 01:25:59","1");
INSERT INTO audit_trail VALUES("5152","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:775","2021-10-16 01:31:43","2021-10-16 01:31:43","1");
INSERT INTO audit_trail VALUES("5153","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:776","2021-10-16 01:33:14","2021-10-16 01:33:14","1");
INSERT INTO audit_trail VALUES("5154","2","CECILIA WANJERI WANGUHU","","Added expense with id:396","2021-10-16 01:34:23","2021-10-16 01:34:23","1");
INSERT INTO audit_trail VALUES("5155","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:777","2021-10-16 03:51:54","2021-10-16 03:51:54","1");
INSERT INTO audit_trail VALUES("5156","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:778","2021-10-16 03:58:29","2021-10-16 03:58:29","1");
INSERT INTO audit_trail VALUES("5157","2","CECILIA WANJERI WANGUHU","","Added expense with id:397","2021-10-16 04:16:24","2021-10-16 04:16:24","1");
INSERT INTO audit_trail VALUES("5158","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-16 06:06:39","2021-10-16 06:06:39","1");
INSERT INTO audit_trail VALUES("5159","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-16 06:09:06","2021-10-16 06:09:06","1");
INSERT INTO audit_trail VALUES("5160","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-16 06:10:34","2021-10-16 06:10:34","1");
INSERT INTO audit_trail VALUES("5161","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-18 01:10:02","2021-10-18 01:10:02","");
INSERT INTO audit_trail VALUES("5162","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:779","2021-10-18 01:11:17","2021-10-18 01:11:17","1");
INSERT INTO audit_trail VALUES("5163","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-18 03:24:16","2021-10-18 03:24:16","");
INSERT INTO audit_trail VALUES("5164","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-18 10:02:33","2021-10-18 10:02:33","1");
INSERT INTO audit_trail VALUES("5165","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-18 10:07:19","2021-10-18 10:07:19","");
INSERT INTO audit_trail VALUES("5166","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-19 01:32:07","2021-10-19 01:32:07","1");
INSERT INTO audit_trail VALUES("5167","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:780","2021-10-19 01:33:25","2021-10-19 01:33:25","1");
INSERT INTO audit_trail VALUES("5168","2","CECILIA WANJERI WANGUHU","","Added expense with id:398","2021-10-19 02:00:53","2021-10-19 02:00:53","1");
INSERT INTO audit_trail VALUES("5169","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-19 02:04:21","2021-10-19 02:04:21","1");
INSERT INTO audit_trail VALUES("5170","2","CECILIA WANJERI WANGUHU","","Added expense with id:399","2021-10-19 02:04:21","2021-10-19 02:04:21","1");
INSERT INTO audit_trail VALUES("5171","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:30764","2021-10-19 02:30:42","2021-10-19 02:30:42","1");
INSERT INTO audit_trail VALUES("5172","2","CECILIA WANJERI WANGUHU","","Added expense with id:400","2021-10-19 03:00:59","2021-10-19 03:00:59","1");
INSERT INTO audit_trail VALUES("5173","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:781","2021-10-19 05:31:37","2021-10-19 05:31:37","1");
INSERT INTO audit_trail VALUES("5174","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:782","2021-10-19 05:32:56","2021-10-19 05:32:56","1");
INSERT INTO audit_trail VALUES("5175","1","Admin Admin","","Logged in to system","2021-10-19 07:54:42","2021-10-19 07:54:42","");
INSERT INTO audit_trail VALUES("5176","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-19 10:06:03","2021-10-19 10:06:03","1");
INSERT INTO audit_trail VALUES("5177","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-19 10:08:07","2021-10-19 10:08:07","1");
INSERT INTO audit_trail VALUES("5178","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-21 02:15:10","2021-10-21 02:15:10","");
INSERT INTO audit_trail VALUES("5179","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:783","2021-10-21 02:17:01","2021-10-21 02:17:01","1");
INSERT INTO audit_trail VALUES("5180","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-21 02:38:06","2021-10-21 02:38:06","");
INSERT INTO audit_trail VALUES("5181","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:784","2021-10-21 03:02:16","2021-10-21 03:02:16","1");
INSERT INTO audit_trail VALUES("5182","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:785","2021-10-21 03:08:49","2021-10-21 03:08:49","1");
INSERT INTO audit_trail VALUES("5183","2","CECILIA WANJERI WANGUHU","","Added expense with id:401","2021-10-21 03:33:12","2021-10-21 03:33:12","1");
INSERT INTO audit_trail VALUES("5184","2","CECILIA WANJERI WANGUHU","","Added expense with id:402","2021-10-21 03:34:32","2021-10-21 03:34:32","1");
INSERT INTO audit_trail VALUES("5185","2","CECILIA WANJERI WANGUHU","","Updated expense with id:395","2021-10-21 04:01:52","2021-10-21 04:01:52","1");
INSERT INTO audit_trail VALUES("5186","2","CECILIA WANJERI WANGUHU","","Updated expense with id:401","2021-10-21 10:05:07","2021-10-21 10:05:07","1");
INSERT INTO audit_trail VALUES("5187","2","CECILIA WANJERI WANGUHU","","Updated expense with id:401","2021-10-21 10:13:33","2021-10-21 10:13:33","1");
INSERT INTO audit_trail VALUES("5188","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-21 10:19:44","2021-10-21 10:19:44","1");
INSERT INTO audit_trail VALUES("5189","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-21 10:19:56","2021-10-21 10:19:56","1");
INSERT INTO audit_trail VALUES("5190","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-21 10:21:17","2021-10-21 10:21:17","1");
INSERT INTO audit_trail VALUES("5191","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-21 10:24:43","2021-10-21 10:24:43","");
INSERT INTO audit_trail VALUES("5192","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-22 01:04:49","2021-10-22 01:04:49","1");
INSERT INTO audit_trail VALUES("5193","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:786","2021-10-22 01:18:43","2021-10-22 01:18:43","1");
INSERT INTO audit_trail VALUES("5194","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-22 01:23:20","2021-10-22 01:23:20","1");
INSERT INTO audit_trail VALUES("5195","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-22 01:23:25","2021-10-22 01:23:25","1");
INSERT INTO audit_trail VALUES("5196","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:787","2021-10-22 03:18:17","2021-10-22 03:18:17","1");
INSERT INTO audit_trail VALUES("5197","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:788","2021-10-22 03:18:57","2021-10-22 03:18:57","1");
INSERT INTO audit_trail VALUES("5198","2","CECILIA WANJERI WANGUHU","","Added expense with id:403","2021-10-22 03:22:37","2021-10-22 03:22:37","1");
INSERT INTO audit_trail VALUES("5199","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:789","2021-10-22 08:41:38","2021-10-22 08:41:38","1");
INSERT INTO audit_trail VALUES("5200","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-22 10:05:23","2021-10-22 10:05:23","1");
INSERT INTO audit_trail VALUES("5201","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-22 10:17:04","2021-10-22 10:17:04","");
INSERT INTO audit_trail VALUES("5202","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-23 01:20:35","2021-10-23 01:20:35","1");
INSERT INTO audit_trail VALUES("5203","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:790","2021-10-23 01:22:12","2021-10-23 01:22:12","1");
INSERT INTO audit_trail VALUES("5204","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:790","2021-10-23 01:22:57","2021-10-23 01:22:57","1");
INSERT INTO audit_trail VALUES("5205","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-23 02:28:21","2021-10-23 02:28:21","1");
INSERT INTO audit_trail VALUES("5206","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-23 02:28:24","2021-10-23 02:28:24","1");
INSERT INTO audit_trail VALUES("5207","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:791","2021-10-23 04:42:13","2021-10-23 04:42:13","1");
INSERT INTO audit_trail VALUES("5208","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-23 06:22:15","2021-10-23 06:22:15","1");
INSERT INTO audit_trail VALUES("5209","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-23 06:29:29","2021-10-23 06:29:29","1");
INSERT INTO audit_trail VALUES("5210","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-23 06:29:46","2021-10-23 06:29:46","1");
INSERT INTO audit_trail VALUES("5211","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-25 01:22:16","2021-10-25 01:22:16","");
INSERT INTO audit_trail VALUES("5212","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:792","2021-10-25 01:23:42","2021-10-25 01:23:42","1");
INSERT INTO audit_trail VALUES("5213","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:792","2021-10-25 01:24:08","2021-10-25 01:24:08","1");
INSERT INTO audit_trail VALUES("5214","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-25 01:34:09","2021-10-25 01:34:09","");
INSERT INTO audit_trail VALUES("5215","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:793","2021-10-25 02:34:18","2021-10-25 02:34:18","1");
INSERT INTO audit_trail VALUES("5216","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:794","2021-10-25 02:41:58","2021-10-25 02:41:58","1");
INSERT INTO audit_trail VALUES("5217","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:795","2021-10-25 03:50:34","2021-10-25 03:50:34","1");
INSERT INTO audit_trail VALUES("5218","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:796","2021-10-25 03:51:09","2021-10-25 03:51:09","1");
INSERT INTO audit_trail VALUES("5219","2","CECILIA WANJERI WANGUHU","","Added expense with id:404","2021-10-25 09:57:31","2021-10-25 09:57:31","1");
INSERT INTO audit_trail VALUES("5220","2","CECILIA WANJERI WANGUHU","","Added expense with id:405","2021-10-25 09:58:20","2021-10-25 09:58:20","1");
INSERT INTO audit_trail VALUES("5221","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-25 10:08:58","2021-10-25 10:08:58","1");
INSERT INTO audit_trail VALUES("5222","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-25 10:10:28","2021-10-25 10:10:28","1");
INSERT INTO audit_trail VALUES("5223","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-25 10:10:45","2021-10-25 10:10:45","1");
INSERT INTO audit_trail VALUES("5224","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-25 10:17:35","2021-10-25 10:17:35","");
INSERT INTO audit_trail VALUES("5225","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:797","2021-10-26 01:21:39","2021-10-26 01:21:39","1");
INSERT INTO audit_trail VALUES("5226","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-26 01:40:44","2021-10-26 01:40:44","1");
INSERT INTO audit_trail VALUES("5227","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-26 01:56:55","2021-10-26 01:56:55","1");
INSERT INTO audit_trail VALUES("5228","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:640","2021-10-26 03:53:08","2021-10-26 03:53:08","1");
INSERT INTO audit_trail VALUES("5229","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31296","2021-10-26 05:19:51","2021-10-26 05:19:51","1");
INSERT INTO audit_trail VALUES("5230","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31300","2021-10-26 05:24:15","2021-10-26 05:24:15","1");
INSERT INTO audit_trail VALUES("5231","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31304","2021-10-26 05:32:42","2021-10-26 05:32:42","1");
INSERT INTO audit_trail VALUES("5232","2","CECILIA WANJERI WANGUHU","","Added expense with id:406","2021-10-26 05:48:59","2021-10-26 05:48:59","1");
INSERT INTO audit_trail VALUES("5233","2","CECILIA WANJERI WANGUHU","","Added expense with id:407","2021-10-26 05:50:14","2021-10-26 05:50:14","1");
INSERT INTO audit_trail VALUES("5234","2","CECILIA WANJERI WANGUHU","","Added expense with id:408","2021-10-26 10:19:58","2021-10-26 10:19:58","1");
INSERT INTO audit_trail VALUES("5235","2","CECILIA WANJERI WANGUHU","","Updated expense with id:408","2021-10-26 10:22:40","2021-10-26 10:22:40","1");
INSERT INTO audit_trail VALUES("5236","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-26 10:32:37","2021-10-26 10:32:37","1");
INSERT INTO audit_trail VALUES("5237","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-26 10:33:22","2021-10-26 10:33:22","1");
INSERT INTO audit_trail VALUES("5238","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-26 10:33:23","2021-10-26 10:33:23","1");
INSERT INTO audit_trail VALUES("5239","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-26 10:36:06","2021-10-26 10:36:06","1");
INSERT INTO audit_trail VALUES("5240","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-27 01:37:13","2021-10-27 01:37:13","1");
INSERT INTO audit_trail VALUES("5241","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-27 01:37:47","2021-10-27 01:37:47","1");
INSERT INTO audit_trail VALUES("5242","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:798","2021-10-27 01:38:47","2021-10-27 01:38:47","1");
INSERT INTO audit_trail VALUES("5243","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:799","2021-10-27 02:13:59","2021-10-27 02:13:59","1");
INSERT INTO audit_trail VALUES("5244","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:641","2021-10-27 04:33:26","2021-10-27 04:33:26","1");
INSERT INTO audit_trail VALUES("5245","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-27 04:39:00","2021-10-27 04:39:00","");
INSERT INTO audit_trail VALUES("5246","2","CECILIA WANJERI WANGUHU","","Added expense with id:409","2021-10-27 09:29:18","2021-10-27 09:29:18","1");
INSERT INTO audit_trail VALUES("5247","2","CECILIA WANJERI WANGUHU","","Added expense with id:410","2021-10-27 09:58:26","2021-10-27 09:58:26","1");
INSERT INTO audit_trail VALUES("5248","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:800","2021-10-27 10:08:36","2021-10-27 10:08:36","1");
INSERT INTO audit_trail VALUES("5249","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-27 10:09:16","2021-10-27 10:09:16","1");
INSERT INTO audit_trail VALUES("5250","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-27 10:23:45","2021-10-27 10:23:45","1");
INSERT INTO audit_trail VALUES("5251","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-27 10:26:53","2021-10-27 10:26:53","1");
INSERT INTO audit_trail VALUES("5252","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-28 01:44:01","2021-10-28 01:44:01","1");
INSERT INTO audit_trail VALUES("5253","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-28 01:44:03","2021-10-28 01:44:03","1");
INSERT INTO audit_trail VALUES("5254","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:801","2021-10-28 01:45:39","2021-10-28 01:45:39","1");
INSERT INTO audit_trail VALUES("5255","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-28 01:56:32","2021-10-28 01:56:32","1");
INSERT INTO audit_trail VALUES("5256","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-28 02:17:36","2021-10-28 02:17:36","1");
INSERT INTO audit_trail VALUES("5257","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:802","2021-10-28 02:46:05","2021-10-28 02:46:05","1");
INSERT INTO audit_trail VALUES("5258","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31482","2021-10-28 02:56:05","2021-10-28 02:56:05","1");
INSERT INTO audit_trail VALUES("5259","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:803","2021-10-28 02:59:36","2021-10-28 02:59:36","1");
INSERT INTO audit_trail VALUES("5260","2","CECILIA WANJERI WANGUHU","","Added expense with id:411","2021-10-28 09:45:29","2021-10-28 09:45:29","1");
INSERT INTO audit_trail VALUES("5261","2","CECILIA WANJERI WANGUHU","","Updated expense with id:411","2021-10-28 10:17:16","2021-10-28 10:17:16","1");
INSERT INTO audit_trail VALUES("5262","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-28 10:33:51","2021-10-28 10:33:51","1");
INSERT INTO audit_trail VALUES("5263","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-28 10:35:20","2021-10-28 10:35:20","1");
INSERT INTO audit_trail VALUES("5264","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-28 10:35:38","2021-10-28 10:35:38","1");
INSERT INTO audit_trail VALUES("5265","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-29 01:19:50","2021-10-29 01:19:50","1");
INSERT INTO audit_trail VALUES("5266","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:804","2021-10-29 01:23:18","2021-10-29 01:23:18","1");
INSERT INTO audit_trail VALUES("5267","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-29 02:09:22","2021-10-29 02:09:22","1");
INSERT INTO audit_trail VALUES("5268","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-29 02:09:24","2021-10-29 02:09:24","1");
INSERT INTO audit_trail VALUES("5269","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:805","2021-10-29 02:12:21","2021-10-29 02:12:21","1");
INSERT INTO audit_trail VALUES("5270","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:806","2021-10-29 02:13:18","2021-10-29 02:13:18","1");
INSERT INTO audit_trail VALUES("5271","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:807","2021-10-29 02:14:52","2021-10-29 02:14:52","1");
INSERT INTO audit_trail VALUES("5272","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:808","2021-10-29 02:16:06","2021-10-29 02:16:06","1");
INSERT INTO audit_trail VALUES("5273","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31582","2021-10-29 02:52:29","2021-10-29 02:52:29","1");
INSERT INTO audit_trail VALUES("5274","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31591","2021-10-29 02:59:55","2021-10-29 02:59:55","1");
INSERT INTO audit_trail VALUES("5275","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31598","2021-10-29 03:11:35","2021-10-29 03:11:35","1");
INSERT INTO audit_trail VALUES("5276","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31613","2021-10-29 03:20:46","2021-10-29 03:20:46","1");
INSERT INTO audit_trail VALUES("5277","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31686","2021-10-29 08:30:00","2021-10-29 08:30:00","1");
INSERT INTO audit_trail VALUES("5278","2","CECILIA WANJERI WANGUHU","","Added expense with id:412","2021-10-29 08:31:19","2021-10-29 08:31:19","1");
INSERT INTO audit_trail VALUES("5279","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31690","2021-10-29 08:32:52","2021-10-29 08:32:52","1");
INSERT INTO audit_trail VALUES("5280","2","CECILIA WANJERI WANGUHU","","Added expense with id:413","2021-10-29 09:40:07","2021-10-29 09:40:07","1");
INSERT INTO audit_trail VALUES("5281","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31733","2021-10-29 10:10:23","2021-10-29 10:10:23","1");
INSERT INTO audit_trail VALUES("5282","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31735","2021-10-29 10:15:28","2021-10-29 10:15:28","1");
INSERT INTO audit_trail VALUES("5283","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31745","2021-10-29 10:39:37","2021-10-29 10:39:37","1");
INSERT INTO audit_trail VALUES("5284","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31747","2021-10-29 10:49:58","2021-10-29 10:49:58","1");
INSERT INTO audit_trail VALUES("5285","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31754","2021-10-29 11:05:45","2021-10-29 11:05:45","1");
INSERT INTO audit_trail VALUES("5286","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31756","2021-10-29 11:09:38","2021-10-29 11:09:38","1");
INSERT INTO audit_trail VALUES("5287","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31759","2021-10-29 11:15:12","2021-10-29 11:15:12","1");
INSERT INTO audit_trail VALUES("5288","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-29 11:20:26","2021-10-29 11:20:26","1");
INSERT INTO audit_trail VALUES("5289","1","Admin Admin","","Logged in to system","2021-10-29 11:29:24","2021-10-29 11:29:24","");
INSERT INTO audit_trail VALUES("5290","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-29 11:37:33","2021-10-29 11:37:33","1");
INSERT INTO audit_trail VALUES("5291","1","Admin Admin","","Logged in to system","2021-10-29 11:44:57","2021-10-29 11:44:57","");
INSERT INTO audit_trail VALUES("5292","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:809","2021-10-30 01:38:43","2021-10-30 01:38:43","1");
INSERT INTO audit_trail VALUES("5293","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-30 01:42:45","2021-10-30 01:42:45","1");
INSERT INTO audit_trail VALUES("5294","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:810","2021-10-30 04:15:54","2021-10-30 04:15:54","1");
INSERT INTO audit_trail VALUES("5295","2","CECILIA WANJERI WANGUHU","","Added expense with id:414","2021-10-30 04:22:40","2021-10-30 04:22:40","1");
INSERT INTO audit_trail VALUES("5296","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:811","2021-10-30 04:30:56","2021-10-30 04:30:56","1");
INSERT INTO audit_trail VALUES("5297","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31848","2021-10-30 04:34:10","2021-10-30 04:34:10","1");
INSERT INTO audit_trail VALUES("5298","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:812","2021-10-30 05:19:53","2021-10-30 05:19:53","1");
INSERT INTO audit_trail VALUES("5299","2","CECILIA WANJERI WANGUHU","","Added expense with id:415","2021-10-30 05:42:05","2021-10-30 05:42:05","1");
INSERT INTO audit_trail VALUES("5300","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-30 06:20:06","2021-10-30 06:20:06","1");
INSERT INTO audit_trail VALUES("5301","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-30 06:20:27","2021-10-30 06:20:27","1");
INSERT INTO audit_trail VALUES("5302","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-10-30 06:25:30","2021-10-30 06:25:30","");
INSERT INTO audit_trail VALUES("5303","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-10-30 06:27:13","2021-10-30 06:27:13","1");
INSERT INTO audit_trail VALUES("5304","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-01 01:42:18","2021-11-01 01:42:18","");
INSERT INTO audit_trail VALUES("5305","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-01 01:42:48","2021-11-01 01:42:48","");
INSERT INTO audit_trail VALUES("5306","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:813","2021-11-01 01:44:23","2021-11-01 01:44:23","1");
INSERT INTO audit_trail VALUES("5307","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-01 02:28:12","2021-11-01 02:28:12","");
INSERT INTO audit_trail VALUES("5308","2","CECILIA WANJERI WANGUHU","","Added expense with id:416","2021-11-01 05:40:34","2021-11-01 05:40:34","1");
INSERT INTO audit_trail VALUES("5309","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31965","2021-11-01 05:54:03","2021-11-01 05:54:03","1");
INSERT INTO audit_trail VALUES("5310","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31969","2021-11-01 06:14:10","2021-11-01 06:14:10","1");
INSERT INTO audit_trail VALUES("5311","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:31971","2021-11-01 06:15:09","2021-11-01 06:15:09","1");
INSERT INTO audit_trail VALUES("5312","2","CECILIA WANJERI WANGUHU","","Added expense with id:417","2021-11-01 09:43:20","2021-11-01 09:43:20","1");
INSERT INTO audit_trail VALUES("5313","2","CECILIA WANJERI WANGUHU","","Added expense with id:418","2021-11-01 10:03:00","2021-11-01 10:03:00","1");
INSERT INTO audit_trail VALUES("5314","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-01 10:22:09","2021-11-01 10:22:09","1");
INSERT INTO audit_trail VALUES("5315","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-01 10:25:24","2021-11-01 10:25:24","1");
INSERT INTO audit_trail VALUES("5316","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-01 10:31:03","2021-11-01 10:31:03","1");
INSERT INTO audit_trail VALUES("5317","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-02 01:03:50","2021-11-02 01:03:50","1");
INSERT INTO audit_trail VALUES("5318","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:814","2021-11-02 01:22:56","2021-11-02 01:22:56","1");
INSERT INTO audit_trail VALUES("5319","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:815","2021-11-02 01:24:14","2021-11-02 01:24:14","1");
INSERT INTO audit_trail VALUES("5320","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-02 01:30:12","2021-11-02 01:30:12","1");
INSERT INTO audit_trail VALUES("5321","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:816","2021-11-02 01:51:24","2021-11-02 01:51:24","1");
INSERT INTO audit_trail VALUES("5322","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:817","2021-11-02 01:52:58","2021-11-02 01:52:58","1");
INSERT INTO audit_trail VALUES("5323","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:817","2021-11-02 02:01:26","2021-11-02 02:01:26","1");
INSERT INTO audit_trail VALUES("5324","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:818","2021-11-02 02:03:32","2021-11-02 02:03:32","1");
INSERT INTO audit_trail VALUES("5325","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:819","2021-11-02 02:04:13","2021-11-02 02:04:13","1");
INSERT INTO audit_trail VALUES("5326","2","CECILIA WANJERI WANGUHU","","Added expense with id:419","2021-11-02 02:05:10","2021-11-02 02:05:10","1");
INSERT INTO audit_trail VALUES("5327","1","Admin Admin","","Logged in to system","2021-11-02 03:08:37","2021-11-02 03:08:37","");
INSERT INTO audit_trail VALUES("5328","1","Admin Admin","","Logged in to system","2021-11-02 05:56:06","2021-11-02 05:56:06","");
INSERT INTO audit_trail VALUES("5329","1","Admin Admin","","Updated expense with id:416","2021-11-02 06:02:25","2021-11-02 06:02:25","1");
INSERT INTO audit_trail VALUES("5330","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32085","2021-11-02 07:20:21","2021-11-02 07:20:21","1");
INSERT INTO audit_trail VALUES("5331","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32087","2021-11-02 07:25:03","2021-11-02 07:25:03","1");
INSERT INTO audit_trail VALUES("5332","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32089","2021-11-02 07:29:20","2021-11-02 07:29:20","1");
INSERT INTO audit_trail VALUES("5333","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32091","2021-11-02 07:31:05","2021-11-02 07:31:05","1");
INSERT INTO audit_trail VALUES("5334","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32093","2021-11-02 07:32:21","2021-11-02 07:32:21","1");
INSERT INTO audit_trail VALUES("5335","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32095","2021-11-02 07:37:03","2021-11-02 07:37:03","1");
INSERT INTO audit_trail VALUES("5336","2","CECILIA WANJERI WANGUHU","","Added expense with id:420","2021-11-02 08:28:02","2021-11-02 08:28:02","1");
INSERT INTO audit_trail VALUES("5337","2","CECILIA WANJERI WANGUHU","","Added expense with id:421","2021-11-02 08:28:54","2021-11-02 08:28:54","1");
INSERT INTO audit_trail VALUES("5338","2","CECILIA WANJERI WANGUHU","","Added expense with id:422","2021-11-02 09:39:52","2021-11-02 09:39:52","1");
INSERT INTO audit_trail VALUES("5339","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-02 10:05:15","2021-11-02 10:05:15","1");
INSERT INTO audit_trail VALUES("5340","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-02 10:16:14","2021-11-02 10:16:14","");
INSERT INTO audit_trail VALUES("5341","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-03 01:25:19","2021-11-03 01:25:19","1");
INSERT INTO audit_trail VALUES("5342","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:820","2021-11-03 01:26:38","2021-11-03 01:26:38","1");
INSERT INTO audit_trail VALUES("5343","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-03 02:34:00","2021-11-03 02:34:00","1");
INSERT INTO audit_trail VALUES("5344","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:821","2021-11-03 03:09:22","2021-11-03 03:09:22","1");
INSERT INTO audit_trail VALUES("5345","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:817","2021-11-03 04:54:57","2021-11-03 04:54:57","1");
INSERT INTO audit_trail VALUES("5346","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:822","2021-11-03 04:59:03","2021-11-03 04:59:03","1");
INSERT INTO audit_trail VALUES("5347","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:823","2021-11-03 05:00:35","2021-11-03 05:00:35","1");
INSERT INTO audit_trail VALUES("5348","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32192","2021-11-03 05:14:17","2021-11-03 05:14:17","1");
INSERT INTO audit_trail VALUES("5349","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32194","2021-11-03 05:16:34","2021-11-03 05:16:34","1");
INSERT INTO audit_trail VALUES("5350","2","CECILIA WANJERI WANGUHU","","Added expense with id:423","2021-11-03 05:35:13","2021-11-03 05:35:13","1");
INSERT INTO audit_trail VALUES("5351","2","CECILIA WANJERI WANGUHU","","Added expense with id:424","2021-11-03 05:36:36","2021-11-03 05:36:36","1");
INSERT INTO audit_trail VALUES("5352","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-03 10:10:39","2021-11-03 10:10:39","1");
INSERT INTO audit_trail VALUES("5353","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-03 10:10:57","2021-11-03 10:10:57","1");
INSERT INTO audit_trail VALUES("5354","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-03 10:13:03","2021-11-03 10:13:03","1");
INSERT INTO audit_trail VALUES("5355","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-03 10:14:35","2021-11-03 10:14:35","1");
INSERT INTO audit_trail VALUES("5356","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-03 10:19:55","2021-11-03 10:19:55","1");
INSERT INTO audit_trail VALUES("5357","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-04 01:27:14","2021-11-04 01:27:14","1");
INSERT INTO audit_trail VALUES("5358","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:824","2021-11-04 01:28:37","2021-11-04 01:28:37","1");
INSERT INTO audit_trail VALUES("5359","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:825","2021-11-04 01:49:02","2021-11-04 01:49:02","1");
INSERT INTO audit_trail VALUES("5360","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:826","2021-11-04 01:51:35","2021-11-04 01:51:35","1");
INSERT INTO audit_trail VALUES("5361","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:821","2021-11-04 02:27:26","2021-11-04 02:27:26","1");
INSERT INTO audit_trail VALUES("5362","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:821","2021-11-04 02:28:15","2021-11-04 02:28:15","1");
INSERT INTO audit_trail VALUES("5363","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:826","2021-11-04 02:28:42","2021-11-04 02:28:42","1");
INSERT INTO audit_trail VALUES("5364","2","CECILIA WANJERI WANGUHU","","Added loan with id:231","2021-11-04 02:32:20","2021-11-04 02:32:20","1");
INSERT INTO audit_trail VALUES("5365","2","CECILIA WANJERI WANGUHU","","Approved loan with id:231","2021-11-04 02:32:59","2021-11-04 02:32:59","1");
INSERT INTO audit_trail VALUES("5366","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:231","2021-11-04 02:34:26","2021-11-04 02:34:26","1");
INSERT INTO audit_trail VALUES("5367","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32279","2021-11-04 02:43:22","2021-11-04 02:43:22","1");
INSERT INTO audit_trail VALUES("5368","2","CECILIA WANJERI WANGUHU","","Added loan with id:232","2021-11-04 02:46:32","2021-11-04 02:46:32","1");
INSERT INTO audit_trail VALUES("5369","2","CECILIA WANJERI WANGUHU","","Approved loan with id:232","2021-11-04 02:47:08","2021-11-04 02:47:08","1");
INSERT INTO audit_trail VALUES("5370","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:232","2021-11-04 02:49:53","2021-11-04 02:49:53","1");
INSERT INTO audit_trail VALUES("5371","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32286","2021-11-04 03:06:30","2021-11-04 03:06:30","1");
INSERT INTO audit_trail VALUES("5372","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32288","2021-11-04 03:39:11","2021-11-04 03:39:11","1");
INSERT INTO audit_trail VALUES("5373","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32290","2021-11-04 03:41:52","2021-11-04 03:41:52","1");
INSERT INTO audit_trail VALUES("5374","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-04 04:09:13","2021-11-04 04:09:13","1");
INSERT INTO audit_trail VALUES("5375","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-04 07:49:14","2021-11-04 07:49:14","");
INSERT INTO audit_trail VALUES("5376","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32310","2021-11-04 08:21:29","2021-11-04 08:21:29","1");
INSERT INTO audit_trail VALUES("5377","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-04 10:36:28","2021-11-04 10:36:28","1");
INSERT INTO audit_trail VALUES("5378","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-05 01:10:12","2021-11-05 01:10:12","1");
INSERT INTO audit_trail VALUES("5379","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:821","2021-11-05 01:17:15","2021-11-05 01:17:15","1");
INSERT INTO audit_trail VALUES("5380","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-05 01:35:31","2021-11-05 01:35:31","1");
INSERT INTO audit_trail VALUES("5381","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-05 01:51:18","2021-11-05 01:51:18","1");
INSERT INTO audit_trail VALUES("5382","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:827","2021-11-05 01:58:34","2021-11-05 01:58:34","1");
INSERT INTO audit_trail VALUES("5383","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:828","2021-11-05 02:01:31","2021-11-05 02:01:31","1");
INSERT INTO audit_trail VALUES("5384","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:826","2021-11-05 02:04:12","2021-11-05 02:04:12","1");
INSERT INTO audit_trail VALUES("5385","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32372","2021-11-05 02:06:24","2021-11-05 02:06:24","1");
INSERT INTO audit_trail VALUES("5386","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-05 10:13:41","2021-11-05 10:13:41","1");
INSERT INTO audit_trail VALUES("5387","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-06 01:06:38","2021-11-06 01:06:38","1");
INSERT INTO audit_trail VALUES("5388","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:829","2021-11-06 01:27:49","2021-11-06 01:27:49","1");
INSERT INTO audit_trail VALUES("5389","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32498","2021-11-06 01:43:28","2021-11-06 01:43:28","1");
INSERT INTO audit_trail VALUES("5390","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-06 01:47:32","2021-11-06 01:47:32","1");
INSERT INTO audit_trail VALUES("5391","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:826","2021-11-06 02:15:08","2021-11-06 02:15:08","1");
INSERT INTO audit_trail VALUES("5392","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:830","2021-11-06 02:20:24","2021-11-06 02:20:24","1");
INSERT INTO audit_trail VALUES("5393","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:829","2021-11-06 02:25:06","2021-11-06 02:25:06","1");
INSERT INTO audit_trail VALUES("5394","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:829","2021-11-06 02:26:07","2021-11-06 02:26:07","1");
INSERT INTO audit_trail VALUES("5395","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:830","2021-11-06 05:22:09","2021-11-06 05:22:09","1");
INSERT INTO audit_trail VALUES("5396","2","CECILIA WANJERI WANGUHU","","Added expense with id:425","2021-11-06 05:25:11","2021-11-06 05:25:11","1");
INSERT INTO audit_trail VALUES("5397","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-06 06:09:15","2021-11-06 06:09:15","1");
INSERT INTO audit_trail VALUES("5398","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-06 06:10:50","2021-11-06 06:10:50","");
INSERT INTO audit_trail VALUES("5399","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-06 06:12:36","2021-11-06 06:12:36","1");
INSERT INTO audit_trail VALUES("5400","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-08 00:14:51","2021-11-08 00:14:51","");
INSERT INTO audit_trail VALUES("5401","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:831","2021-11-08 00:24:43","2021-11-08 00:24:43","1");
INSERT INTO audit_trail VALUES("5402","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-08 00:54:47","2021-11-08 00:54:47","");
INSERT INTO audit_trail VALUES("5403","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:830","2021-11-08 04:11:03","2021-11-08 04:11:03","1");
INSERT INTO audit_trail VALUES("5404","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:830","2021-11-08 04:13:22","2021-11-08 04:13:22","1");
INSERT INTO audit_trail VALUES("5405","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-08 09:22:31","2021-11-08 09:22:31","1");
INSERT INTO audit_trail VALUES("5406","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-08 09:36:13","2021-11-08 09:36:13","");
INSERT INTO audit_trail VALUES("5407","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-09 00:04:14","2021-11-09 00:04:14","1");
INSERT INTO audit_trail VALUES("5408","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:832","2021-11-09 00:12:46","2021-11-09 00:12:46","1");
INSERT INTO audit_trail VALUES("5409","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-09 00:16:21","2021-11-09 00:16:21","1");
INSERT INTO audit_trail VALUES("5410","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-09 00:30:12","2021-11-09 00:30:12","1");
INSERT INTO audit_trail VALUES("5411","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-09 00:30:24","2021-11-09 00:30:24","1");
INSERT INTO audit_trail VALUES("5412","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-09 00:30:33","2021-11-09 00:30:33","1");
INSERT INTO audit_trail VALUES("5413","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32669","2021-11-09 00:36:52","2021-11-09 00:36:52","1");
INSERT INTO audit_trail VALUES("5414","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:833","2021-11-09 02:05:28","2021-11-09 02:05:28","1");
INSERT INTO audit_trail VALUES("5415","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:834","2021-11-09 02:06:25","2021-11-09 02:06:25","1");
INSERT INTO audit_trail VALUES("5416","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:834","2021-11-09 02:35:06","2021-11-09 02:35:06","1");
INSERT INTO audit_trail VALUES("5417","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32711","2021-11-09 06:49:28","2021-11-09 06:49:28","1");
INSERT INTO audit_trail VALUES("5418","2","CECILIA WANJERI WANGUHU","","Added expense with id:426","2021-11-09 08:17:35","2021-11-09 08:17:35","1");
INSERT INTO audit_trail VALUES("5419","2","CECILIA WANJERI WANGUHU","","Added expense with id:427","2021-11-09 09:49:48","2021-11-09 09:49:48","1");
INSERT INTO audit_trail VALUES("5420","2","CECILIA WANJERI WANGUHU","","Added expense with id:428","2021-11-09 09:52:07","2021-11-09 09:52:07","1");
INSERT INTO audit_trail VALUES("5421","2","CECILIA WANJERI WANGUHU","","Added expense with id:429","2021-11-09 09:53:31","2021-11-09 09:53:31","1");
INSERT INTO audit_trail VALUES("5422","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-09 10:13:37","2021-11-09 10:13:37","1");
INSERT INTO audit_trail VALUES("5423","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-10 00:22:37","2021-11-10 00:22:37","1");
INSERT INTO audit_trail VALUES("5424","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-10 00:28:22","2021-11-10 00:28:22","1");
INSERT INTO audit_trail VALUES("5425","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:835","2021-11-10 00:29:32","2021-11-10 00:29:32","1");
INSERT INTO audit_trail VALUES("5426","2","CECILIA WANJERI WANGUHU","","Updated expense with id:187","2021-11-10 06:23:14","2021-11-10 06:23:14","1");
INSERT INTO audit_trail VALUES("5427","2","CECILIA WANJERI WANGUHU","","Updated expense with id:69","2021-11-10 06:30:56","2021-11-10 06:30:56","1");
INSERT INTO audit_trail VALUES("5428","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-10 09:02:41","2021-11-10 09:02:41","");
INSERT INTO audit_trail VALUES("5429","1","Admin Admin","","Logged in to system","2021-11-10 23:01:20","2021-11-10 23:01:20","");
INSERT INTO audit_trail VALUES("5430","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:836","2021-11-11 00:20:53","2021-11-11 00:20:53","1");
INSERT INTO audit_trail VALUES("5431","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:826","2021-11-11 00:44:15","2021-11-11 00:44:15","1");
INSERT INTO audit_trail VALUES("5432","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32920","2021-11-11 01:08:33","2021-11-11 01:08:33","1");
INSERT INTO audit_trail VALUES("5433","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32923","2021-11-11 01:24:35","2021-11-11 01:24:35","1");
INSERT INTO audit_trail VALUES("5434","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32931","2021-11-11 02:29:33","2021-11-11 02:29:33","1");
INSERT INTO audit_trail VALUES("5435","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32936","2021-11-11 02:49:50","2021-11-11 02:49:50","1");
INSERT INTO audit_trail VALUES("5436","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32938","2021-11-11 02:56:30","2021-11-11 02:56:30","1");
INSERT INTO audit_trail VALUES("5437","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32940","2021-11-11 03:30:59","2021-11-11 03:30:59","1");
INSERT INTO audit_trail VALUES("5438","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32942","2021-11-11 04:04:19","2021-11-11 04:04:19","1");
INSERT INTO audit_trail VALUES("5439","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32944","2021-11-11 04:12:06","2021-11-11 04:12:06","1");
INSERT INTO audit_trail VALUES("5440","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32946","2021-11-11 04:13:11","2021-11-11 04:13:11","1");
INSERT INTO audit_trail VALUES("5441","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32948","2021-11-11 04:16:27","2021-11-11 04:16:27","1");
INSERT INTO audit_trail VALUES("5442","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32950","2021-11-11 04:17:31","2021-11-11 04:17:31","1");
INSERT INTO audit_trail VALUES("5443","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32952","2021-11-11 04:22:18","2021-11-11 04:22:18","1");
INSERT INTO audit_trail VALUES("5444","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:32954","2021-11-11 04:37:22","2021-11-11 04:37:22","1");
INSERT INTO audit_trail VALUES("5445","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-11 05:32:43","2021-11-11 05:32:43","");
INSERT INTO audit_trail VALUES("5446","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:830","2021-11-11 06:44:43","2021-11-11 06:44:43","1");
INSERT INTO audit_trail VALUES("5447","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:830","2021-11-11 06:45:37","2021-11-11 06:45:37","1");
INSERT INTO audit_trail VALUES("5448","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:830","2021-11-11 06:46:45","2021-11-11 06:46:45","1");
INSERT INTO audit_trail VALUES("5449","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:830","2021-11-11 06:47:42","2021-11-11 06:47:42","1");
INSERT INTO audit_trail VALUES("5450","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:837","2021-11-11 06:48:37","2021-11-11 06:48:37","1");
INSERT INTO audit_trail VALUES("5451","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:838","2021-11-11 06:49:37","2021-11-11 06:49:37","1");
INSERT INTO audit_trail VALUES("5452","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:839","2021-11-11 06:52:24","2021-11-11 06:52:24","1");
INSERT INTO audit_trail VALUES("5453","2","CECILIA WANJERI WANGUHU","","Added expense with id:430","2021-11-11 08:46:38","2021-11-11 08:46:38","1");
INSERT INTO audit_trail VALUES("5454","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-11 09:10:41","2021-11-11 09:10:41","1");
INSERT INTO audit_trail VALUES("5455","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-12 04:49:01","2021-11-12 04:49:01","1");
INSERT INTO audit_trail VALUES("5456","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:840","2021-11-12 04:54:19","2021-11-12 04:54:19","1");
INSERT INTO audit_trail VALUES("5457","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-12 06:58:49","2021-11-12 06:58:49","");
INSERT INTO audit_trail VALUES("5458","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:841","2021-11-12 08:04:32","2021-11-12 08:04:32","1");
INSERT INTO audit_trail VALUES("5459","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:841","2021-11-12 08:13:17","2021-11-12 08:13:17","1");
INSERT INTO audit_trail VALUES("5460","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:841","2021-11-12 08:23:25","2021-11-12 08:23:25","1");
INSERT INTO audit_trail VALUES("5461","2","CECILIA WANJERI WANGUHU","","Added expense with id:431","2021-11-12 08:33:29","2021-11-12 08:33:29","1");
INSERT INTO audit_trail VALUES("5462","2","CECILIA WANJERI WANGUHU","","Added expense with id:432","2021-11-12 08:36:13","2021-11-12 08:36:13","1");
INSERT INTO audit_trail VALUES("5463","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:841","2021-11-12 08:52:44","2021-11-12 08:52:44","1");
INSERT INTO audit_trail VALUES("5464","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:842","2021-11-12 09:18:53","2021-11-12 09:18:53","1");
INSERT INTO audit_trail VALUES("5465","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-12 10:08:26","2021-11-12 10:08:26","1");
INSERT INTO audit_trail VALUES("5466","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-13 00:31:04","2021-11-13 00:31:04","1");
INSERT INTO audit_trail VALUES("5467","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-13 01:17:13","2021-11-13 01:17:13","1");
INSERT INTO audit_trail VALUES("5468","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-13 01:17:14","2021-11-13 01:17:14","1");
INSERT INTO audit_trail VALUES("5469","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:843","2021-11-13 02:07:22","2021-11-13 02:07:22","1");
INSERT INTO audit_trail VALUES("5470","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:844","2021-11-13 02:09:38","2021-11-13 02:09:38","1");
INSERT INTO audit_trail VALUES("5471","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:845","2021-11-13 02:25:45","2021-11-13 02:25:45","1");
INSERT INTO audit_trail VALUES("5472","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:845","2021-11-13 04:18:50","2021-11-13 04:18:50","1");
INSERT INTO audit_trail VALUES("5473","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-13 06:14:50","2021-11-13 06:14:50","1");
INSERT INTO audit_trail VALUES("5474","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-13 06:20:57","2021-11-13 06:20:57","");
INSERT INTO audit_trail VALUES("5475","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-15 00:30:37","2021-11-15 00:30:37","");
INSERT INTO audit_trail VALUES("5476","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-15 00:37:53","2021-11-15 00:37:53","");
INSERT INTO audit_trail VALUES("5477","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:846","2021-11-15 00:55:53","2021-11-15 00:55:53","1");
INSERT INTO audit_trail VALUES("5478","2","CECILIA WANJERI WANGUHU","","Added expense with id:433","2021-11-15 00:57:06","2021-11-15 00:57:06","1");
INSERT INTO audit_trail VALUES("5479","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-15 01:27:32","2021-11-15 01:27:32","");
INSERT INTO audit_trail VALUES("5480","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-15 09:09:09","2021-11-15 09:09:09","1");
INSERT INTO audit_trail VALUES("5481","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-15 09:11:05","2021-11-15 09:11:05","1");
INSERT INTO audit_trail VALUES("5482","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-15 09:11:35","2021-11-15 09:11:35","1");
INSERT INTO audit_trail VALUES("5483","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-15 09:16:57","2021-11-15 09:16:57","1");
INSERT INTO audit_trail VALUES("5484","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-15 09:18:19","2021-11-15 09:18:19","1");
INSERT INTO audit_trail VALUES("5485","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-16 00:36:37","2021-11-16 00:36:37","1");
INSERT INTO audit_trail VALUES("5486","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:847","2021-11-16 00:41:00","2021-11-16 00:41:00","1");
INSERT INTO audit_trail VALUES("5487","2","CECILIA WANJERI WANGUHU","","Added expense with id:434","2021-11-16 00:43:24","2021-11-16 00:43:24","1");
INSERT INTO audit_trail VALUES("5488","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-16 00:43:53","2021-11-16 00:43:53","1");
INSERT INTO audit_trail VALUES("5489","2","CECILIA WANJERI WANGUHU","","Added expense with id:435","2021-11-16 00:45:13","2021-11-16 00:45:13","1");
INSERT INTO audit_trail VALUES("5490","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:848","2021-11-16 00:48:46","2021-11-16 00:48:46","1");
INSERT INTO audit_trail VALUES("5491","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:849","2021-11-16 00:50:38","2021-11-16 00:50:38","1");
INSERT INTO audit_trail VALUES("5492","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:850","2021-11-16 00:51:07","2021-11-16 00:51:07","1");
INSERT INTO audit_trail VALUES("5493","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:849","2021-11-16 00:53:45","2021-11-16 00:53:45","1");
INSERT INTO audit_trail VALUES("5494","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-16 01:16:07","2021-11-16 01:16:07","1");
INSERT INTO audit_trail VALUES("5495","1","Admin Admin","","Logged in to system","2021-11-16 03:43:48","2021-11-16 03:43:48","");
INSERT INTO audit_trail VALUES("5496","2","CECILIA WANJERI WANGUHU","","Added expense with id:436","2021-11-16 07:55:29","2021-11-16 07:55:29","1");
INSERT INTO audit_trail VALUES("5497","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:851","2021-11-16 07:59:29","2021-11-16 07:59:29","1");
INSERT INTO audit_trail VALUES("5498","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33456","2021-11-16 08:07:37","2021-11-16 08:07:37","1");
INSERT INTO audit_trail VALUES("5499","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-16 09:08:02","2021-11-16 09:08:02","");
INSERT INTO audit_trail VALUES("5500","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-17 00:09:54","2021-11-17 00:09:54","");
INSERT INTO audit_trail VALUES("5501","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:852","2021-11-17 00:23:34","2021-11-17 00:23:34","1");
INSERT INTO audit_trail VALUES("5502","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:853","2021-11-17 01:02:58","2021-11-17 01:02:58","1");
INSERT INTO audit_trail VALUES("5503","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:854","2021-11-17 01:04:29","2021-11-17 01:04:29","1");
INSERT INTO audit_trail VALUES("5504","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33517","2021-11-17 01:20:53","2021-11-17 01:20:53","1");
INSERT INTO audit_trail VALUES("5505","2","CECILIA WANJERI WANGUHU","","Added expense with id:437","2021-11-17 01:20:54","2021-11-17 01:20:54","1");
INSERT INTO audit_trail VALUES("5506","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33521","2021-11-17 01:22:36","2021-11-17 01:22:36","1");
INSERT INTO audit_trail VALUES("5507","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33523","2021-11-17 01:23:32","2021-11-17 01:23:32","1");
INSERT INTO audit_trail VALUES("5508","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:855","2021-11-17 03:30:35","2021-11-17 03:30:35","1");
INSERT INTO audit_trail VALUES("5509","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:856","2021-11-17 03:32:17","2021-11-17 03:32:17","1");
INSERT INTO audit_trail VALUES("5510","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:857","2021-11-17 03:36:19","2021-11-17 03:36:19","1");
INSERT INTO audit_trail VALUES("5511","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-17 09:34:02","2021-11-17 09:34:02","1");
INSERT INTO audit_trail VALUES("5512","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 00:13:05","2021-11-18 00:13:05","1");
INSERT INTO audit_trail VALUES("5513","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 00:29:52","2021-11-18 00:29:52","1");
INSERT INTO audit_trail VALUES("5514","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:858","2021-11-18 00:31:21","2021-11-18 00:31:21","1");
INSERT INTO audit_trail VALUES("5515","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:859","2021-11-18 03:54:21","2021-11-18 03:54:21","1");
INSERT INTO audit_trail VALUES("5516","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:860","2021-11-18 04:01:35","2021-11-18 04:01:35","1");
INSERT INTO audit_trail VALUES("5517","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 07:11:55","2021-11-18 07:11:55","");
INSERT INTO audit_trail VALUES("5518","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 07:11:58","2021-11-18 07:11:58","1");
INSERT INTO audit_trail VALUES("5519","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 07:12:00","2021-11-18 07:12:00","1");
INSERT INTO audit_trail VALUES("5520","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 07:12:00","2021-11-18 07:12:00","1");
INSERT INTO audit_trail VALUES("5521","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 07:12:02","2021-11-18 07:12:02","1");
INSERT INTO audit_trail VALUES("5522","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 07:12:05","2021-11-18 07:12:05","1");
INSERT INTO audit_trail VALUES("5523","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 07:12:07","2021-11-18 07:12:07","1");
INSERT INTO audit_trail VALUES("5524","2","CECILIA WANJERI WANGUHU","","Added expense with id:438","2021-11-18 08:26:42","2021-11-18 08:26:42","1");
INSERT INTO audit_trail VALUES("5525","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-18 09:28:46","2021-11-18 09:28:46","1");
INSERT INTO audit_trail VALUES("5526","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-18 09:29:57","2021-11-18 09:29:57","1");
INSERT INTO audit_trail VALUES("5527","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-18 09:30:20","2021-11-18 09:30:20","1");
INSERT INTO audit_trail VALUES("5528","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-19 00:09:56","2021-11-19 00:09:56","1");
INSERT INTO audit_trail VALUES("5529","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-19 00:27:37","2021-11-19 00:27:37","1");
INSERT INTO audit_trail VALUES("5530","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-19 00:27:40","2021-11-19 00:27:40","1");
INSERT INTO audit_trail VALUES("5531","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:861","2021-11-19 00:32:02","2021-11-19 00:32:02","1");
INSERT INTO audit_trail VALUES("5532","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:862","2021-11-19 00:40:03","2021-11-19 00:40:03","1");
INSERT INTO audit_trail VALUES("5533","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:862","2021-11-19 00:41:55","2021-11-19 00:41:55","1");
INSERT INTO audit_trail VALUES("5534","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:863","2021-11-19 00:47:37","2021-11-19 00:47:37","1");
INSERT INTO audit_trail VALUES("5535","2","CECILIA WANJERI WANGUHU","","Added expense with id:439","2021-11-19 01:12:56","2021-11-19 01:12:56","1");
INSERT INTO audit_trail VALUES("5536","1","Admin Admin","","Logged in to system","2021-11-19 03:35:05","2021-11-19 03:35:05","");
INSERT INTO audit_trail VALUES("5537","1","Admin Admin","","Logged in to system","2021-11-19 03:48:31","2021-11-19 03:48:31","");
INSERT INTO audit_trail VALUES("5538","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-19 06:17:17","2021-11-19 06:17:17","");
INSERT INTO audit_trail VALUES("5539","2","CECILIA WANJERI WANGUHU","","Added expense with id:440","2021-11-19 07:42:44","2021-11-19 07:42:44","1");
INSERT INTO audit_trail VALUES("5540","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:864","2021-11-19 08:23:19","2021-11-19 08:23:19","1");
INSERT INTO audit_trail VALUES("5541","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-19 09:44:39","2021-11-19 09:44:39","1");
INSERT INTO audit_trail VALUES("5542","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-20 00:06:50","2021-11-20 00:06:50","1");
INSERT INTO audit_trail VALUES("5543","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-20 00:20:03","2021-11-20 00:20:03","1");
INSERT INTO audit_trail VALUES("5544","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:865","2021-11-20 00:21:38","2021-11-20 00:21:38","1");
INSERT INTO audit_trail VALUES("5545","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:866","2021-11-20 01:30:08","2021-11-20 01:30:08","1");
INSERT INTO audit_trail VALUES("5546","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:867","2021-11-20 01:36:31","2021-11-20 01:36:31","1");
INSERT INTO audit_trail VALUES("5547","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33856","2021-11-20 03:01:30","2021-11-20 03:01:30","1");
INSERT INTO audit_trail VALUES("5548","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-20 05:37:28","2021-11-20 05:37:28","1");
INSERT INTO audit_trail VALUES("5549","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-22 00:05:37","2021-11-22 00:05:37","");
INSERT INTO audit_trail VALUES("5550","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-22 00:16:06","2021-11-22 00:16:06","");
INSERT INTO audit_trail VALUES("5551","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:868","2021-11-22 00:17:30","2021-11-22 00:17:30","1");
INSERT INTO audit_trail VALUES("5552","2","CECILIA WANJERI WANGUHU","","Added expense with id:441","2021-11-22 01:28:08","2021-11-22 01:28:08","1");
INSERT INTO audit_trail VALUES("5553","2","CECILIA WANJERI WANGUHU","","Added loan with id:233","2021-11-22 02:37:37","2021-11-22 02:37:37","1");
INSERT INTO audit_trail VALUES("5554","2","CECILIA WANJERI WANGUHU","","Approved loan with id:233","2021-11-22 02:38:12","2021-11-22 02:38:12","1");
INSERT INTO audit_trail VALUES("5555","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:233","2021-11-22 02:38:36","2021-11-22 02:38:36","1");
INSERT INTO audit_trail VALUES("5556","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33936","2021-11-22 02:45:09","2021-11-22 02:45:09","1");
INSERT INTO audit_trail VALUES("5557","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33945","2021-11-22 02:51:15","2021-11-22 02:51:15","1");
INSERT INTO audit_trail VALUES("5558","2","CECILIA WANJERI WANGUHU","","Added loan with id:234","2021-11-22 02:53:51","2021-11-22 02:53:51","1");
INSERT INTO audit_trail VALUES("5559","2","CECILIA WANJERI WANGUHU","","Declined loan with id:234","2021-11-22 02:55:15","2021-11-22 02:55:15","1");
INSERT INTO audit_trail VALUES("5560","2","CECILIA WANJERI WANGUHU","","Added loan with id:235","2021-11-22 02:57:57","2021-11-22 02:57:57","1");
INSERT INTO audit_trail VALUES("5561","2","CECILIA WANJERI WANGUHU","","Approved loan with id:235","2021-11-22 02:58:55","2021-11-22 02:58:55","1");
INSERT INTO audit_trail VALUES("5562","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:235","2021-11-22 03:03:14","2021-11-22 03:03:14","1");
INSERT INTO audit_trail VALUES("5563","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33953","2021-11-22 03:08:07","2021-11-22 03:08:07","1");
INSERT INTO audit_trail VALUES("5564","2","CECILIA WANJERI WANGUHU","","Added loan with id:236","2021-11-22 03:09:50","2021-11-22 03:09:50","1");
INSERT INTO audit_trail VALUES("5565","2","CECILIA WANJERI WANGUHU","","Approved loan with id:236","2021-11-22 03:10:19","2021-11-22 03:10:19","1");
INSERT INTO audit_trail VALUES("5566","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:236","2021-11-22 03:11:24","2021-11-22 03:11:24","1");
INSERT INTO audit_trail VALUES("5567","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:33959","2021-11-22 03:15:44","2021-11-22 03:15:44","1");
INSERT INTO audit_trail VALUES("5568","1","Admin Admin","","Logged in to system","2021-11-22 06:08:37","2021-11-22 06:08:37","");
INSERT INTO audit_trail VALUES("5569","2","CECILIA WANJERI WANGUHU","","Added expense with id:442","2021-11-22 06:30:19","2021-11-22 06:30:19","1");
INSERT INTO audit_trail VALUES("5570","2","CECILIA WANJERI WANGUHU","","Added loan with id:237","2021-11-22 07:06:01","2021-11-22 07:06:01","1");
INSERT INTO audit_trail VALUES("5571","2","CECILIA WANJERI WANGUHU","","Approved loan with id:237","2021-11-22 07:06:35","2021-11-22 07:06:35","1");
INSERT INTO audit_trail VALUES("5572","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:237","2021-11-22 07:06:57","2021-11-22 07:06:57","1");
INSERT INTO audit_trail VALUES("5573","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34003","2021-11-22 07:30:00","2021-11-22 07:30:00","1");
INSERT INTO audit_trail VALUES("5574","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34005","2021-11-22 07:31:48","2021-11-22 07:31:48","1");
INSERT INTO audit_trail VALUES("5575","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34011","2021-11-22 07:45:52","2021-11-22 07:45:52","1");
INSERT INTO audit_trail VALUES("5576","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-22 09:14:44","2021-11-22 09:14:44","1");
INSERT INTO audit_trail VALUES("5577","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-23 00:14:46","2021-11-23 00:14:46","1");
INSERT INTO audit_trail VALUES("5578","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:869","2021-11-23 00:16:11","2021-11-23 00:16:11","1");
INSERT INTO audit_trail VALUES("5579","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-23 00:40:40","2021-11-23 00:40:40","1");
INSERT INTO audit_trail VALUES("5580","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:642","2021-11-23 00:57:10","2021-11-23 00:57:10","1");
INSERT INTO audit_trail VALUES("5581","2","CECILIA WANJERI WANGUHU","","Added expense with id:443","2021-11-23 02:10:57","2021-11-23 02:10:57","1");
INSERT INTO audit_trail VALUES("5582","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:870","2021-11-23 07:33:02","2021-11-23 07:33:02","1");
INSERT INTO audit_trail VALUES("5583","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:871","2021-11-23 07:34:44","2021-11-23 07:34:44","1");
INSERT INTO audit_trail VALUES("5584","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:870","2021-11-23 07:37:08","2021-11-23 07:37:08","1");
INSERT INTO audit_trail VALUES("5585","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:871","2021-11-23 07:37:41","2021-11-23 07:37:41","1");
INSERT INTO audit_trail VALUES("5586","2","CECILIA WANJERI WANGUHU","","Added expense with id:444","2021-11-23 09:21:04","2021-11-23 09:21:04","1");
INSERT INTO audit_trail VALUES("5587","2","CECILIA WANJERI WANGUHU","","Added expense with id:445","2021-11-23 09:22:08","2021-11-23 09:22:08","1");
INSERT INTO audit_trail VALUES("5588","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-23 09:33:59","2021-11-23 09:33:59","1");
INSERT INTO audit_trail VALUES("5589","1","Admin Admin","","Logged in to system","2021-11-23 10:22:25","2021-11-23 10:22:25","");
INSERT INTO audit_trail VALUES("5590","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-24 00:09:15","2021-11-24 00:09:15","1");
INSERT INTO audit_trail VALUES("5591","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:872","2021-11-24 00:10:52","2021-11-24 00:10:52","1");
INSERT INTO audit_trail VALUES("5592","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-24 00:12:56","2021-11-24 00:12:56","1");
INSERT INTO audit_trail VALUES("5593","2","CECILIA WANJERI WANGUHU","","Added loan with id:238","2021-11-24 00:49:02","2021-11-24 00:49:02","1");
INSERT INTO audit_trail VALUES("5594","2","CECILIA WANJERI WANGUHU","","Approved loan with id:238","2021-11-24 00:49:28","2021-11-24 00:49:28","1");
INSERT INTO audit_trail VALUES("5595","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:238","2021-11-24 00:51:34","2021-11-24 00:51:34","1");
INSERT INTO audit_trail VALUES("5596","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:873","2021-11-24 02:17:28","2021-11-24 02:17:28","1");
INSERT INTO audit_trail VALUES("5597","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:874","2021-11-24 02:18:32","2021-11-24 02:18:32","1");
INSERT INTO audit_trail VALUES("5598","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:875","2021-11-24 02:19:54","2021-11-24 02:19:54","1");
INSERT INTO audit_trail VALUES("5599","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:876","2021-11-24 02:20:42","2021-11-24 02:20:42","1");
INSERT INTO audit_trail VALUES("5600","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:877","2021-11-24 04:03:58","2021-11-24 04:03:58","1");
INSERT INTO audit_trail VALUES("5601","2","CECILIA WANJERI WANGUHU","","Added expense with id:446","2021-11-24 08:32:53","2021-11-24 08:32:53","1");
INSERT INTO audit_trail VALUES("5602","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-24 09:18:53","2021-11-24 09:18:53","1");
INSERT INTO audit_trail VALUES("5603","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-24 09:24:04","2021-11-24 09:24:04","");
INSERT INTO audit_trail VALUES("5604","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-24 09:26:06","2021-11-24 09:26:06","1");
INSERT INTO audit_trail VALUES("5605","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-25 00:11:59","2021-11-25 00:11:59","1");
INSERT INTO audit_trail VALUES("5606","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:878","2021-11-25 00:19:32","2021-11-25 00:19:32","1");
INSERT INTO audit_trail VALUES("5607","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:879","2021-11-25 01:25:00","2021-11-25 01:25:00","1");
INSERT INTO audit_trail VALUES("5608","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:880","2021-11-25 01:26:03","2021-11-25 01:26:03","1");
INSERT INTO audit_trail VALUES("5609","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-25 02:59:18","2021-11-25 02:59:18","1");
INSERT INTO audit_trail VALUES("5610","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34283","2021-11-25 04:12:21","2021-11-25 04:12:21","1");
INSERT INTO audit_trail VALUES("5611","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-25 07:13:49","2021-11-25 07:13:49","");
INSERT INTO audit_trail VALUES("5612","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-25 09:16:38","2021-11-25 09:16:38","1");
INSERT INTO audit_trail VALUES("5613","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-26 00:17:11","2021-11-26 00:17:11","1");
INSERT INTO audit_trail VALUES("5614","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:881","2021-11-26 00:24:25","2021-11-26 00:24:25","1");
INSERT INTO audit_trail VALUES("5615","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-26 00:37:34","2021-11-26 00:37:34","1");
INSERT INTO audit_trail VALUES("5616","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34353","2021-11-26 01:50:09","2021-11-26 01:50:09","1");
INSERT INTO audit_trail VALUES("5617","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:882","2021-11-26 03:04:53","2021-11-26 03:04:53","1");
INSERT INTO audit_trail VALUES("5618","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:883","2021-11-26 03:05:27","2021-11-26 03:05:27","1");
INSERT INTO audit_trail VALUES("5619","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:884","2021-11-26 03:09:07","2021-11-26 03:09:07","1");
INSERT INTO audit_trail VALUES("5620","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:884","2021-11-26 03:09:59","2021-11-26 03:09:59","1");
INSERT INTO audit_trail VALUES("5621","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:885","2021-11-26 03:10:46","2021-11-26 03:10:46","1");
INSERT INTO audit_trail VALUES("5622","2","CECILIA WANJERI WANGUHU","","Added expense with id:447","2021-11-26 03:46:51","2021-11-26 03:46:51","1");
INSERT INTO audit_trail VALUES("5623","2","CECILIA WANJERI WANGUHU","","Added expense with id:448","2021-11-26 04:04:52","2021-11-26 04:04:52","1");
INSERT INTO audit_trail VALUES("5624","2","CECILIA WANJERI WANGUHU","","Added expense with id:449","2021-11-26 06:15:03","2021-11-26 06:15:03","1");
INSERT INTO audit_trail VALUES("5625","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-26 09:07:02","2021-11-26 09:07:02","1");
INSERT INTO audit_trail VALUES("5626","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-27 00:28:00","2021-11-27 00:28:00","1");
INSERT INTO audit_trail VALUES("5627","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-27 00:40:51","2021-11-27 00:40:51","");
INSERT INTO audit_trail VALUES("5628","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:886","2021-11-27 00:42:00","2021-11-27 00:42:00","1");
INSERT INTO audit_trail VALUES("5629","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-27 01:02:56","2021-11-27 01:02:56","1");
INSERT INTO audit_trail VALUES("5630","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-27 01:09:37","2021-11-27 01:09:37","1");
INSERT INTO audit_trail VALUES("5631","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:887","2021-11-27 03:45:13","2021-11-27 03:45:13","1");
INSERT INTO audit_trail VALUES("5632","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:888","2021-11-27 03:46:00","2021-11-27 03:46:00","1");
INSERT INTO audit_trail VALUES("5633","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:889","2021-11-27 03:46:52","2021-11-27 03:46:52","1");
INSERT INTO audit_trail VALUES("5634","2","CECILIA WANJERI WANGUHU","","Added expense with id:450","2021-11-27 04:53:40","2021-11-27 04:53:40","1");
INSERT INTO audit_trail VALUES("5635","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-27 05:07:16","2021-11-27 05:07:16","1");
INSERT INTO audit_trail VALUES("5636","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-29 00:20:29","2021-11-29 00:20:29","");
INSERT INTO audit_trail VALUES("5637","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-29 00:21:36","2021-11-29 00:21:36","");
INSERT INTO audit_trail VALUES("5638","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:890","2021-11-29 00:36:29","2021-11-29 00:36:29","1");
INSERT INTO audit_trail VALUES("5639","2","CECILIA WANJERI WANGUHU","","Added loan with id:239","2021-11-29 07:15:04","2021-11-29 07:15:04","1");
INSERT INTO audit_trail VALUES("5640","2","CECILIA WANJERI WANGUHU","","Approved loan with id:239","2021-11-29 07:15:36","2021-11-29 07:15:36","1");
INSERT INTO audit_trail VALUES("5641","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:239","2021-11-29 07:16:51","2021-11-29 07:16:51","1");
INSERT INTO audit_trail VALUES("5642","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:239","2021-11-29 07:25:50","2021-11-29 07:25:50","1");
INSERT INTO audit_trail VALUES("5643","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:239","2021-11-29 07:26:00","2021-11-29 07:26:00","1");
INSERT INTO audit_trail VALUES("5644","2","CECILIA WANJERI WANGUHU","","Declined loan with id:239","2021-11-29 07:26:40","2021-11-29 07:26:40","1");
INSERT INTO audit_trail VALUES("5645","2","CECILIA WANJERI WANGUHU","","Added loan with id:240","2021-11-29 07:29:30","2021-11-29 07:29:30","1");
INSERT INTO audit_trail VALUES("5646","2","CECILIA WANJERI WANGUHU","","Approved loan with id:240","2021-11-29 07:30:01","2021-11-29 07:30:01","1");
INSERT INTO audit_trail VALUES("5647","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:240","2021-11-29 07:30:28","2021-11-29 07:30:28","1");
INSERT INTO audit_trail VALUES("5648","2","CECILIA WANJERI WANGUHU","","Updated loan with id:240","2021-11-29 07:42:43","2021-11-29 07:42:43","1");
INSERT INTO audit_trail VALUES("5649","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:240","2021-11-29 07:43:21","2021-11-29 07:43:21","1");
INSERT INTO audit_trail VALUES("5650","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:240","2021-11-29 07:46:09","2021-11-29 07:46:09","1");
INSERT INTO audit_trail VALUES("5651","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34710","2021-11-29 07:55:28","2021-11-29 07:55:28","1");
INSERT INTO audit_trail VALUES("5652","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34747","2021-11-29 08:29:07","2021-11-29 08:29:07","1");
INSERT INTO audit_trail VALUES("5653","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34750","2021-11-29 09:02:18","2021-11-29 09:02:18","1");
INSERT INTO audit_trail VALUES("5654","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34756","2021-11-29 09:38:09","2021-11-29 09:38:09","1");
INSERT INTO audit_trail VALUES("5655","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34758","2021-11-29 09:55:11","2021-11-29 09:55:11","1");
INSERT INTO audit_trail VALUES("5656","1","Admin Admin","","Logged in to system","2021-11-29 10:04:34","2021-11-29 10:04:34","");
INSERT INTO audit_trail VALUES("5657","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-11-29 10:58:39","2021-11-29 10:58:39","1");
INSERT INTO audit_trail VALUES("5658","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-29 11:04:58","2021-11-29 11:04:58","");
INSERT INTO audit_trail VALUES("5659","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-30 00:13:01","2021-11-30 00:13:01","1");
INSERT INTO audit_trail VALUES("5660","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-30 00:14:05","2021-11-30 00:14:05","1");
INSERT INTO audit_trail VALUES("5661","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:891","2021-11-30 00:14:38","2021-11-30 00:14:38","1");
INSERT INTO audit_trail VALUES("5662","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:892","2021-11-30 01:43:49","2021-11-30 01:43:49","1");
INSERT INTO audit_trail VALUES("5663","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:893","2021-11-30 01:45:08","2021-11-30 01:45:08","1");
INSERT INTO audit_trail VALUES("5664","2","CECILIA WANJERI WANGUHU","","Added expense with id:451","2021-11-30 09:16:36","2021-11-30 09:16:36","1");
INSERT INTO audit_trail VALUES("5665","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-11-30 09:58:44","2021-11-30 09:58:44","");
INSERT INTO audit_trail VALUES("5666","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-12-01 00:02:32","2021-12-01 00:02:32","1");
INSERT INTO audit_trail VALUES("5667","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:894","2021-12-01 00:12:45","2021-12-01 00:12:45","1");
INSERT INTO audit_trail VALUES("5668","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34875","2021-12-01 01:33:27","2021-12-01 01:33:27","1");
INSERT INTO audit_trail VALUES("5669","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34877","2021-12-01 01:38:06","2021-12-01 01:38:06","1");
INSERT INTO audit_trail VALUES("5670","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34881","2021-12-01 01:44:15","2021-12-01 01:44:15","1");
INSERT INTO audit_trail VALUES("5671","1","Admin Admin","","Logged in to system","2021-12-01 02:27:39","2021-12-01 02:27:39","");
INSERT INTO audit_trail VALUES("5672","1","Admin Admin","","Deleted user with id:4","2021-12-01 02:29:36","2021-12-01 02:29:36","1");
INSERT INTO audit_trail VALUES("5673","1","Admin Admin","","Deleted user with id:5","2021-12-01 02:30:11","2021-12-01 02:30:11","1");
INSERT INTO audit_trail VALUES("5674","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34883","2021-12-01 02:38:36","2021-12-01 02:38:36","1");
INSERT INTO audit_trail VALUES("5675","1","Admin Admin","","Deleted user with id:3","2021-12-01 07:29:55","2021-12-01 07:29:55","1");
INSERT INTO audit_trail VALUES("5676","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:34930","2021-12-01 08:05:29","2021-12-01 08:05:29","1");
INSERT INTO audit_trail VALUES("5677","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-12-01 09:32:35","2021-12-01 09:32:35","1");
INSERT INTO audit_trail VALUES("5678","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-12-01 10:28:55","2021-12-01 10:28:55","1");
INSERT INTO audit_trail VALUES("5679","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-12-02 00:12:55","2021-12-02 00:12:55","1");
INSERT INTO audit_trail VALUES("5680","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:895","2021-12-02 00:25:52","2021-12-02 00:25:52","1");
INSERT INTO audit_trail VALUES("5681","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-12-02 00:54:53","2021-12-02 00:54:53","1");
INSERT INTO audit_trail VALUES("5682","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:896","2021-12-02 02:54:47","2021-12-02 02:54:47","1");
INSERT INTO audit_trail VALUES("5683","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:897","2021-12-02 02:55:36","2021-12-02 02:55:36","1");
INSERT INTO audit_trail VALUES("5684","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:898","2021-12-02 03:09:11","2021-12-02 03:09:11","1");
INSERT INTO audit_trail VALUES("5685","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:899","2021-12-02 03:17:03","2021-12-02 03:17:03","1");
INSERT INTO audit_trail VALUES("5686","1","Admin Admin","","Logged in to system","2021-12-02 06:43:48","2021-12-02 06:43:48","");
INSERT INTO audit_trail VALUES("5687","1","Admin Admin","","Added user with id:6","2021-12-02 06:46:29","2021-12-02 06:46:29","1");
INSERT INTO audit_trail VALUES("5688","2","CECILIA WANJERI WANGUHU","","Logged out of system","2021-12-02 06:47:36","2021-12-02 06:47:36","1");
INSERT INTO audit_trail VALUES("5689","1","Admin Admin","","Logged out of system","2021-12-02 06:51:40","2021-12-02 06:51:40","1");
INSERT INTO audit_trail VALUES("5690","6","Gilbert Githitu","","Logged in to system","2021-12-02 06:51:56","2021-12-02 06:51:56","1");
INSERT INTO audit_trail VALUES("5691","6","Gilbert Githitu","","Logged in to system","2021-12-02 06:52:08","2021-12-02 06:52:08","1");
INSERT INTO audit_trail VALUES("5692","6","Gilbert Githitu","","Added expense with id:452","2021-12-02 07:12:54","2021-12-02 07:12:54","1");
INSERT INTO audit_trail VALUES("5693","6","Gilbert Githitu","","Added expense with id:453","2021-12-02 07:14:30","2021-12-02 07:14:30","1");
INSERT INTO audit_trail VALUES("5694","6","Gilbert Githitu","","Updated expense with id:453","2021-12-02 07:15:09","2021-12-02 07:15:09","1");
INSERT INTO audit_trail VALUES("5695","6","Gilbert Githitu","","Added expense with id:454","2021-12-02 07:18:41","2021-12-02 07:18:41","1");
INSERT INTO audit_trail VALUES("5696","6","Gilbert Githitu","","Added expense with id:455","2021-12-02 08:50:03","2021-12-02 08:50:03","1");
INSERT INTO audit_trail VALUES("5697","6","Gilbert Githitu","","Updated expense with id:455","2021-12-02 08:51:06","2021-12-02 08:51:06","1");
INSERT INTO audit_trail VALUES("5698","6","Gilbert Githitu","","Logged in to system","2021-12-02 08:52:30","2021-12-02 08:52:30","1");
INSERT INTO audit_trail VALUES("5699","6","Gilbert Githitu","","Logged in to system","2021-12-02 09:46:31","2021-12-02 09:46:31","");
INSERT INTO audit_trail VALUES("5700","6","Gilbert Githitu","","Added Capital  with id:900","2021-12-03 00:24:56","2021-12-03 00:24:56","1");
INSERT INTO audit_trail VALUES("5701","6","Gilbert Githitu","","Added Capital  with id:901","2021-12-03 04:20:29","2021-12-03 04:20:29","1");
INSERT INTO audit_trail VALUES("5702","6","Gilbert Githitu","","Added Capital  with id:902","2021-12-03 04:21:35","2021-12-03 04:21:35","1");
INSERT INTO audit_trail VALUES("5703","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35105","2021-12-03 09:05:17","2021-12-03 09:05:17","1");
INSERT INTO audit_trail VALUES("5704","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35108","2021-12-03 09:16:14","2021-12-03 09:16:14","1");
INSERT INTO audit_trail VALUES("5705","1","Admin Admin","","Logged in to system","2021-12-03 09:21:59","2021-12-03 09:21:59","");
INSERT INTO audit_trail VALUES("5706","6","Gilbert Githitu","","Logged in to system","2021-12-03 10:35:04","2021-12-03 10:35:04","");
INSERT INTO audit_trail VALUES("5707","6","Gilbert Githitu","","Added Capital  with id:903","2021-12-04 00:10:15","2021-12-04 00:10:15","1");
INSERT INTO audit_trail VALUES("5708","6","Gilbert Githitu","","Added Capital  with id:904","2021-12-04 01:20:53","2021-12-04 01:20:53","1");
INSERT INTO audit_trail VALUES("5709","6","Gilbert Githitu","","Added Capital  with id:905","2021-12-04 01:22:21","2021-12-04 01:22:21","1");
INSERT INTO audit_trail VALUES("5710","6","Gilbert Githitu","","Added Capital  with id:906","2021-12-04 01:41:16","2021-12-04 01:41:16","1");
INSERT INTO audit_trail VALUES("5711","6","Gilbert Githitu","","Added expense with id:456","2021-12-04 02:08:39","2021-12-04 02:08:39","1");
INSERT INTO audit_trail VALUES("5712","6","Gilbert Githitu","","Logged out of system","2021-12-04 05:27:42","2021-12-04 05:27:42","1");
INSERT INTO audit_trail VALUES("5713","6","Gilbert Githitu","","Logged in to system","2021-12-06 00:19:35","2021-12-06 00:19:35","");
INSERT INTO audit_trail VALUES("5714","6","Gilbert Githitu","","Added Capital  with id:907","2021-12-06 00:21:57","2021-12-06 00:21:57","1");
INSERT INTO audit_trail VALUES("5715","6","Gilbert Githitu","","Logged in to system","2021-12-06 01:06:44","2021-12-06 01:06:44","");
INSERT INTO audit_trail VALUES("5716","6","Gilbert Githitu","","Added expense with id:457","2021-12-06 01:42:04","2021-12-06 01:42:04","1");
INSERT INTO audit_trail VALUES("5717","6","Gilbert Githitu","","Added Capital  with id:908","2021-12-06 01:44:00","2021-12-06 01:44:00","1");
INSERT INTO audit_trail VALUES("5718","6","Gilbert Githitu","","Added Capital  with id:909","2021-12-06 01:45:27","2021-12-06 01:45:27","1");
INSERT INTO audit_trail VALUES("5719","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35187","2021-12-06 03:46:28","2021-12-06 03:46:28","1");
INSERT INTO audit_trail VALUES("5720","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35189","2021-12-06 04:08:42","2021-12-06 04:08:42","1");
INSERT INTO audit_trail VALUES("5721","6","Gilbert Githitu","","Logged in to system","2021-12-06 09:19:59","2021-12-06 09:19:59","");
INSERT INTO audit_trail VALUES("5722","6","Gilbert Githitu","","Added Capital  with id:910","2021-12-07 00:24:36","2021-12-07 00:24:36","1");
INSERT INTO audit_trail VALUES("5723","6","Gilbert Githitu","","Added Capital  with id:911","2021-12-07 02:29:52","2021-12-07 02:29:52","1");
INSERT INTO audit_trail VALUES("5724","6","Gilbert Githitu","","Added Capital  with id:912","2021-12-07 02:39:37","2021-12-07 02:39:37","1");
INSERT INTO audit_trail VALUES("5725","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35246","2021-12-07 03:12:06","2021-12-07 03:12:06","1");
INSERT INTO audit_trail VALUES("5726","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35250","2021-12-07 04:11:47","2021-12-07 04:11:47","1");
INSERT INTO audit_trail VALUES("5727","6","Gilbert Githitu","","Added expense with id:458","2021-12-07 06:52:26","2021-12-07 06:52:26","1");
INSERT INTO audit_trail VALUES("5728","6","Gilbert Githitu","","Logged in to system","2021-12-07 10:22:16","2021-12-07 10:22:16","");
INSERT INTO audit_trail VALUES("5729","6","Gilbert Githitu","","Added Capital  with id:913","2021-12-08 00:42:17","2021-12-08 00:42:17","1");
INSERT INTO audit_trail VALUES("5730","6","Gilbert Githitu","","Added Capital  with id:914","2021-12-08 02:42:18","2021-12-08 02:42:18","1");
INSERT INTO audit_trail VALUES("5731","6","Gilbert Githitu","","Added Capital  with id:915","2021-12-08 02:43:51","2021-12-08 02:43:51","1");
INSERT INTO audit_trail VALUES("5732","6","Gilbert Githitu","","Added Capital  with id:916","2021-12-08 02:44:39","2021-12-08 02:44:39","1");
INSERT INTO audit_trail VALUES("5733","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35317","2021-12-08 05:07:23","2021-12-08 05:07:23","1");
INSERT INTO audit_trail VALUES("5734","6","Gilbert Githitu","","Added loan with id:241","2021-12-08 07:04:04","2021-12-08 07:04:04","1");
INSERT INTO audit_trail VALUES("5735","6","Gilbert Githitu","","Approved loan with id:241","2021-12-08 07:04:36","2021-12-08 07:04:36","1");
INSERT INTO audit_trail VALUES("5736","6","Gilbert Githitu","","Disbursed loan with id:241","2021-12-08 07:06:11","2021-12-08 07:06:11","1");
INSERT INTO audit_trail VALUES("5737","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35338","2021-12-08 07:19:38","2021-12-08 07:19:38","1");
INSERT INTO audit_trail VALUES("5738","6","Gilbert Githitu","","Added expense with id:459","2021-12-08 07:54:30","2021-12-08 07:54:30","1");
INSERT INTO audit_trail VALUES("5739","6","Gilbert Githitu","","Logged in to system","2021-12-08 09:51:00","2021-12-08 09:51:00","");
INSERT INTO audit_trail VALUES("5740","6","Gilbert Githitu","","Added Capital  with id:917","2021-12-09 00:29:26","2021-12-09 00:29:26","1");
INSERT INTO audit_trail VALUES("5741","6","Gilbert Githitu","","Added expense with id:460","2021-12-09 00:31:08","2021-12-09 00:31:08","1");
INSERT INTO audit_trail VALUES("5742","6","Gilbert Githitu","","Added expense with id:461","2021-12-09 00:39:23","2021-12-09 00:39:23","1");
INSERT INTO audit_trail VALUES("5743","6","Gilbert Githitu","","Added expense with id:462","2021-12-09 00:41:42","2021-12-09 00:41:42","1");
INSERT INTO audit_trail VALUES("5744","6","Gilbert Githitu","","Updated expense with id:460","2021-12-09 00:42:25","2021-12-09 00:42:25","1");
INSERT INTO audit_trail VALUES("5745","6","Gilbert Githitu","","Updated expense with id:460","2021-12-09 00:44:36","2021-12-09 00:44:36","1");
INSERT INTO audit_trail VALUES("5746","6","Gilbert Githitu","","Added Capital  with id:918","2021-12-09 02:24:03","2021-12-09 02:24:03","1");
INSERT INTO audit_trail VALUES("5747","6","Gilbert Githitu","","Added Capital  with id:919","2021-12-09 02:25:59","2021-12-09 02:25:59","1");
INSERT INTO audit_trail VALUES("5748","6","Gilbert Githitu","","Added Capital  with id:920","2021-12-09 02:27:46","2021-12-09 02:27:46","1");
INSERT INTO audit_trail VALUES("5749","6","Gilbert Githitu","","Added expense with id:463","2021-12-09 09:14:42","2021-12-09 09:14:42","1");
INSERT INTO audit_trail VALUES("5750","6","Gilbert Githitu","","Added Capital  with id:921","2021-12-10 00:28:42","2021-12-10 00:28:42","1");
INSERT INTO audit_trail VALUES("5751","6","Gilbert Githitu","","Added Capital  with id:922","2021-12-10 01:34:17","2021-12-10 01:34:17","1");
INSERT INTO audit_trail VALUES("5752","6","Gilbert Githitu","","Added Capital  with id:923","2021-12-10 01:46:55","2021-12-10 01:46:55","1");
INSERT INTO audit_trail VALUES("5753","6","Gilbert Githitu","","Added expense with id:464","2021-12-10 09:12:25","2021-12-10 09:12:25","1");
INSERT INTO audit_trail VALUES("5754","6","Gilbert Githitu","","Logged in to system","2021-12-10 10:55:00","2021-12-10 10:55:00","");
INSERT INTO audit_trail VALUES("5755","6","Gilbert Githitu","","Logged out of system","2021-12-10 23:49:58","2021-12-10 23:49:58","1");
INSERT INTO audit_trail VALUES("5756","6","Gilbert Githitu","","Logged in to system","2021-12-10 23:53:34","2021-12-10 23:53:34","1");
INSERT INTO audit_trail VALUES("5757","6","Gilbert Githitu","","Added Capital  with id:924","2021-12-10 23:55:58","2021-12-10 23:55:58","1");
INSERT INTO audit_trail VALUES("5758","6","Gilbert Githitu","","Logged in to system","2021-12-11 01:48:12","2021-12-11 01:48:12","1");
INSERT INTO audit_trail VALUES("5759","6","Gilbert Githitu","","Added expense with id:465","2021-12-11 02:55:21","2021-12-11 02:55:21","1");
INSERT INTO audit_trail VALUES("5760","6","Gilbert Githitu","","Logged in to system","2021-12-11 04:45:10","2021-12-11 04:45:10","");
INSERT INTO audit_trail VALUES("5761","6","Gilbert Githitu","","Logged in to system","2021-12-14 00:31:00","2021-12-14 00:31:00","");
INSERT INTO audit_trail VALUES("5762","6","Gilbert Githitu","","Logged in to system","2021-12-14 00:31:10","2021-12-14 00:31:10","");
INSERT INTO audit_trail VALUES("5763","6","Gilbert Githitu","","Added Capital  with id:925","2021-12-14 01:01:42","2021-12-14 01:01:42","1");
INSERT INTO audit_trail VALUES("5764","6","Gilbert Githitu","","Added Capital  with id:926","2021-12-14 08:16:51","2021-12-14 08:16:51","1");
INSERT INTO audit_trail VALUES("5765","6","Gilbert Githitu","","Added Capital  with id:927","2021-12-14 08:29:39","2021-12-14 08:29:39","1");
INSERT INTO audit_trail VALUES("5766","6","Gilbert Githitu","","Added Capital  with id:928","2021-12-14 08:34:06","2021-12-14 08:34:06","1");
INSERT INTO audit_trail VALUES("5767","6","Gilbert Githitu","","Added expense with id:466","2021-12-14 08:54:23","2021-12-14 08:54:23","1");
INSERT INTO audit_trail VALUES("5768","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35673","2021-12-14 09:04:28","2021-12-14 09:04:28","1");
INSERT INTO audit_trail VALUES("5769","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35678","2021-12-14 09:08:18","2021-12-14 09:08:18","1");
INSERT INTO audit_trail VALUES("5770","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35682","2021-12-14 09:10:42","2021-12-14 09:10:42","1");
INSERT INTO audit_trail VALUES("5771","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35684","2021-12-14 09:35:46","2021-12-14 09:35:46","1");
INSERT INTO audit_trail VALUES("5772","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35686","2021-12-14 09:40:15","2021-12-14 09:40:15","1");
INSERT INTO audit_trail VALUES("5773","6","Gilbert Githitu","","Added expense with id:467","2021-12-14 09:41:25","2021-12-14 09:41:25","1");
INSERT INTO audit_trail VALUES("5774","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35690","2021-12-14 09:48:19","2021-12-14 09:48:19","1");
INSERT INTO audit_trail VALUES("5775","6","Gilbert Githitu","","Updated expense with id:467","2021-12-14 09:50:33","2021-12-14 09:50:33","1");
INSERT INTO audit_trail VALUES("5776","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35696","2021-12-14 10:02:56","2021-12-14 10:02:56","1");
INSERT INTO audit_trail VALUES("5777","6","Gilbert Githitu","","Added Journal Manual Entry  with id:35698","2021-12-14 10:04:51","2021-12-14 10:04:51","1");
INSERT INTO audit_trail VALUES("5778","1","Admin Admin","","Logged in to system","2021-12-14 10:27:10","2021-12-14 10:27:10","");
INSERT INTO audit_trail VALUES("5779","6","Gilbert Githitu","","Added expense with id:468","2021-12-14 10:37:23","2021-12-14 10:37:23","1");
INSERT INTO audit_trail VALUES("5780","1","Admin Admin","","Deleted expense with id:467","2021-12-14 10:37:29","2021-12-14 10:37:29","1");
INSERT INTO audit_trail VALUES("5781","6","Gilbert Githitu","","Logged in to system","2021-12-14 10:59:44","2021-12-14 10:59:44","");
INSERT INTO audit_trail VALUES("5782","6","Gilbert Githitu","","Added Capital  with id:929","2021-12-15 00:26:52","2021-12-15 00:26:52","1");
INSERT INTO audit_trail VALUES("5783","6","Gilbert Githitu","","Added expense with id:469","2021-12-15 08:51:07","2021-12-15 08:51:07","1");
INSERT INTO audit_trail VALUES("5784","6","Gilbert Githitu","","Logged in to system","2021-12-15 09:39:41","2021-12-15 09:39:41","");
INSERT INTO audit_trail VALUES("5785","6","Gilbert Githitu","","Logged in to system","2021-12-15 09:41:00","2021-12-15 09:41:00","1");
INSERT INTO audit_trail VALUES("5786","6","Gilbert Githitu","","Added Capital  with id:930","2021-12-16 00:36:52","2021-12-16 00:36:52","1");
INSERT INTO audit_trail VALUES("5787","6","Gilbert Githitu","","Added Capital  with id:931","2021-12-16 00:38:29","2021-12-16 00:38:29","1");
INSERT INTO audit_trail VALUES("5788","6","Gilbert Githitu","","Updated loan with id:238","2021-12-16 03:40:56","2021-12-16 03:40:56","1");
INSERT INTO audit_trail VALUES("5789","6","Gilbert Githitu","","Added expense with id:470","2021-12-16 04:14:50","2021-12-16 04:14:50","1");
INSERT INTO audit_trail VALUES("5790","6","Gilbert Githitu","","Added expense with id:471","2021-12-16 04:16:01","2021-12-16 04:16:01","1");
INSERT INTO audit_trail VALUES("5791","6","Gilbert Githitu","","Added Capital  with id:932","2021-12-16 04:17:08","2021-12-16 04:17:08","1");
INSERT INTO audit_trail VALUES("5792","6","Gilbert Githitu","","Added expense with id:472","2021-12-16 08:54:33","2021-12-16 08:54:33","1");
INSERT INTO audit_trail VALUES("5793","6","Gilbert Githitu","","Logged out of system","2021-12-16 09:16:08","2021-12-16 09:16:08","1");
INSERT INTO audit_trail VALUES("5794","6","Gilbert Githitu","","Logged in to system","2021-12-16 09:17:09","2021-12-16 09:17:09","");
INSERT INTO audit_trail VALUES("5795","6","Gilbert Githitu","","Logged in to system","2021-12-17 00:10:26","2021-12-17 00:10:26","1");
INSERT INTO audit_trail VALUES("5796","6","Gilbert Githitu","","Logged in to system","2021-12-17 00:19:08","2021-12-17 00:19:08","1");
INSERT INTO audit_trail VALUES("5797","6","Gilbert Githitu","","Logged in to system","2021-12-17 00:38:59","2021-12-17 00:38:59","1");
INSERT INTO audit_trail VALUES("5798","6","Gilbert Githitu","","Logged in to system","2021-12-17 01:27:56","2021-12-17 01:27:56","1");
INSERT INTO audit_trail VALUES("5799","6","Gilbert Githitu","","Added Capital  with id:933","2021-12-17 01:29:52","2021-12-17 01:29:52","1");
INSERT INTO audit_trail VALUES("5800","6","Gilbert Githitu","","Added Capital  with id:934","2021-12-17 05:34:35","2021-12-17 05:34:35","1");
INSERT INTO audit_trail VALUES("5801","6","Gilbert Githitu","","Added Capital  with id:935","2021-12-17 05:35:37","2021-12-17 05:35:37","1");
INSERT INTO audit_trail VALUES("5802","6","Gilbert Githitu","","Logged in to system","2021-12-17 09:13:25","2021-12-17 09:13:25","");
INSERT INTO audit_trail VALUES("5803","6","Gilbert Githitu","","Added Capital  with id:936","2021-12-18 00:37:31","2021-12-18 00:37:31","1");
INSERT INTO audit_trail VALUES("5804","6","Gilbert Githitu","","Added Capital  with id:937","2021-12-18 00:39:47","2021-12-18 00:39:47","1");
INSERT INTO audit_trail VALUES("5805","6","Gilbert Githitu","","Added expense with id:473","2021-12-18 00:45:46","2021-12-18 00:45:46","1");
INSERT INTO audit_trail VALUES("5806","6","Gilbert Githitu","","Added Capital  with id:938","2021-12-18 02:08:58","2021-12-18 02:08:58","1");
INSERT INTO audit_trail VALUES("5807","6","Gilbert Githitu","","Logged in to system","2021-12-18 05:57:50","2021-12-18 05:57:50","");
INSERT INTO audit_trail VALUES("5808","6","Gilbert Githitu","","Logged in to system","2021-12-20 00:11:01","2021-12-20 00:11:01","");
INSERT INTO audit_trail VALUES("5809","6","Gilbert Githitu","","Logged in to system","2021-12-20 00:36:53","2021-12-20 00:36:53","");
INSERT INTO audit_trail VALUES("5810","6","Gilbert Githitu","","Added Capital  with id:939","2021-12-20 00:38:38","2021-12-20 00:38:38","1");
INSERT INTO audit_trail VALUES("5811","6","Gilbert Githitu","","Updated expense with id:456","2021-12-20 03:27:24","2021-12-20 03:27:24","1");
INSERT INTO audit_trail VALUES("5812","6","Gilbert Githitu","","Updated expense with id:462","2021-12-20 03:42:21","2021-12-20 03:42:21","1");
INSERT INTO audit_trail VALUES("5813","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36131","2021-12-20 05:39:22","2021-12-20 05:39:22","1");
INSERT INTO audit_trail VALUES("5814","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36133","2021-12-20 06:01:54","2021-12-20 06:01:54","1");
INSERT INTO audit_trail VALUES("5815","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36143","2021-12-20 07:15:37","2021-12-20 07:15:37","1");
INSERT INTO audit_trail VALUES("5816","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36145","2021-12-20 07:20:26","2021-12-20 07:20:26","1");
INSERT INTO audit_trail VALUES("5817","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36147","2021-12-20 07:23:25","2021-12-20 07:23:25","1");
INSERT INTO audit_trail VALUES("5818","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36149","2021-12-20 07:38:18","2021-12-20 07:38:18","1");
INSERT INTO audit_trail VALUES("5819","6","Gilbert Githitu","","Added expense with id:474","2021-12-20 08:59:09","2021-12-20 08:59:09","1");
INSERT INTO audit_trail VALUES("5820","6","Gilbert Githitu","","Added expense with id:475","2021-12-20 09:02:52","2021-12-20 09:02:52","1");
INSERT INTO audit_trail VALUES("5821","6","Gilbert Githitu","","Logged in to system","2021-12-20 10:19:02","2021-12-20 10:19:02","");
INSERT INTO audit_trail VALUES("5822","6","Gilbert Githitu","","Added Capital  with id:940","2021-12-21 00:44:49","2021-12-21 00:44:49","1");
INSERT INTO audit_trail VALUES("5823","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36203","2021-12-21 01:29:47","2021-12-21 01:29:47","1");
INSERT INTO audit_trail VALUES("5824","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36205","2021-12-21 01:32:35","2021-12-21 01:32:35","1");
INSERT INTO audit_trail VALUES("5825","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36207","2021-12-21 01:40:37","2021-12-21 01:40:37","1");
INSERT INTO audit_trail VALUES("5826","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36209","2021-12-21 01:45:21","2021-12-21 01:45:21","1");
INSERT INTO audit_trail VALUES("5827","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36213","2021-12-21 02:14:21","2021-12-21 02:14:21","1");
INSERT INTO audit_trail VALUES("5828","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36215","2021-12-21 02:15:28","2021-12-21 02:15:28","1");
INSERT INTO audit_trail VALUES("5829","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36223","2021-12-21 03:43:52","2021-12-21 03:43:52","1");
INSERT INTO audit_trail VALUES("5830","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36225","2021-12-21 04:45:40","2021-12-21 04:45:40","1");
INSERT INTO audit_trail VALUES("5831","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36227","2021-12-21 04:47:24","2021-12-21 04:47:24","1");
INSERT INTO audit_trail VALUES("5832","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36229","2021-12-21 04:52:26","2021-12-21 04:52:26","1");
INSERT INTO audit_trail VALUES("5833","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36231","2021-12-21 04:54:11","2021-12-21 04:54:11","1");
INSERT INTO audit_trail VALUES("5834","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36233","2021-12-21 05:07:17","2021-12-21 05:07:17","1");
INSERT INTO audit_trail VALUES("5835","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36235","2021-12-21 05:10:26","2021-12-21 05:10:26","1");
INSERT INTO audit_trail VALUES("5836","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36237","2021-12-21 05:12:03","2021-12-21 05:12:03","1");
INSERT INTO audit_trail VALUES("5837","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36239","2021-12-21 05:14:07","2021-12-21 05:14:07","1");
INSERT INTO audit_trail VALUES("5838","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36241","2021-12-21 05:27:26","2021-12-21 05:27:26","1");
INSERT INTO audit_trail VALUES("5839","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36245","2021-12-21 05:30:58","2021-12-21 05:30:58","1");
INSERT INTO audit_trail VALUES("5840","6","Gilbert Githitu","","Added Capital  with id:941","2021-12-21 06:27:48","2021-12-21 06:27:48","1");
INSERT INTO audit_trail VALUES("5841","6","Gilbert Githitu","","Added Capital  with id:942","2021-12-21 06:29:53","2021-12-21 06:29:53","1");
INSERT INTO audit_trail VALUES("5842","6","Gilbert Githitu","","Added expense with id:476","2021-12-21 06:33:02","2021-12-21 06:33:02","1");
INSERT INTO audit_trail VALUES("5843","6","Gilbert Githitu","","Logged in to system","2021-12-21 10:08:15","2021-12-21 10:08:15","");
INSERT INTO audit_trail VALUES("5844","6","Gilbert Githitu","","Added Capital  with id:943","2021-12-22 04:01:18","2021-12-22 04:01:18","1");
INSERT INTO audit_trail VALUES("5845","6","Gilbert Githitu","","Logged in to system","2021-12-22 10:58:03","2021-12-22 10:58:03","");
INSERT INTO audit_trail VALUES("5846","6","Gilbert Githitu","","Added Capital  with id:944","2021-12-23 00:25:36","2021-12-23 00:25:36","1");
INSERT INTO audit_trail VALUES("5847","6","Gilbert Githitu","","Added Capital  with id:945","2021-12-23 05:17:08","2021-12-23 05:17:08","1");
INSERT INTO audit_trail VALUES("5848","6","Gilbert Githitu","","Added Capital  with id:946","2021-12-23 06:52:22","2021-12-23 06:52:22","1");
INSERT INTO audit_trail VALUES("5849","6","Gilbert Githitu","","Logged in to system","2021-12-23 09:32:08","2021-12-23 09:32:08","");
INSERT INTO audit_trail VALUES("5850","6","Gilbert Githitu","","Added Capital  with id:947","2021-12-24 00:54:46","2021-12-24 00:54:46","1");
INSERT INTO audit_trail VALUES("5851","6","Gilbert Githitu","","Logged in to system","2021-12-24 08:42:03","2021-12-24 08:42:03","");
INSERT INTO audit_trail VALUES("5852","6","Gilbert Githitu","","Logged in to system","2021-12-28 01:10:26","2021-12-28 01:10:26","");
INSERT INTO audit_trail VALUES("5853","1","Admin Admin","","Logged in to system","2021-12-28 02:11:40","2021-12-28 02:11:40","");
INSERT INTO audit_trail VALUES("5854","6","Gilbert Githitu","","Added Capital  with id:948","2021-12-28 02:18:58","2021-12-28 02:18:58","1");
INSERT INTO audit_trail VALUES("5855","6","Gilbert Githitu","","Logged in to system","2021-12-28 03:02:42","2021-12-28 03:02:42","");
INSERT INTO audit_trail VALUES("5856","6","Gilbert Githitu","","Added Capital  with id:949","2021-12-28 04:15:40","2021-12-28 04:15:40","1");
INSERT INTO audit_trail VALUES("5857","6","Gilbert Githitu","","Added Capital  with id:950","2021-12-28 04:55:03","2021-12-28 04:55:03","1");
INSERT INTO audit_trail VALUES("5858","6","Gilbert Githitu","","Added expense with id:477","2021-12-28 04:55:53","2021-12-28 04:55:53","1");
INSERT INTO audit_trail VALUES("5859","6","Gilbert Githitu","","Added expense with id:478","2021-12-28 05:14:26","2021-12-28 05:14:26","1");
INSERT INTO audit_trail VALUES("5860","1","Admin Admin","","Logged in to system","2021-12-28 05:39:40","2021-12-28 05:39:40","");
INSERT INTO audit_trail VALUES("5861","6","Gilbert Githitu","","Logged in to system","2021-12-28 05:40:27","2021-12-28 05:40:27","");
INSERT INTO audit_trail VALUES("5862","6","Gilbert Githitu","","Updated loan with id:233","2021-12-28 07:33:00","2021-12-28 07:33:00","1");
INSERT INTO audit_trail VALUES("5863","6","Gilbert Githitu","","Added expense with id:479","2021-12-28 09:05:40","2021-12-28 09:05:40","1");
INSERT INTO audit_trail VALUES("5864","6","Gilbert Githitu","","Added expense with id:480","2021-12-28 09:53:25","2021-12-28 09:53:25","1");
INSERT INTO audit_trail VALUES("5865","6","Gilbert Githitu","","Added Capital  with id:951","2021-12-28 10:45:13","2021-12-28 10:45:13","1");
INSERT INTO audit_trail VALUES("5866","6","Gilbert Githitu","","Logged out of system","2021-12-28 10:46:05","2021-12-28 10:46:05","1");
INSERT INTO audit_trail VALUES("5867","6","Gilbert Githitu","","Logged in to system","2021-12-29 00:18:42","2021-12-29 00:18:42","1");
INSERT INTO audit_trail VALUES("5868","6","Gilbert Githitu","","Added Capital  with id:952","2021-12-29 00:32:20","2021-12-29 00:32:20","1");
INSERT INTO audit_trail VALUES("5869","6","Gilbert Githitu","","Logged in to system","2021-12-29 01:19:32","2021-12-29 01:19:32","1");
INSERT INTO audit_trail VALUES("5870","6","Gilbert Githitu","","Added Capital  with id:953","2021-12-29 02:30:12","2021-12-29 02:30:12","1");
INSERT INTO audit_trail VALUES("5871","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36731","2021-12-29 02:41:44","2021-12-29 02:41:44","1");
INSERT INTO audit_trail VALUES("5872","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36733","2021-12-29 02:49:21","2021-12-29 02:49:21","1");
INSERT INTO audit_trail VALUES("5873","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36735","2021-12-29 02:59:19","2021-12-29 02:59:19","1");
INSERT INTO audit_trail VALUES("5874","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36737","2021-12-29 03:10:09","2021-12-29 03:10:09","1");
INSERT INTO audit_trail VALUES("5875","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36741","2021-12-29 03:20:37","2021-12-29 03:20:37","1");
INSERT INTO audit_trail VALUES("5876","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36743","2021-12-29 03:23:12","2021-12-29 03:23:12","1");
INSERT INTO audit_trail VALUES("5877","6","Gilbert Githitu","","Added Journal Manual Entry  with id:36745","2021-12-29 03:25:03","2021-12-29 03:25:03","1");
INSERT INTO audit_trail VALUES("5878","6","Gilbert Githitu","","Logged in to system","2021-12-29 09:58:41","2021-12-29 09:58:41","");
INSERT INTO audit_trail VALUES("5879","6","Gilbert Githitu","","Logged out of system","2021-12-29 10:46:54","2021-12-29 10:46:54","1");
INSERT INTO audit_trail VALUES("5880","6","Gilbert Githitu","","Logged in to system","2021-12-30 00:08:33","2021-12-30 00:08:33","1");
INSERT INTO audit_trail VALUES("5881","6","Gilbert Githitu","","Logged in to system","2021-12-30 00:12:32","2021-12-30 00:12:32","1");
INSERT INTO audit_trail VALUES("5882","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-12-30 00:13:26","2021-12-30 00:13:26","1");
INSERT INTO audit_trail VALUES("5883","6","Gilbert Githitu","","Logged in to system","2021-12-30 00:18:23","2021-12-30 00:18:23","1");
INSERT INTO audit_trail VALUES("5884","6","Gilbert Githitu","","Added Capital  with id:954","2021-12-30 00:26:11","2021-12-30 00:26:11","1");
INSERT INTO audit_trail VALUES("5885","6","Gilbert Githitu","","Logged out of system","2021-12-30 00:26:46","2021-12-30 00:26:46","1");
INSERT INTO audit_trail VALUES("5886","2","CECILIA WANJERI WANGUHU","","Logged in to system","2021-12-30 00:28:22","2021-12-30 00:28:22","1");
INSERT INTO audit_trail VALUES("5887","6","Gilbert Githitu","","Logged in to system","2021-12-30 00:28:41","2021-12-30 00:28:41","1");
INSERT INTO audit_trail VALUES("5888","1","Admin Admin","","Logged in to system","2021-12-30 00:54:07","2021-12-30 00:54:07","");
INSERT INTO audit_trail VALUES("5889","6","Gilbert Githitu","","Logged in to system","2021-12-30 00:56:28","2021-12-30 00:56:28","");
INSERT INTO audit_trail VALUES("5890","6","Gilbert Githitu","","Logged in to system","2021-12-30 01:07:58","2021-12-30 01:07:58","");
INSERT INTO audit_trail VALUES("5891","6","Gilbert Githitu","","Updated Capital  with id:954","2021-12-30 01:12:38","2021-12-30 01:12:38","1");
INSERT INTO audit_trail VALUES("5892","6","Gilbert Githitu","","Logged in to system","2021-12-30 06:07:35","2021-12-30 06:07:35","");
INSERT INTO audit_trail VALUES("5893","6","Gilbert Githitu","","Logged in to system","2021-12-30 06:17:32","2021-12-30 06:17:32","");
INSERT INTO audit_trail VALUES("5894","6","Gilbert Githitu","","Logged in to system","2021-12-30 07:31:49","2021-12-30 07:31:49","");
INSERT INTO audit_trail VALUES("5895","6","Gilbert Githitu","","Logged in to system","2021-12-30 07:38:09","2021-12-30 07:38:09","");
INSERT INTO audit_trail VALUES("5896","6","Gilbert Githitu","","Logged in to system","2021-12-30 08:09:56","2021-12-30 08:09:56","");
INSERT INTO audit_trail VALUES("5897","6","Gilbert Githitu","","Logged in to system","2021-12-30 08:38:38","2021-12-30 08:38:38","");
INSERT INTO audit_trail VALUES("5898","6","Gilbert Githitu","","Logged out of system","2021-12-30 09:20:07","2021-12-30 09:20:07","1");
INSERT INTO audit_trail VALUES("5899","6","Gilbert Githitu","","Logged in to system","2021-12-30 09:28:26","2021-12-30 09:28:26","1");
INSERT INTO audit_trail VALUES("5900","6","Gilbert Githitu","","Logged out of system","2021-12-30 09:30:11","2021-12-30 09:30:11","1");
INSERT INTO audit_trail VALUES("5901","6","Gilbert Githitu","","Logged in to system","2021-12-30 09:33:11","2021-12-30 09:33:11","1");
INSERT INTO audit_trail VALUES("5902","6","Gilbert Githitu","","Logged out of system","2021-12-30 09:34:45","2021-12-30 09:34:45","1");
INSERT INTO audit_trail VALUES("5903","6","Gilbert Githitu","","Logged in to system","2021-12-31 00:07:34","2021-12-31 00:07:34","1");
INSERT INTO audit_trail VALUES("5904","6","Gilbert Githitu","","Logged in to system","2021-12-31 00:10:09","2021-12-31 00:10:09","1");
INSERT INTO audit_trail VALUES("5905","6","Gilbert Githitu","","Added Capital  with id:955","2021-12-31 00:29:26","2021-12-31 00:29:26","1");
INSERT INTO audit_trail VALUES("5906","6","Gilbert Githitu","","Logged in to system","2021-12-31 00:42:39","2021-12-31 00:42:39","1");
INSERT INTO audit_trail VALUES("5907","1","Admin Admin","","Logged in to system","2021-12-31 00:48:39","2021-12-31 00:48:39","");
INSERT INTO audit_trail VALUES("5908","6","Gilbert Githitu","","Logged in to system","2021-12-31 01:39:24","2021-12-31 01:39:24","");
INSERT INTO audit_trail VALUES("5909","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37048","2021-12-31 02:21:58","2021-12-31 02:21:58","1");
INSERT INTO audit_trail VALUES("5910","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37055","2021-12-31 02:27:15","2021-12-31 02:27:15","1");
INSERT INTO audit_trail VALUES("5911","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37084","2021-12-31 02:36:34","2021-12-31 02:36:34","1");
INSERT INTO audit_trail VALUES("5912","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37106","2021-12-31 02:40:51","2021-12-31 02:40:51","1");
INSERT INTO audit_trail VALUES("5913","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37114","2021-12-31 02:49:04","2021-12-31 02:49:04","1");
INSERT INTO audit_trail VALUES("5914","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37116","2021-12-31 02:51:52","2021-12-31 02:51:52","1");
INSERT INTO audit_trail VALUES("5915","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37134","2021-12-31 03:16:23","2021-12-31 03:16:23","1");
INSERT INTO audit_trail VALUES("5916","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37136","2021-12-31 03:17:58","2021-12-31 03:17:58","1");
INSERT INTO audit_trail VALUES("5917","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37150","2021-12-31 04:51:13","2021-12-31 04:51:13","1");
INSERT INTO audit_trail VALUES("5918","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37152","2021-12-31 04:52:36","2021-12-31 04:52:36","1");
INSERT INTO audit_trail VALUES("5919","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37154","2021-12-31 04:53:48","2021-12-31 04:53:48","1");
INSERT INTO audit_trail VALUES("5920","6","Gilbert Githitu","","Added Capital  with id:956","2021-12-31 05:14:48","2021-12-31 05:14:48","1");
INSERT INTO audit_trail VALUES("5921","6","Gilbert Githitu","","Added expense with id:481","2021-12-31 05:22:09","2021-12-31 05:22:09","1");
INSERT INTO audit_trail VALUES("5922","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37179","2021-12-31 06:31:58","2021-12-31 06:31:58","1");
INSERT INTO audit_trail VALUES("5923","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37182","2021-12-31 06:34:41","2021-12-31 06:34:41","1");
INSERT INTO audit_trail VALUES("5924","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37200","2021-12-31 07:10:19","2021-12-31 07:10:19","1");
INSERT INTO audit_trail VALUES("5925","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37211","2021-12-31 07:20:16","2021-12-31 07:20:16","1");
INSERT INTO audit_trail VALUES("5926","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37214","2021-12-31 07:23:03","2021-12-31 07:23:03","1");
INSERT INTO audit_trail VALUES("5927","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37217","2021-12-31 07:25:58","2021-12-31 07:25:58","1");
INSERT INTO audit_trail VALUES("5928","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37220","2021-12-31 07:30:55","2021-12-31 07:30:55","1");
INSERT INTO audit_trail VALUES("5929","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37223","2021-12-31 07:33:48","2021-12-31 07:33:48","1");
INSERT INTO audit_trail VALUES("5930","6","Gilbert Githitu","","Logged out of system","2021-12-31 10:00:13","2021-12-31 10:00:13","1");
INSERT INTO audit_trail VALUES("5931","6","Gilbert Githitu","","Logged in to system","2021-12-31 10:01:09","2021-12-31 10:01:09","1");
INSERT INTO audit_trail VALUES("5932","6","Gilbert Githitu","","Logged out of system","2021-12-31 10:01:22","2021-12-31 10:01:22","1");
INSERT INTO audit_trail VALUES("5933","6","Gilbert Githitu","","Logged in to system","2021-12-31 10:01:25","2021-12-31 10:01:25","");
INSERT INTO audit_trail VALUES("5934","6","Gilbert Githitu","","Logged out of system","2021-12-31 10:02:19","2021-12-31 10:02:19","1");
INSERT INTO audit_trail VALUES("5935","6","Gilbert Githitu","","Logged in to system","2022-01-03 00:28:01","2022-01-03 00:28:01","");
INSERT INTO audit_trail VALUES("5936","6","Gilbert Githitu","","Logged in to system","2022-01-03 00:28:03","2022-01-03 00:28:03","");
INSERT INTO audit_trail VALUES("5937","6","Gilbert Githitu","","Added Capital  with id:957","2022-01-03 00:30:04","2022-01-03 00:30:04","1");
INSERT INTO audit_trail VALUES("5938","6","Gilbert Githitu","","Logged in to system","2022-01-03 00:30:56","2022-01-03 00:30:56","");
INSERT INTO audit_trail VALUES("5939","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37317","2022-01-03 03:30:35","2022-01-03 03:30:35","1");
INSERT INTO audit_trail VALUES("5940","6","Gilbert Githitu","","Added Capital  with id:958","2022-01-03 06:11:52","2022-01-03 06:11:52","1");
INSERT INTO audit_trail VALUES("5941","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37337","2022-01-03 07:46:51","2022-01-03 07:46:51","1");
INSERT INTO audit_trail VALUES("5942","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37339","2022-01-03 07:50:11","2022-01-03 07:50:11","1");
INSERT INTO audit_trail VALUES("5943","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37341","2022-01-03 07:53:37","2022-01-03 07:53:37","1");
INSERT INTO audit_trail VALUES("5944","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37374","2022-01-03 08:50:19","2022-01-03 08:50:19","1");
INSERT INTO audit_trail VALUES("5945","6","Gilbert Githitu","","Added expense with id:482","2022-01-03 09:14:32","2022-01-03 09:14:32","1");
INSERT INTO audit_trail VALUES("5946","1","Admin Admin","","Logged in to system","2022-01-03 09:36:53","2022-01-03 09:36:53","");
INSERT INTO audit_trail VALUES("5947","6","Gilbert Githitu","","Logged out of system","2022-01-03 09:59:56","2022-01-03 09:59:56","1");
INSERT INTO audit_trail VALUES("5948","6","Gilbert Githitu","","Logged in to system","2022-01-04 00:39:26","2022-01-04 00:39:26","1");
INSERT INTO audit_trail VALUES("5949","6","Gilbert Githitu","","Added Capital  with id:959","2022-01-04 00:44:19","2022-01-04 00:44:19","1");
INSERT INTO audit_trail VALUES("5950","6","Gilbert Githitu","","Logged in to system","2022-01-04 00:58:01","2022-01-04 00:58:01","");
INSERT INTO audit_trail VALUES("5951","6","Gilbert Githitu","","Logged in to system","2022-01-04 00:58:01","2022-01-04 00:58:01","");
INSERT INTO audit_trail VALUES("5952","6","Gilbert Githitu","","Added Capital  with id:960","2022-01-04 01:57:35","2022-01-04 01:57:35","1");
INSERT INTO audit_trail VALUES("5953","6","Gilbert Githitu","","Logged in to system","2022-01-04 02:13:04","2022-01-04 02:13:04","");
INSERT INTO audit_trail VALUES("5954","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37406","2022-01-04 02:23:27","2022-01-04 02:23:27","1");
INSERT INTO audit_trail VALUES("5955","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37408","2022-01-04 02:25:57","2022-01-04 02:25:57","1");
INSERT INTO audit_trail VALUES("5956","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37410","2022-01-04 02:30:27","2022-01-04 02:30:27","1");
INSERT INTO audit_trail VALUES("5957","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37412","2022-01-04 02:43:12","2022-01-04 02:43:12","1");
INSERT INTO audit_trail VALUES("5958","6","Gilbert Githitu","","Logged in to system","2022-01-04 02:58:15","2022-01-04 02:58:15","1");
INSERT INTO audit_trail VALUES("5959","6","Gilbert Githitu","","Added Capital  with id:961","2022-01-04 03:42:18","2022-01-04 03:42:18","1");
INSERT INTO audit_trail VALUES("5960","6","Gilbert Githitu","","Added Capital  with id:962","2022-01-04 04:11:23","2022-01-04 04:11:23","1");
INSERT INTO audit_trail VALUES("5961","6","Gilbert Githitu","","Logged in to system","2022-01-04 05:30:27","2022-01-04 05:30:27","");
INSERT INTO audit_trail VALUES("5962","6","Gilbert Githitu","","Logged in to system","2022-01-04 05:30:29","2022-01-04 05:30:29","");
INSERT INTO audit_trail VALUES("5963","6","Gilbert Githitu","","Logged in to system","2022-01-04 05:30:31","2022-01-04 05:30:31","1");
INSERT INTO audit_trail VALUES("5964","6","Gilbert Githitu","","Logged in to system","2022-01-04 05:42:56","2022-01-04 05:42:56","1");
INSERT INTO audit_trail VALUES("5965","6","Gilbert Githitu","","Logged out of system","2022-01-04 09:51:47","2022-01-04 09:51:47","1");
INSERT INTO audit_trail VALUES("5966","6","Gilbert Githitu","","Logged in to system","2022-01-04 11:00:00","2022-01-04 11:00:00","1");
INSERT INTO audit_trail VALUES("5967","6","Gilbert Githitu","","Added Capital  with id:963","2022-01-05 00:18:53","2022-01-05 00:18:53","1");
INSERT INTO audit_trail VALUES("5968","6","Gilbert Githitu","","Logged in to system","2022-01-05 00:24:14","2022-01-05 00:24:14","1");
INSERT INTO audit_trail VALUES("5969","6","Gilbert Githitu","","Logged in to system","2022-01-05 00:55:18","2022-01-05 00:55:18","");
INSERT INTO audit_trail VALUES("5970","6","Gilbert Githitu","","Logged in to system","2022-01-05 01:03:46","2022-01-05 01:03:46","");
INSERT INTO audit_trail VALUES("5971","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37483","2022-01-05 01:37:27","2022-01-05 01:37:27","1");
INSERT INTO audit_trail VALUES("5972","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37491","2022-01-05 02:01:59","2022-01-05 02:01:59","1");
INSERT INTO audit_trail VALUES("5973","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37495","2022-01-05 02:16:30","2022-01-05 02:16:30","1");
INSERT INTO audit_trail VALUES("5974","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37497","2022-01-05 02:26:41","2022-01-05 02:26:41","1");
INSERT INTO audit_trail VALUES("5975","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37499","2022-01-05 04:02:56","2022-01-05 04:02:56","1");
INSERT INTO audit_trail VALUES("5976","6","Gilbert Githitu","","Added expense with id:483","2022-01-05 04:24:29","2022-01-05 04:24:29","1");
INSERT INTO audit_trail VALUES("5977","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37584","2022-01-05 08:57:38","2022-01-05 08:57:38","1");
INSERT INTO audit_trail VALUES("5978","6","Gilbert Githitu","","Added expense with id:484","2022-01-05 09:06:24","2022-01-05 09:06:24","1");
INSERT INTO audit_trail VALUES("5979","6","Gilbert Githitu","","Added expense with id:485","2022-01-05 09:13:28","2022-01-05 09:13:28","1");
INSERT INTO audit_trail VALUES("5980","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37594","2022-01-05 09:23:35","2022-01-05 09:23:35","1");
INSERT INTO audit_trail VALUES("5981","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37598","2022-01-05 09:30:02","2022-01-05 09:30:02","1");
INSERT INTO audit_trail VALUES("5982","6","Gilbert Githitu","","Logged out of system","2022-01-05 09:35:03","2022-01-05 09:35:03","1");
INSERT INTO audit_trail VALUES("5983","6","Gilbert Githitu","","Logged in to system","2022-01-05 10:50:06","2022-01-05 10:50:06","");
INSERT INTO audit_trail VALUES("5984","6","Gilbert Githitu","","Logged in to system","2022-01-06 00:09:02","2022-01-06 00:09:02","1");
INSERT INTO audit_trail VALUES("5985","6","Gilbert Githitu","","Logged in to system","2022-01-06 00:14:55","2022-01-06 00:14:55","1");
INSERT INTO audit_trail VALUES("5986","6","Gilbert Githitu","","Added Capital  with id:964","2022-01-06 00:20:25","2022-01-06 00:20:25","1");
INSERT INTO audit_trail VALUES("5987","6","Gilbert Githitu","","Added Capital  with id:965","2022-01-06 01:06:44","2022-01-06 01:06:44","1");
INSERT INTO audit_trail VALUES("5988","6","Gilbert Githitu","","Added Capital  with id:966","2022-01-06 01:10:08","2022-01-06 01:10:08","1");
INSERT INTO audit_trail VALUES("5989","6","Gilbert Githitu","","Logged in to system","2022-01-06 02:16:54","2022-01-06 02:16:54","1");
INSERT INTO audit_trail VALUES("5990","6","Gilbert Githitu","","Added expense with id:486","2022-01-06 02:45:05","2022-01-06 02:45:05","1");
INSERT INTO audit_trail VALUES("5991","6","Gilbert Githitu","","Added expense with id:487","2022-01-06 02:47:47","2022-01-06 02:47:47","1");
INSERT INTO audit_trail VALUES("5992","6","Gilbert Githitu","","Added expense with id:488","2022-01-06 09:01:00","2022-01-06 09:01:00","1");
INSERT INTO audit_trail VALUES("5993","6","Gilbert Githitu","","Logged out of system","2022-01-06 09:29:05","2022-01-06 09:29:05","1");
INSERT INTO audit_trail VALUES("5994","6","Gilbert Githitu","","Logged in to system","2022-01-06 09:55:39","2022-01-06 09:55:39","1");
INSERT INTO audit_trail VALUES("5995","1","Admin Admin","","Logged in to system","2022-01-06 12:41:57","2022-01-06 12:41:57","");
INSERT INTO audit_trail VALUES("5996","1","Admin Admin","","Logged in to system","2022-01-06 16:25:22","2022-01-06 16:25:22","");
INSERT INTO audit_trail VALUES("5997","6","Gilbert Githitu","","Added Capital  with id:967","2022-01-07 00:42:48","2022-01-07 00:42:48","1");
INSERT INTO audit_trail VALUES("5998","6","Gilbert Githitu","","Logged in to system","2022-01-07 01:14:37","2022-01-07 01:14:37","1");
INSERT INTO audit_trail VALUES("5999","6","Gilbert Githitu","","Logged in to system","2022-01-07 02:57:38","2022-01-07 02:57:38","1");
INSERT INTO audit_trail VALUES("6000","6","Gilbert Githitu","","Added expense with id:489","2022-01-07 03:08:54","2022-01-07 03:08:54","1");
INSERT INTO audit_trail VALUES("6001","6","Gilbert Githitu","","Added expense with id:490","2022-01-07 03:10:34","2022-01-07 03:10:34","1");
INSERT INTO audit_trail VALUES("6002","6","Gilbert Githitu","","Added expense with id:491","2022-01-07 03:11:11","2022-01-07 03:11:11","1");
INSERT INTO audit_trail VALUES("6003","6","Gilbert Githitu","","Logged in to system","2022-01-07 09:31:16","2022-01-07 09:31:16","");
INSERT INTO audit_trail VALUES("6004","6","Gilbert Githitu","","Added Capital  with id:968","2022-01-08 00:38:52","2022-01-08 00:38:52","1");
INSERT INTO audit_trail VALUES("6005","6","Gilbert Githitu","","Added Capital  with id:969","2022-01-08 00:59:45","2022-01-08 00:59:45","1");
INSERT INTO audit_trail VALUES("6006","1","Admin Admin","","Logged in to system","2022-01-08 02:46:08","2022-01-08 02:46:08","");
INSERT INTO audit_trail VALUES("6007","1","Admin Admin","","Logged in to system","2022-01-08 06:41:11","2022-01-08 06:41:11","");
INSERT INTO audit_trail VALUES("6008","1","Admin Admin","","Logged in to system","2022-01-08 06:51:16","2022-01-08 06:51:16","");
INSERT INTO audit_trail VALUES("6009","1","Admin Admin","","Logged out of system","2022-01-08 06:51:56","2022-01-08 06:51:56","1");
INSERT INTO audit_trail VALUES("6010","6","Gilbert Githitu","","Logged in to system","2022-01-08 06:52:10","2022-01-08 06:52:10","1");
INSERT INTO audit_trail VALUES("6011","6","Gilbert Githitu","","Logged in to system","2022-01-10 00:11:13","2022-01-10 00:11:13","");
INSERT INTO audit_trail VALUES("6012","6","Gilbert Githitu","","Added Capital  with id:970","2022-01-10 01:16:55","2022-01-10 01:16:55","1");
INSERT INTO audit_trail VALUES("6013","6","Gilbert Githitu","","Logged in to system","2022-01-10 02:24:36","2022-01-10 02:24:36","");
INSERT INTO audit_trail VALUES("6014","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37918","2022-01-10 02:52:31","2022-01-10 02:52:31","1");
INSERT INTO audit_trail VALUES("6015","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37921","2022-01-10 02:55:20","2022-01-10 02:55:20","1");
INSERT INTO audit_trail VALUES("6016","1","Admin Admin","","Logged in to system","2022-01-10 03:12:04","2022-01-10 03:12:04","");
INSERT INTO audit_trail VALUES("6017","1","Admin Admin","","Logged in to system","2022-01-10 03:33:38","2022-01-10 03:33:38","");
INSERT INTO audit_trail VALUES("6018","6","Gilbert Githitu","","Added Journal Manual Entry  with id:37930","2022-01-10 04:03:45","2022-01-10 04:03:45","1");
INSERT INTO audit_trail VALUES("6019","6","Gilbert Githitu","","Logged in to system","2022-01-10 08:01:02","2022-01-10 08:01:02","");
INSERT INTO audit_trail VALUES("6020","6","Gilbert Githitu","","Added expense with id:492","2022-01-10 09:32:02","2022-01-10 09:32:02","1");
INSERT INTO audit_trail VALUES("6021","6","Gilbert Githitu","","Logged out of system","2022-01-10 09:54:10","2022-01-10 09:54:10","1");
INSERT INTO audit_trail VALUES("6022","6","Gilbert Githitu","","Logged in to system","2022-01-10 10:04:21","2022-01-10 10:04:21","1");
INSERT INTO audit_trail VALUES("6023","6","Gilbert Githitu","","Logged out of system","2022-01-10 10:06:50","2022-01-10 10:06:50","1");
INSERT INTO audit_trail VALUES("6024","6","Gilbert Githitu","","Logged in to system","2022-01-10 10:38:52","2022-01-10 10:38:52","1");
INSERT INTO audit_trail VALUES("6025","6","Gilbert Githitu","","Logged in to system","2022-01-11 00:17:12","2022-01-11 00:17:12","1");
INSERT INTO audit_trail VALUES("6026","6","Gilbert Githitu","","Added Capital  with id:971","2022-01-11 00:23:05","2022-01-11 00:23:05","1");
INSERT INTO audit_trail VALUES("6027","6","Gilbert Githitu","","Added Journal Manual Entry  with id:38070","2022-01-11 07:11:21","2022-01-11 07:11:21","1");
INSERT INTO audit_trail VALUES("6028","6","Gilbert Githitu","","Added expense with id:493","2022-01-11 08:52:13","2022-01-11 08:52:13","1");
INSERT INTO audit_trail VALUES("6029","6","Gilbert Githitu","","Added Capital  with id:972","2022-01-12 00:37:03","2022-01-12 00:37:03","1");
INSERT INTO audit_trail VALUES("6030","6","Gilbert Githitu","","Added expense with id:494","2022-01-12 01:40:05","2022-01-12 01:40:05","1");
INSERT INTO audit_trail VALUES("6031","6","Gilbert Githitu","","Added expense with id:495","2022-01-12 01:42:40","2022-01-12 01:42:40","1");
INSERT INTO audit_trail VALUES("6032","6","Gilbert Githitu","","Logged in to system","2022-01-12 02:16:31","2022-01-12 02:16:31","");
INSERT INTO audit_trail VALUES("6033","6","Gilbert Githitu","","Added loan with id:242","2022-01-12 02:19:52","2022-01-12 02:19:52","1");
INSERT INTO audit_trail VALUES("6034","6","Gilbert Githitu","","Approved loan with id:242","2022-01-12 02:20:27","2022-01-12 02:20:27","1");
INSERT INTO audit_trail VALUES("6035","6","Gilbert Githitu","","Disbursed loan with id:242","2022-01-12 02:20:46","2022-01-12 02:20:46","1");
INSERT INTO audit_trail VALUES("6036","6","Gilbert Githitu","","Added Journal Manual Entry  with id:38164","2022-01-12 02:30:21","2022-01-12 02:30:21","1");
INSERT INTO audit_trail VALUES("6037","6","Gilbert Githitu","","Logged in to system","2022-01-12 04:22:03","2022-01-12 04:22:03","");
INSERT INTO audit_trail VALUES("6038","6","Gilbert Githitu","","Added Capital  with id:973","2022-01-12 04:23:37","2022-01-12 04:23:37","1");
INSERT INTO audit_trail VALUES("6039","6","Gilbert Githitu","","Added Capital  with id:974","2022-01-12 04:24:37","2022-01-12 04:24:37","1");
INSERT INTO audit_trail VALUES("6040","6","Gilbert Githitu","","Added Journal Manual Entry  with id:38194","2022-01-12 07:46:41","2022-01-12 07:46:41","1");
INSERT INTO audit_trail VALUES("6041","6","Gilbert Githitu","","Added expense with id:496","2022-01-12 08:44:10","2022-01-12 08:44:10","1");
INSERT INTO audit_trail VALUES("6042","6","Gilbert Githitu","","Updated expense with id:495","2022-01-12 09:46:18","2022-01-12 09:46:18","1");
INSERT INTO audit_trail VALUES("6043","6","Gilbert Githitu","","Logged out of system","2022-01-12 09:59:06","2022-01-12 09:59:06","1");
INSERT INTO audit_trail VALUES("6044","6","Gilbert Githitu","","Logged in to system","2022-01-13 00:10:31","2022-01-13 00:10:31","1");
INSERT INTO audit_trail VALUES("6045","6","Gilbert Githitu","","Logged in to system","2022-01-13 00:19:25","2022-01-13 00:19:25","1");
INSERT INTO audit_trail VALUES("6046","6","Gilbert Githitu","","Added Capital  with id:975","2022-01-13 00:27:21","2022-01-13 00:27:21","1");
INSERT INTO audit_trail VALUES("6047","6","Gilbert Githitu","","Added Capital  with id:976","2022-01-13 01:18:26","2022-01-13 01:18:26","1");
INSERT INTO audit_trail VALUES("6048","6","Gilbert Githitu","","Added Capital  with id:977","2022-01-13 01:48:37","2022-01-13 01:48:37","1");
INSERT INTO audit_trail VALUES("6049","6","Gilbert Githitu","","Logged in to system","2022-01-13 03:35:06","2022-01-13 03:35:06","1");
INSERT INTO audit_trail VALUES("6050","6","Gilbert Githitu","","Added expense with id:497","2022-01-13 03:56:04","2022-01-13 03:56:04","1");
INSERT INTO audit_trail VALUES("6051","6","Gilbert Githitu","","Added expense with id:498","2022-01-13 03:57:00","2022-01-13 03:57:00","1");
INSERT INTO audit_trail VALUES("6052","6","Gilbert Githitu","","Added expense with id:499","2022-01-13 08:18:48","2022-01-13 08:18:48","1");
INSERT INTO audit_trail VALUES("6053","6","Gilbert Githitu","","Added expense with id:500","2022-01-13 09:34:46","2022-01-13 09:34:46","1");
INSERT INTO audit_trail VALUES("6054","6","Gilbert Githitu","","Updated expense with id:500","2022-01-13 09:36:46","2022-01-13 09:36:46","1");
INSERT INTO audit_trail VALUES("6055","6","Gilbert Githitu","","Logged in to system","2022-01-13 09:37:36","2022-01-13 09:37:36","");
INSERT INTO audit_trail VALUES("6056","6","Gilbert Githitu","","Logged out of system","2022-01-13 09:39:23","2022-01-13 09:39:23","1");
INSERT INTO audit_trail VALUES("6057","6","Gilbert Githitu","","Logged in to system","2022-01-13 09:46:18","2022-01-13 09:46:18","1");
INSERT INTO audit_trail VALUES("6058","6","Gilbert Githitu","","Added Capital  with id:978","2022-01-14 00:53:19","2022-01-14 00:53:19","1");
INSERT INTO audit_trail VALUES("6059","1","Admin Admin","","Logged in to system","2022-01-14 02:39:24","2022-01-14 02:39:24","");
INSERT INTO audit_trail VALUES("6060","6","Gilbert Githitu","","Logged in to system","2022-01-14 03:30:30","2022-01-14 03:30:30","1");
INSERT INTO audit_trail VALUES("6061","6","Gilbert Githitu","","Logged in to system","2022-01-14 06:22:46","2022-01-14 06:22:46","");
INSERT INTO audit_trail VALUES("6062","6","Gilbert Githitu","","Updated loan product with id:1","2022-01-14 06:51:39","2022-01-14 06:51:39","1");
INSERT INTO audit_trail VALUES("6063","6","Gilbert Githitu","","Added loan with id:243","2022-01-14 06:54:03","2022-01-14 06:54:03","1");
INSERT INTO audit_trail VALUES("6064","6","Gilbert Githitu","","Approved loan with id:243","2022-01-14 06:54:40","2022-01-14 06:54:40","1");
INSERT INTO audit_trail VALUES("6065","6","Gilbert Githitu","","Disbursed loan with id:243","2022-01-14 06:54:50","2022-01-14 06:54:50","1");
INSERT INTO audit_trail VALUES("6066","6","Gilbert Githitu","","Logged out of system","2022-01-14 07:21:58","2022-01-14 07:21:58","1");
INSERT INTO audit_trail VALUES("6067","6","Gilbert Githitu","","Logged in to system","2022-01-14 07:23:49","2022-01-14 07:23:49","1");
INSERT INTO audit_trail VALUES("6068","6","Gilbert Githitu","","Logged in to system","2022-01-14 07:46:50","2022-01-14 07:46:50","1");
INSERT INTO audit_trail VALUES("6069","6","Gilbert Githitu","","Logged in to system","2022-01-14 07:46:53","2022-01-14 07:46:53","1");
INSERT INTO audit_trail VALUES("6070","6","Gilbert Githitu","","Added expense with id:501","2022-01-14 09:22:36","2022-01-14 09:22:36","1");
INSERT INTO audit_trail VALUES("6071","6","Gilbert Githitu","","Added expense with id:502","2022-01-14 09:27:48","2022-01-14 09:27:48","1");
INSERT INTO audit_trail VALUES("6072","6","Gilbert Githitu","","Added expense with id:503","2022-01-14 09:32:19","2022-01-14 09:32:19","1");
INSERT INTO audit_trail VALUES("6073","6","Gilbert Githitu","","Logged in to system","2022-01-14 09:36:53","2022-01-14 09:36:53","1");
INSERT INTO audit_trail VALUES("6074","6","Gilbert Githitu","","Added expense with id:504","2022-01-14 09:39:38","2022-01-14 09:39:38","1");
INSERT INTO audit_trail VALUES("6075","6","Gilbert Githitu","","Added expense with id:505","2022-01-14 09:40:56","2022-01-14 09:40:56","1");
INSERT INTO audit_trail VALUES("6076","6","Gilbert Githitu","","Logged out of system","2022-01-14 10:03:19","2022-01-14 10:03:19","1");
INSERT INTO audit_trail VALUES("6077","6","Gilbert Githitu","","Logged in to system","2022-01-15 02:31:10","2022-01-15 02:31:10","1");
INSERT INTO audit_trail VALUES("6078","6","Gilbert Githitu","","Added Capital  with id:979","2022-01-15 02:33:22","2022-01-15 02:33:22","1");
INSERT INTO audit_trail VALUES("6079","6","Gilbert Githitu","","Logged in to system","2022-01-15 02:45:23","2022-01-15 02:45:23","1");
INSERT INTO audit_trail VALUES("6080","6","Gilbert Githitu","","Logged out of system","2022-01-15 07:28:29","2022-01-15 07:28:29","1");
INSERT INTO audit_trail VALUES("6081","6","Gilbert Githitu","","Logged in to system","2022-01-15 08:00:03","2022-01-15 08:00:03","1");
INSERT INTO audit_trail VALUES("6082","6","Gilbert Githitu","","Logged out of system","2022-01-15 08:00:21","2022-01-15 08:00:21","1");
INSERT INTO audit_trail VALUES("6083","6","Gilbert Githitu","","Logged in to system","2022-01-17 02:12:09","2022-01-17 02:12:09","");
INSERT INTO audit_trail VALUES("6084","6","Gilbert Githitu","","Logged in to system","2022-01-17 03:06:18","2022-01-17 03:06:18","");
INSERT INTO audit_trail VALUES("6085","6","Gilbert Githitu","","Added Capital  with id:980","2022-01-17 03:07:33","2022-01-17 03:07:33","1");
INSERT INTO audit_trail VALUES("6086","6","Gilbert Githitu","","Added expense with id:506","2022-01-17 03:08:56","2022-01-17 03:08:56","1");
INSERT INTO audit_trail VALUES("6087","6","Gilbert Githitu","","Added expense with id:507","2022-01-17 03:09:38","2022-01-17 03:09:38","1");
INSERT INTO audit_trail VALUES("6088","6","Gilbert Githitu","","Logged in to system","2022-01-17 03:58:15","2022-01-17 03:58:15","");
INSERT INTO audit_trail VALUES("6089","6","Gilbert Githitu","","Logged in to system","2022-01-17 04:02:43","2022-01-17 04:02:43","");
INSERT INTO audit_trail VALUES("6090","6","Gilbert Githitu","","Added Capital  with id:981","2022-01-17 08:07:30","2022-01-17 08:07:30","1");
INSERT INTO audit_trail VALUES("6091","6","Gilbert Githitu","","Added expense with id:508","2022-01-17 10:21:45","2022-01-17 10:21:45","1");
INSERT INTO audit_trail VALUES("6092","6","Gilbert Githitu","","Logged in to system","2022-01-17 10:56:16","2022-01-17 10:56:16","");
INSERT INTO audit_trail VALUES("6093","6","Gilbert Githitu","","Logged in to system","2022-01-17 10:56:18","2022-01-17 10:56:18","");
INSERT INTO audit_trail VALUES("6094","6","Gilbert Githitu","","Added Capital  with id:982","2022-01-18 02:47:54","2022-01-18 02:47:54","1");
INSERT INTO audit_trail VALUES("6095","1","Admin Admin","","Logged in to system","2022-01-18 03:45:09","2022-01-18 03:45:09","");
INSERT INTO audit_trail VALUES("6096","6","Gilbert Githitu","","Added Capital  with id:983","2022-01-18 05:57:51","2022-01-18 05:57:51","1");
INSERT INTO audit_trail VALUES("6097","6","Gilbert Githitu","","Added expense with id:509","2022-01-18 11:28:02","2022-01-18 11:28:02","1");
INSERT INTO audit_trail VALUES("6098","6","Gilbert Githitu","","Logged in to system","2022-01-18 11:32:21","2022-01-18 11:32:21","");
INSERT INTO audit_trail VALUES("6099","6","Gilbert Githitu","","Added expense with id:510","2022-01-18 11:35:31","2022-01-18 11:35:31","1");
INSERT INTO audit_trail VALUES("6100","6","Gilbert Githitu","","Updated expense with id:510","2022-01-18 11:37:17","2022-01-18 11:37:17","1");
INSERT INTO audit_trail VALUES("6101","6","Gilbert Githitu","","Logged out of system","2022-01-18 11:52:12","2022-01-18 11:52:12","1");
INSERT INTO audit_trail VALUES("6102","6","Gilbert Githitu","","Logged in to system","2022-01-19 02:01:13","2022-01-19 02:01:13","1");
INSERT INTO audit_trail VALUES("6103","6","Gilbert Githitu","","Added Capital  with id:984","2022-01-19 02:02:51","2022-01-19 02:02:51","1");
INSERT INTO audit_trail VALUES("6104","6","Gilbert Githitu","","Logged in to system","2022-01-19 03:29:30","2022-01-19 03:29:30","1");
INSERT INTO audit_trail VALUES("6105","6","Gilbert Githitu","","Added Capital  with id:985","2022-01-19 06:19:10","2022-01-19 06:19:10","1");
INSERT INTO audit_trail VALUES("6106","6","Gilbert Githitu","","Logged in to system","2022-01-19 08:25:00","2022-01-19 08:25:00","");
INSERT INTO audit_trail VALUES("6107","6","Gilbert Githitu","","Logged in to system","2022-01-19 11:00:51","2022-01-19 11:00:51","");
INSERT INTO audit_trail VALUES("6108","6","Gilbert Githitu","","Logged out of system","2022-01-19 11:55:36","2022-01-19 11:55:36","1");
INSERT INTO audit_trail VALUES("6109","6","Gilbert Githitu","","Logged in to system","2022-01-20 02:07:43","2022-01-20 02:07:43","1");
INSERT INTO audit_trail VALUES("6110","6","Gilbert Githitu","","Logged in to system","2022-01-20 02:14:21","2022-01-20 02:14:21","1");
INSERT INTO audit_trail VALUES("6111","6","Gilbert Githitu","","Added Capital  with id:986","2022-01-20 02:19:28","2022-01-20 02:19:28","1");
INSERT INTO audit_trail VALUES("6112","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39001","2022-01-20 02:29:31","2022-01-20 02:29:31","1");
INSERT INTO audit_trail VALUES("6113","6","Gilbert Githitu","","Added expense with id:511","2022-01-20 04:43:48","2022-01-20 04:43:48","1");
INSERT INTO audit_trail VALUES("6114","6","Gilbert Githitu","","Logged in to system","2022-01-20 04:45:54","2022-01-20 04:45:54","1");
INSERT INTO audit_trail VALUES("6115","6","Gilbert Githitu","","Updated expense with id:511","2022-01-20 07:01:25","2022-01-20 07:01:25","1");
INSERT INTO audit_trail VALUES("6116","6","Gilbert Githitu","","Added Capital  with id:987","2022-01-20 08:17:25","2022-01-20 08:17:25","1");
INSERT INTO audit_trail VALUES("6117","6","Gilbert Githitu","","Added Capital  with id:988","2022-01-20 08:18:09","2022-01-20 08:18:09","1");
INSERT INTO audit_trail VALUES("6118","6","Gilbert Githitu","","Added Capital  with id:989","2022-01-20 08:18:53","2022-01-20 08:18:53","1");
INSERT INTO audit_trail VALUES("6119","6","Gilbert Githitu","","Logged in to system","2022-01-20 11:20:03","2022-01-20 11:20:03","");
INSERT INTO audit_trail VALUES("6120","6","Gilbert Githitu","","Logged out of system","2022-01-20 11:21:40","2022-01-20 11:21:40","1");
INSERT INTO audit_trail VALUES("6121","6","Gilbert Githitu","","Logged in to system","2022-01-20 11:22:36","2022-01-20 11:22:36","1");
INSERT INTO audit_trail VALUES("6122","6","Gilbert Githitu","","Logged out of system","2022-01-20 11:22:44","2022-01-20 11:22:44","1");
INSERT INTO audit_trail VALUES("6123","6","Gilbert Githitu","","Logged in to system","2022-01-20 11:58:43","2022-01-20 11:58:43","1");
INSERT INTO audit_trail VALUES("6124","6","Gilbert Githitu","","Added Capital  with id:990","2022-01-21 02:44:39","2022-01-21 02:44:39","1");
INSERT INTO audit_trail VALUES("6125","6","Gilbert Githitu","","Logged in to system","2022-01-21 04:03:09","2022-01-21 04:03:09","1");
INSERT INTO audit_trail VALUES("6126","6","Gilbert Githitu","","Logged in to system","2022-01-21 04:52:50","2022-01-21 04:52:50","");
INSERT INTO audit_trail VALUES("6127","6","Gilbert Githitu","","Logged in to system","2022-01-21 04:59:03","2022-01-21 04:59:03","1");
INSERT INTO audit_trail VALUES("6128","6","Gilbert Githitu","","Logged in to system","2022-01-21 06:32:05","2022-01-21 06:32:05","");
INSERT INTO audit_trail VALUES("6129","6","Gilbert Githitu","","Added Capital  with id:991","2022-01-21 10:46:59","2022-01-21 10:46:59","1");
INSERT INTO audit_trail VALUES("6130","6","Gilbert Githitu","","Logged out of system","2022-01-21 11:13:58","2022-01-21 11:13:58","1");
INSERT INTO audit_trail VALUES("6131","6","Gilbert Githitu","","Logged in to system","2022-01-21 11:14:38","2022-01-21 11:14:38","1");
INSERT INTO audit_trail VALUES("6132","6","Gilbert Githitu","","Logged out of system","2022-01-21 11:16:16","2022-01-21 11:16:16","1");
INSERT INTO audit_trail VALUES("6133","6","Gilbert Githitu","","Logged in to system","2022-01-21 11:41:17","2022-01-21 11:41:17","1");
INSERT INTO audit_trail VALUES("6134","6","Gilbert Githitu","","Added Capital  with id:992","2022-01-22 02:19:21","2022-01-22 02:19:21","1");
INSERT INTO audit_trail VALUES("6135","6","Gilbert Githitu","","Logged in to system","2022-01-22 02:31:42","2022-01-22 02:31:42","");
INSERT INTO audit_trail VALUES("6136","6","Gilbert Githitu","","Logged out of system","2022-01-22 08:14:18","2022-01-22 08:14:18","1");
INSERT INTO audit_trail VALUES("6137","6","Gilbert Githitu","","Logged in to system","2022-01-24 02:06:36","2022-01-24 02:06:36","");
INSERT INTO audit_trail VALUES("6138","6","Gilbert Githitu","","Logged in to system","2022-01-24 02:35:24","2022-01-24 02:35:24","");
INSERT INTO audit_trail VALUES("6139","6","Gilbert Githitu","","Added Capital  with id:993","2022-01-24 02:37:21","2022-01-24 02:37:21","1");
INSERT INTO audit_trail VALUES("6140","6","Gilbert Githitu","","Logged in to system","2022-01-24 02:40:17","2022-01-24 02:40:17","");
INSERT INTO audit_trail VALUES("6141","6","Gilbert Githitu","","Added Capital  with id:994","2022-01-24 07:48:42","2022-01-24 07:48:42","1");
INSERT INTO audit_trail VALUES("6142","6","Gilbert Githitu","","Added Capital  with id:995","2022-01-24 07:50:58","2022-01-24 07:50:58","1");
INSERT INTO audit_trail VALUES("6143","6","Gilbert Githitu","","Added expense with id:512","2022-01-24 07:52:07","2022-01-24 07:52:07","1");
INSERT INTO audit_trail VALUES("6144","6","Gilbert Githitu","","Logged in to system","2022-01-24 09:02:58","2022-01-24 09:02:58","");
INSERT INTO audit_trail VALUES("6145","6","Gilbert Githitu","","Logged in to system","2022-01-24 09:05:11","2022-01-24 09:05:11","");
INSERT INTO audit_trail VALUES("6146","6","Gilbert Githitu","","Logged in to system","2022-01-24 09:08:00","2022-01-24 09:08:00","");
INSERT INTO audit_trail VALUES("6147","6","Gilbert Githitu","","Added Capital  with id:996","2022-01-24 09:25:48","2022-01-24 09:25:48","1");
INSERT INTO audit_trail VALUES("6148","6","Gilbert Githitu","","Added expense with id:513","2022-01-24 10:52:59","2022-01-24 10:52:59","1");
INSERT INTO audit_trail VALUES("6149","6","Gilbert Githitu","","Logged out of system","2022-01-24 11:13:11","2022-01-24 11:13:11","1");
INSERT INTO audit_trail VALUES("6150","6","Gilbert Githitu","","Logged in to system","2022-01-24 11:14:07","2022-01-24 11:14:07","1");
INSERT INTO audit_trail VALUES("6151","6","Gilbert Githitu","","Added Capital  with id:997","2022-01-24 11:15:51","2022-01-24 11:15:51","1");
INSERT INTO audit_trail VALUES("6152","6","Gilbert Githitu","","Logged in to system","2022-01-25 02:12:15","2022-01-25 02:12:15","1");
INSERT INTO audit_trail VALUES("6153","6","Gilbert Githitu","","Added Capital  with id:998","2022-01-25 02:39:21","2022-01-25 02:39:21","1");
INSERT INTO audit_trail VALUES("6154","6","Gilbert Githitu","","Logged in to system","2022-01-25 03:23:31","2022-01-25 03:23:31","");
INSERT INTO audit_trail VALUES("6155","6","Gilbert Githitu","","Added Capital  with id:999","2022-01-25 05:33:52","2022-01-25 05:33:52","1");
INSERT INTO audit_trail VALUES("6156","6","Gilbert Githitu","","Logged in to system","2022-01-25 09:42:26","2022-01-25 09:42:26","");
INSERT INTO audit_trail VALUES("6157","6","Gilbert Githitu","","Logged out of system","2022-01-25 11:28:36","2022-01-25 11:28:36","1");
INSERT INTO audit_trail VALUES("6158","6","Gilbert Githitu","","Logged in to system","2022-01-25 11:28:58","2022-01-25 11:28:58","1");
INSERT INTO audit_trail VALUES("6159","6","Gilbert Githitu","","Logged in to system","2022-01-26 02:26:09","2022-01-26 02:26:09","");
INSERT INTO audit_trail VALUES("6160","6","Gilbert Githitu","","Added Capital  with id:1000","2022-01-26 02:28:14","2022-01-26 02:28:14","1");
INSERT INTO audit_trail VALUES("6161","6","Gilbert Githitu","","Logged in to system","2022-01-26 03:01:08","2022-01-26 03:01:08","1");
INSERT INTO audit_trail VALUES("6162","6","Gilbert Githitu","","Logged in to system","2022-01-26 04:18:00","2022-01-26 04:18:00","");
INSERT INTO audit_trail VALUES("6163","1","Admin Admin","","Logged in to system","2022-01-26 05:15:50","2022-01-26 05:15:50","");
INSERT INTO audit_trail VALUES("6164","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39595","2022-01-26 06:47:22","2022-01-26 06:47:22","1");
INSERT INTO audit_trail VALUES("6165","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39597","2022-01-26 06:48:51","2022-01-26 06:48:51","1");
INSERT INTO audit_trail VALUES("6166","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39599","2022-01-26 06:50:24","2022-01-26 06:50:24","1");
INSERT INTO audit_trail VALUES("6167","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39601","2022-01-26 06:51:43","2022-01-26 06:51:43","1");
INSERT INTO audit_trail VALUES("6168","6","Gilbert Githitu","","Logged in to system","2022-01-26 08:13:24","2022-01-26 08:13:24","");
INSERT INTO audit_trail VALUES("6169","1","Admin Admin","","Logged in to system","2022-01-26 08:55:41","2022-01-26 08:55:41","");
INSERT INTO audit_trail VALUES("6170","6","Gilbert Githitu","","Added expense with id:514","2022-01-26 10:57:01","2022-01-26 10:57:01","1");
INSERT INTO audit_trail VALUES("6171","6","Gilbert Githitu","","Added Capital  with id:1001","2022-01-27 02:13:33","2022-01-27 02:13:33","1");
INSERT INTO audit_trail VALUES("6172","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39699","2022-01-27 03:13:17","2022-01-27 03:13:17","1");
INSERT INTO audit_trail VALUES("6173","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39713","2022-01-27 03:52:44","2022-01-27 03:52:44","1");
INSERT INTO audit_trail VALUES("6174","6","Gilbert Githitu","","Logged in to system","2022-01-27 04:34:15","2022-01-27 04:34:15","");
INSERT INTO audit_trail VALUES("6175","1","Admin Admin","","Logged in to system","2022-01-27 04:58:30","2022-01-27 04:58:30","");
INSERT INTO audit_trail VALUES("6176","6","Gilbert Githitu","","Logged in to system","2022-01-27 07:20:28","2022-01-27 07:20:28","");
INSERT INTO audit_trail VALUES("6177","6","Gilbert Githitu","","Added expense with id:515","2022-01-27 11:13:49","2022-01-27 11:13:49","1");
INSERT INTO audit_trail VALUES("6178","6","Gilbert Githitu","","Added Capital  with id:1002","2022-01-28 02:32:43","2022-01-28 02:32:43","1");
INSERT INTO audit_trail VALUES("6179","6","Gilbert Githitu","","Added Capital  with id:1003","2022-01-28 03:25:06","2022-01-28 03:25:06","1");
INSERT INTO audit_trail VALUES("6180","6","Gilbert Githitu","","Logged in to system","2022-01-28 03:40:53","2022-01-28 03:40:53","");
INSERT INTO audit_trail VALUES("6181","6","Gilbert Githitu","","Logged in to system","2022-01-28 04:32:06","2022-01-28 04:32:06","");
INSERT INTO audit_trail VALUES("6182","6","Gilbert Githitu","","Logged in to system","2022-01-28 05:54:00","2022-01-28 05:54:00","");
INSERT INTO audit_trail VALUES("6183","6","Gilbert Githitu","","Logged in to system","2022-01-28 06:32:30","2022-01-28 06:32:30","");
INSERT INTO audit_trail VALUES("6184","6","Gilbert Githitu","","Logged in to system","2022-01-28 10:30:42","2022-01-28 10:30:42","");
INSERT INTO audit_trail VALUES("6185","6","Gilbert Githitu","","Logged in to system","2022-01-29 02:23:03","2022-01-29 02:23:03","");
INSERT INTO audit_trail VALUES("6186","6","Gilbert Githitu","","Added Capital  with id:1004","2022-01-29 02:27:09","2022-01-29 02:27:09","1");
INSERT INTO audit_trail VALUES("6187","6","Gilbert Githitu","","Added Capital  with id:1005","2022-01-29 03:05:08","2022-01-29 03:05:08","1");
INSERT INTO audit_trail VALUES("6188","6","Gilbert Githitu","","Added Capital  with id:1006","2022-01-29 03:08:17","2022-01-29 03:08:17","1");
INSERT INTO audit_trail VALUES("6189","6","Gilbert Githitu","","Added Capital  with id:1007","2022-01-29 03:10:01","2022-01-29 03:10:01","1");
INSERT INTO audit_trail VALUES("6190","6","Gilbert Githitu","","Added expense with id:516","2022-01-29 03:13:44","2022-01-29 03:13:44","1");
INSERT INTO audit_trail VALUES("6191","6","Gilbert Githitu","","Added Journal Manual Entry  with id:39966","2022-01-29 03:17:03","2022-01-29 03:17:03","1");
INSERT INTO audit_trail VALUES("6192","6","Gilbert Githitu","","Added Capital  with id:1008","2022-01-29 05:59:46","2022-01-29 05:59:46","1");
INSERT INTO audit_trail VALUES("6193","6","Gilbert Githitu","","Added Capital  with id:1009","2022-01-29 06:02:51","2022-01-29 06:02:51","1");
INSERT INTO audit_trail VALUES("6194","6","Gilbert Githitu","","Logged in to system","2022-01-29 07:00:28","2022-01-29 07:00:28","");
INSERT INTO audit_trail VALUES("6195","6","Gilbert Githitu","","Added expense with id:517","2022-01-29 07:04:59","2022-01-29 07:04:59","1");
INSERT INTO audit_trail VALUES("6196","6","Gilbert Githitu","","Logged in to system","2022-01-29 07:10:38","2022-01-29 07:10:38","");
INSERT INTO audit_trail VALUES("6197","6","Gilbert Githitu","","Added Capital  with id:1010","2022-01-29 07:12:02","2022-01-29 07:12:02","1");
INSERT INTO audit_trail VALUES("6198","6","Gilbert Githitu","","Added Capital  with id:1011","2022-01-29 07:12:43","2022-01-29 07:12:43","1");
INSERT INTO audit_trail VALUES("6199","6","Gilbert Githitu","","Logged out of system","2022-01-29 08:20:38","2022-01-29 08:20:38","1");
INSERT INTO audit_trail VALUES("6200","6","Gilbert Githitu","","Logged in to system","2022-01-31 02:38:31","2022-01-31 02:38:31","");
INSERT INTO audit_trail VALUES("6201","6","Gilbert Githitu","","Added Capital  with id:1012","2022-01-31 02:39:54","2022-01-31 02:39:54","1");
INSERT INTO audit_trail VALUES("6202","6","Gilbert Githitu","","Logged in to system","2022-01-31 02:42:39","2022-01-31 02:42:39","");
INSERT INTO audit_trail VALUES("6203","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40162","2022-01-31 03:57:15","2022-01-31 03:57:15","1");
INSERT INTO audit_trail VALUES("6204","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40168","2022-01-31 04:00:11","2022-01-31 04:00:11","1");
INSERT INTO audit_trail VALUES("6205","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40170","2022-01-31 04:01:49","2022-01-31 04:01:49","1");
INSERT INTO audit_trail VALUES("6206","6","Gilbert Githitu","","Logged in to system","2022-01-31 04:58:42","2022-01-31 04:58:42","");
INSERT INTO audit_trail VALUES("6207","6","Gilbert Githitu","","Logged in to system","2022-01-31 05:04:26","2022-01-31 05:04:26","");
INSERT INTO audit_trail VALUES("6208","6","Gilbert Githitu","","Logged in to system","2022-01-31 06:22:40","2022-01-31 06:22:40","");
INSERT INTO audit_trail VALUES("6209","6","Gilbert Githitu","","Added expense with id:518","2022-01-31 06:45:40","2022-01-31 06:45:40","1");
INSERT INTO audit_trail VALUES("6210","6","Gilbert Githitu","","Added expense with id:519","2022-01-31 06:46:26","2022-01-31 06:46:26","1");
INSERT INTO audit_trail VALUES("6211","6","Gilbert Githitu","","Logged in to system","2022-01-31 07:33:36","2022-01-31 07:33:36","");
INSERT INTO audit_trail VALUES("6212","6","Gilbert Githitu","","Logged in to system","2022-01-31 11:06:08","2022-01-31 11:06:08","");
INSERT INTO audit_trail VALUES("6213","6","Gilbert Githitu","","Logged out of system","2022-01-31 12:16:11","2022-01-31 12:16:11","1");
INSERT INTO audit_trail VALUES("6214","6","Gilbert Githitu","","Logged in to system","2022-01-31 12:16:47","2022-01-31 12:16:47","1");
INSERT INTO audit_trail VALUES("6215","6","Gilbert Githitu","","Logged in to system","2022-02-01 02:33:46","2022-02-01 02:33:46","1");
INSERT INTO audit_trail VALUES("6216","6","Gilbert Githitu","","Added Capital  with id:1013","2022-02-01 02:37:44","2022-02-01 02:37:44","1");
INSERT INTO audit_trail VALUES("6217","6","Gilbert Githitu","","Updated expense with id:519","2022-02-01 02:42:25","2022-02-01 02:42:25","1");
INSERT INTO audit_trail VALUES("6218","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40380","2022-02-01 02:47:50","2022-02-01 02:47:50","1");
INSERT INTO audit_trail VALUES("6219","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40396","2022-02-01 03:19:17","2022-02-01 03:19:17","1");
INSERT INTO audit_trail VALUES("6220","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40398","2022-02-01 03:38:48","2022-02-01 03:38:48","1");
INSERT INTO audit_trail VALUES("6221","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40400","2022-02-01 03:41:53","2022-02-01 03:41:53","1");
INSERT INTO audit_trail VALUES("6222","6","Gilbert Githitu","","Logged in to system","2022-02-01 04:11:13","2022-02-01 04:11:13","1");
INSERT INTO audit_trail VALUES("6223","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40440","2022-02-01 04:59:37","2022-02-01 04:59:37","1");
INSERT INTO audit_trail VALUES("6224","6","Gilbert Githitu","","Added Capital  with id:1014","2022-02-01 05:21:47","2022-02-01 05:21:47","1");
INSERT INTO audit_trail VALUES("6225","6","Gilbert Githitu","","Added Capital  with id:1015","2022-02-01 05:23:14","2022-02-01 05:23:14","1");
INSERT INTO audit_trail VALUES("6226","6","Gilbert Githitu","","Added expense with id:520","2022-02-01 05:33:42","2022-02-01 05:33:42","1");
INSERT INTO audit_trail VALUES("6227","6","Gilbert Githitu","","Logged in to system","2022-02-01 09:14:18","2022-02-01 09:14:18","");
INSERT INTO audit_trail VALUES("6228","6","Gilbert Githitu","","Added expense with id:521","2022-02-01 09:15:07","2022-02-01 09:15:07","1");
INSERT INTO audit_trail VALUES("6229","6","Gilbert Githitu","","Added expense with id:522","2022-02-01 09:16:09","2022-02-01 09:16:09","1");
INSERT INTO audit_trail VALUES("6230","6","Gilbert Githitu","","Added expense with id:523","2022-02-01 09:17:25","2022-02-01 09:17:25","1");
INSERT INTO audit_trail VALUES("6231","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40486","2022-02-01 09:24:19","2022-02-01 09:24:19","1");
INSERT INTO audit_trail VALUES("6232","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40488","2022-02-01 09:26:17","2022-02-01 09:26:17","1");
INSERT INTO audit_trail VALUES("6233","6","Gilbert Githitu","","Added Capital  with id:1016","2022-02-01 10:10:39","2022-02-01 10:10:39","1");
INSERT INTO audit_trail VALUES("6234","6","Gilbert Githitu","","Added Capital  with id:1017","2022-02-01 10:11:12","2022-02-01 10:11:12","1");
INSERT INTO audit_trail VALUES("6235","6","Gilbert Githitu","","Added Capital  with id:1018","2022-02-02 02:38:41","2022-02-02 02:38:41","1");
INSERT INTO audit_trail VALUES("6236","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40582","2022-02-02 02:44:44","2022-02-02 02:44:44","1");
INSERT INTO audit_trail VALUES("6237","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40584","2022-02-02 02:49:08","2022-02-02 02:49:08","1");
INSERT INTO audit_trail VALUES("6238","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40586","2022-02-02 02:50:35","2022-02-02 02:50:35","1");
INSERT INTO audit_trail VALUES("6239","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40588","2022-02-02 02:51:40","2022-02-02 02:51:40","1");
INSERT INTO audit_trail VALUES("6240","6","Gilbert Githitu","","Logged in to system","2022-02-02 04:10:55","2022-02-02 04:10:55","");
INSERT INTO audit_trail VALUES("6241","6","Gilbert Githitu","","Logged in to system","2022-02-02 04:30:48","2022-02-02 04:30:48","");
INSERT INTO audit_trail VALUES("6242","1","Admin Admin","","Logged in to system","2022-02-02 05:44:31","2022-02-02 05:44:31","");
INSERT INTO audit_trail VALUES("6243","6","Gilbert Githitu","","Logged in to system","2022-02-02 06:36:30","2022-02-02 06:36:30","");
INSERT INTO audit_trail VALUES("6244","6","Gilbert Githitu","","Logged in to system","2022-02-02 06:40:47","2022-02-02 06:40:47","");
INSERT INTO audit_trail VALUES("6245","6","Gilbert Githitu","","Logged in to system","2022-02-02 06:40:57","2022-02-02 06:40:57","1");
INSERT INTO audit_trail VALUES("6246","6","Gilbert Githitu","","Added Capital  with id:1019","2022-02-02 06:42:23","2022-02-02 06:42:23","1");
INSERT INTO audit_trail VALUES("6247","6","Gilbert Githitu","","Added Capital  with id:1020","2022-02-02 06:44:37","2022-02-02 06:44:37","1");
INSERT INTO audit_trail VALUES("6248","6","Gilbert Githitu","","Added expense with id:524","2022-02-02 06:47:24","2022-02-02 06:47:24","1");
INSERT INTO audit_trail VALUES("6249","6","Gilbert Githitu","","Added expense with id:525","2022-02-02 06:48:02","2022-02-02 06:48:02","1");
INSERT INTO audit_trail VALUES("6250","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40608","2022-02-02 06:51:13","2022-02-02 06:51:13","1");
INSERT INTO audit_trail VALUES("6251","6","Gilbert Githitu","","Logged in to system","2022-02-02 06:52:47","2022-02-02 06:52:47","");
INSERT INTO audit_trail VALUES("6252","6","Gilbert Githitu","","Added Capital  with id:1021","2022-02-02 06:55:22","2022-02-02 06:55:22","1");
INSERT INTO audit_trail VALUES("6253","6","Gilbert Githitu","","Added Capital  with id:1022","2022-02-03 02:21:53","2022-02-03 02:21:53","1");
INSERT INTO audit_trail VALUES("6254","1","Admin Admin","","Logged in to system","2022-02-03 04:54:46","2022-02-03 04:54:46","");
INSERT INTO audit_trail VALUES("6255","6","Gilbert Githitu","","Added expense with id:526","2022-02-03 11:13:09","2022-02-03 11:13:09","1");
INSERT INTO audit_trail VALUES("6256","6","Gilbert Githitu","","Logged out of system","2022-02-03 12:00:04","2022-02-03 12:00:04","1");
INSERT INTO audit_trail VALUES("6257","6","Gilbert Githitu","","Logged in to system","2022-02-04 02:16:28","2022-02-04 02:16:28","1");
INSERT INTO audit_trail VALUES("6258","6","Gilbert Githitu","","Logged in to system","2022-02-04 02:17:42","2022-02-04 02:17:42","1");
INSERT INTO audit_trail VALUES("6259","6","Gilbert Githitu","","Added Capital  with id:1023","2022-02-04 02:20:13","2022-02-04 02:20:13","1");
INSERT INTO audit_trail VALUES("6260","6","Gilbert Githitu","","Added Journal Manual Entry  with id:40793","2022-02-04 02:21:05","2022-02-04 02:21:05","1");
INSERT INTO audit_trail VALUES("6261","6","Gilbert Githitu","","Logged in to system","2022-02-04 08:20:45","2022-02-04 08:20:45","");
INSERT INTO audit_trail VALUES("6262","6","Gilbert Githitu","","Added Capital  with id:1024","2022-02-04 08:39:57","2022-02-04 08:39:57","1");
INSERT INTO audit_trail VALUES("6263","6","Gilbert Githitu","","Added Capital  with id:1025","2022-02-04 08:42:01","2022-02-04 08:42:01","1");
INSERT INTO audit_trail VALUES("6264","6","Gilbert Githitu","","Added Capital  with id:1026","2022-02-05 02:43:26","2022-02-05 02:43:26","1");
INSERT INTO audit_trail VALUES("6265","6","Gilbert Githitu","","Logged in to system","2022-02-05 03:06:28","2022-02-05 03:06:28","");
INSERT INTO audit_trail VALUES("6266","6","Gilbert Githitu","","Added Capital  with id:1027","2022-02-05 03:31:45","2022-02-05 03:31:45","1");
INSERT INTO audit_trail VALUES("6267","6","Gilbert Githitu","","Added Capital  with id:1028","2022-02-05 03:32:19","2022-02-05 03:32:19","1");
INSERT INTO audit_trail VALUES("6268","6","Gilbert Githitu","","Added loan with id:244","2022-02-05 03:38:00","2022-02-05 03:38:00","1");
INSERT INTO audit_trail VALUES("6269","6","Gilbert Githitu","","Approved loan with id:244","2022-02-05 03:38:36","2022-02-05 03:38:36","1");
INSERT INTO audit_trail VALUES("6270","6","Gilbert Githitu","","Disbursed loan with id:244","2022-02-05 03:38:51","2022-02-05 03:38:51","1");
INSERT INTO audit_trail VALUES("6271","6","Gilbert Githitu","","Added expense with id:527","2022-02-05 07:27:47","2022-02-05 07:27:47","1");
INSERT INTO audit_trail VALUES("6272","6","Gilbert Githitu","","Logged out of system","2022-02-05 07:46:52","2022-02-05 07:46:52","1");
INSERT INTO audit_trail VALUES("6273","6","Gilbert Githitu","","Logged in to system","2022-02-07 02:35:16","2022-02-07 02:35:16","");
INSERT INTO audit_trail VALUES("6274","6","Gilbert Githitu","","Added Capital  with id:1029","2022-02-07 02:36:53","2022-02-07 02:36:53","1");
INSERT INTO audit_trail VALUES("6275","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41017","2022-02-07 02:39:53","2022-02-07 02:39:53","1");
INSERT INTO audit_trail VALUES("6276","6","Gilbert Githitu","","Logged in to system","2022-02-07 02:42:00","2022-02-07 02:42:00","");
INSERT INTO audit_trail VALUES("6277","6","Gilbert Githitu","","Logged in to system","2022-02-07 02:51:58","2022-02-07 02:51:58","");
INSERT INTO audit_trail VALUES("6278","6","Gilbert Githitu","","Logged in to system","2022-02-07 03:17:36","2022-02-07 03:17:36","");
INSERT INTO audit_trail VALUES("6279","6","Gilbert Githitu","","Logged in to system","2022-02-07 04:07:14","2022-02-07 04:07:14","");
INSERT INTO audit_trail VALUES("6280","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41041","2022-02-07 09:35:09","2022-02-07 09:35:09","1");
INSERT INTO audit_trail VALUES("6281","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41049","2022-02-07 09:40:41","2022-02-07 09:40:41","1");
INSERT INTO audit_trail VALUES("6282","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41051","2022-02-07 09:42:33","2022-02-07 09:42:33","1");
INSERT INTO audit_trail VALUES("6283","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41053","2022-02-07 09:49:03","2022-02-07 09:49:03","1");
INSERT INTO audit_trail VALUES("6284","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41055","2022-02-07 09:55:37","2022-02-07 09:55:37","1");
INSERT INTO audit_trail VALUES("6285","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41057","2022-02-07 09:56:49","2022-02-07 09:56:49","1");
INSERT INTO audit_trail VALUES("6286","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41059","2022-02-07 09:58:25","2022-02-07 09:58:25","1");
INSERT INTO audit_trail VALUES("6287","6","Gilbert Githitu","","Logged in to system","2022-02-08 02:17:51","2022-02-08 02:17:51","");
INSERT INTO audit_trail VALUES("6288","6","Gilbert Githitu","","Added Capital  with id:1030","2022-02-08 02:23:57","2022-02-08 02:23:57","1");
INSERT INTO audit_trail VALUES("6289","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41173","2022-02-08 02:25:10","2022-02-08 02:25:10","1");
INSERT INTO audit_trail VALUES("6290","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41175","2022-02-08 02:27:19","2022-02-08 02:27:19","1");
INSERT INTO audit_trail VALUES("6291","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41177","2022-02-08 02:28:46","2022-02-08 02:28:46","1");
INSERT INTO audit_trail VALUES("6292","6","Gilbert Githitu","","Added Journal Manual Entry  with id:41179","2022-02-08 02:29:56","2022-02-08 02:29:56","1");
INSERT INTO audit_trail VALUES("6293","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-08 03:18:39","2022-02-08 03:18:39","");
INSERT INTO audit_trail VALUES("6294","6","Gilbert Githitu","","Logged in to system","2022-02-08 09:05:19","2022-02-08 09:05:19","");
INSERT INTO audit_trail VALUES("6295","6","Gilbert Githitu","","Added Capital  with id:1031","2022-02-08 11:15:57","2022-02-08 11:15:57","1");
INSERT INTO audit_trail VALUES("6296","6","Gilbert Githitu","","Added Capital  with id:1032","2022-02-08 11:17:48","2022-02-08 11:17:48","1");
INSERT INTO audit_trail VALUES("6297","6","Gilbert Githitu","","Added expense with id:528","2022-02-08 11:19:35","2022-02-08 11:19:35","1");
INSERT INTO audit_trail VALUES("6298","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1033","2022-02-08 11:20:12","2022-02-08 11:20:12","1");
INSERT INTO audit_trail VALUES("6299","6","Gilbert Githitu","","Added expense with id:529","2022-02-08 11:20:42","2022-02-08 11:20:42","1");
INSERT INTO audit_trail VALUES("6300","6","Gilbert Githitu","","Added expense with id:530","2022-02-08 11:22:52","2022-02-08 11:22:52","1");
INSERT INTO audit_trail VALUES("6301","6","Gilbert Githitu","","Added Capital  with id:1034","2022-02-09 02:20:45","2022-02-09 02:20:45","1");
INSERT INTO audit_trail VALUES("6302","2","CECILIA WANJERI WANGUHU","","Added loan with id:245","2022-02-09 02:46:08","2022-02-09 02:46:08","1");
INSERT INTO audit_trail VALUES("6303","2","CECILIA WANJERI WANGUHU","","Approved loan with id:245","2022-02-09 02:46:37","2022-02-09 02:46:37","1");
INSERT INTO audit_trail VALUES("6304","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:245","2022-02-09 02:46:55","2022-02-09 02:46:55","1");
INSERT INTO audit_trail VALUES("6305","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-09 06:19:47","2022-02-09 06:19:47","");
INSERT INTO audit_trail VALUES("6306","6","Gilbert Githitu","","Added Capital  with id:1035","2022-02-09 06:28:06","2022-02-09 06:28:06","1");
INSERT INTO audit_trail VALUES("6307","6","Gilbert Githitu","","Added Capital  with id:1036","2022-02-09 06:28:48","2022-02-09 06:28:48","1");
INSERT INTO audit_trail VALUES("6308","6","Gilbert Githitu","","Updated Capital  with id:1035","2022-02-09 06:29:11","2022-02-09 06:29:11","1");
INSERT INTO audit_trail VALUES("6309","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:41345","2022-02-09 06:34:48","2022-02-09 06:34:48","1");
INSERT INTO audit_trail VALUES("6310","6","Gilbert Githitu","","Added expense with id:531","2022-02-09 06:42:30","2022-02-09 06:42:30","1");
INSERT INTO audit_trail VALUES("6311","6","Gilbert Githitu","","Added expense with id:532","2022-02-09 06:43:23","2022-02-09 06:43:23","1");
INSERT INTO audit_trail VALUES("6312","6","Gilbert Githitu","","Added expense with id:533","2022-02-09 09:18:52","2022-02-09 09:18:52","1");
INSERT INTO audit_trail VALUES("6313","6","Gilbert Githitu","","Added Capital  with id:1037","2022-02-10 02:28:20","2022-02-10 02:28:20","1");
INSERT INTO audit_trail VALUES("6314","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-10 03:05:10","2022-02-10 03:05:10","");
INSERT INTO audit_trail VALUES("6315","6","Gilbert Githitu","","Added Capital  with id:1038","2022-02-10 04:05:55","2022-02-10 04:05:55","1");
INSERT INTO audit_trail VALUES("6316","6","Gilbert Githitu","","Added expense with id:534","2022-02-10 11:46:24","2022-02-10 11:46:24","1");
INSERT INTO audit_trail VALUES("6317","6","Gilbert Githitu","","Logged out of system","2022-02-10 12:05:07","2022-02-10 12:05:07","1");
INSERT INTO audit_trail VALUES("6318","6","Gilbert Githitu","","Logged in to system","2022-02-10 13:50:48","2022-02-10 13:50:48","1");
INSERT INTO audit_trail VALUES("6319","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-11 02:22:17","2022-02-11 02:22:17","1");
INSERT INTO audit_trail VALUES("6320","6","Gilbert Githitu","","Added Capital  with id:1039","2022-02-11 02:22:35","2022-02-11 02:22:35","1");
INSERT INTO audit_trail VALUES("6321","6","Gilbert Githitu","","Added Capital  with id:1040","2022-02-11 10:25:41","2022-02-11 10:25:41","1");
INSERT INTO audit_trail VALUES("6322","6","Gilbert Githitu","","Added Capital  with id:1041","2022-02-11 10:26:37","2022-02-11 10:26:37","1");
INSERT INTO audit_trail VALUES("6323","6","Gilbert Githitu","","Added expense with id:535","2022-02-11 10:43:13","2022-02-11 10:43:13","1");
INSERT INTO audit_trail VALUES("6324","6","Gilbert Githitu","","Updated expense with id:535","2022-02-11 11:43:58","2022-02-11 11:43:58","1");
INSERT INTO audit_trail VALUES("6325","6","Gilbert Githitu","","Added expense with id:536","2022-02-11 11:46:28","2022-02-11 11:46:28","1");
INSERT INTO audit_trail VALUES("6326","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-12 02:43:31","2022-02-12 02:43:31","");
INSERT INTO audit_trail VALUES("6327","6","Gilbert Githitu","","Added Capital  with id:1042","2022-02-12 02:48:55","2022-02-12 02:48:55","1");
INSERT INTO audit_trail VALUES("6328","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1043","2022-02-12 03:03:44","2022-02-12 03:03:44","1");
INSERT INTO audit_trail VALUES("6329","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1044","2022-02-12 03:17:58","2022-02-12 03:17:58","1");
INSERT INTO audit_trail VALUES("6330","6","Gilbert Githitu","","Added expense with id:537","2022-02-12 07:48:47","2022-02-12 07:48:47","1");
INSERT INTO audit_trail VALUES("6331","6","Gilbert Githitu","","Added expense with id:538","2022-02-12 08:29:28","2022-02-12 08:29:28","1");
INSERT INTO audit_trail VALUES("6332","6","Gilbert Githitu","","Added expense with id:539","2022-02-12 08:49:08","2022-02-12 08:49:08","1");
INSERT INTO audit_trail VALUES("6333","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-02-12 09:28:13","2022-02-12 09:28:13","1");
INSERT INTO audit_trail VALUES("6334","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-12 09:28:51","2022-02-12 09:28:51","1");
INSERT INTO audit_trail VALUES("6335","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-02-12 09:29:25","2022-02-12 09:29:25","1");
INSERT INTO audit_trail VALUES("6336","1","Admin Admin","","Logged in to system","2022-02-28 07:50:05","2022-02-28 07:50:05","");
INSERT INTO audit_trail VALUES("6337","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-28 08:08:58","2022-02-28 08:08:58","");
INSERT INTO audit_trail VALUES("6338","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-28 08:14:24","2022-02-28 08:14:24","");
INSERT INTO audit_trail VALUES("6339","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1045","2022-02-28 08:16:08","2022-02-28 08:16:08","1");
INSERT INTO audit_trail VALUES("6340","6","Gilbert Githitu","","Logged in to system","2022-02-28 08:49:17","2022-02-28 08:49:17","");
INSERT INTO audit_trail VALUES("6341","6","Gilbert Githitu","","Added Capital  with id:1046","2022-02-28 08:51:09","2022-02-28 08:51:09","1");
INSERT INTO audit_trail VALUES("6342","6","Gilbert Githitu","","Added expense with id:540","2022-02-28 08:52:44","2022-02-28 08:52:44","1");
INSERT INTO audit_trail VALUES("6343","6","Gilbert Githitu","","Added expense with id:541","2022-02-28 08:53:55","2022-02-28 08:53:55","1");
INSERT INTO audit_trail VALUES("6344","6","Gilbert Githitu","","Added expense with id:542","2022-02-28 08:56:19","2022-02-28 08:56:19","1");
INSERT INTO audit_trail VALUES("6345","6","Gilbert Githitu","","Added expense with id:543","2022-02-28 08:57:33","2022-02-28 08:57:33","1");
INSERT INTO audit_trail VALUES("6346","6","Gilbert Githitu","","Added expense with id:544","2022-02-28 09:01:09","2022-02-28 09:01:09","1");
INSERT INTO audit_trail VALUES("6347","2","CECILIA WANJERI WANGUHU","","Added expense with id:545","2022-02-28 09:01:17","2022-02-28 09:01:17","1");
INSERT INTO audit_trail VALUES("6348","2","CECILIA WANJERI WANGUHU","","Added expense with id:546","2022-02-28 09:01:52","2022-02-28 09:01:52","1");
INSERT INTO audit_trail VALUES("6349","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1047","2022-02-28 09:05:41","2022-02-28 09:05:41","1");
INSERT INTO audit_trail VALUES("6350","2","CECILIA WANJERI WANGUHU","","Added expense with id:547","2022-02-28 09:49:11","2022-02-28 09:49:11","1");
INSERT INTO audit_trail VALUES("6351","6","Gilbert Githitu","","Added Capital  with id:1048","2022-02-28 10:11:29","2022-02-28 10:11:29","1");
INSERT INTO audit_trail VALUES("6352","6","Gilbert Githitu","","Added expense with id:548","2022-02-28 10:44:16","2022-02-28 10:44:16","1");
INSERT INTO audit_trail VALUES("6353","6","Gilbert Githitu","","Added Capital  with id:1049","2022-02-28 10:54:54","2022-02-28 10:54:54","1");
INSERT INTO audit_trail VALUES("6354","6","Gilbert Githitu","","Added Capital  with id:1050","2022-02-28 10:56:44","2022-02-28 10:56:44","1");
INSERT INTO audit_trail VALUES("6355","6","Gilbert Githitu","","Added Capital  with id:1051","2022-02-28 11:01:03","2022-02-28 11:01:03","1");
INSERT INTO audit_trail VALUES("6356","6","Gilbert Githitu","","Added expense with id:549","2022-02-28 11:24:13","2022-02-28 11:24:13","1");
INSERT INTO audit_trail VALUES("6357","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-02-28 11:25:46","2022-02-28 11:25:46","");
INSERT INTO audit_trail VALUES("6358","6","Gilbert Githitu","","Updated Capital  with id:1049","2022-02-28 11:28:49","2022-02-28 11:28:49","1");
INSERT INTO audit_trail VALUES("6359","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-02-28 11:58:43","2022-02-28 11:58:43","1");
INSERT INTO audit_trail VALUES("6360","6","Gilbert Githitu","","Logged in to system","2022-03-01 02:26:02","2022-03-01 02:26:02","");
INSERT INTO audit_trail VALUES("6361","6","Gilbert Githitu","","Logged in to system","2022-03-01 02:27:49","2022-03-01 02:27:49","1");
INSERT INTO audit_trail VALUES("6362","6","Gilbert Githitu","","Logged out of system","2022-03-01 02:28:06","2022-03-01 02:28:06","1");
INSERT INTO audit_trail VALUES("6363","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-01 02:28:18","2022-03-01 02:28:18","1");
INSERT INTO audit_trail VALUES("6364","6","Gilbert Githitu","","Logged in to system","2022-03-01 02:29:54","2022-03-01 02:29:54","1");
INSERT INTO audit_trail VALUES("6365","6","Gilbert Githitu","","Added Capital  with id:1052","2022-03-01 02:33:00","2022-03-01 02:33:00","1");
INSERT INTO audit_trail VALUES("6366","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:1049","2022-03-01 02:47:26","2022-03-01 02:47:26","1");
INSERT INTO audit_trail VALUES("6367","6","Gilbert Githitu","","Added Capital  with id:1053","2022-03-01 02:48:22","2022-03-01 02:48:22","1");
INSERT INTO audit_trail VALUES("6368","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:1049","2022-03-01 02:48:34","2022-03-01 02:48:34","1");
INSERT INTO audit_trail VALUES("6369","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-01 02:54:05","2022-03-01 02:54:05","1");
INSERT INTO audit_trail VALUES("6370","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-01 02:54:51","2022-03-01 02:54:51","1");
INSERT INTO audit_trail VALUES("6371","6","Gilbert Githitu","","Added expense with id:550","2022-03-01 03:03:43","2022-03-01 03:03:43","1");
INSERT INTO audit_trail VALUES("6372","6","Gilbert Githitu","","Added Capital  with id:1054","2022-03-01 03:47:50","2022-03-01 03:47:50","1");
INSERT INTO audit_trail VALUES("6373","6","Gilbert Githitu","","Added expense with id:551","2022-03-01 03:48:54","2022-03-01 03:48:54","1");
INSERT INTO audit_trail VALUES("6374","6","Gilbert Githitu","","Updated expense with id:551","2022-03-01 03:49:42","2022-03-01 03:49:42","1");
INSERT INTO audit_trail VALUES("6375","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1055","2022-03-01 04:16:26","2022-03-01 04:16:26","1");
INSERT INTO audit_trail VALUES("6376","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1056","2022-03-01 04:18:31","2022-03-01 04:18:31","1");
INSERT INTO audit_trail VALUES("6377","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1057","2022-03-01 05:20:38","2022-03-01 05:20:38","1");
INSERT INTO audit_trail VALUES("6378","2","CECILIA WANJERI WANGUHU","","Added expense with id:552","2022-03-01 05:21:46","2022-03-01 05:21:46","1");
INSERT INTO audit_trail VALUES("6379","2","CECILIA WANJERI WANGUHU","","Added expense with id:553","2022-03-01 05:25:21","2022-03-01 05:25:21","1");
INSERT INTO audit_trail VALUES("6380","2","CECILIA WANJERI WANGUHU","","Added expense with id:554","2022-03-01 05:29:30","2022-03-01 05:29:30","1");
INSERT INTO audit_trail VALUES("6381","6","Gilbert Githitu","","Added Capital  with id:1058","2022-03-01 05:29:31","2022-03-01 05:29:31","1");
INSERT INTO audit_trail VALUES("6382","2","CECILIA WANJERI WANGUHU","","Added expense with id:555","2022-03-01 05:34:58","2022-03-01 05:34:58","1");
INSERT INTO audit_trail VALUES("6383","2","CECILIA WANJERI WANGUHU","","Added expense with id:556","2022-03-01 05:38:59","2022-03-01 05:38:59","1");
INSERT INTO audit_trail VALUES("6384","6","Gilbert Githitu","","Added expense with id:557","2022-03-01 05:54:57","2022-03-01 05:54:57","1");
INSERT INTO audit_trail VALUES("6385","6","Gilbert Githitu","","Added expense with id:558","2022-03-01 05:56:06","2022-03-01 05:56:06","1");
INSERT INTO audit_trail VALUES("6386","6","Gilbert Githitu","","Updated Capital  with id:1058","2022-03-01 05:57:10","2022-03-01 05:57:10","1");
INSERT INTO audit_trail VALUES("6387","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1059","2022-03-01 06:23:42","2022-03-01 06:23:42","1");
INSERT INTO audit_trail VALUES("6388","6","Gilbert Githitu","","Added Capital  with id:1060","2022-03-01 07:11:14","2022-03-01 07:11:14","1");
INSERT INTO audit_trail VALUES("6389","6","Gilbert Githitu","","Added expense with id:559","2022-03-01 09:05:51","2022-03-01 09:05:51","1");
INSERT INTO audit_trail VALUES("6390","2","CECILIA WANJERI WANGUHU","","Added expense with id:560","2022-03-01 09:45:15","2022-03-01 09:45:15","1");
INSERT INTO audit_trail VALUES("6391","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1061","2022-03-01 09:46:33","2022-03-01 09:46:33","1");
INSERT INTO audit_trail VALUES("6392","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-01 11:45:30","2022-03-01 11:45:30","1");
INSERT INTO audit_trail VALUES("6393","6","Gilbert Githitu","","Added Capital  with id:1062","2022-03-02 02:30:17","2022-03-02 02:30:17","1");
INSERT INTO audit_trail VALUES("6394","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-02 03:43:37","2022-03-02 03:43:37","1");
INSERT INTO audit_trail VALUES("6395","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43339","2022-03-02 04:44:20","2022-03-02 04:44:20","1");
INSERT INTO audit_trail VALUES("6396","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43343","2022-03-02 04:46:33","2022-03-02 04:46:33","1");
INSERT INTO audit_trail VALUES("6397","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43347","2022-03-02 04:49:48","2022-03-02 04:49:48","1");
INSERT INTO audit_trail VALUES("6398","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43351","2022-03-02 04:52:48","2022-03-02 04:52:48","1");
INSERT INTO audit_trail VALUES("6399","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43355","2022-03-02 04:56:30","2022-03-02 04:56:30","1");
INSERT INTO audit_trail VALUES("6400","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43359","2022-03-02 05:01:16","2022-03-02 05:01:16","1");
INSERT INTO audit_trail VALUES("6401","6","Gilbert Githitu","","Added Journal Manual Entry  with id:43363","2022-03-02 05:25:27","2022-03-02 05:25:27","1");
INSERT INTO audit_trail VALUES("6402","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43365","2022-03-02 05:25:28","2022-03-02 05:25:28","1");
INSERT INTO audit_trail VALUES("6403","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1063","2022-03-02 05:28:47","2022-03-02 05:28:47","1");
INSERT INTO audit_trail VALUES("6404","6","Gilbert Githitu","","Added Journal Manual Entry  with id:43369","2022-03-02 05:30:17","2022-03-02 05:30:17","1");
INSERT INTO audit_trail VALUES("6405","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1064","2022-03-02 05:32:21","2022-03-02 05:32:21","1");
INSERT INTO audit_trail VALUES("6406","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1065","2022-03-02 05:34:41","2022-03-02 05:34:41","1");
INSERT INTO audit_trail VALUES("6407","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1066","2022-03-02 05:35:35","2022-03-02 05:35:35","1");
INSERT INTO audit_trail VALUES("6408","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1067","2022-03-02 05:36:57","2022-03-02 05:36:57","1");
INSERT INTO audit_trail VALUES("6409","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1068","2022-03-02 05:37:54","2022-03-02 05:37:54","1");
INSERT INTO audit_trail VALUES("6410","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1069","2022-03-02 05:38:53","2022-03-02 05:38:53","1");
INSERT INTO audit_trail VALUES("6411","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1070","2022-03-02 05:39:42","2022-03-02 05:39:42","1");
INSERT INTO audit_trail VALUES("6412","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1071","2022-03-02 05:40:33","2022-03-02 05:40:33","1");
INSERT INTO audit_trail VALUES("6413","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1072","2022-03-02 05:42:39","2022-03-02 05:42:39","1");
INSERT INTO audit_trail VALUES("6414","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1073","2022-03-02 05:43:31","2022-03-02 05:43:31","1");
INSERT INTO audit_trail VALUES("6415","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1074","2022-03-02 05:44:38","2022-03-02 05:44:38","1");
INSERT INTO audit_trail VALUES("6416","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1075","2022-03-02 05:45:32","2022-03-02 05:45:32","1");
INSERT INTO audit_trail VALUES("6417","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1076","2022-03-02 05:46:52","2022-03-02 05:46:52","1");
INSERT INTO audit_trail VALUES("6418","6","Gilbert Githitu","","Added expense with id:561","2022-03-02 10:32:18","2022-03-02 10:32:18","1");
INSERT INTO audit_trail VALUES("6419","6","Gilbert Githitu","","Added expense with id:562","2022-03-02 10:33:18","2022-03-02 10:33:18","1");
INSERT INTO audit_trail VALUES("6420","6","Gilbert Githitu","","Added expense with id:563","2022-03-02 10:34:09","2022-03-02 10:34:09","1");
INSERT INTO audit_trail VALUES("6421","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-02 11:27:34","2022-03-02 11:27:34","1");
INSERT INTO audit_trail VALUES("6422","6","Gilbert Githitu","","Added Capital  with id:1077","2022-03-03 02:34:47","2022-03-03 02:34:47","1");
INSERT INTO audit_trail VALUES("6423","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-03 03:02:59","2022-03-03 03:02:59","1");
INSERT INTO audit_trail VALUES("6424","1","Admin Admin","","Logged in to system","2022-03-03 04:27:54","2022-03-03 04:27:54","");
INSERT INTO audit_trail VALUES("6425","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1078","2022-03-03 09:49:28","2022-03-03 09:49:28","1");
INSERT INTO audit_trail VALUES("6426","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-03 11:12:42","2022-03-03 11:12:42","");
INSERT INTO audit_trail VALUES("6427","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-03 11:36:57","2022-03-03 11:36:57","");
INSERT INTO audit_trail VALUES("6428","2","CECILIA WANJERI WANGUHU","","Added expense with id:564","2022-03-03 11:40:52","2022-03-03 11:40:52","1");
INSERT INTO audit_trail VALUES("6429","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-03 11:44:58","2022-03-03 11:44:58","");
INSERT INTO audit_trail VALUES("6430","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-03 11:45:12","2022-03-03 11:45:12","1");
INSERT INTO audit_trail VALUES("6431","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-03 11:50:00","2022-03-03 11:50:00","1");
INSERT INTO audit_trail VALUES("6432","6","Gilbert Githitu","","Added Journal Manual Entry  with id:43643","2022-03-03 12:00:52","2022-03-03 12:00:52","1");
INSERT INTO audit_trail VALUES("6433","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-03 12:37:34","2022-03-03 12:37:34","1");
INSERT INTO audit_trail VALUES("6434","6","Gilbert Githitu","","Added Capital  with id:1079","2022-03-04 02:28:46","2022-03-04 02:28:46","1");
INSERT INTO audit_trail VALUES("6435","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-04 02:29:15","2022-03-04 02:29:15","1");
INSERT INTO audit_trail VALUES("6436","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-04 02:36:59","2022-03-04 02:36:59","1");
INSERT INTO audit_trail VALUES("6437","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43903","2022-03-04 04:45:55","2022-03-04 04:45:55","1");
INSERT INTO audit_trail VALUES("6438","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:43907","2022-03-04 04:49:10","2022-03-04 04:49:10","1");
INSERT INTO audit_trail VALUES("6439","6","Gilbert Githitu","","Added Capital  with id:1080","2022-03-04 09:29:51","2022-03-04 09:29:51","1");
INSERT INTO audit_trail VALUES("6440","6","Gilbert Githitu","","Added Capital  with id:1081","2022-03-04 09:31:18","2022-03-04 09:31:18","1");
INSERT INTO audit_trail VALUES("6441","6","Gilbert Githitu","","Added expense with id:565","2022-03-04 09:34:51","2022-03-04 09:34:51","1");
INSERT INTO audit_trail VALUES("6442","2","CECILIA WANJERI WANGUHU","","Added expense with id:566","2022-03-04 10:57:44","2022-03-04 10:57:44","1");
INSERT INTO audit_trail VALUES("6443","6","Gilbert Githitu","","Added expense with id:567","2022-03-04 11:08:03","2022-03-04 11:08:03","1");
INSERT INTO audit_trail VALUES("6444","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-04 11:26:06","2022-03-04 11:26:06","1");
INSERT INTO audit_trail VALUES("6445","6","Gilbert Githitu","","Updated Capital  with id:1080","2022-03-04 11:33:27","2022-03-04 11:33:27","1");
INSERT INTO audit_trail VALUES("6446","6","Gilbert Githitu","","Added Capital  with id:1082","2022-03-05 02:25:59","2022-03-05 02:25:59","1");
INSERT INTO audit_trail VALUES("6447","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-05 02:59:03","2022-03-05 02:59:03","1");
INSERT INTO audit_trail VALUES("6448","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-05 03:01:51","2022-03-05 03:01:51","");
INSERT INTO audit_trail VALUES("6449","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1083","2022-03-05 05:04:38","2022-03-05 05:04:38","1");
INSERT INTO audit_trail VALUES("6450","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-05 07:12:24","2022-03-05 07:12:24","1");
INSERT INTO audit_trail VALUES("6451","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-07 03:21:05","2022-03-07 03:21:05","");
INSERT INTO audit_trail VALUES("6452","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1084","2022-03-07 03:22:40","2022-03-07 03:22:40","1");
INSERT INTO audit_trail VALUES("6453","6","Gilbert Githitu","","Logged in to system","2022-03-07 03:55:09","2022-03-07 03:55:09","");
INSERT INTO audit_trail VALUES("6454","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-07 04:03:02","2022-03-07 04:03:02","");
INSERT INTO audit_trail VALUES("6455","6","Gilbert Githitu","","Added Journal Manual Entry  with id:44125","2022-03-07 04:09:46","2022-03-07 04:09:46","1");
INSERT INTO audit_trail VALUES("6456","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1085","2022-03-07 06:40:18","2022-03-07 06:40:18","1");
INSERT INTO audit_trail VALUES("6457","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:44157","2022-03-07 06:50:32","2022-03-07 06:50:32","1");
INSERT INTO audit_trail VALUES("6458","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:44161","2022-03-07 06:58:15","2022-03-07 06:58:15","1");
INSERT INTO audit_trail VALUES("6459","6","Gilbert Githitu","","Added Journal Manual Entry  with id:44177","2022-03-07 07:10:55","2022-03-07 07:10:55","1");
INSERT INTO audit_trail VALUES("6460","6","Gilbert Githitu","","Added Journal Manual Entry  with id:44187","2022-03-07 07:15:02","2022-03-07 07:15:02","1");
INSERT INTO audit_trail VALUES("6461","6","Gilbert Githitu","","Added Journal Manual Entry  with id:44193","2022-03-07 07:18:39","2022-03-07 07:18:39","1");
INSERT INTO audit_trail VALUES("6462","6","Gilbert Githitu","","Added Journal Manual Entry  with id:44195","2022-03-07 07:21:45","2022-03-07 07:21:45","1");
INSERT INTO audit_trail VALUES("6463","1","Admin Admin","","Logged in to system","2022-03-07 10:33:33","2022-03-07 10:33:33","");
INSERT INTO audit_trail VALUES("6464","2","CECILIA WANJERI WANGUHU","","Added expense with id:568","2022-03-07 10:46:07","2022-03-07 10:46:07","1");
INSERT INTO audit_trail VALUES("6465","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-07 11:19:37","2022-03-07 11:19:37","1");
INSERT INTO audit_trail VALUES("6466","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-08 02:26:08","2022-03-08 02:26:08","1");
INSERT INTO audit_trail VALUES("6467","6","Gilbert Githitu","","Added Capital  with id:1086","2022-03-08 02:41:32","2022-03-08 02:41:32","1");
INSERT INTO audit_trail VALUES("6468","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-08 03:04:19","2022-03-08 03:04:19","");
INSERT INTO audit_trail VALUES("6469","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:643","2022-03-08 03:40:06","2022-03-08 03:40:06","1");
INSERT INTO audit_trail VALUES("6470","6","Gilbert Githitu","","Added Capital  with id:1087","2022-03-08 04:40:46","2022-03-08 04:40:46","1");
INSERT INTO audit_trail VALUES("6471","6","Gilbert Githitu","","Added Capital  with id:1088","2022-03-08 04:43:19","2022-03-08 04:43:19","1");
INSERT INTO audit_trail VALUES("6472","6","Gilbert Githitu","","Updated expense with id:495","2022-03-08 05:11:44","2022-03-08 05:11:44","1");
INSERT INTO audit_trail VALUES("6473","6","Gilbert Githitu","","Added Journal Manual Entry  with id:44313","2022-03-08 05:17:58","2022-03-08 05:17:58","1");
INSERT INTO audit_trail VALUES("6474","2","CECILIA WANJERI WANGUHU","","Added expense with id:569","2022-03-08 05:58:35","2022-03-08 05:58:35","1");
INSERT INTO audit_trail VALUES("6475","2","CECILIA WANJERI WANGUHU","","Added expense with id:570","2022-03-08 05:59:27","2022-03-08 05:59:27","1");
INSERT INTO audit_trail VALUES("6476","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1089","2022-03-08 06:00:26","2022-03-08 06:00:26","1");
INSERT INTO audit_trail VALUES("6477","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1090","2022-03-08 06:01:30","2022-03-08 06:01:30","1");
INSERT INTO audit_trail VALUES("6478","6","Gilbert Githitu","","Logged in to system","2022-03-08 09:59:03","2022-03-08 09:59:03","");
INSERT INTO audit_trail VALUES("6479","6","Gilbert Githitu","","Logged in to system","2022-03-09 06:13:36","2022-03-09 06:13:36","");
INSERT INTO audit_trail VALUES("6480","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-09 06:28:34","2022-03-09 06:28:34","");
INSERT INTO audit_trail VALUES("6481","2","CECILIA WANJERI WANGUHU","","Added loan with id:246","2022-03-09 06:44:26","2022-03-09 06:44:26","1");
INSERT INTO audit_trail VALUES("6482","2","CECILIA WANJERI WANGUHU","","Approved loan with id:246","2022-03-09 06:45:20","2022-03-09 06:45:20","1");
INSERT INTO audit_trail VALUES("6483","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:246","2022-03-09 06:45:43","2022-03-09 06:45:43","1");
INSERT INTO audit_trail VALUES("6484","6","Gilbert Githitu","","Added Capital  with id:1091","2022-03-09 06:50:10","2022-03-09 06:50:10","1");
INSERT INTO audit_trail VALUES("6485","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:44437","2022-03-09 06:50:19","2022-03-09 06:50:19","1");
INSERT INTO audit_trail VALUES("6486","2","CECILIA WANJERI WANGUHU","","Added loan with id:247","2022-03-09 07:00:07","2022-03-09 07:00:07","1");
INSERT INTO audit_trail VALUES("6487","2","CECILIA WANJERI WANGUHU","","Approved loan with id:247","2022-03-09 07:01:31","2022-03-09 07:01:31","1");
INSERT INTO audit_trail VALUES("6488","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:247","2022-03-09 07:01:46","2022-03-09 07:01:46","1");
INSERT INTO audit_trail VALUES("6489","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:44451","2022-03-09 07:07:36","2022-03-09 07:07:36","1");
INSERT INTO audit_trail VALUES("6490","2","CECILIA WANJERI WANGUHU","","Added expense with id:571","2022-03-09 07:15:21","2022-03-09 07:15:21","1");
INSERT INTO audit_trail VALUES("6491","2","CECILIA WANJERI WANGUHU","","Added expense with id:572","2022-03-09 07:16:27","2022-03-09 07:16:27","1");
INSERT INTO audit_trail VALUES("6492","2","CECILIA WANJERI WANGUHU","","Added expense with id:573","2022-03-09 07:17:17","2022-03-09 07:17:17","1");
INSERT INTO audit_trail VALUES("6493","2","CECILIA WANJERI WANGUHU","","Added expense with id:574","2022-03-09 07:18:21","2022-03-09 07:18:21","1");
INSERT INTO audit_trail VALUES("6494","2","CECILIA WANJERI WANGUHU","","Added expense with id:575","2022-03-09 07:19:30","2022-03-09 07:19:30","1");
INSERT INTO audit_trail VALUES("6495","6","Gilbert Githitu","","Added expense with id:576","2022-03-09 07:20:03","2022-03-09 07:20:03","1");
INSERT INTO audit_trail VALUES("6496","6","Gilbert Githitu","","Added Capital  with id:1092","2022-03-10 02:48:44","2022-03-10 02:48:44","1");
INSERT INTO audit_trail VALUES("6497","2","CECILIA WANJERI WANGUHU","","Added borrower  with id:644","2022-03-10 04:40:00","2022-03-10 04:40:00","1");
INSERT INTO audit_trail VALUES("6498","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-10 05:15:59","2022-03-10 05:15:59","");
INSERT INTO audit_trail VALUES("6499","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-10 05:22:19","2022-03-10 05:22:19","1");
INSERT INTO audit_trail VALUES("6500","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1093","2022-03-10 05:26:10","2022-03-10 05:26:10","1");
INSERT INTO audit_trail VALUES("6501","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1094","2022-03-10 05:29:58","2022-03-10 05:29:58","1");
INSERT INTO audit_trail VALUES("6502","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:44603","2022-03-10 05:40:38","2022-03-10 05:40:38","1");
INSERT INTO audit_trail VALUES("6503","2","CECILIA WANJERI WANGUHU","","Added loan with id:248","2022-03-10 06:26:24","2022-03-10 06:26:24","1");
INSERT INTO audit_trail VALUES("6504","2","CECILIA WANJERI WANGUHU","","Approved loan with id:248","2022-03-10 06:27:11","2022-03-10 06:27:11","1");
INSERT INTO audit_trail VALUES("6505","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:248","2022-03-10 06:27:39","2022-03-10 06:27:39","1");
INSERT INTO audit_trail VALUES("6506","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:44617","2022-03-10 06:34:16","2022-03-10 06:34:16","1");
INSERT INTO audit_trail VALUES("6507","2","CECILIA WANJERI WANGUHU","","Added Journal Manual Entry  with id:44627","2022-03-10 06:39:04","2022-03-10 06:39:04","1");
INSERT INTO audit_trail VALUES("6508","6","Gilbert Githitu","","Added expense with id:577","2022-03-10 10:37:49","2022-03-10 10:37:49","1");
INSERT INTO audit_trail VALUES("6509","6","Gilbert Githitu","","Added Capital  with id:1095","2022-03-10 10:41:06","2022-03-10 10:41:06","1");
INSERT INTO audit_trail VALUES("6510","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-10 11:23:35","2022-03-10 11:23:35","");
INSERT INTO audit_trail VALUES("6511","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-10 11:26:28","2022-03-10 11:26:28","");
INSERT INTO audit_trail VALUES("6512","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-10 11:34:07","2022-03-10 11:34:07","");
INSERT INTO audit_trail VALUES("6513","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-10 11:36:15","2022-03-10 11:36:15","");
INSERT INTO audit_trail VALUES("6514","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-11 02:20:29","2022-03-11 02:20:29","");
INSERT INTO audit_trail VALUES("6515","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1096","2022-03-11 02:23:05","2022-03-11 02:23:05","1");
INSERT INTO audit_trail VALUES("6516","2","CECILIA WANJERI WANGUHU","","Updated Capital  with id:1094","2022-03-11 02:41:44","2022-03-11 02:41:44","1");
INSERT INTO audit_trail VALUES("6517","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1097","2022-03-11 05:43:30","2022-03-11 05:43:30","1");
INSERT INTO audit_trail VALUES("6518","2","CECILIA WANJERI WANGUHU","","Added expense with id:578","2022-03-11 05:46:13","2022-03-11 05:46:13","1");
INSERT INTO audit_trail VALUES("6519","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-12 02:20:21","2022-03-12 02:20:21","");
INSERT INTO audit_trail VALUES("6520","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1098","2022-03-12 02:21:30","2022-03-12 02:21:30","1");
INSERT INTO audit_trail VALUES("6521","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1099","2022-03-12 04:03:39","2022-03-12 04:03:39","1");
INSERT INTO audit_trail VALUES("6522","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-12 07:35:51","2022-03-12 07:35:51","");
INSERT INTO audit_trail VALUES("6523","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-12 07:39:32","2022-03-12 07:39:32","");
INSERT INTO audit_trail VALUES("6524","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-12 07:45:27","2022-03-12 07:45:27","");
INSERT INTO audit_trail VALUES("6525","6","Gilbert Githitu","","Added expense with id:579","2022-03-12 07:58:46","2022-03-12 07:58:46","1");
INSERT INTO audit_trail VALUES("6526","6","Gilbert Githitu","","Updated expense with id:579","2022-03-12 07:59:23","2022-03-12 07:59:23","1");
INSERT INTO audit_trail VALUES("6527","6","Gilbert Githitu","","Added expense with id:580","2022-03-12 08:04:15","2022-03-12 08:04:15","1");
INSERT INTO audit_trail VALUES("6528","6","Gilbert Githitu","","Added expense with id:581","2022-03-12 08:06:31","2022-03-12 08:06:31","1");
INSERT INTO audit_trail VALUES("6529","6","Gilbert Githitu","","Updated expense with id:580","2022-03-12 08:18:08","2022-03-12 08:18:08","1");
INSERT INTO audit_trail VALUES("6530","6","Gilbert Githitu","","Added expense with id:582","2022-03-12 08:45:01","2022-03-12 08:45:01","1");
INSERT INTO audit_trail VALUES("6531","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-12 09:03:26","2022-03-12 09:03:26","1");
INSERT INTO audit_trail VALUES("6532","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-14 03:54:23","2022-03-14 03:54:23","");
INSERT INTO audit_trail VALUES("6533","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1100","2022-03-14 03:55:34","2022-03-14 03:55:34","1");
INSERT INTO audit_trail VALUES("6534","6","Gilbert Githitu","","Logged in to system","2022-03-14 05:01:50","2022-03-14 05:01:50","");
INSERT INTO audit_trail VALUES("6535","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-14 06:39:47","2022-03-14 06:39:47","");
INSERT INTO audit_trail VALUES("6536","1","Admin Admin","","Logged in to system","2022-03-14 06:47:39","2022-03-14 06:47:39","");
INSERT INTO audit_trail VALUES("6537","1","Admin Admin","","Added repayment for loan with id:9","2022-03-14 07:15:51","2022-03-14 07:15:51","1");
INSERT INTO audit_trail VALUES("6538","1","Admin Admin","","Undisbursed loan with id:246","2022-03-14 09:05:27","2022-03-14 09:05:27","1");
INSERT INTO audit_trail VALUES("6539","1","Admin Admin","","Unapproved loan with id:246","2022-03-14 09:05:36","2022-03-14 09:05:36","1");
INSERT INTO audit_trail VALUES("6540","1","Admin Admin","","Updated loan with id:246","2022-03-14 09:06:04","2022-03-14 09:06:04","1");
INSERT INTO audit_trail VALUES("6541","1","Admin Admin","","Approved loan with id:246","2022-03-14 09:06:33","2022-03-14 09:06:33","1");
INSERT INTO audit_trail VALUES("6542","1","Admin Admin","","Disbursed loan with id:246","2022-03-14 09:06:49","2022-03-14 09:06:49","1");
INSERT INTO audit_trail VALUES("6543","1","Admin Admin","","Undisbursed loan with id:246","2022-03-14 09:14:35","2022-03-14 09:14:35","1");
INSERT INTO audit_trail VALUES("6544","1","Admin Admin","","Unapproved loan with id:246","2022-03-14 09:14:45","2022-03-14 09:14:45","1");
INSERT INTO audit_trail VALUES("6545","1","Admin Admin","","Approved loan with id:246","2022-03-14 09:15:05","2022-03-14 09:15:05","1");
INSERT INTO audit_trail VALUES("6546","1","Admin Admin","","Approved loan with id:246","2022-03-14 09:15:06","2022-03-14 09:15:06","1");
INSERT INTO audit_trail VALUES("6547","1","Admin Admin","","Disbursed loan with id:246","2022-03-14 09:15:16","2022-03-14 09:15:16","1");
INSERT INTO audit_trail VALUES("6548","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:245","2022-03-14 09:28:24","2022-03-14 09:28:24","1");
INSERT INTO audit_trail VALUES("6549","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:245","2022-03-14 09:28:52","2022-03-14 09:28:52","1");
INSERT INTO audit_trail VALUES("6550","6","Gilbert Githitu","","Updated loan with id:245","2022-03-14 09:30:40","2022-03-14 09:30:40","1");
INSERT INTO audit_trail VALUES("6551","6","Gilbert Githitu","","Approved loan with id:245","2022-03-14 09:35:27","2022-03-14 09:35:27","1");
INSERT INTO audit_trail VALUES("6552","6","Gilbert Githitu","","Disbursed loan with id:245","2022-03-14 09:36:11","2022-03-14 09:36:11","1");
INSERT INTO audit_trail VALUES("6553","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:244","2022-03-14 09:39:29","2022-03-14 09:39:29","1");
INSERT INTO audit_trail VALUES("6554","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:244","2022-03-14 09:39:39","2022-03-14 09:39:39","1");
INSERT INTO audit_trail VALUES("6555","6","Gilbert Githitu","","Updated loan with id:244","2022-03-14 09:40:21","2022-03-14 09:40:21","1");
INSERT INTO audit_trail VALUES("6556","6","Gilbert Githitu","","Approved loan with id:244","2022-03-14 09:41:04","2022-03-14 09:41:04","1");
INSERT INTO audit_trail VALUES("6557","6","Gilbert Githitu","","Disbursed loan with id:244","2022-03-14 09:41:22","2022-03-14 09:41:22","1");
INSERT INTO audit_trail VALUES("6558","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:242","2022-03-14 09:43:42","2022-03-14 09:43:42","1");
INSERT INTO audit_trail VALUES("6559","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:242","2022-03-14 09:43:49","2022-03-14 09:43:49","1");
INSERT INTO audit_trail VALUES("6560","6","Gilbert Githitu","","Updated loan with id:242","2022-03-14 09:44:31","2022-03-14 09:44:31","1");
INSERT INTO audit_trail VALUES("6561","6","Gilbert Githitu","","Approved loan with id:242","2022-03-14 09:45:28","2022-03-14 09:45:28","1");
INSERT INTO audit_trail VALUES("6562","6","Gilbert Githitu","","Disbursed loan with id:242","2022-03-14 09:45:44","2022-03-14 09:45:44","1");
INSERT INTO audit_trail VALUES("6563","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:241","2022-03-14 09:47:50","2022-03-14 09:47:50","1");
INSERT INTO audit_trail VALUES("6564","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:241","2022-03-14 09:47:58","2022-03-14 09:47:58","1");
INSERT INTO audit_trail VALUES("6565","6","Gilbert Githitu","","Updated loan with id:241","2022-03-14 09:48:38","2022-03-14 09:48:38","1");
INSERT INTO audit_trail VALUES("6566","6","Gilbert Githitu","","Approved loan with id:241","2022-03-14 09:49:25","2022-03-14 09:49:25","1");
INSERT INTO audit_trail VALUES("6567","6","Gilbert Githitu","","Disbursed loan with id:241","2022-03-14 09:49:38","2022-03-14 09:49:38","1");
INSERT INTO audit_trail VALUES("6568","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:240","2022-03-14 09:50:59","2022-03-14 09:50:59","1");
INSERT INTO audit_trail VALUES("6569","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:240","2022-03-14 09:51:07","2022-03-14 09:51:07","1");
INSERT INTO audit_trail VALUES("6570","6","Gilbert Githitu","","Updated loan with id:240","2022-03-14 09:53:44","2022-03-14 09:53:44","1");
INSERT INTO audit_trail VALUES("6571","6","Gilbert Githitu","","Approved loan with id:240","2022-03-14 09:54:30","2022-03-14 09:54:30","1");
INSERT INTO audit_trail VALUES("6572","6","Gilbert Githitu","","Disbursed loan with id:240","2022-03-14 09:54:43","2022-03-14 09:54:43","1");
INSERT INTO audit_trail VALUES("6573","6","Gilbert Githitu","","Undisbursed loan with id:238","2022-03-14 09:56:45","2022-03-14 09:56:45","1");
INSERT INTO audit_trail VALUES("6574","6","Gilbert Githitu","","Unapproved loan with id:238","2022-03-14 09:56:59","2022-03-14 09:56:59","1");
INSERT INTO audit_trail VALUES("6575","6","Gilbert Githitu","","Updated loan with id:238","2022-03-14 09:57:36","2022-03-14 09:57:36","1");
INSERT INTO audit_trail VALUES("6576","6","Gilbert Githitu","","Approved loan with id:238","2022-03-14 09:58:32","2022-03-14 09:58:32","1");
INSERT INTO audit_trail VALUES("6577","6","Gilbert Githitu","","Disbursed loan with id:238","2022-03-14 09:58:52","2022-03-14 09:58:52","1");
INSERT INTO audit_trail VALUES("6578","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:237","2022-03-14 10:04:00","2022-03-14 10:04:00","1");
INSERT INTO audit_trail VALUES("6579","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:237","2022-03-14 10:04:19","2022-03-14 10:04:19","1");
INSERT INTO audit_trail VALUES("6580","6","Gilbert Githitu","","Updated loan with id:237","2022-03-14 10:04:44","2022-03-14 10:04:44","1");
INSERT INTO audit_trail VALUES("6581","6","Gilbert Githitu","","Approved loan with id:237","2022-03-14 10:05:49","2022-03-14 10:05:49","1");
INSERT INTO audit_trail VALUES("6582","6","Gilbert Githitu","","Disbursed loan with id:237","2022-03-14 10:06:07","2022-03-14 10:06:07","1");
INSERT INTO audit_trail VALUES("6583","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:236","2022-03-14 10:06:22","2022-03-14 10:06:22","1");
INSERT INTO audit_trail VALUES("6584","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:236","2022-03-14 10:06:34","2022-03-14 10:06:34","1");
INSERT INTO audit_trail VALUES("6585","2","CECILIA WANJERI WANGUHU","","Updated loan with id:236","2022-03-14 10:08:10","2022-03-14 10:08:10","1");
INSERT INTO audit_trail VALUES("6586","2","CECILIA WANJERI WANGUHU","","Approved loan with id:236","2022-03-14 10:09:29","2022-03-14 10:09:29","1");
INSERT INTO audit_trail VALUES("6587","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:236","2022-03-14 10:09:47","2022-03-14 10:09:47","1");
INSERT INTO audit_trail VALUES("6588","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:235","2022-03-14 10:15:05","2022-03-14 10:15:05","1");
INSERT INTO audit_trail VALUES("6589","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:235","2022-03-14 10:15:13","2022-03-14 10:15:13","1");
INSERT INTO audit_trail VALUES("6590","2","CECILIA WANJERI WANGUHU","","Updated loan with id:235","2022-03-14 10:15:51","2022-03-14 10:15:51","1");
INSERT INTO audit_trail VALUES("6591","6","Gilbert Githitu","","Undisbursed loan with id:233","2022-03-14 10:16:01","2022-03-14 10:16:01","1");
INSERT INTO audit_trail VALUES("6592","6","Gilbert Githitu","","Unapproved loan with id:233","2022-03-14 10:16:24","2022-03-14 10:16:24","1");
INSERT INTO audit_trail VALUES("6593","6","Gilbert Githitu","","Updated loan with id:233","2022-03-14 10:17:05","2022-03-14 10:17:05","1");
INSERT INTO audit_trail VALUES("6594","2","CECILIA WANJERI WANGUHU","","Approved loan with id:235","2022-03-14 10:17:16","2022-03-14 10:17:16","1");
INSERT INTO audit_trail VALUES("6595","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:235","2022-03-14 10:17:32","2022-03-14 10:17:32","1");
INSERT INTO audit_trail VALUES("6596","6","Gilbert Githitu","","Approved loan with id:233","2022-03-14 10:18:08","2022-03-14 10:18:08","1");
INSERT INTO audit_trail VALUES("6597","6","Gilbert Githitu","","Disbursed loan with id:233","2022-03-14 10:18:24","2022-03-14 10:18:24","1");
INSERT INTO audit_trail VALUES("6598","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:232","2022-03-14 10:23:29","2022-03-14 10:23:29","1");
INSERT INTO audit_trail VALUES("6599","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:232","2022-03-14 10:23:37","2022-03-14 10:23:37","1");
INSERT INTO audit_trail VALUES("6600","2","CECILIA WANJERI WANGUHU","","Updated loan with id:232","2022-03-14 10:24:41","2022-03-14 10:24:41","1");
INSERT INTO audit_trail VALUES("6601","2","CECILIA WANJERI WANGUHU","","Approved loan with id:232","2022-03-14 10:25:53","2022-03-14 10:25:53","1");
INSERT INTO audit_trail VALUES("6602","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:232","2022-03-14 10:26:05","2022-03-14 10:26:05","1");
INSERT INTO audit_trail VALUES("6603","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:231","2022-03-14 10:34:55","2022-03-14 10:34:55","1");
INSERT INTO audit_trail VALUES("6604","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:231","2022-03-14 10:35:04","2022-03-14 10:35:04","1");
INSERT INTO audit_trail VALUES("6605","6","Gilbert Githitu","","Undisbursed loan with id:230","2022-03-14 10:35:09","2022-03-14 10:35:09","1");
INSERT INTO audit_trail VALUES("6606","6","Gilbert Githitu","","Deleted loan with id:230","2022-03-14 10:35:27","2022-03-14 10:35:27","1");
INSERT INTO audit_trail VALUES("6607","2","CECILIA WANJERI WANGUHU","","Updated loan with id:231","2022-03-14 10:35:42","2022-03-14 10:35:42","1");
INSERT INTO audit_trail VALUES("6608","2","CECILIA WANJERI WANGUHU","","Approved loan with id:231","2022-03-14 10:36:30","2022-03-14 10:36:30","1");
INSERT INTO audit_trail VALUES("6609","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:231","2022-03-14 10:36:41","2022-03-14 10:36:41","1");
INSERT INTO audit_trail VALUES("6610","6","Gilbert Githitu","","Undisbursed loan with id:229","2022-03-14 10:40:09","2022-03-14 10:40:09","1");
INSERT INTO audit_trail VALUES("6611","6","Gilbert Githitu","","Unapproved loan with id:229","2022-03-14 10:40:30","2022-03-14 10:40:30","1");
INSERT INTO audit_trail VALUES("6612","6","Gilbert Githitu","","Updated loan with id:229","2022-03-14 10:40:53","2022-03-14 10:40:53","1");
INSERT INTO audit_trail VALUES("6613","6","Gilbert Githitu","","Approved loan with id:229","2022-03-14 10:42:43","2022-03-14 10:42:43","1");
INSERT INTO audit_trail VALUES("6614","6","Gilbert Githitu","","Disbursed loan with id:229","2022-03-14 10:43:44","2022-03-14 10:43:44","1");
INSERT INTO audit_trail VALUES("6615","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:228","2022-03-14 10:44:37","2022-03-14 10:44:37","1");
INSERT INTO audit_trail VALUES("6616","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:228","2022-03-14 10:44:43","2022-03-14 10:44:43","1");
INSERT INTO audit_trail VALUES("6617","2","CECILIA WANJERI WANGUHU","","Updated loan with id:228","2022-03-14 10:45:19","2022-03-14 10:45:19","1");
INSERT INTO audit_trail VALUES("6618","6","Gilbert Githitu","","Undisbursed loan with id:233","2022-03-14 10:47:17","2022-03-14 10:47:17","1");
INSERT INTO audit_trail VALUES("6619","6","Gilbert Githitu","","Unapproved loan with id:233","2022-03-14 10:47:36","2022-03-14 10:47:36","1");
INSERT INTO audit_trail VALUES("6620","2","CECILIA WANJERI WANGUHU","","Approved loan with id:228","2022-03-14 10:47:58","2022-03-14 10:47:58","1");
INSERT INTO audit_trail VALUES("6621","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:228","2022-03-14 10:48:13","2022-03-14 10:48:13","1");
INSERT INTO audit_trail VALUES("6622","6","Gilbert Githitu","","Updated loan with id:233","2022-03-14 10:48:23","2022-03-14 10:48:23","1");
INSERT INTO audit_trail VALUES("6623","6","Gilbert Githitu","","Approved loan with id:233","2022-03-14 10:49:53","2022-03-14 10:49:53","1");
INSERT INTO audit_trail VALUES("6624","6","Gilbert Githitu","","Disbursed loan with id:233","2022-03-14 10:50:14","2022-03-14 10:50:14","1");
INSERT INTO audit_trail VALUES("6625","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:227","2022-03-14 11:16:09","2022-03-14 11:16:09","1");
INSERT INTO audit_trail VALUES("6626","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:227","2022-03-14 11:16:14","2022-03-14 11:16:14","1");
INSERT INTO audit_trail VALUES("6627","2","CECILIA WANJERI WANGUHU","","Updated loan with id:227","2022-03-14 11:17:10","2022-03-14 11:17:10","1");
INSERT INTO audit_trail VALUES("6628","2","CECILIA WANJERI WANGUHU","","Approved loan with id:227","2022-03-14 11:17:50","2022-03-14 11:17:50","1");
INSERT INTO audit_trail VALUES("6629","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:227","2022-03-14 11:18:18","2022-03-14 11:18:18","1");
INSERT INTO audit_trail VALUES("6630","6","Gilbert Githitu","","Undisbursed loan with id:226","2022-03-14 11:22:32","2022-03-14 11:22:32","1");
INSERT INTO audit_trail VALUES("6631","6","Gilbert Githitu","","Unapproved loan with id:226","2022-03-14 11:22:50","2022-03-14 11:22:50","1");
INSERT INTO audit_trail VALUES("6632","6","Gilbert Githitu","","Updated loan with id:226","2022-03-14 11:23:14","2022-03-14 11:23:14","1");
INSERT INTO audit_trail VALUES("6633","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:225","2022-03-14 11:24:12","2022-03-14 11:24:12","1");
INSERT INTO audit_trail VALUES("6634","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:225","2022-03-14 11:24:19","2022-03-14 11:24:19","1");
INSERT INTO audit_trail VALUES("6635","6","Gilbert Githitu","","Approved loan with id:226","2022-03-14 11:24:41","2022-03-14 11:24:41","1");
INSERT INTO audit_trail VALUES("6636","6","Gilbert Githitu","","Disbursed loan with id:226","2022-03-14 11:25:10","2022-03-14 11:25:10","1");
INSERT INTO audit_trail VALUES("6637","2","CECILIA WANJERI WANGUHU","","Updated loan with id:225","2022-03-14 11:25:16","2022-03-14 11:25:16","1");
INSERT INTO audit_trail VALUES("6638","2","CECILIA WANJERI WANGUHU","","Approved loan with id:225","2022-03-14 11:26:05","2022-03-14 11:26:05","1");
INSERT INTO audit_trail VALUES("6639","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:225","2022-03-14 11:26:21","2022-03-14 11:26:21","1");
INSERT INTO audit_trail VALUES("6640","6","Gilbert Githitu","","Undisbursed loan with id:224","2022-03-14 11:27:54","2022-03-14 11:27:54","1");
INSERT INTO audit_trail VALUES("6641","6","Gilbert Githitu","","Unapproved loan with id:224","2022-03-14 11:28:18","2022-03-14 11:28:18","1");
INSERT INTO audit_trail VALUES("6642","6","Gilbert Githitu","","Updated loan with id:224","2022-03-14 11:28:53","2022-03-14 11:28:53","1");
INSERT INTO audit_trail VALUES("6643","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:223","2022-03-14 11:29:44","2022-03-14 11:29:44","1");
INSERT INTO audit_trail VALUES("6644","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:223","2022-03-14 11:29:50","2022-03-14 11:29:50","1");
INSERT INTO audit_trail VALUES("6645","6","Gilbert Githitu","","Approved loan with id:224","2022-03-14 11:30:03","2022-03-14 11:30:03","1");
INSERT INTO audit_trail VALUES("6646","6","Gilbert Githitu","","Disbursed loan with id:224","2022-03-14 11:30:17","2022-03-14 11:30:17","1");
INSERT INTO audit_trail VALUES("6647","2","CECILIA WANJERI WANGUHU","","Updated loan with id:223","2022-03-14 11:30:18","2022-03-14 11:30:18","1");
INSERT INTO audit_trail VALUES("6648","2","CECILIA WANJERI WANGUHU","","Approved loan with id:223","2022-03-14 11:31:04","2022-03-14 11:31:04","1");
INSERT INTO audit_trail VALUES("6649","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:223","2022-03-14 11:31:19","2022-03-14 11:31:19","1");
INSERT INTO audit_trail VALUES("6650","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:222","2022-03-14 11:34:48","2022-03-14 11:34:48","1");
INSERT INTO audit_trail VALUES("6651","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:222","2022-03-14 11:34:53","2022-03-14 11:34:53","1");
INSERT INTO audit_trail VALUES("6652","2","CECILIA WANJERI WANGUHU","","Updated loan with id:222","2022-03-14 11:35:42","2022-03-14 11:35:42","1");
INSERT INTO audit_trail VALUES("6653","2","CECILIA WANJERI WANGUHU","","Approved loan with id:222","2022-03-14 11:36:40","2022-03-14 11:36:40","1");
INSERT INTO audit_trail VALUES("6654","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:222","2022-03-14 11:37:42","2022-03-14 11:37:42","1");
INSERT INTO audit_trail VALUES("6655","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:222","2022-03-14 11:55:31","2022-03-14 11:55:31","1");
INSERT INTO audit_trail VALUES("6656","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:222","2022-03-14 11:55:38","2022-03-14 11:55:38","1");
INSERT INTO audit_trail VALUES("6657","2","CECILIA WANJERI WANGUHU","","Updated loan with id:222","2022-03-14 11:56:41","2022-03-14 11:56:41","1");
INSERT INTO audit_trail VALUES("6658","2","CECILIA WANJERI WANGUHU","","Approved loan with id:222","2022-03-14 11:57:32","2022-03-14 11:57:32","1");
INSERT INTO audit_trail VALUES("6659","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:222","2022-03-14 11:57:46","2022-03-14 11:57:46","1");
INSERT INTO audit_trail VALUES("6660","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:222","2022-03-14 12:04:12","2022-03-14 12:04:12","1");
INSERT INTO audit_trail VALUES("6661","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:222","2022-03-14 12:04:19","2022-03-14 12:04:19","1");
INSERT INTO audit_trail VALUES("6662","2","CECILIA WANJERI WANGUHU","","Updated loan with id:222","2022-03-14 12:04:41","2022-03-14 12:04:41","1");
INSERT INTO audit_trail VALUES("6663","2","CECILIA WANJERI WANGUHU","","Approved loan with id:222","2022-03-14 12:05:21","2022-03-14 12:05:21","1");
INSERT INTO audit_trail VALUES("6664","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:222","2022-03-14 12:05:32","2022-03-14 12:05:32","1");
INSERT INTO audit_trail VALUES("6665","6","Gilbert Githitu","","Undisbursed loan with id:218","2022-03-14 12:22:50","2022-03-14 12:22:50","1");
INSERT INTO audit_trail VALUES("6666","6","Gilbert Githitu","","Unapproved loan with id:218","2022-03-14 12:23:03","2022-03-14 12:23:03","1");
INSERT INTO audit_trail VALUES("6667","6","Gilbert Githitu","","Updated loan with id:218","2022-03-14 12:24:21","2022-03-14 12:24:21","1");
INSERT INTO audit_trail VALUES("6668","6","Gilbert Githitu","","Approved loan with id:218","2022-03-14 12:25:13","2022-03-14 12:25:13","1");
INSERT INTO audit_trail VALUES("6669","6","Gilbert Githitu","","Disbursed loan with id:218","2022-03-14 12:25:31","2022-03-14 12:25:31","1");
INSERT INTO audit_trail VALUES("6670","6","Gilbert Githitu","","Undisbursed loan with id:216","2022-03-14 12:27:29","2022-03-14 12:27:29","1");
INSERT INTO audit_trail VALUES("6671","6","Gilbert Githitu","","Unapproved loan with id:216","2022-03-14 12:27:42","2022-03-14 12:27:42","1");
INSERT INTO audit_trail VALUES("6672","6","Gilbert Githitu","","Updated loan with id:216","2022-03-14 12:28:32","2022-03-14 12:28:32","1");
INSERT INTO audit_trail VALUES("6673","6","Gilbert Githitu","","Approved loan with id:216","2022-03-14 12:29:17","2022-03-14 12:29:17","1");
INSERT INTO audit_trail VALUES("6674","6","Gilbert Githitu","","Disbursed loan with id:216","2022-03-14 12:29:32","2022-03-14 12:29:32","1");
INSERT INTO audit_trail VALUES("6675","6","Gilbert Githitu","","Undisbursed loan with id:216","2022-03-14 12:31:53","2022-03-14 12:31:53","1");
INSERT INTO audit_trail VALUES("6676","6","Gilbert Githitu","","Unapproved loan with id:216","2022-03-14 12:32:06","2022-03-14 12:32:06","1");
INSERT INTO audit_trail VALUES("6677","6","Gilbert Githitu","","Updated loan with id:216","2022-03-14 12:32:45","2022-03-14 12:32:45","1");
INSERT INTO audit_trail VALUES("6678","6","Gilbert Githitu","","Approved loan with id:216","2022-03-14 12:33:37","2022-03-14 12:33:37","1");
INSERT INTO audit_trail VALUES("6679","6","Gilbert Githitu","","Disbursed loan with id:216","2022-03-14 12:33:58","2022-03-14 12:33:58","1");
INSERT INTO audit_trail VALUES("6680","6","Gilbert Githitu","","Undisbursed loan with id:215","2022-03-14 12:36:59","2022-03-14 12:36:59","1");
INSERT INTO audit_trail VALUES("6681","6","Gilbert Githitu","","Unapproved loan with id:215","2022-03-14 12:37:12","2022-03-14 12:37:12","1");
INSERT INTO audit_trail VALUES("6682","6","Gilbert Githitu","","Updated loan with id:215","2022-03-14 12:38:05","2022-03-14 12:38:05","1");
INSERT INTO audit_trail VALUES("6683","6","Gilbert Githitu","","Updated loan with id:215","2022-03-14 12:40:45","2022-03-14 12:40:45","1");
INSERT INTO audit_trail VALUES("6684","6","Gilbert Githitu","","Approved loan with id:215","2022-03-14 12:41:58","2022-03-14 12:41:58","1");
INSERT INTO audit_trail VALUES("6685","6","Gilbert Githitu","","Disbursed loan with id:215","2022-03-14 12:42:17","2022-03-14 12:42:17","1");
INSERT INTO audit_trail VALUES("6686","6","Gilbert Githitu","","Undisbursed loan with id:214","2022-03-14 12:47:48","2022-03-14 12:47:48","1");
INSERT INTO audit_trail VALUES("6687","6","Gilbert Githitu","","Unapproved loan with id:214","2022-03-14 12:48:02","2022-03-14 12:48:02","1");
INSERT INTO audit_trail VALUES("6688","6","Gilbert Githitu","","Updated loan with id:214","2022-03-14 12:48:53","2022-03-14 12:48:53","1");
INSERT INTO audit_trail VALUES("6689","6","Gilbert Githitu","","Approved loan with id:214","2022-03-14 12:49:59","2022-03-14 12:49:59","1");
INSERT INTO audit_trail VALUES("6690","6","Gilbert Githitu","","Disbursed loan with id:214","2022-03-14 12:50:25","2022-03-14 12:50:25","1");
INSERT INTO audit_trail VALUES("6691","6","Gilbert Githitu","","Undisbursed loan with id:213","2022-03-14 12:52:16","2022-03-14 12:52:16","1");
INSERT INTO audit_trail VALUES("6692","6","Gilbert Githitu","","Unapproved loan with id:213","2022-03-14 12:52:28","2022-03-14 12:52:28","1");
INSERT INTO audit_trail VALUES("6693","6","Gilbert Githitu","","Updated loan with id:213","2022-03-14 12:53:15","2022-03-14 12:53:15","1");
INSERT INTO audit_trail VALUES("6694","6","Gilbert Githitu","","Approved loan with id:213","2022-03-14 12:54:27","2022-03-14 12:54:27","1");
INSERT INTO audit_trail VALUES("6695","6","Gilbert Githitu","","Disbursed loan with id:213","2022-03-14 12:54:46","2022-03-14 12:54:46","1");
INSERT INTO audit_trail VALUES("6696","6","Gilbert Githitu","","Undisbursed loan with id:211","2022-03-14 12:56:54","2022-03-14 12:56:54","1");
INSERT INTO audit_trail VALUES("6697","6","Gilbert Githitu","","Unapproved loan with id:211","2022-03-14 12:57:06","2022-03-14 12:57:06","1");
INSERT INTO audit_trail VALUES("6698","6","Gilbert Githitu","","Updated loan with id:211","2022-03-14 12:57:53","2022-03-14 12:57:53","1");
INSERT INTO audit_trail VALUES("6699","6","Gilbert Githitu","","Approved loan with id:211","2022-03-14 12:58:43","2022-03-14 12:58:43","1");
INSERT INTO audit_trail VALUES("6700","6","Gilbert Githitu","","Disbursed loan with id:211","2022-03-14 12:59:05","2022-03-14 12:59:05","1");
INSERT INTO audit_trail VALUES("6701","6","Gilbert Githitu","","Undisbursed loan with id:208","2022-03-14 13:09:48","2022-03-14 13:09:48","1");
INSERT INTO audit_trail VALUES("6702","6","Gilbert Githitu","","Unapproved loan with id:208","2022-03-14 13:10:02","2022-03-14 13:10:02","1");
INSERT INTO audit_trail VALUES("6703","6","Gilbert Githitu","","Updated loan with id:208","2022-03-14 13:10:45","2022-03-14 13:10:45","1");
INSERT INTO audit_trail VALUES("6704","6","Gilbert Githitu","","Updated loan with id:208","2022-03-14 13:11:53","2022-03-14 13:11:53","1");
INSERT INTO audit_trail VALUES("6705","6","Gilbert Githitu","","Approved loan with id:208","2022-03-14 13:12:36","2022-03-14 13:12:36","1");
INSERT INTO audit_trail VALUES("6706","6","Gilbert Githitu","","Disbursed loan with id:208","2022-03-14 13:12:50","2022-03-14 13:12:50","1");
INSERT INTO audit_trail VALUES("6707","6","Gilbert Githitu","","Undisbursed loan with id:206","2022-03-14 13:21:13","2022-03-14 13:21:13","1");
INSERT INTO audit_trail VALUES("6708","6","Gilbert Githitu","","Unapproved loan with id:206","2022-03-14 13:21:25","2022-03-14 13:21:25","1");
INSERT INTO audit_trail VALUES("6709","6","Gilbert Githitu","","Updated loan with id:206","2022-03-14 13:22:15","2022-03-14 13:22:15","1");
INSERT INTO audit_trail VALUES("6710","6","Gilbert Githitu","","Approved loan with id:206","2022-03-14 13:23:14","2022-03-14 13:23:14","1");
INSERT INTO audit_trail VALUES("6711","6","Gilbert Githitu","","Disbursed loan with id:206","2022-03-14 13:23:29","2022-03-14 13:23:29","1");
INSERT INTO audit_trail VALUES("6712","6","Gilbert Githitu","","Undisbursed loan with id:205","2022-03-14 13:24:21","2022-03-14 13:24:21","1");
INSERT INTO audit_trail VALUES("6713","6","Gilbert Githitu","","Unapproved loan with id:205","2022-03-14 13:24:34","2022-03-14 13:24:34","1");
INSERT INTO audit_trail VALUES("6714","6","Gilbert Githitu","","Updated loan with id:205","2022-03-14 13:25:33","2022-03-14 13:25:33","1");
INSERT INTO audit_trail VALUES("6715","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:192","2022-03-14 13:25:36","2022-03-14 13:25:36","1");
INSERT INTO audit_trail VALUES("6716","2","CECILIA WANJERI WANGUHU","","Updated loan with id:192","2022-03-14 13:27:53","2022-03-14 13:27:53","1");
INSERT INTO audit_trail VALUES("6717","6","Gilbert Githitu","","Updated loan with id:205","2022-03-14 13:29:23","2022-03-14 13:29:23","1");
INSERT INTO audit_trail VALUES("6718","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:192","2022-03-14 13:29:29","2022-03-14 13:29:29","1");
INSERT INTO audit_trail VALUES("6719","2","CECILIA WANJERI WANGUHU","","Updated loan with id:192","2022-03-14 13:29:46","2022-03-14 13:29:46","1");
INSERT INTO audit_trail VALUES("6720","6","Gilbert Githitu","","Approved loan with id:205","2022-03-14 13:30:10","2022-03-14 13:30:10","1");
INSERT INTO audit_trail VALUES("6721","6","Gilbert Githitu","","Disbursed loan with id:205","2022-03-14 13:30:27","2022-03-14 13:30:27","1");
INSERT INTO audit_trail VALUES("6722","2","CECILIA WANJERI WANGUHU","","Approved loan with id:192","2022-03-14 13:31:06","2022-03-14 13:31:06","1");
INSERT INTO audit_trail VALUES("6723","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:192","2022-03-14 13:31:22","2022-03-14 13:31:22","1");
INSERT INTO audit_trail VALUES("6724","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:192","2022-03-14 13:31:35","2022-03-14 13:31:35","1");
INSERT INTO audit_trail VALUES("6725","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:192","2022-03-14 13:31:42","2022-03-14 13:31:42","1");
INSERT INTO audit_trail VALUES("6726","2","CECILIA WANJERI WANGUHU","","Updated loan with id:192","2022-03-14 13:32:05","2022-03-14 13:32:05","1");
INSERT INTO audit_trail VALUES("6727","2","CECILIA WANJERI WANGUHU","","Approved loan with id:192","2022-03-14 13:32:49","2022-03-14 13:32:49","1");
INSERT INTO audit_trail VALUES("6728","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:192","2022-03-14 13:33:07","2022-03-14 13:33:07","1");
INSERT INTO audit_trail VALUES("6729","6","Gilbert Githitu","","Undisbursed loan with id:190","2022-03-14 13:34:13","2022-03-14 13:34:13","1");
INSERT INTO audit_trail VALUES("6730","6","Gilbert Githitu","","Unapproved loan with id:190","2022-03-14 13:34:25","2022-03-14 13:34:25","1");
INSERT INTO audit_trail VALUES("6731","6","Gilbert Githitu","","Updated loan with id:190","2022-03-14 13:35:05","2022-03-14 13:35:05","1");
INSERT INTO audit_trail VALUES("6732","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:189","2022-03-14 13:35:20","2022-03-14 13:35:20","1");
INSERT INTO audit_trail VALUES("6733","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:189","2022-03-14 13:35:28","2022-03-14 13:35:28","1");
INSERT INTO audit_trail VALUES("6734","6","Gilbert Githitu","","Approved loan with id:190","2022-03-14 13:35:59","2022-03-14 13:35:59","1");
INSERT INTO audit_trail VALUES("6735","2","CECILIA WANJERI WANGUHU","","Updated loan with id:189","2022-03-14 13:36:11","2022-03-14 13:36:11","1");
INSERT INTO audit_trail VALUES("6736","6","Gilbert Githitu","","Disbursed loan with id:190","2022-03-14 13:36:50","2022-03-14 13:36:50","1");
INSERT INTO audit_trail VALUES("6737","2","CECILIA WANJERI WANGUHU","","Approved loan with id:189","2022-03-14 13:36:52","2022-03-14 13:36:52","1");
INSERT INTO audit_trail VALUES("6738","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:189","2022-03-14 13:37:06","2022-03-14 13:37:06","1");
INSERT INTO audit_trail VALUES("6739","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:188","2022-03-14 13:43:08","2022-03-14 13:43:08","1");
INSERT INTO audit_trail VALUES("6740","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:188","2022-03-14 13:43:13","2022-03-14 13:43:13","1");
INSERT INTO audit_trail VALUES("6741","2","CECILIA WANJERI WANGUHU","","Updated loan with id:188","2022-03-14 13:43:41","2022-03-14 13:43:41","1");
INSERT INTO audit_trail VALUES("6742","6","Gilbert Githitu","","Undisbursed loan with id:187","2022-03-14 13:44:14","2022-03-14 13:44:14","1");
INSERT INTO audit_trail VALUES("6743","2","CECILIA WANJERI WANGUHU","","Approved loan with id:188","2022-03-14 13:44:26","2022-03-14 13:44:26","1");
INSERT INTO audit_trail VALUES("6744","6","Gilbert Githitu","","Unapproved loan with id:187","2022-03-14 13:44:28","2022-03-14 13:44:28","1");
INSERT INTO audit_trail VALUES("6745","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:188","2022-03-14 13:44:36","2022-03-14 13:44:36","1");
INSERT INTO audit_trail VALUES("6746","6","Gilbert Githitu","","Updated loan with id:187","2022-03-14 13:45:13","2022-03-14 13:45:13","1");
INSERT INTO audit_trail VALUES("6747","6","Gilbert Githitu","","Approved loan with id:187","2022-03-14 13:46:36","2022-03-14 13:46:36","1");
INSERT INTO audit_trail VALUES("6748","6","Gilbert Githitu","","Disbursed loan with id:187","2022-03-14 13:46:50","2022-03-14 13:46:50","1");
INSERT INTO audit_trail VALUES("6749","6","Gilbert Githitu","","Undisbursed loan with id:186","2022-03-14 13:52:56","2022-03-14 13:52:56","1");
INSERT INTO audit_trail VALUES("6750","6","Gilbert Githitu","","Unapproved loan with id:186","2022-03-14 13:53:10","2022-03-14 13:53:10","1");
INSERT INTO audit_trail VALUES("6751","6","Gilbert Githitu","","Updated loan with id:186","2022-03-14 13:54:10","2022-03-14 13:54:10","1");
INSERT INTO audit_trail VALUES("6752","6","Gilbert Githitu","","Approved loan with id:186","2022-03-14 13:55:30","2022-03-14 13:55:30","1");
INSERT INTO audit_trail VALUES("6753","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:188","2022-03-14 13:55:33","2022-03-14 13:55:33","1");
INSERT INTO audit_trail VALUES("6754","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:188","2022-03-14 13:55:48","2022-03-14 13:55:48","1");
INSERT INTO audit_trail VALUES("6755","6","Gilbert Githitu","","Disbursed loan with id:186","2022-03-14 13:55:55","2022-03-14 13:55:55","1");
INSERT INTO audit_trail VALUES("6756","2","CECILIA WANJERI WANGUHU","","Updated loan with id:188","2022-03-14 13:56:17","2022-03-14 13:56:17","1");
INSERT INTO audit_trail VALUES("6757","2","CECILIA WANJERI WANGUHU","","Approved loan with id:188","2022-03-14 13:57:05","2022-03-14 13:57:05","1");
INSERT INTO audit_trail VALUES("6758","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:188","2022-03-14 13:57:17","2022-03-14 13:57:17","1");
INSERT INTO audit_trail VALUES("6759","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:183","2022-03-14 14:06:06","2022-03-14 14:06:06","1");
INSERT INTO audit_trail VALUES("6760","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:183","2022-03-14 14:06:12","2022-03-14 14:06:12","1");
INSERT INTO audit_trail VALUES("6761","6","Gilbert Githitu","","Undisbursed loan with id:182","2022-03-14 14:06:16","2022-03-14 14:06:16","1");
INSERT INTO audit_trail VALUES("6762","6","Gilbert Githitu","","Unapproved loan with id:182","2022-03-14 14:06:32","2022-03-14 14:06:32","1");
INSERT INTO audit_trail VALUES("6763","2","CECILIA WANJERI WANGUHU","","Updated loan with id:183","2022-03-14 14:06:54","2022-03-14 14:06:54","1");
INSERT INTO audit_trail VALUES("6764","6","Gilbert Githitu","","Updated loan with id:182","2022-03-14 14:07:21","2022-03-14 14:07:21","1");
INSERT INTO audit_trail VALUES("6765","2","CECILIA WANJERI WANGUHU","","Approved loan with id:183","2022-03-14 14:07:40","2022-03-14 14:07:40","1");
INSERT INTO audit_trail VALUES("6766","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:183","2022-03-14 14:07:54","2022-03-14 14:07:54","1");
INSERT INTO audit_trail VALUES("6767","6","Gilbert Githitu","","Approved loan with id:182","2022-03-14 14:08:46","2022-03-14 14:08:46","1");
INSERT INTO audit_trail VALUES("6768","6","Gilbert Githitu","","Disbursed loan with id:182","2022-03-14 14:09:03","2022-03-14 14:09:03","1");
INSERT INTO audit_trail VALUES("6769","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:180","2022-03-14 14:13:06","2022-03-14 14:13:06","1");
INSERT INTO audit_trail VALUES("6770","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:180","2022-03-14 14:13:16","2022-03-14 14:13:16","1");
INSERT INTO audit_trail VALUES("6771","6","Gilbert Githitu","","Undisbursed loan with id:178","2022-03-14 14:13:29","2022-03-14 14:13:29","1");
INSERT INTO audit_trail VALUES("6772","6","Gilbert Githitu","","Unapproved loan with id:178","2022-03-14 14:13:45","2022-03-14 14:13:45","1");
INSERT INTO audit_trail VALUES("6773","2","CECILIA WANJERI WANGUHU","","Updated loan with id:180","2022-03-14 14:14:03","2022-03-14 14:14:03","1");
INSERT INTO audit_trail VALUES("6774","6","Gilbert Githitu","","Updated loan with id:178","2022-03-14 14:14:23","2022-03-14 14:14:23","1");
INSERT INTO audit_trail VALUES("6775","2","CECILIA WANJERI WANGUHU","","Approved loan with id:180","2022-03-14 14:14:58","2022-03-14 14:14:58","1");
INSERT INTO audit_trail VALUES("6776","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:180","2022-03-14 14:15:10","2022-03-14 14:15:10","1");
INSERT INTO audit_trail VALUES("6777","6","Gilbert Githitu","","Approved loan with id:178","2022-03-14 14:15:15","2022-03-14 14:15:15","1");
INSERT INTO audit_trail VALUES("6778","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:180","2022-03-14 14:15:18","2022-03-14 14:15:18","1");
INSERT INTO audit_trail VALUES("6779","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:180","2022-03-14 14:15:26","2022-03-14 14:15:26","1");
INSERT INTO audit_trail VALUES("6780","6","Gilbert Githitu","","Disbursed loan with id:178","2022-03-14 14:15:31","2022-03-14 14:15:31","1");
INSERT INTO audit_trail VALUES("6781","2","CECILIA WANJERI WANGUHU","","Updated loan with id:180","2022-03-14 14:16:35","2022-03-14 14:16:35","1");
INSERT INTO audit_trail VALUES("6782","2","CECILIA WANJERI WANGUHU","","Approved loan with id:180","2022-03-14 14:17:04","2022-03-14 14:17:04","1");
INSERT INTO audit_trail VALUES("6783","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:180","2022-03-14 14:17:28","2022-03-14 14:17:28","1");
INSERT INTO audit_trail VALUES("6784","6","Gilbert Githitu","","Undisbursed loan with id:175","2022-03-14 14:22:45","2022-03-14 14:22:45","1");
INSERT INTO audit_trail VALUES("6785","6","Gilbert Githitu","","Unapproved loan with id:175","2022-03-14 14:23:00","2022-03-14 14:23:00","1");
INSERT INTO audit_trail VALUES("6786","6","Gilbert Githitu","","Updated loan with id:175","2022-03-14 14:24:01","2022-03-14 14:24:01","1");
INSERT INTO audit_trail VALUES("6787","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:174","2022-03-14 14:24:09","2022-03-14 14:24:09","1");
INSERT INTO audit_trail VALUES("6788","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:174","2022-03-14 14:24:20","2022-03-14 14:24:20","1");
INSERT INTO audit_trail VALUES("6789","2","CECILIA WANJERI WANGUHU","","Updated loan with id:174","2022-03-14 14:24:51","2022-03-14 14:24:51","1");
INSERT INTO audit_trail VALUES("6790","6","Gilbert Githitu","","Approved loan with id:175","2022-03-14 14:25:21","2022-03-14 14:25:21","1");
INSERT INTO audit_trail VALUES("6791","2","CECILIA WANJERI WANGUHU","","Approved loan with id:174","2022-03-14 14:25:42","2022-03-14 14:25:42","1");
INSERT INTO audit_trail VALUES("6792","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:174","2022-03-14 14:25:59","2022-03-14 14:25:59","1");
INSERT INTO audit_trail VALUES("6793","6","Gilbert Githitu","","Disbursed loan with id:175","2022-03-14 14:26:14","2022-03-14 14:26:14","1");
INSERT INTO audit_trail VALUES("6794","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:171","2022-03-14 14:31:13","2022-03-14 14:31:13","1");
INSERT INTO audit_trail VALUES("6795","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:171","2022-03-14 14:31:20","2022-03-14 14:31:20","1");
INSERT INTO audit_trail VALUES("6796","6","Gilbert Githitu","","Undisbursed loan with id:170","2022-03-14 14:31:56","2022-03-14 14:31:56","1");
INSERT INTO audit_trail VALUES("6797","2","CECILIA WANJERI WANGUHU","","Updated loan with id:171","2022-03-14 14:32:02","2022-03-14 14:32:02","1");
INSERT INTO audit_trail VALUES("6798","6","Gilbert Githitu","","Unapproved loan with id:170","2022-03-14 14:32:09","2022-03-14 14:32:09","1");
INSERT INTO audit_trail VALUES("6799","6","Gilbert Githitu","","Updated loan with id:170","2022-03-14 14:32:52","2022-03-14 14:32:52","1");
INSERT INTO audit_trail VALUES("6800","2","CECILIA WANJERI WANGUHU","","Approved loan with id:171","2022-03-14 14:33:15","2022-03-14 14:33:15","1");
INSERT INTO audit_trail VALUES("6801","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:171","2022-03-14 14:33:33","2022-03-14 14:33:33","1");
INSERT INTO audit_trail VALUES("6802","6","Gilbert Githitu","","Approved loan with id:170","2022-03-14 14:33:57","2022-03-14 14:33:57","1");
INSERT INTO audit_trail VALUES("6803","6","Gilbert Githitu","","Disbursed loan with id:170","2022-03-14 14:34:14","2022-03-14 14:34:14","1");
INSERT INTO audit_trail VALUES("6804","6","Gilbert Githitu","","Undisbursed loan with id:169","2022-03-14 14:38:56","2022-03-14 14:38:56","1");
INSERT INTO audit_trail VALUES("6805","6","Gilbert Githitu","","Unapproved loan with id:169","2022-03-14 14:39:09","2022-03-14 14:39:09","1");
INSERT INTO audit_trail VALUES("6806","6","Gilbert Githitu","","Updated loan with id:169","2022-03-14 14:39:48","2022-03-14 14:39:48","1");
INSERT INTO audit_trail VALUES("6807","2","CECILIA WANJERI WANGUHU","","Undisbursed loan with id:166","2022-03-14 14:40:59","2022-03-14 14:40:59","1");
INSERT INTO audit_trail VALUES("6808","2","CECILIA WANJERI WANGUHU","","Unapproved loan with id:166","2022-03-14 14:41:11","2022-03-14 14:41:11","1");
INSERT INTO audit_trail VALUES("6809","6","Gilbert Githitu","","Approved loan with id:169","2022-03-14 14:41:42","2022-03-14 14:41:42","1");
INSERT INTO audit_trail VALUES("6810","2","CECILIA WANJERI WANGUHU","","Updated loan with id:166","2022-03-14 14:41:43","2022-03-14 14:41:43","1");
INSERT INTO audit_trail VALUES("6811","6","Gilbert Githitu","","Disbursed loan with id:169","2022-03-14 14:41:59","2022-03-14 14:41:59","1");
INSERT INTO audit_trail VALUES("6812","2","CECILIA WANJERI WANGUHU","","Approved loan with id:166","2022-03-14 14:42:29","2022-03-14 14:42:29","1");
INSERT INTO audit_trail VALUES("6813","2","CECILIA WANJERI WANGUHU","","Disbursed loan with id:166","2022-03-14 14:42:38","2022-03-14 14:42:38","1");
INSERT INTO audit_trail VALUES("6814","6","Gilbert Githitu","","Undisbursed loan with id:165","2022-03-14 14:48:01","2022-03-14 14:48:01","1");
INSERT INTO audit_trail VALUES("6815","6","Gilbert Githitu","","Unapproved loan with id:165","2022-03-14 14:48:20","2022-03-14 14:48:20","1");
INSERT INTO audit_trail VALUES("6816","6","Gilbert Githitu","","Updated loan with id:165","2022-03-14 14:49:05","2022-03-14 14:49:05","1");
INSERT INTO audit_trail VALUES("6817","6","Gilbert Githitu","","Approved loan with id:165","2022-03-14 14:50:11","2022-03-14 14:50:11","1");
INSERT INTO audit_trail VALUES("6818","6","Gilbert Githitu","","Disbursed loan with id:165","2022-03-14 14:50:31","2022-03-14 14:50:31","1");
INSERT INTO audit_trail VALUES("6819","6","Gilbert Githitu","","Added expense with id:583","2022-03-14 15:38:04","2022-03-14 15:38:04","1");
INSERT INTO audit_trail VALUES("6820","2","CECILIA WANJERI WANGUHU","","Added expense with id:584","2022-03-14 15:40:19","2022-03-14 15:40:19","1");
INSERT INTO audit_trail VALUES("6821","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-14 16:10:06","2022-03-14 16:10:06","1");
INSERT INTO audit_trail VALUES("6822","6","Gilbert Githitu","","Added Capital  with id:1101","2022-03-15 03:45:21","2022-03-15 03:45:21","1");
INSERT INTO audit_trail VALUES("6823","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-15 05:35:09","2022-03-15 05:35:09","");
INSERT INTO audit_trail VALUES("6824","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-15 06:28:07","2022-03-15 06:28:07","");
INSERT INTO audit_trail VALUES("6825","6","Gilbert Githitu","","Added expense with id:585","2022-03-15 12:40:06","2022-03-15 12:40:06","1");
INSERT INTO audit_trail VALUES("6826","6","Gilbert Githitu","","Updated expense with id:585","2022-03-15 12:42:14","2022-03-15 12:42:14","1");
INSERT INTO audit_trail VALUES("6827","6","Gilbert Githitu","","Updated expense with id:585","2022-03-15 12:44:09","2022-03-15 12:44:09","1");
INSERT INTO audit_trail VALUES("6828","6","Gilbert Githitu","","Updated expense with id:585","2022-03-15 12:46:27","2022-03-15 12:46:27","1");
INSERT INTO audit_trail VALUES("6829","6","Gilbert Githitu","","Added Capital  with id:1102","2022-03-16 03:35:05","2022-03-16 03:35:05","1");
INSERT INTO audit_trail VALUES("6830","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-16 04:34:33","2022-03-16 04:34:33","");
INSERT INTO audit_trail VALUES("6831","6","Gilbert Githitu","","Logged in to system","2022-03-16 05:35:28","2022-03-16 05:35:28","");
INSERT INTO audit_trail VALUES("6832","2","CECILIA WANJERI WANGUHU","","Logged in to system","2022-03-16 07:28:18","2022-03-16 07:28:18","");
INSERT INTO audit_trail VALUES("6833","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1103","2022-03-16 07:29:15","2022-03-16 07:29:15","1");
INSERT INTO audit_trail VALUES("6834","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1104","2022-03-16 07:30:04","2022-03-16 07:30:04","1");
INSERT INTO audit_trail VALUES("6835","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1105","2022-03-16 07:30:45","2022-03-16 07:30:45","1");
INSERT INTO audit_trail VALUES("6836","2","CECILIA WANJERI WANGUHU","","Added Capital  with id:1106","2022-03-16 07:31:34","2022-03-16 07:31:34","1");
INSERT INTO audit_trail VALUES("6837","2","CECILIA WANJERI WANGUHU","","Logged out of system","2022-03-16 07:37:03","2022-03-16 07:37:03","1");
INSERT INTO audit_trail VALUES("6838","1","Admin Admin","","Logged in to system","2022-03-16 07:49:43","2022-03-16 07:49:43","");
INSERT INTO audit_trail VALUES("6839","6","Gilbert Githitu","","Undisbursed loan with id:164","2022-03-16 08:03:51","2022-03-16 08:03:51","1");
INSERT INTO audit_trail VALUES("6840","6","Gilbert Githitu","","Unapproved loan with id:164","2022-03-16 08:04:08","2022-03-16 08:04:08","1");
INSERT INTO audit_trail VALUES("6841","6","Gilbert Githitu","","Updated loan with id:164","2022-03-16 08:04:49","2022-03-16 08:04:49","1");
INSERT INTO audit_trail VALUES("6842","6","Gilbert Githitu","","Approved loan with id:164","2022-03-16 08:05:50","2022-03-16 08:05:50","1");
INSERT INTO audit_trail VALUES("6843","6","Gilbert Githitu","","Disbursed loan with id:164","2022-03-16 08:06:09","2022-03-16 08:06:09","1");
INSERT INTO audit_trail VALUES("6844","6","Gilbert Githitu","","Undisbursed loan with id:163","2022-03-16 08:07:10","2022-03-16 08:07:10","1");
INSERT INTO audit_trail VALUES("6845","6","Gilbert Githitu","","Unapproved loan with id:163","2022-03-16 08:07:28","2022-03-16 08:07:28","1");
INSERT INTO audit_trail VALUES("6846","6","Gilbert Githitu","","Updated loan with id:163","2022-03-16 08:08:21","2022-03-16 08:08:21","1");
INSERT INTO audit_trail VALUES("6847","6","Gilbert Githitu","","Undisbursed loan with id:159","2022-03-16 08:08:37","2022-03-16 08:08:37","1");
INSERT INTO audit_trail VALUES("6848","6","Gilbert Githitu","","Unapproved loan with id:159","2022-03-16 08:09:07","2022-03-16 08:09:07","1");
INSERT INTO audit_trail VALUES("6849","6","Gilbert Githitu","","Approved loan with id:163","2022-03-16 08:09:27","2022-03-16 08:09:27","1");
INSERT INTO audit_trail VALUES("6850","6","Gilbert Githitu","","Disbursed loan with id:163","2022-03-16 08:09:46","2022-03-16 08:09:46","1");
INSERT INTO audit_trail VALUES("6851","6","Gilbert Githitu","","Updated loan with id:159","2022-03-16 08:10:04","2022-03-16 08:10:04","1");
INSERT INTO audit_trail VALUES("6852","6","Gilbert Githitu","","Approved loan with id:159","2022-03-16 08:11:06","2022-03-16 08:11:06","1");
INSERT INTO audit_trail VALUES("6853","6","Gilbert Githitu","","Disbursed loan with id:159","2022-03-16 08:11:23","2022-03-16 08:11:23","1");
INSERT INTO audit_trail VALUES("6854","6","Gilbert Githitu","","Undisbursed loan with id:158","2022-03-16 08:14:41","2022-03-16 08:14:41","1");
INSERT INTO audit_trail VALUES("6855","6","Gilbert Githitu","","Unapproved loan with id:158","2022-03-16 08:14:51","2022-03-16 08:14:51","1");
INSERT INTO audit_trail VALUES("6856","6","Gilbert Githitu","","Undisbursed loan with id:157","2022-03-16 08:14:55","2022-03-16 08:14:55","1");
INSERT 