
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.asset',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.asset',2)); ?></h6>

            <div class="heading-elements">
                <?php if(Sentinel::hasAccess('assets.create')): ?>
                    <a href="<?php echo e(url('asset/create')); ?>"
                       class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.asset',1)); ?></a>
                <?php endif; ?>
            </div>
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <table id="data-table" class="table table-striped table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans_choice('general.type',1)); ?></th>
                        <th><?php echo e(trans_choice('general.current',1)); ?> <?php echo e(trans_choice('general.value',1)); ?></th>
                        <th><?php echo e(trans_choice('general.category',1)); ?></th>
                        <th><?php echo e(trans_choice('general.purchase',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></th>
                        <th><?php echo e(trans_choice('general.description',1)); ?></th>
                        <th><?php echo e(trans_choice('general.serial_number',1)); ?></th>
                        <th><?php echo e(trans_choice('general.file',2)); ?></th>
                        <th><?php echo e(trans_choice('general.action',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php if(!empty($key->asset_type)): ?>
                                    <?php echo e($key->asset_type->name); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php $__currentLoopData = $key->valuations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $valuation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <b><?php echo e($valuation->date); ?>:</b> <?php echo e($valuation->amount); ?><br>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <?php if(!empty($key->asset_type)): ?>
                                    <?php if($key->asset_type->type=="current"): ?>
                                        <?php echo e(trans_choice('general.current',1)); ?> <?php echo e(trans_choice('general.asset',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->asset_type->type=="fixed"): ?>
                                        <?php echo e(trans_choice('general.fixed',1)); ?> <?php echo e(trans_choice('general.asset',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->asset_type->type=="intangible"): ?>
                                        <?php echo e(trans_choice('general.intangible',1)); ?> <?php echo e(trans_choice('general.asset',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->asset_type->type=="investment"): ?>
                                        <?php echo e(trans_choice('general.investment',1)); ?> <?php echo e(trans_choice('general.asset',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->asset_type->type=="other"): ?>
                                        <?php echo e(trans_choice('general.other',1)); ?> <?php echo e(trans_choice('general.asset',1)); ?>

                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->purchase_date); ?></td>
                            <td><?php echo e($key->notes); ?></td>
                            <td><?php echo e($key->serial_number); ?></td>
                            <td>
                                <ul class="">
                                    <?php $__currentLoopData = unserialize($key->files); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo asset('uploads/'.$value); ?>"
                                               target="_blank"><?php echo $value; ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </td>
                            <td>
                                <ul class="icons-list">
                                    <li class="dropdown">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                            <i class="icon-menu9"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <?php if(Sentinel::hasAccess('assets.update')): ?>
                                                <li><a href="<?php echo e(url('asset/'.$key->id.'/edit')); ?>"><i
                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?> </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('assets.delete')): ?>
                                                <li><a href="<?php echo e(url('asset/'.$key->id.'/delete')); ?>"
                                                       class="delete"><i
                                                                class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

    <script>

        $('#data-table').DataTable({
            "order": [[2, "desc"]],
            "columnDefs": [
                {"orderable": false, "targets": [7]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>