<style>
    table {
        width: 100%;
        border-collapse: collapse;
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
    }
    th, td {
        padding: 10px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }
    th {
        background-color: #4CAF50;
        color: white;
    }
</style>
<div>

    <?php if(!empty($start_date)): ?>
        <table class="">
            <caption>
                <?php echo e(trans_choice('general.income',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?>

                <?php if(!empty($start_date)): ?>
                    for period: <?php echo e($start_date); ?> to <?php echo e($end_date); ?>

                <?php endif; ?>
            </caption>
            <thead>
            <tr class="">
                <th><?php echo e(trans_choice('general.gl_code',1)); ?></th>
                <th><?php echo e(trans_choice('general.account',1)); ?></th>
                <th><?php echo e(trans_choice('general.balance',1)); ?></th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td colspan="3" style="text-align: center"><b><?php echo e(trans_choice('general.income',1)); ?></b></td>
            </tr>
            <?php
            $total_income = 0;
            $total_expenses = 0;
            ?>
            <?php $__currentLoopData = \App\Models\ChartOfAccount::where('account_type','income')->orderBy('gl_code','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $balance = 0;
                $cr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                    [$start_date, $end_date])->sum('credit');
                $dr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                    [$start_date, $end_date])->sum('debit');
                $balance =  $cr-$dr;
                $total_income = $total_income + $balance;
                ?>
                <tr>
                    <td><?php echo e($key->gl_code); ?></td>
                    <td>
                        <?php echo e($key->name); ?>

                    </td>
                    <td><?php echo e(number_format($balance,2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td colspan="2" style="text-align: right">
                    <b><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.income',1)); ?></b></td>
                <td><b><?php echo e(number_format($total_income,2)); ?></b></td>
            </tr>
            <tr>
                <td colspan="3" style="text-align: center"><b><?php echo e(trans_choice('general.expense',2)); ?></b></td>
            </tr>
            <?php $__currentLoopData = \App\Models\ChartOfAccount::where('account_type','expense')->orderBy('gl_code','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $balance = 0;
                $cr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                    [$start_date, $end_date])->sum('credit');
                $dr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                    [$start_date, $end_date])->sum('debit');
                $balance =  $dr-$cr;
                $total_expenses = $total_expenses + $balance;
                ?>
                <tr>
                    <td><?php echo e($key->gl_code); ?></td>
                    <td>
                        <?php echo e($key->name); ?>

                    </td>
                    <td><?php echo e(number_format($balance,2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td colspan="2" style="text-align: right">
                    <b><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.expense',2)); ?></b></td>
                <td><b><?php echo e(number_format($total_expenses,2)); ?></b></td>
            </tr>
            </tbody>
            <tfoot>
            <tr>
                <td colspan="2" style="text-align: right">
                    <b><?php echo e(trans_choice('general.net',1)); ?> <?php echo e(trans_choice('general.income',1)); ?></b></td>
                <td><b><?php echo e(number_format($total_income-$total_expenses,2)); ?></b></td>
            </tr>
            </tfoot>
        </table>
    <?php endif; ?>
</div>