
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.income',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title">
                <?php echo e(trans_choice('general.income',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?>

                <?php if(!empty($start_date)): ?>
                    for period: <b><?php echo e($start_date); ?> to <?php echo e($end_date); ?></b>
                <?php endif; ?>
            </h6>

            <div class="heading-elements">

            </div>
        </div>
        <div class="panel-body hidden-print">
            <h4 class=""><?php echo e(trans_choice('general.date',1)); ?> <?php echo e(trans_choice('general.range',1)); ?></h4>
            <?php echo Form::open(array('url' => Request::url(), 'method' => 'post','class'=>'form-horizontal', 'name' => 'form')); ?>

            <div class="row">
                <div class="col-xs-5">
                    <?php echo Form::text('start_date',$start_date, array('class' => 'form-control date-picker', 'placeholder'=>"From Date",'required'=>'required')); ?>

                </div>
                <div class="col-xs-1  text-center" style="padding-top: 5px;">
                    to
                </div>
                <div class="col-xs-5">
                    <?php echo Form::text('end_date',$end_date, array('class' => 'form-control date-picker', 'placeholder'=>"To Date",'required'=>'required')); ?>

                </div>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-xs-12">

                        <button type="submit" class="btn btn-success"><?php echo e(trans_choice('general.search',1)); ?>!
                        </button>


                        <a href="<?php echo e(Request::url()); ?>"
                           class="btn btn-danger"><?php echo e(trans_choice('general.reset',1)); ?>!</a>

                        <div class="btn-group">
                            <button type="button" class="btn bg-blue dropdown-toggle legitRipple"
                                    data-toggle="dropdown"><?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.report',1)); ?>

                                <span class="caret"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a href="<?php echo e(url('report/financial_report/income_statement/pdf?start_date='.$start_date.'&end_date='.$end_date)); ?>"
                                       target="_blank"><i
                                                class="icon-file-pdf"></i> <?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.to',1)); ?> <?php echo e(trans_choice('general.pdf',1)); ?>

                                    </a></li>
                                <li>
                                    <a href="<?php echo e(url('report/financial_report/income_statement/excel?start_date='.$start_date.'&end_date='.$end_date)); ?>"
                                       target="_blank"><i
                                                class="icon-file-excel"></i> <?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.to',1)); ?> <?php echo e(trans_choice('general.excel',1)); ?>

                                    </a></li>
                                <li>
                                    <a href="<?php echo e(url('report/financial_report/income_statement/csv?start_date='.$start_date.'&end_date='.$end_date)); ?>"
                                       target="_blank"><i
                                                class="icon-download"></i> <?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.to',1)); ?> <?php echo e(trans_choice('general.csv',1)); ?>

                                    </a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
            <?php echo Form::close(); ?>


        </div>
        <!-- /.panel-body -->

    </div>
    <!-- /.box -->
    <?php if(!empty($start_date)): ?>
        <div class="panel panel-white">
            <div class="panel-body table-responsive no-padding">

                <table class="table table-bordered table-condensed table-hover">
                    <thead>
                    <tr class="bg-green">
                        <th><?php echo e(trans_choice('general.gl_code',1)); ?></th>
                        <th><?php echo e(trans_choice('general.account',1)); ?></th>
                        <th><?php echo e(trans_choice('general.balance',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td colspan="3" style="text-align: center"><b><?php echo e(trans_choice('general.income',1)); ?></b></td>
                    </tr>
                    <?php
                    $total_income = 0;
                    $total_expenses = 0;
                    ?>
                    <?php $__currentLoopData = \App\Models\ChartOfAccount::where('account_type','income')->orderBy('gl_code','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $balance = 0;
                        $cr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                            [$start_date, $end_date])->sum('credit');
                        $dr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                            [$start_date, $end_date])->sum('debit');
                        $balance =  $cr-$dr;
                        $total_income = $total_income + $balance;
                        ?>
                        <tr>
                            <td><?php echo e($key->gl_code); ?></td>
                            <td>
                                <?php echo e($key->name); ?>

                            </td>
                            <td><?php echo e(number_format($balance,2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="2" style="text-align: right">
                            <b><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.income',1)); ?></b></td>
                        <td><b><?php echo e(number_format($total_income,2)); ?></b></td>
                    </tr>
                    <tr>
                        <td colspan="3" style="text-align: center"><b><?php echo e(trans_choice('general.expense',2)); ?></b></td>
                    </tr>
                    <?php $__currentLoopData = \App\Models\ChartOfAccount::where('account_type','expense')->orderBy('gl_code','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $balance = 0;
                        $cr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                            [$start_date, $end_date])->sum('credit');
                        $dr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                            [$start_date, $end_date])->sum('debit');
                        $balance =  $dr-$cr;
                        $total_expenses = $total_expenses + $balance;
                        ?>
                        <tr>
                            <td><?php echo e($key->gl_code); ?></td>
                            <td>
                                <?php echo e($key->name); ?>

                            </td>
                            <td><?php echo e(number_format($balance,2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="2" style="text-align: right">
                            <b><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.expense',2)); ?></b></td>
                        <td><b><?php echo e(number_format($total_expenses,2)); ?></b></td>
                    </tr>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="2" style="text-align: right">
                            <b><?php echo e(trans_choice('general.net',1)); ?> <?php echo e(trans_choice('general.income',1)); ?></b></td>
                        <td><b><?php echo e(number_format($total_income-$total_expenses,2)); ?></b></td>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>