<style>
    table {
        width: 100%;
        border-collapse: collapse;
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
    }
    th, td {
        padding: 10px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }
    th {
        background-color: #4CAF50;
        color: white;
    }
</style>
<div>

    <?php if(!empty($start_date)): ?>
        <table class="">
            <caption>
                <?php echo e(trans_choice('general.trial_balance',1)); ?>

                <?php if(!empty($start_date)): ?>
                    for period: <?php echo e($start_date); ?> to <?php echo e($end_date); ?>

                <?php endif; ?>
            </caption>
            <thead>
            <tr class="">
                <th><?php echo e(trans_choice('general.gl_code',1)); ?></th>
                <th><?php echo e(trans_choice('general.account',1)); ?></th>
                <th><?php echo e(trans_choice('general.debit',1)); ?></th>
                <th><?php echo e(trans_choice('general.credit',1)); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php
            $credit_total = 0;
            $debit_total = 0;
            ?>
            <?php $__currentLoopData = \App\Models\ChartOfAccount::orderBy('gl_code','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $cr = 0;
                $dr = 0;
                $cr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                    [$start_date, $end_date])->where('branch_id',
                    session('branch_id'))->sum('credit');
                $dr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                    [$start_date, $end_date])->where('branch_id',
                    session('branch_id'))->sum('debit');
                $credit_total = $credit_total + $cr;
                $debit_total = $debit_total + $dr;
                ?>
                <tr>
                    <td><?php echo e($key->gl_code); ?></td>
                    <td>
                        <?php echo e($key->name); ?>

                    </td>
                    <td><?php echo e(number_format($dr,2)); ?></td>
                    <td><?php echo e(number_format($cr,2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
            <tr>
                <th colspan="2"><b><?php echo e(trans_choice('general.total',1)); ?></b></th>
                <th><?php echo e(number_format($debit_total,2)); ?></th>
                <th><?php echo e(number_format($credit_total,2)); ?></th>
            </tr>
            </tfoot>
        </table>
    <?php endif; ?>
</div>