
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.product',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.product',2)); ?></h6>

            <div class="heading-elements">
                <?php if(Sentinel::hasAccess('savings.products')): ?>
                    <a href="<?php echo e(url('saving/savings_product/create')); ?>"
                       class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.product',1)); ?></a>
                <?php endif; ?>
            </div>
        </div>
        <div class="panel-body ">
            <div class="table-responsive">
                <table id="data-table" class="table table-striped table-condensed table-hover">
                    <thead>
                    <tr >
                        <th><?php echo e(trans_choice('general.product',1)); ?></th>
                        <th><?php echo e(trans_choice('general.interest_rate_per_annum',1)); ?></th>
                        <th><?php echo e(trans_choice('general.interest_posting_frequency',1)); ?></th>
                        <th><?php echo e(trans_choice('general.minimum',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></th>
                        <th><?php echo e(trans_choice('general.action',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key->name); ?></td>
                            <td><?php echo e($key->interest_rate); ?></td>
                            <td>
                                <?php if($key->interest_posting==1): ?>
                                    <?php echo e(trans_choice('general.every_1_month',1)); ?>

                                <?php endif; ?>
                                <?php if($key->interest_posting==2): ?>
                                    <?php echo e(trans_choice('general.every_2_month',1)); ?>

                                <?php endif; ?>
                                <?php if($key->interest_posting==3): ?>
                                    <?php echo e(trans_choice('general.every_3_month',1)); ?>

                                <?php endif; ?>
                                <?php if($key->interest_posting==4): ?>
                                    <?php echo e(trans_choice('general.every_4_month',1)); ?>

                                <?php endif; ?>
                                <?php if($key->interest_posting==5): ?>
                                    <?php echo e(trans_choice('general.every_6_month',1)); ?>

                                <?php endif; ?>
                                <?php if($key->interest_posting==6): ?>
                                    <?php echo e(trans_choice('general.every_12_month',1)); ?>


                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->minimum_balance); ?></td>
                            <td>
                                <ul class="icons-list">
                                    <li class="dropdown">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                            <i class="icon-menu9"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <?php if(Sentinel::hasAccess('savings.products')): ?>
                                                <li><a href="<?php echo e(url('saving/savings_product/'.$key->id.'/edit')); ?>"><i
                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?> </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('savings.products')): ?>
                                                <li><a href="<?php echo e(url('saving/savings_product/'.$key->id.'/delete')); ?>"
                                                       class="delete"><i
                                                                class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

    <script>

        $('#data-table').DataTable({
            dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
            autoWidth: false,
            columnDefs: [{
                orderable: false,
                width: '100px',
                targets: [4]
            }],
            "order": [[0, "desc"]],
            language: {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>:",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>