
<?php $__env->startSection('title'); ?><?php echo e(trans_choice('general.repayment',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.repayment',2)); ?></h6>

            <div class="heading-elements">

            </div>
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <table id="repayments-data-table"
                       class="table  table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>
                            <?php echo e(trans_choice('general.loan',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.collection',1)); ?> <?php echo e(trans_choice('general.date',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.collected_by',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.method',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.receipt',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.amount',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.action',1)); ?>

                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><a href="<?php echo e(url('loan/'.$key->loan_id.'/show')); ?>"> <?php echo e($key->loan_id); ?></a></td>
                            <td><?php echo e($key->date); ?></td>
                            <td>
                                <?php if(!empty($key->user)): ?>
                                    <?php echo e($key->user->first_name); ?> <?php echo e($key->user->last_name); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if(!empty($key->loan_repayment_method)): ?>
                                    <?php echo e($key->loan_repayment_method->name); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->receipt); ?></td>
                            <td>
                                <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                                    <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?> <?php echo e(number_format($key->credit,2)); ?>

                                <?php else: ?>
                                    <?php echo e(number_format($key->credit,2)); ?>  <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?>

                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <ul class="icons-list">
                                    <li class="dropdown">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                            <i class="icon-menu9"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <li>
                                                <a href="<?php echo e(url('loan/transaction/'.$key->id.'/show')); ?>"><i
                                                            class="fa fa-search"></i> <?php echo e(trans_choice('general.view',1)); ?>

                                                </a></li>
                                            <li>

                                            <?php if($key->transaction_type=='repayment' && $key->reversible==1): ?>
                                                <li>
                                                    <a href="<?php echo e(url('loan/transaction/'.$key->id.'/print')); ?>"
                                                       target="_blank"><i
                                                                class="icon-printer"></i> <?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.receipt',1)); ?>

                                                    </a></li>
                                                <li>
                                                    <a href="<?php echo e(url('loan/transaction/'.$key->id.'/pdf')); ?>"
                                                       target="_blank"><i
                                                                class="icon-file-pdf"></i> <?php echo e(trans_choice('general.pdf',1)); ?> <?php echo e(trans_choice('general.receipt',1)); ?>

                                                    </a></li>
                                                <li>
                                                    <a href="<?php echo e(url('loan/repayment/'.$key->id.'/edit')); ?>"><i
                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?>

                                                    </a></li>
                                                <li>
                                                    <a href="<?php echo e(url('loan/repayment/'.$key->id.'/reverse')); ?>"
                                                       class="delete"><i
                                                                class="fa fa-minus-circle"></i> <?php echo e(trans('general.reverse')); ?>

                                                    </a></li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $(document).ready(function () {
            $('.deletePayment').on('click', function (e) {
                e.preventDefault();
                var href = $(this).attr('href');
                swal({
                    title: '<?php echo e(trans_choice('general.are_you_sure',1)); ?>',
                    text: '<?php echo e(trans_choice('general.delete_payment_msg',1)); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '<?php echo e(trans_choice('general.ok',1)); ?>',
                    cancelButtonText: '<?php echo e(trans_choice('general.cancel',1)); ?>'
                }).then(function () {
                    window.location = href;
                })
            });
        });
    </script>

    <script>

        $('#repayments-data-table').DataTable({
            dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
            autoWidth: false,
            columnDefs: [{
                orderable: false,
                width: '100px',
                targets: [6]
            }],
            "order": [[1, "desc"]],
            language: {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>:",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>