
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.guarantor',1)); ?> <?php echo e(trans_choice('general.detail',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-widget">
        <div class="panel-heading">
            <div class="row">
                <div class="col-sm-3">
                    <div class="user-block">
                        <?php if(!empty($guarantor->photo)): ?>
                            <a href="<?php echo e(asset('uploads/'.$guarantor->photo)); ?>" class="fancybox"> <img class="img-circle"
                                                                                                     src="<?php echo e(asset('uploads/'.$guarantor->photo)); ?>"
                                                                                                     alt="user image"/></a>
                        <?php else: ?>
                            <img class="img-circle"
                                 src="<?php echo e(asset('assets/dist/img/user.png')); ?>"
                                 alt="user image"/>
                        <?php endif; ?>
                        <span class="username">
                                <?php echo e($guarantor->title); ?>

                            . <?php echo e($guarantor->first_name); ?> <?php echo e($guarantor->last_name); ?>

                            </span>
                        <span class="description" style="font-size:13px; color:#000000"><?php echo e($guarantor->unique_number); ?>

                            <br>
                                <a href="<?php echo e(url('borrower/'.$guarantor->id.'/edit')); ?>"><?php echo e(trans_choice('general.edit',1)); ?></a><br>
                            <?php echo e($guarantor->business_name); ?>, <?php echo e($guarantor->working_status); ?>

                            <br><?php echo e($guarantor->gender); ?>

                            , <?php echo e(date("Y-m-d")-$guarantor->dob); ?> <?php echo e(trans_choice('general.year',2)); ?>

                            </span>
                        <a data-toggle="collapse" data-parent="#accordion" href="#viewFiles">
                            <?php echo e(trans_choice('general.view',1)); ?> <?php echo e(trans_choice('general.guarantor',1)); ?> <?php echo e(trans_choice('general.file',2)); ?>

                        </a>

                        <div id="viewFiles" class="panel-collapse collapse">
                            <div class="panel-body">
                                <ul class="no-margin" style="font-size:12px; padding-left:10px">

                                    <?php $__currentLoopData = unserialize($guarantor->files); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo asset('uploads/'.$value); ?>"
                                               target="_blank"><?php echo $value; ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- /.user-block -->
                </div>
                <!-- /.col -->
                <div class="col-sm-3">
                    <ul class="list-unstyled">
                        <li><b><?php echo e(trans_choice('general.address',1)); ?>:</b> <?php echo e($guarantor->address); ?></li>
                        <li><b><?php echo e(trans_choice('general.city',2)); ?>:</b> <?php echo e($guarantor->city); ?></li>
                        <li><b><?php echo e(trans_choice('general.state',2)); ?>:</b> <?php echo e($guarantor->state); ?></li>
                        <li><b><?php echo e(trans_choice('general.zip',2)); ?>:</b> <?php echo e($guarantor->zip); ?></li>
                        <li>
                            <b><?php echo e(trans_choice('general.country',1)); ?>:</b>
                            <?php if($guarantor->country): ?>
                                <?php echo e($guarantor->country->name); ?>

                            <?php endif; ?>
                        </li>
                        <li><b><?php echo e(trans_choice('general.blacklisted',1)); ?>:</b>
                            <?php if($guarantor->blacklisted==1): ?>
                                <span class="label label-danger"><?php echo e(trans_choice('general.yes',1)); ?></span>
                            <?php else: ?>
                                <span class="label label-success"><?php echo e(trans_choice('general.no',1)); ?></span>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
                <div class="col-sm-3">
                    <ul class="list-unstyled">
                        <li><b><?php echo e(trans_choice('general.phone',1)); ?>:</b> <?php echo e($guarantor->phone); ?></li>
                        <li><b><?php echo e(trans_choice('general.email',1)); ?>:</b> <a
                                    onclick="javascript:window.open('mailto:<?php echo e($guarantor->email); ?>', 'mail');event.preventDefault()"
                                    href="mailto:<?php echo e($guarantor->email); ?>"><?php echo e($guarantor->email); ?></a>

                            <div class="btn-group-horizontal hidden"><a type="button" class="btn-xs bg-red"
                                                                        href="<?php echo e(url('communication/email/create?borrower_id='.$guarantor->id)); ?>"><?php echo e(trans_choice('general.send',1)); ?>

                                    <?php echo e(trans_choice('general.email',1)); ?></a></div>
                        </li>
                        <li><b><?php echo e(trans_choice('general.mobile',1)); ?>:</b> <?php echo e($guarantor->mobile); ?>

                            <div class="btn-group-horizontal hidden"><a type="button" class="btn-xs bg-red"
                                                                        href="<?php echo e(url('communication/sms/create?borrower_id='.$guarantor->id)); ?>"><?php echo e(trans_choice('general.send',1)); ?>

                                    <?php echo e(trans_choice('general.sms',1)); ?></a></div>
                        </li>

                    </ul>
                </div>
                <div class="col-sm-3">
                    <ul class="list-unstyled">
                        <li><b><?php echo e(trans_choice('general.custom_field',2)); ?></b></li>
                        <?php $__currentLoopData = $custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <?php if(!empty($key->custom_field)): ?>
                                    <strong><?php echo e($key->custom_field->name); ?>:</strong>
                                <?php endif; ?>
                                <?php echo e($key->name); ?>

                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="box box-info">
        <div class="panel-heading">
            <h3 class="panel-title"><?php echo e(trans_choice('general.loan',2)); ?></h3>

            <div class="heading-elements">

            </div>
        </div>
        <div class="panel-body table-responsive ">
            <table id="data-table" class="table table-bordered table-condensed table-hover">
                <thead>
                <tr style="background-color: #D1F9FF">
                    <th>#</th>
                    <th><?php echo e(trans_choice('general.principal',1)); ?></th>
                    <th><?php echo e(trans_choice('general.released',1)); ?></th>
                    <th><?php echo e(trans_choice('general.interest',1)); ?>%</th>
                    <th><?php echo e(trans_choice('general.due',1)); ?></th>
                    <th><?php echo e(trans_choice('general.paid',1)); ?></th>
                    <th><?php echo e(trans_choice('general.balance',1)); ?></th>
                    <th><?php echo e(trans_choice('general.status',1)); ?></th>
                    <th><?php echo e(trans_choice('general.action',1)); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $guarantor->loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!empty($key->loan)): ?>
                        <tr>

                            <td><?php echo e($key->loan->id); ?></td>
                            <td><?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_principal($key->loan->id),2)); ?></td>
                            <td><?php echo e($key->loan->release_date); ?></td>
                            <td>
                                <?php echo e(round($key->loan->interest_rate,2)); ?>%/<?php echo e($key->loan->interest_period); ?>

                            </td>
                            <td><?php echo e(round(\App\Helpers\GeneralHelper::loan_total_due_amount($key->loan->id),2)); ?></td>
                            <td><?php echo e(round(\App\Helpers\GeneralHelper::loan_total_paid($key->loan->id),2)); ?></td>
                            <td><?php echo e(round(\App\Helpers\GeneralHelper::loan_total_balance($key->loan->id),2)); ?></td>
                            <td>
                                <?php if($key->loan->maturity_date<date("Y-m-d") && \App\Helpers\GeneralHelper::loan_total_balance($key->loan->id)>0): ?>
                                    <span class="label label-danger"><?php echo e(trans_choice('general.past_maturity',1)); ?></span>
                                <?php else: ?>
                                    <?php if($key->loan->status=='pending'): ?>
                                        <span class="label label-warning"><?php echo e(trans_choice('general.pending',1)); ?> <?php echo e(trans_choice('general.approval',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='approved'): ?>
                                        <span class="label label-info"><?php echo e(trans_choice('general.awaiting',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='disbursed'): ?>
                                        <span class="label label-info"><?php echo e(trans_choice('general.active',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='declined'): ?>
                                        <span class="label label-danger"><?php echo e(trans_choice('general.declined',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='withdrawn'): ?>
                                        <span class="label label-danger"><?php echo e(trans_choice('general.withdrawn',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='written_off'): ?>
                                        <span class="label label-danger"><?php echo e(trans_choice('general.written_off',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='closed'): ?>
                                        <span class="label label-success"><?php echo e(trans_choice('general.closed',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='pending_reschedule'): ?>
                                        <span class="label label-warning"><?php echo e(trans_choice('general.pending',1)); ?> <?php echo e(trans_choice('general.reschedule',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($key->loan->status=='rescheduled'): ?>
                                        <span class="label label-info"><?php echo e(trans_choice('general.rescheduled',1)); ?></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-info btn-flat dropdown-toggle"
                                            data-toggle="dropdown" aria-expanded="false">
                                        <?php echo e(trans('general.choose')); ?> <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="<?php echo e(url('loan/'.$key->loan->id.'/show')); ?>"><i
                                                        class="fa fa-search"></i> <?php echo e(trans_choice('general.detail',2)); ?>

                                            </a></li>
                                        <li><a href="<?php echo e(url('loan/'.$key->loan->id.'/edit')); ?>"><i
                                                        class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?> </a></li>
                                        <li><a href="<?php echo e(url('loan/'.$key->loan->id.'/delete')); ?>"
                                               data-toggle="confirmation"><i
                                                        class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?> </a></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatable/media/js/jquery.dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/media/js/dataTables.bootstrap.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/extensions/Buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/extensions/Buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/extensions/Buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/extensions/Responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/extensions/Buttons/js/buttons.colVis.min.js')); ?>"></script>
    <script>
        $('#data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[2, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": [0, 8]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
        $('#view-repayments').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": [4, 5]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
    <script>
        $(document).ready(function () {
            $('.deletePayment').on('click', function (e) {
                e.preventDefault();
                var href = $(this).attr('href');
                swal({
                    title: '<?php echo e(trans_choice('general.are_you_sure',1)); ?>',
                    text: 'If you delete a payment, a fully paid loan may change status to open.',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '<?php echo e(trans_choice('general.ok',1)); ?>',
                    cancelButtonText: '<?php echo e(trans_choice('general.cancel',1)); ?>'
                }).then(function () {
                    window.location = href;
                })
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>